/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/commons/DropdownBox','sap/ui/commons/MenuButton','sap/ui/commons/SearchField','sap/ui/commons/ToggleButton','sap/ui/core/Control','./Feeder','./library'],function(q,D,M,S,T,C,F,l){"use strict";var a=C.extend("sap.ui.ux3.Feed",{metadata:{library:"sap.ui.ux3",properties:{feederThumbnailSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},feederSender:{type:"string",group:"Data",defaultValue:null},live:{type:"boolean",group:"Behavior",defaultValue:true},title:{type:"string",group:"Data",defaultValue:null}},aggregations:{filterItems:{type:"sap.ui.core.ListItem",multiple:true,singularName:"filterItem",bindable:"bindable"},chunks:{type:"sap.ui.ux3.FeedChunk",multiple:true,singularName:"chunk",bindable:"bindable"},toolsMenuItems:{type:"sap.ui.commons.MenuItem",multiple:true,singularName:"toolsMenuItem",bindable:"bindable"}},events:{filterChange:{parameters:{newValue:{type:"string"}}},search:{parameters:{query:{type:"string"}}},chunkAdded:{parameters:{chunk:{type:"sap.ui.ux3.FeedChunk"}}},toolsItemSelected:{parameters:{itemId:{type:"string"},item:{type:"sap.ui.unified.MenuItemBase"}}},toggleLive:{parameters:{live:{type:"boolean"}}}}}});a.prototype.init=function(){this.rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this.data("sap-ui-fastnavgroup","true",true);this.oFeeder=new F(this.getId()+'-Feeder',{type:sap.ui.ux3.FeederType.Medium}).setParent(this);this.oFeeder.attachEvent('submit',this.handleFeederSubmit,this);this.oLiveButton=new T(this.getId()+'-liveButton',{text:this.rb.getText('FEED_LIVE'),pressed:this.getLive(),lite:true}).setParent(this);this.oLiveButton.attachEvent('press',this.handleLiveButtonPress,this);this.oFilter=new D(this.getId()+'-filter').setParent(this);this.oFilter.attachEvent('change',this.handleFilterChange,this);this.oSearchField=new S(this.getId()+'-search',{enableListSuggest:false}).setParent(this);this.oSearchField.attachEvent('search',this.handleSearchFieldSearch,this);};a.prototype.initToolsButton=function(){if(!this.oToolsButton){this.oToolsButton=new M(this.getId()+'-toolsButton',{tooltip:this.rb.getText('FEED_TOOLS'),lite:true,menu:new sap.ui.commons.Menu(this.getId()+'-toolsMenu')}).setParent(this);this.oToolsButton.attachEvent('itemSelected',this.handleLtoolsButtonSelected,this);var i=sap.ui.core.theming.Parameters.get('sap.ui.ux3.Feed:sapUiFeedToolsIconUrl');var I=sap.ui.core.theming.Parameters.get('sap.ui.ux3.Feed:sapUiFeedToolsIconHoverUrl');var t="sap.ui.ux3.themes."+sap.ui.getCore().getConfiguration().getTheme();if(i){this.oToolsButton.setProperty('icon',q.sap.getModulePath(t,i),true);}if(I){this.oToolsButton.setProperty('iconHovered',q.sap.getModulePath(t,I),true);}}};a.prototype.exit=function(){if(this.oFeeder){this.oFeeder.destroy();delete this.oFeeder;}if(this.oLiveButton){this.oLiveButton.destroy();delete this.oLiveButton;}if(this.oToolsButton){this.oToolsButton.destroy();delete this.oToolsButton;}if(this.oFilter){this.oFilter.destroy();delete this.oFilter;}if(this.oSearchField){this.oSearchField.destroy();delete this.oSearchField;}this.rb=undefined;};a.prototype.handleFeederSubmit=function(e){var d=new Date();var s=String(d);var n=new sap.ui.ux3.FeedChunk(this.getId()+'-new-'+this.getChunks().length,{text:e.getParameter('text'),commentChunk:false,deletionAllowed:true,timestamp:s,sender:this.getFeederSender(),thumbnailSrc:this.getFeederThumbnailSrc()});this.insertChunk(n,0);this.fireChunkAdded({chunk:n});};a.prototype.setLive=function(L){this.setProperty("live",L,true);if(this.oLiveButton){this.oLiveButton.setPressed(L);}return this;};a.prototype.handleLiveButtonPress=function(e){var p=e.getParameter("pressed");this.setProperty("live",p,true);this.fireToggleLive({live:p});};a.prototype.handleLtoolsButtonSelected=function(e){this.fireToolsItemSelected(e.mParameters);};a.prototype.handleFilterChange=function(e){this.fireFilterChange(e.mParameters);};a.prototype.handleSearchFieldSearch=function(e){this.fireSearch(e.mParameters);};a.prototype.setFeederThumbnailSrc=function(f){this.setProperty("feederThumbnailSrc",f,true);this.oFeeder.setThumbnailSrc(f);return this;};a.prototype.setLive=function(L){this.setProperty("live",L,true);this.oLiveButton.setPressed(L);return this;};a.prototype.getToolsMenuItems=function(){if(this.oToolsButton){return this.oToolsButton.getMenu().getItems();}};a.prototype.insertToolsMenuItem=function(t,i){this.initToolsButton();this.oToolsButton.getMenu().insertItem(t,i);return this;};a.prototype.addToolsMenuItem=function(t){this.initToolsButton();this.oToolsButton.getMenu().addItem(t);return this;};a.prototype.removeToolsMenuItem=function(t){if(this.oToolsButton){return this.oToolsButton.getMenu().removeItem(t);}};a.prototype.removeAllToolsMenuItems=function(){if(this.oToolsButton){return this.oToolsButton.getMenu().removeAllItems();}};a.prototype.indexOfToolsMenuItem=function(t){if(this.oToolsButton){return this.oToolsButton.getMenu().indexOfItem(t);}};a.prototype.destroyToolsMenuItems=function(){if(this.oToolsButton){this.oToolsButton.getMenu().destroyItems();}return this;};a.prototype.bindToolsMenuItems=function(p,t,s,f){this.initToolsButton();this.oToolsButton.getMenu().bindItems(p,t,s,f);return this;};a.prototype.unbindToolsMenuItems=function(){if(this.oToolsButton){this.oToolsButton.getMenu().unbindItems();}return this;};a.prototype.getFilterItems=function(){return this.oFilter.getItems();};a.prototype.insertFilterItem=function(f,i){this.oFilter.insertItem(f,i);return this;};a.prototype.addFilterItem=function(f){this.oFilter.addItem(f);return this;};a.prototype.removeFilterItem=function(f){return this.oFilter.removeItem(f);};a.prototype.removeAllFilterItems=function(){return this.oFilter.removeAllItems();};a.prototype.indexOfFilterItem=function(f){return this.oFilter.indexOfItem(f);};a.prototype.destroyFilterItems=function(){this.oFilter.destroyItems();return this;};a.prototype.bindFilterItems=function(p,t,s,f){this.oFilter.bindItems(p,t,s,f);return this;};a.prototype.unbindFilterItems=function(){this.oFilter.unbindItems();return this;};return a;},true);
