/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','./TimePickerSliderRenderer','sap/ui/core/IconPool'],function(q,C,T,I){"use strict";var a=C.extend("sap.m.TimePickerSlider",{metadata:{library:"sap.m",properties:{selectedValue:{type:"string",defaultValue:null},isCyclic:{type:"boolean",defaultValue:true},label:{type:"string",defaultValue:null},isExpanded:{type:"boolean",defaultValue:false}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item"},_arrowUp:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_arrowDown:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{expanded:{}}},renderer:T.render});a.MIN_ITEMS=50;a.prototype.init=function(){this._bIsDrag=null;this._selectionOffset=0;this._mousedown=false;this._dragSession=null;this._iSelectedItemIndex=-1;this._animatingSnap=false;this._iSelectedIndex=-1;this._contentRepeat=null;this._animating=false;this._intervalId=null;this._maxScrollTop=null;this._minScrollTop=null;this._marginTop=null;this._marginBottom=null;this._bOneTimeValueSelectionAnimation=false;this._initArrows();};a.prototype.onAfterRendering=function(){if(sap.ui.Device.system.phone){q.sap.delayedCall(0,this,this._afterExpandCollapse);}else{this._afterExpandCollapse();}this._attachEvents();};a.prototype.onThemeChanged=function(E){this.rerender();};a.prototype.fireTap=function(E){if(!this.getIsExpanded()){if(sap.ui.Device.system.desktop){this.focus();}else{this.setIsExpanded(true);}}else{var s=E.srcElement||E.originalTarget,i,h;if(s.tagName.toLowerCase()==="li"){i=q(s).text();h=F.call(this,i);this._bOneTimeValueSelectionAnimation=true;this.setSelectedValue(h);}else{this._addSelectionStyle();}}};a.prototype.setSelectedValue=function(v){var i=f(this.getItems(),function(E){return E.getKey()===v;}),t=this;if(i===-1){return;}if(this.getDomRef()){var h;if(i*this._getItemHeightInPx()>=this._selectionOffset){h=this.getItems().length*Math.floor(this._getContentRepeat()/2)+i;}else{h=this.getItems().length*Math.ceil(this._getContentRepeat()/2)+i;}if(this._bOneTimeValueSelectionAnimation){this._animatingSnap=true;this._getSliderContainerDomRef().animate({scrollTop:h*this._getItemHeightInPx()-this._selectionOffset},200,'linear',function(){t._getSliderContainerDomRef().clearQueue();t._animatingSnap=false;t._bOneTimeValueSelectionAnimation=false;});}else{this._getSliderContainerDomRef().scrollTop(h*this._getItemHeightInPx()-this._selectionOffset);}this._removeSelectionStyle();this._iSelectedItemIndex=h;this._addSelectionStyle();}return this.setProperty("selectedValue",v,true);};a.prototype.setIsExpanded=function(v,s){this.setProperty("isExpanded",v,true);if(this.getDomRef()){var t=this.$();if(v){if(!t.hasClass("sapMTPSliderExpanded")){t.addClass("sapMTPSliderExpanded");}if(sap.ui.Device.system.phone){q.sap.delayedCall(0,this,function(){this._updateSelectionFrameLayout();if(!s){this.fireExpanded({ctrl:this});}});}else{this._updateSelectionFrameLayout();if(!s){this.fireExpanded({ctrl:this});}}}else{this._stopAnimation();if(this._animatingSnap===true){this._animatingSnap=false;this._getSliderContainerDomRef().stop(true);this._scrollerSnapped(this._iSelectedIndex);}t.removeClass("sapMTPSliderExpanded");if(sap.ui.Device.system.phone){q.sap.delayedCall(0,this,this._afterExpandCollapse);}else{this._afterExpandCollapse();}}}return this;};a.prototype.onfocusin=function(E){if(sap.ui.Device.system.desktop&&!this.getIsExpanded()){this.setIsExpanded(true);}};a.prototype.onfocusout=function(E){var s=E.relatedTarget?E.relatedTarget.id:null,A=[this.getAggregation("_arrowUp").getId(),this.getAggregation("_arrowDown").getId()];if(s&&A.indexOf(s)!==-1){return;}if(sap.ui.Device.system.desktop&&this.getIsExpanded()){this.setIsExpanded(false);}};a.prototype.onsappageup=function(E){if(this.getIsExpanded()){var i=this.getItems()[0];this.setSelectedValue(i.getKey());}};a.prototype.onsappagedown=function(E){if(this.getIsExpanded()){var l=this.getItems()[this.getItems().length-1];this.setSelectedValue(l.getKey());}};a.prototype.onsapup=function(E){if(this.getIsExpanded()){this._offsetValue(-1);}};a.prototype.onsapdown=function(E){if(this.getIsExpanded()){this._offsetValue(1);}};a.prototype._getSliderContainerDomRef=function(){return this.$().find(".sapMTimePickerSlider");};a.prototype._getContentRepeat=function(){if(!this._contentRepeat){if(this.getIsCyclic()){this._contentRepeat=Math.ceil(a.MIN_ITEMS/this.getItems().length);this._contentRepeat=Math.max(this._contentRepeat,3);}else{this._contentRepeat=1;}}return this._contentRepeat;};a.prototype._getSelectionFrameIndex=function(){var s=this._getSliderContainerDomRef().height(),i=this._getItemHeightInPx(),h,j,A,k=this.$().parents().hasClass("sapUiSizeCompact");if(s===this.$().height()){s-=q(".sapMTimePickerLabel").height();}h=s/i;j=Math.floor(s/(2*i));A=(!(Math.floor(h)%2))&&((h-Math.floor(h))<0.20);if(A&&!k){j-=1;}return j;};a.prototype._getItemHeightInPx=function(){return this.$("content").find("li").outerHeight();};a.prototype._updateSelectionFrameLayout=function(){var $,i,t;if(this.getDomRef()){$=this.$().find(".sapMTPPickerSelectionFrame");t=this.$().parents(".sapUiSizeCompact").length>0?8:16;i=(this.$().height()-this._getItemHeightInPx())/2+t;$.css("top",i);if(sap.ui.Device.system.phone){q.sap.delayedCall(0,this,this._afterExpandCollapse);}else{this._afterExpandCollapse();}}};a.prototype._getSelectionFrameTopOffset=function(){var $=this._getSliderContainerDomRef().find(".sapMTPPickerSelectionFrame"),h=$.offset();return h.top;};a.prototype._animateScroll=function(s){var p=this._getSliderContainerDomRef().scrollTop(),t=this,h=25,$=t._getSliderContainerDomRef().height(),i=t.$("content").height(),D=200,j=$+D,k=t._getContentRepeat(),l=t.getIsCyclic(),m=0.9,S=0.05,n=200;t._intervalId=setInterval(function(){t._animating=true;p=p-s*h;if(l){p=t._getUpdatedCycleScrollTop($,i,p,j,k);}else{if(p>t._maxScrollTop){p=t._maxScrollTop;s=0;}if(p<t._minScrollTop){p=t._minScrollTop;s=0;}}t._getSliderContainerDomRef().scrollTop(p);s*=m;if(Math.abs(s)<S){var r=t._getItemHeightInPx();var O=t._selectionOffset?(t._selectionOffset%r):0;var u=Math.ceil(p/r)*r-O;clearInterval(t._intervalId);t._animating=null;t._iSelectedIndex=Math.floor(p/r);t._animatingSnap=true;t._getSliderContainerDomRef().animate({scrollTop:u},n,'linear',function(){t._getSliderContainerDomRef().clearQueue();t._animatingSnap=false;t._scrollerSnapped(t._iSelectedIndex);});}},h);};a.prototype._stopAnimation=function(){if(this._animating){clearInterval(this._intervalId);this._animating=null;}};a.prototype._startDrag=function(p){if(!this._dragSession){this._dragSession={};this._dragSession.positions=[];}this._dragSession.pageY=p;this._dragSession.startTop=this._getSliderContainerDomRef().scrollTop();};a.prototype._doDrag=function(p,t){if(this._dragSession){this._dragSession.offsetY=p-this._dragSession.pageY;this._dragSession.positions.push({pageY:p,timeStamp:t});if(this._dragSession.positions.length>20){this._dragSession.positions.splice(0,10);}this._getSliderContainerDomRef().scrollTop(this._dragSession.startTop-this._dragSession.offsetY);}};a.prototype._endDrag=function(p,t){if(this._dragSession){var O,h;for(var i=this._dragSession.positions.length-1;i>=0;i--){O=t-this._dragSession.positions[i].timeStamp;h=p-this._dragSession.positions[i].pageY;if(O>100){break;}}var s=(h/O);if(this._animating){clearInterval(this._intervalId);this._intervalId=null;this._animating=null;}this._dragSession=null;this._animateScroll(s);}};a.prototype._afterExpandCollapse=function(){var s=this.getSelectedValue();this._selectionOffset=this._getSelectionFrameTopOffset()-this._getSliderContainerDomRef().offset().top;if(!this.getIsCyclic()){var S=this._getSliderContainerDomRef();var l=this.$("content");if(this.getIsExpanded()){this._minScrollTop=0;this._marginTop=this._getSelectionFrameTopOffset()-this._getSliderContainerDomRef().offset().top;this._maxScrollTop=this._getItemHeightInPx()*(this.getItems().length-1);this._marginBottom=S.height()-this._marginTop-this._getItemHeightInPx();if(this._marginBottom<0){this._marginBottom=this.$().height()-this._marginTop-this._getItemHeightInPx();}l.css("margin-top",this._marginTop);l.css("margin-bottom",this._marginBottom);}else{l.css("margin-top",0);this._marginBottom=this.$().height()-this._getItemHeightInPx();l.css("margin-bottom",this._marginBottom);}this._selectionOffset=0;}if(!this.getIsExpanded()){this._selectionOffset=0;}this.setSelectedValue(s);};a.prototype._getUpdatedCycleScrollTop=function(i,h,t,D,j){if(this._bIsDrag){var k=h-t-i;if(k<D){t=t-h/j;}if(t<D){t=t+h/j;}}return t;};a.prototype._scrollerSnapped=function(i){var s=i+this._getSelectionFrameIndex(),n;while(s>=this.getItems().length){s=s-this.getItems().length;}if(!this.getIsCyclic()){s=i;}n=this.getItems()[s].getKey();this.setSelectedValue(n);};a.prototype._updateScroll=function(){var s=this.getSelectedValue();if(s!==this.getItems()[0].getKey()&&this._getSliderContainerDomRef().scrollTop()+(this._selectionOffset?this._selectionOffset:0)===0){this.setSelectedValue(s);}};a.prototype._addSelectionStyle=function(){var $=this.$("content").find("li"),s=$.eq(this._iSelectedItemIndex).text(),A=F.call(this,s);$.eq(this._iSelectedItemIndex).addClass("sapMTimePickerItemSelected").attr("aria-selected","true");document.getElementById(this.getId()+"-valDescription").setAttribute("aria-label",A);};a.prototype._removeSelectionStyle=function(){var $=this.$("content").find("li");$.eq(this._iSelectedItemIndex).removeClass("sapMTimePickerItemSelected").attr("aria-selected","false");};a.prototype._attachEvents=function(){var E=this._getSliderContainerDomRef()[0],D=sap.ui.Device;if(D.support.touch){E.addEventListener("touchstart",q.proxy(o,this),false);E.addEventListener("touchmove",q.proxy(b,this),false);document.addEventListener("touchend",q.proxy(c,this),false);}else{E.addEventListener("mousedown",q.proxy(d,this),false);document.addEventListener("mousemove",q.proxy(e,this),false);document.addEventListener("mouseup",q.proxy(g,this),false);}};a.prototype._detachEvents=function(){var E=this.getDomRef(),D=sap.ui.Device;if(D.support.touch){E.removeEventListener("touchstart",q.proxy(o,this),false);E.removeEventListener("touchmove",q.proxy(b,this),false);document.removeEventListener("touchend",q.proxy(c,this),false);}else{E.removeEventListener("mousedown",q.proxy(d,this),false);E.removeEventListener("mousemove",q.proxy(e,this),false);document.removeEventListener("mouseup",q.proxy(g,this),false);}};a.prototype._offsetValue=function(i){var s=this._getSliderContainerDomRef().scrollTop(),h=this._getItemHeightInPx(),S=s+i*h,j=this.getIsCyclic(),t=this,k,l=200;if(!j){if(S>this._maxScrollTop){S=this._maxScrollTop;}if(S<this._minScrollTop){S=this._minScrollTop;}}k=this._iSelectedItemIndex+i-this._getSelectionFrameIndex();if(!this.getIsCyclic()){k=this._iSelectedItemIndex+i;if(k<0||k>=this.getItems().length){return;}}this._animatingSnap=true;this._getSliderContainerDomRef().animate({scrollTop:S},l,'linear',function(){t._getSliderContainerDomRef().clearQueue();t._animatingSnap=false;t._scrollerSnapped(k);});};a.prototype._initArrows=function(){var t=this,A,h;A=new sap.ui.core.Icon({src:I.getIconURI("slim-arrow-up"),press:function(E){t._offsetValue(-1);}});A.addEventDelegate({onAfterRendering:function(){A.$().attr("tabindex",-1);}});this.setAggregation("_arrowUp",A);h=new sap.ui.core.Icon({src:I.getIconURI("slim-arrow-down"),press:function(E){t._offsetValue(1);}});h.addStyleClass("sapMTimePickerItemArrowDown");h.addEventDelegate({onAfterRendering:function(){h.$().attr("tabindex",-1);}});this.setAggregation("_arrowDown",h);};function f(A,p){if(A==null){throw new TypeError('findIndex called with null or undefined array');}if(typeof p!=='function'){throw new TypeError('predicate must be a function');}var l=A.length;var t=arguments[1];var v;for(var i=0;i<l;i++){v=A[i];if(p.call(t,v,i,A)){return i;}}return-1;}var o=function(E){this._bIsDrag=false;if(!this.getIsExpanded()){return;}this._removeSelectionStyle();this._stopAnimation();this._startDrag(E.touches[0].pageY);E.preventDefault();this._mousedown=true;};var b=function(E){if(!this._mousedown||!this.getIsExpanded()){return;}if(!this._bIsDrag&&this._dragSession&&this._dragSession.positions.length){var h=this._dragSession.positions.some(function(p){return Math.abs(p.pageY-E.touches[0].pageY)>5;});if(h){this._bIsDrag=true;}}this._doDrag(E.touches[0].pageY,E.timeStamp);this._mousedown=true;};var c=function(E){if(this._bIsDrag===false){this.fireTap(E);this._dragSession=null;}this._bIsDrag=true;if(!this.getIsExpanded()){this._dragSession=null;return;}this._endDrag(E.changedTouches[0].pageY,E.timeStamp);this._mousedown=false;};var d=function(E){this._bIsDrag=false;if(!this.getIsExpanded()){return;}this._removeSelectionStyle();this._stopAnimation();this._startDrag(E.pageY);this._mousedown=true;};var e=function(E){if(!this._mousedown||!this.getIsExpanded()){return;}if(!this._bIsDrag&&this._dragSession&&this._dragSession.positions.length){var h=this._dragSession.positions.some(function(p){return Math.abs(p.pageY-E.pageY)>5;});if(h){this._bIsDrag=true;}}this._doDrag(E.pageY,E.timeStamp);this._mousedown=true;};var g=function(E){if(this._bIsDrag===false){this.fireTap(E);this._dragSession=null;}this._bIsDrag=true;if(!this.getIsExpanded()){this._dragSession=null;return;}this._endDrag(E.pageY,E.timeStamp);this._mousedown=false;};var F=function(t){var i=this.getItems();var h=f(i,function(j){return j.getText()===t;});return i[h].getKey();};return a;},false);
