/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/support/Plugin','sap/ui/core/util/serializer/ViewSerializer','sap/ui/thirdparty/jszip','sap/ui/core/Element','sap/ui/core/ElementMetadata','sap/ui/core/UIArea','sap/ui/core/mvc/View','sap/ui/core/mvc/Controller'],function(q,P,V,J,E,a,U,b){"use strict";var $=q;var C=P.extend("sap.ui.core.support.plugins.ControlTree",{constructor:function(s){P.apply(this,["sapUiSupportControlTree","Control Tree",s]);this._oStub=s;if(this.isToolPlugin()){this._aEventIds=["sapUiSupportSelectorSelect",this.getId()+"ReceiveControlTree",this.getId()+"ReceiveControlTreeExport",this.getId()+"ReceiveControlTreeExportError",this.getId()+"TriggerRequestProperties",this.getId()+"ReceiveProperties",this.getId()+"ReceiveBindingInfos",this.getId()+"ReceiveMethods",this.getId()+"ReceivePropertiesMethods"];this._breakpointId="sapUiSupportBreakpoint";this._tab={properties:"Properties",bindinginfos:"BindingInfos",breakpoints:"Breakpoints",exports:"Export"};this._currentTab=this._tab.properties;}else{this._aEventIds=[this.getId()+"RequestControlTree",this.getId()+"RequestControlTreeSerialize",this.getId()+"RequestProperties",this.getId()+"RequestBindingInfos",this.getId()+"ChangeProperty",this.getId()+"RefreshBinding"];var t=this;sap.ui.getCore().registerPlugin({startPlugin:function(o){t.oCore=o;},stopPlugin:function(){t.oCore=undefined;}});}}});C.prototype.init=function(s){P.prototype.init.apply(this,arguments);if(this.isToolPlugin()){c.call(this,s);}else{f.call(this,s);}};function c(s){$(document).on("click","li img.sapUiControlTreeIcon",$.proxy(this._onIconClick,this)).on("click","li.sapUiControlTreeElement div",$.proxy(this._onNodeClick,this)).on("click","li.sapUiControlTreeLink div",$.proxy(this._onControlTreeLinkClick,this)).on("click","#sapUiSupportControlTabProperties",$.proxy(this._onPropertiesTab,this)).on("click","#sapUiSupportControlTabBindingInfos",$.proxy(this._onBindingInfosTab,this)).on("click","#sapUiSupportControlTabBreakpoints",$.proxy(this._onMethodsTab,this)).on("click","#sapUiSupportControlTabExport",$.proxy(this._onExportTab,this)).on("change","[data-sap-ui-name]",$.proxy(this._onPropertyChange,this)).on("change","[data-sap-ui-method]",$.proxy(this._onPropertyBreakpointChange,this)).on("keyup",'.sapUiSupportControlMethods input[type="text"]',$.proxy(this._autoComplete,this)).on("blur",'.sapUiSupportControlMethods input[type="text"]',$.proxy(this._updateSelectOptions,this)).on("change",'.sapUiSupportControlMethods select',$.proxy(this._selectOptionsChanged,this)).on("click",'#sapUiSupportControlAddBreakPoint',$.proxy(this._onAddBreakpointClicked,this)).on("click",'#sapUiSupportControlExportToXml',$.proxy(this._onExportToXmlClicked,this)).on("click",'#sapUiSupportControlExportToHtml',$.proxy(this._onExportToHtmlClicked,this)).on("click",'#sapUiSupportControlActiveBreakpoints img.remove-breakpoint',$.proxy(this._onRemoveBreakpointClicked,this)).on("click",'#sapUiSupportControlPropertiesArea a.control-tree',$.proxy(this._onNavToControl,this)).on("click",'#sapUiSupportControlPropertiesArea img.sapUiSupportRefreshBinding',$.proxy(this._onRefreshBinding,this));this.renderContentAreas();}C.prototype.exit=function(s){P.prototype.exit.apply(this,arguments);if(this.isToolPlugin()){$(document).off('click','li img.sapUiControlTreeIcon').off('click','li div').off("click","li.sapUiControlTreeLink").off("click","#sapUiSupportControlTabProperties").off("click","#sapUiSupportControlTabBindings").off("click","#sapUiSupportControlTabBreakpoints").off("click","#sapUiSupportControlTabExport").off('change','[data-sap-ui-name]').off('change','[data-sap-ui-method]').off('keyup','.sapUiSupportControlMethods input[type="text"]').off('blur','.sapUiSupportControlMethods select').off('change','.sapUiSupportControlMethods select').off('click','#sapUiSupportControlAddBreakPoint').off('click','#sapUiSupportControlExportToXml').off('click','#sapUiSupportControlExportToHtml').off('click','#sapUiSupportControlActiveBreakpoints img.remove-breakpoint').off('click','#sapUiSupportControlPropertiesArea a.control-tree').off('click','#sapUiSupportControlPropertiesArea img.sapUiSupportRefreshBinding');}};function d(s){if(s==null){return"";}s=String(s);return s.slice(1+s.lastIndexOf('.'));}function e(s){return s==null?"":q.sap.encodeHTML(String(s));}C.prototype.renderContentAreas=function(){var r=sap.ui.getCore().createRenderManager();r.write('<div id="sapUiSupportControlTreeArea"><ul class="sapUiSupportControlTreeList"></ul></div>');r.write('<div id="sapUiSupportControlTabs" style="visibility:hidden">');r.write('<button id="sapUiSupportControlTabProperties" class="sapUiSupportBtn">Properties</button>');r.write('<button id="sapUiSupportControlTabBindingInfos" class="sapUiSupportBtn">Binding Infos</button>');r.write('<button id="sapUiSupportControlTabBreakpoints" class="sapUiSupportBtn">Breakpoints</button>');r.write('<button id="sapUiSupportControlTabExport" class="sapUiSupportBtn">Export</button>');r.write('</div>');r.write('<div id="sapUiSupportControlPropertiesArea"></div>');r.flush(this.$().get(0));r.destroy();};C.prototype.renderControlTree=function(g){var r=sap.ui.getCore().createRenderManager();function h(i,m){var H=m.aggregation.length>0||m.association.length>0;r.write("<li id=\"sap-debug-controltree-"+e(m.id)+"\" class=\"sapUiControlTreeElement\">");var I=H?"minus":"space";r.write("<img class=\"sapUiControlTreeIcon\" style=\"height: 12px; width: 12px;\" src=\"../../debug/images/"+I+".gif\" />");if(m.isAssociation){r.write("<img title=\"Association\" class=\"sapUiControlTreeIcon\" style=\"height: 12px; width: 12px;\" src=\"../../debug/images/link.gif\" />");}var s=d(m.type);r.write('<div>');r.write('<span class="name" title="'+e(m.type)+'">'+e(s)+' - '+e(m.id)+'</span>');r.write('<span class="sapUiSupportControlTreeBreakpointCount" title="Number of active breakpoints / methods" style="display:none;"></span>');r.write('</div>');if(m.aggregation.length>0){r.write("<ul>");$.each(m.aggregation,h);r.write("</ul>");}if(m.association.length>0){r.write("<ul>");$.each(m.association,function(i,v){if(v.isAssociationLink){var t=d(v.type);r.write("<li data-sap-ui-controlid=\""+e(v.id)+"\" class=\"sapUiControlTreeLink\">");r.write("<img class=\"sapUiControlTreeIcon\" style=\"height: 12px; width: 12px;\" align=\"middle\" src=\"../../debug/images/space.gif\" />");r.write("<img class=\"sapUiControlTreeIcon\" style=\"height: 12px; width: 12px;\" align=\"middle\" src=\"../../debug/images/link.gif\" />");r.write("<div><span title=\"Association '"+e(v.name)+"' to '"+e(v.id)+"' with type '"+e(v.type)+"'\">"+e(t)+" - "+e(v.id)+" ("+e(v.name)+")</span></div>");r.write("</li>");}else{h(0,v);}});r.write("</ul>");}r.write("</li>");}$.each(g,h);r.flush(this.$().find("#sapUiSupportControlTreeArea > ul.sapUiSupportControlTreeList").get(0));r.destroy();};C.prototype.renderPropertiesTab=function(g,s){var r=sap.ui.getCore().createRenderManager();r.write('<ul class="sapUiSupportControlTreeList" data-sap-ui-controlid="'+e(s)+'">');$.each(g,function(i,v){r.write("<li>");r.write("<span><label class='sapUiSupportLabel'>BaseType:</label> <code>"+e(v.control)+"</code></span>");if(v.properties.length>0||v.aggregations.length>0){r.write('<div class="get" title="Activate debugger for get-method">G</div><div class="set" title="Activate debugger for set-method">S</div>');r.write("<div class=\"sapUiSupportControlProperties\"><table><colgroup><col width=\"50%\"/><col width=\"50%\"/></colgroup>");$.each(v.properties,function(i,p){r.write("<tr><td>");r.write("<label class='sapUiSupportLabel'>"+e(p.name)+((p.isBound)?'<img title="Value is bound (see Binding Infos)" src="../../debug/images/link.gif" style="vertical-align:middle;margin-left:3px">':"")+"</label>");r.write("</td><td>");if(p.type==="boolean"){r.write("<input type='checkbox' ");r.write("data-sap-ui-name='"+e(p.name)+"' ");if(p.value==true){r.write("checked='checked'");}r.write("/>");}else if(p.enumValues){r.write("<div><select ");r.write("data-sap-ui-name='"+e(p.name)+"'>");$.each(p.enumValues,function(k,h){r.write("<option");if(k===p.value){r.write(" selected");}r.write(">");r.writeEscaped(""+k);r.write("</option>");});r.write("</select></div>");}else{r.write("<div><input type='text' ");r.write("data-sap-ui-name='"+e(p.name)+"' ");if(p.value){r.write("value='");r.writeEscaped(""+p.value);r.write("'");}r.write("/></div>");}r.write("</td>");r.write('<td><input type="checkbox" data-sap-ui-method="'+e(p._sGetter)+'" title="Activate debugger for '+e(p._sGetter)+'"');if(p.bp_sGetter){r.write("checked='checked'");}r.write('/></td>');r.write('<td><input type="checkbox" data-sap-ui-method="'+e(p._sMutator)+'" title="Activate debugger for '+e(p._sMutator)+'"');if(p.bp_sMutator){r.write("checked='checked'");}r.write('/></td>');r.write("</tr>");});$.each(v.aggregations,function(i,A){r.write("<tr><td>");r.write("<label class='sapUiSupportLabel'>"+e(A.name)+"</label>");r.write("</td><td>");r.write(e(A.value));r.write("</td>");r.write('<td><input type="checkbox" data-sap-ui-method="'+e(A._sGetter)+'" title="Activate debugger for '+e(A._sGetter)+'"');if(A.bp_sGetter){r.write("checked='checked'");}r.write('/></td>');r.write('<td><input type="checkbox" data-sap-ui-method="'+e(A._sMutator)+'" title="Activate debugger for '+e(A._sMutator)+'"');if(A.bp_sMutator){r.write("checked='checked'");}r.write('/></td>');r.write("</tr>");});r.write("</table></div>");}r.write("</li>");});r.write("</ul>");r.flush(this.$().find("#sapUiSupportControlPropertiesArea").get(0));r.destroy();this.$().find("#sapUiSupportControlTabs").css("visibility","");this.selectTab(this._tab.properties);};C.prototype.renderBindingsTab=function(B,s){var r=sap.ui.getCore().createRenderManager();if(B.contexts.length>0){r.write('<h2 style="padding-left:5px">Contexts</h2>');r.write('<ul class="sapUiSupportControlTreeList" data-sap-ui-controlid="'+e(s)+'">');$.each(B.contexts,function(i,o){r.write('<li>');r.write('<span><label class="sapUiSupportLabel">Model Name: '+e(o.modelName)+'</label></span>');r.write('<div class="sapUiSupportControlProperties">');r.write('<table><colgroup><col width="15%"><col width="35%"><col width="50%"></colgroup>');r.write('<tbody>');r.write('<tr><td colspan="2">');r.write('<label class="sapUiSupportLabel">Path</label>');r.write('</td><td>');r.write('<div><span');if(o.invalidPath){r.write(' style="color:red"');}r.write('>'+e(o.path));if(o.invalidPath){r.write(' (invalid)');}r.write('</span></div>');r.write('</td></tr>');if(o.location){r.write('<tr><td colspan="2">');r.write('<label class="sapUiSupportLabel">Inherited from</label>');r.write('</td><td>');r.write('<div><a class="control-tree sapUiSupportLink" title="'+e(o.location.name)+'" data-sap-ui-control-id="'+e(o.location.id)+'" href="javascript:void(0);">'+e(d(o.location.name))+' ('+e(o.location.id)+')</a></div>');r.write('</td></tr>');}r.write('</tbody></table></div></li>');});r.write('</ul>');}if(B.bindings.length>0){r.write('<h2 style="padding-left:5px">Bindings</h2>');r.write('<ul class="sapUiSupportControlTreeList" data-sap-ui-controlid="'+e(s)+'">');$.each(B.bindings,function(i,o){r.write('<li data-sap-ui-binding-name="'+e(o.name)+'">');r.write('<span>');r.write('<label class="sapUiSupportLabel" style="vertical-align: middle">'+e(o.name)+'</label>');r.write('<img class="sapUiSupportRefreshBinding" title="Refresh Binding" '+'src="../../debug/images/refresh.gif" style="cursor:pointer;margin-left:5px;vertical-align:middle">');r.write('</span>');$.each(o.bindings,function(g,h){r.write('<div class="sapUiSupportControlProperties">');r.write('<table><colgroup><col width="15%"><col width="35%"><col width="50%"></colgroup>');r.write('<tbody>');r.write('<tr><td colspan="2">');r.write('<label class="sapUiSupportLabel">Path</label>');r.write('</td><td>');r.write('<div><span');if(h.invalidPath){r.write(' style="color:red"');}r.write('>'+e(h.path));if(h.invalidPath){r.write(' (invalid)');}r.write('</span></div>');r.write('</td></tr>');r.write('<tr><td colspan="2">');r.write('<label class="sapUiSupportLabel">Absolute Path</label>');r.write('</td><td>');if(typeof h.absolutePath!=='undefined'){r.write('<div>'+e(h.absolutePath)+'</div>');}else{r.write('<div>No binding</div>');}r.write('</td></tr>');r.write('<tr><td colspan="2">');r.write('<label class="sapUiSupportLabel">Relative</label>');r.write('</td><td>');if(typeof h.isRelative!=='undefined'){r.write('<div>'+e(h.isRelative)+'</div>');}else{r.write('<div>No binding</div>');}r.write('</td></tr>');r.write('<tr><td colspan="2">');r.write('<label class="sapUiSupportLabel">Binding Type</label>');r.write('</td><td>');if(!o.type){r.write('<div>No binding</div>');}else{r.write('<div title="'+e(o.type)+'">'+e(d(o.type))+'</div>');}r.write('</td></tr>');if(h.mode){r.write('<tr><td colspan="2">');r.write('<label class="sapUiSupportLabel">Binding Mode</label>');r.write('</td><td>');r.write('<div>'+e(h.mode)+'</div>');r.write('</td></tr>');}r.write('<tr><td>');r.write('<label class="sapUiSupportLabel">Model</label>');r.write('</td><td>');r.write('<label class="sapUiSupportLabel">Name</label>');r.write('</td><td>');if(h.model&&h.model.name){r.write('<div>'+e(h.model.name)+'</div>');}else{r.write('<div>No binding</div>');}r.write('</td></tr>');r.write('<tr><td>');r.write('</td><td>');r.write('<label class="sapUiSupportLabel">Type</label>');r.write('</td><td>');if(h.model&&h.model.type){r.write('<div><span title="'+e(h.model.type)+'">'+e(d(h.model.type))+'</span></div>');}else{r.write('<div><span>No binding</span></div>');}r.write('</td></tr>');r.write('<tr><td>');r.write('</td><td>');r.write('<label class="sapUiSupportLabel">Default Binding Mode</label>');r.write('</td><td>');if(h.model&&h.model.bindingMode){r.write('<div><span>'+e(h.model.bindingMode)+'</span></div>');}else{r.write('<div><span>No binding</span></div>');}r.write('</td></tr>');r.write('<tr><td>');r.write('</td><td>');r.write('<label class="sapUiSupportLabel">Location</label>');r.write('</td><td>');if(h.model&&h.model.location&&h.model.location.type){if(h.model.location.type==='control'){r.write('<div><a class="control-tree sapUiSupportLink" title="'+e(h.model.location.name)+'" data-sap-ui-control-id="'+e(h.model.location.id)+'" href="javascript:void(0);">'+e(d(h.model.location.name))+' ('+e(h.model.location.id)+')</a></div>');}else{r.write('<div><span title="sap.ui.getCore()">Core</span></div>');}}else{r.write('<div><span>No binding</span></div>');}r.write('</td></tr>');r.write('</tbody></table></div>');});r.write('</li>');});r.write('</ul>');}r.flush(this.$().find("#sapUiSupportControlPropertiesArea").get(0));r.destroy();};C.prototype.renderBreakpointsTab=function(m,s){var r=sap.ui.getCore().createRenderManager();r.write('<div class="sapUiSupportControlMethods" data-sap-ui-controlid="'+e(s)+'">');r.write('<select id="sapUiSupportControlMethodsSelect" class="sapUiSupportAutocomplete"><option></option>');$.each(m,function(i,v){if(!v.active){r.write('<option>'+e(v.name)+'</option>');}});r.write('</select>');r.write('<input class="sapUiSupportControlBreakpointInput sapUiSupportAutocomplete" type="text"/>');r.write('<button id="sapUiSupportControlAddBreakPoint" class="sapUiSupportBtn">Add breakpoint</button>');r.write('<hr class="no-border"/><ul id="sapUiSupportControlActiveBreakpoints" class="sapUiSupportList sapUiSupportBreakpointList">');$.each(m,function(i,v){if(!v.active){return;}r.write('<li><span>'+e(v.name)+'</span>'+'<img class="remove-breakpoint" style="cursor:pointer;margin-left:5px" '+'src="../../debug/images/delete.gif"></li>');});r.write('</ul></div>');r.flush(this.$().find("#sapUiSupportControlPropertiesArea").get(0));r.destroy();this.selectTab(this._tab.breakpoints);this.$().find('.sapUiSupportControlBreakpointInput').focus();};C.prototype.renderExportTab=function(){var r=sap.ui.getCore().createRenderManager();r.write('<button id="sapUiSupportControlExportToXml" class="sapUiSupportBtn">Export To XML</button>');r.write('<br><br>');r.write('<button id="sapUiSupportControlExportToHtml" class="sapUiSupportBtn">Export To HTML</button>');r.flush(this.$().find("#sapUiSupportControlPropertiesArea").get(0));r.destroy();this.selectTab(this._tab.exports);};C.prototype.requestProperties=function(s){this._oStub.sendEvent(this._breakpointId+"RequestInstanceMethods",{controlId:s,callback:this.getId()+"ReceivePropertiesMethods"});};C.prototype.updateBreakpointCount=function(s,B){var g=$("#sap-debug-controltree-"+s+" > div span.sapUiSupportControlTreeBreakpointCount");if(B.active>0){g.text(B.active+" / "+B.all).show();}else{g.text("").hide();}};C.prototype.onsapUiSupportControlTreeTriggerRequestProperties=function(o){this.requestProperties(o.getParameter("controlId"));};C.prototype.onsapUiSupportControlTreeReceivePropertiesMethods=function(o){var s=o.getParameter("controlId");this._oStub.sendEvent(this.getId()+"RequestProperties",{id:s,breakpointMethods:o.getParameter("methods")});this.updateBreakpointCount(s,JSON.parse(o.getParameter("breakpointCount")));};C.prototype.onsapUiSupportControlTreeReceiveControlTree=function(o){this.renderControlTree(JSON.parse(o.getParameter("controlTree")));};C.prototype.onsapUiSupportControlTreeReceiveControlTreeExportError=function(o){var s=o.getParameter("errorMessage");this._drawAlert(s);};C.prototype._drawAlert=function(s){alert("ERROR: The selected element cannot not be exported.\nPlease choose an other one.\n\nReason:\n"+s);};C.prototype.onsapUiSupportControlTreeReceiveControlTreeExport=function(o){var z;var v=JSON.parse(o.getParameter("serializedViews"));var t=o.getParameter("sType");if(!$.isEmptyObject(v)){z=new J();for(var g in v){var h=v[g];z.file(g.replace(/\./g,'/')+".view."+t.toLowerCase(),h);}}if(z){var j=z.generate({base64:true});var r=window.atob(j);var u=new Uint8Array(r.length);for(var i=0;i<u.length;++i){u[i]=r.charCodeAt(i);}var k=new Blob([u],{type:'application/zip'});var l=document.createEvent("HTMLEvents");l.initEvent("click");$("<a>",{download:t.toUpperCase()+"Export.zip",href:window.URL.createObjectURL(k)}).get(0).dispatchEvent(l);}};C.prototype.onsapUiSupportSelectorSelect=function(o){this.selectControl(o.getParameter("id"));};C.prototype.onsapUiSupportControlTreeReceiveProperties=function(o){this.renderPropertiesTab(JSON.parse(o.getParameter("properties")),o.getParameter("id"));};C.prototype.onsapUiSupportControlTreeReceiveBindingInfos=function(o){this.renderBindingsTab(JSON.parse(o.getParameter("bindinginfos")),o.getParameter("id"));};C.prototype.onsapUiSupportControlTreeReceiveMethods=function(o){var s=o.getParameter("controlId");this.renderBreakpointsTab(JSON.parse(o.getParameter("methods")),s);this.updateBreakpointCount(s,JSON.parse(o.getParameter("breakpointCount")));};C.prototype._onNodeClick=function(o){var g=$(o.target);var h=g.closest("li");if(h.hasClass("sapUiControlTreeElement")){$(".sapUiControlTreeElement > div").removeClass("sapUiSupportControlTreeSelected");h.children("div").addClass("sapUiSupportControlTreeSelected");this._oStub.sendEvent("sapUiSupportSelectorHighlight",{id:h.attr("id").substring("sap-debug-controltree-".length)});var i=h.attr("id").substring("sap-debug-controltree-".length);if(g.hasClass("sapUiSupportControlTreeBreakpointCount")){this._currentTab=this._tab.breakpoints;}this.onAfterControlSelected(i);}o.stopPropagation();};C.prototype._onIconClick=function(o){var g=$(o.target);if(g.parent().attr("data-sap-ui-collapsed")){g.attr("src",g.attr("src").replace("plus","minus")).parent().removeAttr("data-sap-ui-collapsed");g.siblings("ul").show();}else{g.attr("src",g.attr("src").replace("minus","plus")).parent().attr("data-sap-ui-collapsed","true");g.siblings("ul").hide();}if(o.stopPropagation){o.stopPropagation();}};C.prototype._onControlTreeLinkClick=function(o){this.selectControl($(o.target).closest("li").attr("data-sap-ui-controlid"));};C.prototype._onPropertiesTab=function(o){if(this.selectTab(this._tab.properties)){this.requestProperties(this.getSelectedControlId());}};C.prototype._onBindingInfosTab=function(o){if(this.selectTab(this._tab.bindinginfos)){this._oStub.sendEvent(this.getId()+"RequestBindingInfos",{id:this.getSelectedControlId()});}};C.prototype._onMethodsTab=function(o){if(this.selectTab(this._tab.breakpoints)){this._oStub.sendEvent(this._breakpointId+"RequestInstanceMethods",{controlId:this.getSelectedControlId(),callback:this.getId()+"ReceiveMethods"});}};C.prototype._onExportTab=function(o){if(this.selectTab(this._tab.exports)){this.renderExportTab();}};C.prototype._autoComplete=function(o){if(o.keyCode==q.sap.KeyCodes.ENTER){this._updateSelectOptions(o);this._onAddBreakpointClicked();}if(o.keyCode>=q.sap.KeyCodes.ARROW_LEFT&&o.keyCode<=q.sap.KeyCodes.ARROW_DOWN){return;}var g=$(o.target),h=g.prev("select"),I=g.val();if(I==""){return;}var O=h.find("option").map(function(){return $(this).val();}).get();var s;for(var i=0;i<O.length;i++){s=O[i];if(s.toUpperCase().indexOf(I.toUpperCase())==0){var j=g.cursorPos();if(o.keyCode==q.sap.KeyCodes.BACKSPACE){j--;}g.val(s);g.selectText(j,s.length);break;}}return;};C.prototype._updateSelectOptions=function(o){var s=o.target;if(s.tagName=="INPUT"){var v=s.value;s=s.previousSibling;var O=s.options;for(var i=0;i<O.length;i++){var t=O[i].value||O[i].text;if(t.toUpperCase()==v.toUpperCase()){s.selectedIndex=i;break;}}}var g=s.selectedIndex;var h=s.options[g].value||s.options[g].text;if(s.nextSibling&&s.nextSibling.tagName=="INPUT"){s.nextSibling.value=h;}};C.prototype._onAddBreakpointClicked=function(o){var g=this.$().find("#sapUiSupportControlMethodsSelect");this._oStub.sendEvent(this._breakpointId+"ChangeInstanceBreakpoint",{controlId:g.closest("[data-sap-ui-controlid]").attr("data-sap-ui-controlid"),methodName:g.val(),active:true,callback:this.getId()+"ReceiveMethods"});};C.prototype._onExportToXmlClicked=function(o){this._startSerializing("XML");};C.prototype._onExportToHtmlClicked=function(o){this._startSerializing("HTML");};C.prototype._startSerializing=function(t){var s=this.getSelectedControlId();if(s){this._oStub.sendEvent(this.getId()+"RequestControlTreeSerialize",{controlID:s,sType:t});}else{this._drawAlert("Nothing to export. Please select an item in the control tree.");}};C.prototype._onRemoveBreakpointClicked=function(o){var g=$(o.target);this._oStub.sendEvent(this._breakpointId+"ChangeInstanceBreakpoint",{controlId:g.closest("[data-sap-ui-controlid]").attr("data-sap-ui-controlid"),methodName:g.siblings('span').text(),active:false,callback:this.getId()+"ReceiveMethods"});};C.prototype._selectOptionsChanged=function(o){var s=o.target;var i=s.nextSibling;i.value=s.options[s.selectedIndex].value;};C.prototype._onPropertyChange=function(o){var s=o.target;var g=$(s);var i=g.closest("[data-sap-ui-controlid]").attr("data-sap-ui-controlid");var v=g.val();if(g.attr("type")==="checkbox"){v=""+g.is(":checked");}this._oStub.sendEvent(this.getId()+"ChangeProperty",{id:i,name:g.attr("data-sap-ui-name"),value:v});};C.prototype._onPropertyBreakpointChange=function(o){var g=$(o.target);this._oStub.sendEvent(this._breakpointId+"ChangeInstanceBreakpoint",{controlId:g.closest("[data-sap-ui-controlid]").attr("data-sap-ui-controlid"),methodName:g.attr("data-sap-ui-method"),active:g.is(":checked"),callback:this.getId()+"TriggerRequestProperties"});};C.prototype._onNavToControl=function(o){var g=$(o.target);var i=g.attr("data-sap-ui-control-id");if(i!==this.getSelectedControlId()){this.selectControl(i);}};C.prototype._onRefreshBinding=function(o){var g=$(o.target);var i=g.closest("[data-sap-ui-controlid]").attr("data-sap-ui-controlid");var n=g.closest("[data-sap-ui-binding-name]").attr("data-sap-ui-binding-name");this._oStub.sendEvent(this.getId()+"RefreshBinding",{id:i,name:n});};C.prototype.selectTab=function(t){var g=this.$().find("#sapUiSupportControlTab"+t);if(g.hasClass("active")){return false;}this.$().find("#sapUiSupportControlTabs button").removeClass("active");g.addClass("active");this._currentTab=t;return true;};C.prototype.getSelectedControlId=function(){var g=this.$().find(".sapUiSupportControlTreeSelected");if(g.length===0){return undefined;}else{return g.parent().attr("id").substring("sap-debug-controltree-".length);}};C.prototype.selectControl=function(s){if(!s){return;}$(".sapUiControlTreeElement > div").removeClass("sapUiSupportControlTreeSelected");var t=this;$.sap.byId("sap-debug-controltree-"+s).parents("[data-sap-ui-collapsed]").each(function(i,v){t._onIconClick({target:$(v).find("img:first").get(0)});});var p=$.sap.byId("sap-debug-controltree-"+s).children("div").addClass("sapUiSupportControlTreeSelected").position();var S=this.$().find("#sapUiSupportControlTreeArea").scrollTop();this.$().find("#sapUiSupportControlTreeArea").scrollTop(S+p.top);this.onAfterControlSelected(s);};C.prototype.onAfterControlSelected=function(i){if(this._currentTab==this._tab.properties){this.requestProperties(i);}else if(this._currentTab==this._tab.breakpoints){this._oStub.sendEvent(this._breakpointId+"RequestInstanceMethods",{controlId:i,callback:this.getId()+"ReceiveMethods"});}else if(this._currentTab==this._tab.bindinginfos){this._oStub.sendEvent(this.getId()+"RequestBindingInfos",{id:this.getSelectedControlId()});}};function f(s){this.onsapUiSupportControlTreeRequestControlTree();}C.prototype.onsapUiSupportControlTreeRequestControlTree=function(o){this._oStub.sendEvent(this.getId()+"ReceiveControlTree",{controlTree:JSON.stringify(this.getControlTree())});};C.prototype.onsapUiSupportControlTreeRequestControlTreeSerialize=function(o){var g=this.oCore.byId(o.getParameter("controlID"));var t=o.getParameter("sType");var v;var m;sap.ui.controller(t+"ViewController",{});sap.ui.jsview(t+"ViewExported",{getControllerName:function(){return t+"ViewController";},createContent:function(n){}});sap.ui.controller(t+"ViewController",{});sap.ui.jsview(t+"ViewExported",{getControllerName:function(){return t+"ViewController";},createContent:function(n){}});try{if(g){var p=g.getParent();var h;h=p.indexOfContent(g);if(g instanceof b){v=new V(g,window,"sap.m");}else{var j=sap.ui.jsview(t+"ViewExported");j.addContent(g);v=new V(j,window,"sap.m");}m=(t&&t!=="XML")?v.serializeToHTML():v.serializeToXML();if(h){p.insertContent(g,h);}else{p.addContent(g);}}else{var u=this.oCore.getUIArea(o.getParameter("controlID"));var j=sap.ui.jsview(t+"ViewExported");var k=u.getContent();for(var i=0;i<k.length;i++){j.addContent(k[i]);}v=new V(j,window,"sap.m");m=(t&&t!=="XML")?v.serializeToHTML():v.serializeToXML();for(var i=0;i<k.length;i++){u.addContent(k[i]);}}if(v){this._oStub.sendEvent(this.getId()+"ReceiveControlTreeExport",{serializedViews:JSON.stringify(m),sType:t});}}catch(l){this._oStub.sendEvent(this.getId()+"ReceiveControlTreeExportError",{errorMessage:l.message});}};C.prototype.onsapUiSupportControlTreeRequestProperties=function(o){var g=JSON.parse(o.getParameter("breakpointMethods"));var h=this.getControlProperties(o.getParameter("id"),g);this._oStub.sendEvent(this.getId()+"ReceiveProperties",{id:o.getParameter("id"),properties:JSON.stringify(h)});};C.prototype.onsapUiSupportControlTreeChangeProperty=function(o){var i=o.getParameter("id");var g=this.oCore.byId(i);if(g){var n=o.getParameter("name");var v=o.getParameter("value");var p=g.getMetadata().getProperty(n);if(p&&p.type){var t=sap.ui.base.DataType.getType(p.type);if(t instanceof sap.ui.base.DataType){var h=t.parseValue(v);if(t.isValid(h)&&h!=="(null)"){g[p._sMutator](h);}}else if(t){if(t[v]){g[p._sMutator](v);}}}}};C.prototype.onsapUiSupportControlTreeRequestBindingInfos=function(o){var i=o.getParameter("id");this._oStub.sendEvent(this.getId()+"ReceiveBindingInfos",{id:i,bindinginfos:JSON.stringify(this.getControlBindingInfos(i))});};C.prototype.onsapUiSupportControlTreeRefreshBinding=function(o){var i=o.getParameter("id");var B=o.getParameter("name");this.refreshBinding(i,B);this._oStub.sendEvent(this.getId()+"ReceiveBindingInfos",{id:i,bindinginfos:JSON.stringify(this.getControlBindingInfos(i))});};C.prototype.getControlTree=function(){var o=this.oCore,g=[],A={};function s(i){var m={id:i.getId(),type:"",aggregation:[],association:[]};A[m.id]=m.id;if(i instanceof U){m.library="sap.ui.core";m.type="sap.ui.core.UIArea";$.each(i.getContent(),function(I,i){var v=s(i);m.aggregation.push(v);});}else{m.library=i.getMetadata().getLibraryName();m.type=i.getMetadata().getName();if(i.mAggregations){for(var j in i.mAggregations){var k=i.mAggregations[j];if(k){var l=$.isArray(k)?k:[k];$.each(l,function(I,v){if(v instanceof E){var w=s(v);m.aggregation.push(w);}});}}}if(i.mAssociations){var n=i.getMetadata().getAllAssociations();for(var p in i.mAssociations){var r=i.mAssociations[p];var t=(n[p])?n[p].type:null;if(r&&t){var u=$.isArray(r)?r:[r];$.each(u,function(I,v){m.association.push({id:v,type:t,name:p,isAssociationLink:true});});}}}}return m;}$.each(o.mUIAreas,function(i,u){var m=s(u);g.push(m);});function h(I,m){for(var i=0;i<m.association.length;i++){var j=m.association[i];if(!A[j.id]){var t=q.sap.getObject(j.type);if(!t){continue;}var S=t.getMetadata().getStereotype(),O=null;switch(S){case"element":case"control":O=o.byId(j.id);break;case"component":O=o.getComponent(j.id);break;case"template":O=o.getTemplate(j.id);break;default:break;}if(!O){continue;}m.association[i]=s(O);m.association[i].isAssociation=true;h(0,m.association[i]);}}$.each(m.aggregation,h);}$.each(g,h);return g;};C.prototype.getControlProperties=function(i,m){var p=/^((boolean|string|int|float)(\[\])?)$/;var g=[];var h=this.oCore.byId(i);if(!h&&this.oCore.getUIArea(i)){g.push({control:"sap.ui.core.UIArea",properties:[],aggregations:[]});}else if(h){var M=h.getMetadata();while(M instanceof a){var j={control:M.getName(),properties:[],aggregations:[]};var k=M.getProperties();$.each(k,function(K,l){var n={};$.each(l,function(N,v){if(N.substring(0,1)!=="_"||(N=='_sGetter'||N=='_sMutator')){n[N]=v;}if(N=='_sGetter'||N=='_sMutator'){n["bp"+N]=$.grep(m,function(o){return o.name===v&&o.active;}).length===1;}var t=sap.ui.base.DataType.getType(l.type);if(t&&!(t instanceof sap.ui.base.DataType)){n["enumValues"]=t;}});n.value=h.getProperty(K);n.isBound=!!h.mBindingInfos[K];j.properties.push(n);});var A=M.getAggregations();$.each(A,function(K,l){if(l.altTypes&&l.altTypes[0]&&p.test(l.altTypes[0])&&typeof(h.getAggregation(K))!=='object'){var n={};$.each(l,function(N,v){if(N.substring(0,1)!=="_"||(N=='_sGetter'||N=='_sMutator')){n[N]=v;}if(N=='_sGetter'||N=='_sMutator'){n["bp"+N]=$.grep(m,function(o){return o.name===v&&o.active;}).length===1;}});n.value=h.getAggregation(K);j.aggregations.push(n);}});g.push(j);M=M.getParent();}}return g;};C.prototype.getControlBindingInfos=function(i){var m={bindings:[],contexts:[]};var o=this.oCore.byId(i);if(!o){return m;}var B=o.mBindingInfos;var t=this;for(var g in B){if(B.hasOwnProperty(g)){var h=B[g];var j=[];var k,l=[];if($.isArray(h.parts)){k=h.parts;}else{k=[h];}if(h.binding instanceof sap.ui.model.CompositeBinding){l=h.binding.getBindings();}else if(h.binding instanceof sap.ui.model.Binding){l=[h.binding];}$.each(k,function(I,v){var D={};D.invalidPath=true;D.path=v.path;D.mode=v.mode;D.model={name:v.model};if(l.length>I&&l[I]){var w=l[I],M=w.getModel();var A;if(M){A=M.resolve(w.getPath(),w.getContext());if(M.getProperty(A)!=null){D.invalidPath=false;}}D.absolutePath=(typeof(A)==='undefined')?'Unresolvable':A;D.isRelative=w.isRelative();D.model=t.getBindingModelInfo(w,o);}j.push(D);});m.bindings.push({name:g,type:(h.binding)?h.binding.getMetadata().getName():undefined,bindings:j});}}function n(v,M){var w={modelName:(M==='undefined')?'none (default)':M,path:v.getPath()};if(!v.getObject()==null){w.invalidPath=true;}return w;}var p=o.oBindingContexts;for(var r in p){if(p.hasOwnProperty(r)){m.contexts.push(n(p[r],r));}}var p=o.oPropagatedProperties.oBindingContexts;for(var r in p){if(p.hasOwnProperty(r)&&!o.oBindingContexts[r]){var s=n(p[r],r);var u=o;do{if(u.oBindingContexts[r]==p[r]){s.location={id:u.getId(),name:u.getMetadata().getName()};break;}}while((u=u.getParent()));m.contexts.push(s);}}return m;};C.prototype.getBindingModelInfo=function(B,o){var m={};var g=B.getModel();function h(M){for(var s in M){if(M.hasOwnProperty(s)){if(M[s]===g){return s;}}}return null;}m.name=h(o.oModels)||h(o.oPropagatedProperties.oModels);if(m.name){var i=o;do{if(i.oModels[m.name]===g){m.location={type:'control',id:i.getId(),name:i.getMetadata().getName()};break;}}while((i=i.getParent()));if(!m.location){var j=null;if(m.name==='undefined'){j=this.oCore.getModel();}else{j=this.oCore.getModel(m.name);}if(j){m.location={type:'core'};}}}m.type=g.getMetadata().getName();m.bindingMode=g.getDefaultBindingMode();m.name=(m.name==='undefined')?'none (default)':m.name;return m;};C.prototype.refreshBinding=function(I,B){var o=this.oCore.byId(I);var m=o.mBindingInfos[B];if(!o||!m){return;}var g=m.binding;if(!g){return;}if(g instanceof sap.ui.model.CompositeBinding){var h=g.getBindings();for(var i=0;i<h.length;i++){h[i].refresh();}}else{g.refresh();}};return C;});
