/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/library","./SemanticContainer"],function(m,S){"use strict";var B=m.ButtonType;var a=S.extend("sap.f.semantic.SemanticTitle",{constructor:function(c,p){S.call(this,c,p);this._iMainActionCount=0;this._aSemanticTextActions=[];this._aSemanticSimpleIconActions=[];this._aSemanticNavIconActions=[];this._aCustomTextActions=[];this._aCustomIconActions=[];}});a.mPlacementMethodMap={titleText:"TextContent",titleIcon:"IconContent",shareIcon:"ShareContent"};a.prototype.addContent=function(s,p){this["_insertSemantic"+a.mPlacementMethodMap[p]].call(this,s);return this;};a.prototype.removeContent=function(s,p){this["_removeSemantic"+a.mPlacementMethodMap[p]].call(this,s);return this;};a.prototype.destroy=function(){this._aSemanticSimpleIconActions=null;this._aSemanticTextActions=null;this._aCustomTextActions=null;this._aCustomIconActions=null;this._aSemanticNavIconActions=null;return S.prototype.destroy.call(this);};a.prototype.addCustomTextAction=function(c){c.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",c,this._getCustomTextActionInsertIndex());this._aCustomTextActions.push(c);return this;};a.prototype.insertCustomTextAction=function(c,i){c.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",c,this._getCustomTextActionInsertIndex(i));this._aCustomTextActions.splice(i,0,c);return this;};a.prototype.indexOfCustomTextAction=function(c){return this._aCustomTextActions.indexOf(c);};a.prototype.removeCustomTextAction=function(c){var i=this._aCustomTextActions.indexOf(c),r=this._callContainerAggregationMethod("removeAction",c);this._aCustomTextActions.splice(i,1);return r;};a.prototype.removeAllCustomTextActions=function(){var r=[];this._aCustomTextActions.forEach(function(c){var R=this._callContainerAggregationMethod("removeAction",c);if(R){r.push(c);}},this);this._aCustomTextActions=[];return r;};a.prototype.destroyCustomTextActions=function(){this.removeAllCustomTextActions().forEach(function(c){c.destroy();});return this;};a.prototype.getCustomTextActions=function(){return this._aCustomTextActions;};a.prototype.addCustomIconAction=function(c){c.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",c,this._getCustomIconActionInsertIndex());this._aCustomIconActions.push(c);return this;};a.prototype.insertCustomIconAction=function(c,i){c.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",c,this._getCustomIconActionInsertIndex(i));this._aCustomIconActions.splice(i,0,c);return this;};a.prototype.indexOfCustomIconAction=function(c){return this._aCustomIconActions.indexOf(c);};a.prototype.removeCustomIconAction=function(c){var i=this._aCustomIconActions.indexOf(c),r=this._callContainerAggregationMethod("removeAction",c);this._aCustomIconActions.splice(i,1);return r;};a.prototype.removeAllCustomIconActions=function(){var r=[];this._aCustomIconActions.forEach(function(c){var R=this._callContainerAggregationMethod("removeAction",c);if(R){r.push(c);}},this);this._aCustomIconActions=[];return r;};a.prototype.destroyCustomIconActions=function(){this.removeAllCustomIconActions().forEach(function(c){c.destroy();});return this;};a.prototype.getCustomIconActions=function(){return this._aCustomIconActions;};a.prototype._insertSemanticTextContent=function(s){var c=this._getControl(s),i=this._isMainAction(s),I;this._aSemanticTextActions.push(s);if(i){this._iMainActionCount++;I=this._getSemanticTextMainActionInsertIndex();}else{I=this._getSemanticTextActionInsertIndex(s);}this._callContainerAggregationMethod("insertAction",c,I);return this;};a.prototype._removeSemanticTextContent=function(s){var c=this._getControl(s),C=this._aSemanticTextActions.indexOf(s),i=this._isMainAction(s);if(i){this._iMainActionCount--;}this._aSemanticTextActions.splice(C,1);this._callContainerAggregationMethod("removeAction",c);return this;};a.prototype._insertSemanticIconContent=function(s){var c=this._getControl(s),C,i;if(this._isNavigationAction(s)){this._aSemanticNavIconActions.push(s);i=this._getSemanticNavIconActionInsertIndex(s);C="insertNavigationAction";}else{this._aSemanticSimpleIconActions.push(s);i=this._getSemanticSimpleIconActionInsertIndex(s);C="insertAction";}this._callContainerAggregationMethod(C,c,i);return this;};a.prototype._removeSemanticIconContent=function(s){var c=this._getControl(s),C,i;if(this._isNavigationAction(s)){i=this._aSemanticNavIconActions.indexOf(s);this._aSemanticNavIconActions.splice(i,1);C="removeNavigationAction";}else{i=this._aSemanticTextActions.indexOf(s);this._aSemanticSimpleIconActions.splice(i,1);C="removeAction";}this._callContainerAggregationMethod(C,c);return this;};a.prototype._insertSemanticShareContent=function(s){var c=this._getControl(s),i=this._getSemanticShareMenuInsertIndex();this._callContainerAggregationMethod("insertAction",c,i);return this;};a.prototype._removeSemanticShareContent=function(s){var c=this._getControl(s);this._callContainerAggregationMethod("removeAction",c);return this;};a.prototype._getSemanticTextMainActionInsertIndex=function(){return 0;};a.prototype._getCustomTextActionInsertIndex=function(i){var c=this._aCustomTextActions.length;if(i===undefined){return this._iMainActionCount+c;}i=i>=c?c:i;i+=this._iMainActionCount;return i;};a.prototype._getSemanticTextActionInsertIndex=function(s){this._aSemanticTextActions.sort(this._sortControlByOrder.bind(this));return this._getCustomTextActionInsertIndex()+this._aSemanticTextActions.indexOf(s)-this._iMainActionCount;};a.prototype._getCustomIconActionInsertIndex=function(i){var c=this._aCustomIconActions.length,p=this._aCustomTextActions.length+this._aSemanticTextActions.length;if(i===undefined){return p+c;}i=i>=c?c:i;i+=p;return i;};a.prototype._getSemanticSimpleIconActionInsertIndex=function(s){this._aSemanticSimpleIconActions.sort(this._sortControlByOrder.bind(this));return this._getCustomIconActionInsertIndex()+this._aSemanticSimpleIconActions.indexOf(s);};a.prototype._getSemanticNavIconActionInsertIndex=function(s){this._aSemanticNavIconActions.sort(this._sortControlByOrder.bind(this));return this._aSemanticNavIconActions.indexOf(s);};a.prototype._getSemanticShareMenuInsertIndex=function(){return this._callContainerAggregationMethod("getActions").length;};a.prototype._getContainerBar=function(){var c=this._getContainer();if(c){return c.getAggregation("_overflowToolbar");}return null;};return a;});
