ace.define("ace/mode/css_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules"],function(r,e,m){"use strict";var o=r("../lib/oop");var l=r("../lib/lang");var T=r("./text_highlight_rules").TextHighlightRules;var s=e.supportType="align-content|align-items|align-self|all|animation|animation-delay|animation-direction|animation-duration|animation-fill-mode|animation-iteration-count|animation-name|animation-play-state|animation-timing-function|backface-visibility|background|background-attachment|background-blend-mode|background-clip|background-color|background-image|background-origin|background-position|background-repeat|background-size|border|border-bottom|border-bottom-color|border-bottom-left-radius|border-bottom-right-radius|border-bottom-style|border-bottom-width|border-collapse|border-color|border-image|border-image-outset|border-image-repeat|border-image-slice|border-image-source|border-image-width|border-left|border-left-color|border-left-style|border-left-width|border-radius|border-right|border-right-color|border-right-style|border-right-width|border-spacing|border-style|border-top|border-top-color|border-top-left-radius|border-top-right-radius|border-top-style|border-top-width|border-width|bottom|box-shadow|box-sizing|caption-side|clear|clip|color|column-count|column-fill|column-gap|column-rule|column-rule-color|column-rule-style|column-rule-width|column-span|column-width|columns|content|counter-increment|counter-reset|cursor|direction|display|empty-cells|filter|flex|flex-basis|flex-direction|flex-flow|flex-grow|flex-shrink|flex-wrap|float|font|font-family|font-size|font-size-adjust|font-stretch|font-style|font-variant|font-weight|hanging-punctuation|height|justify-content|left|letter-spacing|line-height|list-style|list-style-image|list-style-position|list-style-type|margin|margin-bottom|margin-left|margin-right|margin-top|max-height|max-width|min-height|min-width|nav-down|nav-index|nav-left|nav-right|nav-up|opacity|order|outline|outline-color|outline-offset|outline-style|outline-width|overflow|overflow-x|overflow-y|padding|padding-bottom|padding-left|padding-right|padding-top|page-break-after|page-break-before|page-break-inside|perspective|perspective-origin|position|quotes|resize|right|tab-size|table-layout|text-align|text-align-last|text-decoration|text-decoration-color|text-decoration-line|text-decoration-style|text-indent|text-justify|text-overflow|text-shadow|text-transform|top|transform|transform-origin|transform-style|transition|transition-delay|transition-duration|transition-property|transition-timing-function|unicode-bidi|vertical-align|visibility|white-space|width|word-break|word-spacing|word-wrap|z-index";var a=e.supportFunction="rgb|rgba|url|attr|counter|counters";var b=e.supportConstant="absolute|after-edge|after|all-scroll|all|alphabetic|always|antialiased|armenian|auto|avoid-column|avoid-page|avoid|balance|baseline|before-edge|before|below|bidi-override|block-line-height|block|bold|bolder|border-box|both|bottom|box|break-all|break-word|capitalize|caps-height|caption|center|central|char|circle|cjk-ideographic|clone|close-quote|col-resize|collapse|column|consider-shifts|contain|content-box|cover|crosshair|cubic-bezier|dashed|decimal-leading-zero|decimal|default|disabled|disc|disregard-shifts|distribute-all-lines|distribute-letter|distribute-space|distribute|dotted|double|e-resize|ease-in|ease-in-out|ease-out|ease|ellipsis|end|exclude-ruby|fill|fixed|georgian|glyphs|grid-height|groove|hand|hanging|hebrew|help|hidden|hiragana-iroha|hiragana|horizontal|icon|ideograph-alpha|ideograph-numeric|ideograph-parenthesis|ideograph-space|ideographic|inactive|include-ruby|inherit|initial|inline-block|inline-box|inline-line-height|inline-table|inline|inset|inside|inter-ideograph|inter-word|invert|italic|justify|katakana-iroha|katakana|keep-all|last|left|lighter|line-edge|line-through|line|linear|list-item|local|loose|lower-alpha|lower-greek|lower-latin|lower-roman|lowercase|lr-tb|ltr|mathematical|max-height|max-size|medium|menu|message-box|middle|move|n-resize|ne-resize|newspaper|no-change|no-close-quote|no-drop|no-open-quote|no-repeat|none|normal|not-allowed|nowrap|nw-resize|oblique|open-quote|outset|outside|overline|padding-box|page|pointer|pre-line|pre-wrap|pre|preserve-3d|progress|relative|repeat-x|repeat-y|repeat|replaced|reset-size|ridge|right|round|row-resize|rtl|s-resize|scroll|se-resize|separate|slice|small-caps|small-caption|solid|space|square|start|static|status-bar|step-end|step-start|steps|stretch|strict|sub|super|sw-resize|table-caption|table-cell|table-column-group|table-column|table-footer-group|table-header-group|table-row-group|table-row|table|tb-rl|text-after-edge|text-before-edge|text-bottom|text-size|text-top|text|thick|thin|transparent|underline|upper-alpha|upper-latin|upper-roman|uppercase|use-script|vertical-ideographic|vertical-text|visible|w-resize|wait|whitespace|z-index|zero";var c=e.supportConstantColor="aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkgrey|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkslategrey|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dimgrey|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|grey|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgray|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightslategrey|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|rebeccapurple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|slategrey|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|violet|wheat|white|whitesmoke|yellow|yellowgreen";var d=e.supportConstantFonts="arial|century|comic|courier|cursive|fantasy|garamond|georgia|helvetica|impact|lucida|symbol|system|tahoma|times|trebuchet|utopia|verdana|webdings|sans-serif|serif|monospace";var n=e.numRe="\\-?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))";var p=e.pseudoElements="(\\:+)\\b(after|before|first-letter|first-line|moz-selection|selection)\\b";var f=e.pseudoClasses="(:)\\b(active|checked|disabled|empty|enabled|first-child|first-of-type|focus|hover|indeterminate|invalid|last-child|last-of-type|link|not|nth-child|nth-last-child|nth-last-of-type|nth-of-type|only-child|only-of-type|required|root|target|valid|visited)\\b";var C=function(){var k=this.createKeywordMapper({"support.function":a,"support.constant":b,"support.type":s,"support.constant.color":c,"support.constant.fonts":d},"text",true);this.$rules={"start":[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"ruleset"},{token:"paren.rparen",regex:"\\}"},{token:"string",regex:"@",next:"media"},{token:"keyword",regex:"#[a-z0-9-_]+"},{token:"keyword",regex:"%"},{token:"variable",regex:"\\.[a-z0-9-_]+"},{token:"string",regex:":[a-z0-9-_]+"},{token:"constant.numeric",regex:n},{token:"constant",regex:"[a-z0-9-_]+"},{caseInsensitive:true}],"media":[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"start"},{token:"paren.rparen",regex:"\\}",next:"start"},{token:"string",regex:";",next:"start"},{token:"keyword",regex:"(?:media|supports|document|charset|import|namespace|media|supports|document"+"|page|font|keyframes|viewport|counter-style|font-feature-values"+"|swash|ornaments|annotation|stylistic|styleset|character-variant)"}],"comments":[{token:"comment",regex:"\\/\\*",push:[{token:"comment",regex:"\\*\\/",next:"pop"},{defaultToken:"comment"}]}],"ruleset":[{regex:"-(webkit|ms|moz|o)-",token:"text"},{token:"paren.rparen",regex:"\\}",next:"start"},{include:["strings","url","comments"]},{token:["constant.numeric","keyword"],regex:"("+n+")(ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vm|vw|%)"},{token:"constant.numeric",regex:n},{token:"constant.numeric",regex:"#[a-f0-9]{6}"},{token:"constant.numeric",regex:"#[a-f0-9]{3}"},{token:["punctuation","entity.other.attribute-name.pseudo-element.css"],regex:p},{token:["punctuation","entity.other.attribute-name.pseudo-class.css"],regex:f},{include:"url"},{token:k,regex:"\\-?[a-zA-Z_][a-zA-Z0-9_\\-]*"},{caseInsensitive:true}],url:[{token:"support.function",regex:"(?:url(:?-prefix)?|domain|regexp)\\(",push:[{token:"support.function",regex:"\\)",next:"pop"},{defaultToken:"string"}]}],strings:[{token:"string.start",regex:"'",push:[{token:"string.end",regex:"'|$",next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:true},{defaultToken:"string"}]},{token:"string.start",regex:'"',push:[{token:"string.end",regex:'"|$',next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:true},{defaultToken:"string"}]}],escapes:[{token:"constant.language.escape",regex:/\\([a-fA-F\d]{1,6}|[^a-fA-F\d])/}]};this.normalizeRules();};o.inherits(C,T);e.CssHighlightRules=C;});ace.define("ace/mode/doc_comment_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(r,e,m){"use strict";var o=r("../lib/oop");var T=r("./text_highlight_rules").TextHighlightRules;var D=function(){this.$rules={"start":[{token:"comment.doc.tag",regex:"@[\\w\\d_]+"},D.getTagRule(),{defaultToken:"comment.doc",caseInsensitive:true}]};};o.inherits(D,T);D.getTagRule=function(s){return{token:"comment.doc.tag.storage.type",regex:"\\b(?:TODO|FIXME|XXX|HACK)\\b"};};D.getStartRule=function(s){return{token:"comment.doc",regex:"\\/\\*(?=\\*)",next:s};};D.getEndRule=function(s){return{token:"comment.doc",regex:"\\*\\/",next:s};};e.DocCommentHighlightRules=D;});ace.define("ace/mode/javascript_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/doc_comment_highlight_rules","ace/mode/text_highlight_rules"],function(r,e,m){"use strict";var o=r("../lib/oop");var D=r("./doc_comment_highlight_rules").DocCommentHighlightRules;var T=r("./text_highlight_rules").TextHighlightRules;var i="[a-zA-Z\\$_\u00a1-\uffff][a-zA-Z\\d\\$_\u00a1-\uffff]*";var J=function(b){var k=this.createKeywordMapper({"variable.language":"Array|Boolean|Date|Function|Iterator|Number|Object|RegExp|String|Proxy|"+"Namespace|QName|XML|XMLList|"+"ArrayBuffer|Float32Array|Float64Array|Int16Array|Int32Array|Int8Array|"+"Uint16Array|Uint32Array|Uint8Array|Uint8ClampedArray|"+"Error|EvalError|InternalError|RangeError|ReferenceError|StopIteration|"+"SyntaxError|TypeError|URIError|"+"decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|eval|isFinite|"+"isNaN|parseFloat|parseInt|"+"JSON|Math|"+"this|arguments|prototype|window|document","keyword":"const|yield|import|get|set|async|await|"+"break|case|catch|continue|default|delete|do|else|finally|for|function|"+"if|in|of|instanceof|new|return|switch|throw|try|typeof|let|var|while|with|debugger|"+"__parent__|__count__|escape|unescape|with|__proto__|"+"class|enum|extends|super|export|implements|private|public|interface|package|protected|static","storage.type":"const|let|var|function","constant.language":"null|Infinity|NaN|undefined","support.function":"alert","constant.language.boolean":"true|false"},"identifier");var d="case|do|else|finally|in|instanceof|return|throw|try|typeof|yield|void";var f="\\\\(?:x[0-9a-fA-F]{2}|"+"u[0-9a-fA-F]{4}|"+"u{[0-9a-fA-F]{1,6}}|"+"[0-2][0-7]{0,2}|"+"3[0-7][0-7]?|"+"[4-7][0-7]?|"+".)";this.$rules={"no_regex":[D.getStartRule("doc-start"),c("no_regex"),{token:"string",regex:"'(?=.)",next:"qstring"},{token:"string",regex:'"(?=.)',next:"qqstring"},{token:"constant.numeric",regex:/0(?:[xX][0-9a-fA-F]+|[oO][0-7]+|[bB][01]+)\b/},{token:"constant.numeric",regex:/(?:\d\d*(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+\b)?/},{token:["storage.type","punctuation.operator","support.function","punctuation.operator","entity.name.function","text","keyword.operator"],regex:"("+i+")(\\.)(prototype)(\\.)("+i+")(\\s*)(=)",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+i+")(\\.)("+i+")(\\s*)(=)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+i+")(\\s*)(=)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","entity.name.function","text","paren.lparen"],regex:"("+i+")(\\.)("+i+")(\\s*)(=)(\\s*)(function)(\\s+)(\\w+)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","text","entity.name.function","text","paren.lparen"],regex:"(function)(\\s+)("+i+")(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","punctuation.operator","text","storage.type","text","paren.lparen"],regex:"("+i+")(\\s*)(:)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["text","text","storage.type","text","paren.lparen"],regex:"(:)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:"keyword",regex:"from(?=\\s*('|\"))"},{token:"keyword",regex:"(?:"+d+")\\b",next:"start"},{token:["support.constant"],regex:/that\b/},{token:["storage.type","punctuation.operator","support.function.firebug"],regex:/(console)(\.)(warn|info|log|error|time|trace|timeEnd|assert)\b/},{token:k,regex:i},{token:"punctuation.operator",regex:/[.](?![.])/,next:"property"},{token:"storage.type",regex:/=>/},{token:"keyword.operator",regex:/--|\+\+|\.{3}|===|==|=|!=|!==|<+=?|>+=?|!|&&|\|\||\?:|[!$%&*+\-~\/^]=?/,next:"start"},{token:"punctuation.operator",regex:/[?:,;.]/,next:"start"},{token:"paren.lparen",regex:/[\[({]/,next:"start"},{token:"paren.rparen",regex:/[\])}]/},{token:"comment",regex:/^#!.*$/}],property:[{token:"text",regex:"\\s+"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","entity.name.function","text","paren.lparen"],regex:"("+i+")(\\.)("+i+")(\\s*)(=)(\\s*)(function)(?:(\\s+)(\\w+))?(\\s*)(\\()",next:"function_arguments"},{token:"punctuation.operator",regex:/[.](?![.])/},{token:"support.function",regex:/(s(?:h(?:ift|ow(?:Mod(?:elessDialog|alDialog)|Help))|croll(?:X|By(?:Pages|Lines)?|Y|To)?|t(?:op|rike)|i(?:n|zeToContent|debar|gnText)|ort|u(?:p|b(?:str(?:ing)?)?)|pli(?:ce|t)|e(?:nd|t(?:Re(?:sizable|questHeader)|M(?:i(?:nutes|lliseconds)|onth)|Seconds|Ho(?:tKeys|urs)|Year|Cursor|Time(?:out)?|Interval|ZOptions|Date|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Date|FullYear)|FullYear|Active)|arch)|qrt|lice|avePreferences|mall)|h(?:ome|andleEvent)|navigate|c(?:har(?:CodeAt|At)|o(?:s|n(?:cat|textual|firm)|mpile)|eil|lear(?:Timeout|Interval)?|a(?:ptureEvents|ll)|reate(?:StyleSheet|Popup|EventObject))|t(?:o(?:GMTString|S(?:tring|ource)|U(?:TCString|pperCase)|Lo(?:caleString|werCase))|est|a(?:n|int(?:Enabled)?))|i(?:s(?:NaN|Finite)|ndexOf|talics)|d(?:isableExternalCapture|ump|etachEvent)|u(?:n(?:shift|taint|escape|watch)|pdateCommands)|j(?:oin|avaEnabled)|p(?:o(?:p|w)|ush|lugins.refresh|a(?:ddings|rse(?:Int|Float)?)|r(?:int|ompt|eference))|e(?:scape|nableExternalCapture|val|lementFromPoint|x(?:p|ec(?:Script|Command)?))|valueOf|UTC|queryCommand(?:State|Indeterm|Enabled|Value)|f(?:i(?:nd|le(?:ModifiedDate|Size|CreatedDate|UpdatedDate)|xed)|o(?:nt(?:size|color)|rward)|loor|romCharCode)|watch|l(?:ink|o(?:ad|g)|astIndexOf)|a(?:sin|nchor|cos|t(?:tachEvent|ob|an(?:2)?)|pply|lert|b(?:s|ort))|r(?:ou(?:nd|teEvents)|e(?:size(?:By|To)|calc|turnValue|place|verse|l(?:oad|ease(?:Capture|Events)))|andom)|g(?:o|et(?:ResponseHeader|M(?:i(?:nutes|lliseconds)|onth)|Se(?:conds|lection)|Hours|Year|Time(?:zoneOffset)?|Da(?:y|te)|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Da(?:y|te)|FullYear)|FullYear|A(?:ttention|llResponseHeaders)))|m(?:in|ove(?:B(?:y|elow)|To(?:Absolute)?|Above)|ergeAttributes|a(?:tch|rgins|x))|b(?:toa|ig|o(?:ld|rderWidths)|link|ack))\b(?=\()/},{token:"support.function.dom",regex:/(s(?:ub(?:stringData|mit)|plitText|e(?:t(?:NamedItem|Attribute(?:Node)?)|lect))|has(?:ChildNodes|Feature)|namedItem|c(?:l(?:ick|o(?:se|neNode))|reate(?:C(?:omment|DATASection|aption)|T(?:Head|extNode|Foot)|DocumentFragment|ProcessingInstruction|E(?:ntityReference|lement)|Attribute))|tabIndex|i(?:nsert(?:Row|Before|Cell|Data)|tem)|open|delete(?:Row|C(?:ell|aption)|T(?:Head|Foot)|Data)|focus|write(?:ln)?|a(?:dd|ppend(?:Child|Data))|re(?:set|place(?:Child|Data)|move(?:NamedItem|Child|Attribute(?:Node)?)?)|get(?:NamedItem|Element(?:sBy(?:Name|TagName|ClassName)|ById)|Attribute(?:Node)?)|blur)\b(?=\()/},{token:"support.constant",regex:/(s(?:ystemLanguage|cr(?:ipts|ollbars|een(?:X|Y|Top|Left))|t(?:yle(?:Sheets)?|atus(?:Text|bar)?)|ibling(?:Below|Above)|ource|uffixes|e(?:curity(?:Policy)?|l(?:ection|f)))|h(?:istory|ost(?:name)?|as(?:h|Focus))|y|X(?:MLDocument|SLDocument)|n(?:ext|ame(?:space(?:s|URI)|Prop))|M(?:IN_VALUE|AX_VALUE)|c(?:haracterSet|o(?:n(?:structor|trollers)|okieEnabled|lorDepth|mp(?:onents|lete))|urrent|puClass|l(?:i(?:p(?:boardData)?|entInformation)|osed|asses)|alle(?:e|r)|rypto)|t(?:o(?:olbar|p)|ext(?:Transform|Indent|Decoration|Align)|ags)|SQRT(?:1_2|2)|i(?:n(?:ner(?:Height|Width)|put)|ds|gnoreCase)|zIndex|o(?:scpu|n(?:readystatechange|Line)|uter(?:Height|Width)|p(?:sProfile|ener)|ffscreenBuffering)|NEGATIVE_INFINITY|d(?:i(?:splay|alog(?:Height|Top|Width|Left|Arguments)|rectories)|e(?:scription|fault(?:Status|Ch(?:ecked|arset)|View)))|u(?:ser(?:Profile|Language|Agent)|n(?:iqueID|defined)|pdateInterval)|_content|p(?:ixelDepth|ort|ersonalbar|kcs11|l(?:ugins|atform)|a(?:thname|dding(?:Right|Bottom|Top|Left)|rent(?:Window|Layer)?|ge(?:X(?:Offset)?|Y(?:Offset)?))|r(?:o(?:to(?:col|type)|duct(?:Sub)?|mpter)|e(?:vious|fix)))|e(?:n(?:coding|abledPlugin)|x(?:ternal|pando)|mbeds)|v(?:isibility|endor(?:Sub)?|Linkcolor)|URLUnencoded|P(?:I|OSITIVE_INFINITY)|f(?:ilename|o(?:nt(?:Size|Family|Weight)|rmName)|rame(?:s|Element)|gColor)|E|whiteSpace|l(?:i(?:stStyleType|n(?:eHeight|kColor))|o(?:ca(?:tion(?:bar)?|lName)|wsrc)|e(?:ngth|ft(?:Context)?)|a(?:st(?:M(?:odified|atch)|Index|Paren)|yer(?:s|X)|nguage))|a(?:pp(?:MinorVersion|Name|Co(?:deName|re)|Version)|vail(?:Height|Top|Width|Left)|ll|r(?:ity|guments)|Linkcolor|bove)|r(?:ight(?:Context)?|e(?:sponse(?:XML|Text)|adyState))|global|x|m(?:imeTypes|ultiline|enubar|argin(?:Right|Bottom|Top|Left))|L(?:N(?:10|2)|OG(?:10E|2E))|b(?:o(?:ttom|rder(?:Width|RightWidth|BottomWidth|Style|Color|TopWidth|LeftWidth))|ufferDepth|elow|ackground(?:Color|Image)))\b/},{token:"identifier",regex:i},{regex:"",token:"empty",next:"no_regex"}],"start":[D.getStartRule("doc-start"),c("start"),{token:"string.regexp",regex:"\\/",next:"regex"},{token:"text",regex:"\\s+|^$",next:"start"},{token:"empty",regex:"",next:"no_regex"}],"regex":[{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:"/[sxngimy]*",next:"no_regex"},{token:"invalid",regex:/\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/},{token:"constant.language.escape",regex:/\(\?[:=!]|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/},{token:"constant.language.delimiter",regex:/\|/},{token:"constant.language.escape",regex:/\[\^?/,next:"regex_character_class"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp"}],"regex_character_class":[{token:"regexp.charclass.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"constant.language.escape",regex:"]",next:"regex"},{token:"constant.language.escape",regex:"-"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp.charachterclass"}],"function_arguments":[{token:"variable.parameter",regex:i},{token:"punctuation.operator",regex:"[, ]+"},{token:"punctuation.operator",regex:"$"},{token:"empty",regex:"",next:"no_regex"}],"qqstring":[{token:"constant.language.escape",regex:f},{token:"string",regex:"\\\\$",consumeLineEnd:true},{token:"string",regex:'"|$',next:"no_regex"},{defaultToken:"string"}],"qstring":[{token:"constant.language.escape",regex:f},{token:"string",regex:"\\\\$",consumeLineEnd:true},{token:"string",regex:"'|$",next:"no_regex"},{defaultToken:"string"}]};if(!b||!b.noES6){this.$rules.no_regex.unshift({regex:"[{}]",onMatch:function(v,s,g){this.next=v=="{"?this.nextState:"";if(v=="{"&&g.length){g.unshift("start",s);}else if(v=="}"&&g.length){g.shift();this.next=g.shift();if(this.next.indexOf("string")!=-1||this.next.indexOf("jsx")!=-1)return"paren.quasi.end";}return v=="{"?"paren.lparen":"paren.rparen";},nextState:"start"},{token:"string.quasi.start",regex:/`/,push:[{token:"constant.language.escape",regex:f},{token:"paren.quasi.start",regex:/\${/,push:"start"},{token:"string.quasi.end",regex:/`/,next:"pop"},{defaultToken:"string.quasi"}]});if(!b||b.jsx!=false)a.call(this);}this.embedRules(D,"doc-",[D.getEndRule("no_regex")]);this.normalizeRules();};o.inherits(J,T);function a(){var t=i.replace("\\d","\\d\\-");var j={onMatch:function(v,s,d){var f=v.charAt(1)=="/"?2:1;if(f==1){if(s!=this.nextState)d.unshift(this.next,this.nextState,0);else d.unshift(this.next);d[2]++;}else if(f==2){if(s==this.nextState){d[1]--;if(!d[1]||d[1]<0){d.shift();d.shift();}}}return[{type:"meta.tag.punctuation."+(f==1?"":"end-")+"tag-open.xml",value:v.slice(0,f)},{type:"meta.tag.tag-name.xml",value:v.substr(f)}];},regex:"</?"+t+"",next:"jsxAttributes",nextState:"jsx"};this.$rules.start.unshift(j);var b={regex:"{",token:"paren.quasi.start",push:"start"};this.$rules.jsx=[b,j,{include:"reference"},{defaultToken:"string"}];this.$rules.jsxAttributes=[{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",onMatch:function(v,d,s){if(d==s[0])s.shift();if(v.length==2){if(s[0]==this.nextState)s[1]--;if(!s[1]||s[1]<0){s.splice(0,2);}}this.next=s[0]||"start";return[{type:this.token,value:v}];},nextState:"jsx"},b,c("jsxAttributes"),{token:"entity.other.attribute-name.xml",regex:t},{token:"keyword.operator.attribute-equals.xml",regex:"="},{token:"text.tag-whitespace.xml",regex:"\\s+"},{token:"string.attribute-value.xml",regex:"'",stateName:"jsx_attr_q",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',stateName:"jsx_attr_qq",push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},j];this.$rules.reference=[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}];}function c(n){return[{token:"comment",regex:/\/\*/,next:[D.getTagRule(),{token:"comment",regex:"\\*\\/",next:n||"pop"},{defaultToken:"comment",caseInsensitive:true}]},{token:"comment",regex:"\\/\\/",next:[D.getTagRule(),{token:"comment",regex:"$|^",next:n||"pop"},{defaultToken:"comment",caseInsensitive:true}]}];}e.JavaScriptHighlightRules=J;});ace.define("ace/mode/xml_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(r,e,m){"use strict";var o=r("../lib/oop");var T=r("./text_highlight_rules").TextHighlightRules;var X=function(n){var t="[_:a-zA-Z\xc0-\uffff][-_:.a-zA-Z0-9\xc0-\uffff]*";this.$rules={start:[{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\[",next:"cdata"},{token:["punctuation.instruction.xml","keyword.instruction.xml"],regex:"(<\\?)("+t+")",next:"processing_instruction"},{token:"comment.start.xml",regex:"<\\!--",next:"comment"},{token:["xml-pe.doctype.xml","xml-pe.doctype.xml"],regex:"(<\\!)(DOCTYPE)(?=[\\s])",next:"doctype",caseInsensitive:true},{include:"tag"},{token:"text.end-tag-open.xml",regex:"</"},{token:"text.tag-open.xml",regex:"<"},{include:"reference"},{defaultToken:"text.xml"}],processing_instruction:[{token:"entity.other.attribute-name.decl-attribute-name.xml",regex:t},{token:"keyword.operator.decl-attribute-equals.xml",regex:"="},{include:"whitespace"},{include:"string"},{token:"punctuation.xml-decl.xml",regex:"\\?>",next:"start"}],doctype:[{include:"whitespace"},{include:"string"},{token:"xml-pe.doctype.xml",regex:">",next:"start"},{token:"xml-pe.xml",regex:"[-_a-zA-Z0-9:]+"},{token:"punctuation.int-subset",regex:"\\[",push:"int_subset"}],int_subset:[{token:"text.xml",regex:"\\s+"},{token:"punctuation.int-subset.xml",regex:"]",next:"pop"},{token:["punctuation.markup-decl.xml","keyword.markup-decl.xml"],regex:"(<\\!)("+t+")",push:[{token:"text",regex:"\\s+"},{token:"punctuation.markup-decl.xml",regex:">",next:"pop"},{include:"string"}]}],cdata:[{token:"string.cdata.xml",regex:"\\]\\]>",next:"start"},{token:"text.xml",regex:"\\s+"},{token:"text.xml",regex:"(?:[^\\]]|\\](?!\\]>))+"}],comment:[{token:"comment.end.xml",regex:"-->",next:"start"},{defaultToken:"comment.xml"}],reference:[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],attr_reference:[{token:"constant.language.escape.reference.attribute-value.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],tag:[{token:["meta.tag.punctuation.tag-open.xml","meta.tag.punctuation.end-tag-open.xml","meta.tag.tag-name.xml"],regex:"(?:(<)|(</))((?:"+t+":)?"+t+")",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]}],tag_whitespace:[{token:"text.tag-whitespace.xml",regex:"\\s+"}],whitespace:[{token:"text.whitespace.xml",regex:"\\s+"}],string:[{token:"string.xml",regex:"'",push:[{token:"string.xml",regex:"'",next:"pop"},{defaultToken:"string.xml"}]},{token:"string.xml",regex:'"',push:[{token:"string.xml",regex:'"',next:"pop"},{defaultToken:"string.xml"}]}],attributes:[{token:"entity.other.attribute-name.xml",regex:t},{token:"keyword.operator.attribute-equals.xml",regex:"="},{include:"tag_whitespace"},{include:"attribute_value"}],attribute_value:[{token:"string.attribute-value.xml",regex:"'",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]}]};if(this.constructor===X)this.normalizeRules();};(function(){this.embedTagRules=function(H,p,t){this.$rules.tag.unshift({token:["meta.tag.punctuation.tag-open.xml","meta.tag."+t+".tag-name.xml"],regex:"(<)("+t+"(?=\\s|>|$))",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:p+"start"}]});this.$rules[t+"-end"]=[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start",onMatch:function(v,c,s){s.splice(0);return this.token;}}];this.embedRules(H,p,[{token:["meta.tag.punctuation.end-tag-open.xml","meta.tag."+t+".tag-name.xml"],regex:"(</)("+t+"(?=\\s|>|$))",next:t+"-end"},{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\["},{token:"string.cdata.xml",regex:"\\]\\]>"}]);};}).call(T.prototype);o.inherits(X,T);e.XmlHighlightRules=X;});ace.define("ace/mode/html_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/css_highlight_rules","ace/mode/javascript_highlight_rules","ace/mode/xml_highlight_rules"],function(r,e,m){"use strict";var o=r("../lib/oop");var l=r("../lib/lang");var C=r("./css_highlight_rules").CssHighlightRules;var J=r("./javascript_highlight_rules").JavaScriptHighlightRules;var X=r("./xml_highlight_rules").XmlHighlightRules;var t=l.createMap({a:'anchor',button:'form',form:'form',img:'image',input:'form',label:'form',option:'form',script:'script',select:'form',textarea:'form',style:'style',table:'table',tbody:'table',td:'table',tfoot:'table',th:'table',tr:'table'});var H=function(){X.call(this);this.addRules({attributes:[{include:"tag_whitespace"},{token:"entity.other.attribute-name.xml",regex:"[-_a-zA-Z0-9:.]+"},{token:"keyword.operator.attribute-equals.xml",regex:"=",push:[{include:"tag_whitespace"},{token:"string.unquoted.attribute-value.html",regex:"[^<>='\"`\\s]+",next:"pop"},{token:"empty",regex:"",next:"pop"}]},{include:"attribute_value"}],tag:[{token:function(s,a){var g=t[a];return["meta.tag.punctuation."+(s=="<"?"":"end-")+"tag-open.xml","meta.tag"+(g?"."+g:"")+".tag-name.xml"];},regex:"(</?)([-_a-zA-Z0-9:.]+)",next:"tag_stuff"}],tag_stuff:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]});this.embedTagRules(C,"css-","style");this.embedTagRules(new J({jsx:false}).getRules(),"js-","script");if(this.constructor===H)this.normalizeRules();};o.inherits(H,X);e.HtmlHighlightRules=H;});ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(r,e,m){"use strict";var R=r("../range").Range;var M=function(){};(function(){this.checkOutdent=function(l,i){if(!/^\s+$/.test(l))return false;return/^\s*\}/.test(i);};this.autoOutdent=function(d,a){var l=d.getLine(a);var b=l.match(/^(\s*\})/);if(!b)return 0;var c=b[1].length;var o=d.findMatchingBracket({row:a,column:c});if(!o||o.row==a)return 0;var i=this.$getIndent(d.getLine(o.row));d.replace(new R(a,0,a,c-1),i);};this.$getIndent=function(l){return l.match(/^\s*/)[0];};}).call(M.prototype);e.MatchingBraceOutdent=M;});ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(r,e,a){"use strict";var o=r("../../lib/oop");var R=r("../../range").Range;var B=r("./fold_mode").FoldMode;var F=e.FoldMode=function(c){if(c){this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+c.start));this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+c.end));}};o.inherits(F,B);(function(){this.foldingStartMarker=/(\{|\[)[^\}\]]*$|^\s*(\/\*)/;this.foldingStopMarker=/^[^\[\{]*(\}|\])|^[\s\*]*(\*\/)/;this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/;this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/;this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/;this._getFoldWidgetBase=this.getFoldWidget;this.getFoldWidget=function(s,f,b){var l=s.getLine(b);if(this.singleLineBlockCommentRe.test(l)){if(!this.startRegionRe.test(l)&&!this.tripleStarBlockCommentRe.test(l))return"";}var c=this._getFoldWidgetBase(s,f,b);if(!c&&this.startRegionRe.test(l))return"start";return c;};this.getFoldWidgetRange=function(s,f,b,c){var l=s.getLine(b);if(this.startRegionRe.test(l))return this.getCommentRegionBlock(s,l,b);var m=l.match(this.foldingStartMarker);if(m){var i=m.index;if(m[1])return this.openingBracketBlock(s,m[1],b,i);var d=s.getCommentFoldRange(b,i+m[0].length,1);if(d&&!d.isMultiLine()){if(c){d=this.getSectionRange(s,b);}else if(f!="all")d=null;}return d;}if(f==="markbegin")return;var m=l.match(this.foldingStopMarker);if(m){var i=m.index+m[0].length;if(m[1])return this.closingBracketBlock(s,m[1],b,i);return s.getCommentFoldRange(b,i,-1);}};this.getSectionRange=function(s,b){var l=s.getLine(b);var c=l.search(/\S/);var d=b;var f=l.length;b=b+1;var g=b;var m=s.getLength();while(++b<m){l=s.getLine(b);var i=l.search(/\S/);if(i===-1)continue;if(c>i)break;var h=this.getFoldWidgetRange(s,"all",b);if(h){if(h.start.row<=d){break;}else if(h.isMultiLine()){b=h.end.row;}else if(c==i){break;}}g=b;}return new R(d,f,g,s.getLine(g).length);};this.getCommentRegionBlock=function(s,l,b){var c=l.search(/\s*$/);var d=s.getLength();var f=b;var g=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/;var h=1;while(++b<d){l=s.getLine(b);var m=g.exec(l);if(!m)continue;if(m[1])h--;else h++;if(!h)break;}var i=b;if(i>f){return new R(f,c,i,l.length);}};}).call(F.prototype);});ace.define("ace/mode/javascript",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/javascript_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle"],function(r,e,m){"use strict";var o=r("../lib/oop");var T=r("./text").Mode;var J=r("./javascript_highlight_rules").JavaScriptHighlightRules;var M=r("./matching_brace_outdent").MatchingBraceOutdent;var W=r("../worker/worker_client").WorkerClient;var C=r("./behaviour/cstyle").CstyleBehaviour;var a=r("./folding/cstyle").FoldMode;var b=function(){this.HighlightRules=J;this.$outdent=new M();this.$behaviour=new C();this.foldingRules=new a();};o.inherits(b,T);(function(){this.lineCommentStart="//";this.blockComment={start:"/*",end:"*/"};this.$quotes={'"':'"',"'":"'","`":"`"};this.getNextLineIndent=function(s,l,t){var i=this.$getIndent(l);var c=this.getTokenizer().getLineTokens(l,s);var d=c.tokens;var f=c.state;if(d.length&&d[d.length-1].type=="comment"){return i;}if(s=="start"||s=="no_regex"){var g=l.match(/^.*(?:\bcase\b.*:|[\{\(\[])\s*$/);if(g){i+=t;}}else if(s=="doc-start"){if(f=="start"||f=="no_regex"){return"";}var g=l.match(/^\s*(\/?)\*/);if(g){if(g[1]){i+=" ";}i+="* ";}}return i;};this.checkOutdent=function(s,l,i){return this.$outdent.checkOutdent(l,i);};this.autoOutdent=function(s,d,c){this.$outdent.autoOutdent(d,c);};this.createWorker=function(s){var w=new W(["ace"],"ace/mode/javascript_worker","JavaScriptWorker");w.attachToDocument(s.getDocument());w.on("annotate",function(c){s.setAnnotations(c.data);});w.on("terminate",function(){s.clearAnnotations();});return w;};this.$id="ace/mode/javascript";}).call(b.prototype);e.Mode=b;});ace.define("ace/mode/css_completions",["require","exports","module"],function(r,e,m){"use strict";var p={"background":{"#$0":1},"background-color":{"#$0":1,"transparent":1,"fixed":1},"background-image":{"url('/$0')":1},"background-repeat":{"repeat":1,"repeat-x":1,"repeat-y":1,"no-repeat":1,"inherit":1},"background-position":{"bottom":2,"center":2,"left":2,"right":2,"top":2,"inherit":2},"background-attachment":{"scroll":1,"fixed":1},"background-size":{"cover":1,"contain":1},"background-clip":{"border-box":1,"padding-box":1,"content-box":1},"background-origin":{"border-box":1,"padding-box":1,"content-box":1},"border":{"solid $0":1,"dashed $0":1,"dotted $0":1,"#$0":1},"border-color":{"#$0":1},"border-style":{"solid":2,"dashed":2,"dotted":2,"double":2,"groove":2,"hidden":2,"inherit":2,"inset":2,"none":2,"outset":2,"ridged":2},"border-collapse":{"collapse":1,"separate":1},"bottom":{"px":1,"em":1,"%":1},"clear":{"left":1,"right":1,"both":1,"none":1},"color":{"#$0":1,"rgb(#$00,0,0)":1},"cursor":{"default":1,"pointer":1,"move":1,"text":1,"wait":1,"help":1,"progress":1,"n-resize":1,"ne-resize":1,"e-resize":1,"se-resize":1,"s-resize":1,"sw-resize":1,"w-resize":1,"nw-resize":1},"display":{"none":1,"block":1,"inline":1,"inline-block":1,"table-cell":1},"empty-cells":{"show":1,"hide":1},"float":{"left":1,"right":1,"none":1},"font-family":{"Arial":2,"Comic Sans MS":2,"Consolas":2,"Courier New":2,"Courier":2,"Georgia":2,"Monospace":2,"Sans-Serif":2,"Segoe UI":2,"Tahoma":2,"Times New Roman":2,"Trebuchet MS":2,"Verdana":1},"font-size":{"px":1,"em":1,"%":1},"font-weight":{"bold":1,"normal":1},"font-style":{"italic":1,"normal":1},"font-variant":{"normal":1,"small-caps":1},"height":{"px":1,"em":1,"%":1},"left":{"px":1,"em":1,"%":1},"letter-spacing":{"normal":1},"line-height":{"normal":1},"list-style-type":{"none":1,"disc":1,"circle":1,"square":1,"decimal":1,"decimal-leading-zero":1,"lower-roman":1,"upper-roman":1,"lower-greek":1,"lower-latin":1,"upper-latin":1,"georgian":1,"lower-alpha":1,"upper-alpha":1},"margin":{"px":1,"em":1,"%":1},"margin-right":{"px":1,"em":1,"%":1},"margin-left":{"px":1,"em":1,"%":1},"margin-top":{"px":1,"em":1,"%":1},"margin-bottom":{"px":1,"em":1,"%":1},"max-height":{"px":1,"em":1,"%":1},"max-width":{"px":1,"em":1,"%":1},"min-height":{"px":1,"em":1,"%":1},"min-width":{"px":1,"em":1,"%":1},"overflow":{"hidden":1,"visible":1,"auto":1,"scroll":1},"overflow-x":{"hidden":1,"visible":1,"auto":1,"scroll":1},"overflow-y":{"hidden":1,"visible":1,"auto":1,"scroll":1},"padding":{"px":1,"em":1,"%":1},"padding-top":{"px":1,"em":1,"%":1},"padding-right":{"px":1,"em":1,"%":1},"padding-bottom":{"px":1,"em":1,"%":1},"padding-left":{"px":1,"em":1,"%":1},"page-break-after":{"auto":1,"always":1,"avoid":1,"left":1,"right":1},"page-break-before":{"auto":1,"always":1,"avoid":1,"left":1,"right":1},"position":{"absolute":1,"relative":1,"fixed":1,"static":1},"right":{"px":1,"em":1,"%":1},"table-layout":{"fixed":1,"auto":1},"text-decoration":{"none":1,"underline":1,"line-through":1,"blink":1},"text-align":{"left":1,"right":1,"center":1,"justify":1},"text-transform":{"capitalize":1,"uppercase":1,"lowercase":1,"none":1},"top":{"px":1,"em":1,"%":1},"vertical-align":{"top":1,"bottom":1},"visibility":{"hidden":1,"visible":1},"white-space":{"nowrap":1,"normal":1,"pre":1,"pre-line":1,"pre-wrap":1},"width":{"px":1,"em":1,"%":1},"word-spacing":{"normal":1},"filter":{"alpha(opacity=$0100)":1},"text-shadow":{"$02px 2px 2px #777":1},"text-overflow":{"ellipsis-word":1,"clip":1,"ellipsis":1},"-moz-border-radius":1,"-moz-border-radius-topright":1,"-moz-border-radius-bottomright":1,"-moz-border-radius-topleft":1,"-moz-border-radius-bottomleft":1,"-webkit-border-radius":1,"-webkit-border-top-right-radius":1,"-webkit-border-top-left-radius":1,"-webkit-border-bottom-right-radius":1,"-webkit-border-bottom-left-radius":1,"-moz-box-shadow":1,"-webkit-box-shadow":1,"transform":{"rotate($00deg)":1,"skew($00deg)":1},"-moz-transform":{"rotate($00deg)":1,"skew($00deg)":1},"-webkit-transform":{"rotate($00deg)":1,"skew($00deg)":1}};var C=function(){};(function(){this.completionsDefined=false;this.defineCompletions=function(){if(document){var s=document.createElement('c').style;for(var i in s){if(typeof s[i]!=='string')continue;var n=i.replace(/[A-Z]/g,function(x){return'-'+x.toLowerCase();});if(!p.hasOwnProperty(n))p[n]=1;}}this.completionsDefined=true;};this.getCompletions=function(s,a,b,c){if(!this.completionsDefined){this.defineCompletions();}var t=a.getTokenAt(b.row,b.column);if(!t)return[];if(s==='ruleset'){var l=a.getLine(b.row).substr(0,b.column);if(/:[^;]+$/.test(l)){/([\w\-]+):[^:]*$/.test(l);return this.getPropertyValueCompletions(s,a,b,c);}else{return this.getPropertyCompletions(s,a,b,c);}}return[];};this.getPropertyCompletions=function(s,a,b,c){var d=Object.keys(p);return d.map(function(f){return{caption:f,snippet:f+': $0',meta:"property",score:Number.MAX_VALUE};});};this.getPropertyValueCompletions=function(s,a,b,c){var l=a.getLine(b.row).substr(0,b.column);var d=(/([\w\-]+):[^:]*$/.exec(l)||{})[1];if(!d)return[];var v=[];if(d in p&&typeof p[d]==="object"){v=Object.keys(p[d]);}return v.map(function(f){return{caption:f,snippet:f,meta:"property value",score:Number.MAX_VALUE};});};}).call(C.prototype);e.CssCompletions=C;});ace.define("ace/mode/behaviour/css",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/mode/behaviour/cstyle","ace/token_iterator"],function(r,e,m){"use strict";var o=r("../../lib/oop");var B=r("../behaviour").Behaviour;var C=r("./cstyle").CstyleBehaviour;var T=r("../../token_iterator").TokenIterator;var a=function(){this.inherit(C);this.add("colon","insertion",function(s,b,c,d,t){if(t===':'){var f=c.getCursorPosition();var i=new T(d,f.row,f.column);var g=i.getCurrentToken();if(g&&g.value.match(/\s+/)){g=i.stepBackward();}if(g&&g.type==='support.type'){var l=d.doc.getLine(f.row);var h=l.substring(f.column,f.column+1);if(h===':'){return{text:'',selection:[1,1]}}if(!l.substring(f.column).match(/^\s*;/)){return{text:':;',selection:[1,1]}}}}});this.add("colon","deletion",function(s,b,c,d,f){var g=d.doc.getTextRange(f);if(!f.isMultiLine()&&g===':'){var h=c.getCursorPosition();var i=new T(d,h.row,h.column);var t=i.getCurrentToken();if(t&&t.value.match(/\s+/)){t=i.stepBackward();}if(t&&t.type==='support.type'){var l=d.doc.getLine(f.start.row);var j=l.substring(f.end.column,f.end.column+1);if(j===';'){f.end.column++;return f;}}}});this.add("semicolon","insertion",function(s,b,c,d,t){if(t===';'){var f=c.getCursorPosition();var l=d.doc.getLine(f.row);var g=l.substring(f.column,f.column+1);if(g===';'){return{text:'',selection:[1,1]}}}});};o.inherits(a,C);e.CssBehaviour=a;});ace.define("ace/mode/css",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/css_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/css_completions","ace/mode/behaviour/css","ace/mode/folding/cstyle"],function(r,a,m){"use strict";var o=r("../lib/oop");var T=r("./text").Mode;var C=r("./css_highlight_rules").CssHighlightRules;var M=r("./matching_brace_outdent").MatchingBraceOutdent;var W=r("../worker/worker_client").WorkerClient;var b=r("./css_completions").CssCompletions;var c=r("./behaviour/css").CssBehaviour;var d=r("./folding/cstyle").FoldMode;var f=function(){this.HighlightRules=C;this.$outdent=new M();this.$behaviour=new c();this.$completer=new b();this.foldingRules=new d();};o.inherits(f,T);(function(){this.foldingRules="cStyle";this.blockComment={start:"/*",end:"*/"};this.getNextLineIndent=function(s,l,t){var i=this.$getIndent(l);var e=this.getTokenizer().getLineTokens(l,s).tokens;if(e.length&&e[e.length-1].type=="comment"){return i;}var g=l.match(/^.*\{\s*$/);if(g){i+=t;}return i;};this.checkOutdent=function(s,l,i){return this.$outdent.checkOutdent(l,i);};this.autoOutdent=function(s,e,g){this.$outdent.autoOutdent(e,g);};this.getCompletions=function(s,e,p,g){return this.$completer.getCompletions(s,e,p,g);};this.createWorker=function(s){var w=new W(["ace"],"ace/mode/css_worker","Worker");w.attachToDocument(s.getDocument());w.on("annotate",function(e){s.setAnnotations(e.data);});w.on("terminate",function(){s.clearAnnotations();});return w;};this.$id="ace/mode/css";}).call(f.prototype);a.Mode=f;});ace.define("ace/mode/behaviour/xml",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],function(r,e,m){"use strict";var o=r("../../lib/oop");var B=r("../behaviour").Behaviour;var T=r("../../token_iterator").TokenIterator;var l=r("../../lib/lang");function i(t,a){return t.type.lastIndexOf(a+".xml")>-1;}var X=function(){this.add("string_dquotes","insertion",function(s,a,b,c,t){if(t=='"'||t=="'"){var q=t;var d=c.doc.getTextRange(b.getSelectionRange());if(d!==""&&d!=="'"&&d!='"'&&b.getWrapBehavioursEnabled()){return{text:q+d+q,selection:false};}var f=b.getCursorPosition();var g=c.doc.getLine(f.row);var h=g.substring(f.column,f.column+1);var j=new T(c,f.row,f.column);var k=j.getCurrentToken();if(h==q&&(i(k,"attribute-value")||i(k,"string"))){return{text:"",selection:[1,1]};}if(!k)k=j.stepBackward();if(!k)return;while(i(k,"tag-whitespace")||i(k,"whitespace")){k=j.stepBackward();}var n=!h||h.match(/\s/);if(i(k,"attribute-equals")&&(n||h=='>')||(i(k,"decl-attribute-equals")&&(n||h=='?'))){return{text:q+q,selection:[1,1]};}}});this.add("string_dquotes","deletion",function(s,a,b,c,d){var f=c.doc.getTextRange(d);if(!d.isMultiLine()&&(f=='"'||f=="'")){var g=c.doc.getLine(d.start.row);var h=g.substring(d.start.column+1,d.start.column+2);if(h==f){d.end.column++;return d;}}});this.add("autoclosing","insertion",function(s,a,b,c,t){if(t=='>'){var p=b.getSelectionRange().start;var d=new T(c,p.row,p.column);var f=d.getCurrentToken()||d.stepBackward();if(!f||!(i(f,"tag-name")||i(f,"tag-whitespace")||i(f,"attribute-name")||i(f,"attribute-equals")||i(f,"attribute-value")))return;if(i(f,"reference.attribute-value"))return;if(i(f,"attribute-value")){var g=f.value.charAt(0);if(g=='"'||g=="'"){var h=f.value.charAt(f.value.length-1);var j=d.getCurrentTokenColumn()+f.value.length;if(j>p.column||j==p.column&&g!=h)return;}}while(!i(f,"tag-name")){f=d.stepBackward();if(f.value=="<"){f=d.stepForward();break;}}var k=d.getCurrentTokenRow();var n=d.getCurrentTokenColumn();if(i(d.stepBackward(),"end-tag-open"))return;var q=f.value;if(k==p.row)q=q.substring(0,p.column-n);if(this.voidElements.hasOwnProperty(q.toLowerCase()))return;return{text:">"+"</"+q+">",selection:[1,1]};}});this.add("autoindent","insertion",function(s,a,b,c,t){if(t=="\n"){var d=b.getCursorPosition();var f=c.getLine(d.row);var g=new T(c,d.row,d.column);var h=g.getCurrentToken();if(h&&h.type.indexOf("tag-close")!==-1){if(h.value=="/>")return;while(h&&h.type.indexOf("tag-name")===-1){h=g.stepBackward();}if(!h){return;}var j=h.value;var k=g.getCurrentTokenRow();h=g.stepBackward();if(!h||h.type.indexOf("end-tag")!==-1){return;}if(this.voidElements&&!this.voidElements[j]){var n=c.getTokenAt(d.row,d.column+1);var f=c.getLine(k);var p=this.$getIndent(f);var q=p+c.getTabString();if(n&&n.value==="</"){return{text:"\n"+q+"\n"+p,selection:[1,q.length,1,q.length]};}else{return{text:"\n"+q};}}}}});};o.inherits(X,B);e.XmlBehaviour=X;});ace.define("ace/mode/folding/mixed",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode"],function(r,e,m){"use strict";var o=r("../../lib/oop");var B=r("./fold_mode").FoldMode;var F=e.FoldMode=function(d,s){this.defaultMode=d;this.subModes=s;};o.inherits(F,B);(function(){this.$getMode=function(s){if(typeof s!="string")s=s[0];for(var k in this.subModes){if(s.indexOf(k)===0)return this.subModes[k];}return null;};this.$tryMode=function(s,a,f,b){var c=this.$getMode(s);return(c?c.getFoldWidget(a,f,b):"");};this.getFoldWidget=function(s,f,a){return(this.$tryMode(s.getState(a-1),s,f,a)||this.$tryMode(s.getState(a),s,f,a)||this.defaultMode.getFoldWidget(s,f,a));};this.getFoldWidgetRange=function(s,f,a){var b=this.$getMode(s.getState(a-1));if(!b||!b.getFoldWidget(s,f,a))b=this.$getMode(s.getState(a));if(!b||!b.getFoldWidget(s,f,a))b=this.defaultMode;return b.getFoldWidgetRange(s,f,a);};}).call(F.prototype);});ace.define("ace/mode/folding/xml",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/range","ace/mode/folding/fold_mode","ace/token_iterator"],function(r,e,m){"use strict";var o=r("../../lib/oop");var l=r("../../lib/lang");var R=r("../../range").Range;var B=r("./fold_mode").FoldMode;var T=r("../../token_iterator").TokenIterator;var F=e.FoldMode=function(v,c){B.call(this);this.voidElements=v||{};this.optionalEndTags=o.mixin({},this.voidElements);if(c)o.mixin(this.optionalEndTags,c);};o.inherits(F,B);var a=function(){this.tagName="";this.closing=false;this.selfClosing=false;this.start={row:0,column:0};this.end={row:0,column:0};};function b(t,c){return t.type.lastIndexOf(c+".xml")>-1;}(function(){this.getFoldWidget=function(s,f,c){var t=this._getFirstTagInLine(s,c);if(!t)return this.getCommentFoldWidget(s,c);if(t.closing||(!t.tagName&&t.selfClosing))return f=="markbeginend"?"end":"";if(!t.tagName||t.selfClosing||this.voidElements.hasOwnProperty(t.tagName.toLowerCase()))return"";if(this._findEndTagInLine(s,c,t.tagName,t.end.column))return"";return"start";};this.getCommentFoldWidget=function(s,c){if(/comment/.test(s.getState(c))&&/<!-/.test(s.getLine(c)))return"start";return"";};this._getFirstTagInLine=function(s,c){var t=s.getTokens(c);var d=new a();for(var i=0;i<t.length;i++){var f=t[i];if(b(f,"tag-open")){d.end.column=d.start.column+f.value.length;d.closing=b(f,"end-tag-open");f=t[++i];if(!f)return null;d.tagName=f.value;d.end.column+=f.value.length;for(i++;i<t.length;i++){f=t[i];d.end.column+=f.value.length;if(b(f,"tag-close")){d.selfClosing=f.value=='/>';break;}}return d;}else if(b(f,"tag-close")){d.selfClosing=f.value=='/>';return d;}d.start.column+=f.value.length;}return null;};this._findEndTagInLine=function(s,c,t,d){var f=s.getTokens(c);var g=0;for(var i=0;i<f.length;i++){var h=f[i];g+=h.value.length;if(g<d)continue;if(b(h,"end-tag-open")){h=f[i+1];if(h&&h.value==t)return true;}}return false;};this._readTagForward=function(i){var t=i.getCurrentToken();if(!t)return null;var c=new a();do{if(b(t,"tag-open")){c.closing=b(t,"end-tag-open");c.start.row=i.getCurrentTokenRow();c.start.column=i.getCurrentTokenColumn();}else if(b(t,"tag-name")){c.tagName=t.value;}else if(b(t,"tag-close")){c.selfClosing=t.value=="/>";c.end.row=i.getCurrentTokenRow();c.end.column=i.getCurrentTokenColumn()+t.value.length;i.stepForward();return c;}}while(t=i.stepForward());return null;};this._readTagBackward=function(i){var t=i.getCurrentToken();if(!t)return null;var c=new a();do{if(b(t,"tag-open")){c.closing=b(t,"end-tag-open");c.start.row=i.getCurrentTokenRow();c.start.column=i.getCurrentTokenColumn();i.stepBackward();return c;}else if(b(t,"tag-name")){c.tagName=t.value;}else if(b(t,"tag-close")){c.selfClosing=t.value=="/>";c.end.row=i.getCurrentTokenRow();c.end.column=i.getCurrentTokenColumn()+t.value.length;}}while(t=i.stepBackward());return null;};this._pop=function(s,t){while(s.length){var c=s[s.length-1];if(!t||c.tagName==t.tagName){return s.pop();}else if(this.optionalEndTags.hasOwnProperty(c.tagName)){s.pop();continue;}else{return null;}}};this.getFoldWidgetRange=function(s,f,c){var d=this._getFirstTagInLine(s,c);if(!d){return this.getCommentFoldWidget(s,c)&&s.getCommentFoldRange(c,s.getLine(c).length);}var i=d.closing||d.selfClosing;var g=[];var t;if(!i){var h=new T(s,c,d.start.column);var j={row:c,column:d.start.column+d.tagName.length+2};if(d.start.row==d.end.row)j.column=d.end.column;while(t=this._readTagForward(h)){if(t.selfClosing){if(!g.length){t.start.column+=t.tagName.length+2;t.end.column-=2;return R.fromPoints(t.start,t.end);}else continue;}if(t.closing){this._pop(g,t);if(g.length==0)return R.fromPoints(j,t.start);}else{g.push(t);}}}else{var h=new T(s,c,d.end.column);var k={row:c,column:d.start.column};while(t=this._readTagBackward(h)){if(t.selfClosing){if(!g.length){t.start.column+=t.tagName.length+2;t.end.column-=2;return R.fromPoints(t.start,t.end);}else continue;}if(!t.closing){this._pop(g,t);if(g.length==0){t.start.column+=t.tagName.length+2;if(t.start.row==t.end.row&&t.start.column<t.end.column)t.start.column=t.end.column;return R.fromPoints(t.start,k);}}else{g.push(t);}}}};}).call(F.prototype);});ace.define("ace/mode/folding/html",["require","exports","module","ace/lib/oop","ace/mode/folding/mixed","ace/mode/folding/xml","ace/mode/folding/cstyle"],function(r,e,m){"use strict";var o=r("../../lib/oop");var M=r("./mixed").FoldMode;var X=r("./xml").FoldMode;var C=r("./cstyle").FoldMode;var F=e.FoldMode=function(v,a){M.call(this,new X(v,a),{"js-":new C(),"css-":new C()});};o.inherits(F,M);});ace.define("ace/mode/html_completions",["require","exports","module","ace/token_iterator"],function(r,e,m){"use strict";var T=r("../token_iterator").TokenIterator;var c=["accesskey","class","contenteditable","contextmenu","dir","draggable","dropzone","hidden","id","inert","itemid","itemprop","itemref","itemscope","itemtype","lang","spellcheck","style","tabindex","title","translate"];var a=["onabort","onblur","oncancel","oncanplay","oncanplaythrough","onchange","onclick","onclose","oncontextmenu","oncuechange","ondblclick","ondrag","ondragend","ondragenter","ondragleave","ondragover","ondragstart","ondrop","ondurationchange","onemptied","onended","onerror","onfocus","oninput","oninvalid","onkeydown","onkeypress","onkeyup","onload","onloadeddata","onloadedmetadata","onloadstart","onmousedown","onmousemove","onmouseout","onmouseover","onmouseup","onmousewheel","onpause","onplay","onplaying","onprogress","onratechange","onreset","onscroll","onseeked","onseeking","onselect","onshow","onstalled","onsubmit","onsuspend","ontimeupdate","onvolumechange","onwaiting"];var g=c.concat(a);var b={"html":{"manifest":1},"head":{},"title":{},"base":{"href":1,"target":1},"link":{"href":1,"hreflang":1,"rel":{"stylesheet":1,"icon":1},"media":{"all":1,"screen":1,"print":1},"type":{"text/css":1,"image/png":1,"image/jpeg":1,"image/gif":1},"sizes":1},"meta":{"http-equiv":{"content-type":1},"name":{"description":1,"keywords":1},"content":{"text/html; charset=UTF-8":1},"charset":1},"style":{"type":1,"media":{"all":1,"screen":1,"print":1},"scoped":1},"script":{"charset":1,"type":{"text/javascript":1},"src":1,"defer":1,"async":1},"noscript":{"href":1},"body":{"onafterprint":1,"onbeforeprint":1,"onbeforeunload":1,"onhashchange":1,"onmessage":1,"onoffline":1,"onpopstate":1,"onredo":1,"onresize":1,"onstorage":1,"onundo":1,"onunload":1},"section":{},"nav":{},"article":{"pubdate":1},"aside":{},"h1":{},"h2":{},"h3":{},"h4":{},"h5":{},"h6":{},"header":{},"footer":{},"address":{},"main":{},"p":{},"hr":{},"pre":{},"blockquote":{"cite":1},"ol":{"start":1,"reversed":1},"ul":{},"li":{"value":1},"dl":{},"dt":{},"dd":{},"figure":{},"figcaption":{},"div":{},"a":{"href":1,"target":{"_blank":1,"top":1},"ping":1,"rel":{"nofollow":1,"alternate":1,"author":1,"bookmark":1,"help":1,"license":1,"next":1,"noreferrer":1,"prefetch":1,"prev":1,"search":1,"tag":1},"media":1,"hreflang":1,"type":1},"em":{},"strong":{},"small":{},"s":{},"cite":{},"q":{"cite":1},"dfn":{},"abbr":{},"data":{},"time":{"datetime":1},"code":{},"var":{},"samp":{},"kbd":{},"sub":{},"sup":{},"i":{},"b":{},"u":{},"mark":{},"ruby":{},"rt":{},"rp":{},"bdi":{},"bdo":{},"span":{},"br":{},"wbr":{},"ins":{"cite":1,"datetime":1},"del":{"cite":1,"datetime":1},"img":{"alt":1,"src":1,"height":1,"width":1,"usemap":1,"ismap":1},"iframe":{"name":1,"src":1,"height":1,"width":1,"sandbox":{"allow-same-origin":1,"allow-top-navigation":1,"allow-forms":1,"allow-scripts":1},"seamless":{"seamless":1}},"embed":{"src":1,"height":1,"width":1,"type":1},"object":{"param":1,"data":1,"type":1,"height":1,"width":1,"usemap":1,"name":1,"form":1,"classid":1},"param":{"name":1,"value":1},"video":{"src":1,"autobuffer":1,"autoplay":{"autoplay":1},"loop":{"loop":1},"controls":{"controls":1},"width":1,"height":1,"poster":1,"muted":{"muted":1},"preload":{"auto":1,"metadata":1,"none":1}},"audio":{"src":1,"autobuffer":1,"autoplay":{"autoplay":1},"loop":{"loop":1},"controls":{"controls":1},"muted":{"muted":1},"preload":{"auto":1,"metadata":1,"none":1}},"source":{"src":1,"type":1,"media":1},"track":{"kind":1,"src":1,"srclang":1,"label":1,"default":1},"canvas":{"width":1,"height":1},"map":{"name":1},"area":{"shape":1,"coords":1,"href":1,"hreflang":1,"alt":1,"target":1,"media":1,"rel":1,"ping":1,"type":1},"svg":{},"math":{},"table":{"summary":1},"caption":{},"colgroup":{"span":1},"col":{"span":1},"tbody":{},"thead":{},"tfoot":{},"tr":{},"td":{"headers":1,"rowspan":1,"colspan":1},"th":{"headers":1,"rowspan":1,"colspan":1,"scope":1},"form":{"accept-charset":1,"action":1,"autocomplete":1,"enctype":{"multipart/form-data":1,"application/x-www-form-urlencoded":1},"method":{"get":1,"post":1},"name":1,"novalidate":1,"target":{"_blank":1,"top":1}},"fieldset":{"disabled":1,"form":1,"name":1},"legend":{},"label":{"form":1,"for":1},"input":{"type":{"text":1,"password":1,"hidden":1,"checkbox":1,"submit":1,"radio":1,"file":1,"button":1,"reset":1,"image":31,"color":1,"date":1,"datetime":1,"datetime-local":1,"email":1,"month":1,"number":1,"range":1,"search":1,"tel":1,"time":1,"url":1,"week":1},"accept":1,"alt":1,"autocomplete":{"on":1,"off":1},"autofocus":{"autofocus":1},"checked":{"checked":1},"disabled":{"disabled":1},"form":1,"formaction":1,"formenctype":{"application/x-www-form-urlencoded":1,"multipart/form-data":1,"text/plain":1},"formmethod":{"get":1,"post":1},"formnovalidate":{"formnovalidate":1},"formtarget":{"_blank":1,"_self":1,"_parent":1,"_top":1},"height":1,"list":1,"max":1,"maxlength":1,"min":1,"multiple":{"multiple":1},"name":1,"pattern":1,"placeholder":1,"readonly":{"readonly":1},"required":{"required":1},"size":1,"src":1,"step":1,"width":1,"files":1,"value":1},"button":{"autofocus":1,"disabled":{"disabled":1},"form":1,"formaction":1,"formenctype":1,"formmethod":1,"formnovalidate":1,"formtarget":1,"name":1,"value":1,"type":{"button":1,"submit":1}},"select":{"autofocus":1,"disabled":1,"form":1,"multiple":{"multiple":1},"name":1,"size":1,"readonly":{"readonly":1}},"datalist":{},"optgroup":{"disabled":1,"label":1},"option":{"disabled":1,"selected":1,"label":1,"value":1},"textarea":{"autofocus":{"autofocus":1},"disabled":{"disabled":1},"form":1,"maxlength":1,"name":1,"placeholder":1,"readonly":{"readonly":1},"required":{"required":1},"rows":1,"cols":1,"wrap":{"on":1,"off":1,"hard":1,"soft":1}},"keygen":{"autofocus":1,"challenge":{"challenge":1},"disabled":{"disabled":1},"form":1,"keytype":{"rsa":1,"dsa":1,"ec":1},"name":1},"output":{"for":1,"form":1,"name":1},"progress":{"value":1,"max":1},"meter":{"value":1,"min":1,"max":1,"low":1,"high":1,"optimum":1},"details":{"open":1},"summary":{},"command":{"type":1,"label":1,"icon":1,"disabled":1,"checked":1,"radiogroup":1,"command":1},"menu":{"type":1,"label":1},"dialog":{"open":1}};var d=Object.keys(b);function i(t,j){return t.type.lastIndexOf(j+".xml")>-1;}function f(s,p){var j=new T(s,p.row,p.column);var t=j.getCurrentToken();while(t&&!i(t,"tag-name")){t=j.stepBackward();}if(t)return t.value;}function h(s,p){var j=new T(s,p.row,p.column);var t=j.getCurrentToken();while(t&&!i(t,"attribute-name")){t=j.stepBackward();}if(t)return t.value;}var H=function(){};(function(){this.getCompletions=function(s,j,p,k){var t=j.getTokenAt(p.row,p.column);if(!t)return[];if(i(t,"tag-name")||i(t,"tag-open")||i(t,"end-tag-open"))return this.getTagCompletions(s,j,p,k);if(i(t,"tag-whitespace")||i(t,"attribute-name"))return this.getAttributeCompletions(s,j,p,k);if(i(t,"attribute-value"))return this.getAttributeValueCompletions(s,j,p,k);var l=j.getLine(p.row).substr(0,p.column);if(/&[a-z]*$/i.test(l))return this.getHTMLEntityCompletions(s,j,p,k);return[];};this.getTagCompletions=function(s,j,p,k){return d.map(function(l){return{value:l,meta:"tag",score:Number.MAX_VALUE};});};this.getAttributeCompletions=function(s,j,p,k){var t=f(j,p);if(!t)return[];var l=g;if(t in b){l=l.concat(Object.keys(b[t]));}return l.map(function(n){return{caption:n,snippet:n+'="$0"',meta:"attribute",score:Number.MAX_VALUE};});};this.getAttributeValueCompletions=function(s,j,p,k){var t=f(j,p);var l=h(j,p);if(!t)return[];var v=[];if(t in b&&l in b[t]&&typeof b[t][l]==="object"){v=Object.keys(b[t][l]);}return v.map(function(n){return{caption:n,snippet:n,meta:"attribute value",score:Number.MAX_VALUE};});};this.getHTMLEntityCompletions=function(s,j,p,k){var v=['Aacute;','aacute;','Acirc;','acirc;','acute;','AElig;','aelig;','Agrave;','agrave;','alefsym;','Alpha;','alpha;','amp;','and;','ang;','Aring;','aring;','asymp;','Atilde;','atilde;','Auml;','auml;','bdquo;','Beta;','beta;','brvbar;','bull;','cap;','Ccedil;','ccedil;','cedil;','cent;','Chi;','chi;','circ;','clubs;','cong;','copy;','crarr;','cup;','curren;','Dagger;','dagger;','dArr;','darr;','deg;','Delta;','delta;','diams;','divide;','Eacute;','eacute;','Ecirc;','ecirc;','Egrave;','egrave;','empty;','emsp;','ensp;','Epsilon;','epsilon;','equiv;','Eta;','eta;','ETH;','eth;','Euml;','euml;','euro;','exist;','fnof;','forall;','frac12;','frac14;','frac34;','frasl;','Gamma;','gamma;','ge;','gt;','hArr;','harr;','hearts;','hellip;','Iacute;','iacute;','Icirc;','icirc;','iexcl;','Igrave;','igrave;','image;','infin;','int;','Iota;','iota;','iquest;','isin;','Iuml;','iuml;','Kappa;','kappa;','Lambda;','lambda;','lang;','laquo;','lArr;','larr;','lceil;','ldquo;','le;','lfloor;','lowast;','loz;','lrm;','lsaquo;','lsquo;','lt;','macr;','mdash;','micro;','middot;','minus;','Mu;','mu;','nabla;','nbsp;','ndash;','ne;','ni;','not;','notin;','nsub;','Ntilde;','ntilde;','Nu;','nu;','Oacute;','oacute;','Ocirc;','ocirc;','OElig;','oelig;','Ograve;','ograve;','oline;','Omega;','omega;','Omicron;','omicron;','oplus;','or;','ordf;','ordm;','Oslash;','oslash;','Otilde;','otilde;','otimes;','Ouml;','ouml;','para;','part;','permil;','perp;','Phi;','phi;','Pi;','pi;','piv;','plusmn;','pound;','Prime;','prime;','prod;','prop;','Psi;','psi;','quot;','radic;','rang;','raquo;','rArr;','rarr;','rceil;','rdquo;','real;','reg;','rfloor;','Rho;','rho;','rlm;','rsaquo;','rsquo;','sbquo;','Scaron;','scaron;','sdot;','sect;','shy;','Sigma;','sigma;','sigmaf;','sim;','spades;','sub;','sube;','sum;','sup;','sup1;','sup2;','sup3;','supe;','szlig;','Tau;','tau;','there4;','Theta;','theta;','thetasym;','thinsp;','THORN;','thorn;','tilde;','times;','trade;','Uacute;','uacute;','uArr;','uarr;','Ucirc;','ucirc;','Ugrave;','ugrave;','uml;','upsih;','Upsilon;','upsilon;','Uuml;','uuml;','weierp;','Xi;','xi;','Yacute;','yacute;','yen;','Yuml;','yuml;','Zeta;','zeta;','zwj;','zwnj;'];return v.map(function(l){return{caption:l,snippet:l,meta:"html entity",score:Number.MAX_VALUE};});};}).call(H.prototype);e.HtmlCompletions=H;});ace.define("ace/mode/html",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text","ace/mode/javascript","ace/mode/css","ace/mode/html_highlight_rules","ace/mode/behaviour/xml","ace/mode/folding/html","ace/mode/html_completions","ace/worker/worker_client"],function(r,a,m){"use strict";var o=r("../lib/oop");var l=r("../lib/lang");var T=r("./text").Mode;var J=r("./javascript").Mode;var C=r("./css").Mode;var H=r("./html_highlight_rules").HtmlHighlightRules;var X=r("./behaviour/xml").XmlBehaviour;var b=r("./folding/html").FoldMode;var c=r("./html_completions").HtmlCompletions;var W=r("../worker/worker_client").WorkerClient;var v=["area","base","br","col","embed","hr","img","input","keygen","link","meta","menuitem","param","source","track","wbr"];var d=["li","dt","dd","p","rt","rp","optgroup","option","colgroup","td","th"];var M=function(e){this.fragmentContext=e&&e.fragmentContext;this.HighlightRules=H;this.$behaviour=new X();this.$completer=new c();this.createModeDelegates({"js-":J,"css-":C});this.foldingRules=new b(this.voidElements,l.arrayToMap(d));};o.inherits(M,T);(function(){this.blockComment={start:"<!--",end:"-->"};this.voidElements=l.arrayToMap(v);this.getNextLineIndent=function(s,e,t){return this.$getIndent(e);};this.checkOutdent=function(s,e,i){return false;};this.getCompletions=function(s,e,p,f){return this.$completer.getCompletions(s,e,p,f);};this.createWorker=function(s){if(this.constructor!=M)return;var w=new W(["ace"],"ace/mode/html_worker","Worker");w.attachToDocument(s.getDocument());if(this.fragmentContext)w.call("setOptions",[{context:this.fragmentContext}]);w.on("error",function(e){s.setAnnotations(e.data);});w.on("terminate",function(){s.clearAnnotations();});return w;};this.$id="ace/mode/html";}).call(M.prototype);a.Mode=M;});ace.define("ace/mode/ruby_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(r,e,m){"use strict";var o=r("../lib/oop");var T=r("./text_highlight_rules").TextHighlightRules;var c=e.constantOtherSymbol={token:"constant.other.symbol.ruby",regex:"[:](?:[A-Za-z_]|[@$](?=[a-zA-Z0-9_]))[a-zA-Z0-9_]*[!=?]?"};var q=e.qString={token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"};var a=e.qqString={token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'};var t=e.tString={token:"string",regex:"[`](?:(?:\\\\.)|(?:[^'\\\\]))*?[`]"};var b=e.constantNumericHex={token:"constant.numeric",regex:"0[xX][0-9a-fA-F](?:[0-9a-fA-F]|_(?=[0-9a-fA-F]))*\\b"};var d=e.constantNumericFloat={token:"constant.numeric",regex:"[+-]?\\d(?:\\d|_(?=\\d))*(?:(?:\\.\\d(?:\\d|_(?=\\d))*)?(?:[eE][+-]?\\d+)?)?\\b"};var i=e.instanceVariable={token:"variable.instance",regex:"@{1,2}[a-zA-Z_\\d]+"};var R=function(){var f=("abort|Array|assert|assert_equal|assert_not_equal|assert_same|assert_not_same|"+"assert_nil|assert_not_nil|assert_match|assert_no_match|assert_in_delta|assert_throws|"+"assert_raise|assert_nothing_raised|assert_instance_of|assert_kind_of|assert_respond_to|"+"assert_operator|assert_send|assert_difference|assert_no_difference|assert_recognizes|"+"assert_generates|assert_response|assert_redirected_to|assert_template|assert_select|"+"assert_select_email|assert_select_rjs|assert_select_encoded|css_select|at_exit|"+"attr|attr_writer|attr_reader|attr_accessor|attr_accessible|autoload|binding|block_given?|callcc|"+"caller|catch|chomp|chomp!|chop|chop!|defined?|delete_via_redirect|eval|exec|exit|"+"exit!|fail|Float|flunk|follow_redirect!|fork|form_for|form_tag|format|gets|global_variables|gsub|"+"gsub!|get_via_redirect|host!|https?|https!|include|Integer|lambda|link_to|"+"link_to_unless_current|link_to_function|link_to_remote|load|local_variables|loop|open|open_session|"+"p|print|printf|proc|putc|puts|post_via_redirect|put_via_redirect|raise|rand|"+"raw|readline|readlines|redirect?|request_via_redirect|require|scan|select|"+"set_trace_func|sleep|split|sprintf|srand|String|stylesheet_link_tag|syscall|system|sub|sub!|test|"+"throw|trace_var|trap|untrace_var|atan2|cos|exp|frexp|ldexp|log|log10|sin|sqrt|tan|"+"render|javascript_include_tag|csrf_meta_tag|label_tag|text_field_tag|submit_tag|check_box_tag|"+"content_tag|radio_button_tag|text_area_tag|password_field_tag|hidden_field_tag|"+"fields_for|select_tag|options_for_select|options_from_collection_for_select|collection_select|"+"time_zone_select|select_date|select_time|select_datetime|date_select|time_select|datetime_select|"+"select_year|select_month|select_day|select_hour|select_minute|select_second|file_field_tag|"+"file_field|respond_to|skip_before_filter|around_filter|after_filter|verify|"+"protect_from_forgery|rescue_from|helper_method|redirect_to|before_filter|"+"send_data|send_file|validates_presence_of|validates_uniqueness_of|validates_length_of|"+"validates_format_of|validates_acceptance_of|validates_associated|validates_exclusion_of|"+"validates_inclusion_of|validates_numericality_of|validates_with|validates_each|"+"authenticate_or_request_with_http_basic|authenticate_or_request_with_http_digest|"+"filter_parameter_logging|match|get|post|resources|redirect|scope|assert_routing|"+"translate|localize|extract_locale_from_tld|caches_page|expire_page|caches_action|expire_action|"+"cache|expire_fragment|expire_cache_for|observe|cache_sweeper|"+"has_many|has_one|belongs_to|has_and_belongs_to_many");var k=("alias|and|BEGIN|begin|break|case|class|def|defined|do|else|elsif|END|end|ensure|"+"__FILE__|finally|for|gem|if|in|__LINE__|module|next|not|or|private|protected|public|"+"redo|rescue|retry|return|super|then|undef|unless|until|when|while|yield");var g=("true|TRUE|false|FALSE|nil|NIL|ARGF|ARGV|DATA|ENV|RUBY_PLATFORM|RUBY_RELEASE_DATE|"+"RUBY_VERSION|STDERR|STDIN|STDOUT|TOPLEVEL_BINDING");var h=("$DEBUG|$defout|$FILENAME|$LOAD_PATH|$SAFE|$stdin|$stdout|$stderr|$VERBOSE|"+"$!|root_url|flash|session|cookies|params|request|response|logger|self");var j=this.$keywords=this.createKeywordMapper({"keyword":k,"constant.language":g,"variable.language":h,"support.function":f,"invalid.deprecated":"debugger"},"identifier");this.$rules={"start":[{token:"comment",regex:"#.*$"},{token:"comment",regex:"^=begin(?:$|\\s.*$)",next:"comment"},{token:"string.regexp",regex:"[/](?:(?:\\[(?:\\\\]|[^\\]])+\\])|(?:\\\\/|[^\\]/]))*[/]\\w*\\s*(?=[).,;]|$)"},[{regex:"[{}]",onMatch:function(v,s,l){this.next=v=="{"?this.nextState:"";if(v=="{"&&l.length){l.unshift("start",s);return"paren.lparen";}if(v=="}"&&l.length){l.shift();this.next=l.shift();if(this.next.indexOf("string")!=-1)return"paren.end";}return v=="{"?"paren.lparen":"paren.rparen";},nextState:"start"},{token:"string.start",regex:/"/,push:[{token:"constant.language.escape",regex:/\\(?:[nsrtvfbae'"\\]|c.|C-.|M-.(?:\\C-.)?|[0-7]{3}|x[\da-fA-F]{2}|u[\da-fA-F]{4})/},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/"/,next:"pop"},{defaultToken:"string"}]},{token:"string.start",regex:/`/,push:[{token:"constant.language.escape",regex:/\\(?:[nsrtvfbae'"\\]|c.|C-.|M-.(?:\\C-.)?|[0-7]{3}|x[\da-fA-F]{2}|u[\da-fA-F]{4})/},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/`/,next:"pop"},{defaultToken:"string"}]},{token:"string.start",regex:/'/,push:[{token:"constant.language.escape",regex:/\\['\\]/},{token:"string.end",regex:/'/,next:"pop"},{defaultToken:"string"}]}],{token:"text",regex:"::"},{token:"variable.instance",regex:"@{1,2}[a-zA-Z_\\d]+"},{token:"support.class",regex:"[A-Z][a-zA-Z_\\d]+"},c,b,d,{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:j,regex:"[a-zA-Z_$][a-zA-Z0-9_$]*\\b"},{token:"punctuation.separator.key-value",regex:"=>"},{stateName:"heredoc",onMatch:function(v,l,s){var n=v[2]=='-'?"indentedHeredoc":"heredoc";var p=v.split(this.splitRegex);s.push(n,p[3]);return[{type:"constant",value:p[1]},{type:"string",value:p[2]},{type:"support.class",value:p[3]},{type:"string",value:p[4]}];},regex:"(<<-?)(['\"`]?)([\\w]+)(['\"`]?)",rules:{heredoc:[{onMatch:function(v,l,s){if(v===s[1]){s.shift();s.shift();this.next=s[0]||"start";return"support.class";}this.next="";return"string";},regex:".*$",next:"start"}],indentedHeredoc:[{token:"string",regex:"^ +"},{onMatch:function(v,l,s){if(v===s[1]){s.shift();s.shift();this.next=s[0]||"start";return"support.class";}this.next="";return"string";},regex:".*$",next:"start"}]}},{regex:"$",token:"empty",next:function(l,s){if(s[0]==="heredoc"||s[0]==="indentedHeredoc")return s[0];return l;}},{token:"string.character",regex:"\\B\\?."},{token:"keyword.operator",regex:"!|\\$|%|&|\\*|\\-\\-|\\-|\\+\\+|\\+|~|===|==|=|!=|!==|<=|>=|<<=|>>=|>>>=|<>|<|>|!|&&|\\|\\||\\?\\:|\\*=|%=|\\+=|\\-=|&=|\\^=|\\b(?:in|instanceof|new|delete|typeof|void)"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"}],"comment":[{token:"comment",regex:"^=end(?:$|\\s.*$)",next:"start"},{token:"comment",regex:".+"}]};this.normalizeRules();};o.inherits(R,T);e.RubyHighlightRules=R;});ace.define("ace/mode/folding/coffee",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range"],function(r,e,m){"use strict";var o=r("../../lib/oop");var B=r("./fold_mode").FoldMode;var R=r("../../range").Range;var F=e.FoldMode=function(){};o.inherits(F,B);(function(){this.getFoldWidgetRange=function(s,f,a){var b=this.indentationBlock(s,a);if(b)return b;var c=/\S/;var l=s.getLine(a);var d=l.search(c);if(d==-1||l[d]!="#")return;var g=l.length;var h=s.getLength();var i=a;var j=a;while(++a<h){l=s.getLine(a);var k=l.search(c);if(k==-1)continue;if(l[k]!="#")break;j=a;}if(j>i){var n=s.getLine(j).length;return new R(i,g,j,n);}};this.getFoldWidget=function(s,f,a){var l=s.getLine(a);var i=l.search(/\S/);var n=s.getLine(a+1);var p=s.getLine(a-1);var b=p.search(/\S/);var c=n.search(/\S/);if(i==-1){s.foldWidgets[a-1]=b!=-1&&b<c?"start":"";return"";}if(b==-1){if(i==c&&l[i]=="#"&&n[i]=="#"){s.foldWidgets[a-1]="";s.foldWidgets[a+1]="";return"start";}}else if(b==i&&l[i]=="#"&&p[i]=="#"){if(s.getLine(a-2).search(/\S/)==-1){s.foldWidgets[a-1]="start";s.foldWidgets[a+1]="";return"";}}if(b!=-1&&b<i)s.foldWidgets[a-1]="start";else s.foldWidgets[a-1]="";if(i<c)return"start";else return"";};}).call(F.prototype);});ace.define("ace/mode/ruby",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/ruby_highlight_rules","ace/mode/matching_brace_outdent","ace/range","ace/mode/behaviour/cstyle","ace/mode/folding/coffee"],function(r,e,m){"use strict";var o=r("../lib/oop");var T=r("./text").Mode;var R=r("./ruby_highlight_rules").RubyHighlightRules;var M=r("./matching_brace_outdent").MatchingBraceOutdent;var a=r("../range").Range;var C=r("./behaviour/cstyle").CstyleBehaviour;var F=r("./folding/coffee").FoldMode;var b=function(){this.HighlightRules=R;this.$outdent=new M();this.$behaviour=new C();this.foldingRules=new F();};o.inherits(b,T);(function(){this.lineCommentStart="#";this.getNextLineIndent=function(s,l,t){var i=this.$getIndent(l);var c=this.getTokenizer().getLineTokens(l,s);var d=c.tokens;if(d.length&&d[d.length-1].type=="comment"){return i;}if(s=="start"){var f=l.match(/^.*[\{\(\[]\s*$/);var g=l.match(/^\s*(class|def|module)\s.*$/);var h=l.match(/.*do(\s*|\s+\|.*\|\s*)$/);var j=l.match(/^\s*(if|else|when)\s*/);if(f||g||h||j){i+=t;}}return i;};this.checkOutdent=function(s,l,i){return/^\s+(end|else)$/.test(l+i)||this.$outdent.checkOutdent(l,i);};this.autoOutdent=function(s,c,d){var l=c.getLine(d);if(/}/.test(l))return this.$outdent.autoOutdent(c,d);var i=this.$getIndent(l);var p=c.getLine(d-1);var f=this.$getIndent(p);var t=c.getTabString();if(f.length<=i.length){if(i.slice(-t.length)==t)c.remove(new a(d,i.length-t.length,d,i.length));}};this.$id="ace/mode/ruby";}).call(b.prototype);e.Mode=b;});ace.define("ace/mode/ejs",["require","exports","module","ace/lib/oop","ace/mode/html_highlight_rules","ace/mode/javascript_highlight_rules","ace/lib/oop","ace/mode/html","ace/mode/javascript","ace/mode/css","ace/mode/ruby"],function(r,e,m){"use strict";var o=r("../lib/oop");var H=r("./html_highlight_rules").HtmlHighlightRules;var J=r("./javascript_highlight_rules").JavaScriptHighlightRules;var E=function(s,c){H.call(this);if(!s)s="(?:<%|<\\?|{{)";if(!c)c="(?:%>|\\?>|}})";for(var i in this.$rules){this.$rules[i].unshift({token:"markup.list.meta.tag",regex:s+"(?![>}])[-=]?",push:"ejs-start"});}this.embedRules(new J({jsx:false}).getRules(),"ejs-",[{token:"markup.list.meta.tag",regex:"-?"+c,next:"pop"},{token:"comment",regex:"//.*?"+c,next:"pop"}]);this.normalizeRules();};o.inherits(E,H);e.EjsHighlightRules=E;var o=r("../lib/oop");var a=r("./html").Mode;var b=r("./javascript").Mode;var C=r("./css").Mode;var R=r("./ruby").Mode;var M=function(){a.call(this);this.HighlightRules=E;this.createModeDelegates({"js-":b,"css-":C,"ejs-":b});};o.inherits(M,a);(function(){this.$id="ace/mode/ejs";}).call(M.prototype);e.Mode=M;});
