/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/TooltipBase',"./CalloutBaseRenderer"],function(q,l,T,C){"use strict";var a=T.extend("sap.ui.commons.CalloutBase",{metadata:{library:"sap.ui.commons",events:{open:{parameters:{parent:{type:"sap.ui.core.Control"}}},close:{},beforeOpen:{allowPreventDefault:true,parameters:{parent:{type:"sap.ui.core.Control"}}},opened:{}}}});a.prototype.init=function(){this.oPopup=new sap.ui.core.Popup();this.oPopup.setShadow(true);this.oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");this.setPosition(sap.ui.core.Popup.Dock.BeginBottom,sap.ui.core.Popup.Dock.BeginTop);this.fAnyEventHandlerProxy=q.proxy(this.onAnyEvent,this);var t=this;this.oPopup._applyPosition=function(p){sap.ui.core.Popup.prototype._applyPosition.call(this,p);t.setTip();};this.oPopup.setFollowOf(sap.ui.core.Popup.CLOSE_ON_SCROLL);};a.prototype.exit=function(){this.oPopup.close();this.oPopup.detachEvent("opened",this.handleOpened,this);this.oPopup.detachEvent("closed",this.handleClosed,this);this.oPopup.destroy();delete this.oPopup;delete this.oRb;q.sap.unbindAnyEvent(this.fAnyEventHandlerProxy);};a.prototype._getPopup=function(){return this.oPopup;};a.prototype.hasChild=function(d){return d&&!!(q(d).closest(this.getDomRef()).length);};a.prototype.isPopupElement=function(d){if(!d){return false;}if(this.hasChild(d)){return true;}var s=sap.ui.getCore().getStaticAreaRef();var t=parseInt(q(d).closest(q(s).children()).css("z-index"),10);var b=parseInt(this.$().css("z-index"),10);return t&&b&&t>=b;};a.prototype.setTip=function(){if(!this.oPopup||!this.oPopup.isOpen()){return;}var $=this._currentControl.$(),b=this.$(),c=this.$("arrow"),d=b.offset(),e=$.offset(),s=true,f={},t={l:d.left,r:d.left+b.outerWidth(),w:b.outerWidth(),t:d.top,b:d.top+b.outerHeight(),h:b.outerHeight()},p={l:e.left,r:e.left+$.outerWidth(),w:$.outerWidth(),t:e.top,b:e.top+$.outerHeight(),h:$.outerHeight()},g=(b.outerWidth()-b.innerWidth())/2,h=c.outerWidth()*1.4,i=c.outerWidth()/5,j=i-g-8,m=this.getMyPosition();if(t.r<p.l-j){f.x="right";}else if(t.l-j>p.r){f.x="left";}if(t.t>p.b-j){f.y="top";}else if(t.b<p.t+j){f.y="bottom";}if(f.x){var P=0;if(m.indexOf("top")>-1){P=20;}else if(m.indexOf("bottom")>-1){P=t.h-20-h;}else{P=(t.h-h)/2;}var k=t.t+P+h/2+g;if((k<p.t)||(k>p.b)||(p.t>t.t&&p.b<t.b)){P=(Math.max(t.t,p.t)+Math.min(t.b,p.b))/2-t.t-h/2;}c.css(f.x,j+"px");c.css("top",P);if(P<0||P>t.h-h){s=false;}}if(f.y){var r=sap.ui.getCore().getConfiguration().getRTL();if(r){m.replace("begin","right").replace("end","left");}var n=0;if((m.indexOf("begin")>-1)||(m.indexOf("left")>-1)){n=20;}else if((m.indexOf("right")>-1)||(m.indexOf("end")>-1)){n=t.w-20-h;}else{n=(t.w-h)/2;}var o=t.l+n+h/2+g;if((o<p.l)||(o>p.r)){n=(Math.max(t.l,p.l)+Math.min(t.r,p.r))/2-t.l-h/2;}c.css(f.y,j+"px");c.css("left",n+"px");if(n<0||n>t.w-h){s=false;}}if(f.x&&f.y||!f.x&&!f.y){s=false;}c.toggle(s);};a.prototype.adjustPosition=function(){function _(){if(this.oPopup){var p=this._currentControl.getDomRef();this.oPopup.setPosition(this.getMyPosition(),this.getAtPosition(),p,this.getOffset(),this.getCollision());}}setTimeout(q.proxy(_,this),0);};a.prototype.focus=function(){if(this.oPopup&&this.oPopup.isOpen()){var c=this.$("cont");q.sap.focus(c.firstFocusableDomRef()||c.get(0));}};a.prototype.openPopup=function(s){if(!this.oPopup||this.oPopup.isOpen()){return;}if(T.sOpenTimeout){q.sap.clearDelayedCall(T.sOpenTimeout);T.sOpenTimeout=undefined;}if(!this.fireEvent("beforeOpen",{parent:this._currentControl},true,false)){if(!this.sCloseNowTimeout){T.sOpenTimeout=q.sap.delayedCall(200,this,"openPopup",[this._currentControl]);}return;}this.oParentFocusInfo=s.getFocusInfo();this.oPopup.attachEvent("opened",this.handleOpened,this);T.prototype.openPopup.call(this,s);this.adjustPosition();this.fireOpen({parent:this._currentControl});};a.prototype.close=function(){if(this.oPopup&&this.oPopup.isOpen()&&!this.sCloseNowTimeout){if(T.sOpenTimeout){q.sap.clearDelayedCall(T.sOpenTimeout);T.sOpenTimeout=undefined;}this.closePopup();}};a.prototype.closePopup=function(){var w=this.oPopup!==undefined&&this.oPopup.isOpen();if(this.fAnyEventHandlerProxy){q.sap.unbindAnyEvent(this.onAnyEvent);}T.prototype.closePopup.call(this);if(w&&this._currentControl&&this.bFocused){this._currentControl.applyFocusInfo(this.oParentFocusInfo);this.bFocused=false;}this.fireClose();};a.prototype.handleClosed=function(){if(this.oPopup){this.oPopup.detachEvent("closed",this.handleClosed,this);this.fireClosed();}};a.prototype.onkeydown=function(e){var c=e.ctrlKey&&e.which==q.sap.KeyCodes.I;var E=e.which==q.sap.KeyCodes.ESCAPE;if(!c&&!E){if(q(e.target).control(0)===this._currentControl){this.close();}return;}if(c){if(this.oPopup&&this.oPopup.isOpen()){return;}this.bDoFocus=true;}T.prototype.onkeydown.call(this,e);};a.prototype.handleOpened=function(){this.oPopup.detachEvent("opened",this.handleOpened,this);if(this.bDoFocus){this.focus();this.bDoFocus=false;this.bFocused=true;}this.$().css("display:","");this.fireOpened();q.sap.bindAnyEvent(this.fAnyEventHandlerProxy);};a.prototype.onfocusin=function(e){this.bFocused=true;var s=e.target;if(s.id===this.getId()+"-fhfe"){q.sap.focus(this.$("cont").lastFocusableDomRef());}else if(s.id===this.getId()+"-fhee"){q.sap.focus(this.$("cont").firstFocusableDomRef());}};a.prototype.onfocusout=function(e){return;};a.prototype.onmouseover=function(e){if(this.oPopup&&(this.oPopup.isOpen()&&this.oPopup.getContent()==this)){if(this.sCloseNowTimeout){q.sap.clearDelayedCall(this.sCloseNowTimeout);this.sCloseNowTimeout=null;}return;}else{T.prototype.onmouseover.call(this,e);}};a.prototype.onmouseout=function(e){if(this.oPopup&&(this.oPopup.isOpen()&&this.isPopupElement(e.relatedTarget))){return;}T.prototype.onmouseout.call(this,e);};a.prototype.onmousedown=function(e){if(q(e.target).control(0)===this._currentControl){this.close();this.removeStandardTooltips();}};a.prototype.onAnyEvent=function(e){if((this.oPopup&&!this.oPopup.isOpen())||e.type!="mouseover"||this.hasChild(e.target)){return;}var d=this.isPopupElement(e.target)||q(e.target).control(0)===this._currentControl;if(!d&&!this.sCloseNowTimeout&&!T.sOpenTimeout){this.sCloseNowTimeout=q.sap.delayedCall(400,this,"closePopup");}if(d&&this.sCloseNowTimeout){q.sap.clearDelayedCall(this.sCloseNowTimeout);this.sCloseNowTimeout=null;}};a.prototype.setPosition=function(m,b){var c=m||sap.ui.core.Popup.Dock.BeginBottom;var d=b||sap.ui.core.Popup.Dock.BeginTop;var e=0,f=0,g=0,h=0,i=5;if((c.indexOf("begin")>-1)||(c.indexOf("left")>-1)){e=-1;}else if((c.indexOf("right")>-1)||(c.indexOf("end")>-1)){e=1;}if((d.indexOf("begin")>-1)||(d.indexOf("left")>-1)){g=-1;}else if((d.indexOf("right")>-1)||(d.indexOf("end")>-1)){g=1;}if(c.indexOf("top")>-1){f=-1;}else if(c.indexOf("bottom")>-1){f=1;}if(d.indexOf("top")>-1){h=-1;}else if(d.indexOf("bottom")>-1){h=1;}var o=((e-g)*e*g*i)+" "+((f-h)*f*h*i);this.setMyPosition(c);this.setAtPosition(d);this.setOffset(o);return this;};return a;},true);
