/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/SyncPromise","sap/ui/model/BindingMode","sap/ui/model/ChangeReason","sap/ui/model/ClientListBinding","sap/ui/model/ContextBinding","sap/ui/model/Context","sap/ui/model/MetaModel","sap/ui/model/odata/OperationMode","sap/ui/model/odata/type/Int64","sap/ui/model/odata/type/Raw","sap/ui/model/PropertyBinding","sap/ui/thirdparty/URI","./lib/_Helper","./ValueListType","sap/base/Log","sap/base/assert","sap/base/util/ObjectPath","sap/ui/thirdparty/jquery"],function(S,B,C,a,b,c,M,O,I,R,P,U,_,V,L,d,f,q){"use strict";var g,D=L.Level.DEBUG,h,j,s="sap.ui.model.odata.v4.ODataMetaModel",k,r=/^-?\d+$/,l=new R(),m={messageChange:true},u={"Edm.Boolean":{type:"sap.ui.model.odata.type.Boolean"},"Edm.Byte":{type:"sap.ui.model.odata.type.Byte"},"Edm.Date":{type:"sap.ui.model.odata.type.Date"},"Edm.DateTimeOffset":{constraints:{"$Precision":"precision"},type:"sap.ui.model.odata.type.DateTimeOffset"},"Edm.Decimal":{constraints:{"@Org.OData.Validation.V1.Minimum/$Decimal":"minimum","@Org.OData.Validation.V1.Minimum@Org.OData.Validation.V1.Exclusive":"minimumExclusive","@Org.OData.Validation.V1.Maximum/$Decimal":"maximum","@Org.OData.Validation.V1.Maximum@Org.OData.Validation.V1.Exclusive":"maximumExclusive","$Precision":"precision","$Scale":"scale"},type:"sap.ui.model.odata.type.Decimal"},"Edm.Double":{type:"sap.ui.model.odata.type.Double"},"Edm.Guid":{type:"sap.ui.model.odata.type.Guid"},"Edm.Int16":{type:"sap.ui.model.odata.type.Int16"},"Edm.Int32":{type:"sap.ui.model.odata.type.Int32"},"Edm.Int64":{type:"sap.ui.model.odata.type.Int64"},"Edm.SByte":{type:"sap.ui.model.odata.type.SByte"},"Edm.Single":{type:"sap.ui.model.odata.type.Single"},"Edm.Stream":{type:"sap.ui.model.odata.type.Stream"},"Edm.String":{constraints:{"@com.sap.vocabularies.Common.v1.IsDigitSequence":"isDigitSequence","$MaxLength":"maxLength"},type:"sap.ui.model.odata.type.String"},"Edm.TimeOfDay":{constraints:{"$Precision":"precision"},type:"sap.ui.model.odata.type.TimeOfDay"}},p={},v="@com.sap.vocabularies.Common.v1.ValueListMapping",t={},w="@com.sap.vocabularies.Common.v1.ValueListReferences",x="@com.sap.vocabularies.Common.v1.ValueListWithFixedValues",W=L.Level.WARNING;function y(o,e,i,n){var J,K=o.mSchema2MetadataUrl[e];if(!K){K=o.mSchema2MetadataUrl[e]={};K[i]=false;}else if(!(i in K)){J=Object.keys(K)[0];if(K[J]){E("A schema cannot span more than one document: "+e+" - expected reference URI "+J+" but instead saw "+i,n);}K[i]=false;}}function z(o,e,i,n){var J,K,N,Q;function T(X){var Y,Z;if(!(i in X)){n(W,K," does not contain ",i);return;}n(D,"Including ",i," from ",K);for(Z in X){if(Z[0]!=="$"&&G(Z)===i){Y=X[Z];e[Z]=Y;F(Y,e.$Annotations);}}}if(i in e){return e[i];}Q=o.mSchema2MetadataUrl[i];if(Q){N=Object.keys(Q);if(N.length>1){E("A schema cannot span more than one document: schema is referenced"+" by following URLs: "+N.join(", "),i);}K=N[0];Q[K]=true;n(D,"Namespace ",i," found in $Include of ",K);J=o.mMetadataUrl2Promise[K];if(!J){n(D,"Reading ",K);J=o.mMetadataUrl2Promise[K]=S.resolve(o.oRequestor.read(K)).then(o.validate.bind(o,K));}J=J.then(T);if(i in e){return e[i];}e[i]=J;return J;}}function A(T,e){if(T===e){return"";}if(T.indexOf(e)===0&&T[e.length]==="#"&&T.indexOf("@",e.length)<0){return T.slice(e.length+1);}}function E(e,i){L.error(e,i,s);throw new Error(i+": "+e);}function F(o,e,i){var T;function n(J,K){var N;for(N in K){if(i||!(N in J)){J[N]=K[N];}}}for(T in o.$Annotations){if(!(T in e)){e[T]={};}n(e[T],o.$Annotations[T]);}delete o.$Annotations;}function G(Q){return Q.slice(0,Q.lastIndexOf(".")+1);}h=b.extend("sap.ui.model.odata.v4.ODataMetaContextBinding",{constructor:function(o,e,i){d(!i||i.getModel()===o,"oContext must belong to this model");b.call(this,o,e,i);},initialize:function(){var e=this.oModel.createBindingContext(this.sPath,this.oContext);this.bInitial=false;if(e!==this.oElementContext){this.oElementContext=e;this._fireChange();}},setContext:function(o){d(!o||o.getModel()===this.oModel,"oContext must belong to this model");if(o!==this.oContext){this.oContext=o;if(!this.bInitial){this.initialize();}}}});j=a.extend("sap.ui.model.odata.v4.ODataMetaListBinding",{constructor:function(){a.apply(this,arguments);},_fireFilter:function(){},_fireSort:function(){},checkUpdate:function(e){var i=this.oList.length;this.update();if(e||this.oList.length!==i){this._fireChange({reason:C.Change});}},fetchContexts:function(){var i,e=this.oModel.resolve(this.sPath,this.oContext),n=this;if(!e){return S.resolve([]);}i=e.slice(-1)==="@";if(!i&&!e.endsWith("/")){e+="/";}return this.oModel.fetchObject(e).then(function(o){if(!o){return[];}if(i){e=e.slice(0,-1);}return Object.keys(o).filter(function(K){return K[0]!=="$"&&i!==(K[0]!=="@");}).map(function(K){return new c(n.oModel,e+K);});});},getContexts:function(i,e){this.iCurrentStart=i||0;this.iCurrentLength=Math.min(e||Infinity,this.iLength,this.oModel.iSizeLimit);return this.getCurrentContexts();},getCurrentContexts:function(){var e=[],i,n=this.iCurrentStart+this.iCurrentLength;for(i=this.iCurrentStart;i<n;i++){e.push(this.oList[this.aIndices[i]]);}if(this.oList.dataRequested){e.dataRequested=true;}return e;},setContexts:function(e){this.oList=e;this.updateIndices();this.applyFilter();this.applySort();this.iLength=this._getLength();},update:function(){var e=[],o=this.fetchContexts(),i=this;if(o.isFulfilled()){e=o.getResult();}else{o.then(function(e){i.setContexts(e);i._fireChange({reason:C.Change});});e.dataRequested=true;}this.setContexts(e);}});k=P.extend("sap.ui.model.odata.v4.ODataMetaPropertyBinding",{constructor:function(){P.apply(this,arguments);this.vValue=undefined;},checkUpdate:function(e,i){var o,n=this;function J(K){if(e||K!==n.vValue){n.vValue=K;n._fireChange({reason:i||C.Change});}return K;}o=this.oModel.fetchObject(this.sPath,this.oContext,this.mParameters).then(J);if(this.mParameters&&this.mParameters.$$valueAsPromise&&o.isPending()){J(o.unwrap());}},getValue:function(){return this.vValue;},setContext:function(o){if(this.oContext!=o){this.oContext=o;if(this.bRelative){this.checkUpdate(false,C.Context);}}},setValue:function(){throw new Error("Unsupported operation: ODataMetaPropertyBinding#setValue");}});var H=M.extend("sap.ui.model.odata.v4.ODataMetaModel",{constructor:function(o,e,i,n,J){M.call(this);this.aAnnotationUris=i&&!Array.isArray(i)?[i]:i;this.sDefaultBindingMode=B.OneTime;this.mETags={};this.dLastModified=new Date(0);this.oMetadataPromise=null;this.oModel=n;this.mMetadataUrl2Promise={};this.oRequestor=o;this.mSchema2MetadataUrl={};this.mSupportedBindingModes={"OneTime":true,"OneWay":true};this.bSupportReferences=J!==false;this.sUrl=e;}});H.prototype.$$valueAsPromise=true;H.prototype._mergeAnnotations=function(e,n){var o=this;this.validate(this.sUrl,e);e.$Annotations={};Object.keys(e).forEach(function(i){if(e[i].$kind==="Schema"){y(o,i,o.sUrl);F(e[i],e.$Annotations);}});n.forEach(function(J,i){var K,Q;o.validate(o.aAnnotationUris[i],J);for(Q in J){if(Q[0]!=="$"){if(Q in e){E("A schema cannot span more than one document: "+Q,o.aAnnotationUris[i]);}K=J[Q];e[Q]=K;if(K.$kind==="Schema"){y(o,Q,o.aAnnotationUris[i]);F(K,e.$Annotations,true);}}}});};H.prototype.attachEvent=function(e){if(!(e in m)){throw new Error("Unsupported event '"+e+"': v4.ODataMetaModel#attachEvent");}return M.prototype.attachEvent.apply(this,arguments);};H.prototype.bindContext=function(e,o){return new h(this,e,o);};H.prototype.bindList=function(e,o,i,n){return new j(this,e,o,i,n);};H.prototype.bindProperty=function(e,o,i){return new k(this,e,o,i);};H.prototype.bindTree=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#bindTree");};H.prototype.fetchCanonicalPath=function(o){return this.fetchUpdateData("",o).then(function(e){if(e.propertyPath){throw new Error("Context "+o.getPath()+" does not point to an entity. It should be "+e.entityPath);}return"/"+e.editUrl;});};H.prototype.fetchEntityContainer=function(e){var i,n=this;if(!this.oMetadataPromise){i=[S.resolve(this.oRequestor.read(this.sUrl,false,e))];if(this.aAnnotationUris){this.aAnnotationUris.forEach(function(o){i.push(S.resolve(n.oRequestor.read(o,true,e)));});}if(!e){this.oMetadataPromise=S.all(i).then(function(o){var J=o[0];n._mergeAnnotations(J,o.slice(1));return J;});}}return this.oMetadataPromise;};H.prototype.fetchModule=function(e){var i;e=e.replace(/\./g,"/");i=sap.ui.require(e);if(i){return S.resolve(i);}return S.resolve(new Promise(function(n,o){sap.ui.require([e],n);}));};H.prototype.fetchObject=function(n,J,K){var N=this.resolve(n,J),Q=this;if(!N){L.error("Invalid relative path w/o context",n,s);return S.resolve(null);}return this.fetchEntityContainer().then(function(T){var X,Y,Z,$=true,a1,b1,c1,d1=T;function e1(i,n){var o,l1=i.indexOf("@",2);if(l1>-1){return h1(W,"Unsupported path after ",i.slice(0,l1));}i=i.slice(2);o=i[0]==="."?f.get(i.slice(1),K.scope):K&&f.get(i,K.scope)||f.get(i);if(typeof o!=="function"){return h1(W,i," is not a function but: "+o);}try{d1=o(d1,{$$valueAsPromise:K&&K.$$valueAsPromise,context:new c(Q,n),schemaChildName:b1});}catch(e){h1(W,"Error calling ",i,": ",e);}return false;}function f1(o){return o.$kind!=="Action"||(!o.$IsBound&&X===p||o.$IsBound&&X===o.$Parameter[0].$Type);}function g1(o){return o&&typeof o.then==="function";}function h1(i){var e;if(L.isLoggable(i,s)){e=Array.isArray(Y)?Y.join("/"):Y;L[i===D?"debug":"warning"](Array.prototype.slice.call(arguments,1).join("")+(e?" at /"+e:""),N,s);}if(i===W){d1=undefined;}return false;}function i1(e,i){var o;function l1(){Y=Y||c1&&i&&c1+"/"+i;return h1.apply(this,arguments);}X=d1&&d1.$Type;if(Q.bSupportReferences&&!(e in T)){o=G(e);d1=z(Q,T,o,l1);}if(e in T){c1=Z=b1=e;d1=a1=T[b1];if(!g1(d1)){return true;}}if(g1(d1)&&d1.isPending()){return l1(D,"Waiting for ",o);}return l1(W,"Unknown qualified name ",e);}function j1(e,i,o){var l1,m1;if(e==="$Annotations"){return h1(W,"Invalid segment: $Annotations");}if(d1!==T&&typeof d1==="object"&&e in d1){if(e[0]==="$"||r.test(e)){$=false;}}else{l1=e.indexOf("@@");if(l1<0){if(e.length>11&&e.slice(-11)==="@sapui.name"){l1=e.length-11;}else{l1=e.indexOf("@");}}if(l1>0){if(!j1(e.slice(0,l1),i,o)){return false;}e=e.slice(l1);m1=true;}if(typeof d1==="string"&&!(m1&&e[0]==="@"&&(e==="@sapui.name"||e[1]==="@"))&&!k1(d1,o.slice(0,i))){return false;}if($){if(e[0]==="$"||r.test(e)){$=false;}else if(!m1){if(e[0]!=="@"&&e.indexOf(".")>0){return i1(e);}else if(d1&&"$Type"in d1){if(!i1(d1.$Type,"$Type")){return false;}}else if(d1&&"$Action"in d1){if(!i1(d1.$Action,"$Action")){return false;}X=p;}else if(d1&&"$Function"in d1){if(!i1(d1.$Function,"$Function")){return false;}}else if(i===0){c1=Z=b1=b1||T.$EntityContainer;d1=a1=a1||T[b1];if(e&&e[0]!=="@"&&!(e in a1)){return h1(W,"Unknown child ",e," of ",b1);}}if(Array.isArray(d1)){d1=d1.filter(f1);if(e==="@$ui5.overload"){return true;}if(d1.length!==1){return h1(W,"Unsupported overloads");}d1=d1[0].$ReturnType;c1=c1+"/0/$ReturnType";if(d1){if(e==="value"&&!(T[d1.$Type]&&T[d1.$Type].value)){Z=undefined;return true;}if(!i1(d1.$Type,"$Type")){return false;}}}}}if(!e){return i+1>=o.length||h1(W,"Invalid empty segment");}if(e[0]==="@"){if(e==="@sapui.name"){d1=Z;if(d1===undefined){h1(W,"Unsupported path before @sapui.name");}else if(i+1<o.length){h1(W,"Unsupported path after @sapui.name");}return false;}if(e[1]==="@"){if(i+1<o.length){return h1(W,"Unsupported path after ",e);}return e1(e,"/"+o.slice(0,i).join("/")+"/"+o[i].slice(0,l1));}}if(!d1||typeof d1!=="object"){d1=undefined;return h1(D,"Invalid segment: ",e);}if($&&e[0]==="@"){d1=(T.$Annotations||{})[c1]||{};$=false;}}if(e!=="@"){Z=$||e[0]==="@"?e:undefined;c1=$?c1+"/"+e:undefined;d1=d1[e];}return true;}function k1(e,i){var o;if(Y){return h1(W,"Invalid recursion");}Y=i;$=true;d1=T;o=e.split("/").every(j1);Y=undefined;return o;}k1(N.slice(1));if(g1(d1)){d1=d1.then(function(){return Q.fetchObject(n,J,K);});}return d1;});};H.prototype.fetchUI5Type=function(e){var o=this.getMetaContext(e),i=this;if(e.endsWith("/$count")){g=g||new I();return S.resolve(g);}return this.fetchObject(undefined,o).then(function(n){var J,K,T,N,Q=l.getName();function X(Y,Z){if(Z!==undefined){J=J||{};J[Y]=Z;}}if(!n){L.warning("No metadata for path '"+e+"', using "+Q,undefined,s);return l;}T=n["$ui5.type"];if(T){return T;}if(n.$isCollection){L.warning("Unsupported collection type, using "+Q,e,s);}else{N=u[n.$Type];if(N){Q=N.type;for(K in N.constraints){X(N.constraints[K],K[0]==="@"?i.getObject(K,o):n[K]);}if(n.$Nullable===false){X("nullable",false);}}else{L.warning("Unsupported type '"+n.$Type+"', using "+Q,e,s);}}if(Q===l.getName()){n["$ui5.type"]=l;}else{n["$ui5.type"]=i.fetchModule(Q).then(function(Y){T=new Y(undefined,J);n["$ui5.type"]=T;return T;});}return n["$ui5.type"];});};H.prototype.fetchUpdateData=function(e,o){var n=o.getModel(),J=n.resolve(e,o),K=this;function N(i){var Q=new Error(J+": "+i);n.reportError(i,s,Q);throw Q;}return this.fetchObject(this.getMetaPath(J)).then(function(){return K.fetchEntityContainer();}).then(function(Q){var T,X=Q[Q.$EntityContainer],Y,Z,$,a1,b1,c1,d1=false,e1;function f1(){T.push({path:a1,prefix:T.pop(),type:e1});}function g1(i1){var i=i1.indexOf("(");return i>=0?i1.slice(i):"";}function h1(i1){var i=i1.indexOf("(");return i>=0?i1.slice(0,i):i1;}c1=J.slice(1).split("/");T=[c1.shift()];a1="/"+T[0];Y=a1;$=decodeURIComponent(h1(T[0]));Z=X[$];if(!Z){N("Not an entity set: "+$);}e1=Q[Z.$Type];e="";b1="";c1.forEach(function(i){var i1,j1;a1+="/"+i;if(r.test(i)){f1();Y+="/"+i;}else{j1=decodeURIComponent(h1(i));b1=_.buildPath(b1,j1);i1=e1[j1];if(!i1){N("Not a (navigation) property: "+j1);}e1=Q[i1.$Type];if(i1.$kind==="NavigationProperty"){if(b1 in Z.$NavigationPropertyBinding){$=Z.$NavigationPropertyBinding[b1];Z=X[$];b1="";T=[encodeURIComponent($)+g1(i)];if(!i1.$isCollection){f1();}}else{T.push(i);}Y=a1;e="";}else{e=_.buildPath(e,i);}}});return S.all(T.map(function(i){if(typeof i==="string"){return i;}return o.fetchValue(i.path).then(function(i1){var j1;if(!i1){N("No instance to calculate key predicate at "+i.path);}if(_.hasPrivateAnnotation(i1,"transient")){d1=true;return undefined;}j1=_.getPrivateAnnotation(i1,"predicate");if(!j1){N("No key predicate known at "+i.path);}return i.prefix+j1;},function(i1){N(i1.message+" at "+i.path);});})).then(function(i){return{editUrl:d1?undefined:i.join("/"),entityPath:Y,propertyPath:e};});});};H.prototype.fetchValueListMappings=function(o,n,e){var i=this,J=o.getMetaModel();return J.fetchEntityContainer().then(function(K){var N,Q=K.$Annotations,T={},X=i===J,Y;Y=Object.keys(Q).filter(function(Z){if(_.namespace(Z)===n){if(i.getObject("/"+Z)===e){return true;}if(!X){throw new Error("Unexpected annotation target '"+Z+"' with namespace of data service in "+o.sServiceUrl);}}return false;});if(!Y.length){throw new Error("No annotation '"+v.slice(1)+"' in "+o.sServiceUrl);}N=Q[Y[0]];Object.keys(N).forEach(function(Z){var $=A(Z,v);if($!==undefined){T[$]=N[Z];}else if(!X){throw new Error("Unexpected annotation '"+Z.slice(1)+"' for target '"+Y[0]+"' with namespace of data service in "+o.sServiceUrl);}});return T;});};H.prototype.fetchValueListType=function(e){var o=this.getMetaContext(e),i=this;return this.fetchObject(undefined,o).then(function(n){var J,T;if(!n){throw new Error("No metadata for "+e);}J=i.getObject("@",o);if(J[x]){return V.Fixed;}for(T in J){if(A(T,w)!==undefined||A(T,v)!==undefined){return V.Standard;}}return V.None;});};H.prototype.getAdapterFactoryModulePath=function(){return"sap/ui/model/odata/v4/meta/ODataAdapterFactory";};H.prototype.getETags=function(){return this.mETags;};H.prototype.getLastModified=function(){return this.dLastModified;};H.prototype.getMetaContext=function(e){return new c(this,this.getMetaPath(e));};H.prototype.getMetaPath=function(e){return _.getMetaPath(e);};H.prototype.getOrCreateValueListModel=function(e){var i=new U(this.sUrl).absoluteTo(document.baseURI).pathname().toString(),o,n;n=new U(e).absoluteTo(i).filename("").toString();o=t[n];if(!o){o=new this.oModel.constructor({operationMode:O.Server,serviceUrl:n,synchronizationMode:"None"});o.setDefaultBindingMode(B.OneWay);t[n]=o;o.oRequestor.mHeaders["X-CSRF-Token"]=this.oModel.oRequestor.mHeaders["X-CSRF-Token"];}return o;};H.prototype.getOriginalProperty=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#getOriginalProperty");};H.prototype.getObject=_.createGetMethod("fetchObject");H.prototype.getProperty=H.prototype.getObject;H.prototype.getUI5Type=_.createGetMethod("fetchUI5Type",true);H.prototype.getValueListType=_.createGetMethod("fetchValueListType",true);H.prototype.isList=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#isList");};H.prototype.refresh=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#refresh");};H.prototype.requestObject=_.createRequestMethod("fetchObject");H.prototype.requestUI5Type=_.createRequestMethod("fetchUI5Type");H.prototype.requestValueListType=_.createRequestMethod("fetchValueListType");H.prototype.requestValueListInfo=function(e){var i=this.getMetaPath(e),T=i.slice(0,i.lastIndexOf("/")+1),n=this;return Promise.all([this.requestObject(T+"@sapui.name"),this.requestObject(i),this.requestObject(i+"@"),this.requestObject(i+x)]).then(function(o){var J=o[2],K=o[3],N={},Q=_.namespace(o[0]),X=o[1],Y={};function Z($,a1,b1,c1){if(N[a1]){throw new Error("Annotations '"+v.slice(1)+"' with identical qualifier '"+a1+"' for property "+e+" in "+N[a1]+" and "+b1);}if(K&&Y[""]){throw new Error("Annotation '"+x.slice(1)+"' but multiple '"+v.slice(1)+"' for property "+e);}N[a1]=b1;Y[K?"":a1]=q.extend(true,{$model:c1},$);}if(!X){throw new Error("No metadata for "+e);}Object.keys(J).filter(function($){return A($,v)!==undefined;}).forEach(function($){Z(J[$],A($,v),n.sUrl,n.oModel);});return Promise.all(Object.keys(J).filter(function($){return A($,w)!==undefined;}).map(function($){var a1=J[$];return Promise.all(a1.map(function(b1){var c1=n.getOrCreateValueListModel(b1);return n.fetchValueListMappings(c1,Q,X).then(function(d1){Object.keys(d1).forEach(function(e1){Z(d1[e1],e1,b1,c1);});});}));})).then(function(){if(!Object.keys(Y).length){throw new Error("No annotation '"+w.slice(1)+"' for "+e);}return Y;});});};H.prototype.resolve=function(e,o){var i,n;if(!e){return o?o.getPath():undefined;}n=e[0];if(n==="/"){return e;}if(!o){return undefined;}if(n==="."){if(e[1]!=="/"){throw new Error("Unsupported relative path: "+e);}e=e.slice(2);}i=o.getPath();return n==="@"||i.slice(-1)==="/"?i+e:i+"/"+e;};H.prototype.setLegacySyntax=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#setLegacySyntax");};H.prototype.toString=function(){return s+": "+this.sUrl;};H.prototype.validate=function(e,n){var i,o,J,K,N,Q;if(!this.bSupportReferences){return n;}for(Q in n.$Reference){N=n.$Reference[Q];Q=new U(Q).absoluteTo(this.sUrl).toString();if("$IncludeAnnotations"in N){E("Unsupported IncludeAnnotations",e);}for(i in N.$Include){K=N.$Include[i];if(K in n){E("A schema cannot span more than one document: "+K+" - is both included and defined",e);}y(this,K,Q,e);}}J=n.$LastModified?new Date(n.$LastModified):null;this.mETags[e]=n.$ETag?n.$ETag:J;o=n.$Date?new Date(n.$Date):new Date();J=J||o;if(this.dLastModified<J){this.dLastModified=J;}delete n.$Date;delete n.$ETag;delete n.$LastModified;return n;};return H;});
