/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/SyncPromise","sap/ui/core/MessageType","sap/ui/core/message/Message","sap/ui/model/BindingMode","sap/ui/model/Context","sap/ui/model/Model","sap/ui/model/odata/OperationMode","sap/ui/thirdparty/URI","./lib/_GroupLock","./lib/_Helper","./lib/_MetadataRequestor","./lib/_Requestor","./lib/_Parser","./ODataContextBinding","./ODataListBinding","./ODataMetaModel","./ODataPropertyBinding","./SubmitMode","sap/base/Log","sap/base/assert","sap/ui/thirdparty/jquery"],function(S,M,a,B,b,c,O,U,_,d,e,f,g,h,i,j,k,l,L,m,q){"use strict";var C="sap.ui.model.odata.v4.ODataModel",r=/^\w+$/,n=/^(\$auto(\.\w+)?|\$direct|\w+)$/,o=[undefined,M.Success,M.Information,M.Warning,M.Error],s={messageChange:true},p={annotationURI:true,autoExpandSelect:true,earlyRequests:true,groupId:true,groupProperties:true,odataVersion:true,operationMode:true,serviceUrl:true,supportReferences:true,synchronizationMode:true,updateGroupId:true},t=["$apply","$count","$expand","$filter","$orderby","$search","$select"],E=["$count","$expand","$filter","$levels","$orderby","$search","$select"];var u=c.extend("sap.ui.model.odata.v4.ODataModel",{constructor:function(P){var G,v,H={"Accept-Language":sap.ui.getCore().getConfiguration().getLanguageTag()},w,x,y,z,A=this;c.apply(this);if(!P||P.synchronizationMode!=="None"){throw new Error("Synchronization mode must be 'None'");}w=P.odataVersion||"4.0";this.sODataVersion=w;if(w!=="4.0"&&w!=="2.0"){throw new Error("Unsupported value for parameter odataVersion: "+w);}for(x in P){if(!(x in p)){throw new Error("Unsupported parameter: "+x);}}y=P.serviceUrl;if(!y){throw new Error("Missing service root URL");}z=new U(y);if(z.path()[z.path().length-1]!=="/"){throw new Error("Service root URL must end with '/'");}if(P.operationMode&&P.operationMode!==O.Server){throw new Error("Unsupported operation mode: "+P.operationMode);}this.sOperationMode=P.operationMode;this.mUriParameters=this.buildQueryOptions(z.query(true),false,true);this.sServiceUrl=z.query("").toString();this.sGroupId=P.groupId;if(this.sGroupId===undefined){this.sGroupId="$auto";}if(this.sGroupId!=="$auto"&&this.sGroupId!=="$direct"){throw new Error("Group ID must be '$auto' or '$direct'");}this.checkGroupId(P.updateGroupId,false,"Invalid update group ID: ");this.sUpdateGroupId=P.updateGroupId||this.getGroupId();this.aLockedGroupLocks=[];this.mGroupProperties={};for(G in P.groupProperties){A.checkGroupId(G,true);v=P.groupProperties[G];if(typeof v!=="object"||Object.keys(v).length!==1||!(v.submit in l)){throw new Error("Group '"+G+"' has invalid properties: '"+v+"'");}}this.mGroupProperties=q.extend({"$auto":{submit:l.Auto},"$direct":{submit:l.Direct}},P.groupProperties);if(P.autoExpandSelect!==undefined&&typeof P.autoExpandSelect!=="boolean"){throw new Error("Value for autoExpandSelect must be true or false");}this.bAutoExpandSelect=P.autoExpandSelect===true;this.oMetaModel=new j(e.create(H,w,this.mUriParameters),this.sServiceUrl+"$metadata",P.annotationURI,this,P.supportReferences);this.oRequestor=f.create(this.sServiceUrl,{fnFetchEntityContainer:this.oMetaModel.fetchEntityContainer.bind(this.oMetaModel),fnFetchMetadata:this.oMetaModel.fetchObject.bind(this.oMetaModel),fnGetGroupProperty:this.getGroupProperty.bind(this),fnOnCreateGroup:function(G){if(A.isAutoGroup(G)){sap.ui.getCore().addPrerenderingTask(A._submitBatch.bind(A,G));}},fnReportBoundMessages:this.reportBoundMessages.bind(this),fnReportUnboundMessages:this.reportUnboundMessages.bind(this)},H,this.mUriParameters,w);if(P.earlyRequests){this.oMetaModel.fetchEntityContainer(true);this.initializeSecurityToken();}this.aAllBindings=[];this.sDefaultBindingMode=B.TwoWay;this.mSupportedBindingModes={OneTime:true,OneWay:true,TwoWay:true};}});u.prototype._submitBatch=function(G){var v,P,w=this;P=S.all(this.aLockedGroupLocks.map(function(x){return x.waitFor(G);}));v=P.isPending();if(v){L.info("submitBatch('"+G+"') is waiting for locks",null,C);}return Promise.resolve(P.then(function(){if(v){L.info("submitBatch('"+G+"') continues",null,C);}w.aLockedGroupLocks=w.aLockedGroupLocks.filter(function(x){return x.isLocked();});return w.oRequestor.submitBatch(G).catch(function(x){w.reportError("$batch failed",C,x);throw x;});}));};u.prototype.attachEvent=function(v){if(!(v in s)){throw new Error("Unsupported event '"+v+"': v4.ODataModel#attachEvent");}return c.prototype.attachEvent.apply(this,arguments);};u.prototype.bindContext=function(P,v,w){return new h(this,P,v,w);};u.prototype.bindingCreated=function(v){this.aAllBindings.push(v);};u.prototype.bindingDestroyed=function(v){var I=this.aAllBindings.indexOf(v);if(I<0){throw new Error("Unknown "+v);}this.aAllBindings.splice(I,1);};u.prototype.bindList=function(P,v,w,F,x){return new i(this,P,v,w,F,x);};u.prototype.bindProperty=function(P,v,w){return new k(this,P,v,w);};u.prototype.bindTree=function(){throw new Error("Unsupported operation: v4.ODataModel#bindTree");};u.prototype.buildQueryOptions=function(P,v,w){var x,T=q.extend(true,{},P);function y(z,A,D){var F,G,H,V=z[A];if(!v||D.indexOf(A)<0){throw new Error("System query option "+A+" is not supported");}if((A==="$expand"||A==="$select")&&typeof V==="string"){V=g.parseSystemQueryOption(A+"="+V)[A];z[A]=V;}if(A==="$expand"){for(H in V){G=V[H];if(G===null||typeof G!=="object"){G=V[H]={};}for(F in G){y(G,F,E);}}}else if(A==="$count"){if(typeof V==="boolean"){if(!V){delete z.$count;}}else{switch(typeof V==="string"&&V.toLowerCase()){case"false":delete z.$count;break;case"true":z.$count=true;break;default:throw new Error("Invalid value for $count: "+V);}}}}if(P){for(x in P){if(x.indexOf("$$")===0){delete T[x];}else if(x[0]==="@"){throw new Error("Parameter "+x+" is not supported");}else if(x[0]==="$"){y(T,x,t);}else if(!w&&x.indexOf("sap-")===0){throw new Error("Custom query option "+x+" is not supported");}}}return T;};u.prototype.checkDeferredGroupId=function(G){this.checkGroupId(G,true,"Invalid deferred group ID: ");if(this.isAutoGroup(G)||this.isDirectGroup(G)){throw new Error("Group ID is not deferred: "+G);}};u.prototype.checkGroupId=function(G,A,v){if(!A&&G===undefined||typeof G==="string"&&(A?r:n).test(G)){return;}throw new Error((v||"Invalid group ID: ")+G);};u.prototype.createBindingContext=function(P,v){var D,w,x,R,y;function z(x){var A=x.indexOf("."),F=x.indexOf("/");return A>0&&(F<0||A<F);}if(arguments.length>2){throw new Error("Only the parameters sPath and oContext are supported");}if(v&&v.getBinding){throw new Error("Unsupported type: oContext must be of type sap.ui.model.Context, "+"but was sap.ui.model.odata.v4.Context");}R=this.resolve(P,v);if(R===undefined){throw new Error("Cannot create binding context from relative path '"+P+"' without context");}y=R.indexOf('#');if(y>=0){D=R.slice(0,y);x=R.slice(y+1);if(x[0]==="#"){x=x.slice(1);}else if(D.length>1&&x[0]!=="@"&&z(x)){return new b(this,R);}if(x[0]==="/"){x="."+x;}w=this.oMetaModel.getMetaContext(D);return this.oMetaModel.createBindingContext(x,w);}return new b(this,R);};u.prototype.destroy=function(){this.oMetaModel.destroy();return c.prototype.destroy.apply(this,arguments);};u.prototype.destroyBindingContext=function(){throw new Error("Unsupported operation: v4.ODataModel#destroyBindingContext");};u.prototype.getContext=function(){throw new Error("Unsupported operation: v4.ODataModel#getContext");};u.prototype.getDependentBindings=function(P){return this.aAllBindings.filter(function(v){var w=v.getContext();return v.isRelative()&&(w===P||w&&w.getBinding&&w.getBinding()===P);});};u.prototype.getGroupId=function(){return this.sGroupId;};u.prototype.getGroupProperty=function(G,P){switch(P){case"submit":if(G.startsWith("$auto.")){return l.Auto;}return this.mGroupProperties[G]?this.mGroupProperties[G].submit:l.API;default:throw new Error("Unsupported group property: '"+P+"'");}};u.prototype.getMetaModel=function(){return this.oMetaModel;};u.prototype.getObject=function(){throw new Error("Unsupported operation: v4.ODataModel#getObject");};u.prototype.getODataVersion=function(){return this.sODataVersion;};u.prototype.getOriginalProperty=function(){throw new Error("Unsupported operation: v4.ODataModel#getOriginalProperty");};u.prototype.getProperty=function(){throw new Error("Unsupported operation: v4.ODataModel#getProperty");};u.prototype.getUpdateGroupId=function(){return this.sUpdateGroupId;};u.prototype.hasPendingChanges=function(){return this.oRequestor.hasPendingChanges();};u.prototype.initializeSecurityToken=function(){this.oRequestor.refreshSecurityToken();};u.prototype.isList=function(){throw new Error("Unsupported operation: v4.ODataModel#isList");};u.prototype.isAutoGroup=function(G){return this.getGroupProperty(G,"submit")===l.Auto;};u.prototype.isDirectGroup=function(G){return this.getGroupProperty(G,"submit")===l.Direct;};u.prototype.lockGroup=function(G,v,w){var x;if(v instanceof _){v.setGroupId(G);return v;}x=new _(G,v,w);if(x.isLocked()){this.aLockedGroupLocks.push(x);}return x;};u.prototype.refresh=function(G){this.checkGroupId(G);this.aBindings.slice().forEach(function(v){if(v.isRefreshable()){v.refresh(G);}});};u.prototype.reportBoundMessages=function(R,P,v){var D="/"+R,N=[],w=[],x=this;Object.keys(P).forEach(function(K){P[K].forEach(function(y){var T=D+K+(y.target?"/"+y.target:"");N.push(new a({code:y.code,descriptionUrl:y.longtextUrl||undefined,message:y.message,persistent:y.transition,processor:x,target:T,technical:false,type:o[y.numericSeverity]||M.None}));});});(v||[""]).forEach(function(y){var z=d.buildPath(D,y);Object.keys(x.mMessages||{}).forEach(function(A){if(A===z||A.startsWith(z+"/")||A.startsWith(z+"(")){w=w.concat(x.mMessages[A].filter(function(F){return!F.persistent;}));}});});if(N.length||w.length){this.fireMessageChange({newMessages:N,oldMessages:w});}};u.prototype.reportError=function(v,R,w){var D;if(w.canceled==="noDebugLog"){return;}D=w.stack||w.message;if(D.indexOf(w.message)<0){D=w.message+"\n"+w.stack;}if(w.canceled){L.debug(v,D,R);return;}L.error(v,D,R);if(w.$reported){return;}w.$reported=true;this.fireMessageChange({newMessages:[new a({message:w.message,processor:this,persistent:true,target:"",technical:true,type:"Error"})]});};u.prototype.reportUnboundMessages=function(R,v){var w=this;if(v&&v.length){this.fireMessageChange({newMessages:v.map(function(x){var y=x.longtextUrl;return new a({code:x.code,descriptionUrl:y?d.makeAbsolute(y,w.sServiceUrl+R):undefined,message:x.message,persistent:true,processor:w,target:"",technical:false,type:o[x.numericSeverity]||M.None});})});}};u.prototype.requestCanonicalPath=function(v){m(v.getModel()===this,"oEntityContext must belong to this model");return v.requestCanonicalPath();};u.prototype.resetChanges=function(G){G=G||this.sUpdateGroupId;this.checkDeferredGroupId(G);this.oRequestor.cancelChanges(G);this.aAllBindings.forEach(function(v){if(G===v.getUpdateGroupId()){v.resetInvalidDataState();}});};u.prototype.resolve=function(P,v){var R;if(P&&P[0]==="/"){R=P;}else if(v){if(P){if(v.getPath().slice(-1)==="/"){R=v.getPath()+P;}else{R=v.getPath()+"/"+P;}}else{R=v.getPath();}}if(R&&R!=="/"&&R[R.length-1]==="/"&&R.indexOf("#")<0){R=R.slice(0,R.length-1);}return R;};u.prototype.setLegacySyntax=function(){throw new Error("Unsupported operation: v4.ODataModel#setLegacySyntax");};u.prototype.submitBatch=function(G){var v=this;this.checkDeferredGroupId(G);return new Promise(function(w){sap.ui.getCore().addPrerenderingTask(function(){w(v._submitBatch(G));});});};u.prototype.toString=function(){return C+": "+this.sServiceUrl;};return u;});
