/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/commons/Menu','sap/ui/core/Control','sap/ui/core/theming/Parameters','./library',"./ShellRenderer"],function(q,M,C,P,l,S){"use strict";var a=C.extend("sap.ui.ux3.Shell",{metadata:{library:"sap.ui.ux3",properties:{appTitle:{type:"string",group:"Misc",defaultValue:null},appIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},appIconTooltip:{type:"string",group:"Misc",defaultValue:null},showLogoutButton:{type:"boolean",group:"Misc",defaultValue:true},logoutButtonTooltip:{type:"string",group:"Accessibility",defaultValue:null},showSearchTool:{type:"boolean",group:"Misc",defaultValue:true},showInspectorTool:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},showFeederTool:{type:"boolean",group:"Misc",defaultValue:true},showTools:{type:"boolean",group:"Misc",defaultValue:true},showPane:{type:"boolean",group:"Misc",defaultValue:true},headerType:{type:"sap.ui.ux3.ShellHeaderType",group:"Misc",defaultValue:sap.ui.ux3.ShellHeaderType.Standard},designType:{type:"sap.ui.ux3.ShellDesignType",group:"Misc",defaultValue:sap.ui.ux3.ShellDesignType.Standard},paneWidth:{type:"int",group:"Misc",defaultValue:250},applyContentPadding:{type:"boolean",group:"Appearance",defaultValue:true},fullHeightContent:{type:"boolean",group:"Appearance",defaultValue:false},allowOverlayHeaderAccess:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"content",aggregations:{worksetItems:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"worksetItem"},paneBarItems:{type:"sap.ui.core.Item",multiple:true,singularName:"paneBarItem"},paneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"paneContent"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},toolPopups:{type:"sap.ui.ux3.ToolPopup",multiple:true,singularName:"toolPopup"},headerItems:{type:"sap.ui.core.Control",multiple:true,singularName:"headerItem"},notificationBar:{type:"sap.ui.ux3.NotificationBar",multiple:false},_paneOverflowMenu:{type:"sap.ui.commons.Menu",multiple:false,visibility:"hidden"}},associations:{selectedWorksetItem:{type:"sap.ui.ux3.NavigationItem",multiple:false}},events:{worksetItemSelected:{allowPreventDefault:true,parameters:{id:{type:"string"},item:{type:"sap.ui.ux3.NavigationItem"},key:{type:"string"}}},paneBarItemSelected:{parameters:{id:{type:"string"},item:{type:"sap.ui.core.Item"},key:{type:"string"}}},logout:{},search:{},feedSubmit:{},paneClosed:{parameters:{id:{type:"string"}}}}}});a.WSI_MENU_DELAY=200;a.WSI_OVERFLOW_SCROLL_STEP=250;a.TOOL_PREFIX="-tool-";a.FIRST_RENDERING=true;a.SIDE_BAR_BASE_WIDTH=null;a.PANE_OVERFLOW_BUTTON_HEIGHT=null;a.prototype.init=function(){this._iOpenPaneIndex=-1;this._sOpenWsiId=null;this._bPreviousScrollRight=false;this._bPreviousScrollLeft=false;this._sSelectedWorksetId=null;this._sSelectedFacetId=null;this._aSyncRefStack=[];this._mSyncRefs={};this._oWorksetBar=new sap.ui.ux3.NavigationBar(this.getId()+"-wsBar",{toplevelVariant:true,select:[this._handleWorksetBarSelect,this]}).setParent(this);this._oFacetBar=new sap.ui.ux3.NavigationBar(this.getId()+"-facetBar",{select:[this._handleFacetBarSelect,this]}).setParent(this);this.setAggregation("_paneOverflowMenu",new M());var t=this;this._checkResizeClosure=function(){t._checkResize();};this.currentToolPaletteWidth=0;this._updateThemeVariables();};a.prototype.exit=function(){if(this._oWorksetBar){this._oWorksetBar.destroy();delete this._oWorksetBar;}if(this._oFacetBar){this._oFacetBar.destroy();delete this._oFacetBar;}this._oSearchField=null;q(window).unbind("resize",this._checkResizeClosure);};a.prototype.onBeforeRendering=function(){this._beforeRenderingToolPalette();this.$("focusDummyPane").unbind("focusin");if(window.FileReader){var $=this.$("hdr");$.unbind('dragover',this._handleDragover).unbind('dragend',this._handleDragend).unbind('drop',this._handleDrop);var b=this.$("bgImg");b.unbind('dragover',q.proxy(this._handleDragover)).unbind('dragend',this._handleDragend).unbind('drop',this._handleDrop);}};a.prototype.onAfterRendering=function(){this._afterRenderingToolPalette();if(this._topSyncRefId&&this._mSyncRefs[this._topSyncRefId].focusLast){this.$("focusDummyPane").focusin(this._mSyncRefs[this._topSyncRefId].focusLast);}if(window.FileReader){var $=this.$("hdr");$.bind('dragover',q.proxy(this._handleDragover,this)).bind('dragend',q.proxy(this._handleDragend,this)).bind('drop',q.proxy(this._handleDrop,this));var b=this.$("bgImg");b.bind('dragover',q.proxy(this._handleDragover,this)).bind('dragend',q.proxy(this._handleDragend,this)).bind('drop',q.proxy(this._handleDrop,this));}var s=(this._oFacetBar.getAssociatedItems().length>0);var f=this.$("facetBar");f.css("display",(s?"block":"none"));this._adaptContentHeight();this._bRtl=sap.ui.getCore().getConfiguration().getRTL();if(this._getPersonalization().hasChanges()){this._getPersonalization().applySettings(this._getPersonalization().oSettings);}if(!this._oPaneItemNavigation){this._oPaneItemNavigation=new sap.ui.core.delegate.ItemNavigation().setCycling(false);this.addDelegate(this._oPaneItemNavigation);}var p=this.$("paneBarEntries");this._updatePaneBarItemNavigation(p);this._setNotifyVisibility();if(a.FIRST_RENDERING){q(window).bind("resize",this._checkResizeClosure);}this._checkResize();a.FIRST_RENDERING=false;if(!!sap.ui.Device.browser.firefox&&sap.ui.Device.browser.version==17){q.sap.delayedCall(500,this,this._checkResize);}};a.prototype._updateThemeVariables=function(){a.SIDE_BAR_BASE_WIDTH=parseInt(P.get("sapUiUx3ShellSideBarBaseWidth"),10);a.PANE_OVERFLOW_BUTTON_HEIGHT=parseInt(P.get("sapUiUx3ShellPaneOverflowButtonHeight"),10);a.PANE_OVERFLOW_BUTTON_MAX_HEIGHT=a.PANE_OVERFLOW_BUTTON_HEIGHT;};a.prototype._checkResize=function(){if(!this.getDomRef()){return;}q.sap.clearDelayedCall(this._checkResizeDelayId);this._checkResizeDelayId=q.sap.delayedCall(100,this,function(){this._rerenderPaneBarItems();this._checkToolPaletteSize();});};a.prototype._checkToolPaletteSize=function(h){if(!this.getDomRef()){return;}if(h===undefined){h=!this.getShowTools();}var t=this.$("tp");var c=1;var L=9999999;var i=0;var k=true;if(h){c=0;k=false;}do{var b=c*a.SIDE_BAR_BASE_WIDTH;var s=Math.floor(b/2);var d=Math.floor(b/4);var e=this._bRtl?"right":"left";this.$("canvas").css(e,b+"px");this.$("canvasBackground").css(e,b+"px");this.$("wBar").css("margin-"+e,b+"px");var p={};p[e]=b+"px";this.$("notify").css(p);t.css("width",b+"px");var p={};p["width"]=s+"px";p["margin-"+e]=d+"px";this.$("tp-separator").css(p);if(!k){break;}sap.ui.core.RenderManager.forceRepaint(t[0]);i=t.children().last()[0].offsetTop;if(i>=L){c--;k=false;continue;}L=i;c++;if(c>10){q.sap.log.error("The ToolPalette is growing too much, this must be a bug.");break;}}while(i>t.height());this.currentToolPaletteWidth=this.getShowTools()?b:0;this._updateOverlaysOnToolPaletteChange();};a.prototype._updateOverlaysOnToolPaletteChange=function(){var o=this._getSyncRefs();if(this._bRtl){o.css("right",this.currentToolPaletteWidth+"px");}else{o.css("left",this.currentToolPaletteWidth+"px");}};a.prototype._updatePaneBarItemNavigation=function(p){this._oPaneItemNavigation.setRootDomRef(p[0]);var b=p.children().toArray();this._oPaneItemNavigation.setItemDomRefs(b);if(this._oPaneItemNavigation.getFocusedIndex()>b.length){this._oPaneItemNavigation.setFocusedIndex(-1);}this._checkPaneBarOverflow(p);};a.prototype._checkPaneBarOverflow=function(p){q.sap.clearDelayedCall(this._checkPaneBarOverflowDelayId);this._checkPaneBarOverflowDelayId=q.sap.delayedCall(200,this,function(){this._delayedCheckPaneBarOverflow(p);});};a.prototype._delayedCheckPaneBarOverflow=function(p){if(!p){p=this.$("paneBarEntries");}if(p.length==0){this._checkPaneBarOverflow();return;}var L=p.parent().height()-(this._bRtl?p.innerHeight():0);var I=0;var e=p.children();e.css("display","inline-block");var b=false;var c=e.length;for(var i=c-1;i>=0;--i){var d=e[i];if(this._bRtl){I=(0-d.offsetLeft);}else{I=d.offsetLeft+d.offsetWidth;}var f=I<L;q(d).css("display",f?"inline-block":"none");sap.ui.getCore().byId(d.id+"-overflow").setVisible(!f);if(f){continue;}else{b=true;}}var o=this.$("paneBarOverflowButton");if(b){o.css("display","block");}else{o.css("display","none");if(!!sap.ui.Device.browser.firefox&&sap.ui.Device.browser.version==17){sap.ui.core.RenderManager.forceRepaint(document.getElementsByTagName("body")[0]);}}var O=this._changeOverflowButton();if(O){this._checkPaneBarOverflow();}};a.prototype._adaptOverflowButtonHeight=function(){var b=this.$("paneBarOverflowButton");var B=this.$("paneBarOverflowWrapper");var $=this.$("paneBarOverflowText");var p=this.$("paneBarRight");$.css("width","");var o=a.PANE_OVERFLOW_BUTTON_HEIGHT;var s=$[0].scrollWidth+5;if(s>a.PANE_OVERFLOW_BUTTON_MAX_HEIGHT){a.PANE_OVERFLOW_BUTTON_HEIGHT=a.PANE_OVERFLOW_BUTTON_MAX_HEIGHT;}else{a.PANE_OVERFLOW_BUTTON_HEIGHT=s;}b.css("height",a.PANE_OVERFLOW_BUTTON_HEIGHT);B.css("width",a.PANE_OVERFLOW_BUTTON_HEIGHT);$.css("width","100%");p.css("padding-bottom",a.PANE_OVERFLOW_BUTTON_HEIGHT+"px");return(o!=a.PANE_OVERFLOW_BUTTON_HEIGHT);};a.prototype._changeOverflowButton=function(){var o=null;if(this._sOpenPaneId){o=sap.ui.getCore().byId(this._sOpenPaneId+"-overflow");}var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3").getText("SHELL_MORE_BUTTON");var s=false;if(o&&o.getVisible()){t=o.getText();s=true;}t=t.toUpperCase();var b=this.$("paneBarOverflowText");b.text(t);b.attr("title",t);b.toggleClass("sapUiUx3ShellPaneEntrySelected",s);return this._adaptOverflowButtonHeight();};a.prototype._getPaneOverflowMenu=function(){return this.getAggregation("_paneOverflowMenu");};a.prototype.getFocusInfo=function(){try{var e=document.activeElement;return e?{'sFocusId':e.id,'oFocusedElement':e}:{};}catch(b){return{};}};a.prototype.applyFocusInfo=function(f){var e=q.sap.domById(f.sFocusId)||f.oFocusedElement;q.sap.focus(e);};a._updateToolIcon=function(d){if(d&&d.firstChild){var $=q(d);var t=d.id.substr(d.id.indexOf(a.TOOL_PREFIX)+6);var b=sap.ui.getCore().byId(t);var i;if($.is(".sapUiUx3ShellToolSelected")){i=b.getIconSelected();}else if($.is(".sapUiUx3ShellToolHover")){i=b.getIconHover();}else{i=b.getIcon();}d.firstChild.src=i;}};a.prototype.onclick=function(e){this.onUserActivation(e);};a.prototype.onsapspace=function(e){this.onUserActivation(e);};a.prototype.onsapenter=function(e){this.onUserActivation(e);};a.prototype.onUserActivation=function(e){var t=e.target.id;var p=e.target.parentNode;var i=this.getId();if(e.target.className&&e.target.className.indexOf&&e.target.className.indexOf("sapUiUx3ShellHeader-logout")>-1){this.fireLogout();}else if(p&&p.parentNode&&p.parentNode.className&&p.parentNode.className.indexOf&&p.parentNode.className.indexOf("sapUiUx3ShellToolPaletteArea")>-1){this._handleToolItemClick(t);}else if(p&&p.parentNode&&p.parentNode.parentNode&&p.parentNode.parentNode.className&&p.parentNode.parentNode.className.indexOf&&p.parentNode.parentNode.className.indexOf("sapUiUx3ShellToolPaletteArea")>-1){this._handleToolItemClick(p.id);}else if(t===i+"-paneBarOverflowText"){var T=this.$("paneBarOverflowButton")[0];this._getPaneOverflowMenu().open(true,T,(this._bRtl?"left":"right")+" bottom","center center",T);}else if(t){if(p&&p.className&&p.className.indexOf&&p.className.indexOf("sapUiUx3ShellPaneEntries")>-1){this._handlePaneBarItemClick(t);}}};a.prototype._handleWorksetBarSelect=function(e){var p=this._handleWorksetItemClick(e.getParameter("item"));if(!p){e.preventDefault();}};a.prototype._handleFacetBarSelect=function(e){var p=this._handleWorksetItemClick(e.getParameter("item"));if(!p){e.preventDefault();}};a.prototype._handleWorksetItemClick=function(e){var p=e.getParent(),i=e.getId(),f=i,b=true;if(p instanceof a){if(i!=this._sSelectedWorksetId){var s=e.getSubItems();if(s.length>0){f=s[0].getId();}b=this._fireWorksetItemSelected(f);if(b){this._sSelectedWorksetId=i;if(s.length>0){this._sSelectedFacetId=s[0].getId();i=this._sSelectedFacetId;}else{this._sSelectedFacetId=null;}var s=e.getSubItems();this._oFacetBar.setAssociatedItems(s,true);var F=this.$("facetBar");var c=this._calcFacetBarHeight(F);if(s.length>0){if(!this._oFacetBar.isSelectedItemValid()){this._oFacetBar.setSelectedItem(s[0]);this._sSelectedFacetId=s[0].getId();}F.slideDown();this._adaptContentHeight(null,true,c);}else{this._oFacetBar.setSelectedItem(null);F.slideUp();this._adaptContentHeight(null,true,c);}}}}else{if(i!=this._sSelectedFacetId){b=this._fireWorksetItemSelected(f);if(b){this._sSelectedFacetId=i;}}}return b;};a.prototype._fireWorksetItemSelected=function(i){var b=sap.ui.getCore().byId(i);var k=(b?b.getKey():null);var p=this.fireWorksetItemSelected({id:i,item:b,key:k});if(p){this.setAssociation("selectedWorksetItem",i,true);}return p;};a.prototype._closeCurrentToolPopup=function(){var o;if(this._oOpenToolPopup){o=this._oOpenToolPopup.getId();q.sap.byId(this.getId()+a.TOOL_PREFIX+this._oOpenToolPopup.getId()).removeClass("sapUiUx3ShellToolSelected").attr("aria-pressed","false");if(o===this.getId()+"-feederTool"){var f=sap.ui.getCore().byId(this.getId()+"-feeder");f.setText("");f.rerender();}this._oOpenToolPopup.close();this._oOpenToolPopup=null;}return o;};a.prototype._handleToolItemClick=function(i){var A=this._closeCurrentToolPopup();var t;var b=i.substr(i.indexOf(a.TOOL_PREFIX)+6);if(b==(this.getId()+"-searchTool")){t=this._getSearchTool();}else if(b==(this.getId()+"-feederTool")){t=this._getFeederTool();}else{t=sap.ui.getCore().byId(b);}if(t&&(t.getId()!=A)){this._oOpenToolPopup=t;t.setPosition(sap.ui.core.Popup.Dock.BeginTop,sap.ui.core.Popup.Dock.EndTop,q.sap.domById(i),"13 -6","fit");t.open();q.sap.byId(i).addClass("sapUiUx3ShellToolSelected").attr("aria-pressed","true");a._updateToolIcon(q.sap.domById(i));var c=this;var o=function(e){t.detachClosed(o);if(c._oOpenToolPopup&&c._oOpenToolPopup.getId()===e.getParameter("id")){c._closeCurrentToolPopup();}q.sap.byId(i).removeClass("sapUiUx3ShellToolSelected");a._updateToolIcon(q.sap.domById(i));};t.attachClosed(o);}else if(t.getId()==A){a._updateToolIcon(q.sap.domById(i));}};a.prototype._hasDarkDesign=function(){return(this.getDesignType()!==sap.ui.ux3.ShellDesignType.Light&&this.getDesignType()!==sap.ui.ux3.ShellDesignType.Crystal);};a.prototype._getSearchTool=function(){if(!this._oSearchPopup){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._oSearchPopup=new sap.ui.ux3.ToolPopup(this.getId()+"-searchTool",{tooltip:r.getText("SHELL_SEARCH")}).addStyleClass("sapUiUx3TP-search");var i=this._hasDarkDesign();this._oSearchPopup.setInverted(i);var t=this;var s=new sap.ui.commons.SearchField(this.getId()+"-searchField",{enableListSuggest:false,search:function(e){t.fireSearch({text:e.getParameter("query")});}});var b=new sap.ui.commons.Label({text:r.getText("SHELL_SEARCH_LABEL")+":"}).setLabelFor(s);this._oSearchPopup.addContent(b).addContent(s);this._oSearchPopup.attachOpen(function(){window.setTimeout(function(){s.focus();},100);});this._oSearchField=s;}return this._oSearchPopup;};a.prototype.getSearchField=function(){if(!this._oSearchField){this._getSearchTool();}return this._oSearchField;};a.prototype._getFeederTool=function(){if(!this._oFeederPopup){var t=this;var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._oFeederPopup=new sap.ui.ux3.ToolPopup(this.getId()+"-feederTool",{tooltip:r.getText("SHELL_FEEDER")}).addStyleClass("sapUiUx3TP-feeder");var i=this._hasDarkDesign();this._oFeederPopup.setInverted(i);var f=new sap.ui.ux3.Feeder(this.getId()+"-feeder",{type:sap.ui.ux3.FeederType.Medium,submit:function(e){t.fireFeedSubmit({text:e.getParameter("text")});f.setText("");f.rerender();t._oFeederPopup.close();}});this._oFeederPopup.setInitialFocus(this.getId()+"-feeder");this._oFeederPopup.attachClose(function(){f.setText("");});this._oFeederPopup.addContent(f);}return this._oFeederPopup;};a.prototype.openPane=function(p){var t=this;var i=sap.ui.getCore().byId(p);if(i&&(p!=this._sOpenPaneId)&&this.getShowPane()){var k;if(i){if(i.getKey()==""){k=null;}else{k=i.getKey();}}else{k=null;}this.firePaneBarItemSelected({"id":p,"item":i,"key":k});var o=q.sap.byId(p);o.siblings().removeClass("sapUiUx3ShellPaneEntrySelected");o.addClass("sapUiUx3ShellPaneEntrySelected");if(!this._sOpenPaneId){this._openPane(function(){t.focusPaneStart();});}else{q.sap.byId(this.getId()+"-pb_"+this._sOpenPaneId).removeClass("sapUiUx3ShellPaneEntrySelected");}this._sOpenPaneId=p;}return this;};a.prototype.closePane=function(){this._closePane();return this;};a.prototype.isPaneOpen=function(){return(this._sOpenPaneId!=null);};a.prototype._handlePaneBarItemClick=function(p){if(p===this._sOpenPaneId){this.closePane();}else{this.openPane(p);}this._checkPaneBarOverflow();};(function(){a._SHELL_OFFSET_RIGHT=0;a.prototype._closePane=function(c){if(!this._sOpenPaneId){if(c){c();}return;}var o=this._sOpenPaneId;var t=this;var i=this.getId();var d=this.getShowPane()?(q.sap.byId(i+"-paneBarRight").outerWidth()+a._SHELL_OFFSET_RIGHT):a._SHELL_OFFSET_RIGHT;var p={};p[this._bRtl?"left":"right"]=d+"px";var b={};b[this._bRtl?"marginLeft":"marginRight"]=(d-a._SHELL_OFFSET_RIGHT)+"px";q.sap.byId(i+"-content").css("overflow-x","hidden");q.sap.byId(i+"-canvas").stop().animate(p);q.sap.byId(i+"-notify").stop().animate(p);this._getSyncRefs().stop(false,true).animate(p);q.sap.byId(i+"-wBar").stop().animate(b);q.sap.byId(i+"-paneBar").removeClass("sapUiUx3ShellPaneBarOpened").addClass("sapUiUx3ShellPaneBarClose");q.sap.byId(i+"-canvasBackground").removeClass("sapUiUx3ShellCanvasBackgroundOpen").addClass("sapUiUx3ShellCanvasBackgroundClosed").stop().animate(p,function(){q.sap.byId(i+"-paneBar").removeClass("sapUiUx3ShellPaneBarOpen");q.sap.byId(i+"-content").css("overflow-x","");if(c){c();}t.firePaneClosed({"id":o});});q.sap.byId(this._sOpenPaneId).removeClass("sapUiUx3ShellPaneEntrySelected");this._sOpenPaneId=null;};a.prototype._openPane=function(o){var i=this.getId();var b=this.getPaneWidth();var p=q.sap.byId(i+"-paneBarRight").outerWidth();q.sap.byId(i+"-content").css("overflow-x","hidden");if(this._bRtl){q.sap.byId(i+"-paneBar").removeClass("sapUiUx3ShellPaneBarClose").addClass("sapUiUx3ShellPaneBarOpen");q.sap.byId(i+"-wBar").stop().animate({marginLeft:(b+p)+"px"});q.sap.byId(i+"-canvas").stop().animate({left:(b+p+a._SHELL_OFFSET_RIGHT)+"px"});q.sap.byId(i+"-notify").stop().animate({left:(b+p+a._SHELL_OFFSET_RIGHT)+"px"});this._getSyncRefs().stop(false,true).animate({left:(b+p+a._SHELL_OFFSET_RIGHT)+"px"});q.sap.byId(i+"-canvasBackground").stop().animate({left:(b+p+a._SHELL_OFFSET_RIGHT)+"px"},function(){q.sap.byId(i+"-content").css("overflow-x","");q.sap.byId(i+"-canvasBackground").removeClass("sapUiUx3ShellCanvasBackgroundClosed").addClass("sapUiUx3ShellCanvasBackgroundOpen");q.sap.byId(i+"-paneBar").addClass("sapUiUx3ShellPaneBarOpened");if(o){o();}});}else{q.sap.byId(i+"-paneBar").removeClass("sapUiUx3ShellPaneBarClose").addClass("sapUiUx3ShellPaneBarOpen");q.sap.byId(i+"-wBar").stop().animate({marginRight:(b+p)+"px"});q.sap.byId(i+"-canvas").stop().animate({right:(b+p+a._SHELL_OFFSET_RIGHT)+"px"});q.sap.byId(i+"-notify").stop().animate({right:(b+p+a._SHELL_OFFSET_RIGHT)+"px"});this._getSyncRefs().stop(false,true).animate({right:(b+p+a._SHELL_OFFSET_RIGHT)+"px"});q.sap.byId(i+"-canvasBackground").stop().animate({right:(b+p+a._SHELL_OFFSET_RIGHT)+"px"},function(){q.sap.byId(i+"-content").css("overflow-x","");q.sap.byId(i+"-canvasBackground").removeClass("sapUiUx3ShellCanvasBackgroundClosed").addClass("sapUiUx3ShellCanvasBackgroundOpen");q.sap.byId(i+"-paneBar").addClass("sapUiUx3ShellPaneBarOpened");if(o){o();}});}};a.prototype.setPaneWidth=function(w){if(typeof w=="number"&&(w>0)){w=Math.max(w,50);if(this.getDomRef()){var i=this.getId();q.sap.byId(i+"-paneContent").css("width",w+"px");q.sap.byId(i+"-paneBar").css("width",(w+a.SIDE_BAR_BASE_WIDTH)+"px");if(!!this._sOpenPaneId){if(this._bRtl){q.sap.byId(i+"-wBar").css("marginLeft",(w+a.SIDE_BAR_BASE_WIDTH)+"px");q.sap.byId(i+"-canvas").css("left",(w+a.SIDE_BAR_BASE_WIDTH+a._SHELL_OFFSET_RIGHT)+"px");q.sap.byId(i+"-notify").css("left",(w+a.SIDE_BAR_BASE_WIDTH+a._SHELL_OFFSET_RIGHT)+"px");this._getSyncRefs().css("left",(w+a.SIDE_BAR_BASE_WIDTH+a._SHELL_OFFSET_RIGHT)+"px");q.sap.byId(i+"-canvasBackground").css("left",(w+a.SIDE_BAR_BASE_WIDTH+a._SHELL_OFFSET_RIGHT)+"px");}else{q.sap.byId(i+"-wBar").css("marginRight",(w+a.SIDE_BAR_BASE_WIDTH)+"px");q.sap.byId(i+"-canvas").css("right",(w+a.SIDE_BAR_BASE_WIDTH+a._SHELL_OFFSET_RIGHT)+"px");q.sap.byId(i+"-notify").css("right",(w+a.SIDE_BAR_BASE_WIDTH+a._SHELL_OFFSET_RIGHT)+"px");this._getSyncRefs().css("right",(w+a.SIDE_BAR_BASE_WIDTH+a._SHELL_OFFSET_RIGHT)+"px");q.sap.byId(i+"-canvasBackground").css("right",(w+a.SIDE_BAR_BASE_WIDTH+a._SHELL_OFFSET_RIGHT)+"px");}}}this.setProperty("paneWidth",w,true);}return this;};a.prototype.setOffsetRight=function(p,c,o){if(p<0){p=0;}if(p>600){p=600;}a._SHELL_OFFSET_RIGHT=p;var b=p+"px";var i=this.getId();var d=this._bRtl?{"left":b}:{"right":b};q.sap.byId(i+"-hdr").stop().animate(d);q.sap.byId(i+"-hdrImg").stop().animate(d);q.sap.byId(i+"-bg").stop().animate(d,function(){if(c){c();}});q.sap.byId(i+"-bgImg").stop().animate(d);q.sap.byId(i+"-wBar").stop().animate(d);q.sap.byId(i+"-paneBar").stop().animate(d);q.sap.byId(o).stop().animate({"width":b});if(!this.$().hasClass("sapUiUx3ShellNoPane")){b=(p+(this._sOpenPaneId?this.getPaneWidth():0)+a.SIDE_BAR_BASE_WIDTH)+"px";}d=this._bRtl?{"left":b}:{"right":b};q.sap.byId(i+"-notify").stop().animate(d);this._getSyncRefs().stop(false,true).animate(d);q.sap.byId(i+"-canvas").stop().animate(d);q.sap.byId(i+"-canvasBackground").stop().animate(d);};a.prototype._refreshCanvasOffsetRight=function(p){var i=this.getId();var r=this._bRtl?"left":"right";var b=a._SHELL_OFFSET_RIGHT;if(p){var c=q.sap.byId(i+"-paneBarRight").outerWidth();b=b+(this._sOpenPaneId?this.getPaneWidth():0)+c;}b=b+"px";q.sap.byId(i+"-notify").css(r,b);q.sap.byId(i+"-canvas").css(r,b);q.sap.byId(i+"-canvasBackground").css(r,b);this._getSyncRefs().css(r,b);};a.prototype._setNotifyVisibility=function(v){var n=this.getNotificationBar();if(!n){return;}if(!v){v=n.getVisibleStatus();}var $=this.$("notify");var b=this._topSyncRefId?q.sap.byId(this._topSyncRefId):q(null);var i=b.hasClass("sapUiUx3TI");var h=0;var B=0;if(v===sap.ui.ux3.NotificationBarStatus.Min){h=10;}else if(v===sap.ui.ux3.NotificationBarStatus.Max||v===sap.ui.ux3.NotificationBarStatus.Default){if(this.getHeaderType()===sap.ui.ux3.ShellHeaderType.BrandOnly&&i){h=parseInt(n.getHeightOfStatus(sap.ui.ux3.NotificationBarStatus.Default),10);}else{h=10;}B=h;}$.removeClass("sapUiUx3ShellNotifyTI").removeClass("sapUiUx3ShellNotifyOverlay");if(this._topSyncRefId){this._getSyncRefs().animate({"bottom":B+"px"},"fast");if(B>0){$.addClass(i?"sapUiUx3ShellNotifyTI":"sapUiUx3ShellNotifyOverlay");}}if(v===sap.ui.ux3.NotificationBarStatus.Min){$.css("height",h+"px").css("z-index",1);}else{$.css("height",h+"px").css("z-index",100000);}if(h>0&&!this.$().hasClass("sapUiUx3ShellNotifyVisible")){this.$().addClass("sapUiUx3ShellNotifyVisible");}else if(h==0&&this.$().hasClass("sapUiUx3ShellNotifyVisible")){this.$().removeClass("sapUiUx3ShellNotifyVisible");}this._adaptContentHeight(v);};a.prototype.syncWithCanvasSize=function(i,I,f,F,A){var b=q.inArray(i,this._aSyncRefStack);if(I){var r={id:i,focusFirst:f,focusLast:F,applyChanges:A};if(b<0){this._aSyncRefStack.push(i);}this._mSyncRefs[i]=r;r.applyChanges({showOverlay:this.getHeaderType()!==sap.ui.ux3.ShellHeaderType.BrandOnly});}else{if(b>=0){delete this._mSyncRefs[i];this._aSyncRefStack.splice(b,1);}}this.$("canvas").removeAttr("aria-hidden");this.$("focusDummyTPStart").removeAttr("tabindex").unbind("focusin");this.$("focusDummyTPEnd").removeAttr("tabindex").unbind("focusin");this.$("focusDummyHdrStart").removeAttr("tabindex").unbind("focusin");this.$("focusDummyHdrEnd").removeAttr("tabindex").unbind("focusin");this.$("focusDummyPane").removeAttr("tabindex").unbind("focusin");this.$().toggleClass("sapUiUx3ShellBlockHeaderAccess",false);delete this._topSyncRefId;if(this._aSyncRefStack.length>0){var r=this._mSyncRefs[this._aSyncRefStack[this._aSyncRefStack.length-1]];var d=this._getSyncRefs();var c=this.getDomRef("canvas");d.css(this._bRtl?"right":"left",(this.getShowTools()?this.currentToolPaletteWidth:0)+"px");var R=a._SHELL_OFFSET_RIGHT;if(this.getShowPane()){R+=a.SIDE_BAR_BASE_WIDTH;if(this._sOpenPaneId){R+=this.getPaneWidth();}}d.css(this._bRtl?"left":"right",R+"px");d.css("top",q.sap.domById(this.getId()+(this.getAllowOverlayHeaderAccess()?"-hdr":"-hdrLine")).offsetHeight+"px");d.css("bottom","0");q(c).attr("aria-hidden","true");this.$("focusDummyTPEnd").attr("tabindex","0").focusin(r.focusFirst);this.$("focusDummyHdrStart").attr("tabindex","0").focusin(q.proxy(this.focusPaneEnd,this));this.$("focusDummyHdrEnd").attr("tabindex","0").focusin(q.proxy(this.focusFirstTool,this));this.$("focusDummyTPStart").attr("tabindex","0").focusin(q.proxy(this.focusLastHdr,this));this.$("focusDummyPane").attr("tabindex","0").focusin(r.focusLast);this.$().toggleClass("sapUiUx3ShellBlockHeaderAccess",!this.getAllowOverlayHeaderAccess());this._topSyncRefId=r.id;}q.sap.require("jquery.sap.script");if(this._sUpdateNotificationZIndex){q.sap.clearDelayedCall(this._sUpdateNotificationZIndex);delete this._sUpdateNotificationZIndex;}this._sUpdateNotificationZIndex=q.sap.delayedCall(0,this,function(){delete this._sUpdateNotificationZIndex;this._setNotifyVisibility();if(this._oOpenToolPopup&&this._topSyncRefId){var $=q.sap.byId(this._topSyncRefId);this._oOpenToolPopup.$().css("z-index",parseInt($.css("z-index"),10)+1);}});};}());a.prototype._getSyncRefs=function(){var r=[];var R;for(var i=0;i<this._aSyncRefStack.length;i++){R=q.sap.domById(this._aSyncRefStack[i]);if(R){r.push(R);}}return q(r);};a.prototype.focusFirstHdr=function(){var t=this.$("hdr-items").firstFocusableDomRef();if(t&&this.getAllowOverlayHeaderAccess()&&this.getHeaderType()!=sap.ui.ux3.ShellHeaderType.BrandOnly){q.sap.focus(t);}else{this.focusFirstTool();}};a.prototype.focusLastHdr=function(){var t=this.$("hdr-items").lastFocusableDomRef();if(t&&this.getAllowOverlayHeaderAccess()&&this.getHeaderType()!=sap.ui.ux3.ShellHeaderType.BrandOnly){q.sap.focus(t);}else{this.focusPaneEnd();}};a.prototype.focusFirstTool=function(){var $=this.$("tp").find(".sapUiUx3ShellTool").first();if($.length&&this.getShowTools()){q.sap.focus($[0]);}else{this._mSyncRefs[this._topSyncRefId].focusFirst();}};a.prototype.focusLastTool=function(){var $=this.$("tp").find(".sapUiUx3ShellTool").last();if($.length&&this.getShowTools()){q.sap.focus($[0]);}else{this.focusPaneEnd();}};a.prototype.focusPaneStart=function(){var t=this.$("paneBar").firstFocusableDomRef();if(t){q.sap.focus(t);}else{this.focusFirstTool();}};a.prototype.focusPaneEnd=function(){var t=this.$("paneBar").lastFocusableDomRef();if(t){q.sap.focus(t);}else{this._mSyncRefs[this._topSyncRefId].focusLast();}};a.prototype.setAppTitle=function(A){this.setProperty("appTitle",A,true);this._rerenderHeader();return this;};a.prototype.setAppIcon=function(A){this.setProperty("appIcon",A,true);this._rerenderHeader();return this;};a.prototype.setShowLogoutButton=function(s){this.setProperty("showLogoutButton",s,true);this._rerenderHeader();return this;};a.prototype.setLogoutButtonTooltip=function(t){this.setProperty("logoutButtonTooltip",t,true);this._rerenderHeader();return this;};a.prototype.insertHeaderItem=function(h,i){if(sap.ui.commons&&sap.ui.commons.Button&&(h instanceof sap.ui.commons.Button)){h.setStyled(false);}this.insertAggregation("headerItems",h,i,true);this._rerenderHeader();return this;};a.prototype.addHeaderItem=function(h){if(sap.ui.commons&&sap.ui.commons.Button&&(h instanceof sap.ui.commons.Button)){h.setStyled(false);}this.addAggregation("headerItems",h,true);this._rerenderHeader();return this;};a.prototype.removeHeaderItem=function(i){var r=this.removeAggregation("headerItems",i,true);this._rerenderHeader();return r;};a.prototype.removeAllHeaderItems=function(){var r=this.removeAllAggregation("headerItems",true);this._rerenderHeader();return r;};a.prototype.destroyHeaderItems=function(){this.destroyAggregation("headerItems",true);this._rerenderHeader();return this;};a.prototype.setShowSearchTool=function(s){this.setProperty("showSearchTool",s,true);this._rerenderToolPalette();return this;};a.prototype.setShowFeederTool=function(s){this.setProperty("showFeederTool",s,true);this._rerenderToolPalette();return this;};a.prototype.setHeaderType=function(h){var c=this.getHeaderType();this.setProperty("headerType",h,true);this.$().removeClass("sapUiUx3ShellHead"+c).addClass("sapUiUx3ShellHead"+this.getHeaderType());var s=this._getSyncRefs();if(s.length){s.css("top",q.sap.domById(this.getId()+(this.getAllowOverlayHeaderAccess()?"-hdr":"-hdrLine")).offsetHeight+"px");}var o={showOverlay:h!==sap.ui.ux3.ShellHeaderType.BrandOnly};q.each(this._mSyncRefs,function(i,r){r.applyChanges(o);});return this;};a.prototype.setAllowOverlayHeaderAccess=function(A){this.setProperty("allowOverlayHeaderAccess",A,true);var s=this._getSyncRefs();if(s.length){this.$().toggleClass("sapUiUx3ShellBlockHeaderAccess",!this.getAllowOverlayHeaderAccess());s.css("top",q.sap.domById(this.getId()+(this.getAllowOverlayHeaderAccess()?"-hdr":"-hdrLine")).offsetHeight+"px");}return this;};a.prototype.setDesignType=function(d){var c=this.getDesignType();this.setProperty("designType",d,true);var I=this._hasDarkDesign();if(this._oSearchPopup){this._oSearchPopup.setInverted(I);}if(this._oFeederPopup){this._oFeederPopup.setInverted(I);}var t=this.getToolPopups();for(var i=0;i<t.length;++i){t[i].setInverted(I);}this.$().removeClass("sapUiUx3ShellDesign"+c).addClass("sapUiUx3ShellDesign"+d).toggleClass("sapUiUx3ShellDesignLight",!I);return this;};a.prototype.setShowTools=function(s){this.setProperty("showTools",s,true);if(s){this.$().removeClass("sapUiUx3ShellNoTools");this._checkResize();}else{this.$().addClass("sapUiUx3ShellNoTools");this._closeCurrentToolPopup();this.$("tp").attr("style","");}this._checkToolPaletteSize(true);return this;};a.prototype.setShowPane=function(s){this.setProperty("showPane",s,true);if(s){this.$().removeClass("sapUiUx3ShellNoPane");this._refreshCanvasOffsetRight(true);this._checkPaneBarOverflow();}else{var t=this;this._closePane(function(){t._refreshCanvasOffsetRight(false);t.$().addClass("sapUiUx3ShellNoPane");});}return this;};a.prototype.insertToolPopup=function(t,i){this.insertAggregation("toolPopups",t,i,true);t.attachIconChanged(this._rerenderToolPalette,this);this._rerenderToolPalette();return this;};a.prototype.addToolPopup=function(t){var i=this._hasDarkDesign();t.setInverted(i);this.addAggregation("toolPopups",t,true);t.attachIconChanged(this._rerenderToolPalette,this);this._rerenderToolPalette();return this;};a.prototype.removeToolPopup=function(i){var r=this.removeAggregation("toolPopups",i,true);if(r===this._oOpenToolPopup){this._closeCurrentToolPopup();}this._rerenderToolPalette();return r;};a.prototype.removeAllToolPopups=function(){var r=this.removeAllAggregation("toolPopups",true);this._rerenderToolPalette();return r;};a.prototype.destroyToolPopups=function(){this.destroyAggregation("toolPopups",true);this._rerenderToolPalette();return this;};a.prototype.insertContent=function(c,i){this.insertAggregation("content",c,i,true);this._rerenderContent();return this;};a.prototype.addContent=function(c){this.addAggregation("content",c,true);this._rerenderContent();return this;};a.prototype.removeContent=function(i){var r=this.removeAggregation("content",i,true);this._rerenderContent();return r;};a.prototype.removeAllContent=function(){var r=this.removeAllAggregation("content",true);this._rerenderContent();return r;};a.prototype.destroyContent=function(){this.destroyAggregation("content",true);this._rerenderContent();return this;};a.prototype.addPaneBarItem=function(p){this.addAggregation("paneBarItems",p,true);this._rerenderPaneBarItems();return this;};a.prototype.insertPaneBarItem=function(p,i){this.insertAggregation("paneBarItems",p,i,true);this._rerenderPaneBarItems();return this;};a.prototype.removePaneBarItem=function(p){var r=this.removeAggregation("paneBarItems",p,true);if(r){var i=sap.ui.getCore().byId(r.getId()+"-overflow");if(i){i.destroy();}}this._rerenderPaneBarItems();return r;};a.prototype.removeAllPaneBarItems=function(){var r=this.removeAllAggregation("paneBarItems",true);this._getPaneOverflowMenu().destroyItems();this._rerenderPaneBarItems();return r;};a.prototype.destroyPaneBarItems=function(){this.destroyAggregation("paneBarItems",true);this._getPaneOverflowMenu().destroyItems();this._rerenderPaneBarItems();return this;};a.prototype.addWorksetItem=function(w){this.addAggregation("worksetItems",w,true);this._rerenderWorksetItems();return this;};a.prototype.insertWorksetItem=function(w,i){this.insertAggregation("worksetItems",w,i,true);this._rerenderWorksetItems();return this;};a.prototype.removeWorksetItem=function(w){var r=this.removeAggregation("worksetItems",w,true);this._rerenderWorksetItems();return r;};a.prototype.removeAllWorksetItems=function(){var r=this.removeAllAggregation("worksetItems",true);this._rerenderWorksetItems();return r;};a.prototype.destroyWorksetItems=function(){this.destroyAggregation("worksetItems",true);this._rerenderWorksetItems();return this;};(function(){function c(s){var o=s.getNotificationBar();if(o){s._setNotifyVisibility(sap.ui.ux3.NotificationBarStatus.None);o.setVisibleStatus=o.__orig_setVisibleStatus;o.detachDisplay(o.__fHandleNotifyDisplay);delete o.__orig_setVisibleStatus;delete o.__fHandleNotifyDisplay;}}a.prototype.setNotificationBar=function(n){c(this);if(n){var t=this;n.__orig_setVisibleStatus=n.setVisibleStatus;n.setVisibleStatus=function(v){this.__orig_setVisibleStatus.apply(this,arguments);t._setNotifyVisibility();};}this.setAggregation("notificationBar",n,true);this._rerenderNotificationArea();if(n){n.__fHandleNotifyDisplay=function(e){var s=e?e.getParameter("show"):n.hasItems();n.setVisibleStatus(s?sap.ui.ux3.NotificationBarStatus.Default:sap.ui.ux3.NotificationBarStatus.None);};n.attachDisplay(n.__fHandleNotifyDisplay);n.__fHandleNotifyDisplay();}return this;};a.prototype.destroyNotificationBar=function(){c(this);this.destroyAggregation("notificationBar",true);this._rerenderNotificationArea();return this;};}());a.prototype._rerenderNotificationArea=function(){var $=this.$("notify");if($.length>0){var r=sap.ui.getCore().createRenderManager();sap.ui.ux3.ShellRenderer.renderNotificationArea(r,this);r.flush($[0],true);r.destroy();}};a.prototype._rerenderHeader=function(){var $=this.$("hdr");if($.length>0){var r=sap.ui.getCore().createRenderManager();sap.ui.ux3.ShellRenderer.renderHeader(r,this);r.flush($[0],true);r.destroy();}};a.prototype._rerenderToolPalette=function(){var $=this.$("tp");if($.length>0){var r=sap.ui.getCore().createRenderManager();this._beforeRenderingToolPalette();sap.ui.ux3.ShellRenderer.renderToolPalette(r,this);r.flush($[0],true);this._afterRenderingToolPalette();r.destroy();this._checkResize();}};a.prototype._beforeRenderingToolPalette=function(){this.$("tp").find(".sapUiUx3ShellTool").unbind("mouseenter mouseleave");this.$("focusDummyTPEnd").unbind("focusin");this.$("focusDummyTPStart").unbind("focusin");};a.prototype._afterRenderingToolPalette=function(){var I=this.getId()+a.TOOL_PREFIX;var t=this.getToolPopups();var v=false;if(this._oOpenToolPopup&&this._oOpenToolPopup.isOpen()&&(this.indexOfToolPopup(this._oOpenToolPopup)>=0||this._oOpenToolPopup===this._oSearchPopup||this._oOpenToolPopup===this._oFeederPopup)){this._oOpenToolPopup.setPosition(sap.ui.core.Popup.Dock.BeginTop,sap.ui.core.Popup.Dock.EndTop,q.sap.domById(I+this._oOpenToolPopup.getId()),"13 -6","fit");var p=q.sap.domById(I+this._oOpenToolPopup.getId());q(p).toggleClass("sapUiUx3ShellToolSelected",true);a._updateToolIcon(p);v=true;}if(!v&&this._oOpenToolPopup){this._closeCurrentToolPopup();}for(var i=0;i<t.length;i++){var T=t[i];if(T instanceof sap.ui.ux3.ToolPopup){q.sap.byId(I+T.getId()).hover(function(e){q(this).toggleClass("sapUiUx3ShellToolHover",(e.type==="mouseenter"));a._updateToolIcon(this);});}}if(this._topSyncRefId&&this._mSyncRefs[this._topSyncRefId].focusFirst){this.$("focusDummyTPEnd").attr("tabindex","0").focusin(this._mSyncRefs[this._topSyncRefId].focusFirst);}if(this._aSyncRefStack.length>0){this.$("focusDummyTPStart").attr("tabindex","0").focusin(q.proxy(this.focusLastHdr,this));}};a.prototype._rerenderContent=function(p){var $=this.$("content");if($.length>0){var c=this.getContent(),r=sap.ui.getCore().createRenderManager();for(var i=0;i<c.length;i++){r.renderControl(c[i]);}r.flush($[0],p);r.destroy();}};a.prototype._rerenderPane=function(p){var $=this.$("paneContent");if($.length>0){var b=this.getPaneContent(),r=sap.ui.getCore().createRenderManager();for(var i=0;i<b.length;i++){r.renderControl(b[i]);}r.flush($[0],p);r.destroy();}};a.prototype._rerenderPaneBarItems=function(){var p=this.$("paneBar").find(".sapUiUx3ShellPaneEntries");if(p.length>0){var r=sap.ui.getCore().createRenderManager();sap.ui.ux3.ShellRenderer.renderPaneBarItems(r,this);r.flush(p[0]);r.destroy();this._updatePaneBarItemNavigation(p);}var t=this;var m=this._getPaneOverflowMenu();var b=this.getPaneBarItems();var o=function(e){var d={overflowItem:e.getParameter("item"),target:{id:e.getParameter("id").replace(/-overflow$/,""),parentNode:{className:"sapUiUx3ShellPaneEntries"}}};t.onUserActivation(d);};for(var i=0;i<b.length;++i){var I=b[i].getId()+"-overflow";var c=sap.ui.getCore().byId(I);if(!c){var O=new sap.ui.commons.MenuItem(I,{text:b[i].getText(),visible:false,select:o});m.addItem(O);}}this._checkPaneBarOverflow(p);};a.prototype._rerenderWorksetItems=function(){if(this.$("wBar").length>0){sap.ui.ux3.ShellRenderer.renderWorksetItems(null,this);sap.ui.ux3.ShellRenderer.renderFacetBar(null,this);var i=this._oFacetBar.getAssociatedItems();this._oFacetBar.$().css("display",(i&&i.length>0?"block":"none"));this._adaptContentHeight();}};a.prototype.forceInvalidation=C.prototype.invalidate;a.prototype.invalidate=function(s){if(!s){this.forceInvalidation();}else if(s instanceof sap.ui.ux3.NavigationItem){if(this._oWorksetBar&&this._oFacetBar){this._oWorksetBar.setAssociatedItems(this.getWorksetItems());var w=this.getSelectedWorksetItem();if(w){var i;var b=sap.ui.getCore().byId(w);if(b&&b.getParent()instanceof sap.ui.ux3.NavigationItem){this._oFacetBar.setAssociatedItems(b.getParent().getSubItems());}else if(b&&(i=b.getSubItems())){if(i&&(i.length>0)){this._oFacetBar.setAssociatedItems(i);}}i=this._oFacetBar.getAssociatedItems();this._oFacetBar.$().css("display",(i&&i.length>0?"block":"none"));this._adaptContentHeight();}}}else if((s instanceof sap.ui.core.Item)&&(s.getParent()==this)){this.forceInvalidation();}else if(s instanceof sap.ui.ux3.ToolPopup){this._rerenderToolPalette();}else if(this.indexOfHeaderItem(s)>=0){this._rerenderHeader();}};a.prototype._setParent=C.prototype.setParent;a.prototype.setParent=function(p,A,s){this._setParent(p,A,s);this.forceInvalidation();};a.prototype.setContent=function(c,d){var o=[];var $=this.$("content");var p=false;if(!d){o=this.removeAllAggregation("content",true);if($.length>0){sap.ui.core.RenderManager.preserveContent($[0]);p=true;$.empty();}}else{this.destroyAggregation("content",true);}if(c instanceof C){this.addAggregation("content",c,true);}else if(c&&typeof(c)=="object"&&c.length){for(var i=0;i<c.length;i++){this.addAggregation("content",c[i],true);}}this._rerenderContent(p);return o;};a.prototype.setPaneContent=function(c,d){var o=[];var $=this.$("paneContent");var p=false;if(!d){o=this.removeAllAggregation("paneContent",true);if($.length>0){sap.ui.core.RenderManager.preserveContent($[0]);p=true;$.empty();}}else{this.destroyAggregation("paneContent",true);}if(c instanceof C){this.addAggregation("paneContent",c,true);}else if(c&&typeof(c)=="object"&&c.length){for(var i=0;i<c.length;i++){this.addAggregation("paneContent",c[i],true);}}this._rerenderPane(p);return o;};a.prototype.getSelectedWorksetItem=function(){return this.getAssociation("selectedWorksetItem");};a.prototype.setSelectedWorksetItem=function(s){var o=this.getSelectedWorksetItem();this.setAssociation("selectedWorksetItem",s,true);var n=this.getSelectedWorksetItem();if(o!=n){var b=sap.ui.getCore().byId(n);if(b){this._sSelectedWorksetId=n;this._sSelectedFacetId=null;var c=b.getSubItems();if(c.length>0){b=c[0];}if(b&&(b.getParent()instanceof sap.ui.ux3.NavigationItem)){var d=b.getParent();this._sSelectedWorksetId=d.getId();this._sSelectedFacetId=b.getId();this._oWorksetBar.setSelectedItem(d);this._oFacetBar.setAssociatedItems(d.getSubItems());this._oFacetBar.setSelectedItem(b);if(this.getDomRef()){var f=this.$("facetBar");var F=this._calcFacetBarHeight(f);f.slideDown();this._adaptContentHeight(null,true,F);}}else if(b){this._oWorksetBar.setSelectedItem(b);this._oFacetBar.setAssociatedItems([]);this._oFacetBar.setSelectedItem(null);if(this.getDomRef()){var f=this.$("facetBar");var F=this._calcFacetBarHeight(f);f.slideUp();this._adaptContentHeight(null,true,F);}}}else{throw new Error("WorksetItem with ID "+n+" cannot be found.");}}return this;};a.prototype.setApplyContentPadding=function(A){this.setProperty("applyContentPadding",A,true);this.$().toggleClass("sapUiUx3ShellNoContentPadding",!A);this._adaptContentHeight();};a.prototype.setFullHeightContent=function(f){this.setProperty("fullHeightContent",f,true);this.$().toggleClass("sapUiUx3ShellFullHeightContent",f);this._adaptContentHeight();};a.prototype._calcFacetBarHeight=function(f){if(this._iFacetBarHeight===undefined){this._iFacetBarHeight=0;}if(!f){f=this.$("facetBar");}if(f.length>0){var h=this.$("facetBar").outerHeight(true);this._iFacetBarHeight=Math.max(this._iFacetBarHeight,h);}return this._iFacetBarHeight;};a.prototype._adaptContentHeight=function(n,A,f){if(!this.getDomRef()){return;}var $=this.$("content");var b=this.$("canvas");if(this.getFullHeightContent()){var p=this.getApplyContentPadding();var t=!p?0:parseInt(b.css("paddingTop"),10);var L=!p?0:parseInt(b.css("paddingLeft"),10);var r=!p?0:parseInt(b.css("paddingRight"),10);var _=f?f:this._calcFacetBarHeight();var T=(t+(this._oFacetBar.getAssociatedItems().length>0?_:0))+"px";if(A){$.stop().animate({top:T});}else{$.stop().css("top",T);}var N=this.getNotificationBar();if(N&&!n){n=N.getVisibleStatus();}if(n===sap.ui.ux3.NotificationBarStatus.Default||n===sap.ui.ux3.NotificationBarStatus.Max){$.css("bottom",N.getHeightOfStatus(sap.ui.ux3.NotificationBarStatus.Default));}else{var B=!p?0:parseInt(b.css("paddingBottom"),10);if(N&&n===sap.ui.ux3.NotificationBarStatus.Min){B+=sap.ui.ux3.NotificationBar.HOVER_ITEM_HEIGHT;}$.css("bottom",B+"px");}$.css(this._bRtl?"right":"left",L+"px");$.css(this._bRtl?"left":"right",r+"px");}else{$.removeAttr("style");}if(!!sap.ui.Device.browser.webkit){sap.ui.core.RenderManager.forceRepaint(this.getId()+"-canvas");}};a.prototype._handleDragover=function(e){var i=e.target.id;if(!this._dragOverBlinking){var $=q.sap.byId(i);$.css("opacity","0.5");this._dragOverBlinking=true;var t=this;window.setTimeout(function(){$.css("opacity","1");window.setTimeout(function(){t._dragOverBlinking=null;},300);},300);}return false;};a.prototype._handleDragend=function(e){return false;};a.prototype._handleDrop=function(b){var i=b.target.id;b.preventDefault();var e=b.originalEvent;var f=e.dataTransfer.files[0];if(f){var r=new window.FileReader();r.onload=q.proxy(function(c){var d=c.target.result;if(i==this.getId()+"-bgImg"){this._getPersonalization()._handleBackgroundImageChange(d,true);}else if(i==this.getId()+"-hdr"){this._getPersonalization()._handleHeaderImageChange(d,true);}else if(i==this.getId()+"-logoImg"){this._getPersonalization()._handleLogoImageChange(d,true);}r=null;},this);r.readAsDataURL(f);}};a.prototype._getPersonalization=function(){if(!this.oPersonalization){q.sap.require("sap.ui.ux3.ShellPersonalization");this.oPersonalization=new sap.ui.ux3.ShellPersonalization(this);}return this.oPersonalization;};a.prototype.openPersonalizationDialog=function(){this._getPersonalization().openDialog();};a.prototype.initializePersonalization=function(s){this._getPersonalization().initializeSettings(s);};a.prototype.onThemeChanged=function(e){this._iFacetBarHeight=undefined;if(!this.getDomRef()){return;}var i="";if(!this.getAppIcon()){i=P._getThemeImage('sapUiUx3ShellApplicationImageURL',true);this.$("logoImg").attr('src',i);}i=P._getThemeImage('sapUiUx3ShellHeaderImageURL',true);this.$("hdrImg").attr('src',i);i=P._getThemeImage('sapUiUx3ShellBackgroundImageURL',true);this.$("bgImg").attr('src',i);this.$("facetBar").stop(true,true);this._adaptContentHeight();this._updateThemeVariables();this._checkResize();};return a;},true);
