/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/base/Metadata","./ObjectPageSubSection","./library","sap/base/Log"],function(q,D,M,O,l,L){"use strict";var a=M.createClass("sap.uxap._helpers.LazyLoading",{constructor:function(o){this._oObjectPageLayout=o;this._$html=q("html");this._iPreviousScrollTop=0;this._iScrollProgress=0;this._iPreviousScrollTimestamp=0;this._sLazyLoadingTimer=null;this._oPrevSubSectionsInView={};this.setLazyLoadingParameters();}});a.prototype.setLazyLoadingParameters=function(){this.LAZY_LOADING_DELAY=200;this.LAZY_LOADING_EXTRA_PAGE_SIZE=0.5;if(this._isPhone()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":1,"ScrollToSection":1};}else if(this._isTablet()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":2,"ScrollToSection":1};}else if(this._isTabletSize()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":2,"ScrollToSection":2};}else{this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":3,"ScrollToSection":3};}this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD=5;};a.prototype._triggerVisibleSubSectionsEvents=function(){this._oPrevSubSectionsInView={};this._oObjectPageLayout._requestAdjustLayout(true);this.doLazyLoading();};a.prototype.lazyLoadDuringScroll=function(i,s,t,p){var P,d,f=false;if(i){if(this._sLazyLoadingTimer){clearTimeout(this._sLazyLoadingTimer);}this._sLazyLoadingTimer=null;this.doLazyLoading();return;}this._iScrollProgress=s-this._iPreviousScrollTop;P=Math.round(Math.abs(this._iScrollProgress)/p*100);if(P>=this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD){f=true;}this._iPreviousScrollTop=s;this._iPreviousScrollTimestamp=t||0;d=(s===0)?0:this.LAZY_LOADING_DELAY;if(f&&this._sLazyLoadingTimer){L.debug("ObjectPageLayout :: lazyLoading","delayed by "+d+" ms because of fast scroll");clearTimeout(this._sLazyLoadingTimer);this._sLazyLoadingTimer=null;}if(!this._sLazyLoadingTimer){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this),d);}};a.prototype.doLazyLoading=function(){var h=this._oObjectPageLayout._getHeightRelatedParameters(),s=this._oObjectPageLayout._oSectionInfo,S,i,p,b=this._iPreviousScrollTop>=(h.iHeaderContentHeight),e,E=-1,o={},c={},t,d,f;p=(h.iScreenHeight-(b?h.iAnchorBarHeight:0)-(b?h.iHeaderTitleHeightStickied:0));S=h.iScrollTop;t=Date.now()-this._iPreviousScrollTimestamp;d=(t<(this.LAZY_LOADING_DELAY/2))&&(Math.abs(this._iScrollProgress)>5);if(d){if(this._iScrollProgress>=0){f=Math.round(Math.min(this._iScrollProgress*20,p/2));}else{f=-1*Math.round(Math.min(Math.abs(this._iScrollProgress)*20,p/2));}S+=f;L.debug("ObjectPageLayout :: lazyLoading","Visible page shifted from : "+f);}i=S+p;S+=16;q.each(s,q.proxy(function(I,g){if(!g.isSection&&g.sectionReference.getParent()&&g.sectionReference.getParent().getVisible()){if(g.positionTop<=i&&S<g.positionBottom-1){c[I]=I;if(!g.loaded){o[I]=I;}}else if(!g.loaded&&g.positionTop>i&&g.positionTop<i+p*this.LAZY_LOADING_EXTRA_PAGE_SIZE&&(E==-1||g.positionTop<E)){E=g.positionTop;e=I;}}},this));if(E!=-1&&q.isEmptyObject(o)){L.debug("ObjectPageLayout :: lazyLoading","extra section added : "+e);o[e]=e;}q.each(o,q.proxy(function(g,j){L.debug("ObjectPageLayout :: lazyLoading","connecting "+j);sap.ui.getCore().byId(j).connectToModels();s[j].loaded=true;},this));q.each(c,q.proxy(function(g,j){if(!this._oPrevSubSectionsInView[g]){L.debug("ObjectPageLayout :: lazyLoading","subSectionEnteredViewPort "+j);this._oObjectPageLayout.fireEvent("subSectionEnteredViewPort",{subSection:sap.ui.getCore().byId(j)});}},this));this._oPrevSubSectionsInView=c;if(d){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this),this.LAZY_LOADING_DELAY);}else{if(E){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this),5*this.LAZY_LOADING_DELAY);}else{this._sLazyLoadingTimer=null;}}};a.prototype.getSubsectionsToPreload=function(A,i){var s,t;if(i){s=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.ScrollToSection;t=false;}else{s=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.FirstRendering;t=true;}var S=[];A.some(function(o){if(!t&&i){t=o.getId()==i;}if(t&&o instanceof O){if(o.getVisible()&&o._getInternalVisible()){S.push(o);s--;}}return s<=0;});return S;};a.prototype._isPhone=function(){return l.Utilities.isPhoneScenario(this._oObjectPageLayout._getCurrentMediaContainerRange());};a.prototype._isTablet=function(){return D.system.tablet;};a.prototype._isTabletSize=function(){return l.Utilities.isTabletScenario(this._oObjectPageLayout._getCurrentMediaContainerRange());};return a;},false);
