/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/layout/Grid","sap/ui/layout/GridData","./ObjectPageSectionBase","./ObjectPageLazyLoader","./BlockBase","sap/m/Button","sap/ui/Device","sap/ui/core/StashedControlSupport","sap/ui/base/ManagedObjectObserver","sap/m/TitlePropagationSupport","./library","sap/m/library","./ObjectPageSubSectionRenderer","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/dom/jquery/Focusable"],function(q,G,a,O,b,B,c,D,S,d,T,l,m,e,f,K){"use strict";var g=m.ButtonType;var h=l.ObjectPageSubSectionMode;var i=l.ObjectPageSubSectionLayout;var j=O.extend("sap.uxap.ObjectPageSubSection",{metadata:{library:"sap.uxap",properties:{mode:{type:"sap.uxap.ObjectPageSubSectionMode",group:"Appearance",defaultValue:h.Collapsed},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"blocks",aggregations:{_grid:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},blocks:{type:"sap.ui.core.Control",multiple:true,singularName:"block"},moreBlocks:{type:"sap.ui.core.Control",multiple:true,singularName:"moreBlock"},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"}},designtime:"sap/uxap/designtime/ObjectPageSubSection.designtime"}});T.call(j.prototype,"blocks",function(){return this._getTitleDomId();});j.MEDIA_RANGE=D.media.RANGESETS.SAP_STANDARD;j._getLibraryResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap");};j.prototype.init=function(){O.prototype.init.call(this);this._bRenderedFirstTime=false;this._aAggregationProxy={blocks:[],moreBlocks:[]};this._$spacer=[];this._sContainerSelector=".sapUxAPBlockContainer";this._oObserver=new d(j.prototype._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["actions"]});this._attachMediaContainerWidthChange(this._synchronizeBlockLayouts,this);this._switchSubSectionMode(this.getMode());this._initTitlePropagationSupport();this._sBorrowedTitleDomId=false;};j.prototype._getTitleDomId=function(){if(this._sBorrowedTitleDomId){return this._sBorrowedTitleDomId;}if(!this.getTitle().trim()){return false;}if(this._getInternalTitleVisible()){return this.getId()+"-headerTitle";}return false;};j.prototype._setBorrowedTitleDomId=function(I){this._sBorrowedTitleDomId=I;};j.prototype._expandSection=function(){O.prototype._expandSection.call(this);var p=this.getParent();p&&typeof p._expandSection==="function"&&p._expandSection();return this;};j.prototype._getGrid=function(){if(!this.getAggregation("_grid")){this.setAggregation("_grid",new G({id:this.getId()+"-innerGrid",defaultSpan:"XL12 L12 M12 S12",hSpacing:1,vSpacing:1,width:"100%",containerQuery:true}),true);}return this.getAggregation("_grid");};j.prototype._hasVisibleActions=function(){var A=this.getActions()||[];if(A.length===0){return false;}return A.filter(function(o){return o.getVisible();}).length>0;};j.prototype._observeChanges=function(C){var o=C.object,s=C.name,M=C.mutation,k=C.child,H;if(o===this){if(s==="actions"){if(M==="insert"){this._observeAction(k);}else if(M==="remove"){this._unobserveAction(k);}}}else if(s==="visible"){H=this._getInternalTitleVisible()&&this.getTitle().trim()!=="";if(!H){this.$("header").toggleClass("sapUiHidden",!this._hasVisibleActions());}}};j.prototype._observeAction=function(C){this._oObserver.observe(C,{properties:["visible"]});};j.prototype._unobserveAction=function(C){this._oObserver.unobserve(C,{properties:["visible"]});};j.prototype._unStashControls=function(){S.getStashedControls(this.getId()).forEach(function(C){C.setStashed(false);});};j.prototype.connectToModels=function(){var k=this.getBlocks()||[],M=this.getMoreBlocks()||[],C=this.getMode();this._unStashControls();k.forEach(function(o){if(o instanceof B){if(!o.getMode()){o.setMode(C);}o.connectToModels();}});if(M.length>0&&C===h.Expanded){M.forEach(function(o){if(o instanceof B){if(!o.getMode()){o.setMode(C);}o.connectToModels();}});}};j.prototype._allowPropagationToLoadedViews=function(A){var k=this.getBlocks()||[],M=this.getMoreBlocks()||[];k.forEach(function(o){if(o instanceof B){o._allowPropagationToLoadedViews(A);}});M.forEach(function(o){if(o instanceof B){o._allowPropagationToLoadedViews(A);}});};j.prototype.clone=function(){Object.keys(this._aAggregationProxy).forEach(function(A){var o=this.mAggregations[A];if(!o||o.length===0){this.mAggregations[A]=this._aAggregationProxy[A];}},this);return O.prototype.clone.apply(this,arguments);};j.prototype._cleanProxiedAggregations=function(){var p=this._aAggregationProxy;Object.keys(p).forEach(function(k){p[k].forEach(function(o){o.destroy();});});};j.prototype.exit=function(){if(this._oSeeMoreButton){this._oSeeMoreButton.destroy();this._oSeeMoreButton=null;}this._detachMediaContainerWidthChange(this._synchronizeBlockLayouts,this);this._cleanProxiedAggregations();if(O.prototype.exit){O.prototype.exit.call(this);}};j.prototype.onAfterRendering=function(){var o=this._getObjectPageLayout();if(O.prototype.onAfterRendering){O.prototype.onAfterRendering.call(this);}if(!o){return;}this._$spacer=q(document.getElementById(o.getId()+"-spacer"));};j.prototype.onBeforeRendering=function(){var o=this._getObjectPageLayout();if(!o){return;}if(O.prototype.onBeforeRendering){O.prototype.onBeforeRendering.call(this);}this._setAggregationProxy();this._getGrid().removeAllContent();this._applyLayout(o);this.refreshSeeMoreVisibility();};j.prototype._applyLayout=function(L){var v,o=this._getGrid(),C=this.getMode(),s=L.getSubSectionLayout(),k=this._calculateLayoutConfiguration(s,L),n=this.getBlocks(),A=n.concat(this.getMoreBlocks());this._oLayoutConfig=k;this._resetLayoutData(A);if(C===h.Expanded){v=A;}else{v=n;}this._calcBlockColumnLayout(v,this._oLayoutConfig);try{v.forEach(function(p){this._setBlockMode(p,C);o.addAggregation("content",p,true);},this);}catch(E){f.error("ObjectPageSubSection :: error while building layout "+s+": "+E);}return this;};j.prototype._calculateLayoutConfiguration=function(L,o){var k={M:2,L:3,XL:4},n=k.L,E=k.XL,t=(L===i.TitleOnLeft),u=o.getUseTwoColumnsForLargeScreen();if(t){n-=1;E-=1;}if(u){n-=1;}k.L=n;k.XL=E;return k;};j.prototype.refreshSeeMoreVisibility=function(){var k=!!this.getMoreBlocks().length,s=this._getSeeMoreButton(),$=s.$(),n=this.$();if(!k){k=this.getBlocks().some(function(o){if(o instanceof B&&o.getVisible()&&o.getShowSubSectionMore()){return true;}});}if(n.length){n.toggleClass("sapUxAPObjectPageSubSectionWithSeeMore",k);}this.toggleStyleClass("sapUxAPObjectPageSubSectionWithSeeMore",k);if($.length){$.toggleClass("sapUxAPSubSectionSeeMoreButtonVisible",k);}s.toggleStyleClass("sapUxAPSubSectionSeeMoreButtonVisible",k);return k;};j.prototype.setMode=function(M){if(this.getMode()!==M){this._switchSubSectionMode(M);if(this._bRenderedFirstTime){this.rerender();}}return this;};j.prototype.onkeydown=function(E){if(E.keyCode===K.F7){E.stopPropagation();var t=sap.ui.getCore().byId(E.target.id);if(t instanceof j){this._handleSubSectionF7();}else{this._handleInteractiveElF7();this._oLastFocusedControlF7=t;}}};j.prototype._handleInteractiveElF7=function(){if(this.getParent().getSubSections().length>1){this.$().focus();}else{this.getParent().$().focus();}};j.prototype._handleSubSectionF7=function(E){if(this._oLastFocusedControlF7){this._oLastFocusedControlF7.$().focus();}else{this.$().firstFocusableDomRef().focus();}};j.prototype._calcBlockColumnLayout=function(k,C){var n=12,v,M,L,X,o;M={iRemaining:C.M,iColumnConfig:C.M};L={iRemaining:C.L,iColumnConfig:C.L};X={iRemaining:C.XL,iColumnConfig:C.XL};o=[X,L,M];v=k.filter(function(p){return p.getVisible&&p.getVisible();});v.forEach(function(p,I){o.forEach(function(r){r.iCalculatedSize=this._calculateBlockSize(p,r.iRemaining,v,I,r.iColumnConfig);},this);p.setLayoutData(new a(p.getId()+"-layoutData",{spanS:n,spanM:M.iCalculatedSize*(n/M.iColumnConfig),spanL:L.iCalculatedSize*(n/L.iColumnConfig),spanXL:X.iCalculatedSize*(n/X.iColumnConfig),linebreakM:(I>0&&M.iRemaining===M.iColumnConfig),linebreakL:(I>0&&L.iRemaining===L.iColumnConfig),linebreakXL:(I>0&&X.iRemaining===X.iColumnConfig)}));o.forEach(function(r){r.iRemaining-=r.iCalculatedSize;if(r.iRemaining<1){r.iRemaining=r.iColumnConfig;}});},this);return v;};j.prototype._calculateBlockSize=function(o,r,v,C,M){var k,F=M,n;if(!this._hasAutoLayout(o)){return Math.min(M,parseInt(o.getColumnLayout(),10));}for(n=1;n<=F;n++){k=this._calcLayout(v[C+n]);if(k<r){r-=k;}else{break;}}return r;};j.prototype._calcLayout=function(o){var L=1;if(!o){L=0;}else if(o instanceof B&&o.getColumnLayout()!="auto"){L=parseInt(o.getColumnLayout(),10);}return L;};j.prototype._hasAutoLayout=function(o){return!(o instanceof B)||o.getColumnLayout()=="auto";};j.prototype._onDesktopMediaRange=function(C){return this._onMediaRange(C,["LargeDesktop","Desktop"]);};j.prototype._onTabletMediaRange=function(C){return this._onMediaRange(C,["Tablet"]);};j.prototype._onPhoneMediaRange=function(C){return this._onMediaRange(C,["Phone"]);};j.prototype._onMediaRange=function(C,k){var M=C||this._getCurrentMediaContainerRange();return k.indexOf(M.name)>-1;};j.prototype._synchronizeBlockLayouts=function(C){if(this._getUseTitleOnTheLeft()){this.$("header").toggleClass("titleOnLeftLayout",this._onDesktopMediaRange(C));}this._toggleBlockLayoutResponsiveStyles(C);};j.prototype._toggleBlockLayoutResponsiveStyles=function(C){this.$().find(".sapUxAPBlockContainer").toggleClass("sapUxAPBlockContainerDesktop",this._onDesktopMediaRange(C));this.$().find(".sapUxAPBlockContainer").toggleClass("sapUxAPBlockContainerTablet",this._onTabletMediaRange(C));this.$().find(".sapUxAPBlockContainer").toggleClass("sapUxAPBlockContainerPhone",this._onPhoneMediaRange(C));};j.prototype._getMediaString=function(C){if(this._onPhoneMediaRange(C)){return"Phone";}if(this._onTabletMediaRange(C)){return"Tablet";}return"Desktop";};j.prototype._setAggregationProxy=function(){if(this._bRenderedFirstTime){return;}q.each(this._aAggregationProxy,q.proxy(function(A,v){this._setAggregation(A,this.removeAllAggregation(A,true),true);},this));this._bRenderedFirstTime=true;};j.prototype.hasProxy=function(A){return this._bRenderedFirstTime&&this._aAggregationProxy.hasOwnProperty(A);};j.prototype._getAggregation=function(A){return this._aAggregationProxy[A];};j.prototype._setAggregation=function(A,v,s){this._aAggregationProxy[A]=v;if(s!==true){this._notifyObjectPageLayout();this.invalidate();}return this._aAggregationProxy[A];};j.prototype.addAggregation=function(A,o,s){var k;if(o instanceof b){o.getContent().forEach(function(C){this.addAggregation(A,C,true);},this);o.removeAllContent();o.destroy();this.invalidate();return this;}if(this.hasProxy(A)){k=this._getAggregation(A);k.push(o);this._setAggregation(A,k,s);if(o instanceof B||o instanceof b){o.setParent(this);}return this;}return O.prototype.addAggregation.apply(this,arguments);};j.prototype.insertBlock=function(o,I){f.warning("ObjectPageSubSection :: usage of insertBlock is not supported - addBlock is performed instead.");return this.addAggregation("blocks",o);};j.prototype.insertMoreBlock=function(o,I){f.warning("ObjectPageSubSection :: usage of insertMoreBlock is not supported - addMoreBlock is performed instead.");return this.addAggregation("moreBlocks",o);};j.prototype.removeAllAggregation=function(A,s){var I;if(this.hasProxy(A)){I=this._getAggregation(A);this._setAggregation(A,[],s);return I.slice();}return O.prototype.removeAllAggregation.apply(this,arguments);};j.prototype.removeAggregation=function(A,o){var r=false,I;if(this.hasProxy(A)){I=this._getAggregation(A);I.forEach(function(k,n){if(k.getId()===o.getId()){I.splice(n,1);this._setAggregation(A,I);r=true;}return!r;},this);return(r?o:null);}return O.prototype.removeAggregation.apply(this,arguments);};j.prototype.indexOfAggregation=function(A,o){var I=-1;if(this.hasProxy(A)){this._getAggregation(A).some(function(k,n){if(k.getId()===o.getId()){I=n;return true;}},this);return I;}return O.prototype.indexOfAggregation.apply(this,arguments);};j.prototype.getAggregation=function(A){if(this.hasProxy(A)){return this._getAggregation(A);}return O.prototype.getAggregation.apply(this,arguments);};j.prototype.destroyAggregation=function(A){if(this.hasProxy(A)){this._getAggregation(A).forEach(function(o){o.destroy();});this._setAggregation(A,[]);return this;}return O.prototype.destroyAggregation.apply(this,arguments);};j.prototype._getSeeMoreButton=function(){if(!this._oSeeMoreButton){this._oSeeMoreButton=new c(this.getId()+"--seeMore",{type:g.Transparent,iconFirst:false,ariaLabelledBy:this.getId()}).addStyleClass("sapUxAPSubSectionSeeMoreButton").attachPress(this._seeMoreLessControlPressHandler,this);}return this._oSeeMoreButton;};j.prototype._seeMoreLessControlPressHandler=function(E){var C=this.getMode(),t,M=this.getMoreBlocks()||[];if(C===h.Expanded){t=h.Collapsed;}else{t=h.Expanded;M.forEach(function(o){if(o instanceof B){o.setMode(C);o.connectToModels();}},this);}this._switchSubSectionMode(t);if(this._$spacer.length>0){this._$spacer.height(this._$spacer.height()+this.$().height());}this.rerender();};j.prototype._switchSubSectionMode=function(s){s=this.validateProperty("mode",s);if(s===h.Collapsed){this.setProperty("mode",h.Collapsed,true);this._getSeeMoreButton().setText(j._getLibraryResourceBundle().getText("SEE_MORE"));}else{this.setProperty("mode",h.Expanded,true);this._getSeeMoreButton().setText(j._getLibraryResourceBundle().getText("SEE_LESS"));}};j.prototype._setBlockMode=function(o,M){if(o instanceof B){o.setMode(M);}else{f.debug("ObjectPageSubSection :: cannot propagate mode "+M+" to "+o.getMetadata().getName());}};j.prototype._setToFocusable=function(F){var s='0',n='-1',t="tabIndex";if(F){this.$().attr(t,s);}else{this.$().attr(t,n);}return this;};j.prototype._getUseTitleOnTheLeft=function(){var o=this._getObjectPageLayout();return o&&(o.getSubSectionLayout()===i.TitleOnLeft);};j.prototype._resetLayoutData=function(k){k.forEach(function(o){if(o.getLayoutData()){o.destroyLayoutData();}},this);};j.prototype.getVisibleBlocksCount=function(){var v=S.getStashedControls(this.getId()).length;(this.getBlocks()||[]).forEach(function(o){if(o.getVisible&&!o.getVisible()){return true;}v++;});(this.getMoreBlocks()||[]).forEach(function(M){if(M.getVisible&&!M.getVisible()){return true;}v++;});return v;};return j;});
