/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/uxap/AnchorBar',["sap/ui/thirdparty/jquery","sap/m/Button","sap/m/MenuButton","sap/m/library","sap/m/Toolbar","sap/ui/core/IconPool","sap/ui/core/Item","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ScrollEnablement","sap/ui/layout/HorizontalLayout","sap/ui/Device","sap/ui/core/CustomData","./HierarchicalSelect","./library","sap/uxap/AnchorBarRenderer","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/events/F6Navigation"],function(q,B,M,m,T,I,a,R,S,H,D,C,b,l,A,L,K,F){"use strict";var c=m.SelectType;
var d=T.extend("sap.uxap.AnchorBar",{metadata:{library:"sap.uxap",properties:{showPopover:{type:"boolean",defaultValue:true},upperCase:{type:"boolean",defaultValue:false},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance"}},associations:{selectedButton:{type:"sap.m.Button",multiple:false}},aggregations:{_select:{type:"sap.uxap.HierarchicalSelect",multiple:false,visibility:"hidden"},_scrollArrowLeft:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_scrollArrowRight:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});
d.prototype.init=function(){if(T.prototype.init){T.prototype.init.call(this);}this.addStyleClass("sapUxAPAnchorBar");this._oPressHandlers={};this._oSectionInfo={};this._oScroller=null;this._sSelectedKey=null;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._bRtlScenario=this._bRtl&&!D.browser.msie;this._bHasButtonsBar=D.system.tablet||D.system.desktop;this.oLibraryResourceBundleOP=sap.ui.getCore().getLibraryResourceBundle("sap.uxap");this._oSelect=this._getHierarchicalSelect();if(this._bHasButtonsBar){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:true,vertical:false,nonTouchScrolling:true});this._iREMSize=0;this._iTolerance=0;this._iOffset=0;this._sResizeListenerId=undefined;}this.setDesign("Transparent");};
d.SCROLL_STEP=250;d.SCROLL_DURATION=500;d.DOM_CALC_DELAY=200;
d.prototype.setSelectedButton=function(o){var p=this.getSelectedButton(),P,s=this._oSelect.getItems(),h=s.length>0;if(typeof o==="string"){o=sap.ui.getCore().byId(o);}if(o){if(o.getId()===p){return this;}var e=o.data("sectionId");this._sSelectedKey=e;if(e&&h){this._oSelect.setSelectedKey(e);}if(this._bHasButtonsBar){P=sap.ui.getCore().byId(p);this._toggleSelectionStyleClass(P,false);this._toggleSelectionStyleClass(o,true);if(e){this.scrollToSection(e,d.SCROLL_DURATION);}this._setAnchorButtonsTabFocusValues(o);}}return this.setAssociation("selectedButton",o,true);};
d.prototype.setShowPopover=function(v,s){if(this.getShowPopover()===v){return this;}return this.setProperty("showPopover",v,true);};
d.prototype.setBackgroundDesign=function(s){var e=this.getBackgroundDesign(),$=this.$(),f="sapUxAPAnchorBar";if(e===s){return this;}this.setProperty("backgroundDesign",s,true);if($.length){$.removeClass(f+e);$.addClass(f+s);}return this;};
d.prototype.getSelectedSection=function(){var s=this.getSelectedButton();if(s&&(typeof(s)==="string")){s=sap.ui.getCore().byId(s);}if(s&&(s instanceof B)&&s.data("sectionId")){return sap.ui.getCore().byId(s.data("sectionId"));}return null;};
d.prototype.onBeforeRendering=function(){var s=this.getBackgroundDesign();if(this._bHasButtonsBar){this._iREMSize=parseInt(q("body").css("font-size"),10);this._iTolerance=this._iREMSize*1;this._iOffset=this._iREMSize*3;}if(T.prototype.onBeforeRendering){T.prototype.onBeforeRendering.call(this);}var e=this.getContent()||[],u=this.getUpperCase();this._oSelect.removeAllItems();this._oSelect.setUpperCase(u);this.toggleStyleClass("sapUxAPAnchorBarUpperCase",u);if(s){this.addStyleClass("sapUxAPAnchorBar"+s);}e.forEach(function(o){this._createSelectItem(o);},this);if(e.length>0&&this._sSelectedKey){this._oSelect.setSelectedKey(this._sSelectedKey);}};
d.prototype.addContent=function(o,i){o.addStyleClass("sapUxAPAnchorBarButton");o.removeAllAriaDescribedBy();if(this._bHasButtonsBar&&(o.data("secondLevel")===true||o.data("secondLevel")==="true")){o.attachPress(this._handleDirectScroll,this);}return this.addAggregation("content",o,i);};
d.prototype._createSelectItem=function(o){var i=o.data("secondLevel")===true||o.data("secondLevel")==="true";if(o.getText().trim()!=""&&(!i||o.data("bTitleVisible")===true)){var p=new a({key:o.data("sectionId"),text:o.getText(),customData:[new C({key:"secondLevel",value:o.data("secondLevel")})]});this._oSelect.addItem(p);}if(i){this.removeContent(o);o.destroy();}};
d.prototype._decorateSubMenuButtons=function(e){var f=e.getSource().getContent();f.forEach(function(o){o.$().attr("aria-controls",o.data("sectionId"));});};
d.prototype._toggleSelectionStyleClass=function(o,e){if(o){o.toggleStyleClass("sapUxAPAnchorBarButtonSelected",e);o.$().attr("aria-checked",e);if(o instanceof M){o._getButtonControl().$().attr("aria-checked",e);}}};
d.prototype._handleDirectScroll=function(e){this._requestScrollToSection(e.getSource().data("sectionId"));};
d.prototype._requestScrollToSection=function(r){var o=sap.ui.getCore().byId(r),e=o.getParent();if(this.getParent()instanceof l.ObjectPageLayout){var n=r;if(o instanceof l.ObjectPageSubSection&&e instanceof l.ObjectPageSection){n=e.getId();}this.getParent().setDirectScrollingToSection(n);this.getParent().scrollToSection(o.getId(),null,0,true);}if(o instanceof l.ObjectPageSubSection&&e instanceof l.ObjectPageSection){e.setAssociation("selectedSubSection",o,true);}};
d.prototype._onSelectChange=function(e){var s=e.getParameter("selectedItem"),o;o=sap.ui.getCore().byId(s.getKey());if(o){this._requestScrollToSection(o.getId());}else{L.error("AnchorBar :: cannot find corresponding section",s.getKey());}};
d.prototype._getHierarchicalSelect=function(){if(!this.getAggregation('_select')){this.setAggregation('_select',new b({width:"100%",icon:"sap-icon://slim-arrow-down",tooltip:this.oLibraryResourceBundleOP.getText("ANCHOR_BAR_OVERFLOW"),change:q.proxy(this._onSelectChange,this)}));}return this.getAggregation('_select');};
d.prototype._createScrollArrow=function(e){var s,i,f,g,o,t=this,h=this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SCROLL_LEFT_ARROW"),j=this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SCROLL_RIGHT_ARROW");if(e){s=this.getId()+"-arrowScrollLeft";i="slim-arrow-left";f="anchorBarArrowLeft";g=this._bRtl?j:h;}else{s=this.getId()+"-arrowScrollRight";i="slim-arrow-right";f="anchorBarArrowRight";g=this._bRtl?h:j;}o=new B(s,{icon:I.getIconURI(i),type:"Transparent",press:function(E){E.preventDefault();t._handleScrollButtonTap(e);},tooltip:g});o.addEventDelegate({onAfterRendering:function(){if(sap.ui.getCore().getConfiguration().getTheme()!="sap_hcb"){this.$().attr("tabindex",-1);}},onThemeChanged:function(){if(sap.ui.getCore().getConfiguration().getTheme()=="sap_hcb"){this.$().removeAttr("tabindex");}else{this.$().attr("tabindex",-1);}}},o);return new H({content:[o]}).addStyleClass("anchorBarArrow").addStyleClass(f);};
d.prototype._getScrollArrowLeft=function(){var s=this.getAggregation("_scrollArrowLeft");if(s){return s;}else{s=this._createScrollArrow(true);this.setAggregation("_scrollArrowLeft",s);return s;}};
d.prototype._getScrollArrowRight=function(){var s=this.getAggregation("_scrollArrowRight");if(s){return s;}else{s=this._createScrollArrow(false);this.setAggregation("_scrollArrowRight",s);return s;}};
d.prototype._applyHierarchicalSelectMode=function(){if(this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon){this.$().find(".sapUxAPAnchorBarScrollContainer").show();this._oSelect.setWidth("auto");this._oSelect.setAutoAdjustWidth(true);this._oSelect.setType(c.IconOnly);this._computeBarSectionsInfo();}else{this.$().find(".sapUxAPAnchorBarScrollContainer").hide();this._oSelect.setWidth("100%");this._oSelect.setAutoAdjustWidth(false);this._oSelect.setType(c.Default);}this.$().toggleClass("sapUxAPAnchorBarOverflow",this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon);};
d.prototype._adjustSize=function(){var n=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())?A._AnchorBarHierarchicalSelectMode.Text:A._AnchorBarHierarchicalSelectMode.Icon;if(n!==this._sHierarchicalSelectMode){this._sHierarchicalSelectMode=n;this._applyHierarchicalSelectMode();}if(this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon){if(this._iMaxPosition<0){return;}var $=this.$(),e=$.find(".sapUxAPAnchorBarScrollContainer"),N,f,i;i=e.width();if(this._bRtlScenario){if(D.browser.firefox){f=Math.abs(e.scrollLeft())+i<(this._iMaxPosition-this._iTolerance);N=Math.abs(e.scrollLeft())>=this._iTolerance;}else{f=Math.abs(e.scrollLeft())>=this._iTolerance;N=Math.abs(e.scrollLeft())+i<(this._iMaxPosition-this._iTolerance);}}else{f=e.scrollLeft()+i<(this._iMaxPosition-this._iTolerance);N=e.scrollLeft()>=this._iTolerance;}L.debug("AnchorBar :: scrolled at "+e.scrollLeft(),"scrollBegin ["+(N?"true":"false")+"] scrollEnd ["+(f?"true":"false")+"]");$.toggleClass("sapUxAPAnchorBarScrollLeft",N);$.toggleClass("sapUxAPAnchorBarScrollRight",f);}};
d.prototype._handleScrollButtonTap=function(s){var i=((!this._bRtlScenario&&s)||(this._bRtlScenario&&!s))?-1:1;this._oScroller.scrollTo(this._iMaxPosition*i,0,d.SCROLL_DURATION*3);};
d.prototype.scrollToSection=function(i,e){if(this._bHasButtonsBar){var e=e||d.SCROLL_DURATION,s;if(!l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())&&this._oSectionInfo[i]){if(this._bRtlScenario&&D.browser.firefox){s=this._oSectionInfo[i].scrollLeft+this._iOffset;}else{s=this._oSectionInfo[i].scrollLeft-this._iOffset;if(s<0){s=0;}}L.debug("AnchorBar :: scrolling to section "+i+" of "+s);if(this._sCurrentScrollId!=i){this._sCurrentScrollId=i;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);q(document.getElementById(this.getId()+"-scroll")).parent().stop(true,false);}this._iCurrentScrollTimeout=setTimeout(function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;}.bind(this),e);this._oScroller.scrollTo(s,0,e);}}else{L.debug("AnchorBar :: no need to scroll to "+i);}}};
d.prototype.getScrollDelegate=function(){return this._oScroller;};
d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;
d.prototype.onsapright=function(e){e.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(e.target.id.indexOf(o.getId())>-1){n=i+1;return;}});if(n&&f[n]){f[n].focus();}else if(f[f.length-1]){f[f.length-1].focus();}};
d.prototype.onsapleft=function(e){e.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(e.target.id.indexOf(o.getId())>-1){n=i-1;return;}});if(n&&f[n]){f[n].focus();}else if(f[0]){f[0].focus();}};
d.prototype.onsaphome=function(e){e.preventDefault();var f=this.getContent();f[0].focus();};
d.prototype.onsapend=function(e){e.preventDefault();var f=this.getContent();f[f.length-1].focus();};
d.prototype.onsappageup=function(e){this._handlePageUp(e);};
d.prototype.onsappagedown=function(e){this._handlePageDown(e);};
d.prototype._handlePageUp=function(e){e.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(e.target.id.indexOf(o.getId())>-1){n=i-(d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return;}});if(n&&f[n]){f[n].focus();}else if(f[0]){f[0].focus();}};
d.prototype._handlePageDown=function(e){e.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(e.target.id.indexOf(o.getId())>-1){n=i+d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return;}});if(n&&f[n]){f[n].focus();}else if(f[f.length-1]){f[f.length-1].focus();}};
d.prototype._setAnchorButtonsTabFocusValues=function(s){var e=this.getContent()||[],$,f='0',n='-1',t="tabIndex";e.forEach(function(o){$=o.getAggregation("_button")?o.getAggregation("_button").$():o.$();if(o.sId===s.sId){$.attr(t,f);}else{$.attr(t,n);}});};
d.prototype.onsapskipforward=function(e){this._handleGroupNavigation(e,false);};
d.prototype._handleGroupNavigation=function(e,s){var E=q.Event("keydown"),o={},O=this.getParent(),u=O.getUseIconTabBar(),f=O.getSelectedSection(),g=O._getVisibleSections(),h=[this.getDomRef()],i=[];if(u){i=sap.ui.getCore().byId(f).getSubSections().map(function(j){return j.$().attr("tabindex",-1)[0];});h=h.concat(i);}else{g.forEach(function(j){i=j.getSubSections().map(function(k){return k.$().attr("tabindex",-1)[0];});h=h.concat(i);});}o.scope=h;e.preventDefault();this.$().focus();E.target=e.target;E.keyCode=K.F6;E.key="F6";E.shiftKey=s;F.handleF6GroupNavigation(E,o);};
d.prototype.onAfterRendering=function(){var s;if(T.prototype.onAfterRendering){T.prototype.onAfterRendering.call(this);}s=sap.ui.getCore().byId(this.getSelectedButton());this._iMaxPosition=-1;this._sResizeListenerId=R.register(this,q.proxy(this._adjustSize,this));this.$().find(".sapUxAPAnchorBarScrollContainer").scroll(q.proxy(this._onScroll,this));if(s){this.setSelectedButton(s);this._setAnchorButtonsTabFocusValues(s);}if(this._bHasButtonsBar){setTimeout(function(){if(this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon){this._computeBarSectionsInfo();}this._adjustSize();}.bind(this),d.DOM_CALC_DELAY);}};
d.prototype._onScroll=function(){if(!this._iCurrentSizeCheckTimeout){this._iCurrentSizeCheckTimeout=setTimeout(function(){this._iCurrentSizeCheckTimeout=undefined;this._adjustSize();}.bind(this),d.SCROLL_DURATION);}};
d.prototype._computeBarSectionsInfo=function(){this._iMaxPosition=0;var e=this.getContent()||[];e.forEach(this._computeNextSectionInfo,this);if(this._bRtlScenario&&(D.browser.webkit||D.browser.firefox)){e.forEach(this._adjustNextSectionInfo,this);this._oScroller.scrollTo(this._iMaxPosition,0,0);}};
d.prototype._computeNextSectionInfo=function(o){if(o.data("bHasSubMenu")){o.$().attr("aria-haspopup","true");}o.$().attr("aria-controls",o.data("sectionId")).attr("aria-checked",false);if(o instanceof M){o._getButtonControl().$().attr("aria-controls",o.data("sectionId")).attr("aria-checked",false);}var w=o.$().outerWidth(true);this._oSectionInfo[o.data("sectionId")]={scrollLeft:this._iMaxPosition,width:w};this._iMaxPosition+=w;};
d.prototype._adjustNextSectionInfo=function(o){var s=this._oSectionInfo[o.data("sectionId")];if(D.browser.firefox){s.scrollLeft=-s.scrollLeft;}else{s.scrollLeft=this._iMaxPosition-s.scrollLeft-s.width;}};
d.prototype._resetControl=function(){this.destroyAggregation('content',true);return this;};
d.prototype.enhanceAccessibilityState=function(e,f){var o=this.getContent(),i=o.indexOf(e);if(i!==-1){f.role="menuitemradio";f.type="button";f.setsize=o.length;f.posinset=i+1;}};
d.prototype.exit=function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=null;}};
return d;});
sap.ui.predefine('sap/uxap/AnchorBarRenderer',["sap/m/ToolbarRenderer","sap/ui/core/Renderer","sap/m/BarInPageEnabler","./library"],function(T,R,B,l){"use strict";var A=R.extend(T);var _=A._AnchorBarHierarchicalSelectMode={Icon:"icon",Text:"text"};
A.renderBarContent=function(r,t){if(t._bHasButtonsBar){r.renderControl(t._getScrollArrowLeft());r.write("<div");r.writeAttributeEscaped("id",t.getId()+"-scrollContainer");r.writeAttributeEscaped("aria-label",sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText("ANCHOR_BAR_LABEL"));r.addClass("sapUxAPAnchorBarScrollContainer");r.writeClasses();r.write(">");r.write("<div");r.writeAttributeEscaped("id",t.getId()+"-scroll");r.writeAttributeEscaped("role","menu");r.write(">");A.renderBarItems(r,t);r.write("</div>");r.write("</div>");r.renderControl(t._getScrollArrowRight());}B.addChildClassTo(t._oSelect,t);r.renderControl(t._oSelect);};
A.renderBarItems=function(r,t){var s=t.getSelectedButton();t.getContent().forEach(function(c){B.addChildClassTo(c,t);if(c.getId()===s){c.addStyleClass("sapUxAPAnchorBarButtonSelected");}r.renderControl(c);});};
A.decorateRootElement=function(r,t){T.decorateRootElement.apply(this,arguments);if(t._sHierarchicalSelectMode===_.Icon){r.addClass("sapUxAPAnchorBarOverflow");}};
return A;},true);
sap.ui.predefine('sap/uxap/BlockBase',["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/CustomData","./BlockBaseMetadata","sap/ui/model/Context","sap/ui/Device","sap/ui/layout/form/ResponsiveGridLayout","./library","sap/ui/core/Component","sap/ui/layout/library","sap/base/Log"],function(q,C,a,B,b,D,R,l,c,d,L){"use strict";var S=d.form.SimpleFormLayout;var e=l.BlockBaseFormAdjustment;
var f=C.extend("sap.uxap.BlockBase",{
metadata:{designtime:"sap/uxap/designtime/BlockBase.designtime",library:"sap.uxap",properties:{"mode":{type:"string",group:"Appearance"},"visible":{type:"boolean",group:"Appearance",defaultValue:true},"columnLayout":{type:"sap.uxap.BlockBaseColumnLayout",group:"Behavior",defaultValue:"auto"},"formAdjustment":{type:"sap.uxap.BlockBaseFormAdjustment",group:"Behavior",defaultValue:e.BlockColumns},"showSubSectionMore":{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"mappings",aggregations:{"mappings":{type:"sap.uxap.ModelMapping",multiple:true,singularName:"mapping"},"_views":{type:"sap.ui.core.Control",multiple:true,singularName:"view",visibility:"hidden"}},associations:{"selectedView":{type:"sap.ui.core.Control",multiple:false}},views:{}},
renderer:"sap.uxap.BlockBaseRenderer"
},B);
f.prototype.init=function(){if(!this.getMetadata().hasViews()){this.getMetadata().setView("defaultXML",{viewName:this.getMetadata().getName(),type:"XML"});}this._oMappingApplied={};this._bLazyLoading=false;this._bConnected=false;this._oUpdatedModels={};this._oParentObjectPageSubSection=null;};
f.prototype.onBeforeRendering=function(){var p;this._applyMapping();if(!this.getMode()||this.getMode()===""){if(this.getMetadata().getView("defaultXML")){this.setMode("defaultXML");}else{L.error("BlockBase ::: there is no mode defined for rendering "+this.getMetadata().getName()+". You can either set a default mode on the block metadata or set the mode property before rendering the block.");}}this._applyFormAdjustment();p=this._getObjectPageLayout();this._bLazyLoading=p&&(p.getEnableLazyLoading()||p.getUseIconTabBar());};
f.prototype.onAfterRendering=function(){var p=this._getObjectPageLayout();if(p){p._requestAdjustLayout();}};
f.prototype.setParent=function(p,A,s){C.prototype.setParent.call(this,p,A,s);if(p instanceof l.ObjectPageSubSection){this._bLazyLoading=true;this._oParentObjectPageSubSection=p;}};
f.prototype.setModel=function(m,n){this._applyMapping(n);return C.prototype.setModel.call(this,m,n);};
f.prototype._applyMapping=function(){if(this._shouldLazyLoad()){L.debug("BlockBase ::: Ignoring the _applyMapping as the block is not connected");}else{this.getMappings().forEach(function(m,i){var M,o,I=m.getInternalModelName(),E=m.getExternalPath(),s=m.getExternalModelName(),p;if(E){if(I==""||E==""){throw new Error("BlockBase :: incorrect mapping, one of the modelMapping property is empty");}M=this.getModel(s);if(!M){return;}p=M.resolve(E,this.getBindingContext(s));o=this.getBindingContext(I);if(!this._isMappingApplied(I)||(this.getModel(I)!==this.getModel(s))||(o&&(o.getPath()!==p))){L.info("BlockBase :: mapping external model "+s+" to "+I);this._oMappingApplied[I]=true;C.prototype.setModel.call(this,M,I);this.setBindingContext(new b(M,p),I);}}},this);}};
f.prototype._isMappingApplied=function(i){return this.getModel(i)&&this._oMappingApplied[i];};
f.prototype.propagateProperties=function(n){if(this._shouldLazyLoad()&&!this._oUpdatedModels.hasOwnProperty(n)){this._oUpdatedModels[n]=true;}else{this._applyMapping(n);}return C.prototype.propagateProperties.call(this,n);};
f.prototype.getSupportedModes=function(){var s=q.extend({},this.getMetadata().getViews());for(var k in s){s[k]=k;}return s;};
f.prototype.setMode=function(m){m=this._validateMode(m);if(this.getMode()!==m){this.setProperty("mode",m,false);if(!this._shouldLazyLoad()){this._initView(m);}}return this;};
f.prototype.setColumnLayout=function(s){if(this._oParentObjectPageSubSection){this._oParentObjectPageSubSection.invalidate();}this.setProperty("columnLayout",s);};
f.prototype.clone=function(){var A=-1,s=this.getAssociation("selectedView"),v=this.getAggregation("_views")||[];if(s){v.forEach(function(V,i){if(V.getId()===s){A=i;}return A<0;});}var n=C.prototype.clone.call(this);if(A>=0){n.setAssociation("selectedView",n.getAggregation("_views")[A]);}return n;};
f.prototype._validateMode=function(m){this.validateProperty("mode",m);if(!this.getMetadata().getView(m)){var s=this.getMetadata()._sClassName||this.getId();if(this.getMetadata().getView("defaultXML")){L.warning("BlockBase :: no view defined for block "+s+" for mode "+m+", loading defaultXML instead");m="defaultXML";}else{throw new Error("BlockBase :: no view defined for block "+s+" for mode "+m);}}return m;};
f.prototype._getSelectedViewContent=function(){var v=null,s,V;s=this.getAssociation("selectedView");V=this.getAggregation("_views");if(V){for(var i=0;!v&&i<V.length;i++){if(V[i].getId()===s){v=V[i];}}}return v;};
f.prototype.createView=function(p,m){var o,g;g=function(){return sap.ui.view(this.getId()+"-"+m,p);}.bind(this);o=c.getOwnerComponentFor(this);if(o){return o.runAsOwner(g);}else{return g();}};
f.prototype._initView=function(m){var v,V=this.getAggregation("_views")||[],p=this.getMetadata().getView(m);V.forEach(function(o,i){if(o.data("layoutMode")===m){v=o;}});if(!v){v=this._initNewView(m);}this.setAssociation("selectedView",v,true);if(v.getController()&&v.getController().onParentBlockModeChange){v.getController().onParentBlockModeChange(m);}else{L.info("BlockBase ::: could not notify "+p.viewName+" of loading in mode "+m+": missing controller onParentBlockModeChange method");}return v;};
f.prototype._initNewView=function(m){var v=this._getSelectedViewContent(),p=this.getMetadata().getView(m);if(!v||p.viewName!=v.getViewName()){v=this.createView(p,m);if(v){if(v.getController()){v.getController().oParentBlock=this;}v.addCustomData(new a({"key":"layoutMode","value":m}));this.addAggregation("_views",v,true);}else{throw new Error("BlockBase :: no view defined in metadata.views for mode "+m);}}return v;};
f.FORM_ADUSTMENT_OFFSET=32;f._FORM_ADJUSTMENT_CONST={breakpoints:{XL:D.media._predefinedRangeSets.StdExt.points[2]-f.FORM_ADUSTMENT_OFFSET,L:D.media._predefinedRangeSets.StdExt.points[1]-f.FORM_ADUSTMENT_OFFSET,M:D.media._predefinedRangeSets.StdExt.points[0]-f.FORM_ADUSTMENT_OFFSET},labelSpan:{XL:12,L:12,M:12,S:12},emptySpan:{XL:0,L:0,M:0,S:0},columns:{XL:1,L:1,M:1}};f._PARENT_GRID_SIZE=12;
f.prototype._computeFormAdjustmentFields=function(v,o,F,p){if(v&&o&&F&&p){var g=this._computeFormColumns(o,F,p),h=this._computeFormBreakpoints(o,F);return q.extend({},f._FORM_ADJUSTMENT_CONST,{columns:g},{breakpoints:h});}};
f.prototype._computeFormColumns=function(o,F,p){var g=q.extend({},f._FORM_ADJUSTMENT_CONST.columns);if(F===e.BlockColumns){var i=f._PARENT_GRID_SIZE/p.XL,h=f._PARENT_GRID_SIZE/p.L,j=f._PARENT_GRID_SIZE/p.M;g.XL=o.getSpanXL()/i;g.L=o.getSpanL()/h;g.M=o.getSpanM()/j;}return g;};
f.prototype._computeFormBreakpoints=function(o,F){var g=q.extend({},f._FORM_ADJUSTMENT_CONST.breakpoints);if(F===e.BlockColumns){g.XL=Math.round(g.XL*o.getSpanXL()/f._PARENT_GRID_SIZE);g.L=Math.round(g.L*o.getSpanL()/f._PARENT_GRID_SIZE);g.M=Math.round(g.M*o.getSpanM()/f._PARENT_GRID_SIZE);}return g;};
f.prototype._applyFormAdjustment=function(){var o=this.getLayoutData(),F=this.getFormAdjustment(),v=this._getSelectedViewContent(),p=this._oParentObjectPageSubSection,g;if(F&&(F!==e.None)&&v&&o&&p){var P=p._oLayoutConfig;v.getContent().forEach(function(i){if(i.getMetadata().getName()==="sap.ui.layout.form.SimpleForm"){i.setLayout(S.ResponsiveGridLayout);if(!g){g=this._computeFormAdjustmentFields(v,o,F,P);}this._applyFormAdjustmentFields(g,i);i.setWidth("100%");}else if(i.getMetadata().getName()==="sap.ui.layout.form.Form"){var h=i.getLayout(),r;if(h&&h.getMetadata().getName()==="sap.ui.layout.form.ResponsiveGridLayout"){r=h;}else{r=new R();i.setLayout(r);}if(!g){g=this._computeFormAdjustmentFields(v,o,F,P);}this._applyFormAdjustmentFields(g,r);i.setWidth("100%");}},this);}};
f.prototype._applyFormAdjustmentFields=function(F,o){o.setColumnsXL(F.columns.XL);o.setColumnsL(F.columns.L);o.setColumnsM(F.columns.M);o.setLabelSpanXL(F.labelSpan.XL);o.setLabelSpanL(F.labelSpan.L);o.setLabelSpanM(F.labelSpan.M);o.setLabelSpanS(F.labelSpan.S);o.setEmptySpanXL(F.emptySpan.XL);o.setEmptySpanL(F.emptySpan.L);o.setEmptySpanM(F.emptySpan.M);o.setEmptySpanS(F.emptySpan.S);o.setBreakpointXL(F.breakpoints.XL);o.setBreakpointL(F.breakpoints.L);o.setBreakpointM(F.breakpoints.M);};
f.prototype._getObjectPageLayout=function(){return l.Utilities.getClosestOPL(this);};
f.prototype.setVisible=function(v,s){var p=this._getObjectPageLayout();this.setProperty("visible",v,s);p&&p._requestAdjustLayoutAndUxRules();return this;};
f.prototype.setShowSubSectionMore=function(v,i){if(v!=this.getShowSubSectionMore()){this.setProperty("showSubSectionMore",v,true);if(this._oParentObjectPageSubSection){this._oParentObjectPageSubSection.refreshSeeMoreVisibility();}}return this;};
f.prototype.connectToModels=function(){if(!this._bConnected){L.debug("BlockBase :: Connecting block to the UI5 model tree");this._bConnected=true;if(this._bLazyLoading){var m=this.getMode();m&&this._initView(m);}this.invalidate();}};
f.prototype._allowPropagationToLoadedViews=function(A){if(!this._bConnected){return;}this.mSkipPropagation._views=!A;};
f.prototype.updateBindingContext=function(s,g,m,u){if(!this._shouldLazyLoad()){return C.prototype.updateBindingContext.call(this,s,g,m,u);}else{L.debug("BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout");}};
f.prototype.updateBindings=function(u,m){if(!this._shouldLazyLoad()){return C.prototype.updateBindings.call(this,u,m);}else{L.debug("BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout");}};
f.prototype._shouldLazyLoad=function(){return!!this._oParentObjectPageSubSection&&this._bLazyLoading&&!this._bConnected;};
return f;});
sap.ui.predefine('sap/uxap/BlockBaseMetadata',["sap/ui/thirdparty/jquery","sap/ui/core/ElementMetadata","sap/base/Log"],function(q,E,L){"use strict";var B=function(c,C){E.apply(this,arguments);this._mViews=C.metadata.views||{};};B.prototype=Object.create(E.prototype);
B.prototype.applySettings=function(c){var r=c.hasOwnProperty("renderer")?(c.renderer||""):undefined;E.prototype.applySettings.call(this,c);if(r==null){this._sRendererName=null;}};
B.prototype.getRendererName=function(){if(!this._sBlockRenderer){this._sBlockRenderer=this._resolveRendererName();L.debug("BlockBaseMetadata :: "+this.getName()+" is renderer with "+this._sBlockRenderer);}return this._sBlockRenderer;};
B.prototype._resolveRendererName=function(){var c=E.prototype.getRendererName.call(this);if(c==null){var p=this.getParent();if(p){c=B.prototype._resolveRendererName.apply(p);}else{throw new Error("BlockBaseMetadata :: no renderer found for "+this.getName());}}return c;};
B.prototype.getView=function(v){return this._mViews[v];};
B.prototype.getViews=function(){return this._mViews;};
B.prototype.setView=function(v,V){this._mViews[v]=V;return this;};
B.prototype.hasViews=function(){return!q.isEmptyObject(this._mViews);};
return B;},true);
sap.ui.predefine('sap/uxap/BlockBaseRenderer',function(){"use strict";var B={};
B.render=function(r,c){if(!c.getVisible()){return;}r.write("<div");r.writeControlData(c);if(c._getSelectedViewContent()){r.addClass('sapUxAPBlockBase');r.addClass("sapUxAPBlockBase"+c.getMode());}else{var C=c.getMetadata().getName().split(".").pop();r.addClass('sapUxAPBlockBaseDefaultSize');r.addClass('sapUxAPBlockBaseDefaultSize'+C+c.getMode());}r.writeClasses();r.write(">");if(c._getSelectedViewContent()){r.renderControl(c._getSelectedViewContent());}r.write("</div>");};
return B;},true);
sap.ui.predefine('sap/uxap/BreadCrumbs',["sap/m/Link","sap/m/Select","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ItemNavigation","sap/ui/core/Item","sap/ui/core/Icon","sap/ui/Device","./library","sap/ui/core/InvisibleText","./BreadCrumbsRenderer","sap/ui/thirdparty/jquery"],function(L,S,C,R,I,a,b,D,l,c,B,q){"use strict";
var d=C.extend("sap.uxap.BreadCrumbs",{metadata:{library:"sap.uxap",properties:{showCurrentLocation:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"links",aggregations:{links:{type:"sap.m.Link",multiple:true,singularName:"link"},currentLocation:{type:"sap.m.Text",multiple:false},_tubeIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowSelect:{type:"sap.m.Select",multiple:false,visibility:"hidden"}}}});
d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;
d.prototype.init=function(){this._iREMSize=parseInt(q("body").css("font-size"),10);this._iContainerMaxHeight=this._iREMSize*2;};
d.prototype.onBeforeRendering=function(){this._bOnPhone=D.system.phone;this._resetControl();};
d.prototype.onAfterRendering=function(){this._handleInitialModeSelection();};
d.prototype._handleInitialModeSelection=function(){if(this._bOnPhone){this._setSelectVisible(true);return this;}this._configureKeyboardHandling();if(!this._iContainerHeight){this._iContainerHeight=this.$().outerHeight();}if(this._iContainerHeight>this._iContainerMaxHeight){this._toggleOverflowMode(true);return this;}this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));return this;};
d.prototype._toggleOverflowMode=function(u){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);}this._setSelectVisible(u);this._setBreadcrumbsVisible(!u);this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));return this;};
d.prototype._getTubeIcon=function(){if(!this.getAggregation("_tubeIcon")){this.setAggregation("_tubeIcon",new b({"src":"sap-icon://slim-arrow-right","color":"#bfbfbf","size":"1rem","useIconTooltip":false}).addStyleClass("sapUxAPTubeIcon"));}return this.getAggregation("_tubeIcon");};
d.prototype._getOverflowSelect=function(){var o,s;if(!this.getAggregation("_overflowSelect")){s=this.getLinks().reverse()||[];s.unshift(this.getCurrentLocation());o=new S({items:s.map(this._createSelectItem),autoAdjustWidth:true});o.attachChange(this._overflowSelectChangeHandler);this.setAggregation("_overflowSelect",o);}return this.getAggregation("_overflowSelect");};
d.prototype._createSelectItem=function(i){return new a({key:i.getId(),text:i.getText()});};
d.prototype._overflowSelectChangeHandler=function(e){var s=e.getParameter("selectedItem").getKey(),o=sap.ui.getCore().byId(s),f,g;if(o instanceof L){f=o.getHref();o.firePress();if(f){g=o.getTarget();if(g){window.open(f,g);}else{window.location.href=f;}}}return this;};
d.prototype._handleScreenResize=function(e){var s=this._shouldOverflow(),u=this._getUsingOverflowSelect();if(s&&!u){this._toggleOverflowMode(true);}else if(!s&&u){this._toggleOverflowMode(false);}return this;};
d.prototype._shouldOverflow=function(){var $=this._getBreadcrumbsAsJQueryObject(),s,u=this._getUsingOverflowSelect();if(u){this._setBreadcrumbsVisible(true);}$.addClass("sapUxAPInvisible");s=$.outerHeight()>this._iContainerMaxHeight;$.removeClass("sapUxAPInvisible");if(u){this._setBreadcrumbsVisible(false);}return s;};
d.prototype._getBreadcrumbsAsJQueryObject=function(){if(!this._$breadcrumbs){this._$breadcurmbs=this.$("breadcrumbs");}return this._$breadcurmbs;};
d.prototype._getOverflowSelectAsJQueryObject=function(){if(!this._$select){this._$select=this.$("select");}return this._$select;};
d.prototype._setBreadcrumbsVisible=function(v){var $=this.$(),e=this._getBreadcrumbsAsJQueryObject(),f="sapUxAPFullWidth",s="sapUiHidden";if(v){e.removeClass(s);$.removeClass(f);}else{e.addClass(s);$.addClass(f);}return $;};
d.prototype._setSelectVisible=function(v){var $=this._getOverflowSelectAsJQueryObject(),s="sapUiHidden";if(v){$.removeClass(s);}else{$.addClass(s);}return this;};
d.prototype._resetControl=function(){this._iContainerHeight=null;this._$select=null;this._$breadcrumbs=null;this.setAggregation("_overflowSelect",null,true);if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);}return this;};
d.prototype._getAriaLabelledBy=function(){if(!this._oAriaLabelledBy){d.prototype._oAriaLabelledBy=new c({text:sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText("BREADCRUMB_TRAIL_LABEL")}).toStatic();}return this._oAriaLabelledBy;};
d.prototype._getItemNavigation=function(){if(!this._ItemNavigation){this._ItemNavigation=new I();}return this._ItemNavigation;};
d.prototype._getItemsToNavigate=function(){var i=this.getLinks(),o=this.getCurrentLocation(),s=this.getShowCurrentLocation();if(s&&o){i.push(o);}return i;};
d.prototype._configureKeyboardHandling=function(){var i=this._getItemNavigation(),h=this._getBreadcrumbsAsJQueryObject()[0],s=-1,e=this._getItemsToNavigate(),n=[];e.forEach(function(o){o.$().attr("tabIndex","-1");n.push(o.getDomRef());});this.addDelegate(i);i.setCycling(false);i.setRootDomRef(h);i.setItemDomRefs(n);i.setSelectedIndex(s);this._getBreadcrumbsAsJQueryObject().attr("tabindex","-1");e[0].$().attr("tabindex","0");return this;};
d.prototype.onsappageup=function(e){this._handlePageKeys(e,false);};
d.prototype.onsappagedown=function(e){this._handlePageKeys(e,true);};
d.prototype._handlePageKeys=function(e,m){var n,f=this._getItemsToNavigate(),E=0,i=m?f.length-1:0;e.preventDefault();f.some(function(o,g){if(o.getId()===e.target.id){E=g;return true;}});if(m){n=E+d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE;}else{n=E-d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE;}if(n&&f[n]){f[n].focus();}else if(f[i]){f[i].focus();}};
d.prototype._getUsingOverflowSelect=function(){return!this._getOverflowSelectAsJQueryObject().hasClass("sapUiHidden");};
d.prototype.exit=function(){if(this._ItemNavigation){this.removeDelegate(this._ItemNavigation);this._ItemNavigation.destroy();this._ItemNavigation=null;}this._resetControl();};
return d;});
sap.ui.predefine('sap/uxap/BreadCrumbsRenderer',function(){"use strict";var B={};
B.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUxAPBreadCrumbs");r.writeClasses();r.writeAttribute("role","navigation");r.writeAttributeEscaped("aria-labelledby",c._getAriaLabelledBy().getId());r.write(">");this._renderOverflowSelect(r,c);if(!c._bOnPhone){this._renderBreadcrumbTrail(r,c);}r.write("</div>");};
B._renderBreadcrumbTrail=function(r,c){var l=c.getLinks(),C=c.getCurrentLocation(),t=c._getTubeIcon(),s=c.getShowCurrentLocation();r.write("<ul id='"+c.getId()+"-breadcrumbs'");r.write(">");l.forEach(function(L){r.write("<li>");r.renderControl(L);r.renderControl(t);r.write("</li>");});if(s){r.write("<li>");r.renderControl(C);r.write("</li>");}r.write("</ul>");};
B._renderOverflowSelect=function(r,c){var t=c._getTubeIcon();r.write("<div id='"+c.getId()+"-select'");r.addClass("sapUiHidden");r.writeClasses();r.write(">");r.write('<span class="sapUxAPBreadCrumbsDots">...</span>');r.renderControl(t);r.renderControl(c._getOverflowSelect());r.write("</div>");};
return B;},true);
sap.ui.predefine('sap/uxap/HierarchicalSelect',["sap/m/Select","sap/ui/Device","sap/ui/thirdparty/jquery","./library","./HierarchicalSelectRenderer","sap/ui/thirdparty/jqueryui/jquery-ui-position"],function(S,D,q,l,H){"use strict";
var a=S.extend("sap.uxap.HierarchicalSelect",{metadata:{library:"sap.uxap",properties:{upperCase:{type:"boolean",group:"Appearance",defaultValue:false}}}});
a.POPOVER_MIN_WIDTH_REM=11;
a.prototype.onAfterRendering=function(){S.prototype.onAfterRendering.apply(this,arguments);};
a.prototype.onAfterRenderingPicker=function(){S.prototype.onAfterRenderingPicker.call(this);var i=this.getItems()||[];i.forEach(function(I){var c=(I.data("secondLevel")===true)?"sapUxAPHierarchicalSelectSecondLevel":"sapUxAPHierarchicalSelectFirstLevel";I.$().addClass(c);},this);};
a.prototype.setUpperCase=function(v,s){this.setProperty("upperCase",v,s);this.toggleStyleClass("sapUxAPHierarchicalSelectUpperCase",v);var p=this.getAggregation("picker");if(p){p.toggleStyleClass("sapMSltPickerFirstLevelUpperCase",v);if(!s){p.invalidate();}}return this;};
a.prototype.onsapenter=S.prototype.onsapspace;["onsapup","onsappageup","onsappagedown","onsaphome","onsapend"].forEach(function(n){a.prototype[n]=function(e){S.prototype[n].call(this,e);e.stopPropagation();};});
a.prototype._createDialog=function(){var d=S.prototype._createDialog.call(this),c=d.getCustomHeader();if(c){c.addStyleClass("sapUxAPHierarchicalSelect");}return d;};
a.prototype._decoratePopover=function(p){S.prototype._decoratePopover.call(this,p);p._adaptPositionParams=function(){this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"];this._myPositions=["end bottom","end center","end top","begin center"];this._atPositions=["end top","end center","end bottom","begin center"];};if(D.system.tablet||D.system.desktop){var r=q.position.scrollbarWidth();if(r>0){p.setOffsetX(r);}}};
a.prototype._onAfterRenderingPopover=function(){var p=this.getPicker(),P=p.getDomRef("cont"),m=P.style.minWidth;if(m.endsWith("rem")){m=m.substring(0,m.length-3);var M=parseFloat(m);if(M<a.POPOVER_MIN_WIDTH_REM&&P){P.style.minWidth=a.POPOVER_MIN_WIDTH_REM+"rem";}}};
return a;});
sap.ui.predefine('sap/uxap/HierarchicalSelectRenderer',["sap/m/SelectRenderer","sap/ui/core/Renderer"],function(S,R){"use strict";var H=R.extend(S);
H.addClass=function(r){r.addClass("sapUxAPHierarchicalSelect");};
return H;},true);
sap.ui.predefine('sap/uxap/LazyLoading',["sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/base/Metadata","./ObjectPageSubSection","./library","sap/base/Log"],function(q,D,M,O,l,L){"use strict";var a=M.createClass("sap.uxap._helpers.LazyLoading",{constructor:function(o){this._oObjectPageLayout=o;this._$html=q("html");this._iPreviousScrollTop=0;this._iScrollProgress=0;this._iPreviousScrollTimestamp=0;this._sLazyLoadingTimer=null;this._oPrevSubSectionsInView={};this.setLazyLoadingParameters();}});
a.prototype.setLazyLoadingParameters=function(){this.LAZY_LOADING_DELAY=200;this.LAZY_LOADING_EXTRA_PAGE_SIZE=0.5;if(this._isPhone()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":1,"ScrollToSection":1};}else if(this._isTablet()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":2,"ScrollToSection":1};}else if(this._isTabletSize()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":2,"ScrollToSection":2};}else{this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":3,"ScrollToSection":3};}this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD=5;};
a.prototype._triggerVisibleSubSectionsEvents=function(){this._oPrevSubSectionsInView={};this._oObjectPageLayout._requestAdjustLayout(true);this.doLazyLoading();};
a.prototype.lazyLoadDuringScroll=function(i,s,t,p){var P,d,f=false;if(i){if(this._sLazyLoadingTimer){clearTimeout(this._sLazyLoadingTimer);}this._sLazyLoadingTimer=null;this.doLazyLoading();return;}this._iScrollProgress=s-this._iPreviousScrollTop;P=Math.round(Math.abs(this._iScrollProgress)/p*100);if(P>=this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD){f=true;}this._iPreviousScrollTop=s;this._iPreviousScrollTimestamp=t||0;d=(s===0)?0:this.LAZY_LOADING_DELAY;if(f&&this._sLazyLoadingTimer){L.debug("ObjectPageLayout :: lazyLoading","delayed by "+d+" ms because of fast scroll");clearTimeout(this._sLazyLoadingTimer);this._sLazyLoadingTimer=null;}if(!this._sLazyLoadingTimer){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this),d);}};
a.prototype.doLazyLoading=function(){var h=this._oObjectPageLayout._getHeightRelatedParameters(),s=this._oObjectPageLayout._oSectionInfo,S,i,p,b=this._iPreviousScrollTop>=(h.iHeaderContentHeight),e,E=-1,o={},c={},t,d,f;p=(h.iScreenHeight-(b?h.iAnchorBarHeight:0)-(b?h.iHeaderTitleHeightStickied:0));S=h.iScrollTop;t=Date.now()-this._iPreviousScrollTimestamp;d=(t<(this.LAZY_LOADING_DELAY/2))&&(Math.abs(this._iScrollProgress)>5);if(d){if(this._iScrollProgress>=0){f=Math.round(Math.min(this._iScrollProgress*20,p/2));}else{f=-1*Math.round(Math.min(Math.abs(this._iScrollProgress)*20,p/2));}S+=f;L.debug("ObjectPageLayout :: lazyLoading","Visible page shifted from : "+f);}i=S+p;S+=16;q.each(s,q.proxy(function(I,g){if(!g.isSection&&g.sectionReference.getParent()&&g.sectionReference.getParent().getVisible()){if(g.positionTop<=i&&S<g.positionBottom-1){c[I]=I;if(!g.loaded){o[I]=I;}}else if(!g.loaded&&g.positionTop>i&&g.positionTop<i+p*this.LAZY_LOADING_EXTRA_PAGE_SIZE&&(E==-1||g.positionTop<E)){E=g.positionTop;e=I;}}},this));if(E!=-1&&q.isEmptyObject(o)){L.debug("ObjectPageLayout :: lazyLoading","extra section added : "+e);o[e]=e;}q.each(o,q.proxy(function(g,j){L.debug("ObjectPageLayout :: lazyLoading","connecting "+j);sap.ui.getCore().byId(j).connectToModels();s[j].loaded=true;},this));q.each(c,q.proxy(function(g,j){if(!this._oPrevSubSectionsInView[g]){L.debug("ObjectPageLayout :: lazyLoading","subSectionEnteredViewPort "+j);this._oObjectPageLayout.fireEvent("subSectionEnteredViewPort",{subSection:sap.ui.getCore().byId(j)});}},this));this._oPrevSubSectionsInView=c;if(d){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this),this.LAZY_LOADING_DELAY);}else{if(E){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this),5*this.LAZY_LOADING_DELAY);}else{this._sLazyLoadingTimer=null;}}};
a.prototype.getSubsectionsToPreload=function(A,i){var s,t;if(i){s=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.ScrollToSection;t=false;}else{s=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.FirstRendering;t=true;}var S=[];A.some(function(o){if(!t&&i){t=o.getId()==i;}if(t&&o instanceof O){if(o.getVisible()&&o._getInternalVisible()){S.push(o);s--;}}return s<=0;});return S;};
a.prototype._isPhone=function(){return l.Utilities.isPhoneScenario(this._oObjectPageLayout._getCurrentMediaContainerRange());};
a.prototype._isTablet=function(){return D.system.tablet;};
a.prototype._isTabletSize=function(){return l.Utilities.isTabletScenario(this._oObjectPageLayout._getCurrentMediaContainerRange());};
return a;},false);
sap.ui.predefine('sap/uxap/ModelMapping',["sap/ui/core/Element","./library"],function(E,l){"use strict";
var M=E.extend("sap.uxap.ModelMapping",{metadata:{library:"sap.uxap",properties:{externalModelName:{type:"string",group:"Misc",defaultValue:null},internalModelName:{type:"string",group:"Misc",defaultValue:"Model"},externalPath:{type:"string",group:"Misc",defaultValue:null}}}});
return M;});
sap.ui.predefine('sap/uxap/ObjectImageHelper',["sap/ui/core/Icon","sap/ui/core/IconPool","sap/m/Image"],function(I,a,b){"use strict";var O=function(){};
O.createObjectImage=function(h){var o,s=h.getObjectImageURI();if(s.indexOf("sap-icon://")===0){o=new I();o.addStyleClass("sapUxAPObjectPageHeaderObjectImageIcon");}else{o=new b({densityAware:h.getObjectImageDensityAware(),alt:h.getObjectImageAlt(),decorative:false});o.addStyleClass("sapUxAPObjectPageHeaderObjectImage");}o.setSrc(s);if(h.getObjectImageAlt()){o.setTooltip(h.getObjectImageAlt());}return o;};
O.createPlaceholder=function(){return a.createControlByURI({src:a.getIconURI("picture"),visible:true});};
O._renderImageAndPlaceholder=function(r,o){var h=o.oHeader,c=o.oObjectImage,p=o.oPlaceholder,i=o.bIsObjectIconAlwaysVisible,A=o.bAddSubContainer,B=o.sBaseClass,s=!(h.getObjectImageShape()||h.getShowPlaceholder()),d=(c instanceof I);if(h.getObjectImageURI()||h.getShowPlaceholder()){r.write("<span ");r.addClass(B);r.addClass('sapUxAPObjectPageHeaderObjectImage-'+h.getObjectImageShape());if(i){r.addClass('sapUxAPObjectPageHeaderObjectImageForce');}r.writeClasses();r.write(">");if(A){r.write("<span class='sapUxAPObjectPageHeaderObjectImageContainerSub'>");}if(d){r.write("<div");r.addClass("sapUxAPObjectPageHeaderObjectImage");r.addClass("sapUxAPObjectPageHeaderPlaceholder");r.writeClasses();r.write(">");}r.renderControl(c);O._renderPlaceholder(r,p,s);if(d){r.write("</div>");}if(A){r.write("</span>");}r.write("</span>");}};
O._renderPlaceholder=function(r,p,v){r.write("<div");r.addClass('sapUxAPObjectPageHeaderPlaceholder');r.addClass('sapUxAPObjectPageHeaderObjectImage');if(!v){r.addClass('sapUxAPHidePlaceholder');}r.writeClasses();r.write(">");r.renderControl(p);r.write("</div>");};
return O;},false);
sap.ui.predefine('sap/uxap/ObjectPageDynamicHeaderContent',['./library',"./ObjectPageDynamicHeaderContentRenderer","sap/base/Log"],function(l,O,L){"use strict";try{sap.ui.getCore().loadLibrary("sap.f");}catch(e){L.error("The control 'sap.uxap.ObjectPageDynamicHeaderContent' needs library 'sap.f'.");throw(e);}var D=sap.ui.requireSync("sap/f/DynamicPageHeader");
var a=D.extend("sap.uxap.ObjectPageDynamicHeaderContent",{metadata:{interfaces:["sap.uxap.IHeaderContent"],library:"sap.uxap"}});
a.createInstance=function(c,v,C,p){return new a({content:c,visible:v,pinnable:p});};
a.prototype.supportsPinUnpin=function(){return true;};
a.prototype.supportsChildPageDesign=function(){return false;};
a.prototype.supportsAlwaysExpanded=function(){return false;};
a.prototype.setContentDesign=function(d){};
return a;});
sap.ui.predefine('sap/uxap/ObjectPageDynamicHeaderContentRenderer',['sap/ui/core/Renderer','sap/f/DynamicPageHeaderRenderer'],function(R,D){"use strict";var O=R.extend(D);return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageDynamicHeaderTitle',['./library','sap/uxap/ObjectPageDynamicHeaderContent',"./ObjectPageDynamicHeaderTitleRenderer","sap/base/Log"],function(l,O,a,L){"use strict";try{sap.ui.getCore().loadLibrary("sap.f");}catch(e){L.error("The control 'sap.uxap.ObjectPageDynamicHeaderTitle' needs library 'sap.f'.");throw(e);}var D=sap.ui.requireSync("sap/f/DynamicPageTitle");
var b=D.extend("sap.uxap.ObjectPageDynamicHeaderTitle",{metadata:{interfaces:["sap.uxap.IHeaderTitle"],library:"sap.uxap"}});
b.prototype.isDynamic=function(){return true;};
b.prototype.getCompatibleHeaderContentClass=function(){return O;};
b.prototype.supportsToggleHeaderOnTitleClick=function(){return true;};
b.prototype.supportsTitleInHeaderContent=function(){return false;};
b.prototype.supportsAdaptLayoutForDomElement=function(){return false;};
b.prototype.supportsBackgroundDesign=function(){return true;};
b.KNOWN_HEADING_CONTROL_CLASS_NAMES=["sap.m.Title","sap.m.Text","sap.m.FormattedText","sap.m.Label"];
b.prototype.getTitleText=function(){var h=this.getHeading(),c=h&&h.getMetadata().getName();if(b.KNOWN_HEADING_CONTROL_CLASS_NAMES.indexOf(c)>-1){return h.getText();}};
b.prototype.getHeaderDesign=function(){return l.ObjectPageHeaderDesign.Light;};
b.prototype.snap=function(u){this._toggleState(false,u);};
b.prototype.unSnap=function(u){this._toggleState(true,u);};
b.prototype._adaptLayoutForDomElement=function($,E){};
return b;});
sap.ui.predefine('sap/uxap/ObjectPageDynamicHeaderTitleRenderer',['sap/ui/core/Renderer','sap/f/DynamicPageTitleRenderer'],function(R,D){"use strict";var O=R.extend(D);return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageHeader',["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/CustomData","sap/ui/Device","sap/m/Breadcrumbs","./ObjectPageHeaderActionButton","sap/ui/core/ResizeHandler","sap/m/Button","sap/m/ActionSheet","./ObjectImageHelper","./ObjectPageHeaderContent","./library","sap/m/library","./ObjectPageHeaderRenderer"],function(q,C,I,a,D,B,O,R,b,A,c,d,l,m,e){"use strict";var f=l.Importance;var g=m.ButtonType;var P=m.PlacementType;var h=l.ObjectPageHeaderDesign;var j=l.ObjectPageHeaderPictureShape;
function k(i){return typeof i==="function";}
var n=C.extend("sap.uxap.ObjectPageHeader",{metadata:{library:"sap.uxap",interfaces:["sap.uxap.IHeaderTitle"],properties:{objectImageURI:{type:"string",defaultValue:null},objectImageAlt:{type:"string",defaultValue:''},objectImageDensityAware:{type:"boolean",defaultValue:false},objectTitle:{type:"string",defaultValue:null},objectSubtitle:{type:"string",defaultValue:null},objectImageShape:{type:"sap.uxap.ObjectPageHeaderPictureShape",defaultValue:j.Square},isObjectIconAlwaysVisible:{type:"boolean",defaultValue:false},isObjectTitleAlwaysVisible:{type:"boolean",defaultValue:true},isObjectSubtitleAlwaysVisible:{type:"boolean",defaultValue:true},isActionAreaAlwaysVisible:{type:"boolean",defaultValue:true},headerDesign:{type:"sap.uxap.ObjectPageHeaderDesign",defaultValue:h.Light},showTitleSelector:{type:"boolean",group:"Misc",defaultValue:false},markFavorite:{type:"boolean",group:"Misc",defaultValue:false},markFlagged:{type:"boolean",group:"Misc",defaultValue:false},showMarkers:{type:"boolean",group:"Misc",defaultValue:false},markLocked:{type:"boolean",group:"Misc",defaultValue:false},showPlaceholder:{type:"boolean",group:"Misc",defaultValue:false},markChanges:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"actions",aggregations:{_breadCrumbs:{type:"sap.m.Breadcrumbs",multiple:false,visibility:"hidden"},breadcrumbs:{type:"sap.m.Breadcrumbs",multiple:false,singularName:"breadcrumb"},breadCrumbsLinks:{type:"sap.m.Link",multiple:true,singularName:"breadCrumbLink"},_overflowButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_objectImage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_placeholder:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_lockIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_lockIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_favIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_flagIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowActionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"},_changesIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_changesIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_sideContentBtn:{type:"sap.m.Button",multiple:false,visibility:"hidden"},navigationBar:{type:"sap.m.Bar",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},sideContentButton:{type:"sap.m.Button",multiple:false},titleSelectorTooltip:{type:"sap.ui.core.TooltipBase",altTypes:["string"],multiple:false}},events:{titleSelectorPress:{parameters:{domRef:{type:"string"}}},markLockedPress:{parameters:{domRef:{type:"string"}}},markChangesPress:{parameters:{domRef:{type:"string"}}}},designtime:"sap/uxap/designtime/ObjectPageHeader.designtime"}});
n.prototype._iAvailablePercentageForActions=0.3;
n.prototype.init=function(){this._bFirstRendering=true;if(!this.oLibraryResourceBundle){this.oLibraryResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");}if(!this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=sap.ui.getCore().getLibraryResourceBundle("sap.uxap");}this._oOverflowActionSheet=this._lazyLoadInternalAggregation("_overflowActionSheet",true);this._oOverflowButton=this._lazyLoadInternalAggregation("_overflowButton",true).attachPress(this._handleOverflowButtonPress,this);this._oExpandButton=this._lazyLoadInternalAggregation("_expandButton",true);this._oActionSheetButtonMap={};this._oFlagIcon=this._lazyLoadInternalAggregation("_flagIcon",true);this._oFavIcon=this._lazyLoadInternalAggregation("_favIcon",true);this._oTitleArrowIcon=this._lazyLoadInternalAggregation("_titleArrowIcon",true).attachPress(this._handleArrowPress,this);this._oTitleArrowIconCont=this._lazyLoadInternalAggregation("_titleArrowIconCont",true).attachPress(this._handleArrowPress,this);this._oLockIcon=this._lazyLoadInternalAggregation("_lockIcon",true).attachPress(this._handleLockPress,this);this._oLockIconCont=this._lazyLoadInternalAggregation("_lockIconCont",true).attachPress(this._handleLockPress,this);this._oChangesIcon=this._lazyLoadInternalAggregation("_changesIcon",true).attachPress(this._handleChangesPress,this);this._oChangesIconCont=this._lazyLoadInternalAggregation("_changesIconCont",true).attachPress(this._handleChangesPress,this);};
n.getMetadata().forwardAggregation("breadCrumbsLinks",{getter:function(){return this._lazyLoadInternalAggregation("_breadCrumbs");},aggregation:"links"});
n.prototype._handleOverflowButtonPress=function(E){this._oOverflowActionSheet.openBy(this._oOverflowButton);};
n.prototype._handleArrowPress=function(E){this.fireTitleSelectorPress({domRef:E.getSource().getDomRef()});};
n.prototype._handleLockPress=function(E){this.fireMarkLockedPress({domRef:E.getSource().getDomRef()});};
n.prototype._handleChangesPress=function(E){this.fireMarkChangesPress({domRef:E.getSource().getDomRef()});};
n._internalAggregationFactory={"_objectImage":c.createObjectImage,"_placeholder":c.createPlaceholder,"_overflowActionSheet":function(){return new A({placement:P.Bottom});},"_lockIconCont":function(i){return this._getButton(i,"sap-icon://private","lock-cont",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"));},"_breadCrumbs":function(i){return new B({links:i.getAggregation("breadCrumbLinks")});},"_lockIcon":function(i){return this._getButton(i,"sap-icon://private","lock",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"));},"_titleArrowIconCont":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","titleArrow-cont",i.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_titleArrowIcon":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","titleArrow",i.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_favIcon":function(i){return this._getIcon(i,"favorite",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FAVORITE_MARK_VALUE"));},"_flagIcon":function(i){return this._getIcon(i,"flag",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FLAG_MARK_VALUE"));},"_overflowButton":function(i){return this._getButton(i,"sap-icon://overflow","overflow",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_OVERFLOW_BTN"));},"_expandButton":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","expand",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_EXPAND_HEADER_BTN"));},"_changesIconCont":function(i){return this._getButton(i,"sap-icon://user-edit","changes-cont",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},"_changesIcon":function(i){return this._getButton(i,"sap-icon://user-edit","changes",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},_getIcon:function(i,u,T){return I.createControlByURI({id:this._getParentAugmentedId(i,u),tooltip:T,src:I.getIconURI(u),visible:false});},_getButton:function(i,u,v,T){return new b({id:this._getParentAugmentedId(i,v),tooltip:T,icon:u,type:g.Transparent});},_getParentAugmentedId:function(i,u){return i.getId()+"-"+u;}};
n.prototype._lazyLoadInternalAggregation=function(i,S){if(!this.getAggregation(i)){this.setAggregation(i,n._internalAggregationFactory[i](this),S);}return this.getAggregation(i);};
n.prototype._applyActionProperty=function(i,u){var v=u[0];if(this.getProperty(i)!==v){u.unshift(i);this.setProperty.apply(this,u);if(!this._bFirstRendering){this._notifyParentOfChanges();}}return this;};
n.prototype._applyObjectImageProperty=function(i,u){var v=u[0];if(this.getProperty(i)!==v){u.unshift(i);this.setProperty.apply(this,u);this._destroyObjectImage();if(!this._bFirstRendering){this._notifyParentOfChanges(true);}}return this;};
n.prototype._setAggregationTooltip=function(i,T){var u=this.getAggregation(i);if(u){u.setTooltip(T);}return this;};
n.prototype._setTitleSelectorTooltip=function(T){if(T===null||T===undefined){T=this.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP");}this._setAggregationTooltip("_titleArrowIcon",T);this._setAggregationTooltip("_titleArrowIconCont",T);return this;};
n.prototype.setHeaderDesign=function(H){this.setProperty("headerDesign",H);if(this.getParent()){this.getParent().invalidate();}return this;};
n.prototype.setObjectTitle=function(N){var i=this.getParent(),u=this.getProperty("objectTitle"),v=u!==N;this._applyActionProperty("objectTitle",Array.prototype.slice.call(arguments));i&&k(i._updateRootAriaLabel)&&i._updateRootAriaLabel();if(v&&this.mEventRegistry["_titleChange"]){this.fireEvent("_titleChange",{"id":this.getId(),"name":"objectTitle","oldValue":u,"newValue":N});}return this;};
var p=["objectSubtitle","showTitleSelector","markLocked","markFavorite","markFlagged","showMarkers","showPlaceholder","markChanges"],o=["objectImageURI","objectImageAlt","objectImageDensityAware","objectImageShape"];var G=function(i){var u="set"+i.charAt(0).toUpperCase()+i.slice(1);n.prototype[u]=function(){var v=Array.prototype.slice.call(arguments);this._applyActionProperty.call(this,i,v);};};var r=function(i){var u="set"+i.charAt(0).toUpperCase()+i.slice(1);n.prototype[u]=function(){var v=Array.prototype.slice.call(arguments);this._applyObjectImageProperty.call(this,i,v);};};var s=function(i,S,T){var u="set"+i.charAt(0).toUpperCase()+i.slice(1);S[u]=function(){var v=Array.prototype.slice.call(arguments);v.unshift(i);T.setProperty.apply(T,v);return this.setProperty.apply(this,v);};};p.forEach(G);o.forEach(r);
n.prototype._destroyObjectImage=function(){var i="_objectImage",u=this.getAggregation(i);if(u){u.destroy();this.setAggregation(i,null);}};
n.prototype.onBeforeRendering=function(){var S=this.getSideContentButton();if(S&&!S.getTooltip()){S.setTooltip(this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SHOW_SIDE_CONTENT"));}var i=this.getActions()||[];this._oOverflowActionSheet.removeAllButtons();this._resetActionSheetMap();if(i.length>1||this._hasOneButtonShowText(i)){i.forEach(function(u){if(u instanceof b&&!(u instanceof O)){u._bInternalVisible=u.getVisible();u._getInternalVisible=function(){return this._bInternalVisible;};u._setInternalVisible=function(V,w){this.$().toggle(V);if(V!=this._bInternalVisible){this._bInternalVisible=V;if(w){this.invalidate();}}};u.setVisible=function(V){u._setInternalVisible(V,true);b.prototype.setVisible.call(this,V);};u.onAfterRendering=function(){if(!this._getInternalVisible()){this.$().hide();}};}if(u instanceof b&&(u.getType()==="Default"||u.getType()==="Unstyled")){u.setProperty("type",g.Transparent,false);}if(u instanceof b&&u.getVisible()){var v=this._createActionSheetButton(u);this._oActionSheetButtonMap[u.getId()]=v;this._oOverflowActionSheet.addButton(v);s("text",u,v);s("icon",u,v);s("enabled",u,v);}},this);}this._oTitleArrowIcon.setVisible(this.getShowTitleSelector());this._oFavIcon.setVisible(this.getMarkFavorite());this._oFlagIcon.setVisible(this.getMarkFlagged());this._attachDetachActionButtonsHandler(false);if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}this._bFirstRendering=false;};
n.prototype._resetActionSheetMap=function(){Object.keys(this._oActionSheetButtonMap).forEach(function(i){this._oActionSheetButtonMap[i].destroy();}.bind(this));this._oActionSheetButtonMap={};};
n.prototype._createActionSheetButton=function(i){return new b({press:q.proxy(this._onSeeMoreContentSelect,this),enabled:i.getEnabled(),text:i.getText(),icon:i.getIcon(),tooltip:i.getTooltip(),customData:new a({key:"originalId",value:i.getId()})});};
n.prototype._handleImageNotFoundError=function(){var i=this._lazyLoadInternalAggregation("_objectImage"),u=this.getParent(),$=u?u.$():this.$();if(this.getShowPlaceholder()){$.find(".sapMImg.sapUxAPObjectPageHeaderObjectImage").hide();$.find(".sapUxAPObjectPageHeaderPlaceholder").removeClass("sapUxAPHidePlaceholder");}else{i.addStyleClass("sapMNoImg");}};
n.prototype._clearImageNotFoundHandler=function(){this._lazyLoadInternalAggregation("_objectImage").$().off("error");};
n.prototype.onAfterRendering=function(){var $=this._lazyLoadInternalAggregation("_objectImage").$();this._adaptLayout();this._clearImageNotFoundHandler();$.error(this._handleImageNotFoundError.bind(this));if(!this.getObjectImageURI()){this._handleImageNotFoundError();}if(!this._iResizeId){this._iResizeId=R.register(this,this._onHeaderResize.bind(this));}this._attachDetachActionButtonsHandler(true);};
n.prototype._onHeaderResize=function(E){this._adaptLayout();if(this.getParent()&&typeof this.getParent()._onUpdateHeaderTitleSize==="function"){this.getParent()._onUpdateHeaderTitleSize(E);}};
n.prototype._attachDetachActionButtonsHandler=function(i){var u=this.getActions()||[];if(u.length<1){return;}u.forEach(function(v){if(v instanceof b){var w=this._oActionSheetButtonMap[v.getId()];if(i){v.attachEvent("_change",this._adaptLayout,this);if(w){w.attachEvent("_change",this._adaptOverflow,this);}}else{v.detachEvent("_change",this._adaptLayout,this);if(w){w.detachEvent("_change",this._adaptOverflow,this);}}}},this);};
n.prototype._onSeeMoreContentSelect=function(E){var i=E.getSource(),u=sap.ui.getCore().byId(i.data("originalId"));if(u.firePress){u.firePress({overflowButtonId:this._oOverflowButton.getId()});}this._oOverflowActionSheet.close();};
n._actionImportanceMap={"Low":3,"Medium":2,"High":1};
n._sortActionsByImportance=function(i,u){var v=(i instanceof O)?i.getImportance():f.High,w=(u instanceof O)?u.getImportance():f.High,x=n._actionImportanceMap[v]-n._actionImportanceMap[w];if(x===0){return i.position-u.position;}return x;};
n.prototype._hasOneButtonShowText=function(i){var u=false;if(i.length!==1){return u;}if(i[0]instanceof O){u=(!i[0].getHideText()&&i[0].getText()!="");}else if(i[0]instanceof b){u=(i[0].getText()!="");}return u;};
n.prototype._adaptLayout=function(E){this._adaptLayoutForDomElement(null,E);};
n.prototype._adaptLayoutForDomElement=function($,E){var i=$?$:this.getDomRef();if(t(i)){return;}var u=this._findById($,"identifierLine"),v=u.width(),w=this._getActionsWidth(),x=w/v,y=this._iAvailablePercentageForActions*v,z=this._oOverflowButton.$(),F=this._findById($,"actions"),H=F.find(".sapMBtn").not(".sapUxAPObjectPageHeaderExpandButton");if(x>this._iAvailablePercentageForActions){this._adaptActions(y);}else if(E&&E.getSource()instanceof O){E.getSource()._setInternalVisible(true);}if(D.system.phone){this.getActions().forEach(function(J){if(J instanceof b){J.$().css("visibility","visible");}});}if(H.filter(":visible").length===H.length){z.hide();}this._adaptObjectPageHeaderIndentifierLine($);};
n.prototype._adaptLayoutDelayed=function(){if(this._adaptLayoutTimeout){clearTimeout(this._adaptLayoutTimeout);}this._adaptLayoutTimeout=setTimeout(function(){this._adaptLayoutTimeout=null;this._adaptLayout();}.bind(this),0);};
n.prototype._adaptObjectPageHeaderIndentifierLine=function($){var i=this._findById($,"identifierLine"),u=i.width(),v=this._findById($,"subtitle"),w=this._findById($,"innerTitle"),x=this._findById($,"identifierLineContainer"),S,T,y=this._findById($,"actions"),z=$?$.find(".sapUxAPObjectPageHeaderObjectImageContainer"):this.$().find(".sapUxAPObjectPageHeaderObjectImageContainer"),E=y.width()+z.width(),F=this.$().parents().hasClass('sapUiSizeCompact')?7:3;if(v.length){if(v.hasClass("sapOPHSubtitleBlock")){v.removeClass("sapOPHSubtitleBlock");}S=v.outerHeight()+v.position().top;T=w.outerHeight()+w.position().top;if(Math.abs(S-T)>F){v.addClass("sapOPHSubtitleBlock");}}x.width((0.95-(E/u))*100+"%");};
n.prototype._adaptActions=function(u){var M=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())||D.system.phone,$=this._oOverflowButton.$(),v=$.show().width(),w=this.getActions(),x=w.length,y;for(var i=0;i<x;i++){w[i].position=i;}w.sort(n._sortActionsByImportance);w.forEach(function(z){y=this._oActionSheetButtonMap[z.getId()];if(y){v+=z.$().width();if(u>v&&!M){this._setActionButtonVisibility(z,true);$.hide();}else{this._setActionButtonVisibility(z,false);$.show();}}},this);};
n.prototype._adaptOverflow=function(){var i=this._oOverflowActionSheet.getButtons();var H=i.some(function(u){return u.getVisible();});this._oOverflowButton.$().toggle(H);};
n.prototype._setActionButtonVisibility=function(i,v){var u=this._oActionSheetButtonMap[i.getId()];if(u){if(i.getVisible()){i._setInternalVisible(v);u.setVisible(!v);}else{u.setVisible(false);}}};
n.prototype._getActionsWidth=function(){var w=0;this.getActions().forEach(function(i){if(i instanceof b){i.$().show();if(D.system.phone){i.$().css("visibility","hidden");}w+=i.$().outerWidth(true);}});return w;};
n.prototype._findById=function($,i){if(!i){return null;}if($){i=this.getId()+'-'+i;return q(document.getElementById(i));}return this.$(i);};
n.prototype._getBreadcrumbsAggregation=function(){var i=this.getBreadcrumbs(),u=this._lazyLoadInternalAggregation('_breadCrumbs',true);return i||((u&&u.getLinks().length)?u:null);};
n.prototype._notifyParentOfChanges=function(i){var u=this.getParent();if(u&&typeof u._headerTitleChangeHandler==="function"){u._headerTitleChangeHandler(i);}};
n.prototype.setTitleSelectorTooltip=function(T){this._setTitleSelectorTooltip(T);this.setAggregation("titleSelectorTooltip",T,true);return this;};
n.prototype.destroyTitleSelectorTooltip=function(){this._setTitleSelectorTooltip(null);this.destroyAggregation("titleSelectorTooltip",true);return this;};
n.prototype.exit=function(){this._clearImageNotFoundHandler();if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}this._resetActionSheetMap();};
n.prototype.setNavigationBar=function(i){this.setAggregation("navigationBar",i);if(i&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{"parent":this,"adaptableContent":i});}return this;};
n.prototype._getAdaptableContent=function(){return this.getNavigationBar();};
n.prototype.isDynamic=function(){return false;};
n.prototype.getCompatibleHeaderContentClass=function(){return d;};
n.prototype.supportsToggleHeaderOnTitleClick=function(){return false;};
n.prototype.supportsTitleInHeaderContent=function(){return true;};
n.prototype.supportsAdaptLayoutForDomElement=function(){return true;};
n.prototype.supportsBackgroundDesign=function(){return false;};
n.prototype.getTitleText=function(){return this.getObjectTitle();};
n.prototype.snap=function(){this._adaptLayout();};
n.prototype.unSnap=function(){this._adaptLayout();};
n.prototype._toggleExpandButton=function(T){};
n.prototype._setShowExpandButton=function(v){};
n.prototype._focusExpandButton=function(){};
n.prototype._toggleFocusableState=function(F){};
function t($){return $&&!$.offsetWidth&&!$.offsetHeight;}
return n;});
sap.ui.predefine('sap/uxap/ObjectPageHeaderActionButton',["sap/m/Button","./library","./ObjectPageHeaderActionButtonRenderer"],function(B,l,O){"use strict";
var a=B.extend("sap.uxap.ObjectPageHeaderActionButton",{metadata:{interfaces:["sap.m.IOverflowToolbarContent"],library:"sap.uxap",properties:{hideText:{type:"boolean",defaultValue:true},hideIcon:{type:"boolean",defaultValue:false},importance:{type:"sap.uxap.Importance",group:"Behavior",defaultValue:l.Importance.High}},designtime:"sap/uxap/designtime/ObjectPageHeaderActionButton.designtime"}});
a.prototype.init=function(){this._bInternalVisible=this.getVisible();};
a.prototype.onAfterRendering=function(){if(!this._getInternalVisible()){this.$().hide();}};
a.prototype.applySettings=function(s,S){if(B.prototype.applySettings){B.prototype.applySettings.call(this,s,S);}this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideText",this.getHideText());this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",this.getHideIcon());};
a.prototype.setHideText=function(v,i){this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideText",v);return this.setProperty("hideText",v,i);};
a.prototype.setHideIcon=function(v,i){this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",v);return this.setProperty("hideIcon",v,i);};
a.prototype._setInternalVisible=function(v,i){this.$().toggle(v);if(v!=this._bInternalVisible){this._bInternalVisible=v;if(i){this.invalidate();}}};
a.prototype.setVisible=function(v){var r=B.prototype.setVisible.apply(this,arguments);if(this.getParent()&&typeof this.getParent()._adaptLayoutDelayed==="function"){this.getParent()._adaptLayoutDelayed();}return r;};
a.prototype._getInternalVisible=function(){return this._bInternalVisible;};
a.prototype.getOverflowToolbarConfig=function(){var c={canOverflow:true,propsUnrelatedToSize:["importance"],getCustomImportance:function(){return this.getImportance();}.bind(this)};c.onBeforeEnterOverflow=function(A){A.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideText",false,true);A.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",false,true);};c.onAfterExitOverflow=function(A){A.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideText",A.getHideText(),true);A.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",A.getHideIcon(),true);};return c;};
return a;});
sap.ui.predefine('sap/uxap/ObjectPageHeaderActionButtonRenderer',["sap/m/ButtonRenderer","sap/ui/core/Renderer"],function(B,R){"use strict";var O=R.extend(B);return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageHeaderContent',["sap/ui/core/Control","./library","sap/m/Button","./ObjectImageHelper","./ObjectPageHeaderContentRenderer"],function(C,l,B,O,a){"use strict";var b=l.ObjectPageHeaderDesign;
var c=C.extend("sap.uxap.ObjectPageHeaderContent",{metadata:{library:"sap.uxap",interfaces:["sap.uxap.IHeaderContent"],properties:{contentDesign:{type:"sap.uxap.ObjectPageHeaderDesign",group:"Misc",defaultValue:b.Light}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},_editHeaderButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_objectImage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_placeholder:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}}}});
c.prototype.onBeforeRendering=function(){var p=this.getParent(),e=this.getAggregation("_editHeaderButton");if(e){return;}if(p&&(p instanceof l.ObjectPageLayout)&&p.getShowEditHeaderButton()){e=this._getInternalBtnAggregation("_editHeaderButton","EDIT_HEADER","-editHeaderBtn","Transparent");e.attachPress(this._handleEditHeaderButtonPress,this);}};
c.prototype.exit=function(){var e=this.getAggregation("_editHeaderButton");if(e){e.detachPress(this._handleEditHeaderButtonPress,this);}};
c.prototype._handleEditHeaderButtonPress=function(e){this.getParent().fireEditHeaderButtonPress();};
c.prototype._getInternalBtnAggregation=function(A,s,d,e){if(!this.getAggregation(A)){var o=new B({text:sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText(s),type:e,id:this.getId()+d});this.setAggregation(A,o);}return this.getAggregation(A);};
c.prototype._getObjectImage=function(){if(!this.getAggregation("_objectImage")){var p=this.getParent(),h=p&&p.getHeaderTitle&&p.getHeaderTitle(),o=h&&O.createObjectImage(h);if(o){this.setAggregation("_objectImage",o,true);}}return this.getAggregation("_objectImage");};
c.prototype._destroyObjectImage=function(s){var o=this.getAggregation("_objectImage");if(o){o.destroy();this.getAggregation("_objectImage",null,s);}};
c.prototype._getPlaceholder=function(){if(!this.getAggregation("_placeholder")){var p=this.getParent(),h=p&&p.getHeaderTitle&&p.getHeaderTitle(),s=h.getShowPlaceholder();var P=s&&O.createPlaceholder();if(P){this.setAggregation("_placeholder",P,true);}}return this.getAggregation("_placeholder");};
c.prototype._getLayoutDataForControl=function(o){var L=o.getLayoutData();if(!L){return;}else if(L instanceof l.ObjectPageHeaderLayoutData){return L;}else if(L.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){var d=L.getMultipleLayoutData();for(var i=0;i<d.length;i++){var e=d[i];if(e instanceof l.ObjectPageHeaderLayoutData){return e;}}}};
c.createInstance=function(d,v,s){return new c({content:d,visible:v,contentDesign:s});};
c.prototype.supportsPinUnpin=function(){return false;};
c.prototype.supportsChildPageDesign=function(){return true;};
c.prototype.supportsAlwaysExpanded=function(){return true;};
c.prototype._toggleCollapseButton=function(t){};
c.prototype._setShowCollapseButton=function(v){};
c.prototype._focusCollapseButton=function(){};
c.prototype._focusPinButton=function(){};
return c;});
sap.ui.predefine('sap/uxap/ObjectPageHeaderContentRenderer',["./ObjectPageHeaderRenderer","./ObjectImageHelper"],function(O,a){"use strict";var b={};
b.render=function(r,c){var p=c.getParent(),P=p&&p.isA("sap.uxap.ObjectPageLayout"),h=(p&&P)?p.getHeaderTitle():undefined,R=(p&&P)?(p.isA("sap.uxap.ObjectPageLayout")&&p.getShowTitleInHeaderContent()):false,d=P&&p.getShowEditHeaderButton()&&c.getContent()&&c.getContent().length>0;if(d){r.write("<div ");r.writeControlData(c);r.addClass("sapUxAPObjectPageHeaderContentFlexBox");r.addClass("sapUxAPObjectPageHeaderContentDesign-"+c.getContentDesign());if(h){r.addClass('sapUxAPObjectPageContentObjectImage-'+h.getObjectImageShape());}r.writeClasses();r.write(">");}r.write("<div ");if(d){r.addClass("sapUxAPObjectPageHeaderContentCellLeft");}else{r.writeControlData(c);r.addClass("sapUxAPObjectPageHeaderContentDesign-"+c.getContentDesign());if(h){r.addClass('sapUxAPObjectPageContentObjectImage-'+h.getObjectImageShape());}}r.addClass("sapContrastPlus");r.addClass("ui-helper-clearfix");r.addClass("sapUxAPObjectPageHeaderContent");if(!c.getVisible()){r.addClass("sapUxAPObjectPageHeaderContentHidden");}r.writeClasses();r.write(">");if(P&&p.getIsChildPage()){r.write("<div");r.addClass('sapUxAPObjectChildPage');r.writeClasses();r.write("></div>");}if(R){this._renderTitleImage(r,c,h);if(c.getContent().length==0){r.write("<span class=\"sapUxAPObjectPageHeaderContentItem\">");this._renderTitle(r,h);r.write("</span>");}}c.getContent().forEach(function(i,I){this._renderHeaderContentItem(i,I,r,R,h,c);},this);r.write("</div>");if(d){this._renderEditButton(r,c);r.write("</div>");}};
b._renderHeaderContentItem=function(h,i,r,R,t,c){var H=false,d=false,l=c._getLayoutDataForControl(h),I=i===0;if(l){H=l.getShowSeparatorBefore();d=l.getShowSeparatorAfter();r.write("<span ");r.addClass("sapUxAPObjectPageHeaderWidthContainer");r.addClass("sapUxAPObjectPageHeaderContentItem");r.addStyle("width",l.getWidth());r.writeStyles();if(d||H){r.addClass("sapUxAPObjectPageHeaderSeparatorContainer");}if(!l.getVisibleL()){r.addClass("sapUxAPObjectPageHeaderLayoutHiddenL");}if(!l.getVisibleM()){r.addClass("sapUxAPObjectPageHeaderLayoutHiddenM");}if(!l.getVisibleS()){r.addClass("sapUxAPObjectPageHeaderLayoutHiddenS");}r.writeClasses();r.write(">");if(H){r.write("<span class=\"sapUxAPObjectPageHeaderSeparatorBefore\"/>");}if(I&&R){this._renderTitle(r,t);}}else{if(I&&R){r.write("<span class=\"sapUxAPObjectPageHeaderContentItem\">");this._renderTitle(r,t);}else{h.addStyleClass("sapUxAPObjectPageHeaderContentItem");}}r.renderControl(h);if(d){r.write("<span class=\"sapUxAPObjectPageHeaderSeparatorAfter\"/>");}if(l||(I&&R)){r.write("</span>");}};
b._renderTitleImage=function(r,c,h){a._renderImageAndPlaceholder(r,{oHeader:h,oObjectImage:c._getObjectImage(),oPlaceholder:c._getPlaceholder(),bIsObjectIconAlwaysVisible:false,bAddSubContainer:false,sBaseClass:'sapUxAPObjectPageHeaderContentImageContainer'});};
b._renderTitle=function(r,h){O._renderObjectPageTitle(r,h,true);};
b._renderEditButton=function(r,h){r.write("<div class=\"sapUxAPObjectPageHeaderContentCellRight\">");r.renderControl(h.getAggregation("_editHeaderButton"));r.write("</div>");};
return b;},true);
sap.ui.predefine('sap/uxap/ObjectPageHeaderLayoutData',["sap/ui/core/LayoutData","./library"],function(L,l){"use strict";
var O=L.extend("sap.uxap.ObjectPageHeaderLayoutData",{metadata:{library:"sap.uxap",properties:{visibleS:{type:"boolean",group:"Misc",defaultValue:true},visibleM:{type:"boolean",group:"Misc",defaultValue:true},visibleL:{type:"boolean",group:"Misc",defaultValue:true},showSeparatorBefore:{type:"boolean",group:"Misc",defaultValue:false},showSeparatorAfter:{type:"boolean",group:"Misc",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'auto'}}}});
return O;});
sap.ui.predefine('sap/uxap/ObjectPageHeaderRenderer',["./ObjectImageHelper","sap/ui/Device"],function(O,D){"use strict";var a={};
a.render=function(r,c){var n=c.getNavigationBar(),t=(c.getIsObjectIconAlwaysVisible()||c.getIsObjectTitleAlwaysVisible()||c.getIsObjectSubtitleAlwaysVisible()||c.getIsActionAreaAlwaysVisible()),p=c.getParent(),e=c.getAggregation("_expandButton"),o=c._lazyLoadInternalAggregation("_objectImage",true),P,I=D.system.desktop,b=p&&p.isA("sap.uxap.ObjectPageLayout")&&((p.getHeaderContent()&&p.getHeaderContent().length>0&&p.getShowHeaderContent())||(p.getShowHeaderContent()&&p.getShowTitleInHeaderContent()));r.write("<div");r.writeControlData(c);r.addClass('sapUxAPObjectPageHeader');r.addClass('sapUxAPObjectPageHeaderDesign-'+c.getHeaderDesign());r.writeClasses();r.write(">");if(n){r.write("<div");r.addClass('sapUxAPObjectPageHeaderNavigation');r.writeClasses();r.write(">");r.renderControl(n);r.write("</div>");}r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-identifierLine");r.addClass('sapUxAPObjectPageHeaderIdentifier');if(t){r.addClass('sapUxAPObjectPageHeaderIdentifierForce');}r.writeClasses();r.write(">");if(p&&p.isA("sap.uxap.ObjectPageLayout")&&p.getIsChildPage()){r.write("<div");r.addClass('sapUxAPObjectChildPage');r.writeClasses();r.write("></div>");}if(c.getShowPlaceholder()){P=c._lazyLoadInternalAggregation("_placeholder",true);}O._renderImageAndPlaceholder(r,{oHeader:c,oObjectImage:o,oPlaceholder:P,bIsObjectIconAlwaysVisible:c.getIsObjectIconAlwaysVisible(),bAddSubContainer:true,sBaseClass:'sapUxAPObjectPageHeaderObjectImageContainer'});r.write("<span ");r.writeAttributeEscaped("id",c.getId()+"-identifierLineContainer");r.addClass('sapUxAPObjectPageHeaderIdentifierContainer');r.writeClasses();r.write(">");this._renderObjectPageTitle(r,c);r.write("</span>");r.write("<span");r.writeAttributeEscaped("id",c.getId()+"-actions");r.addClass('sapUxAPObjectPageHeaderIdentifierActions');if(c.getIsActionAreaAlwaysVisible()){r.addClass('sapUxAPObjectPageHeaderIdentifierActionsForce');}r.writeClasses();r.write(">");if(I&&b){e.addStyleClass("sapUxAPObjectPageHeaderExpandButton");r.renderControl(e);}var A=c.getActions();for(var i=0;i<A.length;i++){var d=A[i];r.renderControl(d);}var f=c.getAggregation("_overflowButton");r.renderControl(f);this._renderSideContentBtn(r,c);r.write("</span>");r.write("</div>");r.write("</div>");};
a._renderObjectPageTitle=function(r,c,t){var o=c.getObjectTitle(),m=(c.getShowMarkers()&&(c.getMarkFavorite()||c.getMarkFlagged())),b=c._getBreadcrumbsAggregation();if(!t&&b){r.renderControl(b);}r.write("<h1");r.addClass('sapUxAPObjectPageHeaderIdentifierTitle');if(c.getIsObjectTitleAlwaysVisible()){r.addClass('sapUxAPObjectPageHeaderIdentifierTitleForce');}if(t){r.addClass('sapUxAPObjectPageHeaderIdentifierTitleInContent');}if(c.getShowTitleSelector()){r.addClass('sapUxAPObjectPageHeaderTitleFollowArrow');}r.writeClasses();r.writeAttributeEscaped("id",c.getId()+"-title");r.write(">");r.write("<span");r.addClass("sapUxAPObjectPageHeaderTitleTextWrappable");r.writeClasses();r.writeAttributeEscaped("id",c.getId()+"-innerTitle");r.write(">");if(m||c.getShowTitleSelector()||c.getMarkLocked()||c.getMarkChanges()){var s=o.substr(o.lastIndexOf(" ")+1);var d=o.substr(0,o.lastIndexOf(" ")+1);if(s.length===1){s=o;d='';}r.writeEscaped(d);r.write("</span>");r.write("<span");r.addClass('sapUxAPObjectPageHeaderNowrapMarkers');if(c.getMarkLocked()||c.getMarkChanges()){r.addClass('sapUxAPObjectPageHeaderMarks');}r.writeClasses();r.write(">");r.writeEscaped(s);this._renderMarkers(r,c);if(c.getMarkLocked()){this._renderLock(r,c,t);}else if(c.getMarkChanges()){this._renderMarkChanges(r,c,t);}this._renderSelectTitleArrow(r,c,t);r.write("</span>");}else{r.writeEscaped(o);r.write("</span>");}r.write("</h1>");r.write("<span");r.addClass('sapUxAPObjectPageHeaderIdentifierDescription');if(c.getIsObjectSubtitleAlwaysVisible()&&c.getObjectSubtitle()){r.addClass('sapUxAPObjectPageHeaderIdentifierDescriptionForce');}if(t){r.addClass('sapUxAPObjectPageHeaderIdentifierSubTitleInContent');}r.writeClasses();r.writeAttributeEscaped("id",c.getId()+"-subtitle");r.write(">");r.writeEscaped(c.getObjectSubtitle());r.write("</span>");};
a._renderSelectTitleArrow=function(r,c,t){if(c.getShowTitleSelector()){r.write("<span");r.addClass("sapUxAPObjectPageHeaderTitleArrow");r.writeClasses();r.write(">");if(t){r.renderControl(c._oTitleArrowIconCont);}else{r.renderControl(c._oTitleArrowIcon);}r.write("</span>");}};
a._renderSideContentBtn=function(r,c){var s=c.getSideContentButton();if(s){r.write("<span");r.addClass("sapUxAPObjectPageHeaderSideContentBtn");r.writeClasses();r.write(">");r.write("<span");r.addClass("sapUxAPObjectPageHeaderSeparator");r.writeClasses();r.write("></span>");r.renderControl(s);r.write("</span>");}};
a._renderMarkChanges=function(r,c,t){r.write("<span");r.addClass("sapUxAPObjectPageHeaderChangesBtn");r.addClass("sapUiSizeCompact");r.writeClasses();r.write(">");if(t){r.renderControl(c._oChangesIconCont);}else{r.renderControl(c._oChangesIcon);}r.write("</span>");};
a._renderLock=function(r,c,t){r.write("<span");r.addClass("sapUxAPObjectPageHeaderLockBtn");r.addClass("sapUiSizeCompact");r.writeClasses();r.write(">");if(t){r.renderControl(c._oLockIconCont);}else{r.renderControl(c._oLockIcon);}r.write("</span>");};
a._renderMarkers=function(r,c){var I=[];if(c.getShowMarkers()){I.push(c._oFavIcon);I.push(c._oFlagIcon);this._renderMarkersAria(r,c);r.write("<span");r.addClass("sapMObjStatusMarker");r.writeClasses();r.writeAttributeEscaped("id",c.getId()+"-markers");r.writeAttributeEscaped("aria-describedby",c.getId()+"-markers-aria");r.write(">");for(var i=0;i<I.length;i++){r.renderControl(I[i]);}r.write("</span>");}};
a._renderMarkersAria=function(r,c){var A="";if(c.getMarkFlagged()){A+=(c.oLibraryResourceBundle.getText("ARIA_FLAG_MARK_VALUE")+" ");}if(c.getMarkFavorite()){A+=(c.oLibraryResourceBundle.getText("ARIA_FAVORITE_MARK_VALUE")+" ");}if(A!==""){r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-markers-aria");r.writeAttribute("aria-hidden","false");r.addClass("sapUiHidden");r.writeClasses();r.write(">");r.writeEscaped(A);r.write("</div>");}};
return a;},true);
sap.ui.predefine('sap/uxap/ObjectPageLayout',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObjectObserver","sap/ui/core/ResizeHandler","sap/ui/core/Control","sap/ui/Device","sap/ui/core/delegate/ScrollEnablement","./ObjectPageSectionBase","./ObjectPageSection","./ObjectPageSubSection","./ObjectPageHeaderContent","./LazyLoading","./ObjectPageLayoutABHelper","./ThrottledTaskHelper","sap/ui/core/ScrollBar","sap/ui/core/library","./library","./ObjectPageLayoutRenderer","sap/base/Log","sap/ui/dom/getScrollbarSize","sap/base/assert","sap/ui/events/KeyCodes"],function(q,M,R,C,D,S,O,a,b,c,L,A,T,d,e,l,f,g,h,i,K){"use strict";var j=e.TitleLevel;var k=l.ObjectPageSubSectionLayout;
var m=C.extend("sap.uxap.ObjectPageLayout",{metadata:{library:"sap.uxap",properties:{showAnchorBar:{type:"boolean",defaultValue:true},showAnchorBarPopover:{type:"boolean",defaultValue:true},upperCaseAnchorBar:{type:"boolean",defaultValue:true},backgroundDesignAnchorBar:{type:"sap.m.BackgroundDesign",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},enableLazyLoading:{type:"boolean",defaultValue:false},subSectionLayout:{type:"sap.uxap.ObjectPageSubSectionLayout",defaultValue:k.TitleOnTop},sectionTitleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:j.Auto},useIconTabBar:{type:"boolean",group:"Misc",defaultValue:false},showHeaderContent:{type:"boolean",group:"Misc",defaultValue:true},useTwoColumnsForLargeScreen:{type:"boolean",group:"Appearance",defaultValue:false},showTitleInHeaderContent:{type:"boolean",group:"Appearance",defaultValue:false},showOnlyHighImportance:{type:"boolean",group:"Behavior",defaultValue:false},isChildPage:{type:"boolean",group:"Appearance",defaultValue:false},alwaysShowContentHeader:{type:"boolean",group:"Behavior",defaultValue:false},headerContentPinnable:{type:"boolean",group:"Behavior",defaultValue:true},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},showEditHeaderButton:{type:"boolean",group:"Behavior",defaultValue:false},flexEnabled:{type:"boolean",group:"Misc",defaultValue:false},showFooter:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{selectedSection:{type:"sap.uxap.ObjectPageSection",multiple:false}},defaultAggregation:"sections",aggregations:{sections:{type:"sap.uxap.ObjectPageSection",multiple:true,singularName:"section"},headerTitle:{type:"sap.uxap.IHeaderTitle",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent"},footer:{type:"sap.m.IBar",multiple:false},_anchorBar:{type:"sap.uxap.AnchorBar",multiple:false,visibility:"hidden"},_iconTabBar:{type:"sap.m.IconTabBar",multiple:false,visibility:"hidden"},_headerContent:{type:"sap.uxap.IHeaderContent",multiple:false,visibility:"hidden"},_customScrollBar:{type:"sap.ui.core.ScrollBar",multiple:false,visibility:"hidden"}},events:{toggleAnchorBar:{parameters:{fixed:{type:"boolean"}}},editHeaderButtonPress:{},navigate:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}}},designtime:"sap/uxap/designtime/ObjectPageLayout.designtime"}});
m.HEADER_CALC_DELAY=350;m.DOM_CALC_DELAY=200;m.FOOTER_ANIMATION_DURATION=350;m.MAX_SNAP_POSITION_OFFSET=20;m.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=0.6;m.TITLE_LEVEL_AS_ARRAY=Object.keys(j);m.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};m.BREAK_POINTS={TABLET:1024,PHONE:600};m.DYNAMIC_HEADERS_MEDIA={PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop"};
m._getNextTitleLevelEntry=function(t){var o=m.TITLE_LEVEL_AS_ARRAY.indexOf(t),p=o!==-1,H=p&&(o!==m.TITLE_LEVEL_AS_ARRAY.length-1);if(!p){return j.Auto;}return m.TITLE_LEVEL_AS_ARRAY[H?o+1:o];};
m._getLibraryResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap");};
m.prototype.init=function(){this.oCore=sap.ui.getCore();this._bFirstRendering=true;this._bDomReady=false;this._bPinned=false;this._bStickyAnchorBar=false;this._bHeaderInTitleArea=false;this._bHeaderExpanded=true;this._bHeaderBiggerThanAllowedHeight=false;this._bDelayDOMBasedCalculations=true;this._iStoredScrollPosition=0;this._bInternalAnchorBarVisible=true;this._$opWrapper=[];this._$anchorBar=[];this._$headerTitle=[];this._$stickyAnchorBar=[];this._$headerContent=[];this._$stickyHeaderContent=[];this._bMobileScenario=false;this._oSectionInfo={};this._aSectionBases=[];this._sScrolledSectionId="";this._iScrollToSectionDuration=600;this._$spacer=[];this.iHeaderContentHeight=0;this.iStickyHeaderContentHeight=0;this.iHeaderTitleHeight=0;this.iHeaderTitleHeightStickied=0;this.iAnchorBarHeight=0;this.iTotalHeaderSize=0;this._iREMSize=parseInt(q("body").css("font-size"),10);this._iOffset=parseInt(0.25*this._iREMSize,10);this._iResizeId=R.register(this,this._onUpdateScreenSize.bind(this));this._iAfterRenderingDomReadyTimeout=null;this._oABHelper=new A(this);this._initializeScroller();};
m.prototype.onBeforeRendering=function(){var H,p;this._oLazyLoading=new L(this);if(!this.getVisible()){return;}if(!this.getSelectedSection()){this._bHeaderExpanded=true;}this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(this._checkAlwaysShowContentHeader()){this._bHeaderExpanded=true;}this._bHeaderInTitleArea=this._shouldPreserveHeaderInTitleArea();this._createHeaderContent();this._getHeaderContent().setContentDesign(this._getHeaderDesign());this._oABHelper._getAnchorBar().setProperty("upperCase",this.getUpperCaseAnchorBar(),true);this._storeScrollLocation();this._applyUxRules();this._getCustomScrollBar().setScrollPosition(0);if(!q.isEmptyObject(this._oSectionInfo)&&this._bFirstRendering){this._preloadSectionsOnBeforeFirstRendering();this._bFirstRendering=false;}this._bStickyAnchorBar=false;this._handleExpandButtonPressEventLifeCycle(false);this._attachTitlePressHandler();H=this._getHeaderContent();if(H&&H.supportsPinUnpin()){p=this.getHeaderContentPinnable()&&!this.getPreserveHeaderStateOnScroll();this._getHeaderContent().setPinnable(p);if(p){this._attachPinPressHandler();}}this._attachVisualIndicatorsPressHandlers(this._handleDynamicTitlePress,this);this._attachVisualIndicatorMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);this._attachTitleMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);};
m.prototype.setBackgroundDesignAnchorBar=function(B){var s=this.getBackgroundDesignAnchorBar(),o="sapUxAPObjectPageNavigation";if(s===B){return this;}this.setProperty("backgroundDesignAnchorBar",B,true);this._oABHelper._getAnchorBar().setBackgroundDesign(B);if(n(this._$anchorBar)){this._$anchorBar.removeClass(o+s);this._$anchorBar.addClass(o+B);}if(n(this._$stickyAnchorBar)){this._$stickyAnchorBar.removeClass(o+s);this._$stickyAnchorBar.addClass(o+B);}return this;};
m.prototype.setToggleHeaderOnTitleClick=function(t){var o=this.getHeaderTitle(),r=this.setProperty("toggleHeaderOnTitleClick",t,true);if(!o||!o.supportsToggleHeaderOnTitleClick()){g.warning("Setting toggleHeaderOnTitleClick will not take effect as it is not supported in the ObjectPageHeader, read the API Doc for more information",this);return r;}t=this.getProperty("toggleHeaderOnTitleClick");this.$().toggleClass("sapUxAPObjectPageLayoutTitleClickEnabled",t);this._updateToggleHeaderVisualIndicators();if(n(o)){o._toggleFocusableState(t);}return r;};
m.prototype._attachTitlePressHandler=function(){var t=this.getHeaderTitle();if(n(t)&&!this._bAlreadyAttachedTitlePressHandler){t.attachEvent(m.EVENTS.TITLE_PRESS,this._handleDynamicTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true;}};
m.prototype._toggleHeaderVisibility=function(s){var H=this._getHeaderContent();if(n(H)){H.$().toggleClass("sapUxAPObjectPageHeaderContentHidden",!s);}};
m.prototype._snapHeader=function(o){var I,H=this._getHeaderContent();if(H&&H.supportsPinUnpin()&&this._bPinned){this._unPin();H.getAggregation("_pinButton").setPressed(false);o=true;}this._toggleHeaderTitle(false,true);this._moveAnchorBarToTitleArea();if(o){this._moveHeaderToContentArea();this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout(true);I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));if(I){this._scrollTo(this._getSnapPosition()+1);}return;}this._toggleHeaderVisibility(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();};
m.prototype._expandHeader=function(o){this._toggleHeaderTitle(true,true);this._toggleHeaderVisibility(true);if(o){this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();if(n(this._$stickyAnchorBar)){this._$stickyAnchorBar.addClass("sapUxAPObjectPageStickyAnchorBarPaddingTop");}return;}this._moveAnchorBarToContentArea();this._moveHeaderToContentArea();this._scrollTo(0,0,0);this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();if(n(this._$stickyAnchorBar)){this._$stickyAnchorBar.removeClass("sapUxAPObjectPageStickyAnchorBarPaddingTop");}};
m.prototype._handleDynamicTitlePress=function(){if(!this.getToggleHeaderOnTitleClick()){return;}var E=!this._bHeaderExpanded,I,o,p;if(E){I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));o=!this._headerBiggerThanAllowedToBeExpandedInTitleArea()&&(this._shouldPreserveHeaderInTitleArea()||!I);this._expandHeader(o);if(!o){this._scrollTo(0,0);}}else{p=!this._shouldPreserveHeaderInTitleArea();this._snapHeader(p);}};
m.prototype._attachPinPressHandler=function(){var H=this._getHeaderContent();if(n(H)&&!this._bAlreadyAttachedPinPressHandler){H.attachEvent(m.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};
m.prototype._handleExpandButtonPressEventLifeCycle=function(o){var H=this.getHeaderTitle(),E;if(H){E=H.getAggregation("_expandButton");if(E){E[o?"attachPress":"detachPress"](this._handleExpandButtonPress,this);}}};
m.prototype._adjustSelectedSectionByUXRules=function(){var s=this.oCore.byId(this.getSelectedSection()),v=s&&this._sectionCanBeRenderedByUXRules(s);if(!v){if(this._oFirstVisibleSection){s=this._oFirstVisibleSection;this.setAssociation("selectedSection",s.getId(),true);}else{this.setAssociation("selectedSection",null,true);return;}}var o=this.oCore.byId(this._sStoredScrolledSubSectionId),V=o&&this._sectionCanBeRenderedByUXRules(o)&&(s.indexOfSubSection(o)>=0);if(!V){this._sStoredScrolledSubSectionId=null;}};
m.prototype._sectionCanBeRenderedByUXRules=function(s){if(!s||!s.getVisible()||!s._getInternalVisible()){return false;}var o=this._aSectionBases.map(function(p){return p.getId();});return(o.indexOf(s.getId())>-1);};
m.prototype._getSectionsToRender=function(){this._adjustSelectedSectionByUXRules();var s=this.oCore.byId(this.getSelectedSection());if(this.getUseIconTabBar()&&s){return[s];}else{return this.getSections();}};
m.prototype._preloadSectionsOnBeforeFirstRendering=function(){var t;if(!this.getEnableLazyLoading()){t=this._getSectionsToRender();}else{var s=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;t=this._oLazyLoading.getSubsectionsToPreload(s);}this._connectModelsForSections(t);};
m.prototype._grepCurrentTabSectionBases=function(){var F=[],s;this._adjustSelectedSectionByUXRules();s=this.oCore.byId(this.getSelectedSection());if(s){var o=s.getId();this._aSectionBases.forEach(function(p){if(p.getParent().getId()===o){F.push(p);}});}return F;};
m.prototype.onAfterRendering=function(){var H=this._getHeaderContent();this._ensureCorrectParentHeight();this._cacheDomElements();this._$opWrapper.on("scroll",this._onScroll.bind(this));if(this._bDomReady&&this.$().parents(":hidden").length===0){this._onAfterRenderingDomReady();}else{if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}this._iAfterRenderingDomReadyTimeout=setTimeout(this._onAfterRenderingDomReady.bind(this),this._getDOMCalculationDelay());}if(H&&H.supportsPinUnpin()){this.$().toggleClass("sapUxAPObjectPageLayoutHeaderPinnable",H.getPinnable());}this._handleExpandButtonPressEventLifeCycle(true);};
m.prototype._onAfterRenderingDomReady=function(){var s,o,p;if(this._bIsBeingDestroyed){return;}this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();o=this.oCore.byId(s);this._iAfterRenderingDomReadyTimeout=null;this._bDomReady=true;this._adjustHeaderHeights();this._initAnchorBarScroll();if(s){if(this.getUseIconTabBar()){this._setSelectedSectionId(s);this._setCurrentTabSection(o);}else{this.scrollToSection(s,0);}}if(D.system.desktop){this._$opWrapper.on("scroll",this.onWrapperScroll.bind(this));}this._registerOnContentResize();this.getHeaderTitle()&&this._shiftHeaderTitle();this.getFooter()&&this._shiftFooter();this._setSectionsFocusValues();if(this._preserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}if(!this._bHeaderExpanded){p=!this._shouldPreserveHeaderInTitleArea();this._snapHeader(p);}this._restoreScrollPosition();this.oCore.getEventBus().publish("sap.ui","ControlForPersonalizationRendered",this);if(this._hasDynamicTitle()){this._updateMedia(this._getWidth(this));}this._updateToggleHeaderVisualIndicators();this.fireEvent("onAfterRenderingDOMReady");};
m.prototype._shiftFooter=function(){var $=this.$("footerWrapper"),s=this._calculateShiftOffset();$.css(s.sStyleAttribute,s.iMarginalsOffset+"px");};
m.prototype._calculateShiftOffset=function(){var H=0,s=this.oCore.getConfiguration().getRTL()?"left":"right",o=this._hasVerticalScrollBar(),p=this._iOffset,r;if(D.system.desktop){r=h().width;H=r;if(!o){H=0;p+=r;}}return{"sStyleAttribute":s,"iActionsOffset":p,"iMarginalsOffset":H};};
m.prototype._getDOMCalculationDelay=function(){return this._bDelayDOMBasedCalculations?m.HEADER_CALC_DELAY:0;};
m.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._iResizeId){R.deregister(this._iResizeId);}if(this._iContentResizeId){R.deregister(this._iContentResizeId);}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}if(this._oObserver){this._oObserver.disconnect();this._oObserver=null;}this._oFirstVisibleSection=null;this._oFirstVisibleSubSection=null;};
m.prototype._getCustomScrollBar=function(){if(!this.getAggregation("_customScrollBar")){var v=new d(this.getId()+"-vertSB",{vertical:true,size:"100%",scrollPosition:0,scroll:this.onCustomScrollerScroll.bind(this),visible:false});this.setAggregation("_customScrollBar",v,true);}return this.getAggregation("_customScrollBar");};
m.prototype.onWrapperScroll=function(E){var s=Math.max(E.target.scrollTop,0);if(this._getCustomScrollBar()){if(this.allowCustomScroll===true){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getCustomScrollBar().setScrollPosition(s);}};
m.prototype.onCustomScrollerScroll=function(E){var s=Math.max(this._getCustomScrollBar().getScrollPosition(),0);if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;q(this._$opWrapper).scrollTop(s);};
m.prototype.setShowOnlyHighImportance=function(v){var o=this.getShowOnlyHighImportance();if(o!==v){this.setProperty("showOnlyHighImportance",v,true);this.getSections().forEach(function(s){s._updateImportance();});}return this;};
m.prototype.setIsHeaderContentAlwaysExpanded=function(v){var o=this.getAlwaysShowContentHeader();var s=(D.system.phone||D.system.tablet);if(o!==v){this.setProperty("alwaysShowContentHeader",v,s);}return this;};
m.prototype.setShowEditHeaderButton=function(v){var o=this.getShowEditHeaderButton(),H=this.getAggregation("_headerContent");if(o!==v){this.setProperty("showEditHeaderButton",v,true);H&&H.invalidate();}return this;};
m.prototype._initializeScroller=function(){if(this._oScroller){return;}this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:false,vertical:true});};
m.prototype.setSelectedSection=function(I){var v,s;if(I instanceof O){I=I.getId();}else if(I!=null&&typeof I!=="string"){i(false,"setSelectedSection(): sId must be a string, an instance of sap.uxap.ObjectPageSection or null");return this;}if(I===this.getSelectedSection()){return this;}if(I===null){this.setAssociation("selectedSection",null,true);this._expandHeader(this._bHeaderInTitleArea);this._requestAdjustLayoutAndUxRules(true);return this;}this.scrollToSection(I);v=a._getClosestSection(I);s=(v instanceof a)?v.getId():v;return this.setAssociation("selectedSection",s,true);};
m.prototype._ensureCorrectParentHeight=function(){if(this._bCorrectParentHeightIsSet){return;}if(this.getParent().getHeight&&["","auto"].indexOf(this.getParent().getHeight())!==-1){this.$().parent().css("height","100%");}this._bCorrectParentHeightIsSet=true;};
m.prototype._cacheDomElements=function(){this._$headerTitle=q(document.getElementById(this.getId()+"-headerTitle"));this._$anchorBar=q(document.getElementById(this.getId()+"-anchorBar"));this._$stickyAnchorBar=q(document.getElementById(this.getId()+"-stickyAnchorBar"));this._$opWrapper=q(document.getElementById(this.getId()+"-opwrapper"));this._$spacer=q(document.getElementById(this.getId()+"-spacer"));this._$headerContent=q(document.getElementById(this.getId()+"-headerContent"));this._$stickyHeaderContent=q(document.getElementById(this.getId()+"-stickyHeaderContent"));this._$contentContainer=q(document.getElementById(this.getId()+"-scroll"));this._$sectionsContainer=q(document.getElementById(this.getId()+"-sectionsContainer"));this._oScroller._$Container=this._$opWrapper;this._bDomElementsCached=true;};
m.prototype._handleExpandButtonPress=function(E){if(this._bStickyAnchorBar){this._moveHeaderToTitleArea();this._toggleHeaderTitle(true);}};
m.prototype._toggleHeaderTitle=function(E,u){var H=this.getHeaderTitle();this._$headerTitle.toggleClass("sapUxAPObjectPageHeaderStickied",!E);if(E){H&&H.unSnap(u);}else{H&&H.snap(u);}};
m.prototype._moveHeaderToTitleArea=function(){this._$headerContent.children().appendTo(this._$stickyHeaderContent);this._bHeaderInTitleArea=true;this._bSupressModifyOnScrollOnce=true;};
m.prototype._moveHeaderToContentArea=function(){if(this._bHeaderInTitleArea){this._$headerContent.append(this._$stickyHeaderContent.children());this._$stickyHeaderContent.children().remove();this._bHeaderInTitleArea=false;}};
m.prototype._updateNavigation=function(){if(this.getShowAnchorBar()){this._oABHelper._buildAnchorBar();}};
m.prototype._applyUxRules=function(I){var s,o,v,V,p,r,t,F,u,w,x,y;s=this.getSections()||[];V=0;r=this.getShowAnchorBar();t=this.getUseIconTabBar();F=null;this._cleanMemory();s.forEach(function(z){if(!z.getVisible()){return true;}this._registerSectionBaseInfo(z);o=z.getSubSections()||[];v=0;u=null;o.forEach(function(B){if(!B.getVisible()){return true;}this._registerSectionBaseInfo(B);p=B.getVisibleBlocksCount();if(p===0){B._setInternalVisible(false,I);g.info("ObjectPageLayout :: noVisibleBlock UX rule matched","subSection "+B.getTitle()+" forced to hidden");}else{B._setInternalVisible(true,I);B._setInternalTitleVisible(true,I);v++;if(!u){u=B;}if(this._shouldApplySectionTitleLevel(B)){B._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(B));}}},this);if(v==0){z._setInternalVisible(false,I);g.info("ObjectPageLayout :: noVisibleSubSection UX rule matched","section "+z.getTitle()+" forced to hidden");}else{z._setInternalVisible(true,I);z._setInternalTitleVisible(true,I);if(!F){F=z;y=v;}if(this.getSubSectionLayout()===k.TitleOnTop&&v===1&&u.getTitle().trim()!==""){g.info("ObjectPageLayout :: TitleOnTop.sectionGetSingleSubSectionTitle UX rule matched","section "+z.getTitle()+" is taking its single subsection title "+u.getTitle());z._setInternalTitle(u.getTitle(),I);u._setInternalTitleVisible(false,I);u._setBorrowedTitleDomId(z.getId()+"-title");}else{z._setInternalTitle("",I);}if(v===1&&!u.getTitle().trim()){u._setBorrowedTitleDomId(z.getId()+"-title");}if(this._shouldApplySectionTitleLevel(z)){z._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(z));}V++;}if(t){z._setInternalTitleVisible(false,I);}},this);if(V<=1){r=false;g.info("ObjectPageLayout :: notEnoughVisibleSection UX rule matched","anchorBar forced to hidden");}else if(F&&r){w=true;F._setInternalTitleVisible(false,I);g.info("ObjectPageLayout :: firstSectionTitleHidden UX rule matched","section "+F.getTitle()+" title forced to hidden");}if(r){this._oABHelper._buildAnchorBar();}this._setInternalAnchorBarVisible(r,I);this._oFirstVisibleSection=F;this._oFirstVisibleSubSection=this._getFirstVisibleSubSection(F);if(w&&(y===1)){x=this.getAggregation("_anchorBar").getContent();if(x.length){this._oFirstVisibleSubSection._setBorrowedTitleDomId(x[0].getId()+"-content");}}};
m.prototype.setUseIconTabBar=function(v){var o=this.getUseIconTabBar();if(v!=o){this._applyUxRules();}this.setProperty("useIconTabBar",v);return this;};
m.prototype._setCurrentTabSection=function(s,I){if(!s){return;}var o;if(s instanceof sap.uxap.ObjectPageSubSection){o=s;s=s.getParent();}else{o=this._getFirstVisibleSubSection(s);}if(this._oCurrentTabSection!==s){this._renderSection(s);this._oCurrentTabSection=s;}this._oCurrentTabSubSection=o;};
m.prototype._renderSection=function(s){var $=this.$().find(".sapUxAPObjectPageContainer"),r;if(s&&$.length){r=this.oCore.createRenderManager();this.getSections().forEach(function(o){if((o.getId()===s.getId())){r.renderControl(s);}else{r.cleanupControlWithoutRendering(o);}});r.flush($[0]);r.destroy();}};
m.prototype.setShowAnchorBarPopover=function(v,s){var o=this.getProperty("showAnchorBarPopover"),v=this.validateProperty("showAnchorBarPopover",v),p=this.getSelectedSection();if(v===o){return;}this._oABHelper._getAnchorBar().setShowPopover(v);this._oABHelper._buildAnchorBar();this._setSelectedSectionId(p);return this.setProperty("showAnchorBarPopover",v,true);};
m.prototype._getInternalAnchorBarVisible=function(){return this._bInternalAnchorBarVisible;};
m.prototype._setInternalAnchorBarVisible=function(v,I){if(v!=this._bInternalAnchorBarVisible){this._bInternalAnchorBarVisible=v;if(I===true){this.invalidate();}}};
m.prototype.setUpperCaseAnchorBar=function(v){this._oABHelper._getAnchorBar().setProperty("upperCase",v);return this.setProperty("upperCaseAnchorBar",v,true);};
m.prototype._requestAdjustLayout=function(I){if(!this._oLayoutTask){this._oLayoutTask=new T(this._updateScreenHeightSectionBasesAndSpacer,m.DOM_CALC_DELAY,this);}if(!I){g.debug("ObjectPageLayout :: _requestAdjustLayout","delayed by "+m.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oLayoutTask.reSchedule(I,{}).catch(function(r){});};
m.prototype._requestAdjustLayoutAndUxRules=function(I){this._setSectionInfoIsDirty(true);if(!this._oUxRulesTask){this._oUxRulesTask=new T(this._adjustLayoutAndUxRules,m.DOM_CALC_DELAY,this);}if(!I){g.debug("ObjectPageLayout :: _requestAdjustLayoutAndUxRules","delayed by "+m.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oUxRulesTask.reSchedule(I,{}).catch(function(r){});};
m.prototype._adjustLayoutAndUxRules=function(){var s,o;g.debug("ObjectPageLayout :: _requestAdjustLayout","refreshing ux rules");this._applyUxRules(true);this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();o=this.oCore.byId(s);if(o){this._setSelectedSectionId(s);if(this.getUseIconTabBar()){this._setCurrentTabSection(o);}this._requestAdjustLayout(true).then(function(p){if(p){this._oLazyLoading.doLazyLoading();}this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();if(!this._isClosestScrolledSection(s)||this._oScroller._$Container.is(":animated")){this.scrollToSection(s,null,0,false,true);}}.bind(this));}};
m.prototype._isClosestScrolledSection=function(s){var o=this._$opWrapper.length>0?this._$opWrapper.scrollTop():0,p=this.iScreenHeight,r=this._getClosestScrolledSectionId(o,p);return r&&(s===r);};
m.prototype._setSelectedSectionId=function(s){var o=this.getAggregation("_anchorBar"),p=s&&this._oSectionInfo[s];if(!p){return;}if(o&&p.buttonId){o.setSelectedButton(p.buttonId);this.setAssociation("selectedSection",s,true);}};
m.prototype.isFirstRendering=function(){return this._bFirstRendering;};
m.prototype._cleanMemory=function(){var o=this.getAggregation("_anchorBar");if(o){o._resetControl();}this._oSectionInfo={};this._aSectionBases=[];};
m.prototype._registerSectionBaseInfo=function(s){this._oSectionInfo[s.getId()]={$dom:[],positionTop:0,positionTopMobile:0,buttonId:"",isSection:(s instanceof a),sectionReference:s};this._aSectionBases.push(s);};
m.prototype._triggerVisibleSubSectionsEvents=function(){this._bDelayDOMBasedCalculations=false;if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading._triggerVisibleSubSectionsEvents();}};
m.prototype.scrollToSection=function(I,o,p,r,s){var t=this.oCore.byId(I);if(!this.getDomRef()){g.warning("scrollToSection can only be used after the ObjectPage is rendered",this);return;}if(!t){g.warning("scrollToSection aborted: unknown section",I,this);return;}if(!this._oSectionInfo[I]){g.warning("scrollToSection aborted: section is hidden by UX rules",I,this);return;}if(this.bIsDestroyed){g.debug("ObjectPageLayout :: scrollToSection","scrolling canceled as page is being destroyed");return;}if(this.getUseIconTabBar()){var u=a._getClosestSection(t);if(this._oCurrentTabSection){this._oCurrentTabSection._allowPropagationToLoadedViews(false);}u._allowPropagationToLoadedViews(true);this._setCurrentTabSection(t);this.getAggregation("_anchorBar").setSelectedButton(this._oSectionInfo[u.getId()].buttonId);this.setAssociation("selectedSection",u.getId(),true);}if(r){this.fireNavigate({section:a._getClosestSection(t),subSection:t instanceof b?t:t.getSubSections()[0]});}if(this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();}p=p||0;t._expandSection();this._requestAdjustLayout(true);o=this._computeScrollDuration(o,t);var v=this._computeScrollPosition(t);if(this._sCurrentScrollId!=I||s){this._sCurrentScrollId=I;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);if(this._$contentContainer){this._$contentContainer.parent().stop(true,false);}}if(this._bDomElementsCached){this._iCurrentScrollTimeout=setTimeout(function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;}.bind(this),o);}this._preloadSectionsOnScroll(t);this.getHeaderTitle()&&this._shiftHeaderTitle();this._scrollTo(v+p,o);}};
m.prototype._computeScrollDuration=function(o,t){var p=parseInt(o,10);p=p>=0?p:this._iScrollToSectionDuration;if(this.getUseIconTabBar()&&((t instanceof a)||this._isFirstVisibleSectionBase(t))&&this._bStickyAnchorBar){p=0;}return p;};
m.prototype._computeScrollPosition=function(t){var F=t&&(t instanceof a),I=t.getId(),s=this._bMobileScenario||F?this._oSectionInfo[I].positionTopMobile:this._oSectionInfo[I].positionTop,E=!this._bStickyAnchorBar;if(E&&this._isFirstVisibleSectionBase(t)){s=0;}return s;};
m.prototype._preloadSectionsOnScroll=function(t){var I=t.getId(),o;if(!this.getEnableLazyLoading()&&this.getUseIconTabBar()){o=(t instanceof a)?t:t.getParent();this._connectModelsForSections([o]);}if(this.getEnableLazyLoading()){var s=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;o=this._oLazyLoading.getSubsectionsToPreload(s,I);if(D.system.desktop){setTimeout(function(){this._connectModelsForSections(o);}.bind(this),50);}else{this._connectModelsForSections(o);}o.forEach(function(p){this.fireEvent("subSectionEnteredViewPort",{subSection:p});},this);}};
m.prototype.getScrollingSectionId=function(){return this._sScrolledSectionId;};
m.prototype.setDirectScrollingToSection=function(s){this.sDirectSectionId=s;};
m.prototype.getDirectScrollingToSection=function(){return this.sDirectSectionId;};
m.prototype.clearDirectScrollingToSection=function(){this.sDirectSectionId=null;};
m.prototype._scrollTo=function(y,t){if(this._oScroller&&this._bDomReady&&!this._bSuppressScroll){g.debug("ObjectPageLayout :: scrolling to "+y);if((t===0)&&this._shouldSnapHeaderOnScroll(y)){this._toggleHeader(true);}this._oScroller.scrollTo(0,y,t);}return this;};
m.prototype._scrollBelowCollapseVisualIndicator=function(){var H=this._getHeaderContent(),$,o,v,p;if(!n(H)||!n(this._$opWrapper)){return;}$=H._getCollapseButton().getDomRef();o=$.getBoundingClientRect().height;v=this._$opWrapper[0].getBoundingClientRect().height;p=$.offsetTop+o-v;this._scrollTo(p);};
m.prototype._updateMedia=function(w){var u=function(s){Object.keys(m.DYNAMIC_HEADERS_MEDIA).forEach(function(p){var r=m.DYNAMIC_HEADERS_MEDIA[p],E=s===r;this.toggleStyleClass(r,E);},this);}.bind(this),o=m.DYNAMIC_HEADERS_MEDIA,B=m.BREAK_POINTS;if(w<=B.PHONE){u(o.PHONE);}else if(w<=B.TABLET){u(o.TABLET);}else{u(o.DESKTOP);}};
m.prototype._updateScreenHeightSectionBasesAndSpacer=function(){var o,p,s,P,r,t,u=!this._bHeaderExpanded,v=this.getDomRef();if(!v||!this._bDomReady){return false;}g.debug("ObjectPageLayout :: _updateScreenHeightSectionBasesAndSpacer","re-evaluating dom positions");this.iScreenHeight=this._getDOMRefHeight(v);if(this.iScreenHeight===0){return;}var w=0;this._aSectionBases.forEach(function(x){var I=this._oSectionInfo[x.getId()],$=x.$(),y,z=false;if(!I||!$.length){return;}if(!I.isSection){w++;}I.$dom=$;var B=$.position().top;I.positionTop=Math.ceil(B);if(I.isSection){y=x.$("header");}else{y=x.$("headerTitle");}z=y.length===0;if(!z){I.positionTopMobile=Math.ceil(y.position().top)+y.outerHeight();}else{I.positionTopMobile=I.positionTop;}if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea){I.positionTopMobile-=this.iAnchorBarHeight;I.positionTop-=this.iAnchorBarHeight;}I.sectionReference.toggleStyleClass("sapUxAPObjectPageSubSectionPromoted",z);if(this._bMobileScenario){var E=this.oCore.byId(x.getId()).getParent();if(E instanceof a&&E._getIsHidden()){return;}if(r){this._oSectionInfo[r].positionBottom=I.positionTop;}r=x.getId();p=x;}else{if(I.isSection){if(r){this._oSectionInfo[r].positionBottom=I.positionTop;if(P){this._oSectionInfo[P].positionBottom=I.positionTop;}}r=x.getId();P=null;}else{if(P){this._oSectionInfo[P].positionBottom=I.positionTop;}P=x.getId();p=x;}}},this);if(p){o=this._computeLastVisibleHeight(p);if(this._bMobileScenario&&r){this._oSectionInfo[r].positionBottom=this._oSectionInfo[r].positionTop+o;}else{if(P){this._oSectionInfo[P].positionBottom=this._oSectionInfo[P].positionTop+o;}if(r&&P){this._oSectionInfo[r].positionBottom=this._oSectionInfo[P].positionTop+o;}}t=this._bStickyAnchorBar||(w>1)||this._checkContentBottomRequiresSnap(p);if(t&&!this._shouldPreserveHeaderInTitleArea()){u=true;}s=this._computeSpacerHeight(p,o,t,u);this._$spacer.height(s+"px");g.debug("ObjectPageLayout :: bottom spacer is now "+s+"px");}this._updateCustomScrollerHeight(u);this._setSectionInfoIsDirty(false);return true;};
m.prototype._updateCustomScrollerHeight=function(r){if(D.system.desktop&&this.getAggregation("_customScrollBar")){var s=this._computeScrollableContentSize(r);s+=this._getStickyAreaHeight(r);this._getCustomScrollBar().setContentSize(s+"px");var o=(s>Math.ceil(this.iScreenHeight)),v=(o!==this._getCustomScrollBar().getVisible());if(v){this._getCustomScrollBar().setVisible(o);this.getHeaderTitle()&&this._shiftHeaderTitle();}}};
m.prototype._computeScrollableContentSize=function(s){var o=0;if(this._$contentContainer&&this._$contentContainer.length){o=this._$contentContainer[0].scrollHeight;}if(!this._bStickyAnchorBar&&s){o-=this.iAnchorBarHeight;}if(this._bStickyAnchorBar&&!s){o+=this.iAnchorBarHeight;}return o;};
m.prototype._computeLastVisibleHeight=function(o){var I=this._bStickyAnchorBar||this._bHeaderInTitleArea;var p=this._getSectionPositionTop(o,I);return this._$spacer.position().top-p;};
m.prototype._getStickyAreaHeight=function(I){if(I){return this.iHeaderTitleHeightStickied+this.iAnchorBarHeight;}return this.iHeaderTitleHeight;};
m.prototype._getScrollableViewportHeight=function(I){return this.getDomRef().getBoundingClientRect().height-this._getStickyAreaHeight(I);};
m.prototype._getSectionPositionTop=function(s,o){var p=s.$().position().top;if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea&&o){p-=this.iAnchorBarHeight;}return p;};
m.prototype._getSectionPositionBottom=function(s,o){var p=this._oSectionInfo[s.getId()].positionBottom;if(!o){p+=this.iAnchorBarHeight;}return p;};
m.prototype._determineSectionBaseInternalTitleLevel=function(s){var o=this.getSectionTitleLevel(),I=s instanceof a;if(o===j.Auto){return I?j.H3:j.H4;}return I?o:m._getNextTitleLevelEntry(o);};
m.prototype._shouldApplySectionTitleLevel=function(s){return s.getTitleLevel()===j.Auto;};
m.prototype._checkContentBottomRequiresSnap=function(s){var o=false;return this._getSectionPositionBottom(s,o)>=(this._getScrollableViewportHeight(o)+this._getSnapPosition());};
m.prototype._computeSpacerHeight=function(o,p,r,s){var t,u,F;if(this.getFooter()&&this.getShowFooter()){F=this.$("footerWrapper").outerHeight();}u=this._getScrollableViewportHeight(s);if(!r){p=this._getSectionPositionBottom(o,false);}if(p<u){t=u-p;if(this._bMobileScenario){t+=(this._oSectionInfo[o.getId()].positionTopMobile-this._oSectionInfo[o.getId()].positionTop);}}else{t=0;}if(F>t){t+=F;}return t;};
m.prototype._isFirstVisibleSectionBase=function(s){var o,p,F,r=this.getSelectedSection(),u=this.getUseIconTabBar();if(!s||!s.getParent()){return;}o=s.getId();if(u&&(o===r)){return true;}if(u&&(s.getParent().getId()===r)){p=sap.ui.getCore().byId(r);F=this._getFirstVisibleSubSection(p);return F&&(F.getId()===o);}if(this._oFirstVisibleSection&&this._oFirstVisibleSubSection){return o===this._oFirstVisibleSection.getId()||o===this._oFirstVisibleSubSection.getId();}return false;};
m.prototype._getFirstVisibleSubSection=function(s){if(!s){return;}var F;this._aSectionBases.every(function(o){if(o.getParent()&&(o.getParent().getId()===s.getId())){F=o;return false;}return true;});return F;};
m.prototype._initAnchorBarScroll=function(){var s=this.oCore.byId(this.getSelectedSection()),o;this._requestAdjustLayout(true);o=s?this._computeScrollPosition(s):0;this._sScrolledSectionId="";this._sCurrentScrollId="";this._onScroll({target:{scrollTop:o}},true);};
m.prototype._setAsCurrentSection=function(s){var o,p,r;if(this._sScrolledSectionId===s){return;}g.debug("ObjectPageLayout :: current section is "+s);this._sScrolledSectionId=s;o=this.getAggregation("_anchorBar");if(o&&this._getInternalAnchorBarVisible()){p=this.oCore.byId(s);r=p&&p instanceof b&&(p.getTitle().trim()===""||!p._getInternalTitleVisible()||p.getParent()._getIsHidden());if(r){s=p.getParent().getId();g.debug("ObjectPageLayout :: current section is a subSection with an empty or hidden title, selecting parent "+s);}if(p&&this._oSectionInfo[s]){o.setSelectedButton(this._oSectionInfo[s].buttonId);this.setAssociation("selectedSection",a._getClosestSection(s).getId(),true);this._setSectionsFocusValues(s);}}};
m.prototype._registerOnContentResize=function(){var $=this._$contentContainer.length&&this._$contentContainer[0];if(!$){return;}if(this._iContentResizeId){R.deregister(this._iContentResizeId);}this._iContentResizeId=R.register($,this._onUpdateContentSize.bind(this));};
m.prototype._onUpdateContentSize=function(E){var s;if(this._preserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}if(this._hasDynamicTitle()){this._adjustHeaderHeights();}this._requestAdjustLayout().then(function(){s=this._$opWrapper.scrollTop();this._updateSelectionOnScroll(s);}.bind(this));};
m.prototype._onUpdateScreenSize=function(E){var t=this.getHeaderTitle(),H=this._getHeaderContent(),o=E.size.width,p=E.size.height,r=E.oldSize.height,s=(p!==r),u,I=H&&H.supportsAlwaysExpanded()&&this.getAlwaysShowContentHeader();if(E.size.height===0||E.size.width===0){g.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(!this._bDomReady){g.info("ObjectPageLayout :: cannot _onUpdateScreenSize before dom is ready");return;}this._oLazyLoading.setLazyLoadingParameters();setTimeout(function(){this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(I&&(this._bHeaderInTitleArea!=this._checkAlwaysShowContentHeader())){this.invalidate();}if(this._bHeaderInTitleArea&&this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._expandHeader(false);this._scrollTo(0,0);}if(t&&t.isDynamic()){t._onResize(o);this._updateMedia(o);}this._adjustHeaderHeights();this._requestAdjustLayout(true);if(this.getFooter()&&this.getShowFooter()){this._shiftFooter();}u=this.getSelectedSection();if((r===0)&&s&&!this._isClosestScrolledSection(u)){this.scrollToSection(u,0);}this._scrollTo(this._$opWrapper.scrollTop(),0);if((r===0)&&s&&this.getEnableLazyLoading()&&this._oLazyLoading&&!this._bDelayDOMBasedCalculations){this._oLazyLoading.doLazyLoading();}}.bind(this),this._getDOMCalculationDelay());};
m.prototype._onUpdateHeaderTitleSize=function(E){if(E.size.height===0||E.size.width===0){g.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(!this._bDomReady){g.info("ObjectPageLayout :: cannot _onUpdateTitleSize before dom is ready");return;}this._adjustHeaderHeights();this._requestAdjustLayout();};
m.prototype._shouldSnapHeaderOnScroll=function(s){return(s>0)&&(s>=this._getSnapPosition())&&!this._shouldPreserveHeaderInTitleArea();};
m.prototype._getScrollableContentLength=function(){return this._$contentContainer.length?this._getDOMRefHeight(this._$contentContainer[0]):0;};
m.prototype._isContentScrolledToBottom=function(){return this._oLastScrollState.iScrollableContentLength<=(this._oLastScrollState.iScrollTop+this._oLastScrollState.iScrollableViewportHeight);};
m.prototype._isContentLengthDecreased=function(p){if(p){return((p.iScrollableContentLength>this._oLastScrollState.iScrollableContentLength)&&(p.iSpacerHeight===this._oLastScrollState.iSpacerHeight));}};
m.prototype._canReachScrollTop=function(r,E){var o;E=E||0;o=this._oLastScrollState.iScrollableContentLength+E-this._oLastScrollState.iScrollableViewportHeight;return o>=r;};
m.prototype._onScroll=function(E,I){var s=Math.max(Math.ceil(E.target.scrollTop),0),$=this._$opWrapper.length&&this._$opWrapper[0],o=this._$spacer.length&&this._$spacer[0],p=o.offsetHeight,P,H=this.getHeaderTitle(),r=this._shouldSnapHeaderOnScroll(s),t=this._shouldPreserveHeaderInTitleArea(),u=false,v=this._oLastScrollState,w=v?(v.iScrollTop-s):0;this._oLastScrollState={iScrollTop:s,iScrollableContentLength:this._getScrollableContentLength(),iScrollableViewportHeight:$.offsetHeight,iSpacerHeight:p};if(this._bSupressModifyOnScrollOnce){this._bSupressModifyOnScrollOnce=false;return;}if(!$||!o){return;}P=this.iScreenHeight;if(P===0){return;}if(this._getSectionInfoIsDirty()){return;}if(v&&this._isContentScrolledToBottom()&&this._isContentLengthDecreased(v)){var x=v.iScrollableContentLength-this._oLastScrollState.iScrollableContentLength;if(!this._canReachScrollTop(v.iScrollTop)&&this._canReachScrollTop(v.iScrollTop,x)){var N=p+x;this._$spacer.height(N+"px");this._scrollTo($.scrollTop+w);return;}}if(r&&!t){P-=(this.iAnchorBarHeight+this.iHeaderTitleHeightStickied);}if(this._bHeaderInTitleArea&&!t){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._requestAdjustLayout();}if(!t&&((H&&this.getShowHeaderContent())||this.getShowAnchorBar())){this._toggleHeader(r,!!(E&&E.type==="scroll"));}if(!t){this._adjustHeaderTitleBackgroundPosition(s);}g.debug("ObjectPageLayout :: lazy loading : Scrolling at "+s,"----------------------------------------");this._updateSelectionOnScroll(s);if(this.getEnableLazyLoading()){this._oLazyLoading.lazyLoadDuringScroll(I,s,E.timeStamp,P);}if(H&&H.supportsTitleInHeaderContent()&&this.getShowHeaderContent()&&this.getShowTitleInHeaderContent()&&H.getShowTitleSelector()){if(s===0){q(document.getElementById(this.getId()+"-scroll")).css("z-index","1000");u=false;}else if(!u){u=true;q(document.getElementById(this.getId()+"-scroll")).css("z-index","0");}}};
m.prototype._updateSelectionOnScroll=function(s){var p=this.iScreenHeight,o,r;if(p===0){return;}o=this._getClosestScrolledSectionId(s,p);r=this._getClosestScrolledSectionId(s,p,true);if(o){var t=this.getDirectScrollingToSection();if(o!==this._sScrolledSectionId){g.debug("ObjectPageLayout :: closest id "+o,"----------------------------------------");var t=this.getDirectScrollingToSection();if(t&&t!==o){return;}this.clearDirectScrollingToSection();this._setAsCurrentSection(o);}else if(o===this.getDirectScrollingToSection()){this.clearDirectScrollingToSection();}if(r!==this._sScrolledSubSectionId){this._sScrolledSubSectionId=r;this.fireEvent("_sectionChange",{section:this.oCore.byId(o),subSection:this.oCore.byId(r)});}}};
m.prototype._getSnapPosition=function(){var s=this.iHeaderContentHeight,t=this.iHeaderTitleHeightStickied-this.iHeaderTitleHeight;if(t<m.MAX_SNAP_POSITION_OFFSET){s-=t;}return s;};
m.prototype._getClosestScrolledSectionId=function(s,p,o){o=!!o;s=Math.ceil(s);if(this.getUseIconTabBar()&&this._oCurrentTabSection){return this._oCurrentTabSection.getId();}var r=s+p,t,u=o||this._bMobileScenario;q.each(this._oSectionInfo,function(I,v){var w,x,y,z;w=this.oCore.byId(I);if(!w){return;}x=w.getParent();y=x instanceof a&&x._getIsHidden();if(v.isSection||(u&&!y)){if(!t&&(v.sectionReference._getInternalVisible()===true)){z=this._getFirstVisibleSubSection(v.sectionReference);if(v.isSection&&o&&z){t=z.getId();}else{t=I;}}if(v.isSection&&o){return true;}if(v.positionTop<=r&&s<=v.positionBottom){if(v.positionTop<=s&&v.positionBottom>s){t=I;return false;}}}}.bind(this));return t;};
m.prototype._toggleHeader=function(s,u){var H=this.getHeaderTitle();if(!this._shouldPreserveHeaderInTitleArea()&&!this._bHeaderInTitleArea){this._toggleHeaderTitle(!s,u);}if(!this._bStickyAnchorBar&&s){this._restoreFocusAfter(this._moveAnchorBarToTitleArea);H&&H.snap();this._bHeaderExpanded=false;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();}else if(this._bStickyAnchorBar&&!s){this._restoreFocusAfter(this._moveAnchorBarToContentArea);H&&H.unSnap();this._bHeaderExpanded=true;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();if(n(this._$stickyAnchorBar)){this._$stickyAnchorBar.removeClass("sapUxAPObjectPageStickyAnchorBarPaddingTop");}}};
m.prototype._restoreFocusAfter=function(o){var p=this.oCore.byId(this.oCore.getCurrentFocusedControlId());o.call(this);if(D.system.phone!==true){if(!this.oCore.byId(this.oCore.getCurrentFocusedControlId())){p&&p.$().focus();}}return this;};
m.prototype._moveAnchorBarToTitleArea=function(){this._$anchorBar.children().appendTo(this._$stickyAnchorBar);this._toggleHeaderStyleRules(true);if(this.iHeaderTitleHeight!=this.iHeaderTitleHeightStickied){this._adjustHeaderBackgroundSize();}return this;};
m.prototype._moveAnchorBarToContentArea=function(){if(!this._shouldPreserveHeaderInTitleArea()){this._$anchorBar.css("height","auto").append(this._$stickyAnchorBar.children());this._toggleHeaderStyleRules(false);}return this;};
m.prototype._toggleHeaderStyleRules=function(s){s=!!s;var v=s?"hidden":"inherit";this._bStickyAnchorBar=s;this._$headerContent.css("overflow",v);this._$headerContent.toggleClass("sapContrastPlus",!s);this._$headerContent.toggleClass("sapUxAPObjectPageHeaderDetailsHidden",s);this._$anchorBar.css("visibility",v);this._$anchorBar.toggleClass("sapUxAPObjectPageNavigationHidden",s);this.fireToggleAnchorBar({fixed:s});};
m.prototype.getScrollDelegate=function(){return this._oScroller;};
m.prototype.setHeaderTitle=function(H,s){if(H&&typeof H.addEventDelegate==="function"){H.addEventDelegate({onAfterRendering:this._adjustHeaderHeights.bind(this)});}this.setAggregation("headerTitle",H,s);this._oObserver&&this._oObserver.disconnect();this._oObserver=new M(this._onModifyHeaderTitle.bind(this));this._oObserver.observe(H,{aggregations:["headerTitle"],properties:["backgroundDesign"]});if(H){this._createHeaderContent();}return this;};
m.prototype._onModifyHeaderTitle=function(p){var H=this.getAggregation("_headerContent");H&&p.current&&H.setBackgroundDesign(p.current);};
m.prototype.invalidate=function(o){if(this.getUseIconTabBar()&&o&&(o instanceof a)&&!o.isActive()){return;}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}C.prototype.invalidate.apply(this,arguments);};
m.prototype._createHeaderContent=function(){var H=this.getHeaderTitle(),s=H&&H.supportsBackgroundDesign()&&H.getBackgroundDesign(),o=this.getAggregation("_headerContent"),N;var p=H?H.getCompatibleHeaderContentClass():c;if(!(o instanceof p)){var N=p.createInstance(this.getAggregation("headerContent"),this.getShowHeaderContent(),this._getHeaderDesign(),this.getHeaderContentPinnable());s&&N.setBackgroundDesign(s);this.setAggregation("_headerContent",N,true);}};
m.prototype._adjustHeaderBackgroundSize=function(){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(!this._shouldPreserveHeaderInTitleArea()){this.iTotalHeaderSize=this.iHeaderTitleHeight+this.iHeaderContentHeight;this._$headerContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}else{this.iTotalHeaderSize=this.iHeaderTitleHeight-this._$stickyAnchorBar.height();this._$stickyHeaderContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}H.$().css("background-size","100% "+this.iTotalHeaderSize+"px");this._adjustHeaderTitleBackgroundPosition(0);}};
m.prototype._adjustHeaderTitleBackgroundPosition=function(s){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(this._bStickyAnchorBar){H.$().css("background-position","0px "+((this.iTotalHeaderSize-this.iHeaderTitleHeightStickied)*-1)+"px");}else{if(this._shouldPreserveHeaderInTitleArea()){H.$().css("background-position","0px 0px");}else{H.$().css("background-position","0px "+(this.iHeaderTitleHeight+this.iHeaderContentHeight-this.iTotalHeaderSize-s)+"px");}}}};
m.prototype._adjustHeaderHeights=function(){var t=this.getHeaderTitle(),p=true;if(t&&!t.supportsAdaptLayoutForDomElement()){p=false;}if(this._$headerTitle.length>0){this.iHeaderContentHeight=this._$headerContent.length?Math.ceil(this._getDOMRefHeight(this._$headerContent[0])):0;this.iStickyHeaderContentHeight=this._$stickyHeaderContent.height();this.iAnchorBarHeight=this._bStickyAnchorBar?this._$stickyAnchorBar.height():this._$anchorBar.height();if(!this._bHeaderExpanded){this.iHeaderTitleHeightStickied=this._$headerTitle.height()-this.iAnchorBarHeight;this.iHeaderTitleHeight=this._obtainExpandedTitleHeight(p);}else{this.iHeaderTitleHeight=this._$headerTitle.is(":visible")?this._$headerTitle.height():0;this.iHeaderTitleHeightStickied=this._obtainSnappedTitleHeight(p);}this._adjustHeaderBackgroundSize();g.info("ObjectPageLayout :: adjustHeaderHeight","headerTitleHeight: "+this.iHeaderTitleHeight+" - headerTitleStickiedHeight: "+this.iHeaderTitleHeightStickied+" - headerContentHeight: "+this.iHeaderContentHeight);}else{g.debug("ObjectPageLayout :: adjustHeaderHeight","skipped as the objectPageLayout is being rendered");}};
m.prototype._appendTitleCloneToDOM=function(E){var $=this._$headerTitle.clone();$.css({left:"-10000px",top:"-10000px",width:this._$headerTitle.width()+"px"});$.toggleClass("sapUxAPObjectPageHeaderStickied",E);$.appendTo(this._$headerTitle.parent());if(E){this.getHeaderTitle()&&this.getHeaderTitle()._adaptLayoutForDomElement($);}return $;};
m.prototype._obtainSnappedTitleHeight=function(v){var t=this.getHeaderTitle(),$,H;if(v){this._$opWrapper.css("overflow-y","hidden");$=this._appendTitleCloneToDOM(true);H=$.height();$.remove();this._$opWrapper.css("overflow-y","auto");}else if(t&&t.snap){t.snap(false);H=t.$().outerHeight();t.unSnap(false);}return H;};
m.prototype._obtainExpandedTitleHeight=function(v){var t=this.getHeaderTitle(),$,H;if(v){this._$opWrapper.css("overflow-y","hidden");$=this._appendTitleCloneToDOM(false);H=$.is(":visible")?$.height()-this.iAnchorBarHeight:0;$.remove();this._$opWrapper.css("overflow-y","auto");}else if(t&&t.unSnap){t.unSnap(false);H=t.$().outerHeight();t.snap(false);}return H;};
m.prototype._getHeaderDesign=function(){var H=this.getHeaderTitle(),s=l.ObjectPageHeaderDesign.Light;if(H!=null){s=H.getHeaderDesign();}return s;};
m.prototype._getVisibleSections=function(){return this.getSections().filter(function(s){return s.getVisible()&&s._getInternalVisible();});};
m.prototype._setSectionsFocusValues=function(s){var o=this._getVisibleSections()||[],$,F='0',N='-1',t="tabIndex",p,r=o[0];o.forEach(function(u){$=u.$();if(s===u.sId){$.attr(t,F);p=u;u._setSubSectionsFocusValues();}else{$.attr(t,N);u._disableSubSectionsFocus();}});if(!p&&o.length>0){r.$().attr(t,F);r._setSubSectionsFocusValues();p=r;}return p;};
m.prototype.setShowHeaderContent=function(s){var o=this.getShowHeaderContent(),H;if(o!==s){if(o&&this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);}this.setProperty("showHeaderContent",s);H=this._getHeaderContent();if(H){H.setProperty("visible",s);}}return this;};
m.prototype._headerTitleChangeHandler=function(I){var r;if(!this.getShowTitleInHeaderContent()){return;}if(I){this._getHeaderContent()._destroyObjectImage(true);}r=this.oCore.createRenderManager();this.getRenderer()._rerenderHeaderContentArea(r,this);this._getHeaderContent().invalidate();r.destroy();};
m.prototype.getHeaderContent=function(){if(!this._getHeaderContent()){return this.getAggregation("headerContent",[]);}return this._getHeaderContent().getAggregation("content",[]);};
m.prototype.insertHeaderContent=function(o,I,s){if(!this._getHeaderContent()){return this.insertAggregation("headerContent",o,I,s);}return this._getHeaderContent().insertAggregation("content",o,I,s);};
m.prototype.addHeaderContent=function(o,s){if(!this._getHeaderContent()){return this.addAggregation("headerContent",o,s);}return this._getHeaderContent().addAggregation("content",o,s);};
m.prototype.removeAllHeaderContent=function(s){if(!this._getHeaderContent()){return this.removeAllAggregation("headerContent",s);}return this._getHeaderContent().removeAllAggregation("content",s);};
m.prototype.removeHeaderContent=function(o,s){if(!this._getHeaderContent()){return this.removeAggregation("headerContent",o,s);}return this._getHeaderContent().removeAggregation("content",o,s);};
m.prototype.destroyHeaderContent=function(s){if(!this._getHeaderContent()){return this.destroyAggregation("headerContent",s);}return this._getHeaderContent().destroyAggregation("content",s);};
m.prototype.indexOfHeaderContent=function(o){if(!this._getHeaderContent()){return this.indexOfAggregation("headerContent",o);}return this._getHeaderContent().indexOfAggregation("content",o);};
m.prototype._getHeaderContent=function(){return this.getAggregation("_headerContent");};
m.prototype._connectModelsForSections=function(s){s=s||[];s.forEach(function(o){o.connectToModels();});};
m.prototype._getHeightRelatedParameters=function(){return{iHeaderContentHeight:this.iHeaderContentHeight,iScreenHeight:this.iScreenHeight,iAnchorBarHeight:this.iAnchorBarHeight,iHeaderTitleHeightStickied:this.iHeaderTitleHeightStickied,iStickyHeaderContentHeight:this.iStickyHeaderContentHeight,iScrollTop:this._$opWrapper.scrollTop()};};
m.prototype._hasVerticalScrollBar=function(){return(this._getCustomScrollBar().getVisible()===true);};
m.prototype._shiftHeaderTitle=function(){var s=this._calculateShiftOffset(),o=s.sStyleAttribute,p=s.iMarginalsOffset;this.$().find(".sapUxAPObjectPageHeaderTitle").css("padding-"+o,p+"px");};
m.prototype._isFirstSection=function(s){var o=this._getVisibleSections();if(s===o[0]){return true;}return false;};
m.prototype._isPositionWithinSection=function(s,o){if(!o||!this._bDomReady||!this._oSectionInfo[o.getId()]){return;}var p=this._computeScrollPosition(o),r=q(o.getDomRef()).height(),t=p+r;return((s>=p)&&(s<t));};
m.prototype._restoreScrollPosition=function(){var s=this.oCore.byId(this._sStoredScrolledSubSectionId);if(!s){return;}if(this._isPositionWithinSection(this._iStoredScrollPosition,s)){this._scrollTo(this._iStoredScrollPosition,0);}else{this.scrollToSection(s.getId(),0);}};
m.prototype._storeScrollLocation=function(){if(!this.getDomRef()||!this._bDomReady){return;}this._iStoredScrollPosition=this._oScroller.getScrollTop();this._sStoredScrolledSubSectionId=this._getClosestScrolledSectionId(this._oScroller.getScrollTop(),this.iScreenHeight,true);this._oCurrentTabSection=null;};
m.prototype.onkeyup=function(E){var F,o;if(E.which===K.TAB){F=this.oCore.getCurrentFocusedControlId();o=F&&this.oCore.byId(F);if(o&&this._isFirstSection(o)){this._scrollTo(0,0);}}};
m.prototype.setShowFooter=function(s){var r=this.setProperty("showFooter",s,true);this._toggleFooter(s);return r;};
m.prototype._toggleFooter=function(s){var u=this.oCore.getConfiguration().getAnimation(),F=this.getFooter();if(!n(F)){return;}F.toggleStyleClass("sapUxAPObjectPageFloatingFooterShow",s);F.toggleStyleClass("sapUxAPObjectPageFloatingFooterHide",!s);if(this._iFooterWrapperHideTimeout){clearTimeout(this._iFooterWrapperHideTimeout);}if(u){if(!s){this._iFooterWrapperHideTimeout=setTimeout(function(){this.$("footerWrapper").toggleClass("sapUiHidden",!s);}.bind(this),m.FOOTER_ANIMATION_DURATION);}else{this.$("footerWrapper").toggleClass("sapUiHidden",!s);this._iFooterWrapperHideTimeout=null;}setTimeout(function(){F.removeStyleClass("sapUxAPObjectPageFloatingFooterShow");},m.FOOTER_ANIMATION_DURATION);}this._requestAdjustLayout();};
m.prototype.clone=function(){var o,H;Object.keys(this.mAggregations).forEach(this._cloneProxiedAggregations,this);o=C.prototype.clone.apply(this,arguments);H=this._getHeaderContent();o.setAggregation("_headerContent",H.clone(),true);return o;};
m.prototype._cloneProxiedAggregations=function(s){var o=this.mAggregations[s];if(Array.isArray(o)&&o.length===0){o=this["get"+s.charAt(0).toUpperCase()+s.slice(1)]();}this.mAggregations[s]=o;};
m.prototype._shouldPreserveHeaderInTitleArea=function(){return this._bPinned||this._preserveHeaderStateOnScroll()||this._checkAlwaysShowContentHeader();};
m.prototype._checkAlwaysShowContentHeader=function(){return!this._hasDynamicTitle()&&!this._bMobileScenario&&!this._bTabletScenario&&this.getShowHeaderContent()&&this.getAlwaysShowContentHeader();};
m.prototype._shouldOverridePreserveHeaderStateOnScroll=function(){return!D.system.desktop&&this._headerBiggerThanAllowedToBeFixed();};
m.prototype._headerBiggerThanAllowedToBeFixed=function(){var o=this._getOwnHeight();return this._getEntireHeaderHeight()>m.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*o;};
m.prototype._headerBiggerThanAllowedToBeExpandedInTitleArea=function(){return this._getEntireHeaderHeight()>=this._getOwnHeight();};
m.prototype._getOwnHeight=function(){return this._getHeight(this);};
m.prototype._getHeight=function(o){return!(o instanceof C)?0:o.$().outerHeight()||0;};
m.prototype._getEntireHeaderHeight=function(){var t=0,H=0,o=this.getHeaderTitle(),p=this._getHeaderContent();if(n(o)){t=o.$().outerHeight();}if(n(p)){H=p.$().outerHeight();}return t+H;};
m.prototype._onPinUnpinButtonPress=function(){if(this._bPinned){this._unPin();}else{this._pin();}};
m.prototype._pin=function(){var $=this.$();if(this._bPinned){return;}this._bPinned=true;this._toggleHeaderTitle(true);this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._adjustHeaderHeights();this._requestAdjustLayout();this._togglePinButtonARIAState(this._bPinned);this._updateToggleHeaderVisualIndicators();if(n($)){$.addClass("sapUxAPObjectPageLayoutHeaderPinned");}if(n(this._$stickyAnchorBar)){this._$stickyAnchorBar.addClass("sapUxAPObjectPageStickyAnchorBarPaddingTop");}};
m.prototype._unPin=function(){var $=this.$();if(!this._bPinned){return;}this._bPinned=false;this._updateToggleHeaderVisualIndicators();this._togglePinButtonARIAState(this._bPinned);if(n($)){$.removeClass("sapUxAPObjectPageLayoutHeaderPinned");}};
m.prototype._togglePinButtonARIAState=function(p){var H=this._getHeaderContent();if(n(H)&&H.supportsPinUnpin()){H._updateARIAPinButtonState(p);}};
m.prototype._preserveHeaderStateOnScroll=function(){return this._hasDynamicTitle()&&this.getPreserveHeaderStateOnScroll()&&!this._bHeaderBiggerThanAllowedHeight;};
m.prototype._overridePreserveHeaderStateOnScroll=function(){if(!this._shouldOverridePreserveHeaderStateOnScroll()){this._bHeaderBiggerThanAllowedHeight=false;return;}this._bHeaderBiggerThanAllowedHeight=true;if(this._bHeaderExpanded){this._moveAnchorBarToContentArea();this._moveHeaderToContentArea(true);}else{this._snapHeader(true);}this._adjustHeaderHeights();this._requestAdjustLayout();};
m.prototype._hasDynamicTitle=function(){var t=this.getHeaderTitle();return t&&t.isDynamic();};
m.prototype._attachVisualIndicatorsPressHandlers=function(p,o){var t=this.getHeaderTitle(),H=this._getHeaderContent();if(n(t)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){t.attachEvent(m.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,function(){p.call(o);if(this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._scrollBelowCollapseVisualIndicator();}this._focusCollapseVisualIndicator();},this);this._bAlreadyAttachedTitleIndicatorPressHandler=true;}if(n(H)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){H.attachEvent(m.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,function(){p.call(o);this._focusExpandVisualIndicator();},this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true;}};
m.prototype._updateToggleHeaderVisualIndicators=function(){var H,o,E;if(!this.getToggleHeaderOnTitleClick()){o=false;E=false;}else{H=this._bHeaderExpanded;o=H;E=!H;}this._toggleCollapseVisualIndicator(o);this._toggleExpandVisualIndicator(E);};
m.prototype._focusCollapseVisualIndicator=function(){var o=this._getHeaderContent();if(n(o)){o._focusCollapseButton();}};
m.prototype._focusExpandVisualIndicator=function(){var o=this.getHeaderTitle();if(n(o)){o._focusExpandButton();}};
m.prototype._toggleExpandVisualIndicator=function(t){var o=this.getHeaderTitle();if(n(o)){o._toggleExpandButton(t);}};
m.prototype._toggleCollapseVisualIndicator=function(t){var o=this._getHeaderContent();if(n(o)){o._toggleCollapseButton(t);}};
m.prototype._attachVisualIndicatorMouseOverHandlers=function(o,p,r){var H=this._getHeaderContent();if(n(H)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){H.attachEvent(m.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,o,r);H.attachEvent(m.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,p,r);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true;}};
m.prototype._attachTitleMouseOverHandlers=function(o,p,r){var t=this.getHeaderTitle();if(n(t)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){t.attachEvent(m.EVENTS.TITLE_MOUSE_OVER,o,r);t.attachEvent(m.EVENTS.TITLE_MOUSE_OUT,p,r);this._bAlreadyAttachedTitleMouseOverOutHandler=true;}};
m.prototype._suppressScroll=function(){this._bSuppressScroll=true;};
m.prototype._resumeScroll=function(){this._bSuppressScroll=false;if(this._iStoredScrollPosition){this._scrollTo(this._iStoredScrollPosition,0);}else{this._onScroll({target:{scrollTop:this._$opWrapper.scrollTop()}});}};
m.prototype._addHoverClass=function(){var $=this.$();if($){$.addClass("sapUxAPObjectPageLayoutTitleForceHovered");}};
m.prototype._removeHoverClass=function(){var $=this.$();if($){$.removeClass("sapUxAPObjectPageLayoutTitleForceHovered");}};
m.prototype._getHeight=function(o){return!(o instanceof C)?0:o.$().outerHeight()||0;};
m.prototype._getWidth=function(o){return!(o instanceof C)?0:o.$().outerWidth()||0;};
m.prototype._getSectionInfoIsDirty=function(){return this.bSectionInfoIsDirty;};
m.prototype._setSectionInfoIsDirty=function(o){this.bSectionInfoIsDirty=o;};
m.prototype._getRootAriaLabelText=function(){var H=this.getHeaderTitle(),t=H?H.getTitleText():null,s;if(H&&t){s=m._getLibraryResourceBundle().getText("ROOT_ARIA_LABEL_WITH_TITLE")+" "+t;}else{s=m._getLibraryResourceBundle().getText("ROOT_ARIA_LABEL_WITHOUT_TITLE");}return s;};
m.prototype._getDOMRefHeight=function(o){return o.parentElement?o.getBoundingClientRect().height:0;};
m.prototype._updateRootAriaLabel=function(){var N=this._getRootAriaLabelText(),s=this.$().attr("aria-label");if(N!==s){this.$().attr("aria-label",N);}};
function n(o){if(arguments.length===1){return Array.isArray(o)?o.length>0:!!o;}return Array.prototype.slice.call(arguments).every(function(p){return n(p);});}
return m;});
sap.ui.predefine('sap/uxap/ObjectPageLayoutABHelper',["sap/ui/thirdparty/jquery","sap/ui/base/Metadata","sap/ui/core/CustomData","sap/ui/base/ManagedObjectObserver","./AnchorBar","sap/m/Button","sap/m/MenuButton","sap/m/Menu","sap/m/MenuItem","sap/ui/core/IconPool"],function(q,M,C,a,A,B,b,c,d,I){"use strict";var e=M.createClass("sap.uxap._helpers.AB",{constructor:function(o){this._oObjectPageLayout=o;this._iScrollDuration=o._iScrollToSectionDuration;this._iFocusMoveDelay=this._iScrollDuration-100;this._oObserver=new a(this._proxyStateChanges.bind(this));this._aMenusWithAttachPressHandler=[];}});
e.prototype.getObjectPageLayout=function(){return this._oObjectPageLayout;};
e.prototype._proxyStateChanges=function(o){var O=o.object,g=this._findExistingClone(O),p=o.name,v=o.current,s="set"+f(p);if(g){g[s].call(g,v);}};
e.prototype._findExistingClone=function(o){var g,s=o.getId()+"-__clone",h=this._getAnchorBar(),i=h.getContent();i.some(function(j){if(j.getId().indexOf(s)===0){g=j;return true;}});return g;};
e.prototype._getAnchorBar=function(){var o=this.getObjectPageLayout(),g=o.getAggregation("_anchorBar");if(!g){g=new A({id:o.getId()+"-anchBar",showPopover:o.getShowAnchorBarPopover(),backgroundDesign:o.getBackgroundDesignAnchorBar()});this.getObjectPageLayout().setAggregation("_anchorBar",g,true);}return g;};
e.prototype._buildAnchorBar=function(){var s=this.getObjectPageLayout().getSections()||[],o=this._getAnchorBar(),p=q.proxy(o._handleDirectScroll,o),g,h,m,i;if(o&&this.getObjectPageLayout().getShowAnchorBar()){o._resetControl();this._oObserver.disconnect();s.forEach(function(S){if(!S.getVisible()||!S._getInternalVisible()){return;}var j,k=S.getSubSections()||[];j=this._buildAnchorBarButton(S,true);if(j){o.addContent(j);if(j instanceof b){var l=new c({});j.enhanceAccessibilityState=function(E,n){var r=o.getContent(),t=r.indexOf(E.getParent());if(t!==-1){n.role="menuitemradio";n.type="button";n.setsize=r.length;n.posinset=t+1;}};l._setCustomEnhanceAccStateFunction(function(E,n){n.controls=E.data("sectionId");});j.setMenu(l);}k.forEach(function(n){if(!n.getVisible()||!n._getInternalVisible()){return;}var r=this._buildAnchorBarButton(n,false);if(r){o.addContent(r);}if(j instanceof b){i=n.getCustomAnchorBarButton();if(i){g=i.getText();h=i.getIcon();}else{g=n._getInternalTitle()||n.getTitle();h='';}m=new d({"text":g,"icon":h});m.addCustomData(new C({key:"sectionId",value:n.getId()}));m.attachPress(p);j.getMenu().addItem(m);}},this);}},this);}};
e.prototype._moveFocusOnSection=function(s){var S=s.data(),o=sap.ui.getCore().byId(S.sectionId),O=this.getObjectPageLayout();if(o&&!O.getUseIconTabBar()){setTimeout(o.$()["focus"].bind(o.$()),this._iFocusMoveDelay);}};
e.prototype._instantiateAnchorBarButton=function(i,s,g){var o=i?new b({type:"Transparent",buttonMode:"Split",useDefaultActionOnly:true,ariaDescribedBy:s,id:g}):new B({ariaDescribedBy:s,id:g});return o;};
e.prototype._buildAnchorBarButton=function(s,i){var o=null,O=this.getObjectPageLayout(),g,h=this._getAnchorBar(),j,H,v,S=s.getAggregation("subSections"),p=q.proxy(h._handleDirectScroll,h);if(s.getVisible()&&s._getInternalVisible()){g=s.getCustomAnchorBarButton();if(!g){j=h.getId()+"-"+s.getId()+"-anchor";if(i){if(S&&S.length>1){v=S.filter(function(k){return k.getVisible()&&k._getInternalVisible();}).length;}}H=i&&v>1&&h.getShowPopover();if(H){o=this._instantiateAnchorBarButton(true,s,j);o.attachDefaultAction(p);o._getButtonControl().attachPress(function(){this.getParent().focus();});o._getButtonControl().attachArrowPress(function(){var k=o._getButtonControl();if(this._aMenusWithAttachPressHandler[k.getId()]){return;}o.getMenu().attachItemSelected(function(E){this._moveFocusOnSection(E.getParameter("item"));},this);this._aMenusWithAttachPressHandler[k.getId()]=true;},this);o.addCustomData(new C({key:"bHasSubMenu",value:true}));}else{o=this._instantiateAnchorBarButton(false,s,j);o.attachPress(p);o.attachPress(function(E){this._moveFocusOnSection(E.getSource());},this);}var t=(s._getInternalTitle()!="")?s._getInternalTitle():s.getTitle();o.setText(t);}else{o=g.clone();o.attachPress(p);o.attachPress(function(E){this._moveFocusOnSection(E.getSource());},this);this._oObserver.observe(g,{properties:true});}O._oSectionInfo[s.getId()].buttonId=o.getId();o.addCustomData(new C({key:"sectionId",value:s.getId()}));o.addCustomData(new C({key:"bTitleVisible",value:s._getInternalTitleVisible()}));if(!i){o.addCustomData(new C({key:"secondLevel",value:true}));}}return o;};
function f(n){return n.substring(0,1).toUpperCase()+n.substring(1);}
return e;},false);
sap.ui.predefine('sap/uxap/ObjectPageLayoutRenderer',["sap/ui/Device"],function(D){"use strict";var O={};
O.render=function(r,c){var s,h=c.getHeaderTitle(),a=null,i=c.getHeaderContent()&&c.getHeaderContent().length>0&&c.getShowHeaderContent(),I=c.getShowTitleInHeaderContent()&&c.getShowHeaderContent(),R=i||I,u=c.getUseIconTabBar(),t=c.getToggleHeaderOnTitleClick()&&c.getHeaderTitle()&&c.getHeaderTitle().supportsToggleHeaderOnTitleClick(),b=c._getRootAriaLabelText(),B=c.getBackgroundDesignAnchorBar();if(c.getShowAnchorBar()&&c._getInternalAnchorBarVisible()){a=c.getAggregation("_anchorBar");}r.write("<div");r.writeControlData(c);r.writeAttribute("role","region");r.writeAttributeEscaped("aria-label",b);r.addClass("sapUxAPObjectPageLayout");if(t){r.addClass("sapUxAPObjectPageLayoutTitleClickEnabled");}if(a){r.addClass("sapUxAPObjectPageLayoutWithNavigation");}r.writeClasses();r.addStyle("height",c.getHeight());r.writeStyles();r.write(">");if(D.system.desktop){r.renderControl(c._getCustomScrollBar().addStyleClass("sapUxAPObjectPageCustomScroller"));}r.write("<header ");r.writeAttribute("role","banner");r.writeAttributeEscaped("id",c.getId()+"-headerTitle");r.writeAttribute("data-sap-ui-customfastnavgroup",true);r.addClass("sapUxAPObjectPageHeaderTitle");r.addClass("sapContrastPlus");r.writeClasses();r.write(">");if(h){r.renderControl(h);}this._renderHeaderContentDOM(r,c,R&&c._bHeaderInTitleArea,"-stickyHeaderContent");r.write("<div ");r.writeAttributeEscaped("id",c.getId()+"-stickyAnchorBar");r.addClass("sapUxAPObjectPageStickyAnchorBar");r.addClass("sapUxAPObjectPageNavigation");if(B){r.addClass("sapUxAPObjectPageNavigation"+B);}r.writeClasses();r.write(">");this._renderAnchorBar(r,c,a,c._bHeaderInTitleArea);r.write("</div>");r.write("</header>");r.write("<div ");r.writeAttributeEscaped("id",c.getId()+"-opwrapper");r.addClass("sapUxAPObjectPageWrapper");if(h&&!h.supportsTitleInHeaderContent()||!(c.getShowTitleInHeaderContent()&&h.getShowTitleSelector())){r.addClass("sapUxAPObjectPageWrapperTransform");}r.writeClasses();r.write(">");r.write("<div ");r.writeAttributeEscaped("id",c.getId()+"-scroll");r.addClass("sapUxAPObjectPageScroll");r.writeClasses();r.write(">");this._renderHeaderContentDOM(r,c,R&&!c._bHeaderInTitleArea,"-headerContent",true);r.write("<section ");r.writeAttributeEscaped("id",c.getId()+"-anchorBar");r.writeAttribute("role","navigation");r.addClass("sapUxAPObjectPageNavigation");r.addClass("sapContrastPlus");if(B){r.addClass("sapUxAPObjectPageNavigation"+B);}r.writeClasses();r.write(">");this._renderAnchorBar(r,c,a,!c._bHeaderInTitleArea);r.write("</section>");r.write("<section");r.addClass("sapUxAPObjectPageContainer");r.writeAttributeEscaped("id",c.getId()+"-sectionsContainer");r.addClass("ui-helper-clearfix");if(!a){r.addClass("sapUxAPObjectPageContainerNoBar");}r.writeClasses();r.write(">");s=c._getSectionsToRender();if(Array.isArray(s)){s.forEach(function(S){r.renderControl(S);if(u){c._oCurrentTabSection=S;}});}r.write("</section>");this.renderFooterContent(r,c);r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-spacer");r.write("></div>");r.write("</div>");r.write("</div>");this._renderFooterContentInternal(r,c);r.write("</div>");};
O._renderAnchorBar=function(r,c,a,R){var s=c.getAggregation("sections"),h;if(R){h=c._getHeaderContent();if(c.getIsChildPage()&&h&&h.supportsChildPageDesign()){r.write("<div ");r.writeAttributeEscaped("id",c.getId()+"-childPageBar");if(Array.isArray(s)&&s.length>1){r.addClass('sapUxAPObjectChildPage');}r.writeClasses();r.write("></div>");}if(a){r.renderControl(a);}}};
O._renderHeaderContentDOM=function(r,c,R,i,a){r.write("<header ");r.writeAttributeEscaped("id",c.getId()+i);r.addClass("ui-helper-clearfix");r.addClass("sapUxAPObjectPageHeaderDetails");r.addClass("sapUxAPObjectPageHeaderDetailsDesign-"+c._getHeaderDesign());if(a){r.addClass("sapContrastPlus");}r.writeClasses();r.writeAttribute("data-sap-ui-customfastnavgroup",true);r.write(">");if(R){this.renderHeaderContent(r,c);}r.write("</header>");};
O.renderHeaderContent=function(r,c){r.renderControl(c._getHeaderContent());};
O.renderFooterContent=function(r,c){};
O._renderFooterContentInternal=function(r,o){var f=o.getFooter();if(!f){return;}r.write("<footer");r.writeAttributeEscaped("id",o.getId()+"-footerWrapper");r.addClass("sapUxAPObjectPageFooter sapMFooter-CTX sapContrast sapContrastPlus");if(!o.getShowFooter()){r.addClass("sapUiHidden");}r.writeClasses();r.write(">");f.addStyleClass("sapUxAPObjectPageFloatingFooter");r.renderControl(f);r.write("</footer>");};
O._rerenderHeaderContentArea=function(r,c){var h=c._bHeaderInTitleArea?"stickyHeaderContent":"headerContent",$;this.renderHeaderContent(r,c);$=c.$(h)[0];if($){r.flush($);}};
return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageLazyLoader',['./library','sap/ui/core/Element','sap/ui/core/StashedControlSupport',"sap/base/assert"],function(l,E,S,a){"use strict";
var L=E.extend("sap.uxap.ObjectPageLazyLoader",{metadata:{library:"sap.uxap",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},defaultAggregation:"content"}});
S.mixInto(L);
L.prototype.setParent=function(p){if(!(p===null||p instanceof sap.uxap.ObjectPageSubSection)){a(false,"setParent(): oParent must be an instance of sap.uxap.ObjectPageSubSection or null");}return E.prototype.setParent.apply(this,arguments);};
return L;});
sap.ui.predefine('sap/uxap/ObjectPageSection',["sap/ui/core/InvisibleText","./ObjectPageSectionBase","sap/ui/Device","sap/m/Button","sap/ui/core/StashedControlSupport","./ObjectPageSubSection","./library","sap/m/library","./ObjectPageSectionRenderer"],function(I,O,D,B,S,a,l,m,b){"use strict";var c=m.ButtonType;
var d=O.extend("sap.uxap.ObjectPageSection",{metadata:{library:"sap.uxap",properties:{showTitle:{type:"boolean",group:"Appearance",defaultValue:true},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"subSections",aggregations:{subSections:{type:"sap.uxap.ObjectPageSubSection",multiple:true,singularName:"subSection"},ariaLabelledBy:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},_showHideAllButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_showHideButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{selectedSubSection:{type:"sap.uxap.ObjectPageSubSection",multiple:false}},designtime:"sap/uxap/designtime/ObjectPageSection.designtime"}});
d.MEDIA_RANGE=D.media.RANGESETS.SAP_STANDARD;
d._getClosestSection=function(s){var o=(typeof s==="string"&&sap.ui.getCore().byId(s))||s;return(o instanceof a)?o.getParent():o;};
d._getLibraryResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap");};
d.prototype._expandSection=function(){O.prototype._expandSection.call(this)._updateShowHideAllButton(!this._thereAreHiddenSubSections());};
d.prototype.init=function(){O.prototype.init.call(this);this._sContainerSelector=".sapUxAPObjectPageSectionContainer";};
d.prototype.exit=function(){this._detachMediaContainerWidthChange(this._updateImportance,this);};
d.prototype.setTitle=function(v){O.prototype.setTitle.call(this,v);var A=this.getAggregation("ariaLabelledBy"),s=d._getLibraryResourceBundle().getText("SECTION_CONTROL_NAME");if(A){sap.ui.getCore().byId(A.getId()).setText(v+" "+s);}};
d.prototype._getImportanceLevelToHide=function(C){var o=this._getObjectPageLayout(),M=C||this._getCurrentMediaContainerRange(),s=o&&o.getShowOnlyHighImportance();return this._determineTheLowestLevelOfImportanceToShow(M.name,s);};
d.prototype._updateImportance=function(C){var o=this._getObjectPageLayout(),i=this._getImportanceLevelToHide(C);this.getSubSections().forEach(function(s){s._applyImportanceRules(i);});this._applyImportanceRules(i);this._updateShowHideAllButton(false);if(o&&this.getDomRef()){o._requestAdjustLayout();}};
d.prototype._determineTheLowestLevelOfImportanceToShow=function(M,s){if(s||M==="Phone"){return l.Importance.High;}if(M==="Tablet"){return l.Importance.Medium;}return l.Importance.Low;};
d.prototype.connectToModels=function(){this.getSubSections().forEach(function(s){s.connectToModels();});};
d.prototype._allowPropagationToLoadedViews=function(A){this.getSubSections().forEach(function(s){s._allowPropagationToLoadedViews(A);});};
d.prototype.onBeforeRendering=function(){var A="ariaLabelledBy";if(!this.getAggregation(A)){this.setAggregation(A,this._getAriaLabelledBy(),true);}this._detachMediaContainerWidthChange(this._updateImportance,this);this._updateImportance();};
d.prototype.onAfterRendering=function(){this._attachMediaContainerWidthChange(this._updateImportance,this);};
d.prototype._getAriaLabelledBy=function(){var L="",t=this._getTitle();if(t){L+=t+" ";}L+=d._getLibraryResourceBundle().getText("SECTION_CONTROL_NAME");return new I({text:L}).toStatic();};
d.prototype._isTitleVisible=function(){return this.getShowTitle()&&this._getInternalTitleVisible();};
d.prototype._setSubSectionsFocusValues=function(){var s=this.getSubSections()||[],L=this.getSelectedSubSection(),p;if(s.length===0){return this;}if(s.length===1){s[0]._setToFocusable(false);return this;}s.forEach(function(o){if(L===o.sId){o._setToFocusable(true);p=true;}else{o._setToFocusable(false);}});if(!p){s[0]._setToFocusable(true);}return this;};
d.prototype._disableSubSectionsFocus=function(){var s=this.getSubSections()||[];s.forEach(function(o){o._setToFocusable(false);});return this;};
d.prototype._thereAreHiddenSubSections=function(){return this.getSubSections().some(function(s){return s._getIsHidden();});};
d.prototype._updateShowHideSubSections=function(h){this.getSubSections().forEach(function(s){if(h&&s._shouldBeHidden()){s._updateShowHideState(true);}else if(!h){s._updateShowHideState(false);}});};
d.prototype._getShouldDisplayShowHideAllButton=function(){return this.getSubSections().some(function(s){return s._shouldBeHidden();});};
d.prototype._showHideContentAllContent=function(){var s=this._thereAreHiddenSubSections();if(this._getIsHidden()&&s){this._updateShowHideState(false);}this._updateShowHideSubSections(!s);this._updateShowHideAllButton(s);};
d.prototype._updateShowHideState=function(h){this._updateShowHideButton(h);this._getShowHideAllButton().setVisible(this._getShouldDisplayShowHideAllButton());return O.prototype._updateShowHideState.call(this,h);};
d.prototype._updateShowHideAllButton=function(h){this._getShowHideAllButton().setVisible(this._getShouldDisplayShowHideAllButton()).setText(this._getShowHideAllButtonText(h));};
d.prototype._getShowHideAllButton=function(){if(!this.getAggregation("_showHideAllButton")){this.setAggregation("_showHideAllButton",new B({visible:this._getShouldDisplayShowHideAllButton(),text:this._getShowHideAllButtonText(!this._thereAreHiddenSubSections()),press:this._showHideContentAllContent.bind(this),type:c.Transparent}).addStyleClass("sapUxAPSectionShowHideButton"),true);}return this.getAggregation("_showHideAllButton");};
d.prototype._getShowHideButtonText=function(h){return d._getLibraryResourceBundle().getText(h?"HIDE":"SHOW");};
d.prototype._getShowHideAllButtonText=function(h){return d._getLibraryResourceBundle().getText(h?"HIDE_ALL":"SHOW_ALL");};
d.prototype._updateShowHideButton=function(h){this._getShowHideButton().setVisible(this._shouldBeHidden()).setText(this._getShowHideButtonText(!h));};
d.prototype._getShowHideButton=function(){if(!this.getAggregation("_showHideButton")){this.setAggregation("_showHideButton",new B({visible:this._shouldBeHidden(),text:this._getShowHideButtonText(!this._getIsHidden()),press:this._showHideContent.bind(this),type:c.Transparent}).addStyleClass("sapUxAPSectionShowHideButton"),true);}return this.getAggregation("_showHideButton");};
S.mixInto(d);return d;});
sap.ui.predefine('sap/uxap/ObjectPageSectionBase',["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/library","./library","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/dom/jquery/Focusable"],function(q,C,c,l,L,K){"use strict";var T=c.TitleLevel;
var O=C.extend("sap.uxap.ObjectPageSectionBase",{metadata:{"abstract":true,library:"sap.uxap",properties:{title:{type:"string",group:"Appearance",defaultValue:null},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:T.Auto},visible:{type:"boolean",group:"Appearance",defaultValue:true},importance:{type:"sap.uxap.Importance",group:"Behavior",defaultValue:l.Importance.High}},aggregations:{customAnchorBarButton:{type:"sap.m.Button",multiple:false}}}});
O.prototype.init=function(){this._bInternalVisible=true;this._bInternalTitleVisible=true;this._sInternalTitle="";this._sInternalTitleLevel=T.Auto;this._isHidden=false;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();};
O.prototype.onAfterRendering=function(){if(this._getObjectPageLayout()){this._getObjectPageLayout()._requestAdjustLayout().catch(function(){L.debug("ObjectPageSectionBase :: cannot adjustLayout",this);});this._getObjectPageLayout()._setSectionsFocusValues();}};
O.prototype.setCustomAnchorBarButton=function(b){var r=this.setAggregation("customAnchorBarButton",b,true);if(this._getObjectPageLayout()){this._getObjectPageLayout()._updateNavigation();}return r;};
O.prototype._setInternalVisible=function(v,i){if(v!=this._bInternalVisible){this._bInternalVisible=v;if(i){this.invalidate();}}};
O.prototype._getInternalVisible=function(){return this._bInternalVisible;};
O.prototype._setInternalTitleVisible=function(v,i){if(v!=this._bInternalTitleVisible){this._bInternalTitleVisible=v;if(i){this.invalidate();}}};
O.prototype._getInternalTitleVisible=function(){return this._bInternalTitleVisible;};
O.prototype._setInternalTitle=function(v,i){if(v!=this._sInternalTitle){this._sInternalTitle=v;if(i){this.invalidate();}}};
O.prototype._getTitle=function(){return this._getInternalTitle()||this.getTitle();};
O.prototype._getInternalTitle=function(){return this._sInternalTitle;};
O.prototype._getARIALevel=function(){return this._getTitleLevel().slice(-1);};
O.prototype._getTitleLevel=function(){var t=this.getTitleLevel();return(t===T.Auto)?this._getInternalTitleLevel():t;};
O.prototype._setInternalTitleLevel=function(t){this._sInternalTitleLevel=t;};
O.prototype._getInternalTitleLevel=function(){return this._sInternalTitleLevel;};
O.prototype._getObjectPageLayout=function(){return l.Utilities.getClosestOPL(this);};
O.prototype._notifyObjectPageLayout=function(){if(this._getObjectPageLayout()&&this._getObjectPageLayout().$().length){this._getObjectPageLayout()._requestAdjustLayoutAndUxRules();}};
["addAggregation","insertAggregation","removeAllAggregation","removeAggregation","destroyAggregation"].forEach(function(m){O.prototype[m]=function(a,o,i,s){if(["addAggregation","removeAggregation"].indexOf(m)>-1){s=i;}if(["removeAllAggregation","destroyAggregation"].indexOf(m)>-1){s=o;}var r=C.prototype[m].apply(this,arguments);if(s!==true){this._notifyObjectPageLayout();}return r;};});
O.prototype.setVisible=function(v,s){if(!this._getObjectPageLayout()){return this.setProperty("visible",v,s);}this.setProperty("visible",v,true);this._notifyObjectPageLayout();this.invalidate();return this;};
O.prototype.setTitle=function(v,s){this.setProperty("title",v,s);this._notifyObjectPageLayout();return this;};
O.prototype._shouldBeHidden=function(){return O._importanceMap[this.getImportance()]>O._importanceMap[this._sCurrentLowestImportanceLevelToShow];};
O._importanceMap={"Low":3,"Medium":2,"High":1};
O.prototype._updateShowHideState=function(h){var o=this._getObjectPageLayout();this._isHidden=h;this.$().children(this._sContainerSelector).toggle(!h);if(o){o._requestAdjustLayout();}return this;};
O.prototype._getIsHidden=function(){return this._isHidden;};
O.prototype._expandSection=function(){return this._updateShowHideState(false);};
O.prototype._showHideContent=function(){return this._updateShowHideState(!this._getIsHidden());};
O.prototype._applyImportanceRules=function(s){this._sCurrentLowestImportanceLevelToShow=s;if(this.getDomRef()){this._updateShowHideState(this._shouldBeHidden());}else{this._isHidden=this._shouldBeHidden();}};
O.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;
O.prototype.onkeydown=function(e){if(e.keyCode===K.F7){var s=this.getSubSections(),f=s[0],o;if(s.length===1){o=f._oLastFocusedControlF7;if(o){o.$().focus();}else{f.$().firstFocusableDomRef().focus();}}else{if(f.getActions().length){f.getActions()[0].$().focus();}}}};
O.prototype.onsapdown=function(e){this._handleFocusing(e,e.currentTarget.nextSibling);};
O.prototype._handleFocusing=function(e,E){if(this._targetIsCorrect(e)&&E){e.preventDefault();E.focus();this._scrollParent(q(E).attr("id"));}};
O.prototype._targetIsCorrect=function(e){return e.srcControl===this;};
O.prototype.onsapright=function(e){var m=this._bRtl?"onsapup":"onsapdown";this[m](e);};
O.prototype.onsapup=function(e){this._handleFocusing(e,e.currentTarget.previousSibling);};
O.prototype.onsapleft=function(e){var m=this._bRtl?"onsapdown":"onsapup";this[m](e);};
O.prototype.onsaphome=function(e){this._handleFocusing(e,e.currentTarget.parentElement.firstChild);};
O.prototype.onsapend=function(e){this._handleFocusing(e,e.currentTarget.parentElement.lastChild);};
O.prototype.onsappageup=function(e){if(!this._targetIsCorrect(e)){return;}e.preventDefault();var n;var s=q(e.currentTarget).parent().children();var f;s.each(function(S,o){if(q(o).attr("id")===e.currentTarget.id){n=S-(O.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return;}});if(n&&s[n]){s[n].focus();f=q(s[n]).attr("id");}else if(s[0]){s[0].focus();f=q(s[0]).attr("id");}this._scrollParent(f);};
O.prototype.onsappagedown=function(e){if(!this._targetIsCorrect(e)){return;}e.preventDefault();var n;var s=q(e.currentTarget).parent().children();var f;s.each(function(S,o){if(q(o).attr("id")===e.currentTarget.id){n=S+O.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return;}});if(n&&s[n]){s[n].focus();f=q(s[n]).attr("id");}else if(s[s.length-1]){s[s.length-1].focus();f=q(s[s.length-1]).attr("id");}this._scrollParent(f);};
O.prototype._scrollParent=function(i){if(this._getObjectPageLayout()){this._getObjectPageLayout().scrollToSection(i,0,10);}};
return O;});
sap.ui.predefine('sap/uxap/ObjectPageSectionRenderer',function(){"use strict";var O={};
O.render=function(r,c){var t,T,a=sap.ui.getCore().getConfiguration().getAccessibility(),l=c.getAggregation("ariaLabelledBy");if(!c.getVisible()||!c._getInternalVisible()){return;}t=c._getTitle();T=c._isTitleVisible();r.write("<section ");r.addClass("sapUxAPObjectPageSection");if(!T){r.addClass("sapUxAPObjectPageSectionNoTitle");}r.writeClasses();r.writeAttribute("role","region");if(a&&l){r.writeAttribute("aria-labelledby",l.getId());}r.writeControlData(c);r.write(">");if(T){r.write("<div");r.writeAttribute("role","heading");r.writeAttribute("aria-level",c._getARIALevel());r.writeAttributeEscaped("id",c.getId()+"-header");r.addClass("sapUxAPObjectPageSectionHeader");r.writeClasses();r.write(">");r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-title");r.addClass("sapUxAPObjectPageSectionTitle");if(c.getTitleUppercase()){r.addClass("sapUxAPObjectPageSectionTitleUppercase");}r.writeClasses();r.write(">");r.writeEscaped(t);r.write("</div>");r.renderControl(c._getShowHideAllButton());r.renderControl(c._getShowHideButton());r.write("</div>");}r.write("<div");r.addClass("sapUxAPObjectPageSectionContainer");r.writeClasses();if(c._isHidden){r.addStyle("display","none");}r.writeStyles();r.write(">");c.getSubSections().forEach(r.renderControl);r.write("</div>");r.write("</section>");};
return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageSubSection',["sap/ui/thirdparty/jquery","sap/ui/layout/Grid","sap/ui/layout/GridData","./ObjectPageSectionBase","./ObjectPageLazyLoader","./BlockBase","sap/m/Button","sap/ui/Device","sap/ui/core/StashedControlSupport","sap/ui/base/ManagedObjectObserver","sap/m/TitlePropagationSupport","./library","sap/m/library","./ObjectPageSubSectionRenderer","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/dom/jquery/Focusable"],function(q,G,a,O,b,B,c,D,S,d,T,l,m,e,f,K){"use strict";var g=m.ButtonType;var h=l.ObjectPageSubSectionMode;var i=l.ObjectPageSubSectionLayout;
var j=O.extend("sap.uxap.ObjectPageSubSection",{metadata:{library:"sap.uxap",properties:{mode:{type:"sap.uxap.ObjectPageSubSectionMode",group:"Appearance",defaultValue:h.Collapsed},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"blocks",aggregations:{_grid:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},blocks:{type:"sap.ui.core.Control",multiple:true,singularName:"block"},moreBlocks:{type:"sap.ui.core.Control",multiple:true,singularName:"moreBlock"},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"}},designtime:"sap/uxap/designtime/ObjectPageSubSection.designtime"}});
T.call(j.prototype,"blocks",function(){return this._getTitleDomId();});j.MEDIA_RANGE=D.media.RANGESETS.SAP_STANDARD;
j._getLibraryResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap");};
j.prototype.init=function(){O.prototype.init.call(this);this._bRenderedFirstTime=false;this._aAggregationProxy={blocks:[],moreBlocks:[]};this._$spacer=[];this._sContainerSelector=".sapUxAPBlockContainer";this._oObserver=new d(j.prototype._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["actions"]});this._attachMediaContainerWidthChange(this._synchronizeBlockLayouts,this);this._switchSubSectionMode(this.getMode());this._initTitlePropagationSupport();this._sBorrowedTitleDomId=false;};
j.prototype._getTitleDomId=function(){if(this._sBorrowedTitleDomId){return this._sBorrowedTitleDomId;}if(!this.getTitle().trim()){return false;}if(this._getInternalTitleVisible()){return this.getId()+"-headerTitle";}return false;};
j.prototype._setBorrowedTitleDomId=function(I){this._sBorrowedTitleDomId=I;};
j.prototype._expandSection=function(){O.prototype._expandSection.call(this);var p=this.getParent();p&&typeof p._expandSection==="function"&&p._expandSection();return this;};
j.prototype._getGrid=function(){if(!this.getAggregation("_grid")){this.setAggregation("_grid",new G({id:this.getId()+"-innerGrid",defaultSpan:"XL12 L12 M12 S12",hSpacing:1,vSpacing:1,width:"100%",containerQuery:true}),true);}return this.getAggregation("_grid");};
j.prototype._hasVisibleActions=function(){var A=this.getActions()||[];if(A.length===0){return false;}return A.filter(function(o){return o.getVisible();}).length>0;};
j.prototype._observeChanges=function(C){var o=C.object,s=C.name,M=C.mutation,k=C.child,H;if(o===this){if(s==="actions"){if(M==="insert"){this._observeAction(k);}else if(M==="remove"){this._unobserveAction(k);}}}else if(s==="visible"){H=this._getInternalTitleVisible()&&this.getTitle().trim()!=="";if(!H){this.$("header").toggleClass("sapUiHidden",!this._hasVisibleActions());}}};
j.prototype._observeAction=function(C){this._oObserver.observe(C,{properties:["visible"]});};
j.prototype._unobserveAction=function(C){this._oObserver.unobserve(C,{properties:["visible"]});};
j.prototype._unStashControls=function(){S.getStashedControls(this.getId()).forEach(function(C){C.setStashed(false);});};
j.prototype.connectToModels=function(){var k=this.getBlocks()||[],M=this.getMoreBlocks()||[],C=this.getMode();this._unStashControls();k.forEach(function(o){if(o instanceof B){if(!o.getMode()){o.setMode(C);}o.connectToModels();}});if(M.length>0&&C===h.Expanded){M.forEach(function(o){if(o instanceof B){if(!o.getMode()){o.setMode(C);}o.connectToModels();}});}};
j.prototype._allowPropagationToLoadedViews=function(A){var k=this.getBlocks()||[],M=this.getMoreBlocks()||[];k.forEach(function(o){if(o instanceof B){o._allowPropagationToLoadedViews(A);}});M.forEach(function(o){if(o instanceof B){o._allowPropagationToLoadedViews(A);}});};
j.prototype.clone=function(){Object.keys(this._aAggregationProxy).forEach(function(A){var o=this.mAggregations[A];if(!o||o.length===0){this.mAggregations[A]=this._aAggregationProxy[A];}},this);return O.prototype.clone.apply(this,arguments);};
j.prototype._cleanProxiedAggregations=function(){var p=this._aAggregationProxy;Object.keys(p).forEach(function(k){p[k].forEach(function(o){o.destroy();});});};
j.prototype.exit=function(){if(this._oSeeMoreButton){this._oSeeMoreButton.destroy();this._oSeeMoreButton=null;}this._detachMediaContainerWidthChange(this._synchronizeBlockLayouts,this);this._cleanProxiedAggregations();if(O.prototype.exit){O.prototype.exit.call(this);}};
j.prototype.onAfterRendering=function(){var o=this._getObjectPageLayout();if(O.prototype.onAfterRendering){O.prototype.onAfterRendering.call(this);}if(!o){return;}this._$spacer=q(document.getElementById(o.getId()+"-spacer"));};
j.prototype.onBeforeRendering=function(){var o=this._getObjectPageLayout();if(!o){return;}if(O.prototype.onBeforeRendering){O.prototype.onBeforeRendering.call(this);}this._setAggregationProxy();this._getGrid().removeAllContent();this._applyLayout(o);this.refreshSeeMoreVisibility();};
j.prototype._applyLayout=function(L){var v,o=this._getGrid(),C=this.getMode(),s=L.getSubSectionLayout(),k=this._calculateLayoutConfiguration(s,L),n=this.getBlocks(),A=n.concat(this.getMoreBlocks());this._oLayoutConfig=k;this._resetLayoutData(A);if(C===h.Expanded){v=A;}else{v=n;}this._calcBlockColumnLayout(v,this._oLayoutConfig);try{v.forEach(function(p){this._setBlockMode(p,C);o.addAggregation("content",p,true);},this);}catch(E){f.error("ObjectPageSubSection :: error while building layout "+s+": "+E);}return this;};
j.prototype._calculateLayoutConfiguration=function(L,o){var k={M:2,L:3,XL:4},n=k.L,E=k.XL,t=(L===i.TitleOnLeft),u=o.getUseTwoColumnsForLargeScreen();if(t){n-=1;E-=1;}if(u){n-=1;}k.L=n;k.XL=E;return k;};
j.prototype.refreshSeeMoreVisibility=function(){var k=!!this.getMoreBlocks().length,s=this._getSeeMoreButton(),$=s.$(),n=this.$();if(!k){k=this.getBlocks().some(function(o){if(o instanceof B&&o.getVisible()&&o.getShowSubSectionMore()){return true;}});}if(n.length){n.toggleClass("sapUxAPObjectPageSubSectionWithSeeMore",k);}this.toggleStyleClass("sapUxAPObjectPageSubSectionWithSeeMore",k);if($.length){$.toggleClass("sapUxAPSubSectionSeeMoreButtonVisible",k);}s.toggleStyleClass("sapUxAPSubSectionSeeMoreButtonVisible",k);return k;};
j.prototype.setMode=function(M){if(this.getMode()!==M){this._switchSubSectionMode(M);if(this._bRenderedFirstTime){this.rerender();}}return this;};
j.prototype.onkeydown=function(E){if(E.keyCode===K.F7){E.stopPropagation();var t=sap.ui.getCore().byId(E.target.id);if(t instanceof j){this._handleSubSectionF7();}else{this._handleInteractiveElF7();this._oLastFocusedControlF7=t;}}};
j.prototype._handleInteractiveElF7=function(){if(this.getParent().getSubSections().length>1){this.$().focus();}else{this.getParent().$().focus();}};
j.prototype._handleSubSectionF7=function(E){if(this._oLastFocusedControlF7){this._oLastFocusedControlF7.$().focus();}else{this.$().firstFocusableDomRef().focus();}};
j.prototype._calcBlockColumnLayout=function(k,C){var n=12,v,M,L,X,o;M={iRemaining:C.M,iColumnConfig:C.M};L={iRemaining:C.L,iColumnConfig:C.L};X={iRemaining:C.XL,iColumnConfig:C.XL};o=[X,L,M];v=k.filter(function(p){return p.getVisible&&p.getVisible();});v.forEach(function(p,I){o.forEach(function(r){r.iCalculatedSize=this._calculateBlockSize(p,r.iRemaining,v,I,r.iColumnConfig);},this);p.setLayoutData(new a(p.getId()+"-layoutData",{spanS:n,spanM:M.iCalculatedSize*(n/M.iColumnConfig),spanL:L.iCalculatedSize*(n/L.iColumnConfig),spanXL:X.iCalculatedSize*(n/X.iColumnConfig),linebreakM:(I>0&&M.iRemaining===M.iColumnConfig),linebreakL:(I>0&&L.iRemaining===L.iColumnConfig),linebreakXL:(I>0&&X.iRemaining===X.iColumnConfig)}));o.forEach(function(r){r.iRemaining-=r.iCalculatedSize;if(r.iRemaining<1){r.iRemaining=r.iColumnConfig;}});},this);return v;};
j.prototype._calculateBlockSize=function(o,r,v,C,M){var k,F=M,n;if(!this._hasAutoLayout(o)){return Math.min(M,parseInt(o.getColumnLayout(),10));}for(n=1;n<=F;n++){k=this._calcLayout(v[C+n]);if(k<r){r-=k;}else{break;}}return r;};
j.prototype._calcLayout=function(o){var L=1;if(!o){L=0;}else if(o instanceof B&&o.getColumnLayout()!="auto"){L=parseInt(o.getColumnLayout(),10);}return L;};
j.prototype._hasAutoLayout=function(o){return!(o instanceof B)||o.getColumnLayout()=="auto";};
j.prototype._onDesktopMediaRange=function(C){return this._onMediaRange(C,["LargeDesktop","Desktop"]);};
j.prototype._onTabletMediaRange=function(C){return this._onMediaRange(C,["Tablet"]);};
j.prototype._onPhoneMediaRange=function(C){return this._onMediaRange(C,["Phone"]);};
j.prototype._onMediaRange=function(C,k){var M=C||this._getCurrentMediaContainerRange();return k.indexOf(M.name)>-1;};
j.prototype._synchronizeBlockLayouts=function(C){if(this._getUseTitleOnTheLeft()){this.$("header").toggleClass("titleOnLeftLayout",this._onDesktopMediaRange(C));}this._toggleBlockLayoutResponsiveStyles(C);};
j.prototype._toggleBlockLayoutResponsiveStyles=function(C){this.$().find(".sapUxAPBlockContainer").toggleClass("sapUxAPBlockContainerDesktop",this._onDesktopMediaRange(C));this.$().find(".sapUxAPBlockContainer").toggleClass("sapUxAPBlockContainerTablet",this._onTabletMediaRange(C));this.$().find(".sapUxAPBlockContainer").toggleClass("sapUxAPBlockContainerPhone",this._onPhoneMediaRange(C));};
j.prototype._getMediaString=function(C){if(this._onPhoneMediaRange(C)){return"Phone";}if(this._onTabletMediaRange(C)){return"Tablet";}return"Desktop";};
j.prototype._setAggregationProxy=function(){if(this._bRenderedFirstTime){return;}q.each(this._aAggregationProxy,q.proxy(function(A,v){this._setAggregation(A,this.removeAllAggregation(A,true),true);},this));this._bRenderedFirstTime=true;};
j.prototype.hasProxy=function(A){return this._bRenderedFirstTime&&this._aAggregationProxy.hasOwnProperty(A);};
j.prototype._getAggregation=function(A){return this._aAggregationProxy[A];};
j.prototype._setAggregation=function(A,v,s){this._aAggregationProxy[A]=v;if(s!==true){this._notifyObjectPageLayout();this.invalidate();}return this._aAggregationProxy[A];};
j.prototype.addAggregation=function(A,o,s){var k;if(o instanceof b){o.getContent().forEach(function(C){this.addAggregation(A,C,true);},this);o.removeAllContent();o.destroy();this.invalidate();return this;}if(this.hasProxy(A)){k=this._getAggregation(A);k.push(o);this._setAggregation(A,k,s);if(o instanceof B||o instanceof b){o.setParent(this);}return this;}return O.prototype.addAggregation.apply(this,arguments);};
j.prototype.insertBlock=function(o,I){f.warning("ObjectPageSubSection :: usage of insertBlock is not supported - addBlock is performed instead.");return this.addAggregation("blocks",o);};
j.prototype.insertMoreBlock=function(o,I){f.warning("ObjectPageSubSection :: usage of insertMoreBlock is not supported - addMoreBlock is performed instead.");return this.addAggregation("moreBlocks",o);};
j.prototype.removeAllAggregation=function(A,s){var I;if(this.hasProxy(A)){I=this._getAggregation(A);this._setAggregation(A,[],s);return I.slice();}return O.prototype.removeAllAggregation.apply(this,arguments);};
j.prototype.removeAggregation=function(A,o){var r=false,I;if(this.hasProxy(A)){I=this._getAggregation(A);I.forEach(function(k,n){if(k.getId()===o.getId()){I.splice(n,1);this._setAggregation(A,I);r=true;}return!r;},this);return(r?o:null);}return O.prototype.removeAggregation.apply(this,arguments);};
j.prototype.indexOfAggregation=function(A,o){var I=-1;if(this.hasProxy(A)){this._getAggregation(A).some(function(k,n){if(k.getId()===o.getId()){I=n;return true;}},this);return I;}return O.prototype.indexOfAggregation.apply(this,arguments);};
j.prototype.getAggregation=function(A){if(this.hasProxy(A)){return this._getAggregation(A);}return O.prototype.getAggregation.apply(this,arguments);};
j.prototype.destroyAggregation=function(A){if(this.hasProxy(A)){this._getAggregation(A).forEach(function(o){o.destroy();});this._setAggregation(A,[]);return this;}return O.prototype.destroyAggregation.apply(this,arguments);};
j.prototype._getSeeMoreButton=function(){if(!this._oSeeMoreButton){this._oSeeMoreButton=new c(this.getId()+"--seeMore",{type:g.Transparent,iconFirst:false,ariaLabelledBy:this.getId()}).addStyleClass("sapUxAPSubSectionSeeMoreButton").attachPress(this._seeMoreLessControlPressHandler,this);}return this._oSeeMoreButton;};
j.prototype._seeMoreLessControlPressHandler=function(E){var C=this.getMode(),t,M=this.getMoreBlocks()||[];if(C===h.Expanded){t=h.Collapsed;}else{t=h.Expanded;M.forEach(function(o){if(o instanceof B){o.setMode(C);o.connectToModels();}},this);}this._switchSubSectionMode(t);if(this._$spacer.length>0){this._$spacer.height(this._$spacer.height()+this.$().height());}this.rerender();};
j.prototype._switchSubSectionMode=function(s){s=this.validateProperty("mode",s);if(s===h.Collapsed){this.setProperty("mode",h.Collapsed,true);this._getSeeMoreButton().setText(j._getLibraryResourceBundle().getText("SEE_MORE"));}else{this.setProperty("mode",h.Expanded,true);this._getSeeMoreButton().setText(j._getLibraryResourceBundle().getText("SEE_LESS"));}};
j.prototype._setBlockMode=function(o,M){if(o instanceof B){o.setMode(M);}else{f.debug("ObjectPageSubSection :: cannot propagate mode "+M+" to "+o.getMetadata().getName());}};
j.prototype._setToFocusable=function(F){var s='0',n='-1',t="tabIndex";if(F){this.$().attr(t,s);}else{this.$().attr(t,n);}return this;};
j.prototype._getUseTitleOnTheLeft=function(){var o=this._getObjectPageLayout();return o&&(o.getSubSectionLayout()===i.TitleOnLeft);};
j.prototype._resetLayoutData=function(k){k.forEach(function(o){if(o.getLayoutData()){o.destroyLayoutData();}},this);};
j.prototype.getVisibleBlocksCount=function(){var v=S.getStashedControls(this.getId()).length;(this.getBlocks()||[]).forEach(function(o){if(o.getVisible&&!o.getVisible()){return true;}v++;});(this.getMoreBlocks()||[]).forEach(function(M){if(M.getVisible&&!M.getVisible()){return true;}v++;});return v;};
return j;});
sap.ui.predefine('sap/uxap/ObjectPageSubSectionRenderer',function(){"use strict";var O={};
O.render=function(r,c){var a,h,H,b,u,d,A=sap.ui.getCore().getConfiguration().getAccessibility();if(!c.getVisible()||!c._getInternalVisible()){return;}a=c.getActions()||[];b=a.length>0;h=(c._getInternalTitleVisible()&&(c.getTitle().trim()!==""));H=h||b;d=c._hasVisibleActions();r.write("<div ");r.writeAttribute("role","region");r.writeControlData(c);r.addClass("sapUxAPObjectPageSubSection");r.addClass("ui-helper-clearfix");r.writeClasses(c);r.writeClasses();if(A){if(h){r.writeAttributeEscaped("aria-labelledby",c.getId()+"-headerTitle");}else{r.writeAttribute("aria-label",sap.uxap.ObjectPageSubSection._getLibraryResourceBundle().getText("SUBSECTION_CONTROL_NAME"));}}r.write(">");if(H){r.write("<div");r.addClass("sapUxAPObjectPageSubSectionHeader");if(!h&&!d){r.addClass("sapUiHidden");}u=c._getUseTitleOnTheLeft();if(u&&c._onDesktopMediaRange()){r.addClass("titleOnLeftLayout");}r.writeAttributeEscaped("id",c.getId()+"-header");r.writeClasses();r.write(">");r.write("<div");if(h){r.writeAttribute("role","heading");r.writeAttribute("aria-level",c._getARIALevel());}r.addClass('sapUxAPObjectPageSubSectionHeaderTitle');if(c.getTitleUppercase()){r.addClass("sapUxAPObjectPageSubSectionHeaderTitleUppercase");}r.writeAttributeEscaped("id",c.getId()+"-headerTitle");r.writeClasses();r.writeAttribute("data-sap-ui-customfastnavgroup",true);r.write(">");if(h){r.writeEscaped(c.getTitle());}r.write("</div>");if(b){r.write("<div");r.addClass('sapUxAPObjectPageSubSectionHeaderActions');r.writeClasses();r.writeAttribute("data-sap-ui-customfastnavgroup",true);r.write(">");a.forEach(r.renderControl);r.write("</div>");}r.write("</div>");}r.write("<div");r.addClass("ui-helper-clearfix");r.addClass("sapUxAPBlockContainer");r.addClass("sapUxAPBlockContainer"+c._getMediaString());r.writeClasses();if(c._isHidden){r.addStyle("display","none");}r.writeStyles();r.write(">");r.renderControl(c._getGrid());r.write("<div");r.addClass("sapUxAPSubSectionSeeMoreContainer");r.writeClasses();r.write(">");r.renderControl(c._getSeeMoreButton());r.write("</div>");r.write("</div>");r.write("</div>");};
return O;},true);
sap.ui.predefine('sap/uxap/ThrottledTaskHelper',["sap/ui/thirdparty/jquery",'sap/ui/base/Object'],function(q,B){"use strict";
var T=B.extend("ThrottledTask",{
constructor:function(t,d,c){this._fnTask=t;this._iDelay=d;this._oContext=c;this._oPromise=null;this._fnResolvePromise=null;this._fnRejectPromise=null;this._iTimer=null;this._oTaskOptions=null;},
reSchedule:function(i,t){var r=this._getPromise();if(this._iTimer){clearTimeout(this._iTimer);this._iTimer=null;}this._oTaskOptions=this._mergeOptions(this._oTaskOptions||{},t);if(i){var s=this._fnTask.call(this._oContext,this._oTaskOptions);this._completePromise(s);return r;}this._iTimer=setTimeout(function(){if(this._oPromise){var s=this._fnTask.call(this._oContext,this._oTaskOptions);this._completePromise(s);}}.bind(this),this._iDelay);return r;},
_getPromise:function(){if(!this._oPromise){this._oPromise=new window.Promise(function(r,a){this._fnResolvePromise=r;this._fnRejectPromise=a;}.bind(this));}return this._oPromise;},
_completePromise:function(s){var c=(s)?this._fnResolvePromise:this._fnRejectPromise;c();this._oPromise=null;this._fnResolvePromise=null;this._fnRejectPromise=null;this._oTaskOptions=null;},
_mergeOptions:function(o,n){var m=q.extend({},o,n);q.each(m,function(k){m[k]=o[k]||n[k];});return m;}
});
return T;});
sap.ui.predefine('sap/uxap/changeHandler/MoveObjectPageSection',["sap/ui/fl/changeHandler/MoveControls","sap/ui/thirdparty/jquery"],function(M,q){"use strict";var a=q.extend({},M);
a.applyChange=function(c,C,p){var j=p.modifier.targets==="jsControlTree";if(j){C._suppressScroll();}var r=M.applyChange.call(this,c,C,p);if(j){C.attachEventOnce("onAfterRenderingDOMReady",function(){C._resumeScroll(false);});}return r;};
a.revertChange=function(c,C,p){var j=p.modifier.targets==="jsControlTree";if(j){C._suppressScroll();}var r=M.revertChange.call(this,c,C,p);if(j){C.attachEventOnce("onAfterRenderingDOMReady",function(){C._resumeScroll(false);});}return r;};
return a;},true);
sap.ui.predefine('sap/uxap/changeHandler/RenameObjectPageSection',["sap/ui/fl/Utils","sap/ui/fl/changeHandler/BaseRename"],function(U,B){"use strict";var r={propertyName:"title",changePropertyName:"newText",translationTextType:"XGRP"};var R=B.createRenameChangeHandler(r);
R._getControlForRename=function(c,m){var s=m.getAggregation(c,"subSections");if(s&&s.length===1&&m.getProperty(s[0],"title")&&m.getProperty(m.getParent(c),"subSectionLayout")==="TitleOnTop"){return s[0];}return c;};
R._getSetterMethodName=function(v,p,m){return U.isBinding(v)?"setPropertyBinding":"setProperty";};
R.applyChange=function(c,C,p){var m=p.modifier;var P=r.propertyName;var o=c.getDefinition();var t=o.texts[r.changePropertyName];var v=t.value;var a=R._getControlForRename(C,m);if(o.texts&&t&&typeof(v)==="string"){c.setRevertData(m.getProperty(a,P));var M=R._getSetterMethodName(v);m[M](a,P,v);return true;}else{U.log.error("Change does not contain sufficient information to be applied: ["+o.layer+"]"+o.namespace+"/"+o.fileName+"."+o.fileType);}};
R.revertChange=function(c,C,p){var o=c.getRevertData();if(typeof(o)==="string"){var m=p.modifier;var a=R._getControlForRename(C,m);var P=r.propertyName;var M=R._getSetterMethodName(o);m[M](a,P,o);c.resetRevertData();return true;}else{U.log.error("Change doesn't contain sufficient information to be reverted. Most Likely the Change didn't go through applyChange.");}};
return R;},true);
sap.ui.predefine('sap/uxap/component/Component',["sap/uxap/library","sap/ui/core/UIComponent","sap/ui/core/library","sap/base/Log","sap/ui/core/Component"],function(l,U,c,L){"use strict";var V=c.mvc.ViewType;var O=l.ObjectPageConfigurationMode;
var C=U.extend("sap.uxap.component.Component",{
metadata:{},
init:function(){this._oModel=null;this._oViewConfig={viewData:{component:this}};switch(this.oComponentData.mode){case O.JsonURL:this._oModel=new U(this.oComponentData.jsonConfigurationURL);this._oViewConfig.viewName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory";this._oViewConfig.type=V.XML;break;case O.JsonModel:this._oViewConfig.viewName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory";this._oViewConfig.type=V.XML;break;default:L.error("UxAPComponent :: missing bootstrap information. Expecting one of the following: JsonURL, JsonModel and FacetsAnnotation");}U.prototype.init.call(this);},
createContent:function(){var o;this._oView=sap.ui.view(this._oViewConfig);if(this._oModel){o=this._oView.getController();if(o&&o.connectToComponent){o.connectToComponent(this._oModel);}this._oView.setModel(this._oModel,"objectPageLayoutMetadata");}return this._oView;},
propagateProperties:function(n){if(this.oComponentData.mode===O.JsonModel){var o=this._oView.getController();if(o&&o.connectToComponent){o.connectToComponent(this.getModel("objectPageLayoutMetadata"));}}return U.prototype.propagateProperties.apply(this,arguments);},
destroy:function(){if(this._oView){this._oView.destroy();this._oView=null;}if(this._oModel){this._oModel.destroy();this._oModel=null;}if(U.prototype.destroy){U.prototype.destroy.call(this);}}
});
return C;});
sap.ui.predefine('sap/uxap/component/ObjectPageComponentContainer',['sap/ui/core/ComponentContainer',"sap/base/Log",'sap/ui/core/Component'],function(C,L){"use strict";
var O=C.extend("sap.uxap.component.ObjectPageComponentContainer",{
metadata:{properties:{"jsonConfigurationURL":{type:"string",group:"Behavior"},"mode":{type:"sap.uxap.ObjectPageConfigurationMode",group:"Behavior"}}},
init:function(){this.setPropagateModel(true);this.setName("sap.uxap.component");},
onBeforeRendering:function(){this._oComponent=sap.ui.component("sap.uxap");if(!this._oComponent){this._oComponent=sap.ui.component({name:this.getName(),url:this.getUrl(),componentData:{jsonConfigurationURL:this.getJsonConfigurationURL(),mode:this.getMode()}});this.setComponent(this._oComponent,true);}if(C.prototype.onBeforeRendering){C.prototype.onBeforeRendering.call(this);}},
getObjectPageLayoutInstance:function(){var o=null;if(this._oComponent&&this._oComponent._oView){o=this._oComponent._oView.byId("ObjectPageLayout");}else{L.error("ObjectPageComponentContainer :: cannot find children ObjectPageLayout, has it been rendered already?");}return o;},
renderer:"sap.ui.core.ComponentContainerRenderer"
});
return O;});
sap.ui.predefine('sap/uxap/component/ObjectPageLayoutUXDrivenFactory.controller',["jquery.sap.global","sap/ui/model/BindingMode","sap/ui/model/Context","sap/ui/base/ManagedObject","sap/ui/core/mvc/Controller","sap/base/Log","sap/base/util/ObjectPath","sap/ui/thirdparty/jquery"],function(q,B,C,M,a,L,O,Q){"use strict";return a.extend("sap.uxap.component.ObjectPageLayoutUXDrivenFactory",{connectToComponent:function(m){var h=Q.isEmptyObject(m.getData());m.setDefaultBindingMode(B.OneWay);var H=Q.proxy(function(){if(h){m.detachRequestCompleted(H);}var o=new C(m,"/headerTitle"),b=this.getView().byId("ObjectPageLayout");if(o.getProperty("")){try{this._oHeader=this.controlFactory(b.getId(),o);b.setHeaderTitle(this._oHeader);}catch(e){L.error("ObjectPageLayoutFactory :: error in header creation from config: "+e);}}},this);if(h){m.attachRequestCompleted(H);}else{H();}},controlFactory:function(p,b){var c=b.getProperty(""),o,d,e;try{q.sap.require(c.Type);d=O.get(c.Type||"");e=d.getMetadata();Q.each(e._mAllEvents,Q.proxy(function(s,f){if(typeof c[s]=="string"){c[s]=this.convertEventHandler(c[s]);}},this));o=M.create(c);Q.each(e._mAllProperties,Q.proxy(function(P,f){if(c[P]){o.bindProperty(P,"objectPageLayoutMetadata>"+b.getPath()+"/"+P);}},this));}catch(E){L.error("ObjectPageLayoutFactory :: error in control creation from config: "+E);}return o;},convertEventHandler:function(s){var n=window,N=s.split('.');try{Q.each(N,function(i,b){n=n[b];});}catch(e){L.error("ObjectPageLayoutFactory :: undefined event handler: "+s+". Did you forget to require its static class?");n=undefined;}return n;}});},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageDynamicHeaderTitle.flexibility',["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton","sap/f/changeHandler/MoveDynamicPageTitleActions"],function(C,S,M){"use strict";return{"hideControl":"default","unhideControl":"default","combineButtons":{"changeHandler":C,"layers":{"CUSTOMER":false}},"splitMenuButton":{"changeHandler":S,"layers":{"CUSTOMER":false}},"moveActions":{"changeHandler":M},"moveControls":"default"};},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageHeader.flexibility',["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton"],function(C,S){"use strict";return{"combineButtons":{"changeHandler":C,"layers":{"CUSTOMER":false}},"moveControls":"default","splitMenuButton":{"changeHandler":S,"layers":{"CUSTOMER":false}}};},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageHeaderActionButton.flexibility',["sap/ui/fl/changeHandler/BaseRename"],function(B){"use strict";return{"hideControl":"default","rename":B.createRenameChangeHandler({propertyName:"text",translationTextType:"XBUT"}),"unhideControl":"default"};},false);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageLayout.flexibility',['sap/uxap/changeHandler/MoveObjectPageSection'],function(M){"use strict";return{"moveControls":{"changeHandler":M,"layers":{"USER":true}}};},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageSection.flexibility',['sap/uxap/changeHandler/RenameObjectPageSection'],function(R){"use strict";return{"rename":R,"moveControls":"default","hideControl":{"changeHandler":"default","layers":{"USER":true}},"unhideControl":{"changeHandler":"default","layers":{"USER":true}},"stashControl":{"changeHandler":"default","layers":{"USER":true}},"unstashControl":{"changeHandler":"default","layers":{"USER":true}}};},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageSubSection.flexibility',["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton","sap/ui/fl/changeHandler/BaseRename"],function(C,S,B){"use strict";return{"hideControl":"default","unhideControl":"default","rename":B.createRenameChangeHandler({propertyName:"title",translationTextType:"XGRP"}),"combineButtons":{"changeHandler":C,"layers":{"CUSTOMER":false}},"moveControls":"default","splitMenuButton":{"changeHandler":S,"layers":{"CUSTOMER":false}}};},true);
sap.ui.predefine('sap/uxap/library',["sap/ui/core/Core","sap/ui/base/DataType","sap/ui/Device","sap/m/library","sap/ui/layout/library"],function(C,D,a){"use strict";sap.ui.getCore().initLibrary({name:"sap.uxap",dependencies:["sap.ui.core","sap.m","sap.ui.layout"],designtime:"sap/uxap/designtime/library.designtime",types:["sap.uxap.BlockBaseColumnLayout","sap.uxap.ObjectPageConfigurationMode","sap.uxap.ObjectPageHeaderDesign","sap.uxap.ObjectPageHeaderPictureShape","sap.uxap.ObjectPageSubSectionLayout","sap.uxap.ObjectPageSubSectionMode"],interfaces:["sap.uxap.IHeaderTitle","sap.uxap.IHeaderContent"],controls:["sap.uxap.AnchorBar","sap.uxap.BlockBase","sap.uxap.BreadCrumbs","sap.uxap.HierarchicalSelect","sap.uxap.ObjectPageHeader","sap.uxap.ObjectPageDynamicHeaderTitle","sap.uxap.ObjectPageDynamicHeaderContent","sap.uxap.ObjectPageHeaderActionButton","sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageLayout","sap.uxap.ObjectPageSection","sap.uxap.ObjectPageSectionBase","sap.uxap.ObjectPageSubSection"],elements:["sap.uxap.ModelMapping","sap.uxap.ObjectPageHeaderLayoutData"],version:"1.58.2",extensions:{flChangeHandlers:{"sap.uxap.ObjectPageHeader":"sap/uxap/flexibility/ObjectPageHeader","sap.uxap.ObjectPageLayout":"sap/uxap/flexibility/ObjectPageLayout","sap.uxap.ObjectPageSection":"sap/uxap/flexibility/ObjectPageSection","sap.uxap.ObjectPageSubSection":"sap/uxap/flexibility/ObjectPageSubSection","sap.uxap.ObjectPageDynamicHeaderTitle":"sap/uxap/flexibility/ObjectPageDynamicHeaderTitle","sap.uxap.ObjectPageHeaderActionButton":"sap/uxap/flexibility/ObjectPageHeaderActionButton","sap.ui.core._StashedControl":{"unstashControl":{"changeHandler":"default","layers":{"USER":true}}}},"sap.ui.support":{publicRules:true}}});sap.uxap.BlockBaseColumnLayout=D.createType('sap.uxap.BlockBaseColumnLayout',{isValid:function(v){return/^(auto|[1-4]{1})$/.test(v);}},D.getType('string'));sap.uxap.BlockBaseFormAdjustment={BlockColumns:"BlockColumns",OneColumn:"OneColumn",None:"None"};sap.uxap.ObjectPageConfigurationMode={JsonURL:"JsonURL",JsonModel:"JsonModel"};sap.uxap.ObjectPageHeaderDesign={Light:"Light",Dark:"Dark"};sap.uxap.ObjectPageHeaderPictureShape={Circle:"Circle",Square:"Square"};sap.uxap.ObjectPageSubSectionLayout={TitleOnTop:"TitleOnTop",TitleOnLeft:"TitleOnLeft"};sap.uxap.ObjectPageSubSectionMode={Collapsed:"Collapsed",Expanded:"Expanded"};sap.uxap.Importance={Low:"Low",Medium:"Medium",High:"High"};sap.uxap.Utilities={getClosestOPL:function(c){while(c&&!(c instanceof sap.uxap.ObjectPageLayout)){c=c.getParent();}return c;},isPhoneScenario:function(r){if(a.system.phone){return true;}return sap.uxap.Utilities._isCurrentMediaSize("Phone",r);},isTabletScenario:function(r){return sap.uxap.Utilities._isCurrentMediaSize("Tablet",r);},_isCurrentMediaSize:function(m,r){return r&&r.name===m;}};return sap.uxap;});
sap.ui.require.preload({
	"sap/uxap/component/ObjectPageLayoutUXDrivenFactory.view.xml":'<core:View xmlns:core="sap.ui.core" xmlns="sap.uxap" height="100%" controllerName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory"><ObjectPageLayout id="ObjectPageLayout" subSectionLayout="{objectPageLayoutMetadata&gt;/subSectionLayout}" showAnchorBar="{objectPageLayoutMetadata&gt;/showAnchorBar}" height="{objectPageLayoutMetadata&gt;/height}" enableLazyLoading="{objectPageLayoutMetadata&gt;/enableLazyLoading}" sections="{objectPageLayoutMetadata&gt;/sections}" headerContent="{path:\'objectPageLayoutMetadata&gt;/headerContent\',factory:\'.controlFactory\'}" showAnchorBarPopover="{objectPageLayoutMetadata&gt;/showAnchorBarPopover}" upperCaseAnchorBar="{objectPageLayoutMetadata&gt;/upperCaseAnchorBar}" useIconTabBar="{objectPageLayoutMetadata&gt;/useIconTabBar}" showHeaderContent="{objectPageLayoutMetadata&gt;/showHeaderContent}" useTwoColumnsForLargeScreen="{objectPageLayoutMetadata&gt;/useTwoColumnsForLargeScreen}" showTitleInHeaderContent="{objectPageLayoutMetadata&gt;/showTitleInHeaderContent}" showOnlyHighImportance="{objectPageLayoutMetadata&gt;/showOnlyHighImportance}" isChildPage="{objectPageLayoutMetadata&gt;/isChildPage}" alwaysShowContentHeader="{objectPageLayoutMetadata&gt;/alwaysShowContentHeader}" showEditHeaderButton="{objectPageLayoutMetadata&gt;/showEditHeaderButton}"><sections><ObjectPageSection id="ObjectPageSection" title="{objectPageLayoutMetadata&gt;title}" importance="{objectPageLayoutMetadata&gt;importance}" showTitle="{objectPageLayoutMetadata&gt;showTitle}" subSections="{objectPageLayoutMetadata&gt;subSections}" visible="{objectPageLayoutMetadata&gt;visible}"><subSections><ObjectPageSubSection id="ObjectPageSubSection" title="{objectPageLayoutMetadata&gt;title}" visible="{objectPageLayoutMetadata&gt;visible}" mode="{objectPageLayoutMetadata&gt;mode}" importance="{objectPageLayoutMetadata&gt;importance}" actions="{path:\'objectPageLayoutMetadata&gt;actions\',factory:\'.controlFactory\'}" blocks="{path:\'objectPageLayoutMetadata&gt;blocks\',factory:\'.controlFactory\'}" moreBlocks="{path:\'objectPageLayoutMetadata&gt;moreBlocks\',factory:\'.controlFactory\'}"/></subSections></ObjectPageSection></sections></ObjectPageLayout></core:View>',
	"sap/uxap/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.uxap","type":"library","embeds":["component"],"applicationVersion":{"version":"1.58.2"},"title":"SAP UxAP","description":"SAP UxAP","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.58","libs":{"sap.ui.core":{"minVersion":"1.58.2"},"sap.m":{"minVersion":"1.58.2"},"sap.ui.layout":{"minVersion":"1.58.2"}}},"library":{"i18n":"messagebundle.properties","content":{"controls":["sap.uxap.AnchorBar","sap.uxap.BlockBase","sap.uxap.BreadCrumbs","sap.uxap.HierarchicalSelect","sap.uxap.ObjectPageHeader","sap.uxap.ObjectPageDynamicHeaderTitle","sap.uxap.ObjectPageDynamicHeaderContent","sap.uxap.ObjectPageHeaderActionButton","sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageLayout","sap.uxap.ObjectPageSection","sap.uxap.ObjectPageSectionBase","sap.uxap.ObjectPageSubSection"],"elements":["sap.uxap.ModelMapping","sap.uxap.ObjectPageHeaderLayoutData"],"types":["sap.uxap.BlockBaseColumnLayout","sap.uxap.ObjectPageConfigurationMode","sap.uxap.ObjectPageHeaderDesign","sap.uxap.ObjectPageHeaderPictureShape","sap.uxap.ObjectPageSubSectionLayout","sap.uxap.ObjectPageSubSectionMode"],"interfaces":["sap.uxap.IHeaderTitle","sap.uxap.IHeaderContent"]}}}}'
},"sap/uxap/library-preload"
);
//# sourceMappingURL=library-preload.js.map