/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./Dialog','./ComboBoxTextField','./Toolbar','./Button','./Bar','./Text','./Title','sap/ui/core/InvisibleText','sap/ui/core/IconPool','sap/ui/core/ValueStateSupport','sap/base/Log','./library','sap/ui/Device','sap/ui/core/library','./ComboBoxBaseRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/base/security/encodeXML"],function(D,C,T,B,a,b,c,I,d,V,L,l,e,f,g,h,K,q,j){"use strict";var P=l.PlacementType;var k=f.ValueState;var m=C.extend("sap.m.ComboBoxBase",{metadata:{library:"sap.m","abstract":true,defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"}},events:{loadItems:{}}}});m.DEFAULT_TEXT_FILTER=function(i,o,p){var s,n,M;if(!o[p]){return false;}s=o[p]().toLowerCase();n=i.toLowerCase();M=new RegExp("(\\b"+n+").*","gi");return M.test(s);};m.prototype.updateItems=function(r){this.bItemsUpdated=false;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;if(this.hasLoadItemsEventListeners()){this.onItemsLoaded();}};m.prototype.setFilterFunction=function(F){if(F===null||F===undefined){this.fnFilter=null;return this;}if(typeof(F)!=="function"){L.warning("Passed filter is not a function and the default implementation will be used");}else{this.fnFilter=F;}return this;};m.prototype.highLightList=function(v,i){var n=v.length,v=v.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,'\\$&'),r=new RegExp("\\b"+v,"gi"),$;i.forEach(function(o){$=q(o.ref);$.html(this._boldItemRef.call(this,o.text,r,n));},this);};m.prototype._boldItemRef=function(i,r,n){r.lastIndex=0;var R,o=r.exec(i);if(o===null){return j(i);}var M=o.index;var t="<b>"+j(i.slice(M,M+n))+"</b>";var p=i.split(r);if(p.length===1){R=j(i);}else{R=p.map(function(s){return j(s);}).join(t);}return R;};m.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items");};m.prototype.loadItems=function(i,o){var n=typeof i==="function";if(this.hasLoadItemsEventListeners()&&(this.getItems().length===0)){this._bOnItemsLoadedScheduled=false;if(n){o=q.extend({action:i,busyIndicator:true,busyIndicatorDelay:300},o);this.aMessageQueue.push(o);if((this.iLoadItemsEventInitialProcessingTimeoutID===-1)&&(o.busyIndicator)){this.iLoadItemsEventInitialProcessingTimeoutID=setTimeout(function onItemsNotLoadedAfterDelay(){this.setInternalBusyIndicatorDelay(0);this.setInternalBusyIndicator(true);}.bind(this),o.busyIndicatorDelay);}}if(!this.bProcessingLoadItemsEvent){this.bProcessingLoadItemsEvent=true;this.fireLoadItems();}}else if(n){i.call(this);}};m.prototype.onItemsLoaded=function(){this.bProcessingLoadItemsEvent=false;clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);if(this.bInitialBusyIndicatorState!==this.getBusy()){this.setInternalBusyIndicator(this.bInitialBusyIndicatorState);}if(this.iInitialBusyIndicatorDelay!==this.getBusyIndicatorDelay()){this.setInternalBusyIndicatorDelay(this.iInitialBusyIndicatorDelay);}for(var i=0,n,N,o;i<this.aMessageQueue.length;i++){n=this.aMessageQueue.shift();i--;o=(i+1)===this.aMessageQueue.length;N=o?null:this.aMessageQueue[i+1];if(typeof n.action==="function"){if((n.name==="input")&&!o&&(N.name==="input")){continue;}n.action.call(this);}}};m.prototype.hasLoadItemsEventListeners=function(){return this.hasListeners("loadItems");};m.prototype._scheduleOnItemsLoadedOnce=function(){if(!this._bOnItemsLoadedScheduled&&!this.isBound("items")&&this.hasLoadItemsEventListeners()&&this.bProcessingLoadItemsEvent){this._bOnItemsLoadedScheduled=true;setTimeout(this.onItemsLoaded.bind(this),0);}};m.prototype.getPickerInvisibleTextId=function(){return I.getStaticId("sap.m","COMBOBOX_AVAILABLE_OPTIONS");};m.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setPickerType(e.system.phone?"Dialog":"Dropdown");this.createPicker(this.getPickerType());this.bItemsUpdated=false;this.bOpenedByKeyboardOrButton=false;this._bShouldClosePicker=false;this._oPickerValueStateText=null;this.bProcessingLoadItemsEvent=false;this.iLoadItemsEventInitialProcessingTimeoutID=-1;this.aMessageQueue=[];this.bInitialBusyIndicatorState=this.getBusy();this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();this._bOnItemsLoadedScheduled=false;this._bDoTypeAhead=true;this.getIcon().addEventDelegate({onmousedown:function(E){this._bShouldClosePicker=this.isOpen();}},this);this.getIcon().attachPress(function(E){var p;if(!this.getEnabled()||!this.getEditable()){return;}if(this._bShouldClosePicker){this._bShouldClosePicker=false;this.close();return;}this.loadItems();this.bOpenedByKeyboardOrButton=true;if(this.isPlatformTablet()){p=this.getPicker();p.setInitialFocus(p);}this.open();},this);this.fnFilter=null;};m.prototype.onBeforeRendering=function(){var n=this.getValueState()===k.None;C.prototype.onBeforeRendering.apply(this,arguments);if(!this.isPickerDialog()&&n){this._showValueStateText(false);}};m.prototype.exit=function(){C.prototype.exit.apply(this,arguments);if(this.getList()){this.getList().destroy();this._oList=null;}if(this._oPickerValueStateText){this._oPickerValueStateText.destroy();}clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);this.aMessageQueue=null;this.fnFilter=null;};m.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(E.keyCode===K.F4){this.onF4(E);}if(this.isOpen()){this.close();return;}this.selectText(0,this.getValue().length);this.loadItems();this.bOpenedByKeyboardOrButton=true;this.open();};m.prototype.onF4=function(E){E.preventDefault();};m.prototype.onsapescape=function(E){if(this.getEnabled()&&this.getEditable()&&this.isOpen()){E.setMarked();E.preventDefault();this.close();}else{C.prototype.onsapescape.apply(this,arguments);}};m.prototype.onsaphide=m.prototype.onsapshow;m.prototype.onsapfocusleave=function(E){if(!E.relatedControlId){C.prototype.onsapfocusleave.apply(this,arguments);return;}var r=sap.ui.getCore().byId(E.relatedControlId);if(r===this){return;}var p=this.getAggregation("picker"),F=r&&r.getFocusDomRef();if(p&&h(p.getFocusDomRef(),F)){return;}C.prototype.onsapfocusleave.apply(this,arguments);};m.prototype.getPopupAnchorDomRef=function(){return this.getDomRef();};m.prototype.addContent=function(p){};m.prototype.getList=function(){if(this.bIsDestroyed){return null;}return this._oList;};m.prototype.setPickerType=function(p){this._sPickerType=p;};m.prototype.getPickerType=function(){return this._sPickerType;};m.prototype.setValueState=function(v){var A,s=this.getValueStateText(),S=(v===k.None?false:this.getShowValueStateMessage());this._sOldValueState=this.getValueState();C.prototype.setValueState.apply(this,arguments);this._showValueStateText(S);if(s){this._setValueStateText(s);}else{A=V.getAdditionalText(this);this._setValueStateText(A);}this._alignValueStateStyles();return this;};m.prototype.setValueStateText=function(t){C.prototype.setValueStateText.apply(this,arguments);this._setValueStateText(this.getValueStateText());return this;};m.prototype.setShowValueStateMessage=function(s){C.prototype.setShowValueStateMessage.apply(this,arguments);this._showValueStateText(this.getShowValueStateMessage());return this;};m.prototype._showValueStateText=function(s){var o;if(this.isPickerDialog()){if(this._oPickerValueStateText){this._oPickerValueStateText.setVisible(s);}}else{o=this._getPickerCustomHeader();if(o){o.setVisible(s);}}};m.prototype._setValueStateText=function(t){var H;if(this.isPickerDialog()){this._oPickerValueStateText=this.getPickerValueStateText();this._oPickerValueStateText.setText(t);}else{H=this._getPickerCustomHeader();if(H){H.getContentLeft()[0].setText(t);}}};m.prototype._getPickerCustomHeader=function(){var i,o,p=this.getPicker(),s=this.getRenderer().CSS_CLASS_COMBOBOXBASE+"PickerTitle";if(!p){return null;}if(p.getCustomHeader()){return p.getCustomHeader();}i=new c({textAlign:"Left"}).addStyleClass(s);o=new a({visible:false,contentLeft:i});p.setCustomHeader(o);return o;};m.prototype._alignValueStateStyles=function(){var o=this._sOldValueState,i=this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Picker",p=i+"ValueState",O=i+o+"State",s=i+this.getValueState()+"State",n;if(this.isPickerDialog()&&this._oPickerValueStateText){this._oPickerValueStateText.addStyleClass(p);this._oPickerValueStateText.removeStyleClass(O);this._oPickerValueStateText.addStyleClass(s);}else{n=this._getPickerCustomHeader();if(n){n.addStyleClass(p);n.removeStyleClass(O);n.addStyleClass(s);}}};m.prototype.shouldValueStateMessageBeOpened=function(){var s=C.prototype.shouldValueStateMessageBeOpened.apply(this,arguments);return(s&&!this.isOpen());};m.prototype.onPropertyChange=function(o,i){var n=o.getParameter("newValue"),p=o.getParameter("name"),M="set"+p.charAt(0).toUpperCase()+p.slice(1),r=(i&&i.srcControl)||this.getPickerTextField();if(/\bvalue\b|\benabled\b|\bname\b|\bplaceholder\b|\beditable\b|\btextAlign\b|\btextDirection\b|\bvalueState\b/.test(p)&&r&&(typeof r[M]==="function")){r[M](n);}};m.prototype.isPickerDialog=function(){return this.getPickerType()==="Dialog";};m.prototype.isPlatformTablet=function(){var n=!e.system.combi,t=e.system.tablet&&n;return t;};m.prototype.getDropdownSettings=function(){return{showArrow:false,placement:P.VerticalPreferredBottom,offsetX:0,offsetY:0,bounce:false,ariaLabelledBy:this.getPickerInvisibleTextId()||undefined};};m.prototype.getPickerValueStateText=function(){var p=this.getPicker();if(!this._oPickerValueStateText){this._oPickerValueStateText=new b({width:"100%"});p.insertContent(this._oPickerValueStateText,0);}return this._oPickerValueStateText;};m.prototype.createPicker=function(p){};m.prototype.onBeforeClose=function(){this.bOpenedByKeyboardOrButton=false;};m.prototype.getPicker=function(){if(this.bIsDestroyed){return null;}return this.createPicker(this.getPickerType());};m.prototype.getPickerTextField=function(){var p=this.getPicker(),s=p.getSubHeader();return s&&s.getContent()[0]||null;};m.prototype.getPickerTitle=function(){var p=this.getPicker(),H=p&&p.getCustomHeader();if(this.isPickerDialog()&&H){return H.getContentMiddle()[0];}return null;};m.prototype.createDialog=function(){var t=this,o=this.createPickerTextField(),i=o._handleEvent;o._handleEvent=function(E){i.apply(this,arguments);if(/keydown|sapdown|sapup|saphome|sapend|sappagedown|sappageup|input/.test(E.type)){t._handleEvent(E);}};return new D({stretch:true,customHeader:t.createPickerHeader(),buttons:this.createPickerCloseButton(),subHeader:new T({content:o}),beforeOpen:function(){t.updatePickerHeaderTitle();},ariaLabelledBy:t.getPickerInvisibleTextId()||undefined});};m.prototype.createPickerHeader=function(){var t=this,i=d.getIconURI("decline");return new a({contentMiddle:new c(),contentRight:new B({icon:i,press:function(){t.close();t.revertSelection();}})});};m.prototype.revertSelection=function(){};m.prototype.updatePickerHeaderTitle=function(){var p=this.getPicker(),r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),o,i;if(!p){return;}i=this.getLabels();if(i.length){o=i[0];if(o&&(typeof o.getText==="function")){this.getPickerTitle().setText(o.getText());}}else{this.getPickerTitle().setText(r.getText("COMBOBOX_PICKER_TITLE"));}};m.prototype.createPickerCloseButton=function(){var t=this,o,r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("COMBOBOX_CLOSE_BUTTON"),press:function(){o=t.getPickerTextField();t.updateDomValue(o.getValue());t.onChange();t.close();}});};m.prototype.hasContent=function(){return this.getItems().length>0;};m.prototype.findFirstEnabledItem=function(i){var o=this.getList();return o?o.findFirstEnabledItem(i):null;};m.prototype.findLastEnabledItem=function(i){var o=this.getList();return o?o.findLastEnabledItem(i):null;};m.prototype.open=function(){var p=this.getPicker();if(p){p.open();}return this;};m.prototype.getVisibleItems=function(){var o=this.getList();return o?o.getVisibleItems():[];};m.prototype.isItemSelected=function(){};m.prototype.getKeys=function(n){n=n||this.getItems();for(var i=0,o=[];i<n.length;i++){o[i]=n[i].getKey();}return o;};m.prototype.getSelectableItems=function(){var o=this.getList();return o?o.getSelectableItems():[];};m.prototype.findItem=function(p,v){var o=this.getList();return o?o.findItem(p,v):null;};m.prototype.getItemByText=function(t){return this.findItem("text",t);};m.prototype.scrollToItem=function(i){var p=this.getPicker(),o=p.getDomRef("cont"),n=i&&i.getDomRef();if(!p||!o||!n){return;}var r=o.scrollTop,s=n.offsetTop,t=o.clientHeight,u=n.offsetHeight;if(r>s){o.scrollTop=s;}else if((s+u)>(r+t)){o.scrollTop=Math.ceil(s+u-t);}};m.prototype.clearFilter=function(){for(var i=0,n=this.getItems();i<n.length;i++){n[i].bVisible=true;}};m.prototype.onItemChange=function(o){};m.prototype.clearSelection=function(){};m.prototype.setInternalBusyIndicator=function(i){this.bInitialBusyIndicatorState=this.getBusy();return this.setBusy.apply(this,arguments);};m.prototype.setInternalBusyIndicatorDelay=function(i){this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();return this.setBusyIndicatorDelay.apply(this,arguments);};m.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}this._scheduleOnItemsLoadedOnce();return this;};m.prototype.insertItem=function(i,n){this.insertAggregation("items",i,n,true);if(i){i.attachEvent("_change",this.onItemChange,this);}this._scheduleOnItemsLoadedOnce();return this;};m.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};m.prototype.getFirstItem=function(){return this.getItems()[0]||null;};m.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};m.prototype.getEnabledItems=function(i){var o=this.getList();return o?o.getEnabledItems(i):[];};m.prototype.getItemByKey=function(s){var o=this.getList();return o?o.getItemByKey(s):null;};m.prototype.isOpen=function(){var p=this.getAggregation("picker");return!!(p&&p.isOpen());};m.prototype.close=function(){var p=this.getAggregation("picker");if(p){p.close();}return this;};m.prototype.removeItem=function(i){var o=this.getList();i=o?o.removeItem(i):null;if(i){i.detachEvent("_change",this.onItemChange,this);}return i;};m.prototype.removeAllItems=function(){var o=this.getList(),n=o?o.removeAllItems():[];this.clearSelection();for(var i=0;i<n.length;i++){n[i].detachEvent("_change",this.onItemChange,this);}return n;};m.prototype.intersectItems=function(i,o){return i.filter(function(n){return o.map(function(O){return O.getId();}).indexOf(n.getId())!==-1;});};m.prototype.destroyItems=function(){var o=this.getList();if(o){o.destroyItems();}return this;};return m;});
