/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./Bar','./InstanceManager','./AssociativeOverflowToolbar','./ToolbarSpacer','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/Popup','sap/ui/core/delegate/ScrollEnablement','sap/ui/core/RenderManager','sap/ui/core/InvisibleText','sap/ui/core/ResizeHandler','sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/core/library','./TitlePropagationSupport','./DialogRenderer',"sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Focusable"],function(B,I,A,T,l,C,a,P,S,R,b,c,D,M,d,f,g,L,q){"use strict";var O=d.OpenState;var h=l.DialogType;var V=d.ValueState;var j=C.extend("sap.m.Dialog",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},title:{type:"string",group:"Appearance",defaultValue:null},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},type:{type:"sap.m.DialogType",group:"Appearance",defaultValue:h.Standard},state:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:V.None},stretchOnPhone:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},stretch:{type:"boolean",group:"Appearance",defaultValue:false},contentWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},horizontalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},verticalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},resizable:{type:"boolean",group:"Behavior",defaultValue:false},draggable:{type:"boolean",group:"Behavior",defaultValue:false},escapeHandler:{type:"any",group:"Behavior",defaultValue:null}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},subHeader:{type:"sap.m.IBar",multiple:false},customHeader:{type:"sap.m.IBar",multiple:false},beginButton:{type:"sap.m.Button",multiple:false},endButton:{type:"sap.m.Button",multiple:false},buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},_header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_title:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_icon:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_toolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_valueState:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{leftButton:{type:"sap.m.Button",multiple:false,deprecated:true},rightButton:{type:"sap.m.Button",multiple:false,deprecated:true},initialFocus:{type:"sap.ui.core.Control",multiple:false},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{beforeOpen:{},afterOpen:{},beforeClose:{parameters:{origin:{type:"sap.m.Button"}}},afterClose:{parameters:{origin:{type:"sap.m.Button"}}}},designtime:"sap/m/designtime/Dialog.designtime"}});f.call(j.prototype,"content",function(){return this._headerTitle?this._headerTitle.getId():false;});j._bPaddingByDefault=(sap.ui.getCore().getConfiguration().getCompatibilityVersion("sapMDialogWithPadding").compareTo("1.16")<0);j._mIcons={};j._mIcons[V.Success]=a.getIconURI("message-success");j._mIcons[V.Warning]=a.getIconURI("message-warning");j._mIcons[V.Error]=a.getIconURI("message-error");j.prototype.init=function(){var t=this;this._externalIcon=undefined;this._oManuallySetSize=null;this._oManuallySetPosition=null;this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._scrollContentList=["NavContainer","Page","ScrollContainer","SplitContainer","MultiInput"];this.oPopup=new P();this.oPopup.setShadow(true);this.oPopup.setNavigationMode("SCOPE");if(D.os.ios&&D.system.phone&&!this._bMessageType){this.oPopup.setModal(true,"sapMDialogTransparentBlk");}else{this.oPopup.setModal(true,"sapMDialogBlockLayerInit");}this.oPopup.setAnimations(q.proxy(this._openAnimation,this),q.proxy(this._closeAnimation,this));this.oPopup._applyPosition=function(p,F){var s;var e;t._setDimensions();t._adjustScrollingPane();p.at={};if(t._oManuallySetPosition){p.at.left=t._oManuallySetPosition.x;p.at.top=t._oManuallySetPosition.y;}else{if(window.scrollY===undefined){s=window.pageYOffset;}else{s=window.scrollY;}if(D.os.ios||s<0){s=0;}p.at.top='calc(50% + '+s+'px)';if(t._bRTL){p.at.left='auto';}else{if(window.scrollX===undefined){e=window.pageXOffset;}else{e=window.scrollX;}if(e<0){e=0;}p.at.left='calc(50% + '+e+'px)';}}t._deregisterContentResizeHandler();P.prototype._applyPosition.call(this,p);t._registerContentResizeHandler();};if(j._bPaddingByDefault){this.addStyleClass("sapUiPopupWithPadding");}this._initTitlePropagationSupport();};j.prototype.onBeforeRendering=function(){if(this._hasSingleScrollableContent()){this.setProperty("verticalScrolling",false);this.setProperty("horizontalScrolling",false);L.info("VerticalScrolling and horizontalScrolling in sap.m.Dialog with ID "+this.getId()+" has been disabled because there's scrollable content inside");}else if(!this._oScroller){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:this.getHorizontalScrolling(),vertical:this.getVerticalScrolling()});}this._createToolbarButtons();if(sap.ui.getCore().getConfiguration().getAccessibility()&&this.getState()!=V.None){var v=new b({text:this.getValueStateString(this.getState())});this.setAggregation("_valueState",v);this.addAriaLabelledBy(v.getId());}};j.prototype.onAfterRendering=function(){this._$scrollPane=this.$("scroll");this._$content=this.$("cont");this._$dialog=this.$();if(this.isOpen()){this._setInitialFocus();}if(this.getType()===h.Message){this.$("footer").removeClass("sapContrast sapContrastPlus");}};j.prototype.exit=function(){I.removeDialogInstance(this);this._deregisterContentResizeHandler();this._deregisterResizeHandler();if(this.oPopup){this.oPopup.detachOpened(this._handleOpened,this);this.oPopup.detachClosed(this._handleClosed,this);this.oPopup.destroy();this.oPopup=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._header){this._header.destroy();this._header=null;}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null;}if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}if(this._toolbarSpacer){this._toolbarSpacer.destroy();this._toolbarSpacer=null;}};j.prototype.open=function(){var p=this.oPopup;p.setInitialFocusId(this.getId());var o=p.getOpenState();switch(o){case O.OPEN:case O.OPENING:return this;case O.CLOSING:this._bOpenAfterClose=true;break;default:}this._oCloseTrigger=null;this.fireBeforeOpen();p.attachOpened(this._handleOpened,this);p.setContent(this);p.open();this._registerResizeHandler();I.addDialogInstance(this);return this;};j.prototype.close=function(){this._bOpenAfterClose=false;this.$().removeClass('sapDialogDisableTransition');this._deregisterResizeHandler();var p=this.oPopup;var e=this.oPopup.getOpenState();if(!(e===O.CLOSED||e===O.CLOSING)){l.closeKeyboard();this.fireBeforeClose({origin:this._oCloseTrigger});p.attachClosed(this._handleClosed,this);this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;p.close();this._deregisterContentResizeHandler();}return this;};j.prototype.isOpen=function(){return this.oPopup&&this.oPopup.isOpen();};j.prototype._handleOpened=function(){this.oPopup.detachOpened(this._handleOpened,this);this._setInitialFocus();this.fireAfterOpen();};j.prototype._handleClosed=function(){if(!this.oPopup){return;}this.oPopup.detachClosed(this._handleClosed,this);if(this.getDomRef()){R.preserveContent(this.getDomRef());this.$().remove();}I.removeDialogInstance(this);this.fireAfterClose({origin:this._oCloseTrigger});if(this._bOpenAfterClose){this._bOpenAfterClose=false;this.open();}};j.prototype.onfocusin=function(e){var s=e.target;if(s.id===this.getId()+"-firstfe"){var o=this.$("footer").lastFocusableDomRef()||this.$("cont").lastFocusableDomRef()||(this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef())||(this._getAnyHeader()&&this._getAnyHeader().$().lastFocusableDomRef());if(o){o.focus();}}else if(s.id===this.getId()+"-lastfe"){var F=(this._getAnyHeader()&&this._getAnyHeader().$().firstFocusableDomRef())||(this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef())||this.$("cont").firstFocusableDomRef()||this.$("footer").firstFocusableDomRef();if(F){F.focus();}}};j.prototype._getPromiseWrapper=function(){var t=this;return{reject:function(){t.currentPromise.reject();},resolve:function(){t.currentPromise.resolve();}};};j.prototype.onsapescape=function(e){var E=this.getEscapeHandler(),p={},t=this;if(e.originalEvent&&e.originalEvent._sapui_handledByControl){return;}this._oCloseTrigger=null;if(typeof E==='function'){new window.Promise(function(r,i){p.resolve=r;p.reject=i;t.currentPromise=p;E(t._getPromiseWrapper());}).then(function(r){t.close();}).catch(function(){L.info("Disallow dialog closing");});}else{this.close();}e.stopPropagation();};j.prototype._openAnimation=function(r,i,o){r.addClass("sapMDialogOpen");r.css("display","block");setTimeout(o,300);};j.prototype._closeAnimation=function(r,i,e){r.removeClass("sapMDialogOpen");setTimeout(e,300);};j.prototype._setDimensions=function(){var $=this.$(),s=this.getStretch(),e=this.getStretchOnPhone()&&D.system.phone,m=this._bMessageType,o={};if(!s){if(!this._oManuallySetSize){o.width=this.getContentWidth()||undefined;o.height=this.getContentHeight()||undefined;}else{o.width=this._oManuallySetSize.width;o.height=this._oManuallySetSize.height;}}if(o.width=='auto'){o.width=undefined;}if(o.height=='auto'){o.height=undefined;}if((s&&!m)||(e)){this.$().addClass('sapMDialogStretched');}$.css(o);if(!s&&!this._oManuallySetSize&&!this._bDisableRepositioning){this._applyCustomTranslate();}if(window.navigator.userAgent.toLowerCase().indexOf("chrome")!==-1&&this.getStretch()){$.find('> footer').css({bottom:'0.001px'});}};j.prototype._adjustScrollingPane=function(){if(this._oScroller){this._oScroller.refresh();}};j.prototype._reposition=function(){};j.prototype._repositionAfterOpen=function(){};j.prototype._reapplyPosition=function(){this._adjustScrollingPane();};j.prototype._onResize=function(){var $=this.$(),e=this.$('cont'),i=e[0].clientWidth,m,s=this.getContentHeight(),n=this.getContentWidth(),o,p=Math.floor(window.innerWidth*0.9),r=2,t=D.browser;if(this._oManuallySetSize){e.css({width:'auto'});return;}if(!s||s=='auto'){m=e.scrollTop();e.css({height:'auto'});o=parseFloat($.height())+r;e.height(Math.round(o));e.scrollTop(m);}if((t.internet_explorer||t.edge)&&(!n||n=='auto')&&!this.getStretch()&&i<e[0].scrollWidth&&e.width()<p){var v=e.width()-i;e.css({width:Math.min(e.width()+v,p)+"px"});}if(!this.getStretch()&&!this._oManuallySetSize&&!this._bDisableRepositioning){this._applyCustomTranslate();}if(D.browser.chrome){var F=this.$("footer");F.css("height","auto");setTimeout(function(){F.css("height","");},10);}};j.prototype._applyCustomTranslate=function(){var $=this.$(),t,s,i=$.innerWidth(),e=$.innerHeight();if(D.system.desktop&&(i%2!==0||e%2!==0)){if(!this._bRTL){t='-'+Math.floor(i/2)+"px";}else{t=Math.floor(i/2)+"px";}s='-'+Math.floor(e/2)+"px";var m='translate('+t+','+s+') scale(1) ';$.css('transform',m);$.css('-webkit-transform',m+' translateZ(0px)');}else{$.css('transform','');$.css('-webkit-transform','');}};j.prototype._createHeader=function(){if(!this._header){this._header=new B(this.getId()+"-header");this._header._setRootAccessibilityRole("heading");this.setAggregation("_header",this._header,false);}};j.prototype._hasSingleScrollableContent=function(){var e=this.getContent(),i;while(e.length===1&&e[0]instanceof sap.ui.core.mvc.View){e=e[0].getContent();}if(e.length===1){for(i=0;i<this._scrollContentList.length;i++){if(e[0]instanceof l[this._scrollContentList[i]]){return true;}}}return false;};j.prototype._initBlockLayerAnimation=function(){this.oPopup._hideBlockLayer=function(){var $=q("#sap-ui-blocklayer-popup");$.removeClass("sapMDialogTransparentBlk");P.prototype._hideBlockLayer.call(this);};};j.prototype._clearBlockLayerAnimation=function(){if(D.os.ios&&D.system.phone&&!this._bMessageType){delete this.oPopup._showBlockLayer;this.oPopup._hideBlockLayer=function(){var $=q("#sap-ui-blocklayer-popup");$.removeClass("sapMDialogTransparentBlk");P.prototype._hideBlockLayer.call(this);};}};j.prototype._getFocusId=function(){return this.getInitialFocus()||this._getFirstFocusableContentSubHeader()||this._getFirstFocusableContentElementId()||this._getFirstVisibleButtonId()||this.getId();};j.prototype._getFirstVisibleButtonId=function(){var o=this.getBeginButton(),e=this.getEndButton(),m=this.getButtons(),s="";if(o&&o.getVisible()){s=o.getId();}else if(e&&e.getVisible()){s=e.getId();}else if(m&&m.length>0){for(var i=0;i<m.length;i++){if(m[i].getVisible()){s=m[i].getId();break;}}}return s;};j.prototype._getFirstFocusableContentSubHeader=function(){var $=this.$().find('.sapMDialogSubHeader');var r;var F=$.firstFocusableDomRef();if(F){r=F.id;}return r;};j.prototype._getFirstFocusableContentElementId=function(){var r="";var $=this.$("cont");var F=$.firstFocusableDomRef();if(F){r=F.id;}return r;};j.prototype._setInitialFocus=function(){var F=this._getFocusId();var o=sap.ui.getCore().byId(F);var e;if(o){if(o.getVisible&&!o.getVisible()){this.focus();return;}e=o.getFocusDomRef();}e=e||((F?window.document.getElementById(F):null));if(!e){this.setInitialFocus("");e=sap.ui.getCore().byId(this._getFocusId());}if(!this.getInitialFocus()){this.setAssociation('initialFocus',e?e.id:this.getId(),true);}if(D.system.desktop||(e&&!/input|textarea|select/i.test(e.tagName))){if(e){e.focus();}}else{this.focus();}};j.prototype.getScrollDelegate=function(){return this._oScroller;};j.prototype._composeAggreNameInHeader=function(p){var H;if(p==="Begin"){H="contentLeft";}else if(p==="End"){H="contentRight";}else{H="content"+p;}return H;};j.prototype._isToolbarEmpty=function(){var e=this._oToolbar.getContent().filter(function(i){return i.getMetadata().getName()!=='sap.m.ToolbarSpacer';});return e.length===0;};j.prototype._setButton=function(o,p,s){return this;};j.prototype._getButton=function(p){var s=p.toLowerCase()+"Button",e="_o"+this._firstLetterUpperCase(p)+"Button";if(D.system.phone){return this.getAggregation(s,null,true);}else{return this[e];}};j.prototype._getButtonFromHeader=function(p){if(this._header){var H=this._composeAggreNameInHeader(this._firstLetterUpperCase(p)),e=this._header.getAggregation(H);return e&&e[0];}else{return null;}};j.prototype._firstLetterUpperCase=function(v){return v.charAt(0).toUpperCase()+v.slice(1);};j.prototype._getAnyHeader=function(){var o=this.getCustomHeader();if(o){return o._setRootAccessibilityRole("heading");}else{var s=this.getShowHeader();if(!s){return null;}this._createHeader();return this._header;}};j.prototype._deregisterResizeHandler=function(){if(this._resizeListenerId){c.deregister(this._resizeListenerId);this._resizeListenerId=null;}D.resize.detachHandler(this._onResize,this);};j.prototype._registerResizeHandler=function(){var _=this.$("scroll");this._resizeListenerId=c.register(_.get(0),q.proxy(this._onResize,this));D.resize.attachHandler(this._onResize,this);this._onResize();};j.prototype._deregisterContentResizeHandler=function(){if(this._sContentResizeListenerId){c.deregister(this._sContentResizeListenerId);this._sContentResizeListenerId=null;}};j.prototype._registerContentResizeHandler=function(){if(!this._sContentResizeListenerId){this._sContentResizeListenerId=c.register(this.getDomRef("scrollCont"),q.proxy(this._onResize,this));}this._onResize();};j.prototype._attachHandler=function(o){var t=this;if(!this._oButtonDelegate){this._oButtonDelegate={ontap:function(){t._oCloseTrigger=this;},onkeyup:function(){t._oCloseTrigger=this;},onkeydown:function(){t._oCloseTrigger=this;}};}if(o){o.addDelegate(this._oButtonDelegate,true,o);}};j.prototype._createToolbarButtons=function(){var t=this._getToolbar();var e=this.getButtons();var i=this.getBeginButton();var m=this.getEndButton(),n=this,o=[i,m];o.forEach(function(p){if(p&&n._oButtonDelegate){p.removeDelegate(n._oButtonDelegate);}});t.removeAllContent();if(!("_toolbarSpacer"in this)){this._toolbarSpacer=new T();}t.addContent(this._toolbarSpacer);o.forEach(function(p){n._attachHandler(p);});if(e&&e.length){e.forEach(function(p){t.addContent(p);});}else{if(i){t.addContent(i);}if(m){t.addContent(m);}}};j.prototype._getToolbar=function(){if(!this._oToolbar){this._oToolbar=new A(this.getId()+"-footer").addStyleClass("sapMTBNoBorders");if(D.system.phone){this._oToolbar._bForceRerenderOnResize=true;}this._oToolbar._isControlsInfoCached=function(){return false;};this.setAggregation("_toolbar",this._oToolbar);}return this._oToolbar;};j.prototype.getValueStateString=function(v){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");switch(v){case(V.Success):return r.getText("LIST_ITEM_STATE_SUCCESS");case(V.Warning):return r.getText("LIST_ITEM_STATE_WARNING");case(V.Error):return r.getText("LIST_ITEM_STATE_ERROR");default:return"";}};j.prototype.setSubHeader=function(o){this.setAggregation("subHeader",o);if(o){o.setVisible=function(i){this.$().toggleClass('sapMDialogWithSubHeader',i);o.setProperty("visible",i);}.bind(this);}return this;};j.prototype.setLeftButton=function(v){if(!(v instanceof sap.m.Button)){v=sap.ui.getCore().byId(v);}this.setBeginButton(v);return this.setAssociation("leftButton",v);};j.prototype.setRightButton=function(v){if(!(v instanceof sap.m.Button)){v=sap.ui.getCore().byId(v);}this.setEndButton(v);return this.setAssociation("rightButton",v);};j.prototype.getLeftButton=function(){var o=this.getBeginButton();return o?o.getId():null;};j.prototype.getRightButton=function(){var e=this.getEndButton();return e?e.getId():null;};j.prototype.getAggregation=function(s,o,p){var e=C.prototype.getAggregation.apply(this,Array.prototype.slice.call(arguments,0,2));if(s==='buttons'&&e.length===0){this.getBeginButton()&&e.push(this.getBeginButton());this.getEndButton()&&e.push(this.getEndButton());}return e;};j.prototype.getAriaLabelledBy=function(){var e=this._getAnyHeader(),i=this.getAssociation("ariaLabelledBy",[]).slice();var s=this.getSubHeader();if(s){i.unshift(s.getId());}if(e){i.unshift(e.getId());}return i;};j.prototype.setTitle=function(t){this.setProperty("title",t,true);if(this._headerTitle){this._headerTitle.setText(t);}else{this._headerTitle=new sap.m.Title(this.getId()+"-title",{text:t,level:"H2"}).addStyleClass("sapMDialogTitle");this._createHeader();this._header.addContentMiddle(this._headerTitle);}return this;};j.prototype.setState=function(s){var F={},$=this.$(),n;F[s]=true;this.setProperty("state",s,true);for(n in g._mStateClasses){$.toggleClass(g._mStateClasses[n],!!F[n]);}this.setIcon(j._mIcons[s],true);return this;};j.prototype.setIcon=function(i,e){if(!e){this._externalIcon=i;}else{if(this._externalIcon){i=this._externalIcon;}}if(i){if(i!==this.getIcon()){if(this._iconImage){this._iconImage.setSrc(i);}else{this._iconImage=a.createControlByURI({id:this.getId()+"-icon",src:i,useIconTooltip:false},sap.m.Image).addStyleClass("sapMDialogIcon");this._createHeader();this._header.insertAggregation("contentMiddle",this._iconImage,0);}}}else{var s=this.getState();if(!e&&s!==V.None){if(this._iconImage){this._iconImage.setSrc(j._mIcons[s]);}}else{if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}}}this.setProperty("icon",i,true);return this;};j.prototype.setType=function(t){var o=this.getType();if(o===t){return this;}this._bMessageType=(t===h.Message);return this.setProperty("type",t,false);};j.prototype.setStretch=function(s){this._bStretchSet=true;return this.setProperty("stretch",s);};j.prototype.setStretchOnPhone=function(s){if(this._bStretchSet){L.warning("sap.m.Dialog: stretchOnPhone property is deprecated. Setting stretchOnPhone property is ignored when there's already stretch property set.");return this;}this.setProperty("stretchOnPhone",s);return this.setProperty("stretch",s&&D.system.phone);};j.prototype.setVerticalScrolling=function(v){var o=this.getVerticalScrolling(),H=this._hasSingleScrollableContent();if(H){L.warning("sap.m.Dialog: property verticalScrolling automatically reset to false. See documentation.");v=false;}if(o===v){return this;}this.$().toggleClass("sapMDialogVerScrollDisabled",!v);this.setProperty("verticalScrolling",v);if(this._oScroller){this._oScroller.setVertical(v);}return this;};j.prototype.setHorizontalScrolling=function(v){var o=this.getHorizontalScrolling(),H=this._hasSingleScrollableContent();if(H){L.warning("sap.m.Dialog: property horizontalScrolling automatically reset to false. See documentation.");v=false;}if(o===v){return this;}this.$().toggleClass("sapMDialogHorScrollDisabled",!v);this.setProperty("horizontalScrolling",v);if(this._oScroller){this._oScroller.setHorizontal(v);}return this;};j.prototype.setInitialFocus=function(i){return this.setAssociation("initialFocus",i,true);};j.prototype.forceInvalidate=C.prototype.invalidate;j.prototype.invalidate=function(o){if(this.isOpen()){this.forceInvalidate(o);}};function k(e){var $=q(e);var o=$.control(0);if(!o||o.getMetadata().getInterfaces().indexOf("sap.m.IBar")>-1){return true;}return $.hasClass('sapMDialogTitle');}if(D.system.desktop){j.prototype.ondblclick=function(e){if(k(e.target)){var $=this.$('cont');this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;this.oPopup&&this.oPopup._applyPosition(this.oPopup._oLastPosition,true);this._$dialog.removeClass('sapMDialogTouched');$.css({height:'100%'});}};j.prototype.onmousedown=function(e){if(e.which===3){return;}if(this.getStretch()||(!this.getDraggable()&&!this.getResizable())){return;}var t;var i=this;var $=q(document);var m=q(e.target);var r=m.hasClass('sapMDialogResizeHandler')&&this.getResizable();var n=function(E){t=t?clearTimeout(t):setTimeout(function(){E();},0);};var w=window.innerWidth;var o=window.innerHeight;var p={x:e.pageX,y:e.pageY,width:i._$dialog.width(),height:i._$dialog.height(),outerHeight:i._$dialog.outerHeight(),offset:{x:e.offsetX?e.offsetX:e.originalEvent.layerX,y:e.offsetY?e.offsetY:e.originalEvent.layerY},position:{x:i._$dialog.offset().left,y:i._$dialog.offset().top}};function s(){var E=i.$(),F=i.$('cont'),G,H;$.off("mouseup mousemove");if(r){i._$dialog.removeClass('sapMDialogResizing');G=parseInt(E[0].style.height,10)||parseInt(E.height(),10);H=parseInt(E.css("border-top-width"),10)+parseInt(E.css("border-bottom-width"),10);F.height(G+H);}}if((k(e.target)&&this.getDraggable())||r){i._bDisableRepositioning=true;i._$dialog.addClass('sapDialogDisableTransition');i._$dialog.addClass('sapMDialogTouched');i._oManuallySetPosition={x:p.position.x,y:p.position.y};i._$dialog.css({left:Math.min(Math.max(0,i._oManuallySetPosition.x),w-p.width),top:Math.min(Math.max(0,i._oManuallySetPosition.y),o-p.height),width:p.width,height:p.height,transform:""});}if(k(e.target)&&this.getDraggable()){$.on("mousemove",function(E){if(E.buttons===0){s();return;}n(function(){i._bDisableRepositioning=true;i._oManuallySetPosition={x:E.pageX-e.pageX+p.position.x,y:E.pageY-e.pageY+p.position.y};i._$dialog.css({left:Math.min(Math.max(0,i._oManuallySetPosition.x),w-p.width),top:Math.min(Math.max(0,i._oManuallySetPosition.y),o-p.outerHeight),transform:""});});});}else if(r){i._$dialog.addClass('sapMDialogResizing');var u={};var v=parseInt(i._$dialog.css('min-width'),10);var x=p.x+p.width-v;var y=m.width()-e.offsetX;var z=m.height()-e.offsetY;$.on("mousemove",function(E){n(function(){i._bDisableRepositioning=true;i.$('cont').height('').width('');if(E.pageY+z>o){E.pageY=o-z;}if(E.pageX+y>w){E.pageX=w-y;}i._oManuallySetSize={width:p.width+E.pageX-p.x,height:p.height+E.pageY-p.y};if(i._bRTL){u.left=Math.min(Math.max(E.pageX,0),x);u.transform="";i._oManuallySetSize.width=p.width+p.x-Math.max(E.pageX,0);}u.width=i._oManuallySetSize.width;u.height=i._oManuallySetSize.height;i._$dialog.css(u);});});}else{return;}$.on("mouseup",s);e.preventDefault();e.stopPropagation();};}j.prototype._applyContextualSettings=function(){M.prototype._applyContextualSettings.call(this,M._defaultContextualSettings);};return j;});
