/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','sap/ui/core/library','sap/ui/Device','./TextRenderer'],function(l,C,c,D,T){"use strict";var a=c.TextAlign;var b=c.TextDirection;var d=C.extend("sap.m.Text",{metadata:{interfaces:["sap.ui.core.IShrinkable","sap.ui.core.IFormContent"],library:"sap.m",properties:{text:{type:"string",defaultValue:'',bindable:"bindable"},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:b.Inherit},wrapping:{type:"boolean",group:"Appearance",defaultValue:true},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:a.Begin},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxLines:{type:"int",group:"Appearance",defaultValue:null},renderWhitespace:{type:"boolean",group:"Appearance",defaultValue:false}},designtime:"sap/m/designtime/Text.designtime"}});d.prototype.normalLineHeight=1.2;d.prototype.cacheLineHeight=true;d.prototype.ellipsis='...';d.hasNativeLineClamp=(function(){return typeof document.documentElement.style.webkitLineClamp!="undefined"&&D.browser.chrome;})();d.setNodeValue=function(o,n){n=n||"";var e=o.childNodes;if(e.length===1&&e[0].nodeType===window.Node.TEXT_NODE){e[0].nodeValue=n;}else{o.textContent=n;}};d.prototype.setText=function(t){this.setProperty("text",t,true);var o=this.getTextDomRef();if(o){d.setNodeValue(o,this.getText(true));if(this.getWrapping()){if(t&&!/\s/.test(t)){this.$().addClass("sapMTextBreakWord");}else{this.$().removeClass("sapMTextBreakWord");}}}return this;};d.prototype.getText=function(n){var t=this.getProperty("text");if(n){return t.replace(/\r\n|\n\r|\r/g,"\n");}return t;};d.prototype.onAfterRendering=function(){if(this.getVisible()&&this.hasMaxLines()&&!this.canUseNativeLineClamp()){this.clampHeight();}};d.prototype.hasMaxLines=function(){return(this.getWrapping()&&this.getMaxLines()>1);};d.prototype.getTextDomRef=function(){if(!this.getVisible()){return null;}if(this.hasMaxLines()){return this.getDomRef("inner");}return this.getDomRef();};d.prototype.canUseNativeLineClamp=function(){if(!d.hasNativeLineClamp){return false;}if(this.getTextDirection()==b.RTL){return false;}if(this.getTextDirection()==b.Inherit&&sap.ui.getCore().getConfiguration().getRTL()){return false;}return true;};d.prototype.getLineHeight=function(o){if(this.cacheLineHeight&&this._fLineHeight){return this._fLineHeight;}o=o||this.getTextDomRef();if(!o){return 0;}var s=window.getComputedStyle(o),L=s.lineHeight,f;if(/px$/i.test(L)){f=parseFloat(L);}else if(/^normal$/i.test(L)){f=parseFloat(s.fontSize)*this.normalLineHeight;}else{f=parseFloat(s.fontSize)*parseFloat(L);}if(!D.browser.firefox){f=Math.floor(f);}if(this.cacheLineHeight&&f){this._fLineHeight=f;}return f;};d.prototype.getClampHeight=function(o){o=o||this.getTextDomRef();return this.getMaxLines()*this.getLineHeight(o);};d.prototype.clampHeight=function(o){o=o||this.getTextDomRef();if(!o){return 0;}var m=this.getClampHeight(o);if(m){o.style.maxHeight=m+"px";}return m;};d.prototype.clampText=function(o,s,e){o=o||this.getTextDomRef();if(!o){return;}var E;var t=this.getText(true);var m=this.getClampHeight(o);s=s||0;e=e||t.length;d.setNodeValue(o,t.slice(0,e));if(o.scrollHeight>m){var S=o.style,h=S.height,f=this.ellipsis,i=f.length;S.height=m+"px";while((e-s)>i){E=(s+e)>>1;d.setNodeValue(o,t.slice(0,E-i)+f);if(o.scrollHeight>m){e=E;}else{s=E;}}if(o.scrollHeight>m&&s>0){E=s;o.textContent=t.slice(0,E-i)+f;}S.height=h;}return E;};d.prototype.getAccessibilityInfo=function(){return{description:this.getText()};};return d;});
