/*!
* UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(['./library','sap/ui/core/Control','sap/ui/core/IconPool','./Toolbar','./CheckBox','./SearchField','./List','./StandardListItem','sap/ui/base/ManagedObject','sap/ui/base/EventProvider','sap/ui/Device','sap/ui/core/InvisibleText','./ViewSettingsDialogRenderer',"sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Focusable"],function(l,C,I,T,a,S,L,b,M,E,D,c,V,d,q){"use strict";var e=l.ListMode;var f=l.ListType;var g=l.StringFilterOperator;var h="-list-item";var m=C.extend("sap.m.ViewSettingsDialog",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Behavior",defaultValue:null},sortDescending:{type:"boolean",group:"Behavior",defaultValue:false},groupDescending:{type:"boolean",group:"Behavior",defaultValue:false},filterSearchOperator:{type:"sap.m.StringFilterOperator",group:"Behavior",defaultValue:g.StartsWith}},aggregations:{sortItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"sortItem",bindable:"bindable"},groupItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"groupItem",bindable:"bindable"},filterItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"filterItem",bindable:"bindable"},presetFilterItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"presetFilterItem",bindable:"bindable"},customTabs:{type:"sap.m.ViewSettingsCustomTab",multiple:true,singularName:"customTab",bindable:"bindable"}},associations:{selectedSortItem:{type:"sap.m.ViewSettingsItem",multiple:false},selectedGroupItem:{type:"sap.m.ViewSettingsItem",multiple:false},selectedPresetFilterItem:{type:"sap.m.ViewSettingsItem",multiple:false}},events:{confirm:{parameters:{sortItem:{type:"sap.m.ViewSettingsItem"},sortDescending:{type:"boolean"},groupItem:{type:"sap.m.ViewSettingsItem"},groupDescending:{type:"boolean"},presetFilterItem:{type:"sap.m.ViewSettingsItem"},filterItems:{type:"sap.m.ViewSettingsItem[]"},filterKeys:{type:"object",deprecated:true},filterCompoundKeys:{type:"object"},filterString:{type:"string"}}},cancel:{},resetFilters:{},filterDetailPageOpened:{parameters:{parentFilterItem:{type:"sap.m.ViewSettingsFilterItem"}}}}}});m.prototype.init=function(){this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._sDialogWidth="350px";this._sDialogHeight="434px";this._bAppendedToUIArea=false;this._showSubHeader=false;this._filterDetailList=undefined;this._vContentPage=-1;this._oContentItem=null;this._oPreviousState={};this._sCustomTabsButtonsIdPrefix='-custom-button-';this._sTitleLabelId=this.getId()+"-title";this._aggregationToListItems("sortItems",{text:{listProp:"title"},selected:{}},{type:f.Active},{mode:e.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(j){var k=j.getParameter('listItem'),y=this.getSortItems(),z=this._getVSItem(k),i;z.setProperty('selected',j.getParameter('selected'),true,false);this.setAssociation('selectedSortItem',z,true);for(i=0;i<y.length;i++){if(z!==y[i]){y[i].setProperty('selected',false,true,false);}}}.bind(this)});};m.prototype.exit=function(){this._rb=null;this._sDialogWidth=null;this._sDialogHeight=null;this._bAppendedToUIArea=null;this._showSubHeader=null;this._vContentPage=null;this._oContentItem=null;this._oPreviousState=null;this._sortContent=null;this._groupContent=null;this._filterContent=null;this._sCustomTabsButtonsIdPrefix=null;this._fnFilterSearchCallback=null;if(this._bAppendedToUIArea&&this._dialog){var i=sap.ui.getCore().getStaticAreaRef();i=sap.ui.getCore().getUIArea(i);i.removeContent(this._dialog,true);}if(this._dialog){this._dialog.destroy();this._dialog=null;}if(this._navContainer){this._navContainer.destroy();this._navContainer=null;}if(this._titleLabel){this._titleLabel.destroy();this._titleLabel=null;}if(this._page1){this._page1.destroy();this._page1=null;}if(this._header){this._header.destroy();this._header=null;}if(this._resetButton){this._resetButton.destroy();this._resetButton=null;}if(this._subHeader){this._subHeader.destroy();this._subHeader=null;}if(this._segmentedButton){this._segmentedButton.destroy();this._segmentedButton=null;}if(this._sortButton){this._sortButton.destroy();this._sortButton=null;}if(this._groupButton){this._groupButton.destroy();this._groupButton=null;}if(this._filterButton){this._filterButton.destroy();this._filterButton=null;}if(this._sortList){this._sortList.destroy();this._sortList=null;}if(this._ariaSortListInvisibleText){this._ariaSortListInvisibleText.destroy();this._ariaSortListInvisibleText=null;}if(this._sortOrderList){this._sortOrderList.destroy();this._sortOrderList=null;this._ariaSortOrderInvisibleText.destroy();this._ariaSortOrderInvisibleText=null;}if(this._oGroupingNoneItem){this._oGroupingNoneItem.destroy();this._oGroupingNoneItem=null;}if(this._groupList){this._groupList.destroy();this._groupList=null;this._ariaGroupListInvisibleText.destroy();this._ariaGroupListInvisibleText=null;}if(this._groupOrderList){this._groupOrderList.destroy();this._groupOrderList=null;this._ariaGroupOrderInvisibleText.destroy();this._ariaGroupOrderInvisibleText=null;}if(this._presetFilterList){this._presetFilterList.destroy();this._presetFilterList=null;}if(this._filterList){this._filterList.destroy();this._filterList=null;}if(this._page2){this._page2.destroy();this._page2=null;}if(this._detailTitleLabel){this._detailTitleLabel.destroy();this._detailTitleLabel=null;}if(this._filterDetailList){this._filterDetailList.destroy();this._filterDetailList=null;}if(this._oStringFilter){this._oStringFilter=null;}};m.prototype._aggregationToListItems=function(i,j,k,y){var z=this._getListType(i),B="_"+z+"List";if(!this.mToList){this.mToList={};}this.mToList[z]={"itemPropertyMap":j,"listItemOptions":k,"listOptions":y,"listName":B};};m.prototype._getListType=function(i){return i.replace('Items','');};m.prototype._createList=function(i){var j=this.getId()+"-"+i+"list",k=new L(j,this.mToList[i].listOptions);this[this.mToList[i].listName]=k;return k;};m.prototype._getList=function(i){if(!this.mToList||!this.mToList[i]){return;}return this[this.mToList[i].listName];};m.prototype._createListItem=function(i,j){var O=this.mToList[i].listItemOptions,k=this.mToList[i].itemPropertyMap,y;for(var P in k){if(k.hasOwnProperty(P)){y=k[P].listProp||P;O[y]=this._createListItemPropertyValue(i,P,j);}}return new b(O).data('item',j);};m.prototype._createListItemPropertyValue=function(i,P,j){var k=j.getMetadata().getAllProperties()[P].get(j),y=this.mToList[i].itemPropertyMap[P].fn;return y?y(k):k;};m.prototype._getListItem=function(i,j){var k=this._getList(i).getItems().filter(function(y){return y.data('item')===j;});return k.length?k[0]:null;};m.prototype._getVSItem=function(i){return i.data('item');};m.prototype.addCustomTab=function(i){var j=i.getId();if(j==='sort'||j==='filter'||j==='group'){throw'Id "'+j+'" is reserved and cannot be used as custom tab id.';}this.addAggregation('customTabs',i);return this;};m.prototype.invalidate=function(){if(this._dialog&&(!arguments[0]||arguments[0]&&arguments[0].getId()!==this.getId()+"-dialog")){this._dialog.invalidate(arguments);}};m.prototype.addStyleClass=function(){var i=this._getDialog();i.addStyleClass.apply(i,arguments);return this;};m.prototype.removeStyleClass=function(){var i=this._getDialog();i.removeStyleClass.apply(i,arguments);return this;};m.prototype.toggleStyleClass=function(){var i=this._getDialog();i.toggleStyleClass.apply(i,arguments);return this;};m.prototype.hasStyleClass=function(){var i=this._getDialog();return i.hasStyleClass.apply(i,arguments);};m.prototype.getDomRef=function(){if(this._dialog){return this._dialog.getDomRef.apply(this._dialog,arguments);}else{return null;}};m.prototype.setTitle=function(i){this._getTitleLabel().setText(i);this.setProperty("title",i,true);return this;};m.prototype.addAggregation=function(i,O,j){C.prototype.addAggregation.apply(this,arguments);var k=this._getListType(i);if(this.mToList[k]){var y=this._createListItem(k,O);var z=this._getList(k);if(!z){z=this._createList(k);}z.addItem(y);this._attachItemPropertyChange(k,O);}else{this._attachItemEventHandlers(i,O);}return this;};m.prototype.insertAggregation=function(i,O,j,k){C.prototype.insertAggregation.apply(this,arguments);var y=this._getListType(i);if(this.mToList[y]){var z=this._createListItem(y,O);var B=this._getList(y);if(!B){B=this._createList(y);}B.insertItem(z,j);this._attachItemPropertyChange(y,O);}else{this._attachItemEventHandlers(i,O);}return this;};m.prototype.removeAggregation=function(i,O,j){p.call(this,i,O);var R=C.prototype.removeAggregation.apply(this,arguments);var k=this._getListType(i);if(this.mToList[k]){var y=this._getListItem(k,R);var z=this._getList(k);var B=z.removeItem(y);B.destroy();this._detachItemPropertyChange(R);}return R;};m.prototype.removeAllAggregation=function(i,j){p.call(this);var R=C.prototype.removeAllAggregation.apply(this,arguments);var k=this._getListType(i);if(this.mToList[k]){var y=this._getList(k);if(y){var z=y.removeAllItems();z.forEach(function(B){B.destroy();});}R.forEach(function(B){this._detachItemPropertyChange(B);},this);}return R;};m.prototype.destroyAggregation=function(i,j){p.call(this);C.prototype.destroyAggregation.apply(this,arguments);var k=this._getListType(i);if(this.mToList[k]){var y=this._getList(k);if(y){y.destroyItems();}}return this;};m.prototype._detachItemPropertyChange=function(i){delete E.getEventList(i)["itemPropertyChanged"];};m.prototype._attachItemPropertyChange=function(i,j){j.attachEvent('itemPropertyChanged',function fnHandleItemPropertyChanged(k){var y,P,z,B,F,G;y=this._getListItem(i,j);P=k.getParameter('propertyKey');if(!this.mToList[i].itemPropertyMap[P]){return;}z=this.mToList[i].itemPropertyMap[P].listProp||P;B=k.getParameter('propertyValue');F=this.mToList[i].itemPropertyMap[P].fn;G=F?F(B):B;y.getMetadata().getAllProperties()[z].set(y,G);},this);};m.prototype._attachItemEventHandlers=function(i,O){if(i!=='groupItems'&&i!=='filterItems'){return this;}var j=i.replace('Items','');j=j.charAt(0).toUpperCase()+j.slice(1);O.attachEvent('itemPropertyChanged',function(i,k){if(i==='filterItems'&&k.getParameter('changedItem').getParent().getMetadata().getName()==='sap.m.ViewSettingsFilterItem'){if(k.getParameter('propertyKey')!=='selected'){if(this._vContentPage===3&&this._oContentItem){this._setFilterDetailTitle(this._oContentItem);this._initFilterDetailItems(this._oContentItem);}}else{if(this._filterDetailList){var y=this._filterDetailList.getItems();y.forEach(function(z){if(z.data('item').getId()===k.getParameter('changedItem').getId()){z.setSelected(k.getParameter('propertyValue'));}});this._updateSelectAllCheckBoxState();}}this._updateFilterCounters();}else{if(typeof this['_init'+j+'Content']==='function'){this['_init'+j+'Content']();}if(typeof this['_init'+j+'Items']==='function'){this['_init'+j+'Items']();}}}.bind(this,i));O.attachEvent('filterDetailItemsAggregationChange',function(k){if(this._vContentPage===3&&this._oContentItem){this._setFilterDetailTitle(this._oContentItem);this._initFilterDetailItems(this._oContentItem);}}.bind(this));return this;};m.prototype._setFilterDetailTitle=function(i){this._getDetailTitleLabel().setText(this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY")+" "+i.getText());};m.prototype.updateAggregation=function(i){C.prototype.updateAggregation.apply(this,arguments);if(i!=='groupItems'&&i!=='filterItems'){return this;}var j=i.replace('Items','');j=j.charAt(0).toUpperCase()+j.slice(1);if(typeof this['_init'+j+'Content']==='function'){this['_init'+j+'Content']();}if(typeof this['_init'+j+'Items']==='function'){this['_init'+j+'Items']();}};m.prototype.addSortItem=function(i){this.addAggregation("sortItems",i);if(i.getSelected()){this.setSelectedSortItem(i);}return this;};m.prototype.addGroupItem=function(i){this.addAggregation("groupItems",i);if(i.getSelected()){this.setSelectedGroupItem(i);}return this;};m.prototype.addPresetFilterItem=function(i){this.addAggregation("presetFilterItems",i);if(i.getSelected()){this.setSelectedPresetFilterItem(i);}return this;};m.prototype.setSelectedSortItem=function(j){var k=this.getSortItems(),i=0,y=o(j,k,"Could not set selected sort item. Item is not found: '"+j+"'");if(v(y)){for(i=0;i<k.length;i++){if(k[i].getId()!==y.getId()){k[i].setProperty('selected',false,true);}}if(y.getProperty('selected')!==true){y.setProperty('selected',true,true);}if(this._getDialog().isOpen()){this._updateListSelection(this._sortList,y);}this.setAssociation("selectedSortItem",y,true);}return this;};m.prototype.setSelectedGroupItem=function(j){var k=this.getGroupItems(),i=0,y=o(j,k,"Could not set selected group item. Item is not found: '"+j+"'");if(!y&&!j){y=this._oGroupingNoneItem;}if(v(y)){for(i=0;i<k.length;i++){k[i].setProperty('selected',false,true);}y.setProperty('selected',true,true);if(this._getDialog().isOpen()){this._updateListSelection(this._groupList,y);}this.setAssociation("selectedGroupItem",y,true);}return this;};m.prototype.setSelectedPresetFilterItem=function(j){var k=this.getPresetFilterItems(),i=0,y=o(j,k,"Could not set selected preset filter item. Item is not found: '"+j+"'");if(v(y)){for(i=0;i<k.length;i++){k[i].setProperty('selected',false,true);}y.setProperty('selected',true,true);this._clearSelectedFilters();this.setAssociation("selectedPresetFilterItem",y,true);}return this;};m.prototype.open=function(P){if(!this.getParent()&&!this._bAppendedToUIArea){var i=sap.ui.getCore().getStaticAreaRef();i=sap.ui.getCore().getUIArea(i);i.addContent(this._getDialog(),true);this._bAppendedToUIArea=true;}if(P&&this._vContentPage===3){setTimeout(this._getNavContainer()["to"].bind(this._getNavContainer(),this._getPage1().getId(),"show"),0);}this._initDialogContent(P);this._oPreviousState={sortItem:sap.ui.getCore().byId(this.getSelectedSortItem()),sortDescending:this.getSortDescending(),groupItem:sap.ui.getCore().byId(this.getSelectedGroupItem()),groupDescending:this.getGroupDescending(),presetFilterItem:sap.ui.getCore().byId(this.getSelectedPresetFilterItem()),filterKeys:this.getSelectedFilterKeys(),filterCompoundKeys:this.getSelectedFilterCompoundKeys(),navPage:this._getNavContainer().getCurrentPage(),contentPage:this._vContentPage,contentItem:this._oContentItem};if(D.system.desktop){this._getDialog().attachEventOnce("afterOpen",function(){var j=this._getNavContainer().getCurrentPage(),$;if(j){$=j.$("cont").firstFocusableDomRef();if($){if(q($).hasClass('sapMListUl')){var k=q($).find('.sapMLIB');k.length&&k[0].focus();return;}$.focus();}}},this);}this._getDialog().open();return this;};m.prototype.getSelectedFilterItems=function(){var k=[],F=this.getFilterItems(),y,z=true,i=0,j;for(;i<F.length;i++){if(F[i]instanceof sap.m.ViewSettingsCustomItem){if(F[i].getSelected()){k.push(F[i]);}}else if(F[i]instanceof sap.m.ViewSettingsFilterItem){y=F[i].getItems();z=F[i].getMultiSelect();for(j=0;j<y.length;j++){if(y[j].getSelected()){k.push(y[j]);if(!z){break;}}}}}return k;};m.prototype.getSelectedFilterString=function(){var F="",k,P=this.getSelectedPresetFilterItem(),y=this.getFilterItems(),z,B=true,i=0,j;if(P){F=this._rb.getText("VIEWSETTINGS_FILTERTEXT").concat(" "+sap.ui.getCore().byId(P).getText());}else{for(;i<y.length;i++){if(y[i]instanceof sap.m.ViewSettingsCustomItem){if(y[i].getSelected()){F+=y[i].getText()+", ";}}else if(y[i]instanceof sap.m.ViewSettingsFilterItem){z=y[i].getItems();B=y[i].getMultiSelect();k="";for(j=0;j<z.length;j++){if(z[j].getSelected()){k+=z[j].getText()+", ";if(!B){break;}}}k=k.substring(0,k.length-2);if(k){k=" ("+k+")";F+=y[i].getText()+k+", ";}}}F=F.substring(0,F.length-2);if(F){F=this._rb.getText("VIEWSETTINGS_FILTERTEXT").concat(" "+F);}}return F;};m.prototype.getSelectedFilterKeys=function(){var j={},k=this.getSelectedFilterItems(),i=0;for(;i<k.length;i++){j[k[i].getKey()]=k[i].getSelected();}return j;};m.prototype.getSelectedFilterCompoundKeys=function(){var j={},k=this.getSelectedFilterItems(),i,K,P,F;for(i=0;i<k.length;i++){F=k[i];if(F instanceof sap.m.ViewSettingsCustomItem){K=F.getKey();j[K]=F.getSelected();}else{K=F.getKey();P=F.getParent().getKey();if(!j[P]){j[P]={};}j[P][K]=F.getSelected();}}return j;};m.prototype.setSelectedFilterKeys=function(y){var F=this.getFilterItems(),z={},B,G,i,j,k;if(Object.keys(y).length){this._clearPresetFilter();}for(var K in y){B=null;if(y.hasOwnProperty(K)){for(i=0;i<F.length;i++){if(F[i]instanceof sap.m.ViewSettingsCustomItem){if(F[i].getKey()===K){B=F[i];F[i].setProperty('selected',y[K],true);}}else if(F[i]instanceof sap.m.ViewSettingsFilterItem){z=F[i].getItems();G=F[i].getMultiSelect();for(j=0;j<z.length;j++){if(z[j].getKey()===K){B=z[j];if(!G){for(k=0;k<z.length;k++){z[k].setProperty('selected',false,true);}}break;}}}if(B){break;}}if(B===null){d.warning('Cannot set state for key "'+K+'" because there is no filter with these keys');continue;}B.setProperty('selected',y[K],true);}}return this;};m.prototype.setSelectedFilterCompoundKeys=function(i){var F=this.getFilterItems();var G=function(F,H,K){if(!H.hasOwnProperty(K)){return;}var B=n(F,K);return B;};if(Object.keys(i).length){this._clearPresetFilter();}for(var P in i){var j=G(F,i,P);if(!j){d.warning('No filter with key "'+P);continue;}if(j instanceof sap.m.ViewSettingsCustomItem){j.setProperty('selected',i[P],true);}else if(j instanceof sap.m.ViewSettingsFilterItem){var k=i[P];var y=j.getItems();var z=j.getMultiSelect();for(var K in k){var B=G(y,k,K);if(!B){d.warning('No filter with key "'+K);continue;}if(!z){y.forEach(function(H){H.setProperty('selected',false,true);});}B.setProperty('selected',k[K],true);}}}return this;};m.prototype._getDialog=function(){var i=this;if(this._dialog===undefined){this._dialog=new sap.m.Dialog(this.getId()+"-dialog",{ariaLabelledBy:this._sTitleLabelId,showHeader:false,stretch:D.system.phone,verticalScrolling:true,horizontalScrolling:false,contentWidth:this._sDialogWidth,contentHeight:this._sDialogHeight,content:this._getNavContainer(),beginButton:new sap.m.Button(this.getId()+"-acceptbutton",{text:this._rb.getText("VIEWSETTINGS_ACCEPT")}).attachPress(this._onConfirm,this),endButton:new sap.m.Button(this.getId()+"-cancelbutton",{text:this._rb.getText("VIEWSETTINGS_CANCEL")}).attachPress(this._onCancel,this)}).addStyleClass("sapMVSD");this.addDependent(this._dialog);var j=this._dialog.onsapescape;this._dialog.onsapescape=function(k){if(j){j.call(i._dialog,k);}i._onCancel();};this._dialog.onsapentermodifiers=function(k){if(k.shiftKey&&!k.ctrlKey&&!k.altKey){i._pressBackButton();}};}return this._dialog;};m.prototype._getNavContainer=function(){if(this._navContainer===undefined){this._navContainer=new sap.m.NavContainer(this.getId()+'-navcontainer',{pages:[]});}return this._navContainer;};m.prototype._getTitleLabel=function(){if(this._titleLabel===undefined){this._titleLabel=new sap.m.Label(this._sTitleLabelId,{text:this._rb.getText("VIEWSETTINGS_TITLE")}).addStyleClass("sapMVSDTitle");}return this._titleLabel;};m.prototype._getResetButton=function(){var i=this;if(this._resetButton===undefined){this._resetButton=new sap.m.Button(this.getId()+"-resetbutton",{icon:I.getIconURI("clear-filter"),press:function(){i._onClearFilters();},tooltip:this._rb.getText("VIEWSETTINGS_CLEAR_FILTER_TOOLTIP")});}return this._resetButton;};m.prototype._getDetailTitleLabel=function(){if(this._detailTitleLabel===undefined){this._detailTitleLabel=new sap.m.Label(this.getId()+"-detailtitle",{text:this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY")}).addStyleClass("sapMVSDTitle");}return this._detailTitleLabel;};m.prototype._getHeader=function(){if(this._header===undefined){this._header=new sap.m.Bar({contentMiddle:[this._getTitleLabel()]}).addStyleClass("sapMVSDBar");}return this._header;};m.prototype._getSubHeader=function(){if(this._subHeader===undefined){this._subHeader=new sap.m.Bar({contentLeft:[this._getSegmentedButton()]}).addStyleClass("sapMVSDBar");}return this._subHeader;};m.prototype._getSegmentedButton=function(){var j=this,k=this.getCustomTabs(),y=k.length,i=0;if(this._segmentedButton===undefined){this._segmentedButton=new sap.m.SegmentedButton({select:function(z){var B=z.getParameter('id');if(B===j.getId()+"-sortbutton"){j._switchToPage(0);}else if(B===j.getId()+"-groupbutton"){j._switchToPage(1);}else if(B===j.getId()+"-filterbutton"){j._switchToPage(2);}else{for(i=0;i<y;i++){var F=k[i],G=j.getId()+j._sCustomTabsButtonsIdPrefix+F.getId();if(!j._isEmptyTab(F)&&B===G){j._switchToPage(F.getId());break;}}}d.info('press event segmented: '+z.getParameter('id'));}}).addStyleClass("sapMVSDSeg");this._segmentedButton._bPreventWidthRecalculationOnAfterRendering=true;}return this._segmentedButton;};m.prototype._getSortButton=function(){if(this._sortButton===undefined){this._sortButton=new sap.m.Button(this.getId()+"-sortbutton",{icon:I.getIconURI("sort"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_SORT")});}return this._sortButton;};m.prototype._getGroupButton=function(){if(this._groupButton===undefined){this._groupButton=new sap.m.Button(this.getId()+"-groupbutton",{icon:I.getIconURI("group-2"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_GROUP")});}return this._groupButton;};m.prototype._getFilterButton=function(){if(this._filterButton===undefined){this._filterButton=new sap.m.Button(this.getId()+"-filterbutton",{icon:I.getIconURI("filter"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_FILTER")});}return this._filterButton;};m.prototype._getPage1=function(i){if(this._page1===undefined&&!i){this._page1=new sap.m.Page(this.getId()+'-page1',{title:this._rb.getText("VIEWSETTINGS_TITLE"),customHeader:this._getHeader()});this._getNavContainer().addPage(this._page1);}return this._page1;};m.prototype._getPage2=function(){var i=this,j,B,k;if(this._page2===undefined){B=new sap.m.Button(this.getId()+"-backbutton",{icon:I.getIconURI("nav-back"),press:[this._pressBackButton,this]});k=new sap.m.Button(this.getId()+"-detailresetbutton",{icon:I.getIconURI("clear-filter"),press:function(){i._onClearFilters();},tooltip:this._rb.getText("VIEWSETTINGS_CLEAR_FILTER_TOOLTIP")});j=new sap.m.Bar({contentLeft:[B],contentMiddle:[this._getDetailTitleLabel()],contentRight:[k]}).addStyleClass("sapMVSDBar");this._page2=new sap.m.Page(this.getId()+'-page2',{title:this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY"),customHeader:j});this._getNavContainer().addPage(this._page2);}return this._page2;};m.prototype._initFilterDetailItems=function(k){var y;var z=k.getMultiSelect();var B=k.getItems();var F=this;if(this._filterDetailList){this._filterDetailList.destroy();}this._getPage2().removeAllAggregation('content');this._filterDetailList=new L({mode:(z?e.MultiSelect:e.SingleSelectLeft),includeItemInSelection:true,selectionChange:function(G){var H,J=G.getParameter("listItems"),K,i=0,N;F._clearPresetFilter();if(z){this._updateSelectAllCheckBoxState();}if(J.length>1&&z){K=k.getItems();for(;i<K.length;i++){for(var j=0;j<J.length;j++){if(K[i].getKey()===J[j].getCustomData()[0].getValue().getKey()){K[i].setProperty('selected',J[j].getSelected(),true);}}}}else{H=G.getParameter("listItem").data("item");if(!k.getMultiSelect()){K=k.getItems();for(;i<K.length;i++){if(K[i].getId()!==H.getId()){K[i].setProperty('selected',false,true);}}}N=G.getParameter("listItem").getSelected();if(H.getProperty('selected')!==N){H.setProperty('selected',N,true);}}}.bind(this)});for(var i=0;i<B.length;i++){y=new b({title:M.escapeSettingsValue(B[i].getText()),type:f.Active,selected:B[i].getSelected(),tooltip:B[i].getTooltip()}).data("item",B[i]);this._filterDetailList.addItem(y);}this._filterSearchField=this._getFilterSearchField(this._filterDetailList);this._getPage2().addContent(this._filterSearchField.addStyleClass('sapMVSDFilterSearchField'));this._getPage2().getCustomHeader().addStyleClass('sapMVSDBarWithSearch');if(z){this._selectAllCheckBox=this._createSelectAllCheckbox(B,this._filterDetailList);this._filterDetailList.setHeaderToolbar(new T({content:[this._selectAllCheckBox]}).addStyleClass('sapMVSDFilterHeaderToolbar'));}this._getPage2().addContent(this._filterDetailList);};m.prototype._initSortContent=function(){var i=this;if(this._sortContent){return;}this._vContentPage=-1;this._ariaSortOrderInvisibleText=new c(this.getId()+"-sortOrderLabel",{text:this._rb.getText("VIEWSETTINGS_SORT_DIRECTION").concat(":")});this._sortOrderList=new L(this.getId()+"-sortorderlist",{mode:e.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(j){i.setProperty('sortDescending',j.getParameter("listItem").data("item"),true);},ariaLabelledBy:this._ariaSortOrderInvisibleText}).addStyleClass("sapMVSDUpperList");this._sortOrderList.addItem(new b({title:this._rb.getText("VIEWSETTINGS_ASCENDING_ITEM")}).data("item",false).setSelected(true));this._sortOrderList.addItem(new b({title:this._rb.getText("VIEWSETTINGS_DESCENDING_ITEM")}).data("item",true));this._ariaSortListInvisibleText=new c(this.getId()+"-sortListLabel",{text:this._rb.getText("VIEWSETTINGS_TITLE_SORT").concat(":")});this._sortList.addAriaLabelledBy(this._ariaSortListInvisibleText);this._sortContent=[this._ariaSortOrderInvisibleText,this._sortOrderList,this._ariaSortListInvisibleText,this._sortList];};m.prototype._initGroupItems=function(){var i,H,G=this.getGroupItems();this._groupList.destroyItems();if(!!G.length){G.forEach(function(j){i=new b({id:j.getId()+h,title:M.escapeSettingsValue(j.getText()),type:f.Active,selected:j.getSelected(),tooltip:j.getTooltip()}).data("item",j);this._groupList.addItem(i);},this);if(!this._oGroupingNoneItem||this._oGroupingNoneItem.bIsDestroyed){H=!!this.getSelectedGroupItem();this._oGroupingNoneItem=new sap.m.ViewSettingsItem({text:this._rb.getText("VIEWSETTINGS_NONE_ITEM"),selected:!H,itemPropertyChanged:function(){this._initGroupContent();this._initGroupItems();}.bind(this)});!H&&this.setAssociation("selectedGroupItem",this._oGroupingNoneItem,true);}i=new b({id:this._oGroupingNoneItem.getId()+h,title:this._oGroupingNoneItem.getText(),type:f.Active,selected:this._oGroupingNoneItem.getSelected()}).data("item",this._oGroupingNoneItem);this._groupList.addItem(i);}};m.prototype._initGroupContent=function(){var i=this;if(this._groupContent){return;}this._vContentPage=-1;this._ariaGroupOrderInvisibleText=new c(this.getId()+"-groupOrderLabel",{text:this._rb.getText("VIEWSETTINGS_GROUP_DIRECTION").concat(":")});this._groupOrderList=new L(this.getId()+"-grouporderlist",{mode:e.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(j){i.setProperty('groupDescending',j.getParameter("listItem").data("item"),true);},ariaLabelledBy:this._ariaGroupOrderInvisibleText}).addStyleClass("sapMVSDUpperList");this._groupOrderList.addItem(new b({title:this._rb.getText("VIEWSETTINGS_ASCENDING_ITEM")}).data("item",false).setSelected(true));this._groupOrderList.addItem(new b({title:this._rb.getText("VIEWSETTINGS_DESCENDING_ITEM")}).data("item",true));this._ariaGroupListInvisibleText=new c(this.getId()+"-groupListLabel",{text:this._rb.getText("VIEWSETTINGS_TITLE_GROUP").concat(":")});this._groupList=new L(this.getId()+"-grouplist",{mode:e.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(j){var k=j.getParameter("listItem").data("item");i.setSelectedGroupItem(k);},ariaLabelledBy:this._ariaGroupListInvisibleText});this._groupContent=[this._ariaGroupOrderInvisibleText,this._groupOrderList,this._ariaGroupListInvisibleText,this._groupList];};m.prototype._initFilterItems=function(){var P,F,i,j=this;this._presetFilterList.destroyItems();P=this.getPresetFilterItems();if(P.length){P.forEach(function(k){i=new b({id:k.getId()+h,title:M.escapeSettingsValue(k.getText()),type:f.Active,selected:k.getSelected(),tooltip:k.getTooltip()}).data("item",k);this._presetFilterList.addItem(i);},this);}if(P.length){i=new b({id:this._presetFilterList.getId()+"-none"+h,title:this._rb.getText("VIEWSETTINGS_NONE_ITEM"),selected:!!this.getSelectedPresetFilterItem()});this._presetFilterList.addItem(i);}this._filterList.destroyItems();F=this.getFilterItems();if(F.length){F.forEach(function(k){i=new b({id:k.getId()+h,title:M.escapeSettingsValue(k.getText()),type:f.Active,tooltip:k.getTooltip(),press:(function(k){return function(y){if(j._navContainer.getCurrentPage().getId()!==j.getId()+'-page2'){j._switchToPage(3,k);j._prevSelectedFilterItem=this;setTimeout(j._navContainer["to"].bind(j._navContainer,j.getId()+'-page2',"slide"),0);}if(D.system.desktop&&j._filterDetailList&&j._filterDetailList.getItems()[0]){j._getNavContainer().attachEventOnce("afterNavigate",function(){j._filterDetailList.getItems()[0].focus();});}};}(k))}).data("item",k);this._filterList.addItem(i);},this);}};m.prototype._initFilterContent=function(){var i=this;if(this._filterContent){return;}this._vContentPage=-1;this._presetFilterList=new L(this.getId()+"-predefinedfilterlist",{mode:e.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(j){var k=j.getParameter("listItem").data("item");if(k){k.setProperty('selected',j.getParameter("listItem").getSelected(),true);}i.setAssociation("selectedPresetFilterItem",k,true);i._clearSelectedFilters();}}).addStyleClass("sapMVSDUpperList");this._filterList=new L(this.getId()+"-filterlist",{});this._filterContent=[this._presetFilterList,this._filterList];};m.prototype._initDialogContent=function(P){var i=!!this.getSortItems().length,G=!!this.getGroupItems().length,j=!!this.getPresetFilterItems().length,F=!!this.getFilterItems().length;if(i){this._initSortContent();}if(G){this._initGroupContent();this._initGroupItems();}if(j||F){this._initFilterContent();this._initFilterItems();}this._updateDialogState(P);this._updateListSelections();};m.prototype._getTabButton=function(i,B){var j=B+i.getId(),k=sap.ui.getCore().byId(j);if(k){return k;}else{return new sap.m.Button({id:j,icon:i.getIcon(),tooltip:i.getTooltip()});}};m.prototype._updateDialogState=function(P){var i=!!this.getSortItems().length,G=!!this.getGroupItems().length,j=!!this.getPresetFilterItems().length,F=!!this.getFilterItems().length,k=!!this.getCustomTabs().length,y=this._getSegmentedButton(),z=null,B=false,H={"sort":0,"group":1,"filter":2};y.removeAllButtons();if(this._filterContent){this._presetFilterList.setVisible(true);this._filterList.setVisible(true);}if(i){y.addButton(this._getSortButton());}if(j||F){y.addButton(this._getFilterButton());if(!j){this._presetFilterList.setVisible(false);this._presetFilterList.addStyleClass("sapMVSDUpperList");}if(!F){this._filterList.setVisible(false);this._presetFilterList.removeStyleClass("sapMVSDUpperList");}}if(G){y.addButton(this._getGroupButton());}if(k){this.getCustomTabs().forEach(function(K){if(!this._isEmptyTab(K)){var N=this.getId()+this._sCustomTabsButtonsIdPrefix,O=this._getTabButton(K,N);y.addButton(O);}}.bind(this));}this._showSubHeader=this._hasSubHeader();if(P===undefined&&this._vContentPage!==-1){P=this._vContentPage;switch(P){case 0:P='sort';break;case 1:P='group';break;case 2:P='filter';break;}}if(P===this._vContentPage&&this._vContentPage===3){this._vContentPage=-1;this._switchToPage(3,this._oContentItem);}else{P=this._determineValidPageId(P);for(var J in H){if(P===J){B=true;z=this.getId()+'-'+P+'button';P=H[J];break;}}if(!B){z=this.getId()+this._sCustomTabsButtonsIdPrefix+P;}this._getSegmentedButton().setSelectedButton(z);this._switchToPage(P);if(this._getNavContainer().getCurrentPage()!==this._getPage1()){this._getNavContainer().to(this._getPage1().getId());}}};m.prototype._determineValidPageId=function(P){var i='sort',H=false,j=[];j=this._fetchValidPagesIds();if(j.length){i=j[0];}else{d.warning('No available pages to load - missing items.');}if(!P){P=i;}else{j.filter(function(k){if(k===P){H=true;return false;}return true;});if(!H){P=i;}}return P;};m.prototype._fetchValidPagesIds=function(){var i,j=this.getCustomTabs(),k=j.length,y=[];var P=['sort','filter','group'];P.forEach(function(B){if(this._isValidPredefinedPageId(B)){y.push(B);}},this);for(i=0;i<k;i++){var z=j[i];if(!this._isEmptyTab(z)){y.push(z.getId());}}return y;};m.prototype._isEmptyTab=function(i){return!(i.getContent().length||this._vContentPage===i.getId()&&this._getPage1().getContent().length);};m.prototype._isValidPredefinedPageId=function(N){if(!N){d.warning('Missing mandatory parameter.');return false;}var H=false;switch(N){case'sort':H=!!this.getSortItems().length;break;case'filter':H=!!this.getFilterItems().length||!!this.getPresetFilterItems().length;break;case'group':H=!!this.getGroupItems().length;break;}return H;};m.prototype._pressBackButton=function(){var i=this;if(this._vContentPage===3){this._updateFilterCounters();this._getNavContainer().attachEvent("afterNavigate",function(){if(i._prevSelectedFilterItem){i._prevSelectedFilterItem.focus();}});setTimeout(this._getNavContainer()['back'].bind(this._getNavContainer()),0);this._switchToPage(2);this._segmentedButton.setSelectedButton(this._filterButton);}};m.prototype.setModel=function(i,N){if(this._vContentPage===3&&this._oContentItem){r.call(this);}return M.prototype.setModel.call(this,i,N);};m.prototype.removeFilterItem=function(F){var i="";if(this._vContentPage===3&&this._oContentItem){if(typeof(F)==="object"){i=F.getId();}else if(typeof(F)==="string"){i=F;}else if(typeof(F)==="number"){i=this.getFilterItems()[F].getId();}if(this._oContentItem.getId()===i){r.call(this);}}return this.removeAggregation('filterItems',F);};m.prototype.removeAllFilterItems=function(){if(this._vContentPage===3&&this._oContentItem){r.call(this);}return this.removeAllAggregation('filterItems');};m.prototype.setFilterSearchCallback=function(i){this._fnFilterSearchCallback=i;return this;};m.prototype._switchToPage=function(W,j){var i=0,k=this._getTitleLabel(),R=this._getResetButton(),H=this._getHeader(),y=this._getSubHeader();if(this._vContentPage===W&&W!==3){if(H.getContentRight().length===0&&y.getContentRight().length===0){this._addResetButtonToPage1();}return false;}this._getPage2().getCustomHeader().removeStyleClass('sapMVSDBarWithSearch');if(s.call(this)){p.call(this);}H.removeAllContentRight();y.removeAllContentRight();this._vContentPage=W;this._oContentItem=j;if(W!==3){this._getPage1().removeAllAggregation("content",true);this._addResetButtonToPage1();}else if(W===3){this._getPage2().removeAllAggregation("content",true);}if(this.getTitle()){k.setText(this.getTitle());}else{k.setText(this._rb.getText("VIEWSETTINGS_TITLE"));}switch(W){case 1:R.setVisible(false);if(!this._showSubHeader&&!this.getTitle()){k.setText(this._rb.getText("VIEWSETTINGS_TITLE_GROUP"));}for(;i<this._groupContent.length;i++){this._getPage1().addContent(this._groupContent[i]);}break;case 2:R.setVisible(!!this.getFilterItems().length);if(!this._showSubHeader&&!this.getTitle()){k.setText(this._rb.getText("VIEWSETTINGS_TITLE_FILTER"));}this._updateListSelection(this._presetFilterList,sap.ui.getCore().byId(this.getSelectedPresetFilterItem()));this._updateFilterCounters();for(;i<this._filterContent.length;i++){this._getPage1().addContent(this._filterContent[i]);}break;case 3:this._setFilterDetailTitle(j);if(j instanceof sap.m.ViewSettingsCustomItem&&j.getCustomControl()){this._clearPresetFilter();this._getPage2().addContent(j.getCustomControl());}else if(j instanceof sap.m.ViewSettingsFilterItem&&j.getItems()){this._initFilterDetailItems(j);}break;case 0:R.setVisible(false);if(!this._getPage1().getSubHeader()&&!this.getTitle()){k.setText(this._rb.getText("VIEWSETTINGS_TITLE_SORT"));}if(this._sortContent){for(;i<this._sortContent.length;i++){this._getPage1().addContent(this._sortContent[i]);}}break;default:R.setVisible(false);this._getPage1().removeAllAggregation("content",true);var z="VIEWSETTINGS_TITLE";var B=this.getCustomTabs();if(B.length<2){z=B[0].getTitle();}if(!this._getPage1().getSubHeader()&&!this.getTitle()){k.setText(z);}B.forEach(function(F){if(F.getId()===W){F.getContent().forEach(function(G){this._getPage1().addContent(G);},this);}},this);break;}if(W===3){this.fireFilterDetailPageOpened({parentFilterItem:j});}};m.prototype._createSelectAllCheckbox=function(F,i){var j=false;if(F&&F.length!==0){j=F.every(function(y){return y.getSelected();});}var k=new a({text:this._rb.getText("COLUMNSPANEL_SELECT_ALL"),selected:j,select:function(y){var z=y.getParameter('selected');i.getItems().filter(function(B){return B.getVisible();}).forEach(function(B){var G=B.data("item");G.setSelected(z);});}});return k;};m.prototype._updateSelectAllCheckBoxState=function(){var i=false,j=this._filterDetailList.getItems(),k=[];if(!this._selectAllCheckBox){return;}if(j&&j.length!==0){k=j.filter(function(y){return y.getVisible();});}if(k.length!==0){i=k.every(function(y){return y.getSelected();});}this._selectAllCheckBox.setSelected(i);};m.prototype._getFilterSearchField=function(F){var i=this,j=new S({liveChange:function(k){var Q=k.getParameter('newValue'),y=i._getStringFilter();F.getItems().forEach(function(z){var B=y(Q,z.getTitle());z.setVisible(B);});i._updateSelectAllCheckBoxState();}});return j;};m.prototype._getStringFilter=function(){if(this._fnFilterSearchCallback){return this._fnFilterSearchCallback;}if(!this._oStringFilter||this._oStringFilter.sOperator!==this.getFilterSearchOperator()){this._oStringFilter=new t(this.getFilterSearchOperator());}return this._oStringFilter.filter.bind(this._oStringFilter);};m.prototype._updateListSelections=function(){this._updateListSelection(this._sortList,sap.ui.getCore().byId(this.getSelectedSortItem()));this._updateListSelection(this._sortOrderList,this.getSortDescending());this._updateListSelection(this._groupList,sap.ui.getCore().byId(this.getSelectedGroupItem()));this._updateListSelection(this._groupOrderList,this.getGroupDescending());this._updateListSelection(this._presetFilterList,sap.ui.getCore().byId(this.getSelectedPresetFilterItem()));this._updateFilterCounters();};m.prototype._updateListSelection=function(j,k){var y,i=0;if(!j){return false;}y=j.getItems();j.removeSelections();for(;i<y.length;i++){if(y[i].data("item")===k||y[i].data("item")===null){j.setSelectedItem(y[i],(k&&k.getSelected?k.getSelected():true));return true;}}return false;};m.prototype._updateFilterCounters=function(){var k=(this._filterList?this._filterList.getItems():[]),y,z,F=0,i=0,j;for(;i<k.length;i++){y=k[i].data("item");F=0;if(y){if(y instanceof sap.m.ViewSettingsCustomItem){F=y.getFilterCount();}else if(y instanceof sap.m.ViewSettingsFilterItem){F=0;z=y.getItems();for(j=0;j<z.length;j++){if(z[j].getSelected()){F++;}}}}k[i].setCounter(F);}};m.prototype._clearSelectedFilters=function(){var k=this.getFilterItems(),y,i=0,j;for(;i<k.length;i++){if(k[i]instanceof sap.m.ViewSettingsFilterItem){y=k[i].getItems();for(j=0;j<y.length;j++){y[j].setProperty('selected',false,true);}}k[i].setProperty('selected',false,true);}if(this._vContentPage===2&&this._getDialog().isOpen()){this._updateFilterCounters();}};m.prototype._clearPresetFilter=function(){if(this.getSelectedPresetFilterItem()){this.setSelectedPresetFilterItem(null);}};m.prototype._calculateNumberOfPages=function(){var i=0,j=!!this.getSortItems().length,G=!!this.getGroupItems().length,P=!!this.getPresetFilterItems().length,F=!!this.getFilterItems().length;if(j){i++;}if(P||F){i++;}if(G){i++;}this.getCustomTabs().forEach(function(k){if(!this._isEmptyTab(k)){i++;}},this);return i;};m.prototype._hasSubHeader=function(){return!(this._calculateNumberOfPages()<2);};function r(){this._vContentPage=2;this._oContentItem=null;this._navContainer.to(this._getPage1().getId(),"show");}function n(j,k){var i,y;for(i=0;i<j.length;i++){if(j[i].getKey()===k){y=j[i];break;}}return y;}function o(i,j,k){var y;if(typeof i==="string"){y=n(j,i);if(!y){d.error(k);}}else{y=i;}return y;}function v(i){return i&&i instanceof sap.m.ViewSettingsItem;}m.prototype._onConfirm=function(i){var j=this._getDialog(),k=this,y=function(){var z,G,B=k.getSelectedGroupItem();if(!k._oGroupingNoneItem||B!=k._oGroupingNoneItem.getId()){G=sap.ui.getCore().byId(B);}z={sortItem:sap.ui.getCore().byId(k.getSelectedSortItem()),sortDescending:k.getSortDescending(),groupItem:G,groupDescending:k.getGroupDescending(),presetFilterItem:sap.ui.getCore().byId(k.getSelectedPresetFilterItem()),filterItems:k.getSelectedFilterItems(),filterKeys:k.getSelectedFilterKeys(),filterCompoundKeys:k.getSelectedFilterCompoundKeys(),filterString:k.getSelectedFilterString()};k._dialog.detachAfterClose(y);k.fireConfirm(z);};j.attachAfterClose(y);j.close();};m.prototype._onCancel=function(i){var j=this,k=this._getDialog(),y=function(){j.setSelectedSortItem(j._oPreviousState.sortItem);j.setSortDescending(j._oPreviousState.sortDescending);j.setSelectedGroupItem(j._oPreviousState.groupItem);j.setGroupDescending(j._oPreviousState.groupDescending);j.setSelectedPresetFilterItem(j._oPreviousState.presetFilterItem);j._clearSelectedFilters();j.setSelectedFilterCompoundKeys(j._oPreviousState.filterCompoundKeys);if(j._navContainer.getCurrentPage()!==j._oPreviousState.navPage){setTimeout(j._navContainer["to"].bind(j._navContainer,j._oPreviousState.navPage.getId(),"show"),0);}j._switchToPage(j._oPreviousState.contentPage,j._oPreviousState.contentItem);j._dialog.detachAfterClose(y);j.fireCancel();};k.attachAfterClose(y);k.close();};m.prototype._onClearFilters=function(){this._clearSelectedFilters();this._clearPresetFilter();this.fireResetFilters();this._updateFilterCounters();if(this._vContentPage===3){setTimeout(this._getNavContainer()['to'].bind(this._getNavContainer(),this._getPage1().getId()),0);this._switchToPage(2);this._getSegmentedButton().setSelectedButton(this._getFilterButton());}this._updateListSelection(this._presetFilterList,sap.ui.getCore().byId(this.getSelectedPresetFilterItem()));};m.prototype._addResetButtonToPage1=function(){var H=this._getHeader(),i=this._getSubHeader(),R=this._getResetButton();if(this._showSubHeader){if(!this._getPage1().getSubHeader()){this._getPage1().setSubHeader(i);}i.addContentRight(R);}else{if(this._getPage1().getSubHeader()){this._getPage1().setSubHeader();}H.addContentRight(R);}};m.prototype._applyContextualSettings=function(){M.prototype._applyContextualSettings.call(this,M._defaultContextualSettings);};function p(i,j){if(!this._getPage1(true)){return;}if(i==='customTabs'&&j){if(j.getMetadata().getName()===this.getMetadata().getManagedAggregation(i).type&&this._vContentPage===j.getId()){var P=this._getPage1().getContent();P.forEach(function(k){j.addAggregation('content',k,true);});}}else if(!i&&!j){var P=this._getPage1().getContent();this.getCustomTabs().forEach(function(j){if(this._vContentPage===j.getId()){P.forEach(function(k){j.addAggregation('content',k,true);});}},this);}}function s(){var P=[-1,0,1,2,3];return(this._getPage1().getContent().length&&P.indexOf(this._vContentPage)===-1);}m.prototype.setBusy=function(B){this._getDialog().setBusy(B);return this;};var t=function(O){this.sOperator=O||g.StartsWith;switch(this.sOperator){case g.Equals:this.fnOperator=u;break;case g.Contains:this.fnOperator=w;break;case g.StartsWith:this.fnOperator=x;break;case g.AnyWordStartsWith:this.fnOperator=A;break;default:d.warning("Unknown string compare operator. Use values from sap.m.StringFilterOperator. Default operator should be used.");this.fnOperator=w;break;}};t.prototype.filter=function(Q,i){if(!Q){return true;}if(!i){return false;}i=i.toLowerCase();Q=Q.toLowerCase();return this.fnOperator(Q,i);};function u(Q,i){return i===Q;}function w(Q,i){return i.indexOf(Q)>-1;}function x(Q,i){return i.indexOf(Q)===0;}function A(Q,i){var j=new RegExp(".*\\b"+Q+".*");return j.test(i);}return m;});
