ace.define("ace/keyboard/vim",["require","exports","module","ace/range","ace/lib/event_emitter","ace/lib/dom","ace/lib/oop","ace/lib/keys","ace/lib/event","ace/search","ace/lib/useragent","ace/search_highlight","ace/commands/multi_select_commands","ace/mode/text","ace/multi_select"],function(g,l,q){'use strict';function t(){var d="";function a(p){if(typeof p!="object")return p+"";if("line"in p){return p.line+":"+p.ch;}if("anchor"in p){return a(p.anchor)+"->"+a(p.head);}if(Array.isArray(p))return"["+p.map(function(x){return a(x);})+"]";return JSON.stringify(p);}for(var i=0;i<arguments.length;i++){var p=arguments[i];var f=a(p);d+=f+"  ";}console.log(d);}var R=g("../range").Range;var E=g("../lib/event_emitter").EventEmitter;var u=g("../lib/dom");var z=g("../lib/oop");var K=g("../lib/keys");var A=g("../lib/event");var S=g("../search").Search;var B=g("../lib/useragent");var C=g("../search_highlight").SearchHighlight;var D=g("../commands/multi_select_commands");var T=g("../mode/text").Mode.prototype.tokenRe;g("../multi_select");var F=function(a){this.ace=a;this.state={};this.marks={};this.$uid=0;this.onChange=this.onChange.bind(this);this.onSelectionChange=this.onSelectionChange.bind(this);this.onBeforeEndOperation=this.onBeforeEndOperation.bind(this);this.ace.on('change',this.onChange);this.ace.on('changeSelection',this.onSelectionChange);this.ace.on('beforeEndOperation',this.onBeforeEndOperation);};F.Pos=function(a,c){if(!(this instanceof P))return new P(a,c);this.line=a;this.ch=c;};F.defineOption=function(n,v,s){};F.commands={redo:function(c){c.ace.redo();},undo:function(c){c.ace.undo();},newlineAndIndent:function(c){c.ace.insert("\n");}};F.keyMap={};F.addClass=F.rmClass=F.e_stop=function(){};F.keyName=function(e){if(e.key)return e.key;var k=(K[e.keyCode]||"");if(k.length==1)k=k.toUpperCase();k=A.getModifierString(e).replace(/(^|-)\w/g,function(m){return m.toUpperCase();})+k;return k;};F.keyMap['default']=function(k){return function(c){var a=c.ace.commands.commandKeyBinding[k.toLowerCase()];return a&&c.ace.execCommand(a)!==false;};};F.lookupKey=function y3(k,m,h){if(typeof m=="string")m=F.keyMap[m];var f=typeof m=="function"?m(k):m[k];if(f===false)return"nothing";if(f==="...")return"multi";if(f!=null&&h(f))return"handled";if(m.fallthrough){if(!Array.isArray(m.fallthrough))return y3(k,m.fallthrough,h);for(var i=0;i<m.fallthrough.length;i++){var r=y3(k,m.fallthrough[i],h);if(r)return r;}}};F.signal=function(o,n,e){return o._signal(n,e)};F.on=A.addListener;F.off=A.removeListener;F.isWordChar=function(c){if(c<"\x7f")return/^\w$/.test(c);T.lastIndex=0;return T.test(c);};(function(){z.implement(F.prototype,E);this.destroy=function(){this.ace.off('change',this.onChange);this.ace.off('changeSelection',this.onSelectionChange);this.ace.off('beforeEndOperation',this.onBeforeEndOperation);this.removeOverlay();};this.virtualSelectionMode=function(){return this.ace.inVirtualSelectionMode&&this.ace.selection.index;};this.onChange=function(d){var a={text:d.action[0]=='i'?d.lines:[]};var e=this.curOp=this.curOp||{};if(!e.changeHandlers)e.changeHandlers=this._eventRegistry["change"]&&this._eventRegistry["change"].slice();if(this.virtualSelectionMode())return;if(!e.lastChange){e.lastChange=e.change=a;}else{e.lastChange.next=e.lastChange=a;}this.$updateMarkers(d);};this.onSelectionChange=function(){var a=this.curOp=this.curOp||{};if(!a.cursorActivityHandlers)a.cursorActivityHandlers=this._eventRegistry["cursorActivity"]&&this._eventRegistry["cursorActivity"].slice();this.curOp.cursorActivity=true;if(this.ace.inMultiSelectMode){this.ace.keyBinding.removeKeyboardHandler(D.keyboardHandler);}};this.operation=function(f,a){if(!a&&this.curOp||a&&this.curOp&&this.curOp.force){return f();}if(a||!this.ace.curOp){if(this.curOp)this.onBeforeEndOperation();}if(!this.ace.curOp){var p=this.ace.prevOp;this.ace.startOperation({command:{name:"vim",scrollIntoView:"cursor"}});}var d=this.curOp=this.curOp||{};this.curOp.force=a;var r=f();if(this.ace.curOp&&this.ace.curOp.command.name=="vim"){this.ace.endOperation();if(!d.cursorActivity&&!d.lastChange&&p)this.ace.prevOp=p;}if(a||!this.ace.curOp){if(this.curOp)this.onBeforeEndOperation();}return r;};this.onBeforeEndOperation=function(){var o=this.curOp;if(o){if(o.change){this.signal("change",o.change,o);}if(o&&o.cursorActivity){this.signal("cursorActivity",null,o);}this.curOp=null;}};this.signal=function(a,e,h){var d=h?h[a+"Handlers"]:(this._eventRegistry||{})[a];if(!d)return;d=d.slice();for(var i=0;i<d.length;i++)d[i](this,e);};this.firstLine=function(){return 0;};this.lastLine=function(){return this.ace.session.getLength()-1;};this.lineCount=function(){return this.ace.session.getLength();};this.setCursor=function(a,d){if(typeof a==='object'){d=a.ch;a=a.line;}if(!this.ace.inVirtualSelectionMode)this.ace.exitMultiSelectMode();this.ace.session.unfold({row:a,column:d});this.ace.selection.moveTo(a,d);};this.getCursor=function(p){var s=this.ace.selection;var a=p=='anchor'?(s.isEmpty()?s.lead:s.anchor):p=='head'||!p?s.lead:s.getRange()[p];return H(a);};this.listSelections=function(p){var a=this.ace.multiSelect.rangeList.ranges;if(!a.length||this.ace.inVirtualSelectionMode)return[{anchor:this.getCursor('anchor'),head:this.getCursor('head')}];return a.map(function(r){return{anchor:this.clipPos(H(r.cursor==r.end?r.start:r.end)),head:this.clipPos(H(r.cursor))};},this);};this.setSelections=function(p,a){var s=this.ace.multiSelect;var d=p.map(function(x){var h=G(x.anchor);var j=G(x.head);var r=R.comparePoints(h,j)<0?new R.fromPoints(h,j):new R.fromPoints(j,h);r.cursor=R.comparePoints(r.start,j)?r.end:r.start;return r;});if(this.ace.inVirtualSelectionMode){this.ace.selection.fromOrientedRange(d[0]);return;}if(!a){d=d.reverse();}else if(d[a]){d.push(d.splice(a,1)[0]);}s.toSingleRange(d[0].clone());var e=this.ace.session;for(var i=0;i<d.length;i++){var f=e.$clipRangeToDocument(d[i]);s.addRange(f);}};this.setSelection=function(a,h,p1){var s=this.ace.selection;s.moveTo(a.line,a.ch);s.selectTo(h.line,h.ch);if(p1&&p1.origin=='*mouse'){this.onBeforeEndOperation();}};this.somethingSelected=function(p){return!this.ace.selection.isEmpty();};this.clipPos=function(p){var a=this.ace.session.$clipPositionToDocument(p.line,p.ch);return H(a);};this.markText=function(a){return{clear:function(){},find:function(){}};};this.$updateMarkers=function(d){var a=d.action=="insert";var s=d.start;var e=d.end;var r=(e.row-s.row)*(a?1:-1);var f=(e.column-s.column)*(a?1:-1);if(a)e=s;for(var i in this.marks){var p=this.marks[i];var h=R.comparePoints(p,s);if(h<0){continue;}if(h===0){if(a){if(p.bias==1){h=1;}else{p.bias==-1;continue;}}}var j=a?h:R.comparePoints(p,e);if(j>0){p.row+=r;p.column+=p.row==e.row?f:0;continue;}if(!a&&j<=0){p.row=s.row;p.column=s.column;if(j===0)p.bias=1;}}};var b=function(a,i,r,d){this.cm=a;this.id=i;this.row=r;this.column=d;a.marks[this.id]=this;};b.prototype.clear=function(){delete this.cm.marks[this.id]};b.prototype.find=function(){return H(this)};this.setBookmark=function(a,p1){var d=new b(this,this.$uid++,a.line,a.ch);if(!p1||!p1.insertLeft)d.$insertRight=true;this.marks[d.id]=d;return d;};this.moveH=function(i,a){if(a=='char'){var s=this.ace.selection;s.clearSelection();s.moveCursorBy(0,i);}};this.findPosV=function(s,a,d,e){if(d=='page'){var r=this.ace.renderer;var f=r.layerConfig;a=a*Math.floor(f.height/f.lineHeight);d='line';}if(d=='line'){var h=this.ace.session.documentToScreenPosition(s.line,s.ch);if(e!=null)h.column=e;h.row+=a;h.row=Math.min(Math.max(0,h.row),this.ace.session.getScreenLength()-1);var p=this.ace.session.screenToDocumentPosition(h.row,h.column);return H(p);}else{debugger;}};this.charCoords=function(p,m){if(m=='div'||!m){var s=this.ace.session.documentToScreenPosition(p.line,p.ch);return{left:s.column,top:s.row};}if(m=='local'){var r=this.ace.renderer;var s=this.ace.session.documentToScreenPosition(p.line,p.ch);var a=r.layerConfig.lineHeight;var d=r.layerConfig.characterWidth;var e=a*s.row;return{left:s.column*d,top:e,bottom:e+a};}};this.coordsChar=function(p,m){var r=this.ace.renderer;if(m=='local'){var a=Math.max(0,Math.floor(p.top/r.lineHeight));var d=Math.max(0,Math.floor(p.left/r.characterWidth));var e=r.session.screenToDocumentPosition(a,d);return H(e);}else if(m=='div'){throw"not implemented";}};this.getSearchCursor=function(a,p,d){var e=false;var i=false;if(a instanceof RegExp&&!a.global){e=!a.ignoreCase;a=a.source;i=true;}var s=new S();if(p.ch==undefined)p.ch=Number.MAX_VALUE;var f={row:p.line,column:p.ch};var h=this;var j=null;return{findNext:function(){return this.find(false)},findPrevious:function(){return this.find(true)},find:function(k){s.setOptions({needle:a,caseSensitive:e,wrap:false,backwards:k,regExp:i,start:j||f});var r=s.find(h.ace.session);if(r&&r.isEmpty()){if(h.getLine(r.start.row).length==r.start.column){s.$options.start=r;r=s.find(h.ace.session);}}j=r;return j;},from:function(){return j&&H(j.start)},to:function(){return j&&H(j.end)},replace:function(k){if(j){j.end=h.ace.session.doc.replace(j,k);}}};};this.scrollTo=function(x,y){var r=this.ace.renderer;var a=r.layerConfig;var m=a.maxHeight;m-=(r.$size.scrollerHeight-r.lineHeight)*r.$scrollPastEnd;if(y!=null)this.ace.session.setScrollTop(Math.max(0,Math.min(y,m)));if(x!=null)this.ace.session.setScrollLeft(Math.max(0,Math.min(x,a.width)));};this.scrollInfo=function(){return 0;};this.scrollIntoView=function(p,m){if(p){var r=this.ace.renderer;var v={"top":0,"bottom":m};r.scrollCursorIntoView(G(p),(r.lineHeight*2)/r.$size.scrollerHeight,v);}};this.getLine=function(r){return this.ace.session.getLine(r)};this.getRange=function(s,e){return this.ace.session.getTextRange(new R(s.line,s.ch,e.line,e.ch));};this.replaceRange=function(a,s,e){if(!e)e=s;return this.ace.session.replace(new R(s.line,s.ch,e.line,e.ch),a);};this.replaceSelections=function(p){var s=this.ace.selection;if(this.ace.inVirtualSelectionMode){this.ace.session.replace(s.getRange(),p[0]||"");return;}s.inVirtualSelectionMode=true;var r=s.rangeList.ranges;if(!r.length)r=[this.ace.multiSelect.getRange()];for(var i=r.length;i--;)this.ace.session.replace(r[i],p[i]||"");s.inVirtualSelectionMode=false;};this.getSelection=function(){return this.ace.getSelectedText();};this.getSelections=function(){return this.listSelections().map(function(x){return this.getRange(x.anchor,x.head);},this);};this.getInputField=function(){return this.ace.textInput.getElement();};this.getWrapperElement=function(){return this.ace.containter;};var c={indentWithTabs:"useSoftTabs",indentUnit:"tabSize",tabSize:"tabSize",firstLineNumber:"firstLineNumber",readOnly:"readOnly"};this.setOption=function(n,v){this.state[n]=v;switch(n){case'indentWithTabs':n=c[n];v=!v;break;default:n=c[n];}if(n)this.ace.setOption(n,v);};this.getOption=function(n,v){var a=c[n];if(a)v=this.ace.getOption(a);switch(n){case'indentWithTabs':n=c[n];return!v;}return a?v:this.state[n];};this.toggleOverwrite=function(o){this.state.overwrite=o;return this.ace.setOverwrite(o);};this.addOverlay=function(o){if(!this.$searchHighlight||!this.$searchHighlight.session){var h=new C(null,"ace_highlight-marker","text");var m=this.ace.session.addDynamicMarker(h);h.id=m.id;h.session=this.ace.session;h.destroy=function(o){h.session.off("change",h.updateOnChange);h.session.off("changeEditor",h.destroy);h.session.removeMarker(h.id);h.session=null;};h.updateOnChange=function(d){var a=d.start.row;if(a==d.end.row)h.cache[a]=undefined;else h.cache.splice(a,h.cache.length);};h.session.on("changeEditor",h.destroy);h.session.on("change",h.updateOnChange);}var r=new RegExp(o.query.source,"gmi");this.$searchHighlight=o.highlight=h;this.$searchHighlight.setRegexp(r);this.ace.renderer.updateBackMarkers();};this.removeOverlay=function(o){if(this.$searchHighlight&&this.$searchHighlight.session){this.$searchHighlight.destroy();}};this.getScrollInfo=function(){var r=this.ace.renderer;var a=r.layerConfig;return{left:r.scrollLeft,top:r.scrollTop,height:a.maxHeight,width:a.width,clientHeight:a.height,clientWidth:a.width};};this.getValue=function(){return this.ace.getValue();};this.setValue=function(v){return this.ace.setValue(v);};this.getTokenTypeAt=function(p){var a=this.ace.session.getTokenAt(p.line,p.ch);return a&&/comment|string/.test(a.type)?"string":"";};this.findMatchingBracket=function(p){var m=this.ace.session.findMatchingBracket(G(p));return{to:m&&H(m)};};this.indentLine=function(a,m){if(m===true)this.ace.session.indentRows(a,a,"\t");else if(m===false)this.ace.session.outdentRows(new R(a,0,a,0));};this.indexFromPos=function(p){return this.ace.session.doc.positionToIndex(G(p));};this.posFromIndex=function(i){return H(this.ace.session.doc.indexToPosition(i));};this.focus=function(i){return this.ace.focus();};this.blur=function(i){return this.ace.blur();};this.defaultTextHeight=function(i){return this.ace.renderer.layerConfig.lineHeight;};this.scanForBracket=function(p,d,_,p1){var r=p1.bracketRegex.source;if(d==1){var m=this.ace.session.$findClosingBracket(r.slice(1,2),G(p),/paren|text/);}else{var m=this.ace.session.$findOpeningBracket(r.slice(-2,-1),{row:p.line,column:p.ch+1},/paren|text/);}return m&&{pos:H(m)};};this.refresh=function(){return this.ace.resize(true);};this.getMode=function(){return{name:this.getOption("mode")};}}).call(F.prototype);function G(c){return{row:c.line,column:c.ch};}function H(a){return new P(a.row,a.column);}var I=F.StringStream=function(s,a){this.pos=this.start=0;this.string=s;this.tabSize=a||8;this.lastColumnPos=this.lastColumnValue=0;this.lineStart=0;};I.prototype={eol:function(){return this.pos>=this.string.length;},sol:function(){return this.pos==this.lineStart;},peek:function(){return this.string.charAt(this.pos)||undefined;},next:function(){if(this.pos<this.string.length)return this.string.charAt(this.pos++);},eat:function(m){var c=this.string.charAt(this.pos);if(typeof m=="string")var o=c==m;else var o=c&&(m.test?m.test(c):m(c));if(o){++this.pos;return c;}},eatWhile:function(m){var s=this.pos;while(this.eat(m)){}return this.pos>s;},eatSpace:function(){var s=this.pos;while(/[\s\u00a0]/.test(this.string.charAt(this.pos)))++this.pos;return this.pos>s;},skipToEnd:function(){this.pos=this.string.length;},skipTo:function(c){var f=this.string.indexOf(c,this.pos);if(f>-1){this.pos=f;return true;}},backUp:function(n){this.pos-=n;},column:function(){throw"not implemented";},indentation:function(){throw"not implemented";},match:function(p,c,a){if(typeof p=="string"){var b=function(d){return a?d.toLowerCase():d;};var s=this.string.substr(this.pos,p.length);if(b(s)==b(p)){if(c!==false)this.pos+=p.length;return true;}}else{var m=this.string.slice(this.pos).match(p);if(m&&m.index>0)return null;if(m&&c!==false)this.pos+=m[0].length;return m;}},current:function(){return this.string.slice(this.start,this.pos);},hideFirstChars:function(n,i){this.lineStart+=n;try{return i();}finally{this.lineStart-=n;}}};F.defineExtension=function(n,f){F.prototype[n]=f;};u.importCssString(".normal-mode .ace_cursor{  border: 1px solid red;  background-color: red;  opacity: 0.5;}.normal-mode .ace_hidden-cursors .ace_cursor{  background-color: transparent;}.ace_dialog {  position: absolute;  left: 0; right: 0;  background: white;  z-index: 15;  padding: .1em .8em;  overflow: hidden;  color: #333;}.ace_dialog-top {  border-bottom: 1px solid #eee;  top: 0;}.ace_dialog-bottom {  border-top: 1px solid #eee;  bottom: 0;}.ace_dialog input {  border: none;  outline: none;  background: transparent;  width: 20em;  color: inherit;  font-family: monospace;}","vimMode");(function(){function d(a,b,e){var w=a.ace.container;var L2;L2=w.appendChild(document.createElement("div"));if(e)L2.className="ace_dialog ace_dialog-bottom";else L2.className="ace_dialog ace_dialog-top";if(typeof b=="string"){L2.innerHTML=b;}else{L2.appendChild(b);}return L2;}function c(a,n){if(a.state.currentNotificationClose)a.state.currentNotificationClose();a.state.currentNotificationClose=n;}F.defineExtension("openDialog",function(a,b,p1){if(this.virtualSelectionMode())return;if(!p1)p1={};c(this,null);var L2=d(this,a,p1.bottom);var f=false,m=this;function h(n){if(typeof n=='string'){i.value=n;}else{if(f)return;f=true;L2.parentNode.removeChild(L2);m.focus();if(p1.onClose)p1.onClose(L2);}}var i=L2.getElementsByTagName("input")[0],j;if(i){if(p1.value){i.value=p1.value;if(p1.select!==false)i.select();}if(p1.onInput)F.on(i,"input",function(e){p1.onInput(e,i.value,h);});if(p1.onKeyUp)F.on(i,"keyup",function(e){p1.onKeyUp(e,i.value,h);});F.on(i,"keydown",function(e){if(p1&&p1.onKeyDown&&p1.onKeyDown(e,i.value,h)){return;}if(e.keyCode==27||(p1.closeOnEnter!==false&&e.keyCode==13)){i.blur();F.e_stop(e);h();}if(e.keyCode==13)b(i.value);});if(p1.closeOnBlur!==false)F.on(i,"blur",h);i.focus();}else if(j=L2.getElementsByTagName("button")[0]){F.on(j,"click",function(){h();m.focus();});if(p1.closeOnBlur!==false)F.on(j,"blur",h);j.focus();}return h;});F.defineExtension("openNotification",function(a,p1){if(this.virtualSelectionMode())return;c(this,i);var L2=d(this,a,p1&&p1.bottom);var b=false,f;var h=p1&&typeof p1.duration!=="undefined"?p1.duration:5000;function i(){if(b)return;b=true;clearTimeout(f);L2.parentNode.removeChild(L2);}F.on(L2,'click',function(e){F.e_preventDefault(e);i();});if(h)f=setTimeout(i,h);return i;});})();var J=[{keys:'<Left>',type:'keyToKey',toKeys:'h'},{keys:'<Right>',type:'keyToKey',toKeys:'l'},{keys:'<Up>',type:'keyToKey',toKeys:'k'},{keys:'<Down>',type:'keyToKey',toKeys:'j'},{keys:'<Space>',type:'keyToKey',toKeys:'l'},{keys:'<BS>',type:'keyToKey',toKeys:'h',context:'normal'},{keys:'<C-Space>',type:'keyToKey',toKeys:'W'},{keys:'<C-BS>',type:'keyToKey',toKeys:'B',context:'normal'},{keys:'<S-Space>',type:'keyToKey',toKeys:'w'},{keys:'<S-BS>',type:'keyToKey',toKeys:'b',context:'normal'},{keys:'<C-n>',type:'keyToKey',toKeys:'j'},{keys:'<C-p>',type:'keyToKey',toKeys:'k'},{keys:'<C-[>',type:'keyToKey',toKeys:'<Esc>'},{keys:'<C-c>',type:'keyToKey',toKeys:'<Esc>'},{keys:'<C-[>',type:'keyToKey',toKeys:'<Esc>',context:'insert'},{keys:'<C-c>',type:'keyToKey',toKeys:'<Esc>',context:'insert'},{keys:'s',type:'keyToKey',toKeys:'cl',context:'normal'},{keys:'s',type:'keyToKey',toKeys:'c',context:'visual'},{keys:'S',type:'keyToKey',toKeys:'cc',context:'normal'},{keys:'S',type:'keyToKey',toKeys:'VdO',context:'visual'},{keys:'<Home>',type:'keyToKey',toKeys:'0'},{keys:'<End>',type:'keyToKey',toKeys:'$'},{keys:'<PageUp>',type:'keyToKey',toKeys:'<C-b>'},{keys:'<PageDown>',type:'keyToKey',toKeys:'<C-f>'},{keys:'<CR>',type:'keyToKey',toKeys:'j^',context:'normal'},{keys:'H',type:'motion',motion:'moveToTopLine',motionArgs:{linewise:true,toJumplist:true}},{keys:'M',type:'motion',motion:'moveToMiddleLine',motionArgs:{linewise:true,toJumplist:true}},{keys:'L',type:'motion',motion:'moveToBottomLine',motionArgs:{linewise:true,toJumplist:true}},{keys:'h',type:'motion',motion:'moveByCharacters',motionArgs:{forward:false}},{keys:'l',type:'motion',motion:'moveByCharacters',motionArgs:{forward:true}},{keys:'j',type:'motion',motion:'moveByLines',motionArgs:{forward:true,linewise:true}},{keys:'k',type:'motion',motion:'moveByLines',motionArgs:{forward:false,linewise:true}},{keys:'gj',type:'motion',motion:'moveByDisplayLines',motionArgs:{forward:true}},{keys:'gk',type:'motion',motion:'moveByDisplayLines',motionArgs:{forward:false}},{keys:'w',type:'motion',motion:'moveByWords',motionArgs:{forward:true,wordEnd:false}},{keys:'W',type:'motion',motion:'moveByWords',motionArgs:{forward:true,wordEnd:false,bigWord:true}},{keys:'e',type:'motion',motion:'moveByWords',motionArgs:{forward:true,wordEnd:true,inclusive:true}},{keys:'E',type:'motion',motion:'moveByWords',motionArgs:{forward:true,wordEnd:true,bigWord:true,inclusive:true}},{keys:'b',type:'motion',motion:'moveByWords',motionArgs:{forward:false,wordEnd:false}},{keys:'B',type:'motion',motion:'moveByWords',motionArgs:{forward:false,wordEnd:false,bigWord:true}},{keys:'ge',type:'motion',motion:'moveByWords',motionArgs:{forward:false,wordEnd:true,inclusive:true}},{keys:'gE',type:'motion',motion:'moveByWords',motionArgs:{forward:false,wordEnd:true,bigWord:true,inclusive:true}},{keys:'{',type:'motion',motion:'moveByParagraph',motionArgs:{forward:false,toJumplist:true}},{keys:'}',type:'motion',motion:'moveByParagraph',motionArgs:{forward:true,toJumplist:true}},{keys:'<C-f>',type:'motion',motion:'moveByPage',motionArgs:{forward:true}},{keys:'<C-b>',type:'motion',motion:'moveByPage',motionArgs:{forward:false}},{keys:'<C-d>',type:'motion',motion:'moveByScroll',motionArgs:{forward:true,explicitRepeat:true}},{keys:'<C-u>',type:'motion',motion:'moveByScroll',motionArgs:{forward:false,explicitRepeat:true}},{keys:'gg',type:'motion',motion:'moveToLineOrEdgeOfDocument',motionArgs:{forward:false,explicitRepeat:true,linewise:true,toJumplist:true}},{keys:'G',type:'motion',motion:'moveToLineOrEdgeOfDocument',motionArgs:{forward:true,explicitRepeat:true,linewise:true,toJumplist:true}},{keys:'0',type:'motion',motion:'moveToStartOfLine'},{keys:'^',type:'motion',motion:'moveToFirstNonWhiteSpaceCharacter'},{keys:'+',type:'motion',motion:'moveByLines',motionArgs:{forward:true,toFirstChar:true}},{keys:'-',type:'motion',motion:'moveByLines',motionArgs:{forward:false,toFirstChar:true}},{keys:'_',type:'motion',motion:'moveByLines',motionArgs:{forward:true,toFirstChar:true,repeatOffset:-1}},{keys:'$',type:'motion',motion:'moveToEol',motionArgs:{inclusive:true}},{keys:'%',type:'motion',motion:'moveToMatchedSymbol',motionArgs:{inclusive:true,toJumplist:true}},{keys:'f<character>',type:'motion',motion:'moveToCharacter',motionArgs:{forward:true,inclusive:true}},{keys:'F<character>',type:'motion',motion:'moveToCharacter',motionArgs:{forward:false}},{keys:'t<character>',type:'motion',motion:'moveTillCharacter',motionArgs:{forward:true,inclusive:true}},{keys:'T<character>',type:'motion',motion:'moveTillCharacter',motionArgs:{forward:false}},{keys:';',type:'motion',motion:'repeatLastCharacterSearch',motionArgs:{forward:true}},{keys:',',type:'motion',motion:'repeatLastCharacterSearch',motionArgs:{forward:false}},{keys:'\'<character>',type:'motion',motion:'goToMark',motionArgs:{toJumplist:true,linewise:true}},{keys:'`<character>',type:'motion',motion:'goToMark',motionArgs:{toJumplist:true}},{keys:']`',type:'motion',motion:'jumpToMark',motionArgs:{forward:true}},{keys:'[`',type:'motion',motion:'jumpToMark',motionArgs:{forward:false}},{keys:']\'',type:'motion',motion:'jumpToMark',motionArgs:{forward:true,linewise:true}},{keys:'[\'',type:'motion',motion:'jumpToMark',motionArgs:{forward:false,linewise:true}},{keys:']p',type:'action',action:'paste',isEdit:true,actionArgs:{after:true,isEdit:true,matchIndent:true}},{keys:'[p',type:'action',action:'paste',isEdit:true,actionArgs:{after:false,isEdit:true,matchIndent:true}},{keys:']<character>',type:'motion',motion:'moveToSymbol',motionArgs:{forward:true,toJumplist:true}},{keys:'[<character>',type:'motion',motion:'moveToSymbol',motionArgs:{forward:false,toJumplist:true}},{keys:'|',type:'motion',motion:'moveToColumn'},{keys:'o',type:'motion',motion:'moveToOtherHighlightedEnd',context:'visual'},{keys:'O',type:'motion',motion:'moveToOtherHighlightedEnd',motionArgs:{sameLine:true},context:'visual'},{keys:'d',type:'operator',operator:'delete'},{keys:'y',type:'operator',operator:'yank'},{keys:'c',type:'operator',operator:'change'},{keys:'>',type:'operator',operator:'indent',operatorArgs:{indentRight:true}},{keys:'<',type:'operator',operator:'indent',operatorArgs:{indentRight:false}},{keys:'g~',type:'operator',operator:'changeCase'},{keys:'gu',type:'operator',operator:'changeCase',operatorArgs:{toLower:true},isEdit:true},{keys:'gU',type:'operator',operator:'changeCase',operatorArgs:{toLower:false},isEdit:true},{keys:'n',type:'motion',motion:'findNext',motionArgs:{forward:true,toJumplist:true}},{keys:'N',type:'motion',motion:'findNext',motionArgs:{forward:false,toJumplist:true}},{keys:'x',type:'operatorMotion',operator:'delete',motion:'moveByCharacters',motionArgs:{forward:true},operatorMotionArgs:{visualLine:false}},{keys:'X',type:'operatorMotion',operator:'delete',motion:'moveByCharacters',motionArgs:{forward:false},operatorMotionArgs:{visualLine:true}},{keys:'D',type:'operatorMotion',operator:'delete',motion:'moveToEol',motionArgs:{inclusive:true},context:'normal'},{keys:'D',type:'operator',operator:'delete',operatorArgs:{linewise:true},context:'visual'},{keys:'Y',type:'operatorMotion',operator:'yank',motion:'moveToEol',motionArgs:{inclusive:true},context:'normal'},{keys:'Y',type:'operator',operator:'yank',operatorArgs:{linewise:true},context:'visual'},{keys:'C',type:'operatorMotion',operator:'change',motion:'moveToEol',motionArgs:{inclusive:true},context:'normal'},{keys:'C',type:'operator',operator:'change',operatorArgs:{linewise:true},context:'visual'},{keys:'~',type:'operatorMotion',operator:'changeCase',motion:'moveByCharacters',motionArgs:{forward:true},operatorArgs:{shouldMoveCursor:true},context:'normal'},{keys:'~',type:'operator',operator:'changeCase',context:'visual'},{keys:'<C-w>',type:'operatorMotion',operator:'delete',motion:'moveByWords',motionArgs:{forward:false,wordEnd:false},context:'insert'},{keys:'<C-i>',type:'action',action:'jumpListWalk',actionArgs:{forward:true}},{keys:'<C-o>',type:'action',action:'jumpListWalk',actionArgs:{forward:false}},{keys:'<C-e>',type:'action',action:'scroll',actionArgs:{forward:true,linewise:true}},{keys:'<C-y>',type:'action',action:'scroll',actionArgs:{forward:false,linewise:true}},{keys:'a',type:'action',action:'enterInsertMode',isEdit:true,actionArgs:{insertAt:'charAfter'},context:'normal'},{keys:'A',type:'action',action:'enterInsertMode',isEdit:true,actionArgs:{insertAt:'eol'},context:'normal'},{keys:'A',type:'action',action:'enterInsertMode',isEdit:true,actionArgs:{insertAt:'endOfSelectedArea'},context:'visual'},{keys:'i',type:'action',action:'enterInsertMode',isEdit:true,actionArgs:{insertAt:'inplace'},context:'normal'},{keys:'I',type:'action',action:'enterInsertMode',isEdit:true,actionArgs:{insertAt:'firstNonBlank'},context:'normal'},{keys:'I',type:'action',action:'enterInsertMode',isEdit:true,actionArgs:{insertAt:'startOfSelectedArea'},context:'visual'},{keys:'o',type:'action',action:'newLineAndEnterInsertMode',isEdit:true,interlaceInsertRepeat:true,actionArgs:{after:true},context:'normal'},{keys:'O',type:'action',action:'newLineAndEnterInsertMode',isEdit:true,interlaceInsertRepeat:true,actionArgs:{after:false},context:'normal'},{keys:'v',type:'action',action:'toggleVisualMode'},{keys:'V',type:'action',action:'toggleVisualMode',actionArgs:{linewise:true}},{keys:'<C-v>',type:'action',action:'toggleVisualMode',actionArgs:{blockwise:true}},{keys:'<C-q>',type:'action',action:'toggleVisualMode',actionArgs:{blockwise:true}},{keys:'gv',type:'action',action:'reselectLastSelection'},{keys:'J',type:'action',action:'joinLines',isEdit:true},{keys:'p',type:'action',action:'paste',isEdit:true,actionArgs:{after:true,isEdit:true}},{keys:'P',type:'action',action:'paste',isEdit:true,actionArgs:{after:false,isEdit:true}},{keys:'r<character>',type:'action',action:'replace',isEdit:true},{keys:'@<character>',type:'action',action:'replayMacro'},{keys:'q<character>',type:'action',action:'enterMacroRecordMode'},{keys:'R',type:'action',action:'enterInsertMode',isEdit:true,actionArgs:{replace:true}},{keys:'u',type:'action',action:'undo',context:'normal'},{keys:'u',type:'operator',operator:'changeCase',operatorArgs:{toLower:true},context:'visual',isEdit:true},{keys:'U',type:'operator',operator:'changeCase',operatorArgs:{toLower:false},context:'visual',isEdit:true},{keys:'<C-r>',type:'action',action:'redo'},{keys:'m<character>',type:'action',action:'setMark'},{keys:'"<character>',type:'action',action:'setRegister'},{keys:'zz',type:'action',action:'scrollToCursor',actionArgs:{position:'center'}},{keys:'z.',type:'action',action:'scrollToCursor',actionArgs:{position:'center'},motion:'moveToFirstNonWhiteSpaceCharacter'},{keys:'zt',type:'action',action:'scrollToCursor',actionArgs:{position:'top'}},{keys:'z<CR>',type:'action',action:'scrollToCursor',actionArgs:{position:'top'},motion:'moveToFirstNonWhiteSpaceCharacter'},{keys:'z-',type:'action',action:'scrollToCursor',actionArgs:{position:'bottom'}},{keys:'zb',type:'action',action:'scrollToCursor',actionArgs:{position:'bottom'},motion:'moveToFirstNonWhiteSpaceCharacter'},{keys:'.',type:'action',action:'repeatLastEdit'},{keys:'<C-a>',type:'action',action:'incrementNumberToken',isEdit:true,actionArgs:{increase:true,backtrack:false}},{keys:'<C-x>',type:'action',action:'incrementNumberToken',isEdit:true,actionArgs:{increase:false,backtrack:false}},{keys:'a<character>',type:'motion',motion:'textObjectManipulation'},{keys:'i<character>',type:'motion',motion:'textObjectManipulation',motionArgs:{textObjectInner:true}},{keys:'/',type:'search',searchArgs:{forward:true,querySrc:'prompt',toJumplist:true}},{keys:'?',type:'search',searchArgs:{forward:false,querySrc:'prompt',toJumplist:true}},{keys:'*',type:'search',searchArgs:{forward:true,querySrc:'wordUnderCursor',wholeWordOnly:true,toJumplist:true}},{keys:'#',type:'search',searchArgs:{forward:false,querySrc:'wordUnderCursor',wholeWordOnly:true,toJumplist:true}},{keys:'g*',type:'search',searchArgs:{forward:true,querySrc:'wordUnderCursor',toJumplist:true}},{keys:'g#',type:'search',searchArgs:{forward:false,querySrc:'wordUnderCursor',toJumplist:true}},{keys:':',type:'ex'}];var L=[{name:'colorscheme',shortName:'colo'},{name:'map'},{name:'imap',shortName:'im'},{name:'nmap',shortName:'nm'},{name:'vmap',shortName:'vm'},{name:'unmap'},{name:'write',shortName:'w'},{name:'undo',shortName:'u'},{name:'redo',shortName:'red'},{name:'set',shortName:'se'},{name:'set',shortName:'se'},{name:'setlocal',shortName:'setl'},{name:'setglobal',shortName:'setg'},{name:'sort',shortName:'sor'},{name:'substitute',shortName:'s',possiblyAsync:true},{name:'nohlsearch',shortName:'noh'},{name:'delmarks',shortName:'delm'},{name:'registers',shortName:'reg',excludeFromCommandHistory:true},{name:'global',shortName:'g'}];var P=F.Pos;var V=function(){return B1;};function M(c){c.setOption('disableInput',true);c.setOption('showCursorWhenSelecting',false);F.signal(c,"vim-mode-change",{mode:"normal"});c.on('cursorActivity',q3);x1(c);F.on(c.getInputField(),'paste',Z(c));}function N(c){c.setOption('disableInput',false);c.off('cursorActivity',q3);F.off(c.getInputField(),'paste',Z(c));c.state.vim=null;}function O(c,n){if(this==F.keyMap.vim)F.rmClass(c.getWrapperElement(),"cm-fat-cursor");if(!n||n.attach!=Q)N(c,false);}function Q(c,p){if(this==F.keyMap.vim)F.addClass(c.getWrapperElement(),"cm-fat-cursor");if(!p||p.attach!=Q)M(c);}F.defineOption('vimMode',false,function(c,v,p){if(v&&c.getOption("keyMap")!="vim")c.setOption("keyMap","vim");else if(!v&&p!=F.Init&&/^vim/.test(c.getOption("keyMap")))c.setOption("keyMap","default");});function U(k,c){if(!c){return undefined;}var v=Y(k);if(!v){return false;}var a=F.Vim.findKey(c,v);if(typeof a=='function'){F.signal(c,'vim-keypress',v);}return a;}var W={'Shift':'S','Ctrl':'C','Alt':'A','Cmd':'D','Mod':'A'};var X={Enter:'CR',Backspace:'BS',Delete:'Del'};function Y(k){if(k.charAt(0)=='\''){return k.charAt(1);}var p=k.split(/-(?!$)/);var a=p[p.length-1];if(p.length==1&&p[0].length==1){return false;}else if(p.length==2&&p[0]=='Shift'&&a.length==1){return false;}var h=false;for(var i=0;i<p.length;i++){var b=p[i];if(b in W){p[i]=W[b];}else{h=true;}if(b in X){p[i]=X[b];}}if(!h){return false;}if(m1(a)){p[p.length-1]=a.toLowerCase();}return'<'+p.join('-')+'>';}function Z(c){var v=c.state.vim;if(!v.onPasteFn){v.onPasteFn=function(){if(!v.insertMode){c.setCursor(S1(c.getCursor(),0,1));O1.enterInsertMode(c,{},v);}};}return v.onPasteFn;}var $=/[\d]/;var a1=[F.isWordChar,function(c){return c&&!F.isWordChar(c)&&!/\s/.test(c);}],b1=[function(c){return/\S/.test(c);}];function c1(s,a){var k=[];for(var i=s;i<s+a;i++){k.push(String.fromCharCode(i));}return k;}var d1=c1(65,26);var e1=c1(97,26);var f1=c1(48,10);var g1=[].concat(d1,e1,f1,['<','>']);var h1=[].concat(d1,e1,f1,['-','"','.',':','/']);function i1(c,a){return a>=c.firstLine()&&a<=c.lastLine();}function j1(k){return(/^[a-z]$/).test(k);}function k1(k){return'()[]{}'.indexOf(k)!=-1;}function l1(k){return $.test(k);}function m1(k){return(/^[A-Z]$/).test(k);}function n1(k){return(/^\s*$/).test(k);}function o1(v,a){for(var i=0;i<a.length;i++){if(a[i]==v){return true;}}return false;}var p1={};function q1(n,d,a,b,c){if(d===undefined&&!c){throw Error('defaultValue is required unless callback is provided');}if(!a){a='string';}p1[n]={type:a,defaultValue:d,callback:c};if(b){for(var i=0;i<b.length;i++){p1[b[i]]=p1[n];}}if(d){s1(n,d);}}function s1(n,v,c,a){var o=p1[n];a=a||{};var s=a.scope;if(!o){throw Error('Unknown option: '+n);}if(o.type=='boolean'){if(v&&v!==true){throw Error('Invalid argument: '+n+'='+v);}else if(v!==false){v=true;}}if(o.callback){if(s!=='local'){o.callback(v,undefined);}if(s!=='global'&&c){o.callback(v,c);}}else{if(s!=='local'){o.value=o.type=='boolean'?!!v:v;}if(s!=='global'&&c){c.state.vim.options[n]={value:v};}}}function t1(n,c,a){var o=p1[n];a=a||{};var s=a.scope;if(!o){throw Error('Unknown option: '+n);}if(o.callback){var b=c&&o.callback(undefined,c);if(s!=='global'&&b!==undefined){return b;}if(s!=='local'){return o.callback();}return;}else{var b=(s!=='global')&&(c&&c.state.vim.options[n]);return(b||(s!=='local')&&o||{}).value;}}q1('filetype',undefined,'string',['ft'],function(n,c){if(c===undefined){return;}if(n===undefined){var m=c.getOption('mode');return m=='null'?'':m;}else{var m=n==''?'null':n;c.setOption('mode',m);}});var u1=function(){var s=100;var p=-1;var h=0;var a=0;var b=new Array(s);function c(d,o,n){var e=p%s;var f=b[e];function i(k){var r=++p%s;var v=b[r];if(v){v.clear();}b[r]=d.setBookmark(k);}if(f){var j=f.find();if(j&&!Z1(j,o)){i(o);}}else{i(o);}i(n);h=p;a=p-s+1;if(a<0){a=0;}}function m(d,o){p+=o;if(p>h){p=h;}else if(p<a){p=a;}var e=b[(s+p)%s];if(e&&!e.find()){var i=o>0?1:-1;var n;var f=d.getCursor();do{p+=i;e=b[(s+p)%s];if(e&&(n=e.find())&&!Z1(f,n)){break;}}while(p<h&&p>a);}return e;}return{cachedCursor:undefined,add:c,move:m};};var v1=function(c){if(c){return{changes:c.changes,expectCursorActivityForChange:c.expectCursorActivityForChange};}return{changes:[],expectCursorActivityForChange:false};};function w1(){this.latestRegister=undefined;this.isPlaying=false;this.isRecording=false;this.replaySearchQueries=[];this.onRecordingDone=undefined;this.lastInsertModeChanges=v1();}w1.prototype={exitMacroRecordMode:function(){var m=y1.macroModeState;if(m.onRecordingDone){m.onRecordingDone();}m.onRecordingDone=undefined;m.isRecording=false;},enterMacroRecordMode:function(c,r){var a=y1.registerController.getRegister(r);if(a){a.clear();this.latestRegister=r;if(c.openDialog){this.onRecordingDone=c.openDialog('(recording)['+r+']',null,{bottom:true});}this.isRecording=true;}}};function x1(c){if(!c.state.vim){c.state.vim={inputState:new C1(),lastEditInputState:undefined,lastEditActionCommand:undefined,lastHPos:-1,lastHSPos:-1,lastMotion:null,marks:{},fakeCursor:null,insertMode:false,insertModeRepeat:undefined,visualMode:false,visualLine:false,visualBlock:false,lastSelection:null,lastPastedText:null,sel:{},options:{}};}return c.state.vim;}var y1;function z1(){y1={searchQuery:null,searchIsReversed:false,lastSubstituteReplacePart:undefined,jumpList:u1(),macroModeState:new w1,lastChararacterSearch:{increment:0,forward:true,selectedCharacter:''},registerController:new G1({}),searchHistoryController:new H1({}),exCommandHistoryController:new H1({})};for(var o in p1){var a=p1[o];a.value=a.defaultValue;}}var A1;var B1={buildKeyMap:function(){},getRegisterController:function(){return y1.registerController;},resetVimGlobalState_:z1,getVimGlobalState_:function(){return y1;},maybeInitVimState_:x1,suppressErrorLogging:false,InsertModeKey:t3,map:function(a,r,c){g3.map(a,r,c);},unmap:function(a,c){g3.unmap(a,c);},setOption:s1,getOption:t1,defineOption:q1,defineEx:function(n,p,f){if(!p){p=n;}else if(n.indexOf(p)!==0){throw new Error('(Vim.defineEx) "'+p+'" is not a prefix of "'+n+'", command not registered');}f3[n]=f;g3.commandMap_[p]={name:n,shortName:p,type:'api'};},handleKey:function(c,k,o){var a=this.findKey(c,k,o);if(typeof a==='function'){return a();}},findKey:function(c,k,o){var v=x1(c);function h(){var m=y1.macroModeState;if(m.isRecording){if(k=='q'){m.exitMacroRecordMode();D1(c);return true;}if(o!='mapping'){m3(m,k);}}}function a(){if(k=='<Esc>'){D1(c);if(v.visualMode){p2(c);}else if(v.insertMode){i3(c);}return true;}}function d(e){var m;while(e){m=(/<\w+-.+?>|<\w+>|./).exec(e);k=m[0];e=e.substring(m.index+k.length);F.Vim.handleKey(c,k,'mapping');}}function b(){if(a()){return true;}var e=v.inputState.keyBuffer=v.inputState.keyBuffer+k;var m=k.length==1;var n=I1.matchCommand(e,J,v.inputState,'insert');while(e.length>1&&n.type!='full'){var e=v.inputState.keyBuffer=e.slice(1);var p=I1.matchCommand(e,J,v.inputState,'insert');if(p.type!='none'){n=p;}}if(n.type=='none'){D1(c);return false;}else if(n.type=='partial'){if(A1){window.clearTimeout(A1);}A1=window.setTimeout(function(){if(v.insertMode&&v.inputState.keyBuffer){D1(c);}},t1('insertModeEscKeysTimeout'));return!m;}if(A1){window.clearTimeout(A1);}if(m){var s=c.listSelections();for(var i=0;i<s.length;i++){var r=s[i].head;c.replaceRange('',S1(r,0,-(e.length-1)),r,'+input');}y1.macroModeState.lastInsertModeChanges.changes.pop();}D1(c);return n.command;}function f(){if(h()||a()){return true;}var e=v.inputState.keyBuffer=v.inputState.keyBuffer+k;if(/^[1-9]\d*$/.test(e)){return true;}var i=/^(\d*)(.*)$/.exec(e);if(!i){D1(c);return false;}var m=v.visualMode?'visual':'normal';var n=I1.matchCommand(i[2]||i[1],J,v.inputState,m);if(n.type=='none'){D1(c);return false;}else if(n.type=='partial'){return true;}v.inputState.keyBuffer='';var i=/^(\d*)(.*)$/.exec(e);if(i[1]&&i[1]!='0'){v.inputState.pushRepeatDigit(i[1]);}return n.command;}var j;if(v.insertMode){j=b();}else{j=f();}if(j===false){return undefined;}else if(j===true){return function(){return true;};}else{return function(){if((j.operator||j.isEdit)&&c.getOption('readOnly'))return;return c.operation(function(){c.curOp.isVimOp=true;try{if(j.type=='keyToKey'){d(j.toKeys);}else{I1.processCommand(c,v,j);}}catch(e){c.state.vim=undefined;x1(c);if(!F.Vim.suppressErrorLogging){console['log'](e);}throw e;}return true;});};}},handleEx:function(c,i){g3.processCommand(c,i);},defineMotion:K1,defineAction:P1,defineOperator:N1,mapCommand:k3,_mapCommand:j3,defineRegister:F1,exitVisualMode:p2,exitInsertMode:i3};function C1(){this.prefixRepeat=[];this.motionRepeat=[];this.operator=null;this.operatorArgs=null;this.motion=null;this.motionArgs=null;this.keyBuffer=[];this.registerName=null;}C1.prototype.pushRepeatDigit=function(n){if(!this.operator){this.prefixRepeat=this.prefixRepeat.concat(n);}else{this.motionRepeat=this.motionRepeat.concat(n);}};C1.prototype.getRepeat=function(){var r=0;if(this.prefixRepeat.length>0||this.motionRepeat.length>0){r=1;if(this.prefixRepeat.length>0){r*=parseInt(this.prefixRepeat.join(''),10);}if(this.motionRepeat.length>0){r*=parseInt(this.motionRepeat.join(''),10);}}return r;};function D1(c,r){c.state.vim.inputState=new C1();F.signal(c,'vim-command-done',r);}function E1(a,b,c){this.clear();this.keyBuffer=[a||''];this.insertModeChanges=[];this.searchQueries=[];this.linewise=!!b;this.blockwise=!!c;}E1.prototype={setText:function(a,b,c){this.keyBuffer=[a||''];this.linewise=!!b;this.blockwise=!!c;},pushText:function(a,b){if(b){if(!this.linewise){this.keyBuffer.push('\n');}this.linewise=true;}this.keyBuffer.push(a);},pushInsertModeChanges:function(c){this.insertModeChanges.push(v1(c));},pushSearchQuery:function(a){this.searchQueries.push(a);},clear:function(){this.keyBuffer=[];this.insertModeChanges=[];this.searchQueries=[];this.linewise=false;},toString:function(){return this.keyBuffer.join('');}};function F1(n,r){var a=y1.registerController.registers[n];if(!n||n.length!=1){throw Error('Register name must be 1 character');}a[n]=r;h1.push(n);}function G1(r){this.registers=r;this.unnamedRegister=r['"']=new E1();r['.']=new E1();r[':']=new E1();r['/']=new E1();}G1.prototype={pushText:function(r,o,a,b,c){if(b&&a.charAt(0)=='\n'){a=a.slice(1)+'\n';}if(b&&a.charAt(a.length-1)!=='\n'){a+='\n';}var d=this.isValidRegister(r)?this.getRegister(r):null;if(!d){switch(o){case'yank':this.registers['0']=new E1(a,b,c);break;case'delete':case'change':if(a.indexOf('\n')==-1){this.registers['-']=new E1(a,b);}else{this.shiftNumericRegisters_();this.registers['1']=new E1(a,b);}break;}this.unnamedRegister.setText(a,b,c);return;}var e=m1(r);if(e){d.pushText(a,b);}else{d.setText(a,b,c);}this.unnamedRegister.setText(d.toString(),b);},getRegister:function(n){if(!this.isValidRegister(n)){return this.unnamedRegister;}n=n.toLowerCase();if(!this.registers[n]){this.registers[n]=new E1();}return this.registers[n];},isValidRegister:function(n){return n&&o1(n,h1);},shiftNumericRegisters_:function(){for(var i=9;i>=2;i--){this.registers[i]=this.getRegister(''+(i-1));}}};function H1(){this.historyBuffer=[];this.iterator;this.initialPrefix=null;}H1.prototype={nextMatch:function(a,b){var h=this.historyBuffer;var d=b?-1:1;if(this.initialPrefix===null)this.initialPrefix=a;for(var i=this.iterator+d;b?i>=0:i<h.length;i+=d){var e=h[i];for(var j=0;j<=e.length;j++){if(this.initialPrefix==e.substring(0,j)){this.iterator=i;return e;}}}if(i>=h.length){this.iterator=h.length;return this.initialPrefix;}if(i<0)return a;},pushInput:function(i){var a=this.historyBuffer.indexOf(i);if(a>-1)this.historyBuffer.splice(a,1);if(i.length)this.historyBuffer.push(i);},reset:function(){this.initialPrefix=null;this.iterator=this.historyBuffer.length;}};var I1={matchCommand:function(k,a,b,c){var m=U1(k,a,c,b);if(!m.full&&!m.partial){return{type:'none'};}else if(!m.full&&m.partial){return{type:'partial'};}var d;for(var i=0;i<m.full.length;i++){var e=m.full[i];if(!d){d=e;}}if(d.keys.slice(-11)=='<character>'){var f=W1(k);if(/<C-.>/.test(f))return{type:'none'};b.selectedCharacter=f;}return{type:'full',command:d};},processCommand:function(c,v,a){v.inputState.repeatOverride=a.repeatOverride;switch(a.type){case'motion':this.processMotion(c,v,a);break;case'operator':this.processOperator(c,v,a);break;case'operatorMotion':this.processOperatorMotion(c,v,a);break;case'action':this.processAction(c,v,a);break;case'search':this.processSearch(c,v,a);break;case'ex':case'keyToEx':this.processEx(c,v,a);break;default:break;}},processMotion:function(c,v,a){v.inputState.motion=a.motion;v.inputState.motionArgs=R1(a.motionArgs);this.evalInput(c,v);},processOperator:function(c,v,a){var i=v.inputState;if(i.operator){if(i.operator==a.operator){i.motion='expandToLine';i.motionArgs={linewise:true};this.evalInput(c,v);return;}else{D1(c);}}i.operator=a.operator;i.operatorArgs=R1(a.operatorArgs);if(v.visualMode){this.evalInput(c,v);}},processOperatorMotion:function(c,v,a){var b=v.visualMode;var o=R1(a.operatorMotionArgs);if(o){if(b&&o.visualLine){v.visualLine=true;}}this.processOperator(c,v,a);if(!b){this.processMotion(c,v,a);}},processAction:function(c,v,a){var i=v.inputState;var r=i.getRepeat();var b=!!r;var d=R1(a.actionArgs)||{};if(i.selectedCharacter){d.selectedCharacter=i.selectedCharacter;}if(a.operator){this.processOperator(c,v,a);}if(a.motion){this.processMotion(c,v,a);}if(a.motion||a.operator){this.evalInput(c,v);}d.repeat=r||1;d.repeatIsExplicit=b;d.registerName=i.registerName;D1(c);v.lastMotion=null;if(a.isEdit){this.recordLastEdit(v,i,a);}O1[a.action](c,d,v);},processSearch:function(c,v,a){if(!c.getSearchCursor){return;}var f=a.searchArgs.forward;var w=a.searchArgs.wholeWordOnly;K2(c).setReversed(!f);var p=(f)?'/':'?';var o=K2(c).getQuery();var b=c.getScrollInfo();function h(k,s,x){y1.searchHistoryController.pushInput(k);y1.searchHistoryController.reset();try{Z2(c,k,s,x);}catch(e){U2(c,'Invalid regex: '+k);D1(c);return;}I1.processMotion(c,v,{type:'motion',motion:'findNext',motionArgs:{forward:true,toJumplist:a.searchArgs.toJumplist}});}function d(k){c.scrollTo(b.left,b.top);h(k,true,true);var m=y1.macroModeState;if(m.isRecording){o3(m,k);}}function i(e,k,s){var x=F.keyName(e),y;if(x=='Up'||x=='Down'){y=x=='Up'?true:false;k=y1.searchHistoryController.nextMatch(k,y)||'';s(k);}else{if(x!='Left'&&x!='Right'&&x!='Ctrl'&&x!='Alt'&&x!='Shift')y1.searchHistoryController.reset();}var _;try{_=Z2(c,k,true,true);}catch(e){}if(_){c.scrollIntoView(a3(c,!f,_),30);}else{b3(c);c.scrollTo(b.left,b.top);}}function j(e,k,s){var x=F.keyName(e);if(x=='Esc'||x=='Ctrl-C'||x=='Ctrl-['||(x=='Backspace'&&k=='')){y1.searchHistoryController.pushInput(k);y1.searchHistoryController.reset();Z2(c,o);b3(c);c.scrollTo(b.left,b.top);F.e_stop(e);D1(c);s();c.focus();}else if(x=='Ctrl-U'){F.e_stop(e);s('');}}switch(a.searchArgs.querySrc){case'prompt':var m=y1.macroModeState;if(m.isPlaying){var k=m.replaySearchQueries.shift();h(k,true,false);}else{X2(c,{onClose:d,prefix:p,desc:W2,onKeyUp:i,onKeyDown:j});}break;case'wordUnderCursor':var n=u2(c,false,true,false,true);var r=true;if(!n){n=u2(c,false,true,false,false);r=false;}if(!n){return;}var k=c.getLine(n.start.line).substring(n.start.ch,n.end.ch);if(r&&w){k='\\b'+k+'\\b';}else{k=e2(k);}y1.jumpList.cachedCursor=c.getCursor();c.setCursor(n.start);h(k,true,false);break;}},processEx:function(c,v,a){function o(i){y1.exCommandHistoryController.pushInput(i);y1.exCommandHistoryController.reset();g3.processCommand(c,i);}function b(e,i,d){var k=F.keyName(e),f;if(k=='Esc'||k=='Ctrl-C'||k=='Ctrl-['||(k=='Backspace'&&i=='')){y1.exCommandHistoryController.pushInput(i);y1.exCommandHistoryController.reset();F.e_stop(e);D1(c);d();c.focus();}if(k=='Up'||k=='Down'){f=k=='Up'?true:false;i=y1.exCommandHistoryController.nextMatch(i,f)||'';d(i);}else if(k=='Ctrl-U'){F.e_stop(e);d('');}else{if(k!='Left'&&k!='Right'&&k!='Ctrl'&&k!='Alt'&&k!='Shift')y1.exCommandHistoryController.reset();}}if(a.type=='keyToEx'){g3.processCommand(c,a.exArgs.input);}else{if(v.visualMode){X2(c,{onClose:o,prefix:':',value:'\'<,\'>',onKeyDown:b});}else{X2(c,{onClose:o,prefix:':',onKeyDown:b});}}},evalInput:function(c,v){var a=v.inputState;var m=a.motion;var b=a.motionArgs||{};var o=a.operator;var d=a.operatorArgs||{};var r=a.registerName;var s=v.sel;var e=Y1(v.visualMode?Q1(c,s.head):c.getCursor('head'));var f=Y1(v.visualMode?Q1(c,s.anchor):c.getCursor('anchor'));var h=Y1(e);var j=Y1(f);var n,k;var p;if(o){this.recordLastEdit(v,a);}if(a.repeatOverride!==undefined){p=a.repeatOverride;}else{p=a.getRepeat();}if(p>0&&b.explicitRepeat){b.repeatIsExplicit=true;}else if(b.noRepeat||(!b.explicitRepeat&&p===0)){p=1;b.repeatIsExplicit=false;}if(a.selectedCharacter){b.selectedCharacter=d.selectedCharacter=a.selectedCharacter;}b.repeat=p;D1(c);if(m){var w=J1[m](c,e,b,v);v.lastMotion=J1[m];if(!w){return;}if(b.toJumplist){if(!o&&c.ace.curOp!=null)c.ace.curOp.command.scrollIntoView="center-animate";var x=y1.jumpList;var y=x.cachedCursor;if(y){v2(c,y,w);delete x.cachedCursor;}else{v2(c,e,w);}}if(w instanceof Array){k=w[0];n=w[1];}else{n=w;}if(!n){n=Y1(e);}if(v.visualMode){if(!(v.visualBlock&&n.ch===Infinity)){n=Q1(c,n,v.visualBlock);}if(k){k=Q1(c,k,true);}k=k||j;s.anchor=k;s.head=n;m2(c);E2(c,v,'<',$1(k,n)?k:n);E2(c,v,'>',$1(k,n)?n:k);}else if(!o){n=Q1(c,n);c.setCursor(n.line,n.ch);}}if(o){if(d.lastSel){k=j;var _=d.lastSel;var r1=Math.abs(_.head.line-_.anchor.line);var r2=Math.abs(_.head.ch-_.anchor.ch);if(_.visualLine){n=P(j.line+r1,j.ch);}else if(_.visualBlock){n=P(j.line+r1,j.ch+r2);}else if(_.head.line==_.anchor.line){n=P(j.line,j.ch+r2);}else{n=P(j.line+r1,j.ch);}v.visualMode=true;v.visualLine=_.visualLine;v.visualBlock=_.visualBlock;s=v.sel={anchor:k,head:n};m2(c);}else if(v.visualMode){d.lastSel={anchor:Y1(s.anchor),head:Y1(s.head),visualBlock:v.visualBlock,visualLine:v.visualLine};}var F3,G3,H3,I3;var J3;if(v.visualMode){F3=_1(s.head,s.anchor);G3=a2(s.head,s.anchor);H3=v.visualLine||d.linewise;I3=v.visualBlock?'block':H3?'line':'char';J3=n2(c,{anchor:F3,head:G3},I3);if(H3){var K3=J3.ranges;if(I3=='block'){for(var i=0;i<K3.length;i++){K3[i].head.ch=c2(c,K3[i].head.line);}}else if(I3=='line'){K3[0].head=P(K3[0].head.line+1,0);}}}else{F3=Y1(k||j);G3=Y1(n||h);if($1(G3,F3)){var L3=F3;F3=G3;G3=L3;}H3=b.linewise||d.linewise;if(H3){s2(c,F3,G3);}else if(b.forward){q2(c,F3,G3);}I3='char';var M3=!b.inclusive||H3;J3=n2(c,{anchor:F3,head:G3},I3,M3);}c.setSelections(J3.ranges,J3.primary);v.lastMotion=null;d.repeat=p;d.registerName=r;d.linewise=H3;var N3=M1[o](c,d,J3.ranges,j,n);if(v.visualMode){p2(c,N3!=null);}if(N3){c.setCursor(N3);}}},recordLastEdit:function(v,i,a){var m=y1.macroModeState;if(m.isPlaying){return;}v.lastEditInputState=i;v.lastEditActionCommand=a;m.lastInsertModeChanges.changes=[];m.lastInsertModeChanges.expectCursorActivityForChange=false;}};var J1={moveToTopLine:function(c,_,m){var a=d3(c).top+m.repeat-1;return P(a,t2(c.getLine(a)));},moveToMiddleLine:function(c){var r=d3(c);var a=Math.floor((r.top+r.bottom)*0.5);return P(a,t2(c.getLine(a)));},moveToBottomLine:function(c,_,m){var a=d3(c).bottom-m.repeat+1;return P(a,t2(c.getLine(a)));},expandToLine:function(_,h,m){var c=h;return P(c.line+m.repeat-1,Infinity);},findNext:function(c,_,m){var s=K2(c);var a=s.getQuery();if(!a){return;}var p=!m.forward;p=(s.isReversed())?!p:p;_2(c,a);return a3(c,p,a,m.repeat);},goToMark:function(c,_,m,v){var a=v.marks[m.selectedCharacter];if(a){var p=a.find();return m.linewise?{line:p.line,ch:t2(c.getLine(p.line))}:p;}return null;},moveToOtherHighlightedEnd:function(c,_,m,v){if(v.visualBlock&&m.sameLine){var s=v.sel;return[Q1(c,P(s.anchor.line,s.head.ch)),Q1(c,P(s.head.line,s.anchor.ch))];}else{return([v.sel.head,v.sel.anchor]);}},jumpToMark:function(c,h,m,v){var b=h;for(var i=0;i<m.repeat;i++){var a=b;for(var k in v.marks){if(!j1(k)){continue;}var d=v.marks[k].find();var e=(m.forward)?$1(d,a):$1(a,d);if(e){continue;}if(m.linewise&&(d.line==a.line)){continue;}var f=Z1(a,b);var j=(m.forward)?b2(a,d,b):b2(b,d,a);if(f||j){b=d;}}}if(m.linewise){b=P(b.line,t2(c.getLine(b.line)));}return b;},moveByCharacters:function(_,h,m){var c=h;var r=m.repeat;var a=m.forward?c.ch+r:c.ch-r;return P(c.line,a);},moveByLines:function(c,h,m,v){var a=h;var e=a.ch;switch(v.lastMotion){case this.moveByLines:case this.moveByDisplayLines:case this.moveByScroll:case this.moveToColumn:case this.moveToEol:e=v.lastHPos;break;default:v.lastHPos=e;}var r=m.repeat+(m.repeatOffset||0);var b=m.forward?a.line+r:a.line-r;var f=c.firstLine();var d=c.lastLine();if((b<f&&a.line==f)||(b>d&&a.line==d)){return;}var i=c.ace.session.getFoldLine(b);if(i){if(m.forward){if(b>i.start.row)b=i.end.row+1;}else{b=i.start.row;}}if(m.toFirstChar){e=t2(c.getLine(b));v.lastHPos=e;}v.lastHSPos=c.charCoords(P(b,e),'div').left;return P(b,e);},moveByDisplayLines:function(c,h,m,v){var a=h;switch(v.lastMotion){case this.moveByDisplayLines:case this.moveByScroll:case this.moveByLines:case this.moveToColumn:case this.moveToEol:break;default:v.lastHSPos=c.charCoords(a,'div').left;}var r=m.repeat;var b=c.findPosV(a,(m.forward?r:-r),'line',v.lastHSPos);if(b.hitSide){if(m.forward){var d=c.charCoords(b,'div');var e={top:d.top+8,left:v.lastHSPos};var b=c.coordsChar(e,'div');}else{var f=c.charCoords(P(c.firstLine(),0),'div');f.left=v.lastHSPos;b=c.coordsChar(f,'div');}}v.lastHPos=b.ch;return b;},moveByPage:function(c,h,m){var a=h;var r=m.repeat;return c.findPosV(a,(m.forward?r:-r),'page');},moveByParagraph:function(c,h,m){var d=m.forward?1:-1;return G2(c,h,m.repeat,d);},moveByScroll:function(c,h,m,v){var s=c.getScrollInfo();var a=null;var r=m.repeat;if(!r){r=s.clientHeight/(2*c.defaultTextHeight());}var o=c.charCoords(h,'local');m.repeat=r;var a=J1.moveByDisplayLines(c,h,m,v);if(!a){return null;}var d=c.charCoords(a,'local');c.scrollTo(null,s.top+d.top-o.top);return a;},moveByWords:function(c,h,m){return B2(c,h,m.repeat,!!m.forward,!!m.wordEnd,!!m.bigWord);},moveTillCharacter:function(c,_,m){var r=m.repeat;var a=C2(c,r,m.forward,m.selectedCharacter);var i=m.forward?-1:1;w2(i,m);if(!a)return null;a.ch+=i;return a;},moveToCharacter:function(c,h,m){var r=m.repeat;w2(0,m);return C2(c,r,m.forward,m.selectedCharacter)||h;},moveToSymbol:function(c,h,m){var r=m.repeat;return z2(c,r,m.forward,m.selectedCharacter)||h;},moveToColumn:function(c,h,m,v){var r=m.repeat;v.lastHPos=r-1;v.lastHSPos=c.charCoords(h,'div').left;return D2(c,r);},moveToEol:function(c,h,m,v){var a=h;v.lastHPos=Infinity;var r=P(a.line+m.repeat-1,Infinity);var e=c.clipPos(r);e.ch--;v.lastHSPos=c.charCoords(e,'div').left;return r;},moveToFirstNonWhiteSpaceCharacter:function(c,h){var a=h;return P(a.line,t2(c.getLine(a.line)));},moveToMatchedSymbol:function(c,h){var a=h;var b=a.line;var d=a.ch;var e=c.getLine(b);var s;do{s=e.charAt(d++);if(s&&k1(s)){var f=c.getTokenTypeAt(P(b,d));if(f!=="string"&&f!=="comment"){break;}}}while(s);if(s){var m=c.findMatchingBracket(P(b,d));return m.to;}else{return a;}},moveToStartOfLine:function(_,h){return P(h.line,0);},moveToLineOrEdgeOfDocument:function(c,_,m){var a=m.forward?c.lastLine():c.firstLine();if(m.repeatIsExplicit){a=m.repeat-c.getOption('firstLineNumber');}return P(a,t2(c.getLine(a)));},textObjectManipulation:function(c,h,m,v){var a={'(':')',')':'(','{':'}','}':'{','[':']',']':'['};var s={'\'':true,'"':true};var b=m.selectedCharacter;if(b=='b'){b='(';}else if(b=='B'){b='{';}var i=!m.textObjectInner;var d;if(a[b]){d=H2(c,h,b,i);}else if(s[b]){d=I2(c,h,b,i);}else if(b==='W'){d=u2(c,i,true,true);}else if(b==='w'){d=u2(c,i,true,false);}else if(b==='p'){d=G2(c,h,m.repeat,0,i);m.linewise=true;if(v.visualMode){if(!v.visualLine){v.visualLine=true;}}else{var o=v.inputState.operatorArgs;if(o){o.linewise=true;}d.end.line--;}}else{return null;}if(!c.state.vim.visualMode){return[d.start,d.end];}else{return l2(c,d.start,d.end);}},repeatLastCharacterSearch:function(c,h,m){var a=y1.lastChararacterSearch;var r=m.repeat;var f=m.forward===a.forward;var i=(a.increment?1:0)*(f?-1:1);c.moveH(-i,'char');m.inclusive=f?true:false;var b=C2(c,r,f,a.selectedCharacter);if(!b){c.moveH(i,'char');return h;}b.ch+=i;return b;}};function K1(n,f){J1[n]=f;}function L1(v,a){var b=[];for(var i=0;i<a;i++){b.push(v);}return b;}var M1={change:function(c,a,r){var f,b;var v=c.state.vim;y1.macroModeState.lastInsertModeChanges.inVisualBlock=v.visualBlock;if(!v.visualMode){var d=r[0].anchor,h=r[0].head;b=c.getRange(d,h);var e=v.lastEditInputState||{};if(e.motion=="moveByWords"&&!n1(b)){var m=(/\s+$/).exec(b);if(m&&e.motionArgs&&e.motionArgs.forward){h=S1(h,0,-m[0].length);b=b.slice(0,-m[0].length);}}var p=new P(d.line-1,Number.MAX_VALUE);var w=c.firstLine()==c.lastLine();if(h.line>c.lastLine()&&a.linewise&&!w){c.replaceRange('',p,h);}else{c.replaceRange('',d,h);}if(a.linewise){if(!w){c.setCursor(p);F.commands.newlineAndIndent(c);}d.ch=Number.MAX_VALUE;}f=d;}else{b=c.getSelection();var i=L1('',r.length);c.replaceSelections(i);f=_1(r[0].head,r[0].anchor);}y1.registerController.pushText(a.registerName,'change',b,a.linewise,r.length>1);O1.enterInsertMode(c,{head:f},c.state.vim);},'delete':function(c,a,r){var f,b;var v=c.state.vim;if(!v.visualBlock){var d=r[0].anchor,h=r[0].head;if(a.linewise&&h.line!=c.firstLine()&&d.line==c.lastLine()&&d.line==h.line-1){if(d.line==c.firstLine()){d.ch=0;}else{d=P(d.line-1,c2(c,d.line-1));}}b=c.getRange(d,h);c.replaceRange('',d,h);f=d;if(a.linewise){f=J1.moveToFirstNonWhiteSpaceCharacter(c,d);}}else{b=c.getSelection();var e=L1('',r.length);c.replaceSelections(e);f=r[0].anchor;}y1.registerController.pushText(a.registerName,'delete',b,a.linewise,v.visualBlock);return Q1(c,f);},indent:function(c,a,r){var v=c.state.vim;var s=r[0].anchor.line;var e=v.visualBlock?r[r.length-1].anchor.line:r[0].head.line;var b=(v.visualMode)?a.repeat:1;if(a.linewise){e--;}for(var i=s;i<=e;i++){for(var j=0;j<b;j++){c.indentLine(i,a.indentRight);}}return J1.moveToFirstNonWhiteSpaceCharacter(c,r[0].anchor);},changeCase:function(c,a,r,o,n){var s=c.getSelections();var b=[];var d=a.toLower;for(var j=0;j<s.length;j++){var e=s[j];var f='';if(d===true){f=e.toLowerCase();}else if(d===false){f=e.toUpperCase();}else{for(var i=0;i<e.length;i++){var h=e.charAt(i);f+=m1(h)?h.toLowerCase():h.toUpperCase();}}b.push(f);}c.replaceSelections(b);if(a.shouldMoveCursor){return n;}else if(!c.state.vim.visualMode&&a.linewise&&r[0].anchor.line+1==r[0].head.line){return J1.moveToFirstNonWhiteSpaceCharacter(c,o);}else if(a.linewise){return o;}else{return _1(r[0].anchor,r[0].head);}},yank:function(c,a,r,o){var v=c.state.vim;var b=c.getSelection();var e=v.visualMode?_1(v.sel.anchor,v.sel.head,r[0].head,r[0].anchor):o;y1.registerController.pushText(a.registerName,'yank',b,a.linewise,v.visualBlock);return e;}};function N1(n,f){M1[n]=f;}var O1={jumpListWalk:function(c,a,v){if(v.visualMode){return;}var r=a.repeat;var f=a.forward;var j=y1.jumpList;var m=j.move(c,f?r:-r);var b=m?m.find():undefined;b=b?b:c.getCursor();c.setCursor(b);c.ace.curOp.command.scrollIntoView="center-animate";},scroll:function(c,a,v){if(v.visualMode){return;}var r=a.repeat||1;var b=c.defaultTextHeight();var d=c.getScrollInfo().top;var e=b*r;var n=a.forward?d+e:d-e;var f=Y1(c.getCursor());var h=c.charCoords(f,'local');if(a.forward){if(n>h.top){f.line+=(n-h.top)/b;f.line=Math.ceil(f.line);c.setCursor(f);h=c.charCoords(f,'local');c.scrollTo(null,h.top);}else{c.scrollTo(null,n);}}else{var i=n+c.getScrollInfo().clientHeight;if(i<h.bottom){f.line-=(h.bottom-i)/b;f.line=Math.floor(f.line);c.setCursor(f);h=c.charCoords(f,'local');c.scrollTo(null,h.bottom-c.getScrollInfo().clientHeight);}else{c.scrollTo(null,n);}}},scrollToCursor:function(c,a){var b=c.getCursor().line;var d=c.charCoords(P(b,0),'local');var h=c.getScrollInfo().clientHeight;var y=d.top;var e=d.bottom-y;switch(a.position){case'center':y=y-(h/2)+e;break;case'bottom':y=y-h+e*1.4;break;case'top':y=y+e*0.4;break;}c.scrollTo(null,y);},replayMacro:function(c,a,v){var r=a.selectedCharacter;var b=a.repeat;var m=y1.macroModeState;if(r=='@'){r=m.latestRegister;}while(b--){l3(c,v,m,r);}},enterMacroRecordMode:function(c,a){var m=y1.macroModeState;var r=a.selectedCharacter;m.enterMacroRecordMode(c,r);},enterInsertMode:function(c,a,v){if(c.getOption('readOnly')){return;}v.insertMode=true;v.insertModeRepeat=a&&a.repeat||1;var i=(a)?a.insertAt:null;var s=v.sel;var h=a.head||c.getCursor('head');var b=c.listSelections().length;if(i=='eol'){h=P(h.line,c2(c,h.line));}else if(i=='charAfter'){h=S1(h,0,1);}else if(i=='firstNonBlank'){h=J1.moveToFirstNonWhiteSpaceCharacter(c,h);}else if(i=='startOfSelectedArea'){if(!v.visualBlock){if(s.head.line<s.anchor.line){h=s.head;}else{h=P(s.anchor.line,0);}}else{h=P(Math.min(s.head.line,s.anchor.line),Math.min(s.head.ch,s.anchor.ch));b=Math.abs(s.head.line-s.anchor.line)+1;}}else if(i=='endOfSelectedArea'){if(!v.visualBlock){if(s.head.line>=s.anchor.line){h=S1(s.head,0,1);}else{h=P(s.anchor.line,0);}}else{h=P(Math.min(s.head.line,s.anchor.line),Math.max(s.head.ch+1,s.anchor.ch));b=Math.abs(s.head.line-s.anchor.line)+1;}}else if(i=='inplace'){if(v.visualMode){return;}}c.setOption('keyMap','vim-insert');c.setOption('disableInput',false);if(a&&a.replace){c.toggleOverwrite(true);c.setOption('keyMap','vim-replace');F.signal(c,"vim-mode-change",{mode:"replace"});}else{c.setOption('keyMap','vim-insert');F.signal(c,"vim-mode-change",{mode:"insert"});}if(!y1.macroModeState.isPlaying){c.on('change',p3);F.on(c.getInputField(),'keydown',u3);}if(v.visualMode){p2(c);}h2(c,h,b);},toggleVisualMode:function(c,a,v){var r=a.repeat;var b=c.getCursor();var h;if(!v.visualMode){v.visualMode=true;v.visualLine=!!a.linewise;v.visualBlock=!!a.blockwise;h=Q1(c,P(b.line,b.ch+r-1),true);v.sel={anchor:b,head:h};F.signal(c,"vim-mode-change",{mode:"visual",subMode:v.visualLine?"linewise":v.visualBlock?"blockwise":""});m2(c);E2(c,v,'<',_1(b,h));E2(c,v,'>',a2(b,h));}else if(v.visualLine^a.linewise||v.visualBlock^a.blockwise){v.visualLine=!!a.linewise;v.visualBlock=!!a.blockwise;F.signal(c,"vim-mode-change",{mode:"visual",subMode:v.visualLine?"linewise":v.visualBlock?"blockwise":""});m2(c);}else{p2(c);}},reselectLastSelection:function(c,_,v){var a=v.lastSelection;if(v.visualMode){k2(c,v);}if(a){var b=a.anchorMark.find();var h=a.headMark.find();if(!b||!h){return;}v.sel={anchor:b,head:h};v.visualMode=true;v.visualLine=a.visualLine;v.visualBlock=a.visualBlock;m2(c);E2(c,v,'<',_1(b,h));E2(c,v,'>',a2(b,h));F.signal(c,'vim-mode-change',{mode:'visual',subMode:v.visualLine?'linewise':v.visualBlock?'blockwise':''});}},joinLines:function(c,a,v){var b,d;if(v.visualMode){b=c.getCursor('anchor');d=c.getCursor('head');if($1(d,b)){var e=d;d=b;b=e;}d.ch=c2(c,d.line)-1;}else{var r=Math.max(a.repeat,2);b=c.getCursor();d=Q1(c,P(b.line+r-1,Infinity));}var f=0;for(var i=b.line;i<d.line;i++){f=c2(c,b.line);var e=P(b.line+1,c2(c,b.line+1));var h=c.getRange(b,e);h=h.replace(/\n\s*/g,' ');c.replaceRange(h,b,e);}var j=P(b.line,f);if(v.visualMode){p2(c,false);}c.setCursor(j);},newLineAndEnterInsertMode:function(c,a,v){v.insertMode=true;var i=Y1(c.getCursor());if(i.line===c.firstLine()&&!a.after){c.replaceRange('\n',P(c.firstLine(),0));c.setCursor(c.firstLine(),0);}else{i.line=(a.after)?i.line:i.line-1;i.ch=c2(c,i.line);c.setCursor(i);var n=F.commands.newlineAndIndentContinueComment||F.commands.newlineAndIndent;n(c);}this.enterInsertMode(c,{repeat:a.repeat},v);},paste:function(c,a,v){var b=Y1(c.getCursor());var r=y1.registerController.getRegister(a.registerName);var d=r.toString();if(!d){return;}if(a.matchIndent){var e=c.getOption("tabSize");var w=function(J3){var K3=(J3.split("\t").length-1);var L3=(J3.split(" ").length-1);return K3*e+L3*1;};var f=c.getLine(c.getCursor().line);var h=w(f.match(/^\s*/)[0]);var j=d.replace(/\n$/,'');var k=d!==j;var m=w(d.match(/^\s*/)[0]);var d=j.replace(/^\s*/gm,function(J3){var K3=h+(w(J3)-m);if(K3<0){return"";}else if(c.getOption("indentWithTabs")){var L3=Math.floor(K3/e);return Array(L3+1).join('\t');}else{return Array(K3+1).join(' ');}});d+=k?"\n":"";}if(a.repeat>1){var d=Array(a.repeat+1).join(d);}var n=r.linewise;var o=r.blockwise;if(n&&!o){if(v.visualMode){d=v.visualLine?d.slice(0,-1):'\n'+d.slice(0,d.length-1)+'\n';}else if(a.after){d='\n'+d.slice(0,d.length-1);b.ch=c2(c,b.line);}else{b.ch=0;}}else{if(o){d=d.split('\n');for(var i=0;i<d.length;i++){d[i]=(d[i]=='')?' ':d[i];}}b.ch+=a.after?1:0;}var p;var s;if(v.visualMode){v.lastPastedText=d;var x;var y=j2(c,v);var _=y[0];var r1=y[1];var r2=c.getSelection();var F3=c.listSelections();var G3=new Array(F3.length).join('1').split('1');if(v.lastSelection){x=v.lastSelection.headMark.find();}y1.registerController.unnamedRegister.setText(r2);if(o){c.replaceSelections(G3);r1=P(_.line+d.length-1,_.ch);c.setCursor(_);g2(c,r1);c.replaceSelections(d);p=_;}else if(v.visualBlock){c.replaceSelections(G3);c.setCursor(_);c.replaceRange(d,_,_);p=_;}else{c.replaceRange(d,_,r1);p=c.posFromIndex(c.indexFromPos(_)+d.length-1);}if(x){v.lastSelection.headMark=c.setBookmark(x);}if(n){p.ch=0;}}else{if(o){c.setCursor(b);for(var i=0;i<d.length;i++){var H3=b.line+i;if(H3>c.lastLine()){c.replaceRange('\n',P(H3,0));}var I3=c2(c,H3);if(I3<b.ch){f2(c,H3,b.ch);}}c.setCursor(b);g2(c,P(b.line+d.length-1,b.ch));c.replaceSelections(d);p=b;}else{c.replaceRange(d,b);if(n&&a.after){p=P(b.line+1,t2(c.getLine(b.line+1)));}else if(n&&!a.after){p=P(b.line,t2(c.getLine(b.line)));}else if(!n&&a.after){s=c.indexFromPos(b);p=c.posFromIndex(s+d.length-1);}else{s=c.indexFromPos(b);p=c.posFromIndex(s+d.length);}}}if(v.visualMode){p2(c,false);}c.setCursor(p);},undo:function(c,a){c.operation(function(){X1(c,F.commands.undo,a.repeat)();c.setCursor(c.getCursor('anchor'));});},redo:function(c,a){X1(c,F.commands.redo,a.repeat)();},setRegister:function(_,a,v){v.inputState.registerName=a.selectedCharacter;},setMark:function(c,a,v){var m=a.selectedCharacter;E2(c,v,m,c.getCursor());},replace:function(c,a,v){var r=a.selectedCharacter;var b=c.getCursor();var d;var e;var s=c.listSelections();if(v.visualMode){b=c.getCursor('start');e=c.getCursor('end');}else{var f=c.getLine(b.line);d=b.ch+a.repeat;if(d>f.length){d=f.length;}e=P(b.line,d);}if(r=='\n'){if(!v.visualMode)c.replaceRange('',b,e);(F.commands.newlineAndIndentContinueComment||F.commands.newlineAndIndent)(c);}else{var h=c.getRange(b,e);h=h.replace(/[^\n]/g,r);if(v.visualBlock){var i=new Array(c.getOption("tabSize")+1).join(' ');h=c.getSelection();h=h.replace(/\t/g,i).replace(/[^\n]/g,r).split('\n');c.replaceSelections(h);}else{c.replaceRange(h,b,e);}if(v.visualMode){b=$1(s[0].anchor,s[0].head)?s[0].anchor:s[0].head;c.setCursor(b);p2(c,false);}else{c.setCursor(S1(e,0,-1));}}},incrementNumberToken:function(c,a){var b=c.getCursor();var d=c.getLine(b.line);var r=/-?\d+/g;var m;var s;var e;var n;var f;while((m=r.exec(d))!==null){f=m[0];s=m.index;e=s+f.length;if(b.ch<e)break;}if(!a.backtrack&&(e<=b.ch))return;if(f){var i=a.increase?1:-1;var h=parseInt(f)+(i*a.repeat);var j=P(b.line,s);var k=P(b.line,e);n=h.toString();c.replaceRange(n,j,k);}else{return;}c.setCursor(P(b.line,s+n.length-1));},repeatLastEdit:function(c,a,v){var b=v.lastEditInputState;if(!b){return;}var r=a.repeat;if(r&&a.repeatIsExplicit){v.lastEditInputState.repeatOverride=r;}else{r=v.lastEditInputState.repeatOverride||r;}v3(c,v,r,false);},exitInsertMode:i3};function P1(n,f){O1[n]=f;}function Q1(c,a,i){var b=Math.min(Math.max(c.firstLine(),a.line),c.lastLine());var m=c2(c,b)-1;m=(i)?m+1:m;var d=Math.min(Math.max(0,a.ch),m);return P(b,d);}function R1(a){var r={};for(var p in a){if(a.hasOwnProperty(p)){r[p]=a[p];}}return r;}function S1(c,o,a){if(typeof o==='object'){a=o.ch;o=o.line;}return P(c.line+o,c.ch+a);}function T1(a,h){return{line:h.line-a.line,ch:h.line-a.line};}function U1(k,a,c,b){var m,p=[],f=[];for(var i=0;i<a.length;i++){var d=a[i];if(c=='insert'&&d.context!='insert'||d.context&&d.context!=c||b.operator&&d.type=='action'||!(m=V1(k,d.keys))){continue;}if(m=='partial'){p.push(d);}if(m=='full'){f.push(d);}}return{partial:p.length&&p,full:f.length&&f};}function V1(p,m){if(m.slice(-11)=='<character>'){var a=m.length-11;var b=p.slice(0,a);var c=m.slice(0,a);return b==c&&p.length>a?'full':c.indexOf(b)==0?'partial':false;}else{return p==m?'full':m.indexOf(p)==0?'partial':false;}}function W1(k){var m=/^.*(<[\w\-]+>)$/.exec(k);var s=m?m[1]:k.slice(-1);if(s.length>1){switch(s){case'<CR>':s='\n';break;case'<Space>':s=' ';break;default:break;}}return s;}function X1(c,f,r){return function(){for(var i=0;i<r;i++){f(c);}};}function Y1(c){return P(c.line,c.ch);}function Z1(c,a){return c.ch==a.ch&&c.line==a.line;}function $1(c,a){if(c.line<a.line){return true;}if(c.line==a.line&&c.ch<a.ch){return true;}return false;}function _1(c,a){if(arguments.length>2){a=_1.apply(undefined,Array.prototype.slice.call(arguments,1));}return $1(c,a)?c:a;}function a2(c,a){if(arguments.length>2){a=a2.apply(undefined,Array.prototype.slice.call(arguments,1));}return $1(c,a)?a:c;}function b2(c,a,b){var d=$1(c,a);var e=$1(a,b);return d&&e;}function c2(c,a){return c.getLine(a).length;}function d2(s){if(s.trim){return s.trim();}return s.replace(/^\s+|\s+$/g,'');}function e2(s){return s.replace(/([.?*+$\[\]\/\\(){}|\-])/g,'\\$1');}function f2(c,a,b){var e=c2(c,a);var s=new Array(b-e+1).join(' ');c.setCursor(P(a,e));c.replaceRange(s,c.getCursor());}function g2(c,s){var a=[],r=c.listSelections();var h=Y1(c.clipPos(s));var i=!Z1(s,h);var b=c.getCursor('head');var p=i2(r,b);var w=Z1(r[p].head,r[p].anchor);var m=r.length-1;var d=m-p>p?m:0;var e=r[d].anchor;var f=Math.min(e.line,h.line);var j=Math.max(e.line,h.line);var k=e.ch,n=h.ch;var o=r[d].head.ch-k;var v=n-k;if(o>0&&v<=0){k++;if(!i){n--;}}else if(o<0&&v>=0){k--;if(!w){n++;}}else if(o<0&&v==-1){k--;n++;}for(var x=f;x<=j;x++){var y={anchor:new P(x,k),head:new P(x,n)};a.push(y);}p=h.line==j?a.length-1:0;c.setSelections(a);s.ch=n;e.ch=k;return e;}function h2(c,h,a){var s=[];for(var i=0;i<a;i++){var b=S1(h,i,0);s.push({anchor:b,head:b});}c.setSelections(s,0);}function i2(r,c,e){for(var i=0;i<r.length;i++){var a=e!='head'&&Z1(r[i].anchor,c);var b=e!='anchor'&&Z1(r[i].head,c);if(a||b){return i;}}return-1;}function j2(c,v){var a=v.lastSelection;var b=function(){var s=c.listSelections();var e=s[0];var f=s[s.length-1];var h=$1(e.anchor,e.head)?e.anchor:e.head;var i=$1(f.anchor,f.head)?f.head:f.anchor;return[h,i];};var d=function(){var s=c.getCursor();var e=c.getCursor();var f=a.visualBlock;if(f){var w=f.width;var h=f.height;e=P(s.line+h,s.ch+w);var j=[];for(var i=s.line;i<e.line;i++){var k=P(i,s.ch);var m=P(i,e.ch);var r={anchor:k,head:m};j.push(r);}c.setSelections(j);}else{var n=a.anchorMark.find();var o=a.headMark.find();var p=o.line-n.line;var x=o.ch-n.ch;e={line:e.line+p,ch:p?e.ch:x+e.ch};if(a.visualLine){s=P(s.line,0);e=P(e.line,c2(c,e.line));}c.setSelection(s,e);}return[s,e];};if(!v.visualMode){return d();}else{return b();}}function k2(c,v){var a=v.sel.anchor;var h=v.sel.head;if(v.lastPastedText){h=c.posFromIndex(c.indexFromPos(a)+v.lastPastedText.length);v.lastPastedText=null;}v.lastSelection={'anchorMark':c.setBookmark(a),'headMark':c.setBookmark(h),'anchor':Y1(a),'head':Y1(h),'visualMode':v.visualMode,'visualLine':v.visualLine,'visualBlock':v.visualBlock};}function l2(c,s,e){var a=c.state.vim.sel;var h=a.head;var b=a.anchor;var d;if($1(e,s)){d=e;e=s;s=d;}if($1(h,b)){h=_1(s,h);b=a2(b,e);}else{b=_1(s,b);h=a2(h,e);h=S1(h,0,-1);if(h.ch==-1&&h.line!=c.firstLine()){h=P(h.line-1,c2(c,h.line-1));}}return[b,h];}function m2(c,s,m){var v=c.state.vim;s=s||v.sel;var m=m||v.visualLine?'line':v.visualBlock?'block':'char';var a=n2(c,s,m);c.setSelections(a.ranges,a.primary);r3(c);}function n2(c,s,m,e){var h=Y1(s.head);var a=Y1(s.anchor);if(m=='char'){var b=!e&&!$1(s.head,s.anchor)?1:0;var d=$1(s.head,s.anchor)?1:0;h=S1(s.head,0,b);a=S1(s.anchor,0,d);return{ranges:[{anchor:a,head:h}],primary:0};}else if(m=='line'){if(!$1(s.head,s.anchor)){a.ch=0;var f=c.lastLine();if(h.line>f){h.line=f;}h.ch=c2(c,h.line);}else{h.ch=0;a.ch=c2(c,a.line);}return{ranges:[{anchor:a,head:h}],primary:0};}else if(m=='block'){var j=Math.min(a.line,h.line),k=Math.min(a.ch,h.ch),n=Math.max(a.line,h.line),r=Math.max(a.ch,h.ch)+1;var o=n-j+1;var p=h.line==j?0:o-1;var v=[];for(var i=0;i<o;i++){v.push({anchor:P(j+i,k),head:P(j+i,r)});}return{ranges:v,primary:p};}}function o2(c){var a=c.getCursor('head');if(c.getSelection().length==1){a=_1(a,c.getCursor('anchor'));}return a;}function p2(c,m){var v=c.state.vim;if(m!==false){c.setCursor(Q1(c,v.sel.head));}k2(c,v);v.visualMode=false;v.visualLine=false;v.visualBlock=false;F.signal(c,"vim-mode-change",{mode:"normal"});if(v.fakeCursor){v.fakeCursor.clear();}}function q2(c,a,b){var s=c.getRange(a,b);if(/\n\s*$/.test(s)){var d=s.split('\n');d.pop();var e;for(var e=d.pop();d.length>0&&e&&n1(e);e=d.pop()){b.line--;b.ch=0;}if(e){b.line--;b.ch=c2(c,b.line);}else{b.ch=0;}}}function s2(_,c,a){c.ch=0;a.ch=0;a.line++;}function t2(a){if(!a){return 0;}var f=a.search(/\S/);return f==-1?a.length:f;}function u2(c,i,_,b,n){var a=o2(c);var d=c.getLine(a.line);var e=a.ch;var f=n?a1[0]:b1[0];while(!f(d.charAt(e))){e++;if(e>=d.length){return null;}}if(b){f=b1[0];}else{f=a1[0];if(!f(d.charAt(e))){f=a1[1];}}var h=e,s=e;while(f(d.charAt(h))&&h<d.length){h++;}while(f(d.charAt(s))&&s>=0){s--;}s++;if(i){var w=h;while(/\s/.test(d.charAt(h))&&h<d.length){h++;}if(w==h){var j=s;while(/\s/.test(d.charAt(s-1))&&s>0){s--;}if(!s){s=j;}}}return{start:P(a.line,s),end:P(a.line,h)};}function v2(c,o,n){if(!Z1(o,n)){y1.jumpList.add(c,o,n);}}function w2(i,a){y1.lastChararacterSearch.increment=i;y1.lastChararacterSearch.forward=a.forward;y1.lastChararacterSearch.selectedCharacter=a.selectedCharacter;}var x2={'(':'bracket',')':'bracket','{':'bracket','}':'bracket','[':'section',']':'section','*':'comment','/':'comment','m':'method','M':'method','#':'preprocess'};var y2={bracket:{isComplete:function(s){if(s.nextCh===s.symb){s.depth++;if(s.depth>=1)return true;}else if(s.nextCh===s.reverseSymb){s.depth--;}return false;}},section:{init:function(s){s.curMoveThrough=true;s.symb=(s.forward?']':'[')===s.symb?'{':'}';},isComplete:function(s){return s.index===0&&s.nextCh===s.symb;}},comment:{isComplete:function(s){var f=s.lastCh==='*'&&s.nextCh==='/';s.lastCh=s.nextCh;return f;}},method:{init:function(s){s.symb=(s.symb==='m'?'{':'}');s.reverseSymb=s.symb==='{'?'}':'{';},isComplete:function(s){if(s.nextCh===s.symb)return true;return false;}},preprocess:{init:function(s){s.index=0;},isComplete:function(s){if(s.nextCh==='#'){var a=s.lineText.match(/#(\w+)/)[1];if(a==='endif'){if(s.forward&&s.depth===0){return true;}s.depth++;}else if(a==='if'){if(!s.forward&&s.depth===0){return true;}s.depth--;}if(a==='else'&&s.depth===0)return true;}return false;}}};function z2(c,r,f,s){var a=Y1(c.getCursor());var i=f?1:-1;var e=f?c.lineCount():-1;var b=a.ch;var d=a.line;var h=c.getLine(d);var j={lineText:h,nextCh:h.charAt(b),lastCh:null,index:b,symb:s,reverseSymb:(f?{')':'(','}':'{'}:{'(':')','{':'}'})[s],forward:f,depth:0,curMoveThrough:false};var m=x2[s];if(!m)return a;var k=y2[m].init;var n=y2[m].isComplete;if(k){k(j);}while(d!==e&&r){j.index+=i;j.nextCh=j.lineText.charAt(j.index);if(!j.nextCh){d+=i;j.lineText=c.getLine(d)||'';if(i>0){j.index=0;}else{var o=j.lineText.length;j.index=(o>0)?(o-1):0;}j.nextCh=j.lineText.charAt(j.index);}if(n(j)){a.line=d;a.ch=j.index;r--;}}if(j.nextCh||j.curMoveThrough){return P(d,j.index);}return a;}function A2(c,a,f,b,e){var d=a.line;var p=a.ch;var h=c.getLine(d);var j=f?1:-1;var k=b?b1:a1;if(e&&h==''){d+=j;h=c.getLine(d);if(!i1(c,d)){return null;}p=(f)?0:h.length;}while(true){if(e&&h==''){return{from:0,to:0,line:d};}var s=(j>0)?h.length:-1;var w=s,m=s;while(p!=s){var n=false;for(var i=0;i<k.length&&!n;++i){if(k[i](h.charAt(p))){w=p;while(p!=s&&k[i](h.charAt(p))){p+=j;}m=p;n=w!=m;if(w==a.ch&&d==a.line&&m==w+j){continue;}else{return{from:Math.min(w,m+1),to:Math.max(w,m),line:d};}}}if(!n){p+=j;}}d+=j;if(!i1(c,d)){return null;}h=c.getLine(d);p=(j>0)?0:h.length;}throw new Error('The impossible happened.');}function B2(c,a,r,f,w,b){var d=Y1(a);var e=[];if(f&&!w||!f&&w){r++;}var h=!(f&&w);for(var i=0;i<r;i++){var j=A2(c,a,f,b,h);if(!j){var k=c2(c,c.lastLine());e.push(f?{line:c.lastLine(),from:k,to:k}:{line:0,from:0,to:0});break;}e.push(j);a=P(j.line,f?(j.to-1):j.from);}var s=e.length!=r;var m=e[0];var n=e.pop();if(f&&!w){if(!s&&(m.from!=d.ch||m.line!=d.line)){n=e.pop();}return P(n.line,n.from);}else if(f&&w){return P(n.line,n.to-1);}else if(!f&&w){if(!s&&(m.to!=d.ch||m.line!=d.line)){n=e.pop();}return P(n.line,n.to);}else{return P(n.line,n.from);}}function C2(c,r,f,a){var b=c.getCursor();var s=b.ch;var d;for(var i=0;i<r;i++){var e=c.getLine(b.line);d=F2(s,e,a,f,true);if(d==-1){return null;}s=d;}return P(c.getCursor().line,d);}function D2(c,r){var a=c.getCursor().line;return Q1(c,P(a,r-1));}function E2(c,v,m,p){if(!o1(m,g1)){return;}if(v.marks[m]){v.marks[m].clear();}v.marks[m]=c.setBookmark(p);}function F2(s,a,c,f,i){var b;if(f){b=a.indexOf(c,s+1);if(b!=-1&&!i){b-=1;}}else{b=a.lastIndexOf(c,s-1);if(b!=-1&&!i){b+=1;}}return b;}function G2(c,h,r,d,a){var b=h.line;var m=c.firstLine();var e=c.lastLine();var s,f,i=b;function j(i){return!/\S/.test(c.getLine(i));}function k(i,d,w){if(w){return j(i)!=j(i+d);}return!j(i)&&j(i+d);}function n(i){d=d>0?1:-1;var w=c.ace.session.getFoldLine(i);if(w){if(i+d>w.start.row&&i+d<w.end.row)d=(d>0?w.end.row:w.start.row)-i;}}if(d){while(m<=i&&i<=e&&r>0){n(i);if(k(i,d)){r--;}i+=d;}return new P(i,0);}var v=c.state.vim;if(v.visualLine&&k(b,1,true)){var o=v.sel.anchor;if(k(o.line,-1,true)){if(!a||o.line!=b){b+=1;}}}var p=j(b);for(i=b;i<=e&&r;i++){if(k(i,1,true)){if(!a||j(i)!=p){r--;}}}f=new P(i,0);if(i>e&&!p){p=true;}else{a=false;}for(i=b;i>m;i--){if(!a||j(i)==p||i==b){if(k(i,-1,true)){break;}}}s=new P(i,0);return{start:s,end:f};}function H2(c,h,s,i){var a=h,b,e;var d=({'(':/[()]/,')':/[()]/,'[':/[[\]]/,']':/[[\]]/,'{':/[{}]/,'}':/[{}]/})[s];var o=({'(':'(',')':'(','[':'[',']':'[','{':'{','}':'{'})[s];var f=c.getLine(a.line).charAt(a.ch);var j=f===o?1:0;b=c.scanForBracket(P(a.line,a.ch+j),-1,null,{'bracketRegex':d});e=c.scanForBracket(P(a.line,a.ch+j),1,null,{'bracketRegex':d});if(!b||!e){return{start:a,end:a};}b=b.pos;e=e.pos;if((b.line==e.line&&b.ch>e.ch)||(b.line>e.line)){var k=b;b=e;e=k;}if(i){e.ch+=1;}else{b.ch+=1;}return{start:b,end:e};}function I2(c,h,s,a){var b=Y1(h);var d=c.getLine(b.line);var e=d.split('');var f,j,i,k;var m=e.indexOf(s);if(b.ch<m){b.ch=m;}else if(m<b.ch&&e[b.ch]==s){j=b.ch;--b.ch;}if(e[b.ch]==s&&!j){f=b.ch+1;}else{for(i=b.ch;i>-1&&!f;i--){if(e[i]==s){f=i+1;}}}if(f&&!j){for(i=f,k=e.length;i<k&&!j;i++){if(e[i]==s){j=i;}}}if(!f||!j){return{start:b,end:b};}if(a){--f;++j;}return{start:P(b.line,f),end:P(b.line,j)};}q1('pcre',true,'boolean');function J2(){}J2.prototype={getQuery:function(){return y1.query;},setQuery:function(a){y1.query=a;},getOverlay:function(){return this.searchOverlay;},setOverlay:function(o){this.searchOverlay=o;},isReversed:function(){return y1.isReversed;},setReversed:function(r){y1.isReversed=r;},getScrollbarAnnotate:function(){return this.annotate;},setScrollbarAnnotate:function(a){this.annotate=a;}};function K2(c){var v=c.state.vim;return v.searchState_||(v.searchState_=new J2());}function L2(c,a,s,o,p1){if(c.openDialog){c.openDialog(a,o,{bottom:true,value:p1.value,onKeyDown:p1.onKeyDown,onKeyUp:p1.onKeyUp,selectValueOnOpen:false});}else{o(prompt(s,''));}}function M2(a){var s=N2(a)||[];if(!s.length)return[];var b=[];if(s[0]!==0)return;for(var i=0;i<s.length;i++){if(typeof s[i]=='number')b.push(a.substring(s[i]+1,s[i+1]));}return b;}function N2(s){var e=false;var a=[];for(var i=0;i<s.length;i++){var c=s.charAt(i);if(!e&&c=='/'){a.push(i);}e=!e&&(c=='\\');}return a;}function O2(s){var a='|(){';var b='}';var e=false;var o=[];for(var i=-1;i<s.length;i++){var c=s.charAt(i)||'';var n=s.charAt(i+1)||'';var d=(n&&a.indexOf(n)!=-1);if(e){if(c!=='\\'||!d){o.push(c);}e=false;}else{if(c==='\\'){e=true;if(n&&b.indexOf(n)!=-1){d=true;}if(!d||n==='\\'){o.push(c);}}else{o.push(c);if(d&&n!=='\\'){o.push('\\');}}}}return o.join('');}var P2={'\\n':'\n','\\r':'\r','\\t':'\t'};function Q2(s){var e=false;var o=[];for(var i=-1;i<s.length;i++){var c=s.charAt(i)||'';var n=s.charAt(i+1)||'';if(P2[c+n]){o.push(P2[c+n]);i++;}else if(e){o.push(c);e=false;}else{if(c==='\\'){e=true;if((l1(n)||n==='$')){o.push('$');}else if(n!=='/'&&n!=='\\'){o.push('\\');}}else{if(c==='$'){o.push('$');}o.push(c);if(n==='/'){o.push('\\');}}}}return o.join('');}var R2={'\\/':'/','\\\\':'\\','\\n':'\n','\\r':'\r','\\t':'\t'};function S2(s){var a=new F.StringStream(s);var o=[];while(!a.eol()){while(a.peek()&&a.peek()!='\\'){o.push(a.next());}var m=false;for(var b in R2){if(a.match(b,true)){m=true;o.push(R2[b]);break;}}if(!m){o.push(a.next());}}return o.join('');}function T2(a,i,s){var b=y1.registerController.getRegister('/');b.setText(a);if(a instanceof RegExp){return a;}var c=N2(a);var r;var f;if(!c.length){r=a;}else{r=a.substring(0,c[0]);var d=a.substring(c[0]);f=(d.indexOf('i')!=-1);}if(!r){return null;}if(!t1('pcre')){r=O2(r);}if(s){i=(/^[^A-Z]*$/).test(r);}var e=new RegExp(r,(i||f)?'i':undefined);return e;}function U2(c,a){if(c.openNotification){c.openNotification('<span style="color: red">'+a+'</span>',{bottom:true,duration:5000});}else{alert(a);}}function V2(p,d){var r='';if(p){r+='<span style="font-family: monospace">'+p+'</span>';}r+='<input type="text"/> '+'<span style="color: #888">';if(d){r+='<span style="color: #888">';r+=d;r+='</span>';}return r;}var W2='(Javascript regexp)';function X2(c,p1){var s=(p1.prefix||'')+' '+(p1.desc||'');var p=V2(p1.prefix,p1.desc);L2(c,p,s,p1.onClose,p1);}function Y2(r,a){if(r instanceof RegExp&&a instanceof RegExp){var p=['global','multiline','ignoreCase','source'];for(var i=0;i<p.length;i++){var b=p[i];if(r[b]!==a[b]){return false;}}return true;}return false;}function Z2(c,r,i,s){if(!r){return;}var a=K2(c);var b=T2(r,!!i,!!s);if(!b){return;}_2(c,b);if(Y2(b,a.getQuery())){return b;}a.setQuery(b);return b;}function $2(a){if(a.source.charAt(0)=='^'){var m=true;}return{token:function(s){if(m&&!s.sol()){s.skipToEnd();return;}var b=s.match(a,false);if(b){if(b[0].length==0){s.next();return'searching';}if(!s.sol()){s.backUp(1);if(!a.exec(s.next()+b[0])){s.next();return null;}}s.match(a);return'searching';}while(!s.eol()){s.next();if(s.match(a,false))break;}},query:a};}function _2(c,a){var s=K2(c);var o=s.getOverlay();if(!o||a!=o.query){if(o){c.removeOverlay(o);}o=$2(a);c.addOverlay(o);if(c.showMatchesOnScrollbar){if(s.getScrollbarAnnotate()){s.getScrollbarAnnotate().clear();}s.setScrollbarAnnotate(c.showMatchesOnScrollbar(a));}s.setOverlay(o);}}function a3(c,p,a,r){if(r===undefined){r=1;}return c.operation(function(){var b=c.getCursor();var d=c.getSearchCursor(a,b);for(var i=0;i<r;i++){var f=d.find(p);if(i==0&&f&&Z1(d.from(),b)){f=d.find(p);}if(!f){d=c.getSearchCursor(a,(p)?P(c.lastLine()):P(c.firstLine(),0));if(!d.find(p)){return;}}}return d.from();});}function b3(c){var s=K2(c);c.removeOverlay(K2(c).getOverlay());s.setOverlay(null);if(s.getScrollbarAnnotate()){s.getScrollbarAnnotate().clear();s.setScrollbarAnnotate(null);}}function c3(p,s,e){if(typeof p!='number'){p=p.line;}if(s instanceof Array){return o1(p,s);}else{if(e){return(p>=s&&p<=e);}else{return p==s;}}}function d3(c){var r=c.ace.renderer;return{top:r.getFirstFullyVisibleRow(),bottom:r.getLastFullyVisibleRow()}}var e3=function(){this.buildCommandMap_();};e3.prototype={processCommand:function(c,i,o){var a=this;c.operation(function(){c.curOp.isVimOp=true;a._processCommand(c,i,o);});},_processCommand:function(c,a,o){var v=c.state.vim;var b=y1.registerController.getRegister(':');var p=b.toString();if(v.visualMode){p2(c);}var d=new F.StringStream(a);b.setText(a);var f=o||{};f.input=a;try{this.parseInput_(c,d,f);}catch(e){U2(c,e);throw e;}var h;var j;if(!f.commandName){if(f.line!==undefined){j='move';}}else{h=this.matchCommand_(f.commandName);if(h){j=h.name;if(h.excludeFromCommandHistory){b.setText(p);}this.parseCommandArgs_(d,f,h);if(h.type=='exToKey'){for(var i=0;i<h.toKeys.length;i++){F.Vim.handleKey(c,h.toKeys[i],'mapping');}return;}else if(h.type=='exToEx'){this.processCommand(c,h.toInput);return;}}}if(!j){U2(c,'Not an editor command ":'+a+'"');return;}try{f3[j](c,f);if((!h||!h.possiblyAsync)&&f.callback){f.callback();}}catch(e){U2(c,e);throw e;}},parseInput_:function(c,i,r){i.eatWhile(':');if(i.eat('%')){r.line=c.firstLine();r.lineEnd=c.lastLine();}else{r.line=this.parseLineSpec_(c,i);if(r.line!==undefined&&i.eat(',')){r.lineEnd=this.parseLineSpec_(c,i);}}var V1=i.match(/^(\w+)/);if(V1){r.commandName=V1[1];}else{r.commandName=i.match(/.*/)[0];}return r;},parseLineSpec_:function(c,i){var n=i.match(/^(\d+)/);if(n){return parseInt(n[1],10)-1;}switch(i.next()){case'.':return c.getCursor().line;case'$':return c.lastLine();case'\'':var m=c.state.vim.marks[i.next()];if(m&&m.find()){return m.find().line;}throw new Error('Mark not set');default:i.backUp(1);return undefined;}},parseCommandArgs_:function(i,p,c){if(i.eol()){return;}p.argString=i.match(/.*/)[0];var d=c.argDelimiter||/\s+/;var a=d2(p.argString).split(d);if(a.length&&a[0]){p.args=a;}},matchCommand_:function(c){for(var i=c.length;i>0;i--){var p=c.substring(0,i);if(this.commandMap_[p]){var a=this.commandMap_[p];if(a.name.indexOf(c)===0){return a;}}}return null;},buildCommandMap_:function(){this.commandMap_={};for(var i=0;i<L.length;i++){var c=L[i];var k=c.shortName||c.name;this.commandMap_[k]=c;}},map:function(a,r,c){if(a!=':'&&a.charAt(0)==':'){if(c){throw Error('Mode not supported for ex mappings');}var b=a.substring(1);if(r!=':'&&r.charAt(0)==':'){this.commandMap_[b]={name:b,type:'exToEx',toInput:r.substring(1),user:true};}else{this.commandMap_[b]={name:b,type:'exToKey',toKeys:r,user:true};}}else{if(r!=':'&&r.charAt(0)==':'){var m={keys:a,type:'keyToEx',exArgs:{input:r.substring(1)},user:true};if(c){m.context=c;}J.unshift(m);}else{var m={keys:a,type:'keyToKey',toKeys:r,user:true};if(c){m.context=c;}J.unshift(m);}}},unmap:function(a,c){if(a!=':'&&a.charAt(0)==':'){if(c){throw Error('Mode not supported for ex mappings');}var b=a.substring(1);if(this.commandMap_[b]&&this.commandMap_[b].user){delete this.commandMap_[b];return;}}else{var k=a;for(var i=0;i<J.length;i++){if(k==J[i].keys&&J[i].context===c&&J[i].user){J.splice(i,1);return;}}}}};var f3={colorscheme:function(c,p){if(!p.args||p.args.length<1){U2(c,c.getOption('theme'));return;}c.setOption('theme',p.args[0]);},map:function(c,p,a){var m=p.args;if(!m||m.length<2){if(c){U2(c,'Invalid mapping: '+p.input);}return;}g3.map(m[0],m[1],a);},imap:function(c,p){this.map(c,p,'insert');},nmap:function(c,p){this.map(c,p,'normal');},vmap:function(c,p){this.map(c,p,'visual');},unmap:function(c,p,a){var m=p.args;if(!m||m.length<1){if(c){U2(c,'No such mapping: '+p.input);}return;}g3.unmap(m[0],a);},move:function(c,p){I1.processCommand(c,c.state.vim,{type:'motion',motion:'moveToLineOrEdgeOfDocument',motionArgs:{forward:false,explicitRepeat:true,linewise:true},repeatOverride:p.line+1});},set:function(c,p){var s=p.args;var a=p.setCfg||{};if(!s||s.length<1){if(c){U2(c,'Invalid mapping: '+p.input);}return;}var e=s[0].split('=');var o=e[0];var v=e[1];var f=false;if(o.charAt(o.length-1)=='?'){if(v){throw Error('Trailing characters: '+p.argString);}o=o.substring(0,o.length-1);f=true;}if(v===undefined&&o.substring(0,2)=='no'){o=o.substring(2);v=false;}var b=p1[o]&&p1[o].type=='boolean';if(b&&v==undefined){v=true;}if(!b&&v===undefined||f){var d=t1(o,c,a);if(d===true||d===false){U2(c,' '+(d?'':'no')+o);}else{U2(c,'  '+o+'='+d);}}else{s1(o,v,c,a);}},setlocal:function(c,p){p.setCfg={scope:'local'};this.set(c,p);},setglobal:function(c,p){p.setCfg={scope:'global'};this.set(c,p);},registers:function(c,p){var r=p.args;var a=y1.registerController.registers;var b='----------Registers----------<br><br>';if(!r){for(var d in a){var e=a[d].toString();if(e.length){b+='"'+d+'    '+e+'<br>';}}}else{var d;r=r.join('');for(var i=0;i<r.length;i++){d=r.charAt(i);if(!y1.registerController.isValidRegister(d)){continue;}var f=a[d]||new E1();b+='"'+d+'    '+f.toString()+'<br>';}}U2(c,b);},sort:function(c,p){var r,d,e,n;function f(){if(p.argString){var a=new F.StringStream(p.argString);if(a.eat('!')){r=true;}if(a.eol()){return;}if(!a.eatSpace()){return'Invalid arguments';}var b=a.match(/[a-z]+/);if(b){b=b[0];d=b.indexOf('i')!=-1;e=b.indexOf('u')!=-1;var r2=b.indexOf('d')!=-1&&1;var F3=b.indexOf('x')!=-1&&1;var G3=b.indexOf('o')!=-1&&1;if(r2+F3+G3>1){return'Invalid arguments';}n=r2&&'decimal'||F3&&'hex'||G3&&'octal';}if(a.match(/\/.*\//)){return'patterns not supported';}}}var h=f();if(h){U2(c,h+': '+p.argString);return;}var j=p.line||c.firstLine();var k=p.lineEnd||p.line||c.lastLine();if(j==k){return;}var m=P(j,0);var o=P(k,c2(c,k));var s=c.getRange(m,o).split('\n');var $=(n=='decimal')?/(-?)([\d]+)/:(n=='hex')?/(-?)(?:0x)?([0-9a-f]+)/i:(n=='octal')?/([0-7]+)/:null;var v=(n=='decimal')?10:(n=='hex')?16:(n=='octal')?8:null;var w=[],x=[];if(n){for(var i=0;i<s.length;i++){if($.exec(s[i])){w.push(s[i]);}else{x.push(s[i]);}}}else{x=s;}function y(a,b){if(r){var r2;r2=a;a=b;b=r2;}if(d){a=a.toLowerCase();b=b.toLowerCase();}var F3=n&&$.exec(a);var G3=n&&$.exec(b);if(!F3){return a<b?-1:1;}F3=parseInt((F3[1]+F3[2]).toLowerCase(),v);G3=parseInt((G3[1]+G3[2]).toLowerCase(),v);return F3-G3;}w.sort(y);x.sort(y);s=(!r)?x.concat(w):w.concat(x);if(e){var _=s;var r1;s=[];for(var i=0;i<_.length;i++){if(_[i]!=r1){s.push(_[i]);}r1=_[i];}}c.replaceRange(s.join('\n'),m,o);},global:function(c,p){var a=p.argString;if(!a){U2(c,'Regular Expression missing from global');return;}var b=(p.line!==undefined)?p.line:c.firstLine();var d=p.lineEnd||p.line||c.lastLine();var f=M2(a);var r=a,h;if(f.length){r=f[0];h=f.slice(1,f.length).join('/');}if(r){try{Z2(c,r,true,true);}catch(e){U2(c,'Invalid regex: '+r);return;}}var j=K2(c).getQuery();var m=[],k='';for(var i=b;i<=d;i++){var n=j.test(c.getLine(i));if(n){m.push(i+1);k+=c.getLine(i)+'<br>';}}if(!h){U2(c,k);return;}var o=0;var s=function(){if(o<m.length){var v=m[o]+h;g3.processCommand(c,v,{callback:s});}o++;};s();},substitute:function(c,p){if(!c.getSearchCursor){throw new Error('Search feature not available. Requires searchcursor.js or '+'any other getSearchCursor implementation.');}var a=p.argString;var b=a?M2(a):[];var r,d='',f,h,i;var j=false;var k=false;if(b.length){r=b[0];d=b[1];if(d!==undefined){if(t1('pcre')){d=S2(d);}else{d=Q2(d);}y1.lastSubstituteReplacePart=d;}f=b[2]?b[2].split(' '):[];}else{if(a&&a.length){U2(c,'Substitutions should be of the form '+':s/pattern/replace/');return;}}if(f){h=f[0];i=parseInt(f[1]);if(h){if(h.indexOf('c')!=-1){j=true;h.replace('c','');}if(h.indexOf('g')!=-1){k=true;h.replace('g','');}r=r+'/'+h;}}if(r){try{Z2(c,r,true,true);}catch(e){U2(c,'Invalid regex: '+r);return;}}d=d||y1.lastSubstituteReplacePart;if(d===undefined){U2(c,'No previous substitute regular expression');return;}var s=K2(c);var m=s.getQuery();var n=(p.line!==undefined)?p.line:c.getCursor().line;var o=p.lineEnd||n;if(n==c.firstLine()&&o==c.lastLine()){o=Infinity;}if(i){n=o;o=n+i-1;}var v=Q1(c,P(n,0));var w=c.getSearchCursor(m,v);h3(c,j,k,n,o,w,m,d,p.callback);},redo:F.commands.redo,undo:F.commands.undo,write:function(c){if(F.commands.save){F.commands.save(c);}else{c.save();}},nohlsearch:function(c){b3(c);},delmarks:function(c,p){if(!p.argString||!d2(p.argString)){U2(c,'Argument required');return;}var s=c.state.vim;var a=new F.StringStream(d2(p.argString));while(!a.eol()){a.eatSpace();var b=a.pos;if(!a.match(/[a-zA-Z]/,false)){U2(c,'Invalid argument: '+p.argString.substring(b));return;}var d=a.next();if(a.match('-',true)){if(!a.match(/[a-zA-Z]/,false)){U2(c,'Invalid argument: '+p.argString.substring(b));return;}var e=d;var f=a.next();if(j1(e)&&j1(f)||m1(e)&&m1(f)){var h=e.charCodeAt(0);var i=f.charCodeAt(0);if(h>=i){U2(c,'Invalid argument: '+p.argString.substring(b));return;}for(var j=0;j<=i-h;j++){var m=String.fromCharCode(h+j);delete s.marks[m];}}else{U2(c,'Invalid argument: '+e+'-');return;}}else{delete s.marks[d];}}}};var g3=new e3();function h3(c,a,b,d,f,s,h,r,i){c.state.vim.exMode=true;var j=false;var k=s.from();function m(){c.operation(function(){while(!j){n();o();}p();});}function n(){var e=c.getRange(s.from(),s.to());var w=e.replace(h,r);s.replace(w);}function o(){while(s.findNext()&&c3(s.from(),d,f)){if(!b&&k&&s.from().line==k.line){continue;}c.scrollIntoView(s.from(),30);c.setSelection(s.from(),s.to());k=s.from();j=false;return;}j=true;}function p(e){if(e){e();}c.focus();if(k){c.setCursor(k);var w=c.state.vim;w.exMode=false;w.lastHPos=w.lastHSPos=k.ch;}if(i){i();}}function v(e,_,w){F.e_stop(e);var x=F.keyName(e);switch(x){case'Y':n();o();break;case'N':o();break;case'A':var y=i;i=undefined;c.operation(m);i=y;break;case'L':n();case'Q':case'Esc':case'Ctrl-C':case'Ctrl-[':p(w);break;}if(j){p(w);}return true;}o();if(j){U2(c,'No matches for '+h.source);return;}if(!a){m();if(i){i();}return;}X2(c,{prefix:'replace with <strong>'+r+'</strong> (y/n/a/q/l)',onKeyDown:v});}F.keyMap.vim={attach:Q,detach:O,call:U};function i3(c){var v=c.state.vim;var m=y1.macroModeState;var a=y1.registerController.getRegister('.');var b=m.isPlaying;var d=m.lastInsertModeChanges;var e=[];if(!b){var s=d.inVisualBlock?v.lastSelection.visualBlock.height:1;var f=d.changes;var e=[];var i=0;while(i<f.length){e.push(f[i]);if(f[i]instanceof t3){i++;}else{i+=s;}}d.changes=e;c.off('change',p3);F.off(c.getInputField(),'keydown',u3);}if(!b&&v.insertModeRepeat>1){v3(c,v,v.insertModeRepeat-1,true);v.lastEditInputState.repeatOverride=v.insertModeRepeat;}delete v.insertModeRepeat;v.insertMode=false;c.setCursor(c.getCursor().line,c.getCursor().ch-1);c.setOption('keyMap','vim');c.setOption('disableInput',true);d.overwrite=c.state.overwrite;c.toggleOverwrite(false);a.setText(d.changes.join(''));F.signal(c,"vim-mode-change",{mode:"normal"});if(m.isRecording){n3(m);}}function j3(c){J.unshift(c);}function k3(k,a,n,b,e){var c={keys:k,type:a};c[a]=n;c[a+"Args"]=b;for(var d in e)c[d]=e[d];j3(c);}q1('insertModeEscKeysTimeout',200,'number');F.keyMap['vim-insert']={'Ctrl-N':'autocomplete','Ctrl-P':'autocomplete','Enter':function(c){var f=F.commands.newlineAndIndentContinueComment||F.commands.newlineAndIndent;f(c);},fallthrough:['default'],attach:Q,detach:O,call:U};F.keyMap['vim-replace']={'Backspace':'goCharLeft',fallthrough:['vim-insert'],attach:Q,detach:O,call:U};function l3(c,v,m,r){var a=y1.registerController.getRegister(r);if(r==':'){if(a.keyBuffer[0]){g3.processCommand(c,a.keyBuffer[0]);}m.isPlaying=false;return;}var k=a.keyBuffer;var b=0;m.isPlaying=true;m.replaySearchQueries=a.searchQueries.slice(0);for(var i=0;i<k.length;i++){var d=k[i];var e,f;while(d){e=(/<\w+-.+?>|<\w+>|./).exec(d);f=e[0];d=d.substring(e.index+f.length);F.Vim.handleKey(c,f,'macro');if(v.insertMode){var h=a.insertModeChanges[b++].changes;y1.macroModeState.lastInsertModeChanges.changes=h;w3(c,h,1);i3(c);}}}m.isPlaying=false;}function m3(m,k){if(m.isPlaying){return;}var r=m.latestRegister;var a=y1.registerController.getRegister(r);if(a){a.pushText(k);}}function n3(m){if(m.isPlaying){return;}var r=m.latestRegister;var a=y1.registerController.getRegister(r);if(a&&a.pushInsertModeChanges){a.pushInsertModeChanges(m.lastInsertModeChanges);}}function o3(m,a){if(m.isPlaying){return;}var r=m.latestRegister;var b=y1.registerController.getRegister(r);if(b&&b.pushSearchQuery){b.pushSearchQuery(a);}}function p3(_,c){var m=y1.macroModeState;var a=m.lastInsertModeChanges;if(!m.isPlaying){while(c){a.expectCursorActivityForChange=true;if(c.origin=='+input'||c.origin=='paste'||c.origin===undefined){var b=c.text.join('\n');if(a.maybeReset){a.changes=[];a.maybeReset=false;}a.changes.push(b);}c=c.next;}}}function q3(c){var v=c.state.vim;if(v.insertMode){var m=y1.macroModeState;if(m.isPlaying){return;}var a=m.lastInsertModeChanges;if(a.expectCursorActivityForChange){a.expectCursorActivityForChange=false;}else{a.maybeReset=true;}}else if(!c.curOp.isVimOp){s3(c,v);}if(v.visualMode){r3(c);}}function r3(c){var v=c.state.vim;var f=Q1(c,Y1(v.sel.head));var a=S1(f,0,1);if(v.fakeCursor){v.fakeCursor.clear();}v.fakeCursor=c.markText(f,a,{className:'cm-animate-fat-cursor'});}function s3(c,v){var a=c.getCursor('anchor');var h=c.getCursor('head');if(v.visualMode&&!c.somethingSelected()){p2(c,false);}else if(!v.visualMode&&!v.insertMode&&c.somethingSelected()){v.visualMode=true;v.visualLine=false;F.signal(c,"vim-mode-change",{mode:"visual"});}if(v.visualMode){var b=!$1(h,a)?-1:0;var d=$1(h,a)?-1:0;h=S1(h,0,b);a=S1(a,0,d);v.sel={anchor:a,head:h};E2(c,v,'<',_1(h,a));E2(c,v,'>',a2(h,a));}else if(!v.insertMode){v.lastHPos=c.getCursor().ch;}}function t3(k){this.keyName=k;}function u3(e){var m=y1.macroModeState;var a=m.lastInsertModeChanges;var k=F.keyName(e);if(!k){return;}function o(){if(a.maybeReset){a.changes=[];a.maybeReset=false;}a.changes.push(new t3(k));return true;}if(k.indexOf('Delete')!=-1||k.indexOf('Backspace')!=-1){F.lookupKey(k,'vim-insert',o);}}function v3(c,v,r,a){var m=y1.macroModeState;m.isPlaying=true;var b=!!v.lastEditActionCommand;var d=v.inputState;function e(){if(b){I1.processAction(c,v,v.lastEditActionCommand);}else{I1.evalInput(c,v);}}function f(r){if(m.lastInsertModeChanges.changes.length>0){r=!v.lastEditActionCommand?1:r;var h=m.lastInsertModeChanges;w3(c,h.changes,r,h.overwrite);}}v.inputState=v.lastEditInputState;if(b&&v.lastEditActionCommand.interlaceInsertRepeat){for(var i=0;i<r;i++){e();f(1);}}else{if(!a){e();}f(r);}v.inputState=d;if(v.insertMode&&!a){i3(c);}m.isPlaying=false;}function w3(c,a,r,o){function k(p){if(typeof p=='string'){F.commands[p](c);}else{p(c);}return true;}var h=c.getCursor('head');var b=y1.macroModeState.lastInsertModeChanges.inVisualBlock;if(b){var v=c.state.vim;var d=v.lastSelection;var e=T1(d.anchor,d.head);h2(c,h,e.line+1);r=c.listSelections().length;c.setCursor(h);}for(var i=0;i<r;i++){if(b){c.setCursor(S1(h,i,0));}for(var j=0;j<a.length;j++){var f=a[j];if(f instanceof t3){F.lookupKey(f.keyName,'vim-insert',k);}else{var m=c.getCursor();var n=m;if(o&&!/\n/.test(f)){n=S1(m,0,f.length);}c.replaceRange(f,m,n);}}}if(b){c.setCursor(S1(h,0,1));}}z1();F.Vim=V();V=F.Vim;var x3={'return':'CR',backspace:'BS','delete':'Del',esc:'Esc',left:'Left',right:'Right',up:'Up',down:'Down',space:'Space',home:'Home',end:'End',pageup:'PageUp',pagedown:'PageDown',enter:'CR'};function y3(h,k,e){if(k.length>1&&k[0]=="n"){k=k.replace("numpad","");}k=x3[k]||k;var n='';if(e.ctrlKey){n+='C-';}if(e.altKey){n+='A-';}if(e.shiftKey){n+='S-';}n+=k;if(n.length>1){n='<'+n+'>';}return n;}var z3=V.handleKey.bind(V);V.handleKey=function(c,k,o){return c.operation(function(){return z3(c,k,o);},true);};function A3(s){var n=new s.constructor();Object.keys(s).forEach(function(k){var o=s[k];if(Array.isArray(o))o=o.slice();else if(o&&typeof o=="object"&&o.constructor!=Object)o=A3(o);n[k]=o;});if(s.sel){n.sel={head:s.sel.head&&Y1(s.sel.head),anchor:s.sel.anchor&&Y1(s.sel.anchor)};}return n;}function B3(c,k,o){var i=false;var v=V.maybeInitVimState_(c);var a=v.visualBlock||v.wasInVisualBlock;if(v.wasInVisualBlock&&!c.ace.inMultiSelectMode){v.wasInVisualBlock=false;}else if(c.ace.inMultiSelectMode&&v.visualBlock){v.wasInVisualBlock=true;}if(k=='<Esc>'&&!v.insertMode&&!v.visualMode&&c.ace.inMultiSelectMode){c.ace.exitMultiSelectMode();}else if(a||!c.ace.inMultiSelectMode||c.ace.inVirtualSelectionMode){i=V.handleKey(c,k,o);}else{var b=A3(v);c.operation(function(){c.ace.forEachSelection(function(){var s=c.ace.selection;c.state.vim.lastHPos=s.$desiredColumn==null?s.lead.column:s.$desiredColumn;var h=c.getCursor("head");var d=c.getCursor("anchor");var e=!$1(h,d)?-1:0;var f=$1(h,d)?-1:0;h=S1(h,0,e);d=S1(d,0,f);c.state.vim.sel.head=h;c.state.vim.sel.anchor=d;i=z3(c,k,o);s.$desiredColumn=c.state.vim.lastHPos==-1?null:c.state.vim.lastHPos;if(c.virtualSelectionMode()){c.state.vim=A3(b);}});if(c.curOp.cursorActivity&&!i)c.curOp.cursorActivity=false;},true);}return i;}l.CodeMirror=F;var C3=V.maybeInitVimState_;l.handler={$id:"ace/keyboard/vim",drawCursor:function(s,p,c,a,b){var v=this.state.vim||{};var w=c.characterWidth;var h=c.lineHeight;var d=p.top;var e=p.left;if(!v.insertMode){var i=!a.cursor?b.selection.isBackwards()||b.selection.isEmpty():R.comparePoints(a.cursor,a.start)<=0;if(!i&&e>w)e-=w;}if(!v.insertMode&&v.status){h=h/2;d+=h;}s.left=e+"px";s.top=d+"px";s.width=w+"px";s.height=h+"px";},handleKeyboard:function(d,h,k,a,e){var b=d.editor;var c=b.state.cm;var v=C3(c);if(a==-1)return;if(k=="c"&&h==1){if(!B.isMac&&b.getCopyText()){b.once("copy",function(){b.selection.clearSelection();});return{command:"null",passEvent:true};}}else if(!v.insertMode){if(B.isMac&&this.handleMacRepeat(d,h,k)){h=-1;k=d.inputChar;}}if(h==-1||h&1||h===0&&k.length>1){var i=v.insertMode;var n=y3(h,k,e||{});if(v.status==null)v.status="";var f=B3(c,n,'user');v=C3(c);if(f&&v.status!=null)v.status+=n;else if(v.status==null)v.status="";c._signal("changeStatus");if(!f&&(h!=-1||i))return;return{command:"null",passEvent:!f};}},attach:function(e){if(!e.state)e.state={};var c=new F(e);e.state.cm=c;e.$vimModeHandler=this;F.keyMap.vim.attach(c);C3(c).status=null;c.on('vim-command-done',function(){if(c.virtualSelectionMode())return;C3(c).status=null;c.ace._signal("changeStatus");c.ace.session.markUndoGroup();});c.on("changeStatus",function(){c.ace.renderer.updateCursor();c.ace._signal("changeStatus");});c.on("vim-mode-change",function(){if(c.virtualSelectionMode())return;c.ace.renderer.setStyle("normal-mode",!C3(c).insertMode);c._signal("changeStatus");});c.ace.renderer.setStyle("normal-mode",!C3(c).insertMode);e.renderer.$cursorLayer.drawCursor=this.drawCursor.bind(c);this.updateMacCompositionHandlers(e,true);},detach:function(e){var c=e.state.cm;F.keyMap.vim.detach(c);c.destroy();e.state.cm=null;e.$vimModeHandler=null;e.renderer.$cursorLayer.drawCursor=null;e.renderer.setStyle("normal-mode",false);this.updateMacCompositionHandlers(e,false);},getStatusText:function(e){var c=e.state.cm;var v=C3(c);if(v.insertMode)return"INSERT";var s="";if(v.visualMode){s+="VISUAL";if(v.visualLine)s+=" LINE";if(v.visualBlock)s+=" BLOCK";}if(v.status)s+=(s?" ":"")+v.status;return s;},handleMacRepeat:function(d,h,k){if(h==-1){d.inputChar=k;d.lastEvent="input";}else if(d.inputChar&&d.$lastHash==h&&d.$lastKey==k){if(d.lastEvent=="input"){d.lastEvent="input1";}else if(d.lastEvent=="input1"){return true;}}else{d.$lastHash=h;d.$lastKey=k;d.lastEvent="keypress";}},updateMacCompositionHandlers:function(e,a){var o=function(c){var d=e.state.cm;var v=C3(d);if(!v.insertMode){var f=this.textInput.getElement();f.blur();f.focus();f.value=c;}else{this.onCompositionUpdateOrig(c);}};var b=function(c){var d=e.state.cm;var v=C3(d);if(!v.insertMode){this.onCompositionStartOrig(c);}};if(a){if(!e.onCompositionUpdateOrig){e.onCompositionUpdateOrig=e.onCompositionUpdate;e.onCompositionUpdate=o;e.onCompositionStartOrig=e.onCompositionStart;e.onCompositionStart=b;}}else{if(e.onCompositionUpdateOrig){e.onCompositionUpdate=e.onCompositionUpdateOrig;e.onCompositionUpdateOrig=null;e.onCompositionStart=e.onCompositionStartOrig;e.onCompositionStartOrig=null;}}}};var D3={getText:function(s,r){return(Math.abs(s.selection.lead.row-r)||(r+1+(r<9?"\xb7":"")))+"";},getWidth:function(s,a,c){return s.getLength().toString().length*c.characterWidth;},update:function(e,a){a.renderer.$loop.schedule(a.renderer.CHANGE_GUTTER);},attach:function(e){e.renderer.$gutterLayer.$renderer=this;e.on("changeSelection",this.update);},detach:function(e){e.renderer.$gutterLayer.$renderer=null;e.off("changeSelection",this.update);}};V.defineOption({name:"wrap",set:function(v,c){if(c){c.ace.setOption("wrap",v)}},type:"boolean"},false);V.defineEx('write','w',function(){console.log(':write is not implemented')});J.push({keys:'zc',type:'action',action:'fold',actionArgs:{open:false}},{keys:'zC',type:'action',action:'fold',actionArgs:{open:false,all:true}},{keys:'zo',type:'action',action:'fold',actionArgs:{open:true}},{keys:'zO',type:'action',action:'fold',actionArgs:{open:true,all:true}},{keys:'za',type:'action',action:'fold',actionArgs:{toggle:true}},{keys:'zA',type:'action',action:'fold',actionArgs:{toggle:true,all:true}},{keys:'zf',type:'action',action:'fold',actionArgs:{open:true,all:true}},{keys:'zd',type:'action',action:'fold',actionArgs:{open:true,all:true}},{keys:'<C-A-k>',type:'action',action:'aceCommand',actionArgs:{name:"addCursorAbove"}},{keys:'<C-A-j>',type:'action',action:'aceCommand',actionArgs:{name:"addCursorBelow"}},{keys:'<C-A-S-k>',type:'action',action:'aceCommand',actionArgs:{name:"addCursorAboveSkipCurrent"}},{keys:'<C-A-S-j>',type:'action',action:'aceCommand',actionArgs:{name:"addCursorBelowSkipCurrent"}},{keys:'<C-A-h>',type:'action',action:'aceCommand',actionArgs:{name:"selectMoreBefore"}},{keys:'<C-A-l>',type:'action',action:'aceCommand',actionArgs:{name:"selectMoreAfter"}},{keys:'<C-A-S-h>',type:'action',action:'aceCommand',actionArgs:{name:"selectNextBefore"}},{keys:'<C-A-S-l>',type:'action',action:'aceCommand',actionArgs:{name:"selectNextAfter"}});O1.aceCommand=function(c,a,v){c.vimCmd=a;if(c.ace.inVirtualSelectionMode)c.ace.on("beforeEndOperation",E3);else E3(null,c.ace);};function E3(o,a){a.off("beforeEndOperation",E3);var c=a.state.cm.vimCmd;if(c){a.execCommand(c.exec?c:c.name,c.args);}a.curOp=a.prevOp;}O1.fold=function(c,a,v){c.ace.execCommand(['toggleFoldWidget','toggleFoldWidget','foldOther','unfoldall'][(a.all?2:0)+(a.open?1:0)]);};l.handler.defaultKeymap=J;l.handler.actions=O1;l.Vim=V;V.map("Y","yy","normal");});
