/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./PositionContainer','sap/ui/commons/library','sap/ui/core/Control',"./AbsoluteLayoutRenderer"],function(q,P,l,C,A){"use strict";var a=C.extend("sap.ui.commons.layout.AbsoluteLayout",{metadata:{library:"sap.ui.commons",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},verticalScrolling:{type:"sap.ui.core.Scrolling",group:"Behavior",defaultValue:sap.ui.core.Scrolling.Hidden},horizontalScrolling:{type:"sap.ui.core.Scrolling",group:"Behavior",defaultValue:sap.ui.core.Scrolling.Hidden}},defaultAggregation:"positions",aggregations:{positions:{type:"sap.ui.commons.layout.PositionContainer",multiple:true,singularName:"position"}}}});(function(){a.prototype.setWidth=function(w){return s(this,"width",w,"LYT_SIZE");};a.prototype.setHeight=function(h){return s(this,"height",h,"LYT_SIZE");};a.prototype.setVerticalScrolling=function(v){return s(this,"verticalScrolling",v,"LYT_SCROLL");};a.prototype.setHorizontalScrolling=function(h){return s(this,"horizontalScrolling",h,"LYT_SCROLL");};a.prototype.insertPosition=function(p,i){var h=!!this.getDomRef();this.insertAggregation("positions",p,i,h);if(h&&p&&p.getControl()){this.contentChanged(p,"CTRL_ADD");}return this;};a.prototype.addPosition=function(p){var h=!!this.getDomRef();this.addAggregation("positions",p,h);if(h&&p&&p.getControl()){this.contentChanged(p,"CTRL_ADD");}return this;};a.prototype.removePosition=function(p){var h=!!this.getDomRef();var r=this.removeAggregation("positions",p,h);if(r){c([r]);this.contentChanged(r,"CTRL_REMOVE");}return r;};a.prototype.removeAllPositions=function(){c(this.getPositions());var h=!!this.getDomRef();var r=this.removeAllAggregation("positions",h);if(h){this.contentChanged(r,"CTRL_REMOVE_ALL");}return r;};a.prototype.destroyPositions=function(){c(this.getPositions());var h=!!this.getDomRef();this.destroyAggregation("positions",h);if(h){this.contentChanged(null,"CTRL_REMOVE_ALL");}return this;};a.prototype.getContent=function(){var e=[];var p=this.getPositions();for(var i=0;i<p.length;i++){e.push(p[i].getControl());}return e;};a.prototype.addContent=function(o,p){var e=P.createPosition(o,p);this.addPosition(e);return this;};a.prototype.insertContent=function(o,i,p){var e=P.createPosition(o,p);this.insertPosition(e,i);return this;};a.prototype.removeContent=function(v){var i=v;if(typeof(v)=="string"){v=sap.ui.getCore().byId(v);}if(typeof(v)=="object"){i=this.indexOfContent(v);}if(i>=0&&i<this.getContent().length){this.removePosition(i);return v;}return null;};a.prototype.removeAllContent=function(){var e=this.getContent();this.removeAllPositions();return e;};a.prototype.indexOfContent=function(o){var e=this.getContent();for(var i=0;i<e.length;i++){if(o===e[i]){return i;}}return-1;};a.prototype.destroyContent=function(){this.destroyPositions();return this;};a.prototype.setPositionOfChild=function(o,p){var i=this.indexOfContent(o);if(i>=0){var e=this.getPositions()[i];e.updatePosition(p);return true;}return false;};a.prototype.getPositionOfChild=function(o){var i=this.indexOfContent(o);if(i>=0){var p=this.getPositions()[i];return p.getComputedPosition();}return{};};a.prototype.exit=function(){c(this.getPositions());};a.prototype.doBeforeRendering=function(){var p=this.getPositions();if(!p||p.length==0){return;}for(var i=0;i<p.length;i++){var o=p[i];o.reinitializeEventHandlers(true);b(o,true);}};a.prototype.onAfterRendering=function(){var p=this.getPositions();if(!p||p.length==0){return;}for(var i=0;i<p.length;i++){p[i].reinitializeEventHandlers();}};a.cleanUpControl=function(o){if(o&&o[S]){o.removeDelegate(o[S]);o[S]=undefined;}};a.prototype.contentChanged=function(p,e){switch(e){case"CTRL_POS":sap.ui.commons.layout.AbsoluteLayoutRenderer.updatePositionStyles(p);b(p);p.reinitializeEventHandlers();break;case"CTRL_CHANGE":b(p,true);sap.ui.commons.layout.AbsoluteLayoutRenderer.updatePositionedControl(p);p.reinitializeEventHandlers();break;case"CTRL_REMOVE":sap.ui.commons.layout.AbsoluteLayoutRenderer.removePosition(p);p.reinitializeEventHandlers(true);break;case"CTRL_REMOVE_ALL":sap.ui.commons.layout.AbsoluteLayoutRenderer.removeAllPositions(this);var f=p;if(f){for(var i=0;i<f.length;i++){f[i].reinitializeEventHandlers(true);}}break;case"CTRL_ADD":b(p,true);sap.ui.commons.layout.AbsoluteLayoutRenderer.insertPosition(this,p);p.reinitializeEventHandlers();break;case"LYT_SCROLL":sap.ui.commons.layout.AbsoluteLayoutRenderer.updateLayoutScolling(this);break;case"LYT_SIZE":sap.ui.commons.layout.AbsoluteLayoutRenderer.updateLayoutSize(this);break;}};var S="__absolutelayout__delegator";var c=function(p){for(var i=0;i<p.length;i++){var o=p[i];var e=o.getControl();if(e){a.cleanUpControl(e);}}};var b=function(p,r){var o=p.getControl();if(o){a.cleanUpControl(o);if(!r){d(o);}var D=(function(e){return{onAfterRendering:function(){d(e);}};}(o));o[S]=D;o.addDelegate(D,true);}};var d=function(o){var e=false;if(o.getParent()&&o.getParent().getComputedPosition){var p=o.getParent().getComputedPosition();if(p.top&&p.bottom||p.height){q(o.getDomRef()).css("height","100%");e=true;}if(p.left&&p.right||p.width){q(o.getDomRef()).css("width","100%");e=true;}if(e){sap.ui.commons.layout.AbsoluteLayoutRenderer.updatePositionStyles(o.getParent());}}return e;};var s=function(t,p,v,e){var h=!!t.getDomRef();t.setProperty(p,v,h);if(h){t.contentChanged(null,e);}return t;};}());return a;},true);
