/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/base/ManagedObjectMetadata','sap/ui/core/Manifest','sap/ui/thirdparty/URI','sap/base/Log','sap/base/util/isPlainObject','sap/base/util/LoaderExtensions'],function(q,M,b,U,L,c,d){"use strict";var C=window["sap-ui-config"]||{};var s=0;if(C['xx-nosync']==='warn'||/(?:\?|&)sap-ui-xx-nosync=(?:warn)/.exec(window.location.search)){s=1;}if(C['xx-nosync']===true||C['xx-nosync']==='true'||/(?:\?|&)sap-ui-xx-nosync=(?:x|X|true)/.exec(window.location.search)){s=2;}var e=function(a,o){M.apply(this,arguments);};e.prototype=Object.create(M.prototype);e.preprocessClassInfo=function(o){if(o&&typeof o.metadata==="string"){o.metadata={_src:o.metadata};}return o;};e.prototype.applySettings=function(o){var S=this._oStaticInfo=o.metadata;var n=this.getName(),p=n.replace(/\.\w+?$/,"");if(S._src){if(S._src=="component.json"){L.warning("Usage of declaration \"metadata: 'component.json'\" is deprecated (component "+n+"). Use \"metadata: 'json'\" instead.");}else if(S._src!="json"){throw new Error("Invalid metadata declaration for component "+n+": \""+S._src+"\"! Use \"metadata: 'json'\" to load metadata from component.json.");}var r=p.replace(/\./g,"/")+"/component.json";L.info("The metadata of the component "+n+" is loaded from file "+r+".");try{var R=d.loadResource(r,{dataType:"json"});q.extend(S,R);}catch(a){L.error("Failed to load component metadata from \""+r+"\" (component "+n+")! Reason: "+a);}}M.prototype.applySettings.call(this,o);this._sComponentName=p;this._bInitialized=false;this._iInstanceCount=0;var m=S["manifest"];if(m){S.__metadataVersion=2;if(typeof m==="string"&&m==="json"){return;}}else{S.__metadataVersion=1;m={};}this._applyManifest(m);};e.prototype._applyManifest=function(m){if(this._oManifest){L.warning("Can't apply manifest to ComponentMetadata as it has already been created.",this.getName(),"sap.ui.core.ComponentMetadata");return;}m["name"]=m["name"]||this.getName();m["sap.app"]=m["sap.app"]||{"id":this.getComponentName()};m["sap.ui5"]=m["sap.ui5"]||{};if(!this.isBaseClass()){m["sap.ui5"]["extends"]=m["sap.ui5"]["extends"]||{};}this._convertLegacyMetadata(this._oStaticInfo,m);this._oManifest=new b(m,{componentName:this.getComponentName(),baseUrl:sap.ui.require.toUrl(this.getComponentName().replace(/\./g,"/"))+"/",process:this._oStaticInfo.__metadataVersion===2});};e.prototype.init=function(){if(this._iInstanceCount===0){var p=this.getParent();if(p instanceof e){p.init();}this.getManifestObject().init();this._bInitialized=true;}this._iInstanceCount++;};e.prototype.exit=function(){var i=Math.max(this._iInstanceCount-1,0);if(i===0){this.getManifestObject().exit();var p=this.getParent();if(p instanceof e){p.exit();}this._bInitialized=false;}this._iInstanceCount=i;};e.prototype.onInitComponent=function(i){L.error("The function ComponentMetadata#onInitComponent will be removed soon!");};e.prototype.onExitComponent=function(i){L.error("The function ComponentMetadata#onExitComponent will be removed soon!");};e.prototype.isBaseClass=function(){return/^sap\.ui\.core\.(UI)?Component$/.test(this.getName());};e.prototype.getMetadataVersion=function(){return this._oStaticInfo.__metadataVersion;};e.prototype.getManifestObject=function(){if(!this._oManifest){var m=this._oStaticInfo["manifest"];if(typeof m==="string"&&m==="json"){var n=this.getName();var p=this.getComponentName();var r=p.replace(/\./g,"/")+"/manifest.json";var i=!!sap.ui.loader._.getModuleState(r);if(!i&&s===2){L.error("[nosync] Loading manifest of the component "+n+" ignored.",r,"sap.ui.core.ComponentMetadata");m={};}else{if(!i&&s===1){L.error("[nosync] The manifest of the component "+n+" is loaded with sync XHR.",r,"sap.ui.core.ComponentMetadata");}else{L.info("The manifest of the component "+n+" is loaded from file "+r+".");}try{var R=d.loadResource(r,{dataType:"json"});m=R;}catch(a){L.error("Failed to load component manifest from \""+r+"\" (component "+n+")! Reason: "+a);m={};}}this._applyManifest(m);}}return this._oManifest;};e.prototype.getManifest=function(){if(this.getMetadataVersion()===1){return this.getManifestObject().getRawJson();}return this.getManifestObject().getJson();};e.prototype._getManifest=function(){L.warning("ComponentMetadata#_getManifest: do not use deprecated functions anymore!");return this.getManifestObject().getJson();};e.prototype.getRawManifest=function(){return this.getManifestObject().getRawJson();};e.prototype._getRawManifest=function(){L.warning("ComponentMetadata#_getRawManifest: do not use deprecated functions anymore!");return this.getManifestObject().getRawJson();};e.prototype.getManifestEntry=function(k,m){var D=this.getManifestObject().getEntry(k);if(D!==undefined&&!c(D)){return D;}var p,P;if(m&&(p=this.getParent())instanceof e){P=p.getManifestEntry(k,m);}if(P||D){D=q.extend(true,{},P,D);}return D;};e.prototype.getCustomEntry=function(k,m){if(!k||k.indexOf(".")<=0){L.warning("Component Metadata entries with keys without namespace prefix can not be read via getCustomEntry. Key: "+k+", Component: "+this.getName());return null;}var p,D=this._oStaticInfo[k]||{};if(!c(D)){L.warning("Custom Component Metadata entry with key '"+k+"' must be an object. Component: "+this.getName());return null;}if(m&&(p=this.getParent())instanceof e){return q.extend(true,{},p.getCustomEntry(k,m),D);}return q.extend(true,{},D);};e.prototype.getComponentName=function(){return this._sComponentName;};e.prototype.getDependencies=function(){if(!this._oLegacyDependencies){var D=this.getManifestEntry("/sap.ui5/dependencies"),u=D&&D.minUI5Version||null,l=D&&D.libs||{},m=D&&D.components||{};var a={ui5version:u,libs:[],components:[]};for(var f in l){a.libs.push(f);}for(var g in m){a.components.push(g);}this._oLegacyDependencies=a;}return this._oLegacyDependencies;};e.prototype.getIncludes=function(){if(!this._aLegacyIncludes){var I=[],r=this.getManifestEntry("/sap.ui5/resources")||{},a=r&&r.css||[],j=r&&r.js||[];for(var i=0,l=a.length;i<l;i++){if(a[i]&&a[i].uri){I.push(a[i].uri);}}for(var i=0,l=j.length;i<l;i++){if(j[i]&&j[i].uri){I.push(j[i].uri);}}this._aLegacyIncludes=(I.length>0)?I:null;}return this._aLegacyIncludes;};e.prototype.getUI5Version=function(){return this.getManifestEntry("/sap.ui5/dependencies/minUI5Version");};e.prototype.getComponents=function(){return this.getDependencies().components;};e.prototype.getLibs=function(){return this.getDependencies().libs;};e.prototype.getVersion=function(){return this.getManifestEntry("/sap.app/applicationVersion/version");};e.prototype.getConfig=function(k,D){var m=this.getManifestEntry("/sap.ui5/config",!D);if(!m){return{};}if(!k){return m;}return m.hasOwnProperty(k)?m[k]:{};};e.prototype.getCustomizing=function(D){return this.getManifestEntry("/sap.ui5/extends/extensions",!D);};e.prototype.getModels=function(D){if(!this._oLegacyModels){this._oLegacyModels={};var m=this.getManifestEntry("/sap.ui5/models")||{};for(var a in m){var o=m[a];this._oLegacyModels[a]=o.settings||{};this._oLegacyModels[a].type=o.type;this._oLegacyModels[a].uri=o.uri;}}var p,f=q.extend(true,{},this._oLegacyModels);if(!D&&(p=this.getParent())instanceof e){f=q.extend(true,{},p.getModels(),f);}return f;};e.prototype.handleValidation=function(){return this.getManifestEntry("/sap.ui5/handleValidation");};e.prototype.getServices=function(){L.warning("Usage of sap.ui.core.ComponentMetadata.protoype.getServices is deprecated!");return this._oStaticInfo.services||{};};e.prototype._convertLegacyMetadata=function(S,f){var g=function(a,x){var o={};if(a){for(var i=0,l=a.length;i<l;i++){var v=a[i];if(typeof v==="string"){o[v]=typeof x==="function"&&x(v)||{};}}}return o;};var A=f["sap.app"];var u=f["sap.ui5"];for(var n in S){var v=S[n];if(v!==undefined){switch(n){case"name":f[n]=f[n]||v;A["id"]=A["id"]||v;break;case"description":case"keywords":A[n]=A[n]||v;break;case"version":var h=A.applicationVersion=A.applicationVersion||{};h.version=h.version||v;break;case"config":u[n]=u[n]||v;break;case"customizing":var E=u["extends"]=u["extends"]||{};E.extensions=E.extensions||v;break;case"dependencies":if(!u[n]){u[n]={};u[n].minUI5Version=v.ui5version;u[n].libs=g(v.libs);u[n].components=g(v.components);}break;case"includes":if(!u["resources"]){u["resources"]={};if(v&&v.length>0){for(var i=0,l=v.length;i<l;i++){var r=v[i];var m=r.match(/\.(css|js)$/i);if(m){u["resources"][m[1]]=u["resources"][m[1]]||[];u["resources"][m[1]].push({"uri":r});}}}}break;case"handleValidation":if(u[n]===undefined){u[n]=v;}break;case"models":if(!u["models"]){var j={};for(var k in v){var D=v[k];var p={};for(var t in D){var w=D[t];switch(t){case"type":case"uri":p[t]=w;break;default:p.settings=p.settings||{};p.settings[t]=w;}}j[k]=p;}u["models"]=j;}break;}}}};return e;},true);
