/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/core/Control','sap/ui/core/ResizeHandler','sap/ui/layout/library','./DynamicSideContentRenderer'],function(q,C,R,l,D){"use strict";var a=l.SideContentPosition;var b=l.SideContentFallDown;var c=l.SideContentVisibility;var d=C.extend("sap.ui.layout.DynamicSideContent",{metadata:{library:"sap.ui.layout",properties:{showSideContent:{type:"boolean",group:"Appearance",defaultValue:true},showMainContent:{type:"boolean",group:"Appearance",defaultValue:true},sideContentVisibility:{type:"sap.ui.layout.SideContentVisibility",group:"Appearance",defaultValue:c.ShowAboveS},sideContentFallDown:{type:"sap.ui.layout.SideContentFallDown",group:"Appearance",defaultValue:b.OnMinimumWidth},equalSplit:{type:"boolean",group:"Appearance",defaultValue:false},containerQuery:{type:"boolean",group:"Behavior",defaultValue:false},sideContentPosition:{type:"sap.ui.layout.SideContentPosition",group:"Appearance",defaultValue:a.End}},defaultAggregation:"mainContent",events:{breakpointChanged:{parameters:{currentBreakpoint:{type:"string"}}}},aggregations:{mainContent:{type:"sap.ui.core.Control",multiple:true},sideContent:{type:"sap.ui.core.Control",multiple:true}},designTime:"sap/ui/layout/designtime/DynamicSideContent.designtime"}});var S="S",M="M",L="L",X="XL",H="sapUiHidden",e="sapUiDSCSpan12",f="sapUiDSCMCFixed",g="sapUiDSCSCFixed",h=3,i=4,j=6,k=8,m=9,n=12,I="Invalid Breakpoint. Expected: S, M, L or XL",o="SCGridCell",p="MCGridCell",r=720,s=1024,t=1440;d.prototype.init=function(){this._bSuppressInitialFireBreakPointChange=true;};d.prototype.setSideContentVisibility=function(v,u){this.setProperty("sideContentVisibility",v,true);if(!u&&this.$().length){this._setResizeData(this.getCurrentBreakpoint());this._changeGridState();}return this;};d.prototype.setShowSideContent=function(v,u){this.setProperty("showSideContent",v,true);this._SCVisible=v;if(!u&&this.$().length){this._setResizeData(this.getCurrentBreakpoint(),this.getEqualSplit());if(this._currentBreakpoint===S){this._MCVisible=true;}this._changeGridState();}return this;};d.prototype.setShowMainContent=function(v,u){this.setProperty("showMainContent",v,true);this._MCVisible=v;if(!u&&this.$().length){this._setResizeData(this.getCurrentBreakpoint(),this.getEqualSplit());if(this._currentBreakpoint===S){this._SCVisible=true;}this._changeGridState();}return this;};d.prototype.getShowSideContent=function(){if(this._currentBreakpoint===S){return this._SCVisible&&this.getProperty("showSideContent");}else{return this.getProperty("showSideContent");}};d.prototype.getShowMainContent=function(){if(this._currentBreakpoint===S){return this._MCVisible&&this.getProperty("showMainContent");}else{return this.getProperty("showMainContent");}};d.prototype.setEqualSplit=function(u){this._MCVisible=true;this._SCVisible=true;this.setProperty("equalSplit",u,true);if(this._currentBreakpoint){this._setResizeData(this._currentBreakpoint,u);this._changeGridState();}return this;};d.prototype.addSideContent=function(u){this.addAggregation("sideContent",u,true);this._rerenderControl(this.getAggregation("sideContent"),this.$(o));return this;};d.prototype.addMainContent=function(u){this.addAggregation("mainContent",u,true);this._rerenderControl(this.getAggregation("mainContent"),this.$(p));return this;};d.prototype.toggle=function(){if(this._currentBreakpoint===S){if(!this.getProperty("showMainContent")){this.setShowMainContent(true,true);this._MCVisible=false;}if(!this.getProperty("showSideContent")){this.setShowSideContent(true,true);this._SCVisible=false;}if(this._MCVisible&&!this._SCVisible){this._SCVisible=true;this._MCVisible=false;}else if(!this._MCVisible&&this._SCVisible){this._MCVisible=true;this._SCVisible=false;}this._changeGridState();}return this;};d.prototype.getCurrentBreakpoint=function(){return this._currentBreakpoint;};d.prototype.onBeforeRendering=function(){this._detachContainerResizeListener();this._SCVisible=this.getProperty("showSideContent");this._MCVisible=this.getProperty("showMainContent");if(!this.getContainerQuery()){this._iWindowWidth=q(window).width();this._setBreakpointFromWidth(this._iWindowWidth);this._setResizeData(this._currentBreakpoint,this.getEqualSplit());}};d.prototype.onAfterRendering=function(){if(this.getContainerQuery()){this._attachContainerResizeListener();this._adjustToScreenSize();}else{var u=this;q(window).resize(function(){u._adjustToScreenSize();});}this._changeGridState();this._initScrolling();};d.prototype.exit=function(){this._detachContainerResizeListener();if(this._oSCScroller){this._oSCScroller.destroy();this._oSCScroller=null;}if(this._oMCScroller){this._oMCScroller.destroy();this._oMCScroller=null;}};d.prototype._rerenderControl=function(u,$){if(this.getDomRef()){var v=sap.ui.getCore().createRenderManager();this.getRenderer().renderControls(v,u);v.flush($[0]);v.destroy();}return this;};d.prototype._initScrolling=function(){var u=this.getId(),v=u+"-"+o,w=u+"-"+p;if(!this._oSCScroller&&!this._oMCScroller){var x=sap.ui.requireSync("sap/ui/core/delegate/ScrollEnablement");this._oSCScroller=new x(this,null,{scrollContainerId:v,horizontal:false,vertical:true});this._oMCScroller=new x(this,null,{scrollContainerId:w,horizontal:false,vertical:true});}};d.prototype._attachContainerResizeListener=function(){if(!this._sContainerResizeListener){this._sContainerResizeListener=R.register(this,q.proxy(this._adjustToScreenSize,this));}};d.prototype._detachContainerResizeListener=function(){if(this._sContainerResizeListener){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;}};d.prototype._getBreakPointFromWidth=function(w){if(w<=r&&this._currentBreakpoint!==S){return S;}else if((w>r)&&(w<=s)&&this._currentBreakpoint!==M){return M;}else if((w>s)&&(w<=t)&&this._currentBreakpoint!==L){return L;}else if(w>t&&this._currentBreakpoint!==X){return X;}return this._currentBreakpoint;};d.prototype._setBreakpointFromWidth=function(w){this._currentBreakpoint=this._getBreakPointFromWidth(w);if(this._bSuppressInitialFireBreakPointChange){this._bSuppressInitialFireBreakPointChange=false;}else{this.fireBreakpointChanged({currentBreakpoint:this._currentBreakpoint});}};d.prototype._adjustToScreenSize=function(){if(this.getContainerQuery()){this._iWindowWidth=this.$().parent().width();}else{this._iWindowWidth=q(window).width();}if(this._iWindowWidth!==this._iOldWindowWidth){this._iOldWindowWidth=this._iWindowWidth;this._oldBreakPoint=this._currentBreakpoint;this._setBreakpointFromWidth(this._iWindowWidth);if((this._oldBreakPoint!==this._currentBreakpoint)||(this._currentBreakpoint===M&&this.getSideContentFallDown()===b.OnMinimumWidth)){this._setResizeData(this._currentBreakpoint,this.getEqualSplit());this._changeGridState();}}};d.prototype._setResizeData=function(u,v){var w=this.getSideContentVisibility(),x=this.getSideContentFallDown();if(!v){switch(u){case S:this._setSpanSize(n,n);if(this.getProperty("showSideContent")&&this.getProperty("showMainContent")){this._SCVisible=w===c.AlwaysShow;}this._bFixedSideContent=false;break;case M:var y=Math.ceil((33.333/100)*this._iWindowWidth);if(x===b.BelowL||x===b.BelowXL||(y<=320&&x===b.OnMinimumWidth)){this._setSpanSize(n,n);this._bFixedSideContent=false;}else{this._setSpanSize(i,k);this._bFixedSideContent=true;}this._SCVisible=w===c.ShowAboveS||w===c.AlwaysShow;this._MCVisible=true;break;case L:if(x===b.BelowXL){this._setSpanSize(n,n);}else{this._setSpanSize(i,k);}this._SCVisible=w===c.ShowAboveS||w===c.ShowAboveM||w===c.AlwaysShow;this._MCVisible=true;this._bFixedSideContent=false;break;case X:this._setSpanSize(h,m);this._SCVisible=w!==c.NeverShow;this._MCVisible=true;this._bFixedSideContent=false;break;default:throw new Error(I);}}else{switch(u){case S:this._setSpanSize(n,n);this._SCVisible=false;break;default:this._setSpanSize(j,j);this._SCVisible=true;this._MCVisible=true;}this._bFixedSideContent=false;}return this;};d.prototype._shouldSetHeight=function(){var u,B,O,v,w,F,x;u=(this._iScSpan+this._iMcSpan)===n;B=this._MCVisible&&this._SCVisible;O=!this._MCVisible&&this._SCVisible;v=this._MCVisible&&!this._SCVisible;w=O||v;F=this._fixedSideContent;x=this.getSideContentVisibility()===c.NeverShow;return((u&&B)||w||F||x);};d.prototype._changeGridState=function(){var $=this.$(o),u=this.$(p),v=this.getProperty("showMainContent"),w=this.getProperty("showSideContent");if(this._bFixedSideContent){$.removeClass().addClass(g);u.removeClass().addClass(f);}else{$.removeClass(g);u.removeClass(f);}if(this._SCVisible&&this._MCVisible&&w&&v){if(!this._bFixedSideContent){u.removeClass().addClass("sapUiDSCSpan"+this._iMcSpan);$.removeClass().addClass("sapUiDSCSpan"+this._iScSpan);}if(this._shouldSetHeight()){$.css("height","100%").css("float","left");u.css("height","100%").css("float","left");}else{$.css("height","auto").css("float","none");u.css("height","auto").css("float","none");}}else if(!this._SCVisible&&!this._MCVisible){u.addClass(H);$.addClass(H);}else if(this._MCVisible&&v){u.removeClass().addClass(e);$.addClass(H);}else if(this._SCVisible&&w){$.removeClass().addClass(e);u.addClass(H);}else if(!v&&!w){u.addClass(H);$.addClass(H);}};d.prototype._setSpanSize=function(u,v){this._iScSpan=u;this._iMcSpan=v;};return d;});
