/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/SyncPromise","sap/ui/thirdparty/URI","./_GroupLock","./_Helper","./_Requestor","sap/base/Log","sap/ui/thirdparty/jquery"],function(S,U,_,a,b,L,q){"use strict";var m="@com.sap.vocabularies.Common.v1.Messages",r=/^([^(]*)(\(.*\))$/;function c(h,p,i,D){if(i.$count!==undefined){s(h,p,i,i.$count+D);}}function g(h){return h.$count!==undefined?h.$count:Infinity;}function d(R,p){return p===""||R===p||R.indexOf(p+"/")===0;}function s(h,p,i,v){if(typeof v==="string"){v=parseInt(v,10);}a.updateCache(h,p,i,{$count:v});}function C(R,h,Q,i){this.bActive=true;this.mChangeListeners={};this.sMetaPath=a.getMetaPath("/"+h);this.mPatchRequests={};this.mPostRequests={};this.oRequestor=R;this.bSortExpandSelect=i;this.sResourcePath=h;this.bSentReadRequest=false;this.oTypePromise=undefined;this.setQueryOptions(Q);}C.prototype._delete=function(G,E,p,h){var i=p.split("/"),D=i.pop(),j=i.join("/"),t=this;return this.fetchValue(_.$cached,j).then(function(v){var o=D?v[D]:v,H,k=a.getPrivateAnnotation(o,"predicate"),T=a.getPrivateAnnotation(o,"transient");if(T===true){throw new Error("No 'delete' allowed while waiting for server response");}if(T){G.unlock();t.oRequestor.removePost(T,o);return Promise.resolve();}if(o["$ui5.deleting"]){throw new Error("Must not delete twice: "+E);}o["$ui5.deleting"]=true;H={"If-Match":o["@odata.etag"]};E+=t.oRequestor.buildQueryString(t.sMetaPath,t.mQueryOptions,true);return t.oRequestor.request("DELETE",E,G,H).catch(function(l){if(l.status!==404){delete o["$ui5.deleting"];throw l;}}).then(function(){var M,l;if(Array.isArray(v)){if(v[D]!==o){D=v.indexOf(o);}if(D==="-1"){delete v[-1];}else{l=a.getPrivateAnnotation(o,"predicate");if(l){delete v.$byPredicate[l];}v.splice(D,1);}c(t.mChangeListeners,j,v,-1);t.iLimit-=1;h(Number(D),v);M=a.buildPath(j,k);}else{if(D){a.updateCache(t.mChangeListeners,j,v,C.makeUpdateData([D],null));}else{o["$ui5.deleted"]=true;}h();M=a.buildPath(j,D);}t.oRequestor.reportBoundMessages(t.sResourcePath,[],[M]);});});};C.prototype.addByPath=function(M,p,i){if(i){if(!M[p]){M[p]=[i];}else if(M[p].indexOf(i)<0){M[p].push(i);}}};C.prototype.calculateKeyPredicate=function(i,t,M){var T=t[M];if(T&&T.$Key){a.setPrivateAnnotation(i,"predicate",a.getKeyPredicate(i,M,t));}};C.prototype.checkActive=function(){var E;if(!this.bActive){E=new Error("Response discarded: cache is inactive");E.canceled=true;throw E;}};C.prototype.create=function(G,p,h,E,i,j){var k,t=this;function l(){t.removeByPath(t.mPostRequests,h,E);delete k[-1];i();}function n(){a.setPrivateAnnotation(E,"transient",true);}function o(u,v){var w=v.getGroupId();a.setPrivateAnnotation(E,"transient",w);t.addByPath(t.mPostRequests,h,E);return t.oRequestor.request("POST",u,v,null,E,n,l).then(function(R){a.deletePrivateAnnotation(E,"transient");c(t.mChangeListeners,h,k,1);t.removeByPath(t.mPostRequests,h,E);a.updateCacheAfterPost(t.mChangeListeners,a.buildPath(h,"-1"),E,R,a.getSelectForPath(t.mQueryOptions,h));t.fetchTypes().then(function(T){a.setPrivateAnnotation(E,"predicate",a.getKeyPredicate(E,a.getMetaPath(a.buildPath(t.sMetaPath,h)),T));});},function(x){if(x.canceled){throw x;}if(j){j(x);}return o(u,new _(t.oRequestor.getGroupSubmitMode(w)==="API"?w:"$parked."+w));});}E=q.extend(true,{},E);E=b.cleanPayload(E);k=this.fetchValue(_.$cached,h).getResult();if(!Array.isArray(k)){throw new Error("Create is only supported for collections; '"+h+"' does not reference a collection");}k[-1]=E;return S.resolve(p).then(function(u){u+=t.oRequestor.buildQueryString(t.sMetaPath,t.mQueryOptions,true);return o(u,G);});};C.prototype.deregisterChange=function(p,l){this.removeByPath(this.mChangeListeners,p,l);};C.prototype.drillDown=function(D,p){var t=this;function h(i){L.error("Failed to drill-down into "+p+", invalid segment: "+i,t.toString(),"sap.ui.model.odata.v4.lib._Cache");return undefined;}function j(v,i,k){var l="",n,R,o;if(p[0]!=='('){l+="/";}l+=p.split("/").slice(0,k).join("/");n=t.oRequestor.fetchTypeForPath(t.sMetaPath+a.getMetaPath(l),true).getResult();if(n==="Edm.Stream"){R=v[i+"@odata.mediaReadLink"];o=t.oRequestor.getServiceUrl();return R||o+t.sResourcePath+l;}return h(i);}if(!p){return D;}return p.split("/").reduce(function(v,k,i){var M,o;if(k==="$count"){return Array.isArray(v)?v.$count:h(k);}if(v===undefined||v===null){return undefined;}if(typeof v!=="object"||k==="@$ui5._"){return h(k);}o=v;M=r.exec(k);if(M){if(M[1]){v=v[M[1]];}if(v){v=v.$byPredicate[M[2]];}}else{v=v[k];}return v===undefined&&k[0]!=="#"?j(o,k,i+1):v;},D);};C.prototype.fetchTypes=function(){var p,t,h=this;function i(B,Q){if(Q&&Q.$expand){Object.keys(Q.$expand).forEach(function(n){var M=B;n.split("/").forEach(function(k){M+="/"+k;j(M);});i(M,Q.$expand[n]);});}}function j(M){p.push(h.oRequestor.fetchTypeForPath(M).then(function(T){var o=h.oRequestor.fetchMetadata(M+"/"+m).getResult();if(o){T=Object.create(T);T[m]=o;}t[M]=T;if(T&&T.$Key){T.$Key.forEach(function(k){var I,K;if(typeof k!=="string"){K=k[Object.keys(k)[0]];I=K.lastIndexOf("/");if(I>=0){j(M+"/"+K.slice(0,I));}}});}}));}if(!this.oTypePromise){p=[];t={};j(this.sMetaPath);if(this.bFetchOperationReturnType){j(this.sMetaPath+"/$Type");}i(this.sMetaPath,this.mQueryOptions);this.oTypePromise=S.all(p).then(function(){return t;});}return this.oTypePromise;};C.prototype.hasPendingChangesForPath=function(p){return Object.keys(this.mPatchRequests).some(function(R){return d(R,p);})||Object.keys(this.mPostRequests).some(function(R){return d(R,p);});};C.prototype.registerChange=function(p,l){this.addByPath(this.mChangeListeners,p,l);};C.prototype.removeByPath=function(M,p,i){var I=M[p],h;if(I){h=I.indexOf(i);if(h>=0){if(I.length===1){delete M[p];}else{I.splice(h,1);}}}};C.prototype.resetChangesForPath=function(p){var t=this;Object.keys(this.mPatchRequests).forEach(function(R){var i,h;if(d(R,p)){h=t.mPatchRequests[R];for(i=h.length-1;i>=0;i--){t.oRequestor.removePatch(h[i]);}delete t.mPatchRequests[R];}});Object.keys(this.mPostRequests).forEach(function(R){var E,i,T;if(d(R,p)){E=t.mPostRequests[R];for(i=E.length-1;i>=0;i--){T=a.getPrivateAnnotation(E[i],"transient");t.oRequestor.removePost(T,E[i]);}delete t.mPostRequests[R];}});};C.prototype.setActive=function(A){this.bActive=A;if(!A){this.mChangeListeners={};}};C.prototype.setQueryOptions=function(Q){if(this.bSentReadRequest){throw new Error("Cannot set query options: Cache has already sent a read request");}this.mQueryOptions=Q;this.sQueryString=this.oRequestor.buildQueryString(this.sMetaPath,Q,false,this.bSortExpandSelect);};C.prototype.toString=function(){return this.oRequestor.getServiceUrl()+this.sResourcePath+this.sQueryString;};C.prototype.update=function(G,p,v,E,h,i,u){var j=p.split("/"),k,t=this;return this.fetchValue(G.getUnlockedCopy(),i).then(function(o){var F=a.buildPath(i,p),l=G.getGroupId(),O,n,w,T,x,y=C.makeUpdateData(j,v);function z(){t.removeByPath(t.mPatchRequests,F,n);a.updateCache(t.mChangeListeners,i,o,C.makeUpdateData(j,O));}function A(B){n=t.oRequestor.request("PATCH",h,B,{"If-Match":o["@odata.etag"]},y,undefined,z);t.addByPath(t.mPatchRequests,F,n);return n.then(function(D){t.removeByPath(t.mPatchRequests,F,n);a.updateCache(t.mChangeListeners,i,o,D);return D;},function(D){t.removeByPath(t.mPatchRequests,F,n);if(!D.canceled){E(D);if(t.oRequestor.getGroupSubmitMode(l)==="API"){return A(B.getUnlockedCopy());}}throw D;});}if(!o){throw new Error("Cannot update '"+p+"': '"+i+"' does not exist");}T=a.getPrivateAnnotation(o,"transient");if(T){if(T===true){throw new Error("No 'update' allowed while waiting for server response");}if(T.indexOf("$parked.")===0){w=T;T=T.slice(8);}if(T!==l){throw new Error("The entity will be created via group '"+T+"'. Cannot patch via group '"+l+"'");}}O=a.drillDown(o,j);a.updateCache(t.mChangeListeners,i,o,y);if(u){k=u.split("/");x=a.drillDown(o,k);if(x===undefined){L.debug("Missing value for unit of measure "+a.buildPath(i,u)+" when updating "+F,t.toString(),"sap.ui.model.odata.v4.lib._Cache");}else{q.extend(true,y,C.makeUpdateData(k,x));}}if(T){if(w){a.setPrivateAnnotation(o,"transient",T);t.oRequestor.relocate(w,o,T);}G.unlock();return Promise.resolve({});}h+=t.oRequestor.buildQueryString(t.sMetaPath,t.mQueryOptions,true);return A(G);});};C.prototype.visitResponse=function(R,t,w,h){var H=false,k,p={},j=this.oRequestor.getServiceUrl()+this.sResourcePath,l=this;function n(M,i,x){H=true;if(M&&M.length){p[i]=M;M.forEach(function(y){if(y.longtextUrl){y.longtextUrl=a.makeAbsolute(y.longtextUrl,x);}});}}function o(B,i){return i?a.makeAbsolute(i,B):B;}function v(I,M,x,y){var B={},i,z,A;for(i=0;i<I.length;i++){z=I[i];if(z&&typeof z==="object"){u(z,M,x,y,true);A=a.getPrivateAnnotation(z,"predicate");if(!x){k.push(A);}if(A){B[A]=z;I.$byPredicate=B;}}}}function u(i,M,I,x,y){var T=t[M],z=T&&T[m]&&T[m].$Path,A;x=o(x,i["@odata.context"]);l.calculateKeyPredicate(i,t,M);if(y){I+=a.getPrivateAnnotation(i,"predicate");}if(z){A=a.drillDown(i,z.split("/"));if(A!==undefined){n(A,I,x);}}Object.keys(i).forEach(function(B){var D,E=M+"/"+B,F=i[B],G=I+"/"+B;if(B.endsWith("@odata.mediaReadLink")){i[B]=a.makeAbsolute(F,x);}if(B.includes("@")){return;}if(Array.isArray(F)){F.$count=undefined;D=i[B+"@odata.count"];if(D){s({},"",F,D);}else if(!i[B+"@odata.nextLink"]){s({},"",F,F.length);}v(F,E,G,o(x,i[B+"@odata.context"]));}else if(F&&typeof F==="object"){u(F,E,G,x);}});}if(w){k=[];v(R.value,h||this.sMetaPath,"",o(j,R["@odata.context"]));}else if(R&&typeof R==="object"){u(R,h||this.sMetaPath,"",j);}if(H){this.oRequestor.reportBoundMessages(this.sResourcePath,p,k);}};function e(R,h,Q,i){C.apply(this,arguments);this.sContext=undefined;this.aElements=[];this.aElements.$byPredicate={};this.aElements.$count=undefined;this.aElements.$tail=undefined;this.iLimit=Infinity;this.oSyncPromiseAll=undefined;}e.prototype=Object.create(C.prototype);e.prototype.fetchValue=function(G,p,D,l){var E,t=this;G.unlock();if(!this.oSyncPromiseAll){E=this.aElements.$tail?this.aElements.concat(this.aElements.$tail):this.aElements;this.oSyncPromiseAll=S.all(E);}return this.oSyncPromiseAll.then(function(){t.checkActive();t.registerChange(p,l);return t.drillDown(t.aElements,p);});};e.prototype.fill=function(p,h,E){var i,n=Math.max(this.aElements.length,1024);if(E>n){if(this.aElements.$tail&&p){throw new Error("Cannot fill from "+h+" to "+E+", $tail already in use, # of elements is "+this.aElements.length);}this.aElements.$tail=p;E=this.aElements.length;}for(i=h;i<E;i++){this.aElements[i]=p;}this.oSyncPromiseAll=undefined;};e.prototype.getReadRange=function(h,l,p){var E=this.aElements;function j(h,k){var i;for(i=h;i<k;i+=1){if(E[i]===undefined){return true;}}return false;}if(j(h+l,h+l+p/2)){l+=p;}if(j(Math.max(h-p/2,0),h)){l+=p;h-=p;if(h<0){l+=h;if(isNaN(l)){l=Infinity;}h=0;}}return{length:l,start:h};};e.prototype.getResourcePath=function(i,E){var D=this.sQueryString?"&":"?",h=E-i,R=this.sResourcePath+this.sQueryString;if(i>0||h<Infinity){R+=D+"$skip="+i;}if(h<Infinity){R+="&$top="+h;}return R;};e.prototype.handleResponse=function(h,E,R,t){var j,k,o,i,p,l=R.value.length;this.sContext=R["@odata.context"];k=R["@odata.count"];if(k){this.iLimit=parseInt(k,10);s(this.mChangeListeners,"",this.aElements,this.iLimit);}this.visitResponse(R,t,true);for(i=0;i<l;i++){o=R.value[i];this.aElements[h+i]=o;p=a.getPrivateAnnotation(o,"predicate");if(p){this.aElements.$byPredicate[p]=o;}}if(l<E-h){j=Math.min(g(this.aElements),h+l);this.aElements.length=j;if(!k&&j>0&&!this.aElements[j-1]){j=undefined;}s(this.mChangeListeners,"",this.aElements,j);this.iLimit=j;}};e.prototype.read=function(I,l,p,G,D){var i,n,E,h,j=-1,k=this.aElements[-1]?-1:0,R,o=Math.max(I,0),t=this;if(I<k){throw new Error("Illegal index "+I+", must be >= "+k);}if(l<0){throw new Error("Illegal length "+l+", must be >= 0");}if(this.aElements.$tail){return this.aElements.$tail.then(function(){return t.read(I,l,p,G,D);});}R=this.getReadRange(I,l,p);h=Math.min(R.start+R.length,this.iLimit);n=Math.min(h,Math.max(R.start,this.aElements.length)+1);for(i=R.start;i<n;i++){if(this.aElements[i]!==undefined){if(j>=0){this.requestElements(j,i,G.getUnlockedCopy(),D);D=undefined;j=-1;}}else if(j<0){j=i;}}if(j>=0){this.requestElements(j,h,G.getUnlockedCopy(),D);}G.unlock();E=this.aElements.slice(o,h);if(this.aElements.$tail){E.push(this.aElements.$tail);}return S.all(E).then(function(){var u;t.checkActive();u={"@odata.context":t.sContext,value:t.aElements.slice(o,h)};u.value.$count=t.aElements.$count;if(I===-1){u.value.unshift(t.aElements[-1]);}return u;});};e.prototype.requestElements=function(i,E,G,D){var p,t=this;p=S.all([this.oRequestor.request("GET",this.getResourcePath(i,E),G,undefined,undefined,D),this.fetchTypes()]).then(function(R){if(t.aElements.$tail===p){t.aElements.$tail=undefined;}t.handleResponse(i,E,R[0],R[1]);}).catch(function(o){t.fill(undefined,i,E);throw o;});this.bSentReadRequest=true;this.fill(p,i,E);};e.prototype.refreshSingle=function(G,i,D){var p=a.getPrivateAnnotation(this.aElements[i],"predicate"),o,R=this.sResourcePath+p,Q=q.extend({},this.mQueryOptions),t=this;delete Q["$count"];delete Q["$filter"];delete Q["$orderby"];R+=this.oRequestor.buildQueryString(this.sMetaPath,Q,false,this.bSortExpandSelect);o=S.all([this.oRequestor.request("GET",R,G,undefined,undefined,D),this.fetchTypes()]).then(function(h){var E=h[0];t.aElements[i]=t.aElements.$byPredicate[p]=E;t.visitResponse(E,h[1]);});this.bSentReadRequest=true;return o;};e.prototype.refreshSingleWithRemove=function(G,i,D,o){var t=this;return this.fetchTypes().then(function(T){var k,K=[],E=t.aElements[i],h=a.getKeyProperties(E,"/"+t.sResourcePath,T),p=a.getPrivateAnnotation(E,"predicate"),Q=q.extend({},t.mQueryOptions),F=Q["$filter"],R=t.sResourcePath;for(k in h){K.push(k+" eq "+h[k]);}Q["$filter"]=(F?"("+F+") and ":"")+K.join(" and ");R+=t.oRequestor.buildQueryString(t.sMetaPath,Q,false,t.bSortExpandSelect);t.bSentReadRequest=true;return t.oRequestor.request("GET",R,G,undefined,undefined,D).then(function(j){if(t.aElements[i]!==E){i=t.aElements.indexOf(E);}if(j.value.length>1){throw new Error("Unexpected server response, more than one entity returned.");}else if(j.value.length===0){if(i===-1){delete t.aElements[-1];}else{t.aElements.splice(i,1);}delete t.aElements.$byPredicate[p];c(t.mChangeListeners,"",t.aElements,-1);t.iLimit-=1;o(i);}else{j=j.value[0];t.aElements[i]=t.aElements.$byPredicate[p]=j;t.visitResponse(j,T);}});});};function P(R,h,Q){C.call(this,R,h,Q);this.oPromise=null;}P.prototype=Object.create(C.prototype);P.prototype._delete=function(){throw new Error("Unsupported");};P.prototype.create=function(){throw new Error("Unsupported");};P.prototype.fetchValue=function(G,p,D,l){var t=this;t.registerChange("",l);if(!this.oPromise){this.oPromise=S.resolve(this.oRequestor.request("GET",this.sResourcePath+this.sQueryString,G,undefined,undefined,D,undefined,this.sMetaPath));this.bSentReadRequest=true;}else{G.unlock();}return this.oPromise.then(function(R){t.checkActive();return R.value;});};P.prototype.update=function(){throw new Error("Unsupported");};function f(R,h,Q,i,p,M,F){C.apply(this,arguments);this.bFetchOperationReturnType=F;this.sMetaPath=M||this.sMetaPath;this.bPost=p;this.bPosting=false;this.oPromise=null;}f.prototype=Object.create(C.prototype);f.prototype.fetchValue=function(G,p,D,l){var R=this.sResourcePath+this.sQueryString,t=this;this.registerChange(p,l);if(!this.oPromise){if(this.bPost){throw new Error("Cannot fetch a value before the POST request");}this.oPromise=S.all([this.oRequestor.request("GET",R,G,undefined,undefined,D,undefined,this.sMetaPath),this.fetchTypes()]).then(function(h){t.visitResponse(h[0],h[1],false,t.bFetchOperationReturnType?t.sMetaPath+"/$Type":undefined);return h[0];});this.bSentReadRequest=true;}else{G.unlock();}return this.oPromise.then(function(o){t.checkActive();if(o["$ui5.deleted"]){throw new Error("Cannot read a deleted entity");}return t.drillDown(o,p);});};f.prototype.post=function(G,D,E){var h="POST",p,t=this;if(!this.bPost){throw new Error("POST request not allowed");}if(this.bPosting){throw new Error("Parallel POST requests not allowed");}if(D){h=D["X-HTTP-Method"]||h;delete D["X-HTTP-Method"];if(this.oRequestor.isActionBodyOptional()&&!Object.keys(D).length){D=undefined;}}p=[this.oRequestor.request(h,this.sResourcePath+this.sQueryString,G,{"If-Match":E},D)];if(this.bFetchOperationReturnType){p.push(this.fetchTypes());}this.oPromise=S.all(p).then(function(R){t.bPosting=false;if(t.bFetchOperationReturnType){t.visitResponse(R[0],R[1],false,t.sMetaPath+"/$Type");}return R[0];},function(o){t.bPosting=false;throw o;});this.bPosting=true;return this.oPromise;};C.create=function(R,h,Q,i){return new e(R,h,Q,i);};C.createProperty=function(R,h,Q){return new P(R,h,Q);};C.createSingle=function(R,h,Q,i,p,M,F){return new f(R,h,Q,i,p,M,F);};C.makeUpdateData=function(p,v){return p.reduceRight(function(V,h){var R={};R[h]=V;return R;},v);};return C;},false);
