/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/ManagedObject','sap/ui/fl/ChangePersistenceFactory','sap/ui/fl/Utils','sap/ui/rta/command/Settings','sap/ui/rta/command/CompositeCommand','sap/ui/rta/ControlTreeModifier'],function(M,C,F,S,a,b){"use strict";var c=M.extend("sap.ui.rta.command.Stack",{metadata:{library:"sap.ui.rta",properties:{},aggregations:{commands:{type:"sap.ui.rta.command.BaseCommand",multiple:true}},events:{modified:{},commandExecuted:{parameters:{command:{type:"object"},undo:{type:"boolean"}}}}}});c.initializeWithChanges=function(o,f){var s=new c();s._aPersistedChanges=f;var m={};if(f&&f.length>0){var d=C.getChangePersistenceForControl(o);var e=F.getComponentForControl(o);var A=sap.ui.fl.Utils.getAppDescriptor(e)["sap.app"].id;var p={oComponent:e,appName:A};return d.getChangesForComponent(p).then(function(g){var h={};g.forEach(function(i){h[i.getDefinition().fileName]=i;});f.forEach(function(i){var j=h[i];var k=j.getSelector();var l=new S({selector:k,changeType:j.getDefinition().changeType,element:b.bySelector(k,e)});l._oPreparedChange=j;if(j.getUndoOperations()){l._aRecordedUndo=j.getUndoOperations();j.resetUndoOperations();}var n=j.getDefinition().support.compositeCommand;if(n){if(!m[n]){m[n]=new a();s.pushExecutedCommand(m[n]);}m[n].addCommand(l);}else{s.pushExecutedCommand(l);}});return s;});}else{return Promise.resolve(s);}};c.prototype.addCommandExecutionHandler=function(h){this._aCommandExecutionHandler.push(h);};c.prototype.removeCommandExecutionHandler=function(h){var i=this._aCommandExecutionHandler.indexOf(h);if(i>-1){this._aCommandExecutionHandler.splice(i,1);}};c.prototype.init=function(){this._aCommandExecutionHandler=[];this._toBeExecuted=-1;this._oLastCommand=Promise.resolve();};c.prototype._waitForCommandExecutionHandler=function(p){return Promise.all(this._aCommandExecutionHandler.map(function(h){return h(p);}));};c.prototype._getCommandToBeExecuted=function(){return this.getCommands()[this._toBeExecuted];};c.prototype.pushExecutedCommand=function(o){this.push(o,true);};c.prototype.push=function(o,e){if(this._bUndoneCommands){this._bUndoneCommands=false;while(this._toBeExecuted>-1){this.pop();}}this.insertCommand(o,0);if(!e){this._toBeExecuted++;}this.fireModified();};c.prototype.top=function(){return this.getCommands()[0];};c.prototype.pop=function(){if(this._toBeExecuted>-1){this._toBeExecuted--;}return this.removeCommand(0);};c.prototype.removeCommand=function(o,s){var r=this.removeAggregation("commands",o,s);this.fireModified();return r;};c.prototype.removeAllCommands=function(s){var d=this.removeAllAggregation("commands",s);this._toBeExecuted=-1;this.fireModified();return d;};c.prototype.isEmpty=function(){return this.getCommands().length===0;};c.prototype.execute=function(){this._oLastCommand=this._oLastCommand.catch(function(){}).then(function(){var o=this._getCommandToBeExecuted();if(o){return o.execute().then(function(){this._toBeExecuted--;var p={command:o,undo:false};this.fireCommandExecuted(p);this.fireModified();return this._waitForCommandExecutionHandler(p);}.bind(this)).catch(function(e){e=e||new Error("Executing of the change failed.");e.index=this._toBeExecuted;e.command=this.removeCommand(this._toBeExecuted);this._toBeExecuted--;return Promise.reject(e);}.bind(this));}}.bind(this));return this._oLastCommand;};c.prototype._unExecute=function(){if(this.canUndo()){this._bUndoneCommands=true;this._toBeExecuted++;var o=this._getCommandToBeExecuted();if(o){return o.undo().then(function(){var p={command:o,undo:true};this.fireCommandExecuted(p);this.fireModified();return this._waitForCommandExecutionHandler(p);}.bind(this));}else{return Promise.resolve();}}else{return Promise.resolve();}};c.prototype.canUndo=function(){return(this._toBeExecuted+1)<this.getCommands().length;};c.prototype.undo=function(){return this._unExecute();};c.prototype.canRedo=function(){return!!this._getCommandToBeExecuted();};c.prototype.redo=function(){return this.execute();};c.prototype.pushAndExecute=function(o){this.push(o);return this.execute();};c.prototype.getAllExecutedCommands=function(){var A=[];var d=this.getCommands();for(var i=d.length-1;i>this._toBeExecuted;i--){var s=this.getSubCommands(d[i]);A=A.concat(s);}return A;};c.prototype.getSubCommands=function(o){var d=[];if(o.getCommands){o.getCommands().forEach(function(s){var e=this.getSubCommands(s);d=d.concat(e);},this);}else{d.push(o);}return d;};return c;},true);
