/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/rta/plugin/Plugin','sap/ui/rta/Utils','sap/ui/fl/Utils','sap/ui/dt/OverlayRegistry',"sap/ui/events/KeyCodes","sap/ui/dt/Overlay","sap/ui/dt/Util","sap/ui/Device"],function(P,U,F,O,K,a,D,b){"use strict";var S=P.extend("sap.ui.rta.plugin.Selection",{metadata:{library:"sap.ui.rta",properties:{multiSelectionRequiredPlugins:{type:"string[]"}},associations:{},events:{elementEditableChange:{parameters:{editable:{type:"boolean"}}}}}});S.prototype.init=function(){this._multiSelectionValidator=this._multiSelectionValidator.bind(this);P.prototype.init.apply(this,arguments);};S.prototype._checkDeveloperMode=function(o){if(o.getDesignTimeMetadata()){var f=this.getCommandFactory().getFlexSettings().developerMode;if(f&&this.hasStableId(o)){o.setEditable(true);o.setSelectable(true);this.fireElementEditableChange({editable:true});return true;}}return false;};S.prototype.registerElementOverlay=function(o){if(!this._checkDeveloperMode(o)){o.attachEditableChange(this._onEditableChange,this);this._adaptSelectable(o);}o.attachBrowserEvent("click",this._selectOverlay,this);o.attachBrowserEvent("keydown",this._onKeyDown,this);o.attachBrowserEvent("mousedown",this._onMouseDown,this);o.attachBrowserEvent("mouseover",this._onMouseover,this);o.attachBrowserEvent("mouseleave",this._onMouseleave,this);};S.prototype._onEditableChange=function(E){var o=E.getSource();this._adaptSelectable(o);};S.prototype._adaptSelectable=function(o){var s=o.getEditable();if(o.getSelectable()!==s){o.setSelectable(s);if(!s){this._removePreviousHover();}this.fireElementEditableChange({editable:s});}};S.prototype.deregisterElementOverlay=function(o){o.detachBrowserEvent("click",this._selectOverlay,this);o.detachBrowserEvent("keydown",this._onKeyDown,this);o.detachBrowserEvent("mousedown",this._onMouseDown,this);o.detachBrowserEvent("mouseover",this._onMouseover,this);o.detachBrowserEvent("mouseleave",this._onMouseleave,this);o.detachEditableChange(this._onEditableChange,this);};S.prototype._setFocusOnOverlay=function(o,E){if(o&&o.getSelectable()){o.focus();E.stopPropagation();}};S.prototype._onKeyDown=function(E){var o=U.getFocusedOverlay();if(E.keyCode===K.ENTER){this._selectOverlay(E);}else if(E.keyCode===K.ARROW_UP&&E.shiftKey===false&&E.altKey===false){if(o){var p=U.getFocusableParentOverlay(o);this._setFocusOnOverlay(p,E);E.preventDefault();}}else if(E.keyCode===K.ARROW_DOWN&&E.shiftKey===false&&E.altKey===false){if(o){var f=U.getFirstFocusableDescendantOverlay(o);this._setFocusOnOverlay(f,E);E.preventDefault();}}else if(E.keyCode===K.ARROW_LEFT&&E.shiftKey===false&&E.altKey===false){if(o){var g=U.getPreviousFocusableSiblingOverlay(o);this._setFocusOnOverlay(g,E);E.preventDefault();}}else if(E.keyCode===K.ARROW_RIGHT&&E.shiftKey===false&&E.altKey===false){if(o){var n=U.getNextFocusableSiblingOverlay(o);this._setFocusOnOverlay(n,E);E.preventDefault();}}};S.prototype._selectOverlay=function(E){var o=O.getOverlay(E.currentTarget.id);var m=E.metaKey||E.ctrlKey;if(o&&o.getSelectable()){if(o.isSelected()){this.getDesignTime().getSelectionManager().remove(o);}else{if(m){this.getDesignTime().getSelectionManager().add(o);}else{this.getDesignTime().getSelectionManager().set(o);}}E.preventDefault();E.stopPropagation();}};S.prototype._onMouseDown=function(E){if(b.browser.name=="ie"){var t=O.getOverlay(E.target.id);var T=jQuery(E.target).hasClass("sapUiDtOverlayScrollContainer");var o=O.getOverlay(E.currentTarget.id);if(o&&(T||t instanceof a)){if(o.getSelectable()){o.focus();E.stopPropagation();}else{o.getDomRef().blur();}}}};S.prototype._onMouseover=function(E){var o=O.getOverlay(E.currentTarget.id);if(o.isSelectable()){if(o!==this._oHoverTarget){this._removePreviousHover();this._oHoverTarget=o;o.addStyleClass("sapUiRtaOverlayHover");}E.preventDefault();E.stopPropagation();}};S.prototype._onMouseleave=function(E){var o=O.getOverlay(E.currentTarget.id);if(o.isSelectable()){this._removePreviousHover();E.preventDefault();E.stopPropagation();}};S.prototype._removePreviousHover=function(){if(this._oHoverTarget){this._oHoverTarget.removeStyleClass("sapUiRtaOverlayHover");}delete this._oHoverTarget;};S.prototype.setDesignTime=function(o){if(this.getDesignTime()){this.getDesignTime().getSelectionManager().removeValidator(this._multiSelectionValidator);}P.prototype.setDesignTime.apply(this,arguments);if(this.getDesignTime()){this.getDesignTime().getSelectionManager().addValidator(this._multiSelectionValidator);}};S.prototype._multiSelectionValidator=function(E){return(E.length===1||(_(E,this.getMultiSelectionRequiredPlugins())&&c(E)&&(d(E)||e(E))));};function _(E,m){var s=m.slice();E.forEach(function(o){s=D.intersection(s,o.getEditableByPlugins());});return s.length>0;}function c(E){return E.every(function(o){return o.getRelevantContainer()===E[0].getRelevantContainer();});}function d(E){return E.every(function(o){return o.getParentElementOverlay()===E[0].getParentElementOverlay();});}function e(E){return E.every(function(o){return o.getElement().getMetadata().getName()===E[0].getElement().getMetadata().getName();});}return S;},true);
