/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/DateRange','./calendar/Header','./calendar/Month','./calendar/MonthPicker','./calendar/YearPicker','./calendar/CalendarDate','./library','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale',"./CalendarRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery"],function(C,L,a,D,H,M,b,Y,c,l,d,e,R,f,g,h,j,k,q){"use strict";var m=C.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",designtime:"sap/ui/unified/designtime/Calendar.designtime",properties:{intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:1},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},secondMonthHeader:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{},weekNumberSelect:{allowPreventDefault:true,parameters:{weekNumber:{type:"int"},weekDays:{type:"sap.ui.unified.DateRange"}}}}}});m.prototype.init=function(){this._iBreakPointTablet=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._iMode=0;this._iColumns=1;this._oYearFormat=e.getDateInstance({format:"y",calendarType:i});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=a._minDate(this.getPrimaryCalendarType());this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());this._initializeHeader();this._initializeSecondMonthHeader();var x=this._createMonth(this.getId()+"--Month0");x.attachEvent("focus",this._handleFocus,this);x.attachEvent("select",s,this);x.attachEvent("_renderMonth",r,this);x.attachEvent("_bindMousemove",t,this);x.attachEvent("_unbindMousemove",u,this);x._bNoThemeChange=true;this.addAggregation("month",x);this._initilizeMonthPicker();this._initilizeYearPicker();this._resizeProxy=q.proxy(v,this);this._oSelectedMonth;};m.prototype.exit=function(){if(this._sInvalidateMonth){clearTimeout(this._sInvalidateMonth);}if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}this._oSelectedMonth=null;};m.prototype._initializeHeader=function(){var i=new H(this.getId()+"--Head");i.attachEvent("pressPrevious",this._handlePrevious,this);i.attachEvent("pressNext",this._handleNext,this);i.attachEvent("pressButton1",this._handleButton1,this);i.attachEvent("pressButton2",this._handleButton2,this);i.attachEvent("pressButton3",this._handleButton1,this);i.attachEvent("pressButton4",this._handleButton2,this);this.setAggregation("header",i);};m.prototype._initializeSecondMonthHeader=function(){var S=new H(this.getId()+"--SecondMonthHead");S.addStyleClass("sapUiCalHeadSecondMonth");S.attachEvent("pressPrevious",this._handlePrevious,this);S.attachEvent("pressNext",this._handleNext,this);S.attachEvent("pressButton1",this._handleButton1,this);S.attachEvent("pressButton2",this._handleButton2,this);this.setAggregation("secondMonthHeader",S);};m.prototype._initilizeMonthPicker=function(){var i=new b(this.getId()+"--MP");i.attachEvent("select",this._selectMonth,this);i._bNoThemeChange=true;this.setAggregation("monthPicker",i);};m.prototype._initilizeYearPicker=function(){var y=new Y(this.getId()+"--YP");y.attachEvent("select",this._selectYear,this);this.setAggregation("yearPicker",y);};m.prototype._createMonth=function(i){var x=new M(i,{width:"100%"});x.attachEvent("datehovered",this._handleDateHovered,this);return x;};m.prototype._handleDateHovered=function(E){var x=this.getAggregation("month"),y=E.getParameter("date1"),z=E.getParameter("date2"),i;for(i=0;i<x.length;i++){x[i]._markDatesBetweenStartAndHoveredDate(y,z);}};m.prototype.onBeforeRendering=function(){var x=this.getAggregation("month");var y;var z=x[0].getDate();var F=this._getFocusedDate();if(x.length>1&&z){y=c.fromLocalJSDate(z,this.getPrimaryCalendarType());}else if(x.length>1){y=w.call(this,this._getFocusedDate());}else{y=F;}for(var i=0;i<x.length;i++){z=new c(y);if(i>0){z.setDate(1);z.setMonth(z.getMonth()+i);}var A=z;if(F.getYear()===z.getYear()&&F.getMonth()===z.getMonth()){A=F;}x[i].displayDate(A.toLocalJSDate());x[i].setShowWeekNumbers(this.getShowWeekNumbers());}this._updateHeader(y);this._iSize=0;};m.prototype.onAfterRendering=function(E){if(!this._getSucessorsPickerPopup()){n.call(this);}if(p.call(this)>1||this._bInitMonth){E.size={width:this.getDomRef().offsetWidth};v.call(this,E,true);if(!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}this._bInitMonth=undefined;}};m.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof D))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateMonth){this._sInvalidateMonth=setTimeout(this._invalidateMonth.bind(this,O),0);}};m.prototype.removeSelectedDate=function(S){this._bDateRangeChanged=true;return this.removeAggregation("selectedDates",S);};m.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("selectedDates");return i;};m.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};m.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("specialDates");return i;};m.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};m.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};m.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("disabledDates");return i;};m.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};m.prototype.setLocale=function(i){if(this._sLocale!=i){this._sLocale=i;this._oLocaleData=undefined;this.invalidate();}return this;};m.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};m.prototype._getFocusedDate=function(){if(!this._oFocusedDate){_.call(this);}return this._oFocusedDate;};m.prototype._setFocusedDate=function(i){a._checkCalendarDate(i);this._oFocusedDate=new c(i,this.getPrimaryCalendarType());};m.prototype.focusDate=function(i){o.call(this,i,false);return this;};m.prototype.displayDate=function(i){o.call(this,i,true);return this;};m.prototype.getStartDate=function(){var S;if(this.getDomRef()){var i=this.getAggregation("month");S=c.fromLocalJSDate(i[0].getDate(),this.getPrimaryCalendarType());}else{S=new c(this._getFocusedDate());}S.setDate(1);return S.toLocalJSDate();};m.prototype.setPopupMode=function(P){this._bPoupupMode=P;return this;};m.prototype.setMonths=function(x){this._bDateRangeChanged=undefined;this.setProperty("months",x,false);x=p.call(this);var y=this.getAggregation("month");var i=0;var z;if(y.length<x){for(i=y.length;i<x;i++){z=this._createMonth(this.getId()+"--Month"+i);z.attachEvent("focus",this._handleFocus,this);z.attachEvent("select",s,this);z.attachEvent("_renderMonth",r,this);z.attachEvent("_bindMousemove",t,this);z.attachEvent("_unbindMousemove",u,this);z._bNoThemeChange=true;this.addAggregation("month",z);}}else if(y.length>x){for(i=y.length;i>x;i--){z=this.removeAggregation("month",i-1);z.destroy();}if(x==1){this._bInitMonth=true;}}if(x>1&&y[0].getDate()){y[0].setProperty("date",null,true);}return this;};m.prototype.setPrimaryCalendarType=function(x){var y=this.getAggregation("month");var z=false;if(y.length>1){z=true;}this.setProperty("primaryCalendarType",x,!z);this._oYearFormat=e.getDateInstance({format:"y",calendarType:x});if(this._oFocusedDate){this._oFocusedDate=new c(this._oFocusedDate,x);}this._oMinDate=new c(this._oMinDate,x);this._oMaxDate=new c(this._oMaxDate,x);for(var i=0;i<y.length;i++){var A=y[i];A.setPrimaryCalendarType(x);}if(!this._getSucessorsPickerPopup()){var B=this.getAggregation("monthPicker");B.setPrimaryCalendarType(x);var E=this.getAggregation("yearPicker");E.setPrimaryCalendarType(x);}if(this.getDomRef()){this._updateHeader(this._oFocusedDate);if(!this._getSucessorsPickerPopup()){if(this.iMode!=1&&B.getDomRef()){B.$().remove();}if(this.iMode!=2&&E.getDomRef()){E.$().remove();}}}return this;};m.prototype.setSecondaryCalendarType=function(x){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",x,true);this._oYearFormatSecondary=e.getDateInstance({format:"y",calendarType:x});var y=this.getAggregation("month");for(var i=0;i<y.length;i++){var z=y[i];z.setSecondaryCalendarType(x);}if(this.getDomRef()){this._updateHeader(this._getFocusedDate());this.$().toggleClass("sapUiCalSecType",!!this._getSecondaryCalendarType());}return this;};m.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S==P){S=undefined;}}return S;};m.prototype.setMinDate=function(i){if(j(i,this.getMinDate())){return this;}if(!i){this._oMinDate=a._minDate(this.getPrimaryCalendarType());}else{a._checkJSDateObject(i);this._oMinDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var y=this._oMinDate.getYear();a._checkYearInValidRange(y);if(this._oMaxDate.isBefore(this._oMinDate)){k.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());this._oMaxDate.setDate(a._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(c.fromLocalJSDate(i,this.getPrimaryCalendarType()));}this.setProperty("minDate",i,false);if(!this._getSucessorsPickerPopup()){var x=this.getAggregation("yearPicker");x._oMinDate.setYear(this._oMinDate.getYear());}return this;};m.prototype.setMaxDate=function(i){if(j(i,this.getMaxDate())){return this;}if(!i){this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());}else{a._checkJSDateObject(i);this._oMaxDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var y=this._oMaxDate.getYear();a._checkYearInValidRange(y);if(this._oMinDate.isAfter(this._oMaxDate)){k.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(c.fromLocalJSDate(i,this.getPrimaryCalendarType()));}this.setProperty("maxDate",i,false);if(!this._getSucessorsPickerPopup()){var x=this.getAggregation("yearPicker");x._oMaxDate.setYear(this._oMaxDate.getYear());}return this;};m.prototype._setMinMaxDateExtend=function(i){if(this._oFocusedDate){if(a._isOutside(this._oFocusedDate,this._oMinDate,this._oMaxDate)){k.warning("focused date is not between [minDate - maxDate] -> refocus to the new max/min date: "+i.toString(),this);this.focusDate(i.toLocalJSDate());}}};m.prototype._getLocaleData=function(){if(!this._oLocaleData){var i=this.getLocale();var x=new f(i);this._oLocaleData=L.getInstance(x);}return this._oLocaleData;};m.prototype._getShowMonthHeader=function(){var i=p.call(this);if(i>2){return true;}else{return false;}};m.prototype.setWidth=function(W){this.setProperty("width",W,true);if(this.getDomRef()){W=this.getWidth();this.$().css("width",W);if(W){this.$().addClass("sapUiCalWidth");}else{this.$().removeClass("sapUiCalWidth");}}return this;};m.prototype.onclick=function(E){var i=E.target,T=i.classList.contains("sapUiCalWeekNum");if(this.getIntervalSelection()&&this.getPrimaryCalendarType()===sap.ui.core.CalendarType.Gregorian&&T){this._handleWeekSelection(i);}if(E.isMarked("delayedMouseEvent")){return;}if(i.id==this.getId()+"-cancel"){this.onsapescape(E);}};m.prototype.onmousedown=function(E){E.preventDefault();E.setMark("cancelAutoClose");};m.prototype.onsapescape=function(E){if(this._iMode==0){this.fireCancel();}this._closedPickers();};m.prototype.onsapshow=function(E){if(this._bPoupupMode){this._closedPickers();this.fireCancel();E.preventDefault();}};m.prototype.onsaphide=m.prototype.onsapshow;m.prototype.onsaptabnext=function(E){var x=this.getAggregation("header");if(h(this.getDomRef("content"),E.target)){if(this._shouldFocusB2OnTabNext(E)){var y=x.getDomRef("B2");if(y){y.focus();}}else{var z=x.getDomRef("B1");if(z){z.focus();}}if(!this._bPoupupMode){var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(!this._getSucessorsPickerPopup()){var F=this.getAggregation("monthPicker");var G=this.getAggregation("yearPicker");if(F.getDomRef()){q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(G.getDomRef()){q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}E.preventDefault();}else if(this._shouldFocusB2OnTabNext(E)){var y=x.getDomRef("B2");if(y){y.focus();}E.preventDefault();}};m.prototype._shouldFocusB2OnTabNext=function(E){var i=this.getAggregation("header");return(E.target.id==i.getId()+"-B1");};m.prototype._shouldFocusB2OnTabPrevious=function(E){return this._bPoupupMode;};m.prototype.onsaptabprevious=function(E){var x=this.getAggregation("header");if(h(this.getDomRef("content"),E.target)){if(this._shouldFocusB2OnTabPrevious()){var y=x.getDomRef("B2");if(y){y.focus();}E.preventDefault();}}else if(E.target.id==x.getId()+"-B1"){var z=this.getAggregation("month");var F;switch(this._iMode){case 0:F=this._getFocusedDate();for(var i=0;i<z.length;i++){var A=z[i];var B=c.fromLocalJSDate(A.getDate(),this.getPrimaryCalendarType());if(F.isSame(B)){A._oItemNavigation.focusItem(A._oItemNavigation.getFocusedIndex());}else{q(A._oItemNavigation.getItemDomRefs()[A._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}break;case 1:if(!this._getSucessorsPickerPopup()){var G=this.getAggregation("monthPicker");G._oItemNavigation.focusItem(G._oItemNavigation.getFocusedIndex());}break;case 2:if(!this._getSucessorsPickerPopup()){var I=this.getAggregation("yearPicker");I._oItemNavigation.focusItem(I._oItemNavigation.getFocusedIndex());}break;}E.preventDefault();}else if(E.target.id==x.getId()+"-B2"){var J=x.getDomRef("B1");if(J){J.focus();}E.preventDefault();}};m.prototype.onfocusin=function(E){if(E.target.id==this.getId()+"-end"){var x=this.getAggregation("month");this._focusOnShiftTab();if(!this._bPoupupMode){for(var i=0;i<x.length;i++){var y=x[i];q(y._oItemNavigation.getItemDomRefs()[y._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(!this._getSucessorsPickerPopup()){var z=this.getAggregation("monthPicker");var A=this.getAggregation("yearPicker");if(z.getDomRef()){q(z._oItemNavigation.getItemDomRefs()[z._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(A.getDomRef()){q(A._oItemNavigation.getItemDomRefs()[A._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};m.prototype._focusOnShiftTab=function(){var i=this.getAggregation("header");var x=i.getDomRef("B2");if(x){x.focus();}};m.prototype.onsapfocusleave=function(E){var x,y,z,A;if(!E.relatedControlId||!h(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){x=this.getAggregation("month");switch(this._iMode){case 0:for(var i=0;i<x.length;i++){y=x[i];q(y._oItemNavigation.getItemDomRefs()[y._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 1:if(!this._getSucessorsPickerPopup()){z=this.getAggregation("monthPicker");q(z._oItemNavigation.getItemDomRefs()[z._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 2:if(!this._getSucessorsPickerPopup()){A=this.getAggregation("yearPicker");q(A._oItemNavigation.getItemDomRefs()[A._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};m.prototype.getFocusDomRef=function(){var i=this._oSelectedMonth?this._oSelectedMonth:this.getAggregation("month")[0];return i._oItemNavigation.getItemDomRefs()[i._oItemNavigation.getFocusedIndex()];};m.prototype.onThemeChanged=function(){var x;if(!this.getDomRef()){return;}this._bNamesLengthChecked=undefined;if(!this._getSucessorsPickerPopup()){x=this.getAggregation("monthPicker");this._showMonthPicker(true);x._bNoThemeChange=false;x.onThemeChanged(arguments);x._bNoThemeChange=true;this._bLongMonth=x._bLongMonth;this._hideMonthPicker(true);}var y=this.getAggregation("month");for(var i=0;i<y.length;i++){var z=y[i];z._bNoThemeChange=false;z.onThemeChanged(arguments);z._bNoThemeChange=true;}var A;if(y.length>1){A=c.fromLocalJSDate(y[0].getDate(),this.getPrimaryCalendarType());}else{A=this._getFocusedDate();}this._setHeaderText(A);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();if(!this._getSucessorsPickerPopup()){n.call(this);}};m.prototype._updateHeader=function(i){this._setHeaderText(i);this._togglePrevNext(i,true);};m.prototype._togglePrevNext=function(i,x){var y=this._oMaxDate.getYear();var z=this._oMinDate.getYear();var A=this._oMaxDate.getMonth();var B=this._oMinDate.getMonth();var E=this.getAggregation("header");var F=p.call(this);var G=new c(i,this.getPrimaryCalendarType());if(this._iMode==0&&F>1){G=w.call(this,i);G.setMonth(G.getMonth()+F-1);G.setDate(a._daysInMonth(G));}else{G.setDate(a._daysInMonth(G));}var I=G.getYear();var J=G.getMonth();if(I>y||(I==y&&(!x||J>=A))||(this._iMode==1&&this._getSucessorsPickerPopup())){E.setEnabledNext(false);}else{E.setEnabledNext(true);}if(this._iMode==0&&F>1){G.setMonth(G.getMonth()-F+1);G.setDate(1);}else{G.setDate(1);}I=G.getYear();J=G.getMonth();if(I<z||(I==z&&(!x||J<=B))||(this._iMode==1&&this._getSucessorsPickerPopup())){E.setEnabledPrevious(false);}else{E.setEnabledPrevious(true);}};m.prototype._togglePrevNexYearPicker=function(){var y=this.getAggregation("yearPicker");var i=y.getYears();var x=c.fromLocalJSDate(y.getFirstRenderedDate());x.setYear(x.getYear()+Math.floor(i/2));var z=this.getAggregation("header");var A=new c(this._oMaxDate,this.getPrimaryCalendarType());A.setYear(A.getYear()-Math.ceil(i/2));A.setMonth(11);A.setDate(31);var B=new c(this._oMinDate,this.getPrimaryCalendarType());B.setYear(B.getYear()+Math.floor(i/2)+1);B.setMonth(0);B.setDate(1);z.setEnabledNext(x.isSameOrBefore(A));z.setEnabledPrevious(x.isSameOrAfter(B));};m.prototype._handlePrevious=function(E){var F=this._getFocusedDate();var y=this.getAggregation("yearPicker");var i=p.call(this);var x;var z;var S=false;switch(this._iMode){case 0:if(i>1){x=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());x.setDate(1);this._setFocusedDate(x);F=this._getFocusedDate();}else{F.setDate(1);}F.setDate(F.getDate()-1);this._renderMonth(S,true);break;case 1:F.setYear(F.getYear()-1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(F.toUTCJSDate(),true));var A=this._getSecondaryCalendarType();if(A){z=new c(F,A);z.setMonth(0);z.setDate(1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(z.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:y.previousPage();this._togglePrevNexYearPicker();break;}};m.prototype._handleNext=function(E){var F=this._getFocusedDate();var y=this.getAggregation("yearPicker");var i=p.call(this);var x;var z;switch(this._iMode){case 0:if(i>1){x=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());this._setFocusedDate(x);F=this._getFocusedDate();}F.setDate(1);F.setMonth(F.getMonth()+i);this._renderMonth();break;case 1:F.setYear(F.getYear()+1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(F.toUTCJSDate(),true));var S=this._getSecondaryCalendarType();if(S){z=new c(F,S);z.setMonth(0);z.setDate(1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(z.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:y.nextPage();this._togglePrevNexYearPicker();break;}};m.prototype._getDisplayedMonths=function(x){var y=[];var z=x.getMonth();var A=p.call(this);if(A>1){for(var i=0;i<A;i++){y.push((z+i)%12);}}else{y.push(z);}return y;};m.prototype._getDisplayedSecondaryMonths=function(P,S){var i=this.getAggregation("month");var F=c.fromLocalJSDate(i[0].getDate(),P);F.setDate(1);F=new c(F,S);var x=F.getMonth();var y=c.fromLocalJSDate(i[i.length-1].getDate(),P);y.setDate(a._daysInMonth(y));y=new c(y,S);var E=y.getMonth();return{start:x,end:E};};m.prototype._closedPickers=function(){switch(this._iMode){case 0:break;case 1:this._hideMonthPicker();break;case 2:this._hideYearPicker();break;}};m.prototype._setDisabledMonths=function(y,i){var x=0;var z=11;if(y==this._oMinDate.getYear()){x=this._oMinDate.getMonth();}if(y==this._oMaxDate.getYear()){z=this._oMaxDate.getMonth();}if(!i){i=this.getAggregation("monthPicker");}i.setMinMax(x,z);};m.prototype._handleFocus=function(E){var i=c.fromLocalJSDate(E.getParameter("date"),this.getPrimaryCalendarType());var O=E.getParameter("otherMonth");var x=E.getParameter("restoreOldDate");if(x){if(!j(this._getFocusedDate(),i)){this._renderMonth(false,false,true);}}else{this._focusDate(i,O);}};m.prototype._getVisibleDays=function(){var i=this.getAggregation("month")[0];return i._getVisibleDays(i._getDate(),false);};m.prototype._renderMonth=function(S,I,N){var x=this._getFocusedDate();var y=this.getAggregation("month");var F=false;var z;var A;var B;var i=0;for(i=0;i<y.length;i++){z=y[i];if(z.checkDateFocusable(x.toLocalJSDate())){F=true;}if(F||y.length==1){if(!S){z.setDate(x.toLocalJSDate());}else{z.displayDate(x.toLocalJSDate());}break;}}if(!F){B=new c(x,this.getPrimaryCalendarType());if(y.length>1){B=w.call(this,B);for(i=0;i<y.length;i++){z=y[i];A=new c(B,this.getPrimaryCalendarType());A.setMonth(B.getMonth()+i);if(!S&&a._isSameMonthAndYear(A,x)){z.setDate(x.toLocalJSDate());}else{z.displayDate(A.toLocalJSDate());}}}this._updateHeader(B);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();if(!N){this.fireStartDateChange();}}};function _(){var S=this.getSelectedDates();var i=this.getPrimaryCalendarType();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=c.fromLocalJSDate(S[0].getStartDate(),i);}else{this._oFocusedDate=c.fromLocalJSDate(new Date(),i);}if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new c(this._oMinDate,i);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new c(this._oMaxDate,i);}}m.prototype._showMonthPicker=function(S){if(this._iMode==2){this._hideYearPicker(true);}var x=this._getFocusedDate();var y=this.getAggregation("monthPicker");if(y.getDomRef()){y.$().css("display","");}else{var z=sap.ui.getCore().createRenderManager();var $=this.$("content");z.renderControl(y);z.flush($[0],false,true);z.destroy();}this._showOverlay();if(!S){y.setMonth(x.getMonth());this._setDisabledMonths(x.getYear(),y);if(this._iMode==0){var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this._iMode=1;this._togglePrevNext(x,false);};m.prototype._hideMonthPicker=function(S){this._iMode=0;var x=this.getAggregation("monthPicker");x.$().css("display","none");this._hideOverlay();if(!S){this._renderMonth();if(p.call(this)>1){var y=this.getAggregation("month");for(var i=0;i<y.length;i++){var z=y[i];q(z._oItemNavigation.getItemDomRefs()[z._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);};m.prototype._showYearPicker=function(){if(this._iMode==1){this._hideMonthPicker(true);}var x=this._getFocusedDate();var y=this.getAggregation("yearPicker");if(y.getDomRef()){y.$().css("display","");}else{var z=sap.ui.getCore().createRenderManager();var $=this.$("content");z.renderControl(y);z.flush($[0],false,true);z.destroy();}this._showOverlay();y.setDate(x.toLocalJSDate());var A;if(p.call(this)==1){A=this.getAggregation("month")[0];var B=A.$("days").find(".sapUiCalItem");if(B.length==28){y.$().addClass("sapUiCalYearNoTop");}else{y.$().removeClass("sapUiCalYearNoTop");}}if(this._iMode==0){var E=this.getAggregation("month");for(var i=0;i<E.length;i++){A=E[i];q(A._oItemNavigation.getItemDomRefs()[A._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}this._togglePrevNexYearPicker();this._iMode=2;};m.prototype._hideYearPicker=function(S){this._iMode=0;var y=this.getAggregation("yearPicker");y.$().css("display","none");this._hideOverlay();if(!S){this._renderMonth();if(p.call(this)>1){var x=this.getAggregation("month");for(var i=0;i<x.length;i++){var z=x[i];q(z._oItemNavigation.getItemDomRefs()[z._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);};function n(){if(!this._bNamesLengthChecked){this._showMonthPicker(true);this._hideMonthPicker(true);var i=this.getAggregation("monthPicker");this._bLongMonth=i._bLongMonth;this._bNamesLengthChecked=true;if(!this._bLongMonth){var x=this.getAggregation("month");var y;if(x.length>1){y=c.fromLocalJSDate(x[0].getDate(),this.getPrimaryCalendarType());}else{y=this._getFocusedDate();}this._setHeaderText(y);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();}}else if(p.call(this)>1){this._focusDate(this._getFocusedDate(),true,true);}}m.prototype._focusDate=function(i,O,N){var F;var x=false;var y=false;if(i.isBefore(this._oMinDate)){F=this._oMinDate;x=true;}else if(i.isAfter(this._oMaxDate)){F=this._oMaxDate;x=true;}else{F=i;}if(this._focusDateExtend){y=this._focusDateExtend(i,O,N);}var I=F.isBefore(this._getFocusedDate());this._setFocusedDate(F);if(x||O){this._renderMonth(false,I,N);}if(y){this.fireStartDateChange();}};m.prototype._invalidateMonth=function(O){this._sInvalidateMonth=undefined;var x=this.getAggregation("month");if(x){for(var i=0;i<x.length;i++){var y=x[i];y._bDateRangeChanged=true;y._bInvalidateSync=true;y._bNoFocus=true;y.invalidate(O);y._bInvalidateSync=undefined;}}this._bDateRangeChanged=undefined;};m.prototype._setHeaderText=function(i){var x=this.getAggregation("header");var S=this.getAggregation("secondMonthHeader");var y=this._getLocaleData();var z=[];var A=[];var B=[];var E;var F=false;var G;var I;var T;var J;var P;var K=this.getPrimaryCalendarType();var N=this._getSecondaryCalendarType();if(this._bLongMonth||!this._bNamesLengthChecked){z=y.getMonthsStandAlone("wide",K);}else{F=true;z=y.getMonthsStandAlone("abbreviated",K);A=y.getMonthsStandAlone("wide",K);}if(N){B=y.getMonthsStandAlone("abbreviated",N);var O=this._getDisplayedSecondaryMonths(K,N);if(O.start==O.end){T=B[O.start];}else{P=y.getIntervalPattern();T=P.replace(/\{0\}/,B[O.start]).replace(/\{1\}/,B[O.end]);}}x.setAdditionalTextButton1(T);x._setAdditionalTextButton3(T);S.setAdditionalTextButton1(T);var Q=this._getDisplayedMonths(i);this._sFirstMonthName=G=z[Q[0]];I=z[Q[Q.length-1]];if(Q.length>1&&!this._bShowOneMonth){if(!P){P=y.getIntervalPattern();}T=P.replace(/\{0\}/,G).replace(/\{1\}/,I);E=A.length?P.replace(/\{0\}/,A[Q[0]]).replace(/\{1\}/,A[Q[Q.length-1]]):T;}else{T=G;E=A[Q[0]]||T;}x.setTextButton1(T);x.setAriaLabelButton1(E);x._setTextButton3(I);x._setAriaLabelButton3(I);S.setTextButton1(I);S.setAriaLabelButton1(I);var U=new c(i,K);U.setDate(1);J=this._oYearFormat.format(U.toUTCJSDate(),true);this._updateHeadersYearPrimaryText(J);if(N){U=new c(U,N);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(U.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}return{sMonth:T,sYear:J,sAriaLabel:E,bShort:F};};function o(i,S){if(!i){return;}var x=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var y=x.getYear();a._checkYearInValidRange(y);if(a._isOutside(x,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(x);if(this.getDomRef()&&this._iMode==0){this._renderMonth(S,false,true);}}function p(){if(d.system.phone){return 1;}else{return this.getMonths();}}m.prototype._handleButton1=function(E){if(this._iMode!=1){this._showMonthPicker();}else{this._hideMonthPicker();}};m.prototype._handleButton2=function(E){if(this._iMode!=2){this._showYearPicker();}else{this._hideYearPicker();}};function r(E){this.fireEvent("_renderMonth",{days:E.getParameter("days")});}function s(E){if(p.call(this)>1){var x=this.getAggregation("month");for(var i=0;i<x.length;i++){var y=x[i];if(y.getId()!=E.oSource.getId()){y._updateSelection();}}}this._oSelectedMonth=E.oSource;this.fireSelect();}function t(E){if(p.call(this)>1){var x=this.getAggregation("month");for(var i=0;i<x.length;i++){var y=x[i];if(y.getId()!=E.oSource.getId()){y._bindMousemove();}}}}function u(E){if(p.call(this)>1){var x=this.getAggregation("month");for(var i=0;i<x.length;i++){var y=x[i];if(y.getId()!=E.oSource.getId()){y._unbindMousemove();}}}}m.prototype._selectMonth=function(){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType()),i=this.getAggregation("monthPicker"),x=i.getMonth();F.setMonth(x);if(x!=F.getMonth()){F.setDate(0);}this._focusDate(F,true);this._hideMonthPicker();};m.prototype._getSucessorsPickerPopup=function(){return this.getPickerPopup&&this.getPickerPopup();};m.prototype._selectYear=function(){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType());var y=this.getAggregation("yearPicker");var i=c.fromLocalJSDate(y.getDate(),this.getPrimaryCalendarType());i.setMonth(F.getMonth());i.setDate(F.getDate());F=i;this._focusDate(F,true);this._hideYearPicker();};m.prototype._showOverlay=function(){this.$("contentOver").css("display","");};m.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};m.prototype._setColumns=function(i){this._iColumns=i;return this;};m.prototype._getColumns=function(){return this._iColumns;};m.prototype._updateHeadersButtons=function(){var i=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader");if(this._isTwoMonthsInOneColumn()){S.setVisible(true);i._setVisibleButton3(false);i._setVisibleButton4(false);}else if(this._isTwoMonthsInTwoColumns()){S.setVisible(false);i._setVisibleButton3(true);i._setVisibleButton4(true);}else{S.setVisible(false);i._setVisibleButton3(false);i._setVisibleButton4(false);}};m.prototype._setPrimaryHeaderMonthButtonText=function(){var i=this.getAggregation("header");if(this._isTwoMonthsInOneColumn()||this._isTwoMonthsInTwoColumns()){i.setTextButton1(this._sFirstMonthName);}};m.prototype._toggleTwoMonthsInTwoColumnsCSS=function(){if(this._isTwoMonthsInTwoColumns()){this.addStyleClass("sapUiCalTwoMonthsTwoColumns");}else{this.removeStyleClass("sapUiCalTwoMonthsTwoColumns");}};m.prototype._isTwoMonthsInOneColumn=function(){var i=p.call(this);return this._getColumns()===1&&i===2;};m.prototype._isTwoMonthsInTwoColumns=function(){var i=p.call(this);return this._getColumns()===2&&i===2;};m.prototype._updateHeadersYearPrimaryText=function(y){var i=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader");i.setTextButton2(y);i.setAriaLabelButton2(y);i._setTextButton4(y);i._setAriaLabelButton4(y);S.setTextButton2(y);S.setAriaLabelButton2(y);};m.prototype._updateHeadersYearAdditionalText=function(y){var i=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader");i.setAdditionalTextButton2(y);i._setAdditionalTextButton4(y);S.setAdditionalTextButton2(y);};m.prototype._handleWeekSelection=function(E){var S=parseInt(E.innerText,10),i=q(E.parentElement).attr("data-sap-day"),F=sap.ui.core.format.DateFormat.getInstance({pattern:"yyyyMMdd"}),x=F.parse(i),y=new Date(x.getFullYear(),x.getMonth(),x.getDate()+6),z=new D({startDate:x,endDate:y}),A=this.getSelectedDates();if(A.length&&A[0].getStartDate().getTime()===z.getStartDate().getTime()&&A[0].getEndDate()&&A[0].getEndDate().getTime()===z.getEndDate().getTime()){z=null;}if(this.fireWeekNumberSelect({weekNumber:S,weekDays:z})){this.removeAllSelectedDates();this.addSelectedDate(z);this.focusDate(x);}};function v(E){var W=E.size.width;if(W<=0){return;}var O=this._iSize;if(W<this._iBreakPointTablet){this._iSize=0;}else if(W<this._iBreakPointDesktop){this._iSize=1;}else if(W<this._iBreakPointLargeDesktop){this._iSize=2;}else{this._iSize=3;}var x=p.call(this);if(O!=this._iSize||this._bInitMonth){switch(this._iSize){case 1:this._setColumns(2);break;case 2:this._setColumns(3);break;case 3:this._setColumns(4);break;default:this._setColumns(1);break;}if(x<this._getColumns()){this._setColumns(x);}if(this._getColumns()>2&&x>this._getColumns()){var y=this._getColumns();var U=0.0;var z=this._getColumns();while(y>=2){var A=x%y;if(A==0){z=y;break;}else{var N=A/y;if(N>U){U=N;z=y;}}y--;}this._setColumns(z);}var B;var F=this.getAggregation("month");if(this._getColumns()>1){B=100/this._getColumns()+"%";this.$("content").removeClass("sapUiCalContentSingle");}else{B="100%";this.$("content").addClass("sapUiCalContentSingle");}for(var i=0;i<F.length;i++){var G=F[i];G.setWidth(B);}}this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();}function w(i){var F=new c(i,this.getPrimaryCalendarType());F.setDate(1);var x=p.call(this);if(x<=12){var y=i.getMonth();y=y-y%x;if(12%x>0&&y+x>11){y=12-x;}F.setMonth(y);}return F;}return m;});
