/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library','sap/ui/core/Locale',"./MonthRenderer","sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(C,D,L,I,a,b,l,c,d,e,M,f,K,q){"use strict";var g=d.CalendarType;var h=l.CalendarDayType;var j=C.extend("sap.ui.unified.calendar.Month",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},otherMonth:{type:"boolean"},restoreOldDate:{type:"boolean"}}}}}});j.prototype.init=function(){var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._oFormatYyyymmdd=c.getInstance({pattern:"yyyyMMdd",calendarType:g.Gregorian});this._oFormatLong=c.getInstance({style:"long",calendarType:i});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._iColumns=7;this._aVisibleDays=[];};j.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateMonth){clearTimeout(this._sInvalidateMonth);}this._aVisibleDays=null;};j.prototype.onAfterRendering=function(){_.call(this);t.call(this);};j.prototype.onmouseover=function(E){var T=q(E.target),S,i,u;if(!this.getIntervalSelection()){return;}S=this.getSelectedDates()[0];if(!S||!S.getStartDate()||S.getEndDate()){return;}if(!T.hasClass('sapUiCalItemText')&&!T.hasClass('sapUiCalItem')){return;}if(T.hasClass('sapUiCalItemText')){T=T.parent();}i=parseInt(this._oFormatYyyymmdd.format(S.getStartDate()),10);u=T.data("sapDay");if(i>u){i=i+u;u=i-u;i=i-u;}if(this.hasListeners("datehovered")){this.fireEvent("datehovered",{date1:i,date2:u});}else{this._markDatesBetweenStartAndHoveredDate(i,u);}};j.prototype._markDatesBetweenStartAndHoveredDate=function(u,v){var w,$,x,i;w=this.$().find(".sapUiCalItem");for(i=0;i<w.length;i++){$=q(w[i]);x=$.data('sapDay');if(x>u&&x<v){$.addClass('sapUiCalItemSelBetween');}else{$.removeClass('sapUiCalItemSelBetween');}}};j.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!f(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){this._unbindMousemove(true);var S=this._selectDay(this._getDate());if(!S&&this._oMoveSelectedDate){this._selectDay(this._oMoveSelectedDate);}this._bMoveChange=false;this._bMousedownChange=false;this._oMoveSelectedDate=undefined;s.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;s.call(this);}}};j.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};j.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};j.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};j.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};j.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("disabledDates");return R;};j.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};j.prototype.setDate=function(i){var u=b.fromLocalJSDate(i,this.getPrimaryCalendarType());n.call(this,u,false);return this;};j.prototype._setDate=function(i){var u=i.toLocalJSDate();this.setProperty("date",u,true);this._oDate=i;};j.prototype._getDate=function(){if(!this._oDate){this._oDate=b.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());}return this._oDate;};j.prototype.displayDate=function(i){var u=b.fromLocalJSDate(i,this.getPrimaryCalendarType());n.call(this,u,true);return this;};j.prototype.setPrimaryCalendarType=function(i){this.setProperty("primaryCalendarType",i);this._oFormatLong=c.getInstance({style:"long",calendarType:i});if(this._oDate){this._oDate=new b(this._oDate,i);}return this;};j.prototype.setSecondaryCalendarType=function(i){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",i);this.invalidate();this._oFormatSecondaryLong=c.getInstance({style:"long",calendarType:i});return this;};j.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S==P){S=undefined;}}return S;};j.prototype._getLocale=function(){var P=this.getParent();if(P&&P.getLocale){return P.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};j.prototype._getLocaleData=function(){var P=this.getParent();if(P&&P._getLocaleData){return P._getLocaleData();}else if(!this._oLocaleData){var i=this._getLocale();var u=new e(i);this._oLocaleData=L.getInstance(u);}return this._oLocaleData;};j.prototype._getFormatLong=function(){var i=this._getLocale();if(this._oFormatLong.oLocale.toString()!=i){var u=new e(i);this._oFormatLong=c.getInstance({style:"long",calendarType:this.getPrimaryCalendarType()},u);if(this._oFormatSecondaryLong){this._oFormatSecondaryLong=c.getInstance({style:"long",calendarType:this._getSecondaryCalendarType()},u);}}return this._oFormatLong;};j.prototype.getIntervalSelection=function(){var P=this.getParent();if(P&&P.getIntervalSelection){return P.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};j.prototype.getSingleSelection=function(){var P=this.getParent();if(P&&P.getSingleSelection){return P.getSingleSelection();}else{return this.getProperty("singleSelection");}};j.prototype.getSelectedDates=function(){var P=this.getParent();if(P&&P.getSelectedDates){return P.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};j.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};j.prototype.getDisabledDates=function(){var P=this.getParent();if(P&&P.getDisabledDates){return P.getDisabledDates();}else{return this.getAggregation("disabledDates",[]);}};j.prototype._getShowHeader=function(){var P=this.getParent();if(P&&P._getShowMonthHeader){return P._getShowMonthHeader();}else{return this.getProperty("showHeader");}};j.prototype.getAriaLabelledBy=function(){var P=this.getParent();if(P&&P.getAriaLabelledBy){return P.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};j.prototype.getLegend=function(){var P=this.getParent();if(P&&P.getLegend){return P.getLegend();}else{return this.getAssociation("legend",[]);}};j.prototype._getFirstDayOfWeek=function(){var P=this.getParent();var F=0;if(P&&P.getFirstDayOfWeek){F=P.getFirstDayOfWeek();}else{F=this.getProperty("firstDayOfWeek");}if(F<0||F>6){var i=this._getLocaleData();F=i.getFirstDayOfWeek();}return F;};j.prototype._getNonWorkingDays=function(){var P=this.getParent();var N;if(P&&P.getNonWorkingDays){N=P.getNonWorkingDays();}else{N=this.getProperty("nonWorkingDays");}if(N&&!Array.isArray(N)){N=[];}return N;};j.prototype._checkDateSelected=function(u){a._checkCalendarDate(u);var S=0;var v=this.getSelectedDates();var T=u.toUTCJSDate().getTime();var w=this.getPrimaryCalendarType();for(var i=0;i<v.length;i++){var R=v[i];var x=R.getStartDate();var y=0;if(x){x=b.fromLocalJSDate(x,w);y=x.toUTCJSDate().getTime();}var E=R.getEndDate();var z=0;if(E){E=b.fromLocalJSDate(E,w);z=E.toUTCJSDate().getTime();}if(T==y&&!E){S=1;break;}else if(T==y&&E){S=2;if(E&&T==z){S=5;}break;}else if(E&&T==z){S=3;break;}else if(E&&T>y&&T<z){S=4;break;}if(this.getSingleSelection()){break;}}return S;};j.prototype._getDateTypes=function(u){a._checkCalendarDate(u);var T,v,N,w=[];var S=this.getSpecialDates();var x=u.toUTCJSDate().getTime();var y=this.getPrimaryCalendarType();for(var i=0;i<S.length;i++){var R=S[i];var z=R.getStartDate();var A=a.MAX_MILLISECONDS;if(z){z=b.fromLocalJSDate(z,y);A=z.toUTCJSDate().getTime();}var E=R.getEndDate();var B=-a.MAX_MILLISECONDS;if(E){E=b.fromLocalJSDate(E,y);B=E.toUTCJSDate().getTime();}N=R.getType()===h.NonWorking;if((x==A&&!E)||(x>=A&&x<=B)){if(!N&&!T){T={type:R.getType(),tooltip:R.getTooltip_AsString()};w.push(T);}else if(N&&!v){v={type:R.getType(),tooltip:R.getTooltip_AsString()};w.push(v);}if(T&&v){break;}}}return w;};j.prototype._checkDateEnabled=function(u){a._checkCalendarDate(u);var E=true;var v=this.getDisabledDates();var T=u.toUTCJSDate().getTime();var w=this.getPrimaryCalendarType();var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(T<P._oMinDate.valueOf()||T>P._oMaxDate.valueOf()){return false;}}for(var i=0;i<v.length;i++){var R=v[i];var S=R.getStartDate();var x=0;if(S){S=b.fromLocalJSDate(S,w);x=S.toUTCJSDate().getTime();}var y=R.getEndDate();var z=0;if(y){y=b.fromLocalJSDate(y,w);z=y.toUTCJSDate().getTime();}if(y){if(T>x&&T<z){E=false;break;}}else if(T==x){E=false;break;}}return E;};j.prototype.setWidth=function(w){this.setProperty("width",w,true);if(this.getDomRef()){w=this.getWidth();this.$().css("width",w);}return this;};j.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){this._unbindMousemove(true);}var T=q(E.target);if(T.hasClass("sapUiCalItemText")){T=T.parent();}if(this._sLastTargetId&&this._sLastTargetId==T.attr("id")){return;}this._sLastTargetId=T.attr("id");if(T.hasClass("sapUiCalItem")){var O=this._getDate();if(!f(this.getDomRef(),E.target)){var S=this.getSelectedDates();if(S.length>0&&this.getSingleSelection()){var i=S[0].getStartDate();if(i){i=b.fromLocalJSDate(i,this.getPrimaryCalendarType());}var u=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(T.attr("data-sap-day")));if(u.isSameOrAfter(i)){p.call(this,i,u);}else{p.call(this,u,i);}}}else{var F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(T.attr("data-sap-day")),this.getPrimaryCalendarType());if(!F.isSame(O)){if(T.hasClass("sapUiCalItemOtherMonth")){this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});}else{this._setDate(F);var v=this._selectDay(F,true);if(v){this._oMoveSelectedDate=new b(F,this.getPrimaryCalendarType());}this._bMoveChange=true;}}}}};j.prototype.onmousedown=function(E){this._oMousedownPosition={clientX:E.clientX,clientY:E.clientY};};j.prototype.onmouseup=function(E){if(this._bMouseMove){this._unbindMousemove(true);var F=this._getDate();var u=this._oItemNavigation.getItemDomRefs();for(var i=0;i<u.length;i++){var $=q(u[i]);if(!$.hasClass("sapUiCalItemOtherMonth")){if($.attr("data-sap-day")==this._oFormatYyyymmdd.format(F.toUTCJSDate(),true)){$.focus();break;}}}if(this._bMoveChange){var S=this._selectDay(F);if(!S&&this._oMoveSelectedDate){this._selectDay(this._oMoveSelectedDate);}this._bMoveChange=false;this._bMousedownChange=false;this._oMoveSelectedDate=undefined;s.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;s.call(this);}else if(D.support.touch&&this._isValueInThreshold(this._oMousedownPosition.clientX,E.clientX,10)&&this._isValueInThreshold(this._oMousedownPosition.clientY,E.clientY,10)&&(E.target.classList.contains("sapUiCalItemText")||E.target.classList.contains("sapUiCalDayName"))){var v=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(q(E.target).parent().attr("data-sap-day")),this.getPrimaryCalendarType());this._selectDay(v,false,false);s.call(this);}};j.prototype.onsapselect=function(E){var S=this._selectDay(this._getDate());if(S){s.call(this);}E.stopPropagation();E.preventDefault();};j.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};j.prototype.onsappageupmodifiers=function(E){var F=new b(this._getDate(),this.getPrimaryCalendarType());var y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(y-10);}else{F.setYear(y-1);}this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});E.preventDefault();};j.prototype.onsappagedownmodifiers=function(E){var F=new b(this._getDate(),this.getPrimaryCalendarType());var y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(y+10);}else{F.setYear(y+1);}this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});E.preventDefault();};j.prototype._updateSelection=function(){var S=this.getSelectedDates();if(S.length>0){var i=this.getPrimaryCalendarType();var u=S.map(function(v){var w=v.getStartDate();if(w){return b.fromLocalJSDate(w,i);}});var E=S[0].getEndDate();if(E){E=b.fromLocalJSDate(E,i);}p.call(this,u,E);}};j.prototype._isValueInThreshold=function(R,v,T){var i=R-T,u=R+T;return v>=i&&v<=u;};j.prototype._bindMousemove=function(F){q(window.document).bind('mousemove',this._mouseMoveProxy);this._bMouseMove=true;if(F){this.fireEvent("_bindMousemove");}};j.prototype._unbindMousemove=function(F){q(window.document).unbind('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;this._sLastTargetId=undefined;if(F){this.fireEvent("_unbindMousemove");}};j.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return;}this._bNamesLengthChecked=undefined;this._bLongWeekDays=undefined;var w=this.$().find(".sapUiCalWH");var u=this._getLocaleData();var S=this._getFirstWeekDay();var v=u.getDaysStandAlone("abbreviated",this.getPrimaryCalendarType());for(var i=0;i<w.length;i++){var W=w[i];q(W).text(v[(i+S)%7]);}t.call(this);};j.prototype._handleBorderReached=function(i){var E=i.getParameter("event");var u=0;var O=this._getDate();var F=new b(O,this.getPrimaryCalendarType());if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":if(E.keyCode==K.ARROW_DOWN){F.setDate(F.getDate()+7);}else{F.setDate(F.getDate()+1);}break;case"sapprevious":case"sappreviousmodifiers":if(E.keyCode==K.ARROW_UP){F.setDate(F.getDate()-7);}else{F.setDate(F.getDate()-1);}break;case"sappagedown":u=F.getMonth()+1;F.setMonth(u);if(u%12!=F.getMonth()){while(u!=F.getMonth()){F.setDate(F.getDate()-1);}}break;case"sappageup":u=F.getMonth()-1;F.setMonth(u);if(u<0){u=11;}if(u!=F.getMonth()){while(u!=F.getMonth()){F.setDate(F.getDate()-1);}}break;default:break;}this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});}};j.prototype.checkDateFocusable=function(i){a._checkJSDateObject(i);var u=this._getDate();var v=b.fromLocalJSDate(i,this.getPrimaryCalendarType());return a._isSameMonthAndYear(v,u);};j.prototype.applyFocusInfo=function(i){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this;};j.prototype._renderHeader=function(){if(this._getShowHeader()){var i=this._getDate();var u=this._getLocaleData();var v=u.getMonthsStandAlone("wide",this.getPrimaryCalendarType());this.$("Head").text(v[i.getMonth()]);}};j.prototype._getFirstWeekDay=function(){return this._getFirstDayOfWeek();};j.prototype._isMonthNameLong=function(w){var i;var W;for(i=0;i<w.length;i++){W=w[i];if(Math.abs(W.clientWidth-W.scrollWidth)>1){return true;}}return false;};j.prototype._getVisibleDays=function(S,i){var N,u,v,w,F,x,y;if(!S){return this._aVisibleDays;}this._aVisibleDays=[];x=this._getFirstDayOfWeek();F=new b(S,this.getPrimaryCalendarType());F.setDate(1);w=F.getDay()-x;if(w<0){w=7+w;}if(w>0){F.setDate(1-w);}u=new b(F);N=(S.getMonth()+1)%12;do{y=u.getYear();v=new b(u,this.getPrimaryCalendarType());if(i&&y<1){v._bBeforeFirstYear=true;this._aVisibleDays.push(v);}else if(y>0&&y<10000){this._aVisibleDays.push(v);}u.setDate(u.getDate()+1);}while(u.getMonth()!==N||u.getDay()!==x);return this._aVisibleDays;};j.prototype._handleMousedown=function(E,F,i){var T=(D.browser.msie||D.browser.edge)&&navigator.maxTouchPoints,w=E.target.classList.contains("sapUiCalWeekNum"),u=!E.button;if(!u||D.support.touch||(w&&(u||T))){return;}var S=this._selectDay(F);if(S){this._bMousedownChange=true;}if(this._bMouseMove){this._unbindMousemove(true);this._bMoveChange=false;this._oMoveSelectedDate=undefined;}else if(S&&this.getIntervalSelection()&&this.$().is(":visible")){this._bindMousemove(true);this._oMoveSelectedDate=new b(F,this.getPrimaryCalendarType());}E.preventDefault();E.setMark("cancelAutoClose");};j.prototype._selectDay=function(u,v){if(!this._checkDateEnabled(u)){return false;}var S=this.getSelectedDates();var w;var x=this._oItemNavigation.getItemDomRefs();var $;var y;var i=0;var P=this.getParent();var A=this;var z;var B=this.getPrimaryCalendarType();if(P&&P.getSelectedDates){A=P;}if(this.getSingleSelection()){if(S.length>0){w=S[0];z=w.getStartDate();if(z){z=b.fromLocalJSDate(z,B);}}else{w=new sap.ui.unified.DateRange();A.addAggregation("selectedDates",w,true);}if(this.getIntervalSelection()&&(!w.getEndDate()||v)&&z){var E;if(u.isBefore(z)){E=z;z=u;if(!v){w.setProperty("startDate",z.toLocalJSDate(),true);w.setProperty("endDate",E.toLocalJSDate(),true);}}else if(u.isSameOrAfter(z)){E=u;if(!v){w.setProperty("endDate",E.toLocalJSDate(),true);}}p.call(this,z,E);}else{p.call(this,u);w.setProperty("startDate",u.toLocalJSDate(),true);w.setProperty("endDate",undefined,true);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var F=this._checkDateSelected(u);if(F>0){for(i=0;i<S.length;i++){z=S[i].getStartDate();if(z&&u.isSame(b.fromLocalJSDate(z,B))){A.removeAggregation("selectedDates",i,true);break;}}}else{w=new sap.ui.unified.DateRange({startDate:u.toLocalJSDate()});A.addAggregation("selectedDates",w,true);}y=this._oFormatYyyymmdd.format(u.toUTCJSDate(),true);for(i=0;i<x.length;i++){$=q(x[i]);if($.attr("data-sap-day")==y){if(F>0){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}}}}}return true;};function _(){var y=this._oFormatYyyymmdd.format(this._getDate().toUTCJSDate(),true);var u=0;var R=this.$("days").get(0);var v=this.$("days").find(".sapUiCalItem");for(var i=0;i<v.length;i++){var $=q(v[i]);if($.attr("data-sap-day")===y){u=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,k,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,m,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,this._handleBorderReached,this);this.addDelegate(this._oItemNavigation);if(this._iColumns>1){this._oItemNavigation.setHomeEndColumnMode(true,true);}this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(this._iColumns,true);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(v);this._oItemNavigation.setFocusedIndex(u);this._oItemNavigation.setPageSize(v.length);}function k(u){var v=u.getParameter("index");var E=u.getParameter("event");if(!E){return;}var O=this._getDate();var F=new b(O,this.getPrimaryCalendarType());var w=false;var x=true;var y=this._oItemNavigation.getItemDomRefs();var i=0;var $=q(y[v]);var z;if($.hasClass("sapUiCalItemOtherMonth")){if(E.type=="saphomemodifiers"&&(E.metaKey||E.ctrlKey)){F.setDate(1);this._focusDate(F);}else if(E.type=="sapendmodifiers"&&(E.metaKey||E.ctrlKey)){for(i=y.length-1;i>0;i--){z=q(y[i]);if(!z.hasClass("sapUiCalItemOtherMonth")){F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(z.attr("data-sap-day")),this.getPrimaryCalendarType());break;}}this._focusDate(F);}else{w=true;F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse($.attr("data-sap-day")),this.getPrimaryCalendarType());if(!F){F=new b(O);}this._focusDate(O);if(E.type=="mousedown"||(this._sTouchstartYyyyMMdd&&E.type=="focusin"&&this._sTouchstartYyyyMMdd==$.attr("data-sap-day"))){x=false;this.fireFocus({date:O.toLocalJSDate(),otherMonth:false,restoreOldDate:true});}if(E.originalEvent&&E.originalEvent.type=="touchstart"){this._sTouchstartYyyyMMdd=$.attr("data-sap-day");}else{this._sTouchstartYyyyMMdd=undefined;}}}else{if(q(E.target).hasClass("sapUiCalWeekNum")){this._focusDate(F);}else{F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse($.attr("data-sap-day")),this.getPrimaryCalendarType());this._setDate(F);}this._sTouchstartYyyyMMdd=undefined;}if(E.type=="mousedown"&&this.getIntervalSelection()){this._sLastTargetId=$.attr("id");}if(x){this.fireFocus({date:F.toLocalJSDate(),otherMonth:w});}if(E.type=="mousedown"){this._handleMousedown(E,F,v);}}function m(i){var u=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var F=this._getDate();if(this.getIntervalSelection()){var v=this._oItemNavigation.getItemDomRefs();this._sLastTargetId=v[u].id;}this._handleMousedown(E,F,u);}}function n(i,N){a._checkCalendarDate(i);var y=i.getYear();a._checkYearInValidRange(y);var F=true;if(!this.getDate()||!i.isSame(b.fromLocalJSDate(this.getDate(),i.getCalendarType()))){var u=new b(i);F=this.checkDateFocusable(i.toLocalJSDate());this.setProperty("date",i.toLocalJSDate(),true);this._oDate=u;}if(this.getDomRef()){if(F){this._focusDate(this._oDate,true,N);}else{o.call(this,N);}}}j.prototype._focusDate=function(u,S,v){if(!S){this.setDate(u.toLocalJSDate());}var y=this._oFormatYyyymmdd.format(u.toUTCJSDate(),true);var w=this._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<w.length;i++){$=q(w[i]);if($.attr("data-sap-day")==y){if(document.activeElement!=w[i]){if(v){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}};function o(N){var u=this.getRenderer().getStartDate(this);var $=this.$("days");var w=this.$("weeks");var v;var x;var i=0;var y=0;if(this._sLastTargetId){v=this._oItemNavigation.getItemDomRefs();for(i=0;i<v.length;i++){x=q(v[i]);if(x.attr("id")==this._sLastTargetId){y=i;break;}}}if($.length>0){var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderDays(R,this,u);R.flush($[0]);if(w.length){this.getRenderer().renderWeekNumbers(R,this);R.flush(w[0]);}R.destroy();}this._renderHeader();this.fireEvent("_renderMonth",{days:$.find(".sapUiCalItem").length});_.call(this);if(!N){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());}if(this._sLastTargetId){v=this._oItemNavigation.getItemDomRefs();if(y<=v.length-1){x=q(v[y]);this._sLastTargetId=x.attr("id");}}}function p(S,E){if(!Array.isArray(S)){S=[S];}var u=this._oItemNavigation.getItemDomRefs();var $;var i=0;var v=false;var w=false;if(!E){var x=S.map(function(z){return this._oFormatYyyymmdd.format(z.toUTCJSDate(),true);},this);for(i=0;i<u.length;i++){$=q(u[i]);v=false;w=false;if(x.indexOf($.attr("data-sap-day"))>-1){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");v=true;}else if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}r.call(this,$,v,w);}}else{var y;for(i=0;i<u.length;i++){$=q(u[i]);v=false;w=false;y=b.fromLocalJSDate(this._oFormatYyyymmdd.parse($.attr("data-sap-day")),g.Gregorian);if(y.isSame(S[0])){$.addClass("sapUiCalItemSelStart");v=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");if(E&&y.isSame(E)){$.addClass("sapUiCalItemSelEnd");w=true;}$.removeClass("sapUiCalItemSelBetween");}else if(E&&a._isBetween(y,S[0],E)){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.addClass("sapUiCalItemSelBetween");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelEnd");}else if(E&&y.isSame(E)){$.addClass("sapUiCalItemSelEnd");w=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelBetween");}else{if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}}r.call(this,$,v,w);}}}function r($,S,E){if(!this.getIntervalSelection()){return;}var u="";var v=[];var w=this.getId();var x=false;u=$.attr("aria-describedby");if(u){v=u.split(" ");}var y=-1;var z=-1;for(var i=0;i<v.length;i++){var A=v[i];if(A==(w+"-Start")){y=i;}if(A==(w+"-End")){z=i;}}if(y>=0&&!S){v.splice(y,1);x=true;if(z>y){z--;}}if(z>=0&&!E){v.splice(z,1);x=true;}if(y<0&&S){v.push(w+"-Start");x=true;}if(z<0&&E){v.push(w+"-End");x=true;}if(x){u=v.join(" ");$.attr("aria-describedby",u);}}function s(){if(this._bMouseMove){this._unbindMousemove(true);}this.fireSelect();}function t(){if(!this._bNamesLengthChecked){var w;var W=this.$().find(".sapUiCalWH");var T=this._isMonthNameLong(W);var i=0;if(T){this._bLongWeekDays=false;var u=this._getLocaleData();var S=this._getFirstWeekDay();var v=u.getDaysStandAlone("narrow",this.getPrimaryCalendarType());for(i=0;i<W.length;i++){w=W[i];q(w).text(v[(i+S)%7]);}}else{this._bLongWeekDays=true;}this._bNamesLengthChecked=true;}}return j;});
