/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/m/Button","sap/m/MenuButton","sap/m/library","sap/m/Toolbar","sap/ui/core/IconPool","sap/ui/core/Item","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ScrollEnablement","sap/ui/layout/HorizontalLayout","sap/ui/Device","sap/ui/core/CustomData","./HierarchicalSelect","./library","sap/uxap/AnchorBarRenderer","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/events/F6Navigation"],function(q,B,M,m,T,I,a,R,S,H,D,C,b,l,A,L,K,F){"use strict";var c=m.SelectType;var d=T.extend("sap.uxap.AnchorBar",{metadata:{library:"sap.uxap",properties:{showPopover:{type:"boolean",defaultValue:true},upperCase:{type:"boolean",defaultValue:false},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance"}},associations:{selectedButton:{type:"sap.m.Button",multiple:false}},aggregations:{_select:{type:"sap.uxap.HierarchicalSelect",multiple:false,visibility:"hidden"},_scrollArrowLeft:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_scrollArrowRight:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});d.prototype.init=function(){if(T.prototype.init){T.prototype.init.call(this);}this.addStyleClass("sapUxAPAnchorBar");this._oPressHandlers={};this._oSectionInfo={};this._oScroller=null;this._sSelectedKey=null;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._bRtlScenario=this._bRtl&&!D.browser.msie;this._bHasButtonsBar=D.system.tablet||D.system.desktop;this.oLibraryResourceBundleOP=sap.ui.getCore().getLibraryResourceBundle("sap.uxap");this._oSelect=this._getHierarchicalSelect();if(this._bHasButtonsBar){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:true,vertical:false,nonTouchScrolling:true});this._iREMSize=0;this._iTolerance=0;this._iOffset=0;this._sResizeListenerId=undefined;}this.setDesign("Transparent");};d.SCROLL_STEP=250;d.SCROLL_DURATION=500;d.DOM_CALC_DELAY=200;d.prototype.setSelectedButton=function(o){var p=this.getSelectedButton(),P,s=this._oSelect.getItems(),h=s.length>0;if(typeof o==="string"){o=sap.ui.getCore().byId(o);}if(o){if(o.getId()===p){return this;}var e=o.data("sectionId");this._sSelectedKey=e;if(e&&h){this._oSelect.setSelectedKey(e);}if(this._bHasButtonsBar){P=sap.ui.getCore().byId(p);this._toggleSelectionStyleClass(P,false);this._toggleSelectionStyleClass(o,true);if(e){this.scrollToSection(e,d.SCROLL_DURATION);}this._setAnchorButtonsTabFocusValues(o);}}return this.setAssociation("selectedButton",o,true);};d.prototype.setShowPopover=function(v,s){if(this.getShowPopover()===v){return this;}return this.setProperty("showPopover",v,true);};d.prototype.setBackgroundDesign=function(s){var e=this.getBackgroundDesign(),$=this.$(),f="sapUxAPAnchorBar";if(e===s){return this;}this.setProperty("backgroundDesign",s,true);if($.length){$.removeClass(f+e);$.addClass(f+s);}return this;};d.prototype.getSelectedSection=function(){var s=this.getSelectedButton();if(s&&(typeof(s)==="string")){s=sap.ui.getCore().byId(s);}if(s&&(s instanceof B)&&s.data("sectionId")){return sap.ui.getCore().byId(s.data("sectionId"));}return null;};d.prototype.onBeforeRendering=function(){var s=this.getBackgroundDesign();if(this._bHasButtonsBar){this._iREMSize=parseInt(q("body").css("font-size"),10);this._iTolerance=this._iREMSize*1;this._iOffset=this._iREMSize*3;}if(T.prototype.onBeforeRendering){T.prototype.onBeforeRendering.call(this);}var e=this.getContent()||[],u=this.getUpperCase();this._oSelect.removeAllItems();this._oSelect.setUpperCase(u);this.toggleStyleClass("sapUxAPAnchorBarUpperCase",u);if(s){this.addStyleClass("sapUxAPAnchorBar"+s);}e.forEach(function(o){this._createSelectItem(o);},this);if(e.length>0&&this._sSelectedKey){this._oSelect.setSelectedKey(this._sSelectedKey);}};d.prototype.addContent=function(o,i){o.addStyleClass("sapUxAPAnchorBarButton");o.removeAllAriaDescribedBy();if(this._bHasButtonsBar&&(o.data("secondLevel")===true||o.data("secondLevel")==="true")){o.attachPress(this._handleDirectScroll,this);}return this.addAggregation("content",o,i);};d.prototype._createSelectItem=function(o){var i=o.data("secondLevel")===true||o.data("secondLevel")==="true";if(o.getText().trim()!=""&&(!i||o.data("bTitleVisible")===true)){var p=new a({key:o.data("sectionId"),text:o.getText(),customData:[new C({key:"secondLevel",value:o.data("secondLevel")})]});this._oSelect.addItem(p);}if(i){this.removeContent(o);o.destroy();}};d.prototype._decorateSubMenuButtons=function(e){var f=e.getSource().getContent();f.forEach(function(o){o.$().attr("aria-controls",o.data("sectionId"));});};d.prototype._toggleSelectionStyleClass=function(o,e){if(o){o.toggleStyleClass("sapUxAPAnchorBarButtonSelected",e);o.$().attr("aria-checked",e);if(o instanceof M){o._getButtonControl().$().attr("aria-checked",e);}}};d.prototype._handleDirectScroll=function(e){this._requestScrollToSection(e.getSource().data("sectionId"));};d.prototype._requestScrollToSection=function(r){var o=sap.ui.getCore().byId(r),e=o.getParent();if(this.getParent()instanceof l.ObjectPageLayout){var n=r;if(o instanceof l.ObjectPageSubSection&&e instanceof l.ObjectPageSection){n=e.getId();}this.getParent().setDirectScrollingToSection(n);this.getParent().scrollToSection(o.getId(),null,0,true);}if(o instanceof l.ObjectPageSubSection&&e instanceof l.ObjectPageSection){e.setAssociation("selectedSubSection",o,true);}};d.prototype._onSelectChange=function(e){var s=e.getParameter("selectedItem"),o;o=sap.ui.getCore().byId(s.getKey());if(o){this._requestScrollToSection(o.getId());}else{L.error("AnchorBar :: cannot find corresponding section",s.getKey());}};d.prototype._getHierarchicalSelect=function(){if(!this.getAggregation('_select')){this.setAggregation('_select',new b({width:"100%",icon:"sap-icon://slim-arrow-down",tooltip:this.oLibraryResourceBundleOP.getText("ANCHOR_BAR_OVERFLOW"),change:q.proxy(this._onSelectChange,this)}));}return this.getAggregation('_select');};d.prototype._createScrollArrow=function(e){var s,i,f,g,o,t=this,h=this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SCROLL_LEFT_ARROW"),j=this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SCROLL_RIGHT_ARROW");if(e){s=this.getId()+"-arrowScrollLeft";i="slim-arrow-left";f="anchorBarArrowLeft";g=this._bRtl?j:h;}else{s=this.getId()+"-arrowScrollRight";i="slim-arrow-right";f="anchorBarArrowRight";g=this._bRtl?h:j;}o=new B(s,{icon:I.getIconURI(i),type:"Transparent",press:function(E){E.preventDefault();t._handleScrollButtonTap(e);},tooltip:g});o.addEventDelegate({onAfterRendering:function(){if(sap.ui.getCore().getConfiguration().getTheme()!="sap_hcb"){this.$().attr("tabindex",-1);}},onThemeChanged:function(){if(sap.ui.getCore().getConfiguration().getTheme()=="sap_hcb"){this.$().removeAttr("tabindex");}else{this.$().attr("tabindex",-1);}}},o);return new H({content:[o]}).addStyleClass("anchorBarArrow").addStyleClass(f);};d.prototype._getScrollArrowLeft=function(){var s=this.getAggregation("_scrollArrowLeft");if(s){return s;}else{s=this._createScrollArrow(true);this.setAggregation("_scrollArrowLeft",s);return s;}};d.prototype._getScrollArrowRight=function(){var s=this.getAggregation("_scrollArrowRight");if(s){return s;}else{s=this._createScrollArrow(false);this.setAggregation("_scrollArrowRight",s);return s;}};d.prototype._applyHierarchicalSelectMode=function(){if(this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon){this.$().find(".sapUxAPAnchorBarScrollContainer").show();this._oSelect.setWidth("auto");this._oSelect.setAutoAdjustWidth(true);this._oSelect.setType(c.IconOnly);this._computeBarSectionsInfo();}else{this.$().find(".sapUxAPAnchorBarScrollContainer").hide();this._oSelect.setWidth("100%");this._oSelect.setAutoAdjustWidth(false);this._oSelect.setType(c.Default);}this.$().toggleClass("sapUxAPAnchorBarOverflow",this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon);};d.prototype._adjustSize=function(){var n=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())?A._AnchorBarHierarchicalSelectMode.Text:A._AnchorBarHierarchicalSelectMode.Icon;if(n!==this._sHierarchicalSelectMode){this._sHierarchicalSelectMode=n;this._applyHierarchicalSelectMode();}if(this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon){if(this._iMaxPosition<0){return;}var $=this.$(),e=$.find(".sapUxAPAnchorBarScrollContainer"),N,f,i;i=e.width();if(this._bRtlScenario){if(D.browser.firefox){f=Math.abs(e.scrollLeft())+i<(this._iMaxPosition-this._iTolerance);N=Math.abs(e.scrollLeft())>=this._iTolerance;}else{f=Math.abs(e.scrollLeft())>=this._iTolerance;N=Math.abs(e.scrollLeft())+i<(this._iMaxPosition-this._iTolerance);}}else{f=e.scrollLeft()+i<(this._iMaxPosition-this._iTolerance);N=e.scrollLeft()>=this._iTolerance;}L.debug("AnchorBar :: scrolled at "+e.scrollLeft(),"scrollBegin ["+(N?"true":"false")+"] scrollEnd ["+(f?"true":"false")+"]");$.toggleClass("sapUxAPAnchorBarScrollLeft",N);$.toggleClass("sapUxAPAnchorBarScrollRight",f);}};d.prototype._handleScrollButtonTap=function(s){var i=((!this._bRtlScenario&&s)||(this._bRtlScenario&&!s))?-1:1;this._oScroller.scrollTo(this._iMaxPosition*i,0,d.SCROLL_DURATION*3);};d.prototype.scrollToSection=function(i,e){if(this._bHasButtonsBar){var e=e||d.SCROLL_DURATION,s;if(!l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())&&this._oSectionInfo[i]){if(this._bRtlScenario&&D.browser.firefox){s=this._oSectionInfo[i].scrollLeft+this._iOffset;}else{s=this._oSectionInfo[i].scrollLeft-this._iOffset;if(s<0){s=0;}}L.debug("AnchorBar :: scrolling to section "+i+" of "+s);if(this._sCurrentScrollId!=i){this._sCurrentScrollId=i;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);q(document.getElementById(this.getId()+"-scroll")).parent().stop(true,false);}this._iCurrentScrollTimeout=setTimeout(function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;}.bind(this),e);this._oScroller.scrollTo(s,0,e);}}else{L.debug("AnchorBar :: no need to scroll to "+i);}}};d.prototype.getScrollDelegate=function(){return this._oScroller;};d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;d.prototype.onsapright=function(e){e.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(e.target.id.indexOf(o.getId())>-1){n=i+1;return;}});if(n&&f[n]){f[n].focus();}else if(f[f.length-1]){f[f.length-1].focus();}};d.prototype.onsapleft=function(e){e.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(e.target.id.indexOf(o.getId())>-1){n=i-1;return;}});if(n&&f[n]){f[n].focus();}else if(f[0]){f[0].focus();}};d.prototype.onsaphome=function(e){e.preventDefault();var f=this.getContent();f[0].focus();};d.prototype.onsapend=function(e){e.preventDefault();var f=this.getContent();f[f.length-1].focus();};d.prototype.onsappageup=function(e){this._handlePageUp(e);};d.prototype.onsappagedown=function(e){this._handlePageDown(e);};d.prototype._handlePageUp=function(e){e.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(e.target.id.indexOf(o.getId())>-1){n=i-(d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return;}});if(n&&f[n]){f[n].focus();}else if(f[0]){f[0].focus();}};d.prototype._handlePageDown=function(e){e.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(e.target.id.indexOf(o.getId())>-1){n=i+d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return;}});if(n&&f[n]){f[n].focus();}else if(f[f.length-1]){f[f.length-1].focus();}};d.prototype._setAnchorButtonsTabFocusValues=function(s){var e=this.getContent()||[],$,f='0',n='-1',t="tabIndex";e.forEach(function(o){$=o.getAggregation("_button")?o.getAggregation("_button").$():o.$();if(o.sId===s.sId){$.attr(t,f);}else{$.attr(t,n);}});};d.prototype.onsapskipforward=function(e){this._handleGroupNavigation(e,false);};d.prototype._handleGroupNavigation=function(e,s){var E=q.Event("keydown"),o={},O=this.getParent(),u=O.getUseIconTabBar(),f=O.getSelectedSection(),g=O._getVisibleSections(),h=[this.getDomRef()],i=[];if(u){i=sap.ui.getCore().byId(f).getSubSections().map(function(j){return j.$().attr("tabindex",-1)[0];});h=h.concat(i);}else{g.forEach(function(j){i=j.getSubSections().map(function(k){return k.$().attr("tabindex",-1)[0];});h=h.concat(i);});}o.scope=h;e.preventDefault();this.$().focus();E.target=e.target;E.keyCode=K.F6;E.key="F6";E.shiftKey=s;F.handleF6GroupNavigation(E,o);};d.prototype.onAfterRendering=function(){var s;if(T.prototype.onAfterRendering){T.prototype.onAfterRendering.call(this);}s=sap.ui.getCore().byId(this.getSelectedButton());this._iMaxPosition=-1;this._sResizeListenerId=R.register(this,q.proxy(this._adjustSize,this));this.$().find(".sapUxAPAnchorBarScrollContainer").scroll(q.proxy(this._onScroll,this));if(s){this.setSelectedButton(s);this._setAnchorButtonsTabFocusValues(s);}if(this._bHasButtonsBar){setTimeout(function(){if(this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon){this._computeBarSectionsInfo();}this._adjustSize();}.bind(this),d.DOM_CALC_DELAY);}};d.prototype._onScroll=function(){if(!this._iCurrentSizeCheckTimeout){this._iCurrentSizeCheckTimeout=setTimeout(function(){this._iCurrentSizeCheckTimeout=undefined;this._adjustSize();}.bind(this),d.SCROLL_DURATION);}};d.prototype._computeBarSectionsInfo=function(){this._iMaxPosition=0;var e=this.getContent()||[];e.forEach(this._computeNextSectionInfo,this);if(this._bRtlScenario&&(D.browser.webkit||D.browser.firefox)){e.forEach(this._adjustNextSectionInfo,this);this._oScroller.scrollTo(this._iMaxPosition,0,0);}};d.prototype._computeNextSectionInfo=function(o){if(o.data("bHasSubMenu")){o.$().attr("aria-haspopup","true");}o.$().attr("aria-controls",o.data("sectionId")).attr("aria-checked",false);if(o instanceof M){o._getButtonControl().$().attr("aria-controls",o.data("sectionId")).attr("aria-checked",false);}var w=o.$().outerWidth(true);this._oSectionInfo[o.data("sectionId")]={scrollLeft:this._iMaxPosition,width:w};this._iMaxPosition+=w;};d.prototype._adjustNextSectionInfo=function(o){var s=this._oSectionInfo[o.data("sectionId")];if(D.browser.firefox){s.scrollLeft=-s.scrollLeft;}else{s.scrollLeft=this._iMaxPosition-s.scrollLeft-s.width;}};d.prototype._resetControl=function(){this.destroyAggregation('content',true);return this;};d.prototype.enhanceAccessibilityState=function(e,f){var o=this.getContent(),i=o.indexOf(e);if(i!==-1){f.role="menuitemradio";f.type="button";f.setsize=o.length;f.posinset=i+1;}};d.prototype.exit=function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=null;}};return d;});
