/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.gmap.api;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.gmap.api.GEvent;
import org.wicketstuff.gmap.api.GLatLng;
import org.wicketstuff.gmap.api.GMarker;
import org.wicketstuff.gmap.api.GOverlay;
import org.wicketstuff.gmap.js.Constructor;
import org.wicketstuff.gmap.js.ObjectLiteral;

public class GInfoWindow
extends GOverlay {
    private static final long serialVersionUID = 1L;
    private GLatLng latLng;
    private GMarker marker;
    private String content;
    private boolean contentIsNode;
    private Integer maxWidth;
    private Boolean disableAutoPan;
    private Integer zIndex;

    public GInfoWindow(GLatLng latLng, String content) {
        this(latLng);
        this.content = ((Object)Strings.replaceAll((CharSequence)content, (CharSequence)"'", (CharSequence)"\\'")).toString();
    }

    public GInfoWindow(GLatLng latLng, Component content) {
        this(latLng);
        Args.notNull((Object)content, (String)"content");
        content.setOutputMarkupId(true);
        String markupId = content.getMarkupId(true);
        this.content = String.format("document.getElementById('%s')", markupId);
        this.contentIsNode = true;
    }

    private GInfoWindow(GLatLng latLng) {
        this.latLng = (GLatLng)Args.notNull((Object)latLng, (String)"latLng");
    }

    @Override
    public String getJSconstructor() {
        ObjectLiteral args = new ObjectLiteral();
        if (!this.contentIsNode) {
            args.setString("content", this.content);
        } else {
            args.set("content", this.content);
        }
        args.set("position", this.latLng.toString());
        if (this.maxWidth != null) {
            args.set("maxWidth", this.maxWidth.toString());
        }
        if (this.disableAutoPan != null) {
            args.set("disableAutoPan", this.disableAutoPan.toString());
        }
        if (this.zIndex != null) {
            args.set("zIndex", this.zIndex.toString());
        }
        Constructor constructor = new Constructor("google.maps.InfoWindow").add(args.toJS());
        return constructor.toJS();
    }

    @Override
    protected void updateOnAjaxCall(AjaxRequestTarget target, GEvent overlayEvent) {
    }

    public boolean isOpen() {
        return this.latLng != null || this.marker != null;
    }

    public void close() {
        this.marker = null;
        this.latLng = null;
        AjaxRequestTarget target = (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class);
        if (target != null) {
            target.appendJavaScript((CharSequence)super.getJSremove());
        }
    }

    public GLatLng getLatLng() {
        return this.latLng;
    }

    public void setMaxWidth(Integer maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setLatLng(GLatLng latLng) {
        this.latLng = latLng;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Integer getMaxWidth() {
        return this.maxWidth;
    }

    public Boolean getDisableAutoPan() {
        return this.disableAutoPan;
    }

    public void setDisableAutoPan(Boolean disableAutoPan) {
        this.disableAutoPan = disableAutoPan;
    }

    public Integer getzIndex() {
        return this.zIndex;
    }

    public void setzIndex(Integer zIndex) {
        this.zIndex = zIndex;
    }
}

