/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.gmap.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.cycle.RequestCycle;
import org.wicketstuff.gmap.GMap;
import org.wicketstuff.gmap.api.GEvent;
import org.wicketstuff.gmap.api.GEventHandler;

public abstract class GOverlay
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String id;
    private GMap parent = null;
    private final Map<GEvent, GEventHandler> events = new EnumMap<GEvent, GEventHandler>(GEvent.class);
    private final Map<GEvent, String> functions = new EnumMap<GEvent, String>(GEvent.class);

    public GOverlay() {
        this.id = String.valueOf(Session.get().nextSequenceValue());
    }

    public GOverlay(String id) {
        this.id = id;
    }

    public String getJS() {
        return ((Object)this.addFunctions(this.addEvents(this.addOverlays(new StringBuilder())))).toString();
    }

    private StringBuilder addOverlays(StringBuilder js) {
        js.append(this.parent.getJSinvoke("addOverlay('overlay" + this.getId() + "', " + this.getJSconstructor() + ")"));
        js.append(this.parent.getJSinvoke("overlays['overlay" + this.getId() + "'].setMap(Wicket.maps['" + this.parent.getMapId() + "'].map)"));
        return js;
    }

    private CharSequence addFunctions(StringBuilder js) {
        for (GEvent event : this.functions.keySet()) {
            js.append(event.getJSadd(this, this.functions.get((Object)event)));
        }
        return js;
    }

    private StringBuilder addEvents(StringBuilder js) {
        for (GEvent event : this.events.keySet()) {
            js.append(event.getJSadd(this));
        }
        return js;
    }

    public String getJSremove() {
        StringBuilder js = new StringBuilder();
        for (GEvent event : this.events.keySet()) {
            js.append(event.getJSclear(this));
        }
        js.append(this.parent.getJSinvoke("removeOverlay('overlay" + this.getId() + "')"));
        return js.toString();
    }

    public String getId() {
        return this.id;
    }

    public abstract String getJSconstructor();

    public GMap getParent() {
        return this.parent;
    }

    protected Page getPage() {
        Page page = null;
        if (this.getParent() != null) {
            page = this.getParent().getPage();
        }
        return page;
    }

    public void setParent(GMap parent) {
        this.parent = parent;
    }

    public GOverlay addListener(GEvent event, GEventHandler handler) {
        this.events.put(event, handler);
        AjaxRequestTarget target = (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class);
        if (target != null && this.getPage() != null) {
            target.appendJavaScript((CharSequence)event.getJSadd(this));
        }
        return this;
    }

    public GOverlay addFunctionListener(GEvent event, String jsFunction) {
        this.functions.put(event, jsFunction);
        AjaxRequestTarget target = (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class);
        if (target != null && this.getPage() != null) {
            target.appendJavaScript((CharSequence)event.getJSadd(this, this.functions.get((Object)event)));
        }
        return this;
    }

    public Map<GEvent, GEventHandler> getListeners() {
        return Collections.unmodifiableMap(this.events);
    }

    public Map<GEvent, String> getFunctionListeners() {
        return Collections.unmodifiableMap(this.functions);
    }

    public GOverlay clearListeners(GEvent event) {
        this.events.remove((Object)event);
        AjaxRequestTarget target = (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class);
        if (target != null) {
            target.appendJavaScript((CharSequence)event.getJSclear(this));
        }
        return this;
    }

    public void onEvent(AjaxRequestTarget target, GEvent overlayEvent) {
        this.updateOnAjaxCall(target, overlayEvent);
        this.events.get((Object)overlayEvent).onEvent(target);
    }

    protected abstract void updateOnAjaxCall(AjaxRequestTarget var1, GEvent var2);
}

