/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.gmap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.gmap.GMapHeaderContributor;
import org.wicketstuff.gmap.GMapMarkerClustererHeaderContributor;
import org.wicketstuff.gmap.GOverlayContainer;
import org.wicketstuff.gmap.api.GEvent;
import org.wicketstuff.gmap.api.GLatLng;
import org.wicketstuff.gmap.api.GLatLngBounds;
import org.wicketstuff.gmap.api.GMapType;
import org.wicketstuff.gmap.api.GMarker;
import org.wicketstuff.gmap.api.GMarkerCluster;
import org.wicketstuff.gmap.api.GMarkerOptions;
import org.wicketstuff.gmap.api.GOverlay;
import org.wicketstuff.gmap.event.GEventListenerBehavior;

public class GMap
extends Panel
implements GOverlayContainer {
    private static final Logger log = LoggerFactory.getLogger(GMap.class);
    private static final long serialVersionUID = 1L;
    private GLatLng center = new GLatLng(37.4419, -122.1419);
    private boolean draggingEnabled = true;
    private boolean doubleClickZoomEnabled = false;
    private boolean scrollWheelZoomEnabled = false;
    private boolean streetViewControlEnabled = false;
    private boolean zoomControlEnabled = true;
    private boolean mapTypeControlEnabled = true;
    private boolean scaleControlEnabled = false;
    private boolean panControlEnabled = true;
    private GMapType mapType = GMapType.ROADMAP;
    private int zoom = 13;
    private int minZoom = 0;
    private int maxZoom = 0;
    private final Map<String, GOverlay> overlays = new HashMap<String, GOverlay>();
    protected final WebMarkupContainer map;
    private GLatLngBounds bounds;
    private OverlayListener overlayListener = null;
    private List<GLatLng> markersToShow = new ArrayList<GLatLng>();
    private boolean jsInitialized = false;
    private boolean failSilently = false;
    private GMarkerCluster markerCluster;

    public GMap(String id, String apiKey) {
        this(id, new GMapHeaderContributor("http", apiKey));
    }

    public GMap(String id, String apiKey, String scheme) {
        this(id, new GMapHeaderContributor(scheme, apiKey));
    }

    public GMap(String id, GMapHeaderContributor headerContrib) {
        super(id);
        if (headerContrib != null) {
            this.add(new Behavior[]{headerContrib});
        }
        this.map = new WebMarkupContainer("map");
        this.map.setOutputMarkupId(true);
        this.add(new Component[]{this.map});
        this.overlayListener = this.getOverlayListener();
        this.add(new Behavior[]{this.overlayListener});
    }

    protected OverlayListener getOverlayListener() {
        return new OverlayListener();
    }

    public String getMapId() {
        return this.map.getMarkupId();
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        if (this.getApplication().usesDevelopmentConfig() && !this.getApplication().getMarkupSettings().getStripWicketTags()) {
            log.warn("Application is in DEVELOPMENT mode && Wicket tags are not stripped,Some Chrome Versions will not render the GMap. Change to DEPLOYMENT mode  || turn on Wicket tags stripping. See: http://www.nabble.com/Gmap2-problem-with-Firefox-3.0-to18137475.html.");
        }
    }

    public void renderHead(IHeaderResponse response) {
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.getJSinit()));
        this.jsInitialized = true;
    }

    @Override
    public GMap addOverlay(GOverlay overlay) {
        this.overlays.put(overlay.getId(), overlay);
        overlay.setParent(this);
        Optional target = this.getRequestCycle().find(AjaxRequestTarget.class);
        if (target.isPresent() && this.findPage() != null && this.jsInitialized) {
            ((AjaxRequestTarget)target.get()).appendJavaScript((CharSequence)overlay.getJS());
        }
        return this;
    }

    @Override
    public GMap removeOverlay(GOverlay overlay) {
        while (this.overlays.containsKey(overlay.getId())) {
            this.overlays.remove(overlay.getId());
        }
        Optional target = RequestCycle.get().find(AjaxRequestTarget.class);
        if (target.isPresent() && this.findPage() != null && this.jsInitialized) {
            ((AjaxRequestTarget)target.get()).appendJavaScript((CharSequence)overlay.getJSremove());
        }
        overlay.setParent(null);
        return this;
    }

    @Override
    public GMap removeAllOverlays() {
        for (GOverlay overlay : this.overlays.values()) {
            overlay.setParent(null);
        }
        this.overlays.clear();
        Optional target = this.getRequestCycle().find(AjaxRequestTarget.class);
        if (target.isPresent() && this.findPage() != null && this.jsInitialized) {
            ((AjaxRequestTarget)target.get()).appendJavaScript((CharSequence)this.getJSinvoke("clearOverlays()"));
        }
        return this;
    }

    @Override
    public List<GOverlay> getOverlays() {
        return Collections.unmodifiableList(new ArrayList<GOverlay>(this.overlays.values()));
    }

    public GLatLngBounds getBounds() {
        return this.bounds;
    }

    public void setBounds(GLatLngBounds bounds) {
        this.bounds = bounds;
    }

    public CharSequence getTriggerEventScript(String event) {
        return "Wicket.maps['" + this.getMapId() + "'].triggerEvent('" + event + "')";
    }

    public CharSequence getTriggerResizeScript() {
        return "Wicket.maps['" + this.getMapId() + "'].triggerResize();";
    }

    public void setDraggingEnabled(boolean enabled) {
        if (this.draggingEnabled != enabled) {
            this.draggingEnabled = enabled;
            Optional target = this.getRequestCycle().find(AjaxRequestTarget.class);
            if (target.isPresent() && this.findPage() != null && this.jsInitialized) {
                ((AjaxRequestTarget)target.get()).appendJavaScript((CharSequence)this.getJSsetDraggingEnabled(enabled));
            }
        }
    }

    public boolean isDraggingEnabled() {
        return this.draggingEnabled;
    }

    public void setDoubleClickZoomEnabled(boolean enabled) {
        if (this.doubleClickZoomEnabled != enabled) {
            this.doubleClickZoomEnabled = enabled;
            Optional target = RequestCycle.get().find(AjaxRequestTarget.class);
            if (target.isPresent() && this.findPage() != null && this.jsInitialized) {
                ((AjaxRequestTarget)target.get()).appendJavaScript((CharSequence)this.getJSsetDoubleClickZoomEnabled(enabled));
            }
        }
    }

    public boolean isDoubleClickZoomEnabled() {
        return this.doubleClickZoomEnabled;
    }

    public void setScrollWheelZoomEnabled(boolean enabled) {
        if (this.scrollWheelZoomEnabled != enabled) {
            this.scrollWheelZoomEnabled = enabled;
            Optional target = this.getRequestCycle().find(AjaxRequestTarget.class);
            if (target.isPresent() && this.findPage() != null && this.jsInitialized) {
                ((AjaxRequestTarget)target.get()).appendJavaScript((CharSequence)this.getJSsetScrollWheelZoomEnabled(enabled));
            }
        }
    }

    public boolean isScrollWheelZoomEnabled() {
        return this.scrollWheelZoomEnabled;
    }

    public boolean isStreetViewControlEnabled() {
        return this.streetViewControlEnabled;
    }

    public void setStreetViewControlEnabled(boolean enabled) {
        if (this.streetViewControlEnabled != enabled) {
            this.streetViewControlEnabled = enabled;
            Optional target = this.getRequestCycle().find(AjaxRequestTarget.class);
            if (target.isPresent() && this.findPage() != null && this.jsInitialized) {
                ((AjaxRequestTarget)target.get()).appendJavaScript((CharSequence)this.getJSsetStreetViewControlEnabled(enabled));
            }
        }
    }

    public boolean isZoomControlEnabled() {
        return this.zoomControlEnabled;
    }

    public void setZoomControlEnabled(boolean enabled) {
        if (this.zoomControlEnabled != enabled) {
            this.zoomControlEnabled = enabled;
            Optional target = this.getRequestCycle().find(AjaxRequestTarget.class);
            if (target.isPresent() && this.findPage() != null && this.jsInitialized) {
                ((AjaxRequestTarget)target.get()).appendJavaScript((CharSequence)this.getJSsetZoomControlEnabled(enabled));
            }
        }
    }

    public boolean isMapTypeControlEnabled() {
        return this.mapTypeControlEnabled;
    }

    public void setMapTypeControlEnabled(boolean enabled) {
        if (this.mapTypeControlEnabled != enabled) {
            this.mapTypeControlEnabled = enabled;
            Optional target = this.getRequestCycle().find(AjaxRequestTarget.class);
            if (target.isPresent() && this.findPage() != null && this.jsInitialized) {
                ((AjaxRequestTarget)target.get()).appendJavaScript((CharSequence)this.getJSsetMapTypeControlEnabled(enabled));
            }
        }
    }

    public boolean isScaleControlEnabled() {
        return this.scaleControlEnabled;
    }

    public void setScaleControlEnabled(boolean enabled) {
        if (this.scaleControlEnabled != enabled) {
            this.scaleControlEnabled = enabled;
            Optional target = this.getRequestCycle().find(AjaxRequestTarget.class);
            if (target.isPresent() && this.findPage() != null && this.jsInitialized) {
                ((AjaxRequestTarget)target.get()).appendJavaScript((CharSequence)this.getJSsetScaleControlEnabled(enabled));
            }
        }
    }

    public boolean isPanControlEnabled() {
        return this.panControlEnabled;
    }

    public void setPanControlEnabled(boolean enabled) {
        if (this.panControlEnabled != enabled) {
            this.panControlEnabled = enabled;
            Optional target = this.getRequestCycle().find(AjaxRequestTarget.class);
            if (target.isPresent() && this.findPage() != null && this.jsInitialized) {
                ((AjaxRequestTarget)target.get()).appendJavaScript((CharSequence)this.getJSsetPanControlEnabled(enabled));
            }
        }
    }

    public GMapType getMapType() {
        return this.mapType;
    }

    public void setMapType(GMapType mapType) {
        if (this.mapType != mapType) {
            this.mapType = mapType;
            Optional target = RequestCycle.get().find(AjaxRequestTarget.class);
            if (target.isPresent() && this.findPage() != null && this.jsInitialized) {
                ((AjaxRequestTarget)target.get()).appendJavaScript((CharSequence)mapType.getJSsetMapType(this));
            }
        }
    }

    public int getZoom() {
        return this.zoom;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public void setZoom(int level) {
        if (this.zoom != level) {
            this.zoom = level;
            Optional target = this.getRequestCycle().find(AjaxRequestTarget.class);
            if (target.isPresent() && this.findPage() != null && this.jsInitialized) {
                ((AjaxRequestTarget)target.get()).appendJavaScript((CharSequence)this.getJSsetZoom(this.zoom));
            }
        }
    }

    public void setMinZoom(int level) {
        if (this.minZoom != level) {
            this.minZoom = level >= 0 ? level : 0;
            Optional target = this.getRequestCycle().find(AjaxRequestTarget.class);
            if (target.isPresent() && this.findPage() != null && this.jsInitialized) {
                ((AjaxRequestTarget)target.get()).appendJavaScript((CharSequence)this.getJSsetMinZoom(this.minZoom));
            }
        }
    }

    public void setMaxZoom(int level) {
        if (this.maxZoom != level) {
            this.maxZoom = level >= 0 ? level : 0;
            Optional target = this.getRequestCycle().find(AjaxRequestTarget.class);
            if (target.isPresent() && this.findPage() != null && this.jsInitialized) {
                ((AjaxRequestTarget)target.get()).appendJavaScript((CharSequence)this.getJSsetMaxZoom(this.maxZoom));
            }
        }
    }

    public GLatLng getCenter() {
        return this.center;
    }

    public void setCenter(GLatLng center) {
        if (!this.center.equals(center)) {
            this.center = center;
            Optional target = RequestCycle.get().find(AjaxRequestTarget.class);
            if (target.isPresent() && this.findPage() != null && this.jsInitialized) {
                ((AjaxRequestTarget)target.get()).appendJavaScript((CharSequence)this.getJSsetCenter(center));
            }
        }
    }

    public void panTo(GLatLng center) {
        if (!this.center.equals(center)) {
            this.center = center;
            Optional target = this.getRequestCycle().find(AjaxRequestTarget.class);
            if (target.isPresent() && this.findPage() != null && this.jsInitialized) {
                ((AjaxRequestTarget)target.get()).appendJavaScript((CharSequence)this.getJSpanTo(center));
            }
        }
    }

    public void setMarkerCluster(GMarkerCluster markerCluster) {
        if (markerCluster == null) {
            throw new IllegalArgumentException("GMarkerCluster argument should not be null.");
        }
        this.markerCluster = markerCluster;
        if (this.getBehaviors(GMapMarkerClustererHeaderContributor.class).isEmpty()) {
            this.add(new Behavior[]{new GMapMarkerClustererHeaderContributor()});
        }
    }

    public boolean isMarkerClusterEnabled() {
        return this.markerCluster != null;
    }

    public String getJSinit() {
        StringBuilder js = new StringBuilder("new WicketMap('" + this.getMapId() + "', " + this.isFailSilently() + ");\n");
        js.append(this.getJSinvoke("clearOverlays()"));
        js.append(this.overlayListener.getJSinit());
        js.append(this.getJSsetCenter(this.getCenter()));
        js.append(this.getJSsetZoom(this.getZoom()));
        js.append(this.getJSsetMinZoom(this.getMinZoom()));
        js.append(this.getJSsetMaxZoom(this.getMaxZoom()));
        js.append(this.getJSfitBounds());
        js.append(this.getJSsetDraggingEnabled(this.draggingEnabled));
        js.append(this.getJSsetDoubleClickZoomEnabled(this.doubleClickZoomEnabled));
        js.append(this.getJSsetScrollWheelZoomEnabled(this.scrollWheelZoomEnabled));
        js.append(this.getJSsetStreetViewControlEnabled(this.streetViewControlEnabled));
        js.append(this.getJSsetZoomControlEnabled(this.zoomControlEnabled));
        js.append(this.getJSsetScaleControlEnabled(this.scaleControlEnabled));
        js.append(this.getJSsetMapTypeControlEnabled(this.mapTypeControlEnabled));
        js.append(this.getJSsetPanControlEnabled(this.panControlEnabled));
        js.append(this.getJSFitMarkers());
        js.append(this.mapType.getJSsetMapType(this));
        for (GOverlay overlay : this.overlays.values()) {
            js.append(overlay.getJS());
        }
        for (GOverlay behavior : this.getBehaviors(GEventListenerBehavior.class)) {
            js.append(((GEventListenerBehavior)((Object)behavior)).getJSaddListener());
        }
        js.append(this.getJSMarkerCluster());
        return js.toString();
    }

    public String getJSinvoke(String invocation) {
        return this.getJsReference() + "." + invocation + ";\n";
    }

    public String getJsReference() {
        return "Wicket.maps['" + this.getMapId() + "']";
    }

    public void fitMarkers(List<GLatLng> markersToShow) {
        this.fitMarkers(markersToShow, false, 0.0);
    }

    public void fitMarkers(List<GLatLng> markersToShow, boolean showMarkersForPoints) {
        this.fitMarkers(markersToShow, showMarkersForPoints, 0.0);
    }

    public void fitMarkers(List<GLatLng> markersToShow, boolean showMarkersForPoints, double zoomAdjustment) {
        this.markersToShow = markersToShow;
        if (showMarkersForPoints) {
            for (GLatLng location : markersToShow) {
                this.addOverlay(new GMarker(new GMarkerOptions(this, location)));
            }
        }
    }

    public String getJSFitMarkers(List<GLatLng> markers) {
        if (markers.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("var bounds = new google.maps.LatLngBounds();\n");
        for (GLatLng point : markers) {
            buf.append("bounds.extend( ").append(point.getJSconstructor()).append(" );\n");
        }
        buf.append(this.getJSinvoke("fitBounds(bounds)"));
        buf.append(this.getJSinvoke("panToBounds(bounds)"));
        return buf.toString();
    }

    private String getJSFitMarkers() {
        return this.getJSFitMarkers(this.markersToShow);
    }

    private String getJSsetDraggingEnabled(boolean enabled) {
        return this.getJSinvoke("setDraggingEnabled(" + enabled + ")");
    }

    private String getJSsetDoubleClickZoomEnabled(boolean enabled) {
        return this.getJSinvoke("setDoubleClickZoomEnabled(" + enabled + ")");
    }

    private String getJSsetScrollWheelZoomEnabled(boolean enabled) {
        return this.getJSinvoke("setScrollWheelZoomEnabled(" + enabled + ")");
    }

    private String getJSsetStreetViewControlEnabled(boolean enabled) {
        return this.getJSinvoke("setStreetViewControlEnabled(" + enabled + ")");
    }

    private String getJSsetZoomControlEnabled(boolean enabled) {
        return this.getJSinvoke("setZoomControlEnabled(" + enabled + ")");
    }

    private String getJSsetScaleControlEnabled(boolean enabled) {
        return this.getJSinvoke("setScaleControlEnabled(" + enabled + ")");
    }

    private String getJSsetMapTypeControlEnabled(boolean enabled) {
        return this.getJSinvoke("setMapTypeControlEnabled(" + enabled + ")");
    }

    private String getJSsetPanControlEnabled(boolean enabled) {
        return this.getJSinvoke("setPanControlEnabled(" + enabled + ")");
    }

    private String getJSsetZoom(int zoom) {
        return this.getJSinvoke("setZoom(" + zoom + ")");
    }

    private String getJSsetMinZoom(int minZoom) {
        return this.getJSinvoke("setMinZoom(" + minZoom + ")");
    }

    private String getJSsetMaxZoom(int maxZoom) {
        return this.getJSinvoke("setMaxZoom(" + maxZoom + ")");
    }

    private String getJSfitBounds() {
        if (null == this.bounds || Strings.isEmpty((String)this.bounds.getJSconstructor())) {
            return "";
        }
        return this.getJSinvoke("fitBounds(" + this.bounds.getJSconstructor() + ")");
    }

    private String getJSsetCenter(GLatLng center) {
        if (center != null) {
            if (!this.failSilently) {
                return this.getJSinvoke("setCenter(" + center.getJSconstructor() + ")");
            }
            return this.getJSinvoke("setCenterFailSafe(" + center.getArguments() + ")");
        }
        return "";
    }

    private String getJSpanDirection(int dx, int dy) {
        return this.getJSinvoke("panDirection(" + dx + "," + dy + ")");
    }

    private String getJSpanTo(GLatLng center) {
        return this.getJSinvoke("panTo(" + center.getJSconstructor() + ")");
    }

    private String getJSzoomOut() {
        return this.getJSinvoke("zoomOut()");
    }

    private String getJSzoomIn() {
        return this.getJSinvoke("zoomIn()");
    }

    private String getJSMarkerCluster() {
        if (this.markerCluster != null) {
            return this.markerCluster.getJSconstructor();
        }
        return "";
    }

    public void update() {
        IRequestParameters requestParameters = this.getRequest().getRequestParameters();
        this.bounds = GLatLngBounds.parse(requestParameters.getParameterValue("bounds").toString());
        this.center = GLatLng.parse(requestParameters.getParameterValue("center").toString());
        this.zoom = requestParameters.getParameterValue("zoom").toInt(this.zoom);
        String requestMapType = requestParameters.getParameterValue("currentMapType").toString();
        this.mapType = requestMapType != null ? GMapType.valueOf(requestParameters.getParameterValue("currentMapType").toString()) : this.mapType;
    }

    public void setOverlays(List<GOverlay> overlays) {
        this.removeAllOverlays();
        for (GOverlay overlay : overlays) {
            this.addOverlay(overlay);
        }
    }

    public boolean isFailSilently() {
        return this.failSilently;
    }

    public void setFailSilently(boolean failSilently) {
        this.failSilently = failSilently;
    }

    public class OverlayListener
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;

        protected void respond(AjaxRequestTarget target) {
            Request request = RequestCycle.get().getRequest();
            String overlayId = request.getRequestParameters().getParameterValue("overlay.overlayId").toString().replace("overlay", "");
            String event = request.getRequestParameters().getParameterValue("overlay.event").toString();
            GOverlay overlay = GMap.this.overlays.get(overlayId);
            if (overlay != null) {
                overlay.onEvent(target, GEvent.valueOf(event));
            }
        }

        public Object getJSinit() {
            return GMap.this.getJSinvoke("overlayListenerCallbackUrl = '" + this.getCallbackUrl() + "'");
        }
    }

    public class SetMapTypeBehavior
    extends JSMethodBehavior {
        private static final long serialVersionUID = 1L;
        private final GMapType mapTypeBehavior;

        public SetMapTypeBehavior(String event, GMapType mapType) {
            super(event);
            this.mapTypeBehavior = mapType;
        }

        @Override
        protected String getJSinvoke() {
            return this.mapTypeBehavior.getJSsetMapType(GMap.this);
        }
    }

    public class SetCenterBehavior
    extends JSMethodBehavior {
        private static final long serialVersionUID = 1L;
        private final GLatLng gLatLng;

        public SetCenterBehavior(String event, GLatLng gLatLng) {
            super(event);
            this.gLatLng = gLatLng;
        }

        @Override
        protected String getJSinvoke() {
            return GMap.this.getJSsetCenter(this.gLatLng);
        }
    }

    public class SetZoomBehavior
    extends JSMethodBehavior {
        private static final long serialVersionUID = 1L;
        private final int zoomBehavior;

        public SetZoomBehavior(String event, int zoom) {
            super(event);
            this.zoomBehavior = zoom;
        }

        @Override
        protected String getJSinvoke() {
            return GMap.this.getJSsetZoom(this.zoomBehavior);
        }
    }

    public class PanDirectionBehavior
    extends JSMethodBehavior {
        private static final long serialVersionUID = 1L;
        private final int dx;
        private final int dy;

        public PanDirectionBehavior(String event, int dx, int dy) {
            super(event);
            this.dx = dx;
            this.dy = dy;
        }

        @Override
        protected String getJSinvoke() {
            return GMap.this.getJSpanDirection(this.dx, this.dy);
        }
    }

    public class ZoomInBehavior
    extends JSMethodBehavior {
        private static final long serialVersionUID = 1L;

        public ZoomInBehavior(String event) {
            super(event);
        }

        @Override
        protected String getJSinvoke() {
            return GMap.this.getJSzoomIn();
        }
    }

    public class ZoomOutBehavior
    extends JSMethodBehavior {
        private static final long serialVersionUID = 1L;

        public ZoomOutBehavior(String event) {
            super(event);
        }

        @Override
        protected String getJSinvoke() {
            return GMap.this.getJSzoomOut();
        }
    }

    private static abstract class JSMethodBehavior
    extends Behavior {
        private static final long serialVersionUID = 1L;
        private final String attribute;

        public JSMethodBehavior(String attribute) {
            this.attribute = attribute;
        }

        public void onComponentTag(Component component, ComponentTag tag) {
            Object invoke = this.getJSinvoke();
            if (this.attribute.equalsIgnoreCase("href")) {
                invoke = "javascript:" + (String)invoke;
            }
            tag.put(this.attribute, (CharSequence)invoke);
        }

        protected abstract String getJSinvoke();
    }
}

