/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.gmap.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.StringTokenizer;
import org.wicketstuff.gmap.api.GValue;
import org.wicketstuff.gmap.js.Constructor;

public class GLatLng
implements GValue {
    private static final long serialVersionUID = 1L;
    private final double lat;
    private final double lng;
    private final boolean unbounded;

    @JsonCreator
    public GLatLng(@JsonProperty(value="lat") double lat, @JsonProperty(value="lng") double lng) {
        this(lat, lng, false);
    }

    public GLatLng(double lat, double lng, boolean unbounded) {
        this.lat = lat;
        this.lng = lng;
        this.unbounded = unbounded;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLng() {
        return this.lng;
    }

    public String toString() {
        return this.getJSconstructor();
    }

    @Override
    public String getJSconstructor() {
        return new Constructor("google.maps.LatLng").add(BigDecimal.valueOf(this.lat).toString()).add(BigDecimal.valueOf(this.lng).toString()).add(this.unbounded).toJS();
    }

    public String getArguments() {
        return BigDecimal.valueOf(this.lat).toString() + "," + BigDecimal.valueOf(this.lng).toString() + "," + Boolean.valueOf(this.unbounded);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.lat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.lng);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.unbounded ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GLatLng other = (GLatLng)obj;
        if (Double.doubleToLongBits(this.lat) != Double.doubleToLongBits(other.lat)) {
            return false;
        }
        if (Double.doubleToLongBits(this.lng) != Double.doubleToLongBits(other.lng)) {
            return false;
        }
        return this.unbounded == other.unbounded;
    }

    public static GLatLng parse(String value) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(value, "(, )");
            float lat = Float.valueOf(tokenizer.nextToken()).floatValue();
            float lng = Float.valueOf(tokenizer.nextToken()).floatValue();
            return new GLatLng(lat, lng);
        }
        catch (Exception e) {
            return null;
        }
    }
}

