/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.gmap.api;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Checks;
import org.wicketstuff.gmap.api.GEvent;
import org.wicketstuff.gmap.api.GLatLngBounds;
import org.wicketstuff.gmap.api.GOverlay;
import org.wicketstuff.gmap.js.ObjectLiteral;

public class GRectangle
extends GOverlay {
    private static final long serialVersionUID = 1L;
    private final GLatLngBounds bounds;
    private boolean clickable = true;
    private boolean draggable;
    private boolean editable;
    private final String fillColor;
    private final float fillOpacity;
    private final String strokeColor;
    private final float strokeOpacity;
    private final int strokeWeight;
    private boolean visible = true;
    private Integer zIndex;

    public GRectangle(GLatLngBounds bounds, String strokeColor, int strokeWeight, float strokeOpacity, String fillColor, float fillOpacity) {
        this.bounds = (GLatLngBounds)Args.notNull((Object)bounds, (String)"bounds");
        this.strokeColor = strokeColor;
        this.strokeWeight = strokeWeight;
        this.strokeOpacity = strokeOpacity;
        this.fillColor = fillColor;
        this.fillOpacity = fillOpacity;
    }

    @Override
    public String getJSconstructor() {
        return "new google.maps.Rectangle(" + this.getSettings().toJS() + ")";
    }

    private ObjectLiteral getSettings() {
        ObjectLiteral settings = new ObjectLiteral();
        settings.set("strokeWeight", String.valueOf(this.strokeWeight));
        settings.setString("strokeColor", this.strokeColor);
        settings.set("strokeOpacity", String.valueOf(this.strokeOpacity));
        settings.setString("fillColor", this.fillColor);
        settings.set("fillOpacity", String.valueOf(this.fillOpacity));
        settings.set("bounds", this.bounds.toString());
        if (!this.clickable) {
            settings.set("clickable", "false");
        }
        if (this.draggable) {
            settings.set("draggable", "true");
        }
        if (this.editable) {
            settings.set("editable", "true");
        }
        if (!this.visible) {
            settings.set("visible", "false");
        }
        if (this.zIndex != null) {
            settings.set("zIndex", String.valueOf(this.zIndex));
        }
        return settings;
    }

    @Override
    protected void updateOnAjaxCall(AjaxRequestTarget target, GEvent overlayEvent) {
    }

    public GRectangle setClickable(boolean clickable) {
        this.clickable = clickable;
        return this;
    }

    public GRectangle setDraggable(boolean draggable) {
        this.draggable = draggable;
        return this;
    }

    public GRectangle setEditable(boolean editable) {
        this.editable = editable;
        return this;
    }

    public GRectangle setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public GRectangle setZIndex(Integer zIndex) {
        if (zIndex != null) {
            Checks.withinRangeShort((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE), (Comparable)zIndex, (String)"zIndex");
        }
        this.zIndex = zIndex;
        return this;
    }
}

