/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.input.events;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.template.PackageTextTemplate;
import org.apache.wicket.util.template.TextTemplate;
import org.apache.wicket.util.value.IValueMap;
import wicket.contrib.input.events.EventType;
import wicket.contrib.input.events.key.KeyHookOn;
import wicket.contrib.input.events.key.KeyType;

public class InputBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private final ResourceReference SHORTCUTS_JAVASCRIPT = new PackageResourceReference(InputBehavior.class, "shortcut.js");
    private final KeyType[] keyCombo;
    private EventType eventType;
    private boolean autoHook = false;
    private boolean linkUnbound = false;
    private final TextTemplate shortcutJs = new PackageTextTemplate(InputBehavior.class, "wicket-contrib-input-behavior.js");
    private final TextTemplate shortcutJsAutoHook = new PackageTextTemplate(InputBehavior.class, "wicket-contrib-input-behavior-autohook.js");
    private final TextTemplate shortcutJsAutoHookLink = new PackageTextTemplate(InputBehavior.class, "wicket-contrib-input-behavior-autohook-link.js");
    private Component component;

    public InputBehavior(KeyType[] keyCombo, EventType eventType) {
        this.keyCombo = keyCombo;
        this.eventType = eventType;
    }

    public InputBehavior(KeyType[] keyCombo) {
        this.keyCombo = keyCombo;
        this.autoHook = true;
    }

    public void bind(Component component) {
        super.bind(component);
        this.component = component;
        component.setOutputMarkupId(true);
    }

    protected final String getEscapedComponentMarkupId() {
        return this.component.getMarkupId().replaceAll("\\W", "");
    }

    public void renderHead(Component c, IHeaderResponse response) {
        super.renderHead(c, response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)this.SHORTCUTS_JAVASCRIPT));
        if (!this.autoHook) {
            response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)this.generateString(this.shortcutJs)));
        }
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        if (this.autoHook) {
            IValueMap attribs = tag.getAttributes();
            for (String attrib : attribs.keySet()) {
                List<EventType> list = Arrays.asList(EventType.values());
                for (EventType e : list) {
                    if (!attrib.toLowerCase().contains(e.toString().toLowerCase())) continue;
                    this.eventType = e;
                }
            }
            if (component instanceof Link && this.eventType == null) {
                this.linkUnbound = true;
                return;
            }
        }
    }

    public void afterRender(Component component) {
        super.afterRender(component);
        if (this.autoHook) {
            Response response = component.getResponse();
            if (this.linkUnbound) {
                response.write((CharSequence)this.generateString(this.shortcutJsAutoHookLink));
            } else {
                response.write((CharSequence)this.generateString(this.shortcutJsAutoHook));
            }
        }
    }

    private String generateString(TextTemplate textTemplate) {
        HashMap<String, String> variables = new HashMap<String, String>();
        String widgetId = this.getEscapedComponentMarkupId();
        StringBuilder keyComboString = new StringBuilder();
        boolean first = true;
        for (KeyType keyType : this.keyCombo) {
            if (first) {
                first = false;
            } else {
                keyComboString.append('+');
            }
            keyComboString.append(keyType.getKeyCode());
        }
        if (this.eventType != null) {
            variables.put("event", this.eventType.toString());
        }
        variables.put("keys", keyComboString.toString());
        variables.put("wicketComponentId", widgetId);
        variables.put("disable_in_input", this.getDisable_in_input().toString());
        variables.put("type", this.getType().toString());
        variables.put("propagate", this.getPropagate().toString());
        variables.put("target", this.getTarget());
        textTemplate.interpolate(variables);
        return textTemplate.asString();
    }

    protected Boolean getDisable_in_input() {
        return false;
    }

    protected KeyHookOn getType() {
        return KeyHookOn.keydown;
    }

    protected Boolean getPropagate() {
        return false;
    }

    protected String getTarget() {
        return "document";
    }
}

