/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.behavior.tooltipsy;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.wicketstuff.minis.behavior.tooltipsy.TooltipsyOptions;

public class TooltipsyBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private static final String TOOLTIPSY_JS_FILENAME = "tooltipsy.js";
    private TooltipsyOptions options = new TooltipsyOptions();
    private String overrideSelector = "";

    public TooltipsyBehavior() {
    }

    public TooltipsyBehavior(TooltipsyOptions options) {
        this.options = new TooltipsyOptions(options);
    }

    public TooltipsyOptions getOptions() {
        return this.options;
    }

    public void setOptions(TooltipsyOptions options) {
        this.options = new TooltipsyOptions(options);
    }

    public void renderHead(Component component, IHeaderResponse response) {
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)Application.get().getJavaScriptLibrarySettings().getJQueryReference()));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new PackageResourceReference(((Object)((Object)this)).getClass(), TOOLTIPSY_JS_FILENAME)));
        if (component != null) {
            String selector = "#" + component.getMarkupId();
            if (!this.overrideSelector.equals("")) {
                selector = this.overrideSelector;
            }
            String javascript = "$('" + selector + "').tooltipsy(" + this.options.getParameterString() + ");";
            response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)javascript));
        }
    }

    public String getOverrideSelector() {
        return this.overrideSelector;
    }

    public void setOverrideSelector(String overrideSelector) {
        Args.notNull((Object)overrideSelector, (String)"overrideSelector");
        this.overrideSelector = overrideSelector;
    }
}

