/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.behavior.veil;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class VeilResources
extends Behavior {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference JS = new JavaScriptResourceReference(VeilResources.class, "wicket-veil.js");
    private static final ResourceReference CSS = new PackageResourceReference(VeilResources.class, "wicket-veil.css");
    public static final String DEFAULT_CSS_CLASS_NAME = "wicket-veil";

    public void bind(Component component) {
        super.bind(component);
        component.setOutputMarkupId(true);
    }

    public void renderHead(Component c, IHeaderResponse response) {
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JS));
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)CSS));
    }

    public static class Javascript {
        public static String hide(Component component) {
            return Generic.hide(component.getMarkupId());
        }

        public static String show(Component component) {
            return Generic.show(component.getMarkupId());
        }

        public static String show(Component component, String className) {
            return Generic.show(component.getMarkupId(), className);
        }

        public static String toggle(Component component) {
            return Generic.toggle(component.getMarkupId());
        }

        public static String toggle(Component component, String className) {
            return Generic.toggle(component.getMarkupId(), className);
        }

        private Javascript() {
        }

        public static class Generic {
            public static String hide(String markupId) {
                return "Wicket.Veil.toggle('" + markupId + "');";
            }

            public static String show(String markupId) {
                return Generic.show(markupId, VeilResources.DEFAULT_CSS_CLASS_NAME);
            }

            public static String show(String markupId, String className) {
                return "Wicket.Veil.show('" + markupId + "', {className:'" + className + "'});";
            }

            public static String toggle(String markupId) {
                return Generic.toggle(markupId, VeilResources.DEFAULT_CSS_CLASS_NAME);
            }

            public static String toggle(String markupId, String className) {
                return "Wicket.Veil.toggle('" + markupId + "', {className:'" + className + "'});";
            }

            private Generic() {
            }
        }
    }
}

