/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.protocol.ws.javax;

import java.net.URI;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.protocol.ws.javax.WicketEndpoint;

public class WicketServerEndpointConfig
implements ServerEndpointConfig {
    static final String WICKET_WEB_SOCKET_PATH = "/wicket/websocket";
    private final ServerEndpointConfig delegate = ServerEndpointConfig.Builder.create(WicketEndpoint.class, (String)"/wicket/websocket").build();
    private ServerEndpointConfig.Configurator configurator;

    public Class<?> getEndpointClass() {
        return this.delegate.getEndpointClass();
    }

    public String getPath() {
        return this.delegate.getPath();
    }

    public List<String> getSubprotocols() {
        return this.delegate.getSubprotocols();
    }

    public List<Extension> getExtensions() {
        return this.delegate.getExtensions();
    }

    public ServerEndpointConfig.Configurator getConfigurator() {
        if (this.configurator == null) {
            this.configurator = new JavaxWebSocketConfigurator(this.delegate.getConfigurator());
        }
        return this.configurator;
    }

    public List<Class<? extends Encoder>> getEncoders() {
        return this.delegate.getEncoders();
    }

    public List<Class<? extends Decoder>> getDecoders() {
        return this.delegate.getDecoders();
    }

    public Map<String, Object> getUserProperties() {
        return this.delegate.getUserProperties();
    }

    private static class JavaxWebSocketConfigurator
    extends ServerEndpointConfig.Configurator {
        private static final Logger LOG = LoggerFactory.getLogger(JavaxWebSocketConfigurator.class);
        private final ServerEndpointConfig.Configurator delegate;

        public JavaxWebSocketConfigurator(ServerEndpointConfig.Configurator delegate) {
            this.delegate = delegate;
        }

        public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
            this.delegate.modifyHandshake(sec, request, response);
            Map userProperties = sec.getUserProperties();
            Object httpSession = request.getHttpSession();
            LOG.trace("httpSession: {}", httpSession);
            if (httpSession != null) {
                userProperties.put("session", httpSession);
            }
            Map headers = request.getHeaders();
            LOG.trace("headers: {}", (Object)headers);
            if (headers != null) {
                userProperties.put("headers", headers);
            }
            Map parameterMap = request.getParameterMap();
            LOG.trace("parameterMap: {}", (Object)parameterMap);
            if (parameterMap != null) {
                userProperties.put("parameterMap", parameterMap);
            }
            String queryString = request.getQueryString();
            LOG.trace("queryString: {}", (Object)queryString);
            if (queryString != null) {
                userProperties.put("queryString", queryString);
            }
            URI requestURI = request.getRequestURI();
            LOG.trace("requestURI: {}", (Object)requestURI);
            if (requestURI != null) {
                userProperties.put("requestURI", requestURI);
            }
            Principal userPrincipal = request.getUserPrincipal();
            LOG.trace("userPrincipal: {}", (Object)userPrincipal);
            if (userPrincipal != null) {
                userProperties.put("userPrincipal", userPrincipal);
            }
        }

        public String getNegotiatedSubprotocol(List<String> supported, List<String> requested) {
            return this.delegate.getNegotiatedSubprotocol(supported, requested);
        }

        public List<Extension> getNegotiatedExtensions(List<Extension> installed, List<Extension> requested) {
            return this.delegate.getNegotiatedExtensions(installed, requested);
        }

        public boolean checkOrigin(String originHeaderValue) {
            return this.delegate.checkOrigin(originHeaderValue);
        }

        public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
            return (T)this.delegate.getEndpointInstance(endpointClass);
        }
    }
}

