/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.common.analyze.report;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.pageserializer.common.analyze.AbstractTreeTransformingProcessor;
import org.wicketstuff.pageserializer.common.analyze.ISerializedObjectTree;
import org.wicketstuff.pageserializer.common.analyze.ISerializedObjectTreeProcessor;
import org.wicketstuff.pageserializer.common.analyze.ImmutableTree;
import org.wicketstuff.pageserializer.common.analyze.report.TreeTypeMap;

public class SimilarNodeTreeTransformator
extends AbstractTreeTransformingProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SimilarNodeTreeTransformator.class);

    public SimilarNodeTreeTransformator(ISerializedObjectTreeProcessor parent) {
        super(parent);
    }

    @Override
    protected ISerializedObjectTree transform(ISerializedObjectTree tree) {
        return SimilarNodeTreeTransformator.transformTree(tree);
    }

    public static ISerializedObjectTree transformTree(ISerializedObjectTree tree) {
        ISerializedObjectTree ret = tree;
        if (!tree.children().isEmpty()) {
            ArrayList<ISerializedObjectTree> transformed = new ArrayList<ISerializedObjectTree>();
            for (ISerializedObjectTree iSerializedObjectTree : tree.children()) {
                transformed.add(SimilarNodeTreeTransformator.transformTree(iSerializedObjectTree));
            }
            TreeTypeMap typeMap = new TreeTypeMap(transformed);
            if (typeMap.hasLessEntries(transformed.size())) {
                List<ISerializedObjectTree> list = typeMap.compressedResult();
                ret = new ImmutableTree(ret.id(), ret.type(), ret.label(), ret.size(), list);
            } else if (!SimilarNodeTreeTransformator.sameEntries(tree.children(), transformed)) {
                ret = new ImmutableTree(ret.id(), ret.type(), ret.label(), ret.size(), transformed);
            }
        }
        return ret;
    }

    static <T> boolean sameEntries(List<? extends T> a, List<? extends T> b) {
        if (a.size() != b.size()) {
            return false;
        }
        int s = a.size();
        for (int i = 0; i < s; ++i) {
            if (a.get(i) == b.get(i)) continue;
            return false;
        }
        return true;
    }
}

