/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.common.analyze.report;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.pageserializer.common.analyze.ISerializedObjectTree;
import org.wicketstuff.pageserializer.common.analyze.ISerializedObjectTreeProcessor;
import org.wicketstuff.pageserializer.common.analyze.report.IReportOutput;
import org.wicketstuff.pageserializer.common.analyze.report.IReportRenderer;
import org.wicketstuff.pageserializer.common.analyze.reportbuilder.AttributeBuilder;
import org.wicketstuff.pageserializer.common.analyze.reportbuilder.Column;
import org.wicketstuff.pageserializer.common.analyze.reportbuilder.Report;

public class TreeSizeReport
implements ISerializedObjectTreeProcessor {
    static final Column emptyFirst = new Column("", new AttributeBuilder().set(Column.Separator, "|").build());
    static final Column id = new Column("#", new AttributeBuilder().set(Column.Align.Right).set(Column.FillBefore, Character.valueOf(' ')).set(Column.Separator, "| ").build());
    static final Column label = new Column("Type", new AttributeBuilder().set(Column.FillAfter, Character.valueOf(' ')).set(Column.Separator, "|").set(Column.Indent, "  ").build());
    static final Column percent = new Column("", new AttributeBuilder().set(Column.Align.Right).set(Column.FillBefore, Character.valueOf(' ')).set(Column.Separator, "%| ").build());
    static final Column sum = new Column("sum", new AttributeBuilder().set(Column.Align.Right).set(Column.FillBefore, Character.valueOf(' ')).set(Column.Separator, "| ").build());
    static final Column local = new Column("local", new AttributeBuilder().set(Column.Align.Right).set(Column.FillBefore, Character.valueOf(' ')).set(Column.Separator, "| ").build());
    static final Column child = new Column("child", new AttributeBuilder().set(Column.Align.Right).set(Column.FillBefore, Character.valueOf(' ')).set(Column.Separator, "|").build());
    private static final Logger LOG = LoggerFactory.getLogger(TreeSizeReport.class);
    private final IReportOutput reportOutput;

    public TreeSizeReport(IReportOutput reportOutput) {
        this.reportOutput = reportOutput;
    }

    @Override
    public void process(ISerializedObjectTree tree) {
        this.reportOutput.write(tree, new IReportRenderer(){

            @Override
            public String render(ISerializedObjectTree tree) {
                Report report = new Report("TreeSizeReport\n");
                TreeSizeReport.this.process(tree, report, 0, tree.size() + tree.childSize());
                String result = report.export(emptyFirst, id, percent, sum, local, child, label).separateColumnNamesWith('-').tableBorderWith('=').asString();
                return result;
            }
        });
    }

    private void process(ISerializedObjectTree tree, Report report, int indent, int allSize) {
        Report.Row row = report.newRow();
        row.set(id, 0, "" + tree.id());
        row.set(label, indent, this.label(tree));
        row.set(percent, 0, "" + (tree.size() + tree.childSize()) * 100 / allSize);
        row.set(sum, 0, "" + (tree.size() + tree.childSize()));
        row.set(local, 0, "" + tree.size());
        row.set(child, 0, "" + tree.childSize());
        for (ISerializedObjectTree iSerializedObjectTree : this.preProcess(tree.children())) {
            this.process(iSerializedObjectTree, report, indent + 1, allSize);
        }
    }

    protected List<? extends ISerializedObjectTree> preProcess(List<? extends ISerializedObjectTree> children) {
        return children;
    }

    private String label(ISerializedObjectTree tree) {
        return (tree.type().isAnonymousClass() ? tree.type().getSuperclass().getName() : tree.type().getName()) + (tree.label() != null ? "(" + tree.label() + ")" : "");
    }
}

