/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.common.analyze.report;

import org.wicketstuff.pageserializer.common.analyze.AbstractTreeTransformingProcessor;
import org.wicketstuff.pageserializer.common.analyze.ISerializedObjectTree;
import org.wicketstuff.pageserializer.common.analyze.ISerializedObjectTreeProcessor;
import org.wicketstuff.pageserializer.common.analyze.report.Level;
import org.wicketstuff.pageserializer.common.analyze.report.TreeTransformations;
import org.wicketstuff.pageserializer.common.analyze.report.filter.ITreeFilter;

public class TreeTransformator
extends AbstractTreeTransformingProcessor {
    private final IFilter[] filter;

    public TreeTransformator(ISerializedObjectTreeProcessor destination, IFilter ... filter) {
        super(destination);
        this.filter = filter;
    }

    @Override
    protected ISerializedObjectTree transform(ISerializedObjectTree tree) {
        ISerializedObjectTree current = tree;
        block4: for (IFilter f : this.filter) {
            switch (f.filterType()) {
                case COMPACT: {
                    current = TreeTransformations.compact(current, f);
                    continue block4;
                }
                case STRIP: {
                    current = TreeTransformations.strip(current, f);
                }
            }
        }
        return current;
    }

    public static IFilter strip(ITreeFilter filter) {
        return new Filter(FilterType.STRIP, filter);
    }

    public static IFilter compact(ITreeFilter filter) {
        return new Filter(FilterType.COMPACT, filter);
    }

    static class Filter
    implements IFilter {
        private final ITreeFilter filter;
        private final FilterType type;

        public Filter(FilterType type, ITreeFilter filter) {
            this.type = type;
            this.filter = filter;
        }

        @Override
        public boolean accept(ISerializedObjectTree source, Level current) {
            return this.filter.accept(source, current);
        }

        @Override
        public FilterType filterType() {
            return this.type;
        }
    }

    public static interface IFilter
    extends ITreeFilter {
        public FilterType filterType();
    }

    public static enum FilterType {
        COMPACT,
        STRIP;

    }
}

