/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.common.analyze.report.io;

import org.wicketstuff.pageserializer.common.analyze.ISerializedObjectTree;
import org.wicketstuff.pageserializer.common.analyze.report.io.IReportKeyGenerator;

public class JoiningKeyGenerator
implements IReportKeyGenerator {
    private final String _separator;
    private final IReportKeyGenerator[] _generator;

    public JoiningKeyGenerator(String separator, IReportKeyGenerator ... generator) {
        this._separator = separator;
        this._generator = generator;
    }

    @Override
    public String keyOf(ISerializedObjectTree tree) {
        StringBuilder sb = new StringBuilder();
        boolean addSeparator = false;
        for (IReportKeyGenerator g : this._generator) {
            if (addSeparator) {
                sb.append("-");
            }
            addSeparator = true;
            String key = g.keyOf(tree);
            sb.append(key);
        }
        return sb.toString();
    }
}

