/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.common.analyze.reportbuilder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wicketstuff.pageserializer.common.analyze.reportbuilder.Column;
import org.wicketstuff.pageserializer.common.analyze.reportbuilder.IAttributes;

public class Report {
    private final List<Row> rows = new ArrayList<Row>();
    private final String title;

    public Report() {
        this(null);
    }

    public Report(String title) {
        this.title = title;
    }

    public Row newRow() {
        Row ret = new Row();
        this.rows.add(ret);
        return ret;
    }

    protected Integer width(Column c, int indentLen) {
        int width = 0;
        for (Row row : this.rows) {
            Row.RowColumnValue rcv = row.get(c);
            width = Math.max(width, rcv != null ? rcv.width(indentLen) : 0);
        }
        return width;
    }

    public Export export(Column ... columns) {
        return new Export(this, columns);
    }

    public static class Export {
        private final Column[] columns;
        private final Report report;
        boolean showColumnNames = true;
        Character columnNamesSeparator = null;
        Character tableBorder = null;

        public Export(Report report, Column ... columns) {
            this.report = report;
            this.columns = columns;
        }

        public Export hideColumnNames() {
            this.showColumnNames = false;
            return this;
        }

        public Export separateColumnNamesWith(char separator) {
            this.columnNamesSeparator = Character.valueOf(separator);
            return this;
        }

        public Export tableBorderWith(char separator) {
            this.tableBorder = Character.valueOf(separator);
            return this;
        }

        public String asString() {
            HashMap<Column, Integer> columnWidth = new HashMap<Column, Integer>();
            for (Column c : this.columns) {
                String indent = c.attributes().get(Column.Indent, null);
                int indentLen = indent != null ? indent.length() : 0;
                columnWidth.put(c, Math.max(this.showColumnNames ? c.name.length() : 0, this.report.width(c, indentLen)));
            }
            StringBuilder sb = new StringBuilder();
            if (this.report.title != null) {
                sb.append(this.report.title);
            }
            if (this.tableBorder != null) {
                this.lineSeparator(sb, columnWidth, this.tableBorder.charValue());
            }
            if (this.showColumnNames) {
                for (Column c : this.columns) {
                    this.append(sb, (Integer)columnWidth.get(c), 0, c.name, c.attributes());
                    sb.append(c.attributes().get(Column.Separator, ","));
                }
                sb.append("\n");
                if (this.columnNamesSeparator != null) {
                    this.lineSeparator(sb, columnWidth, this.columnNamesSeparator.charValue());
                }
            }
            for (Row r : this.report.rows) {
                for (Column c : this.columns) {
                    Row.RowColumnValue rcv = r.get(c);
                    String value = rcv != null ? rcv.value() : null;
                    int indent = rcv != null ? rcv.indent() : 0;
                    this.append(sb, (Integer)columnWidth.get(c), indent, value, c.attributes());
                    sb.append(c.attributes().get(Column.Separator, ","));
                }
                sb.append("\n");
            }
            if (this.tableBorder != null) {
                this.lineSeparator(sb, columnWidth, this.tableBorder.charValue());
            }
            return sb.toString();
        }

        private void lineSeparator(StringBuilder sb, Map<Column, Integer> columnWidth, char separator) {
            for (Column c : this.columns) {
                this.fill(sb, (int)columnWidth.get(c), separator);
                this.fill(sb, c.attributes().get(Column.Separator, ",").length(), separator);
            }
            sb.append("\n");
        }

        private void append(StringBuilder sb, int width, int indent, String value, IAttributes attributes) {
            if (value == null) {
                value = "";
            }
            String indentValue = attributes.get(Column.Indent, "");
            switch (attributes.get(Column.Align.Left)) {
                case Right: {
                    this.fill(sb, width - value.length() - indentValue.length() * indent, attributes.get(Column.FillBefore, Character.valueOf(' ')).charValue());
                    sb.append(value);
                    this.fill(sb, indent, indentValue);
                    break;
                }
                default: {
                    this.fill(sb, indent, indentValue);
                    sb.append(value);
                    this.fill(sb, width - value.length() - indentValue.length() * indent, attributes.get(Column.FillAfter, Character.valueOf(' ')).charValue());
                }
            }
        }

        private void fill(StringBuilder sb, int count, String s) {
            for (int i = 0; i < count; ++i) {
                sb.append(s);
            }
        }

        private void fill(StringBuilder sb, int count, char c) {
            if (count < 10) {
                for (int i = 0; i < count; ++i) {
                    sb.append(c);
                }
            } else {
                char[] buffer = new char[count];
                for (int i = 0; i < count; ++i) {
                    buffer[i] = c;
                }
                sb.append(buffer);
            }
        }
    }

    public static class Row {
        Map<Column, RowColumnValue> values = new HashMap<Column, RowColumnValue>();

        public Row set(Column column, int indent, String value) {
            if (value != null) {
                this.values.put(column, new RowColumnValue(indent, value));
            }
            return this;
        }

        public RowColumnValue get(Column c) {
            return this.values.get(c);
        }

        static class RowColumnValue {
            private final int indent;
            private final String value;

            public RowColumnValue(int indent, String value) {
                this.indent = indent;
                this.value = value;
            }

            public int indent() {
                return this.indent;
            }

            public String value() {
                return this.value;
            }

            public int width(int indentLen) {
                return this.value.length() + indentLen * this.indent;
            }
        }
    }
}

