/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.common.listener;

import org.wicketstuff.pageserializer.common.listener.ISerializationListener;

public final class SerializationListeners {
    private SerializationListeners() {
    }

    public static ISerializationListener listOf(final ISerializationListener ... listener) {
        return new ISerializationListener(){

            @Override
            public void begin(Object object) {
                for (ISerializationListener l : listener) {
                    l.begin(object);
                }
            }

            @Override
            public void before(int position, Object object) {
                for (ISerializationListener l : listener) {
                    l.before(position, object);
                }
            }

            @Override
            public void after(int position, Object object) {
                for (ISerializationListener l : listener) {
                    l.after(position, object);
                }
            }

            @Override
            public void end(Object object, Exception exceptionIfAny) {
                for (ISerializationListener l : listener) {
                    l.end(object, exceptionIfAny);
                }
            }
        };
    }
}

