/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.codesource;

import japa.parser.JavaParser;
import japa.parser.ParseException;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.Node;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.JavadocComment;
import japa.parser.ast.body.TypeDeclaration;
import japa.parser.ast.visitor.GenericVisitor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.wikbook.codesource.CodeSource;
import org.wikbook.codesource.CompilationUnitVisitor;
import org.wikbook.codesource.Signature;
import org.wikbook.codesource.TypeSource;
import org.wikbook.text.Position;
import org.wikbook.text.TextArea;

abstract class Visit {
    Visit() {
    }

    abstract CU getCU();

    abstract void appendPathPrefix(StringBuilder var1);

    abstract void appendFQNPrefix(StringBuilder var1);

    final String clip(Node node) {
        CU cu = this.getCU();
        int from = cu.sb.offset(Position.get(node.getBeginLine() - 1, 0));
        int to = cu.sb.offset(Position.get(node.getEndLine() - 1, node.getEndColumn()));
        return cu.source.substring(from, to);
    }

    final String javaDoc(BodyDeclaration node) {
        JavadocComment doc = node.getJavaDoc();
        return doc != null ? this.clip((Node)doc) : null;
    }

    final String getPkg() {
        return this.getCU().pkg;
    }

    final void accept(CompilationUnitVisitor visitor) {
        this.getCU().compilationUnit.accept((GenericVisitor)visitor, (Object)this);
    }

    static class TD
    extends Visit {
        final Visit parent;
        final LinkedList<LinkedList<CodeSource>> stack = new LinkedList();
        Iterator<Signature> constructorSignatures;
        Iterator<Signature> methodSignatures;
        final TypeDeclaration decl;

        TD(Visit parent, TypeDeclaration decl) {
            this.parent = parent;
            this.decl = decl;
        }

        String getPath() {
            StringBuilder path = new StringBuilder();
            this.parent.appendPathPrefix(path);
            path.append(this.decl.getName());
            path.append(".class");
            return path.toString();
        }

        String getFQN() {
            StringBuilder fqn = new StringBuilder();
            this.parent.appendFQNPrefix(fqn);
            fqn.append(this.decl.getName());
            return fqn.toString();
        }

        void appendPathPrefix(StringBuilder path) {
            this.parent.appendPathPrefix(path);
            path.append(this.decl.getName());
            path.append('$');
        }

        void appendFQNPrefix(StringBuilder path) {
            this.parent.appendFQNPrefix(path);
            path.append(this.decl.getName());
            path.append('.');
        }

        CU getCU() {
            return this.parent.getCU();
        }
    }

    static class CU
    extends Visit {
        private final CompilationUnit compilationUnit;
        final String source;
        private final TextArea sb;
        String pkg;
        final List<TypeSource> types;

        CU(String source) throws ParseException {
            this.compilationUnit = JavaParser.parse((InputStream)new ByteArrayInputStream(source.getBytes()));
            this.source = source;
            this.sb = new TextArea(source);
            this.types = new ArrayList<TypeSource>();
        }

        void appendPathPrefix(StringBuilder path) {
            if (this.pkg.length() > 0) {
                path.append(this.pkg.replace('.', '/')).append('/');
            }
        }

        void appendFQNPrefix(StringBuilder path) {
            if (this.pkg.length() > 0) {
                path.append(this.pkg).append('.');
            }
        }

        CU getCU() {
            return this;
        }
    }
}

