/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.model;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import org.wikbook.core.ResourceType;
import org.wikbook.core.ValidationMode;
import org.wikbook.core.WikbookValidationException;
import org.wikbook.core.model.DocbookBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocbookBuilderContext {
    public final void onValidationError(String msg) {
        this.onValidationError(msg, null);
    }

    public final void onValidationError(Throwable t) {
        this.onValidationError(t.getMessage(), t);
    }

    public final void onValidationError(String msg, Throwable t) {
        if (this.getValidationMode() == ValidationMode.STRICT) {
            throw new WikbookValidationException(msg, t);
        }
        this.log("Validation error:" + msg);
    }

    public final URL resolveResource(ResourceType type, String id) throws IOException {
        List<URL> found = this.resolveResources(type, id);
        return found.isEmpty() ? null : found.get(0);
    }

    public abstract boolean getHighlightCode();

    public abstract ValidationMode getValidationMode();

    public abstract void log(String var1);

    public abstract List<URL> resolveResources(ResourceType var1, String var2) throws IOException;

    public abstract String getProperty(String var1);

    public abstract void build(Reader var1, String var2, DocbookBuilder var3);
}

