/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.wikbook.core.model.DocbookElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementContainer<E extends DocbookElement>
implements Iterable<E> {
    protected final LinkedList<E> elements = new LinkedList();
    private final Class<E> elementType;

    public ElementContainer(Class<E> elementType) {
        this.elementType = elementType;
    }

    @Override
    public Iterator<E> iterator() {
        return this.elements.iterator();
    }

    public Iterator<E> reverseIterator() {
        final ListIterator<E> delegate = this.elements.listIterator(this.elements.size());
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return delegate.hasPrevious();
            }

            @Override
            public E next() {
                return (DocbookElement)delegate.previous();
            }

            @Override
            public void remove() {
                delegate.remove();
            }
        };
    }

    public Iterable<E> iterator(int from, int to) {
        return new ArrayList<E>(this.elements).subList(from, to);
    }

    public Class<E> getElementType() {
        return this.elementType;
    }

    public boolean isNotEmpty() {
        return !this.elements.isEmpty();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public E peekFirst() {
        return (E)((DocbookElement)this.elements.peekFirst());
    }

    public E getLast() {
        return (E)((DocbookElement)this.elements.getLast());
    }

    public int getSize() {
        return this.elements.size();
    }

    public boolean append(DocbookElement elt) {
        if (this.elementType.isInstance(elt)) {
            this.elements.add(this.elementType.cast(elt));
            return true;
        }
        return false;
    }
}

