/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.render.docbook.content.block.table;

import java.util.Arrays;
import org.wikbook.core.model.content.block.table.TableCellElement;
import org.wikbook.core.model.content.block.table.TableElement;
import org.wikbook.core.model.content.block.table.TableRowElement;
import org.wikbook.core.render.docbook.ElementTransformer;
import org.wikbook.core.xml.ElementEmitter;
import org.wikbook.core.xml.XMLEmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableTransformer
extends ElementTransformer<TableElement> {
    @Override
    public void write(TableElement element, XMLEmitter emitter) {
        ElementEmitter tableXML;
        if (element.getTitle() != null) {
            tableXML = emitter.element("table");
            ((XMLEmitter)tableXML).element("caption").content(element.getTitle());
        } else {
            tableXML = emitter.element("informaltable");
        }
        int maxColumn = element.getColumnMaxSize();
        Iterable<TableRowElement> header = element.getHeaders();
        Iterable<TableRowElement> footer = element.getFooters();
        Iterable<TableRowElement> body = element.getBody();
        ElementEmitter tgroup = tableXML;
        for (Iterable a : Arrays.asList(header, body, footer)) {
            boolean head;
            ElementEmitter elementXML;
            if (!a.iterator().hasNext()) continue;
            if (a == header) {
                elementXML = tgroup.element("thead");
                head = true;
            } else if (a == body) {
                elementXML = tgroup.element("tbody");
                head = false;
            } else {
                elementXML = tgroup.element("tfoot");
                head = false;
            }
            for (TableRowElement row : a) {
                ElementEmitter rowXML = elementXML.element("tr");
                if (row.getVAlign() != null) {
                    rowXML.withAttribute("valign", row.getVAlign().toString().toLowerCase());
                }
                for (TableCellElement cell : row.getCells()) {
                    ElementEmitter entryXML = rowXML.element(head ? "th" : "td");
                    if (cell.getAlign() != null) {
                        entryXML.withAttribute("align", cell.getAlign().toString().toLowerCase());
                    }
                    if (cell.getVAlign() != null) {
                        entryXML.withAttribute("valign", cell.getVAlign().toString().toLowerCase());
                    }
                    TableTransformer.getWriter(cell).write(cell, entryXML);
                }
            }
        }
    }
}

