/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Person {
    private final String firstName;
    private final String lastName;
    private final String email;
    private final String organization;
    private final Set<String> roles;

    public Person(String firstName, String lastName, String email, String organization, String ... roleNames) {
        this(firstName, lastName, email, organization, new HashSet<String>(Arrays.asList(roleNames)));
    }

    public Person(String firstName, String lastName, String email, String organization, Set<String> roleNames) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.organization = organization;
        this.roles = new HashSet<String>(roleNames);
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getOrganization() {
        return this.organization;
    }

    public boolean hasRole(String roleName) {
        return this.roles.contains(roleName);
    }

    public String toString() {
        return "Person[firstName=" + this.firstName + ",lastName=" + this.lastName + ",email=" + this.email + ",organization=" + this.organization + "]";
    }
}

