/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.wiki;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.wikbook.ResourceType;
import org.wikbook.Utils;
import org.wikbook.WikbookException;
import org.wikbook.WikletContext;
import org.wikbook.wiki.Substitution;
import org.xwiki.component.embed.EmbeddableComponentManager;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.HeaderBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.SectionBlock;
import org.xwiki.rendering.block.VerbatimBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiLoader {
    private final WikletContext context;
    private final EmbeddableComponentManager ecm;

    public WikiLoader(WikletContext context) throws WikbookException {
        EmbeddableComponentManager ecm = new EmbeddableComponentManager();
        ecm.initialize(Thread.currentThread().getContextClassLoader());
        this.context = context;
        this.ecm = ecm;
    }

    public XDOM load(String id, String syntaxId) throws WikbookException {
        return this.load(id, syntaxId, 0);
    }

    public XDOM load(Reader reader, String syntaxId) throws WikbookException {
        return this.load(reader, syntaxId, 0);
    }

    private XDOM load(String id, String syntaxId, int baseLevel) throws WikbookException {
        try {
            Reader reader = this._load(id);
            return this.load(reader, syntaxId, baseLevel);
        }
        catch (IOException e) {
            throw new WikbookException(e);
        }
    }

    private XDOM load(Reader reader, String syntaxId, int baseLevel) throws WikbookException {
        try {
            XDOM xdom;
            if (syntaxId == null) {
                syntaxId = Syntax.XWIKI_2_0.toIdString();
            }
            if ("verbatim".equals(syntaxId)) {
                xdom = new XDOM(new ArrayList());
                xdom.addChild((Block)new VerbatimBlock(Utils.read(reader), false));
            } else {
                List<Substitution> substitutions;
                Parser parser = (Parser)this.ecm.lookup(Parser.class, syntaxId);
                xdom = parser.parse(reader);
                if (baseLevel > 0) {
                    for (HeaderBlock header : xdom.getChildrenByType(HeaderBlock.class, true)) {
                        int l = baseLevel + header.getLevel().getAsInt();
                        HeaderBlock nheader = new HeaderBlock(header.getChildren(), HeaderLevel.parseInt((int)l), header.getParameters(), header.getId());
                        header.getParent().replaceChild((Block)nheader, (Block)header);
                    }
                }
                if ((substitutions = this.visit((Block)xdom)).size() > 0) {
                    for (Substitution substitution : substitutions) {
                        substitution.src.getParent().replaceChild(substitution.dst, substitution.src);
                    }
                    DefaultWikiPrinter printer = new DefaultWikiPrinter();
                    BlockRenderer renderer = (BlockRenderer)this.ecm.lookup(BlockRenderer.class, Syntax.XWIKI_2_0.toIdString());
                    renderer.render((Block)xdom, (WikiPrinter)printer);
                    xdom = parser.parse((Reader)new StringReader(printer.toString()));
                }
            }
            return xdom;
        }
        catch (IOException e) {
            throw new WikbookException(e);
        }
        catch (ComponentLookupException e) {
            throw new WikbookException(e);
        }
        catch (ParseException e) {
            throw new WikbookException(e);
        }
    }

    private Reader _load(String id) throws IOException {
        URL main = this.context.resolveResource(ResourceType.WIKI, id);
        return Utils.read(main);
    }

    private List<Substitution> visit(Block block) {
        return this.visit(block, 0);
    }

    private List<Substitution> visit(Block block, int level) {
        if (block instanceof MacroBlock) {
            String value;
            String name;
            MacroBlock macro = (MacroBlock)block;
            String id = macro.getId();
            if ("include".equals(id)) {
                String includedId = macro.getParameter("document");
                String syntax = macro.getParameter("syntax");
                LinkedList<Substitution> list = new LinkedList<Substitution>();
                list.add(new Substitution(block, this.load(includedId, syntax, level)));
                return list;
            }
            if (id.startsWith("property.") && (name = id.substring("property.".length())) != null && (value = this.context.getProperty(name)) != null) {
                LinkedList<Substitution> list = new LinkedList<Substitution>();
                list.add(new Substitution(block, (Block)new WordBlock(value)));
                return list;
            }
        } else if (block instanceof SectionBlock) {
            ++level;
        }
        LinkedList<Substitution> substitutions = new LinkedList<Substitution>();
        for (Block child : block.getChildren()) {
            List<Substitution> childSubstitutions = this.visit(child, level);
            if (childSubstitutions.size() <= 0) continue;
            substitutions.addAll(childSubstitutions);
        }
        return substitutions;
    }
}

