/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.wikbook.core.Person;
import org.wikbook.core.ResourceType;
import org.wikbook.core.WikletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleWikletContext
implements WikletContext {
    private final File base;
    private final Map<String, Person> persons;
    private final Map<String, String> properties;

    public SimpleWikletContext(File base) {
        if (base == null) {
            throw new NullPointerException("No null base directory accepted");
        }
        this.base = base;
        this.persons = new LinkedHashMap<String, Person>();
        this.properties = new HashMap<String, String>();
    }

    @Override
    public String getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public void setProperty(String propertyName, String propertyValue) {
        if (this.properties != null) {
            this.properties.put(propertyName, propertyValue);
        } else {
            this.properties.remove(propertyName);
        }
    }

    public void removeProperty(String propertyName) {
        this.setProperty(propertyName, null);
    }

    public void addPerson(String authorId, Person author) {
        this.persons.put(authorId, author);
    }

    @Override
    public List<Person> findPersonsByRole(String roleName) {
        ArrayList<Person> ps = new ArrayList<Person>();
        for (Person p : this.persons.values()) {
            if (!p.hasRole(roleName)) continue;
            ps.add(p);
        }
        return ps;
    }

    @Override
    public List<URL> resolveResources(ResourceType type, String id) throws IOException {
        switch (type) {
            case WIKI: {
                File resolved = new File(this.base, id);
                if (resolved == null || !resolved.isFile()) break;
                return Arrays.asList(resolved.toURI().toURL());
            }
            case JAVA: {
                Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(id);
                ArrayList<URL> streams = new ArrayList<URL>();
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    streams.add(url);
                }
                return streams;
            }
            default: {
                throw new AssertionError();
            }
        }
        return null;
    }

    @Override
    public URL resolveResource(ResourceType type, String id) throws IOException {
        List<URL> urls = this.resolveResources(type, id);
        return urls.isEmpty() ? null : urls.get(0);
    }
}

