/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.template.freemarker;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import javax.annotation.processing.Filer;
import org.wikbook.template.freemarker.FilerTemplateLoader;
import org.wikbook.template.freemarker.FreemarkerModelBuilder;
import org.wikbook.template.processing.metamodel.MetaModel;
import org.wikbook.template.processing.metamodel.TemplateElement;

public class FreemarkerRenderer {
    private FreemarkerModelBuilder builder = new FreemarkerModelBuilder();

    public void render(MetaModel model, String templateName, TemplateElement element, OutputStream os, Filer filer) throws IOException {
        Map<String, Object> data = this.builder.build(model, element);
        Configuration cfg = new Configuration();
        try {
            cfg.setTemplateLoader((TemplateLoader)new FilerTemplateLoader(filer));
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            Template temp = cfg.getTemplate(templateName);
            OutputStreamWriter osw = new OutputStreamWriter(os);
            temp.process(data, (Writer)osw);
            osw.flush();
            osw.close();
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }
}

