/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.template.processing.metamodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wikbook.template.processing.metamodel.TemplateAnnotation;
import org.wikbook.template.processing.metamodel.TemplateType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateElement
implements Serializable {
    private String name;
    private TemplateType type;
    private Map<String, TemplateAnnotation> annotations;
    private List<TemplateElement> elements;
    private Map<String, List<List<String>>> javadoc;

    public TemplateElement(String name) {
        this.name = name;
        this.annotations = new HashMap<String, TemplateAnnotation>();
        this.elements = new ArrayList<TemplateElement>();
        this.javadoc = new HashMap<String, List<List<String>>>();
    }

    public TemplateElement(String name, TemplateType type) {
        this(name);
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public TemplateType getType() {
        return this.type;
    }

    public void addAnnotation(TemplateAnnotation annotation) {
        this.annotations.put(annotation.getName(), annotation);
    }

    public TemplateAnnotation getAnnotation(String name) {
        return this.annotations.get(name);
    }

    public Map<String, TemplateAnnotation> getAnnotations() {
        return this.annotations;
    }

    public void addElement(TemplateElement element) {
        this.elements.add(element);
    }

    public List<TemplateElement> getElements() {
        return this.elements;
    }

    public void addJavadoc(String name, List<List<String>> value) {
        this.javadoc.put(name, value);
    }

    public Map<String, List<List<String>>> getJavadoc() {
        return this.javadoc;
    }

    public List<List<String>> getJavadoc(String name) {
        List<List<String>> got = this.javadoc.get(name);
        if (got == null) {
            got = new ArrayList<List<String>>();
            this.javadoc.put(name, got);
        }
        return got;
    }
}

